/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.BindProps;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Import;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Managed;
import org.noear.solon.annotation.ManagedToBeanAnno;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Remoting;
import org.noear.solon.annotation.To;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanContainer;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.FactoryManager;
import org.noear.solon.core.InjectGather;
import org.noear.solon.core.Lifecycle;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.core.convert.ConverterFactory;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.core.handle.ActionExecuteHandler;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.EntityConverter;
import org.noear.solon.core.handle.EntityConverterFromExecutor;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodArgumentResolver;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.RenderFactory;
import org.noear.solon.core.handle.ReturnValueHandler;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.serialize.Serializer;
import org.noear.solon.core.util.Assert;
import org.noear.solon.core.util.BiConsumerEx;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.ConditionUtil;
import org.noear.solon.core.util.ConsumerEx;
import org.noear.solon.core.util.GenericUtil;
import org.noear.solon.core.util.IndexUtil;
import org.noear.solon.core.util.ProxyBinder;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.core.util.ScanUtil;
import org.noear.solon.core.util.SnelUtil;
import org.noear.solon.core.util.TypeMap;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.ConstructorWrap;
import org.noear.solon.core.wrap.FieldWrap;
import org.noear.solon.core.wrap.MethodKey;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.core.wrap.VarHolderOfParam;
import org.noear.solon.lang.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppContext
extends BeanContainer {
    static final Logger log = LoggerFactory.getLogger(AppContext.class);
    private final Set<RankEntity<Lifecycle>> lifecycleBeans = new HashSet<RankEntity<Lifecycle>>();
    private final Map<MethodKey, MethodWrap> methodCached = new HashMap<MethodKey, MethodWrap>();
    private final Set<Class<?>> beanBuildedCached = new HashSet();
    private final Set<InjectGather> gatherSet = new HashSet<InjectGather>();
    private static final int build_bean_ofclass_state0 = 0;
    private static final int build_bean_ofclass_state1 = 1;
    private static final int build_bean_ofclass_state2 = 2;
    private boolean starting;
    private boolean started;

    public AppContext() {
        this(new Props());
    }

    public AppContext(Props props) {
        this(Thread.currentThread().getContextClassLoader(), props);
    }

    public AppContext(ClassLoader classLoader, Props props) {
        this(Solon.app(), classLoader, props);
    }

    public AppContext(SolonApp app, ClassLoader classLoader, Props props) {
        super(app, classLoader, props);
        this.initialize();
        this.lifecycle(-95, () -> this.startInjectReview(0));
        this.lifecycle(-96, () -> this.startInjectReview(1));
    }

    public <T> AppContext onEvent(Class<T> type, EventListener<T> handler) {
        EventBus.subscribe(type, handler);
        return this;
    }

    public <T> AppContext onEvent(Class<T> type, int index, EventListener<T> handler) {
        EventBus.subscribe(type, index, handler);
        return this;
    }

    public MethodWrap methodGet(Method method) {
        return this.methodGet(method.getDeclaringClass(), method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodWrap methodGet(Class<?> clz, Method method) {
        MethodKey methodKey = new MethodKey(method, clz);
        MethodWrap mw = this.methodCached.get(methodKey);
        if (mw == null) {
            this.SYNC_LOCK.lock();
            try {
                mw = this.methodCached.get(methodKey);
                if (mw == null) {
                    mw = new MethodWrap(this, clz, method);
                    this.methodCached.put(methodKey, mw);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
        return mw;
    }

    public void methodForeach(Consumer<MethodWrap> action) {
        this.methodCached.values().forEach(action);
    }

    @Override
    public void clear() {
        super.clear();
        this.methodCached.clear();
        this.beanBuildedCached.clear();
        this.gatherSet.clear();
        this.lifecycleBeans.clear();
        this.started = false;
    }

    @Override
    protected BeanWrap wrapCreate(Class<?> type, Object bean, String name, boolean typed) {
        return new BeanWrap(this, type, bean, name, typed);
    }

    protected void initialize() {
        this.beanBuilderAdd(Configuration.class, (clz, bw, anno) -> {
            for (Annotation a1 : clz.getAnnotations()) {
                if (a1 instanceof Import) {
                    this.cfg().loadAdd((Import)a1);
                    this.beanImport((Import)a1);
                    continue;
                }
                if ((a1 = a1.annotationType().getAnnotation(Import.class)) == null) continue;
                this.cfg().loadAdd((Import)a1);
                this.beanImport((Import)a1);
            }
            this.tryFill(bw.raw(), clz.getAnnotations());
            this.beanExtractOrProxy(bw, true, false);
            this.beanDeliver(bw);
            this.beanRegisterSupI(clz, bw);
        });
        this.beanExtractorAdd(Bean.class, (bw, m, anno) -> {
            this.tryBuildBeanOfMethod(m, bw, anno.priority(), (mw, raw) -> this.tryBuildBeanOfMethod3((MethodWrap)mw, bw, raw, (Bean)anno));
            if (!Modifier.isPublic(m.getModifiers())) {
                log.warn("This @" + anno.annotationType().getSimpleName() + " method is not public: " + m.getDeclaringClass().getName() + ":" + m.getName());
            }
        });
        this.beanExtractorAdd(Managed.class, (bw, m, mm) -> {
            ManagedToBeanAnno anno = new ManagedToBeanAnno((Managed)mm);
            this.tryBuildBeanOfMethod(m, bw, (mw, raw) -> this.tryBuildBeanOfMethod3((MethodWrap)mw, bw, raw, anno));
            if (!Modifier.isPublic(m.getModifiers())) {
                log.warn("This @" + anno.annotationType().getSimpleName() + " method is not public: " + m.getDeclaringClass().getName() + ":" + m.getName());
            }
        });
        this.beanBuilderAdd(Component.class, (clz, bw, anno) -> {
            String beanName = Utils.annoAlias(anno.value(), anno.name());
            bw.nameSet(beanName);
            bw.tagSet(anno.tag());
            bw.typedSet(anno.typed());
            bw.indexSet(anno.index());
            this.beanComponentized(bw, anno.delivered());
        });
        this.beanBuilderAdd(Managed.class, (clz, bw, anno) -> {
            String beanName = Utils.annoAlias(anno.value(), anno.name());
            bw.nameSet(beanName);
            bw.tagSet(anno.tag());
            bw.typedSet(anno.typed());
            bw.indexSet(anno.index());
            this.beanComponentized(bw, anno.delivered());
        });
        this.beanBuilderAdd(Remoting.class, (clz, bw, anno) -> {
            bw.remotingSet(true);
            this.beanRegister(bw, "", false);
            if (this.app() != null) {
                this.app().router().add(bw);
            }
        });
        this.beanBuilderAdd(Controller.class, (clz, bw, anno) -> {
            if (this.app() != null) {
                this.app().router().add(bw);
            }
        });
        this.beanInjectorAdd(Inject.class, new BeanInjector<Inject>(){

            @Override
            public void doInject(VarHolder vh, Inject anno) {
                AppContext.this.beanInject(vh, anno.value(), anno.required(), anno.autoRefreshed());
            }

            @Override
            public void doFill(Object obj, Inject anno) {
                AppContext.this.beanFillProperties(obj, anno);
            }
        });
        this.beanInjectorAdd(BindProps.class, new BeanInjector<BindProps>(){

            @Override
            public void doInject(VarHolder vh, BindProps anno) {
            }

            @Override
            public void doFill(Object obj, BindProps anno) {
                AppContext.this.cfg().getProp(anno.prefix()).bindTo(obj);
            }
        });
        this.beanInterceptorAdd(To.class, inv -> {
            To anno;
            Object rst = inv.invoke();
            Context ctx = Context.current();
            if (ctx != null && (anno = inv.method().getAnnotation(To.class)).value().length > 0) {
                ArrayList<String> list = new ArrayList<String>(anno.value().length);
                for (String val : anno.value()) {
                    list.add(SnelUtil.evalTmpl(val, inv));
                }
                ctx.attrSet("ATTR_TO", list);
            }
            return rst;
        });
    }

    protected void beanComponentized(BeanWrap bw, boolean delivered) {
        this.beanExtractOrProxy(bw);
        if (delivered) {
            this.beanDeliver(bw);
        }
        this.beanRegister(bw, bw.name(), bw.typed());
        if (bw.singleton()) {
            this.beanPublish(bw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beanInject(VarHolder vh, String name, boolean required, boolean autoRefreshed) {
        super.beanInject(vh, name, required, autoRefreshed);
        if (vh.isDone()) {
            return;
        }
        try {
            if (Utils.isEmpty(name) && vh.getGenericType() != null) {
                if (List.class == vh.getType()) {
                    Type type;
                    ParameterizedType genericType;
                    Type tmp = vh.getGenericType().getActualTypeArguments()[0];
                    if (tmp instanceof ParameterizedType) {
                        genericType = (ParameterizedType)tmp;
                        type = ((ParameterizedType)tmp).getRawType();
                    } else {
                        genericType = null;
                        type = tmp;
                    }
                    if (type instanceof Class) {
                        if (!vh.isField()) {
                            vh.setDependencyType((Class)type);
                        }
                        vh.required(required);
                        vh.setValueDefault(() -> this.getBeansOfType((Class)type, genericType));
                    }
                } else if (Map.class == vh.getType()) {
                    Type valType;
                    ParameterizedType valGenericType;
                    Type valTmp = vh.getGenericType().getActualTypeArguments()[1];
                    Type keyType = vh.getGenericType().getActualTypeArguments()[0];
                    if (valTmp instanceof ParameterizedType) {
                        valGenericType = (ParameterizedType)valTmp;
                        valType = valGenericType.getRawType();
                    } else {
                        valGenericType = null;
                        valType = valTmp;
                    }
                    if (String.class == keyType && valType instanceof Class) {
                        if (!vh.isField()) {
                            vh.setDependencyType((Class)valType);
                        }
                        vh.required(required);
                        vh.setValueDefault(() -> this.getBeansMapOfType((Class)valType, valGenericType));
                    }
                }
            }
        }
        finally {
            if (this.isStarted()) {
                vh.commit();
            }
        }
    }

    public void beanDeliver(BeanWrap bw) {
        Mapping mapping;
        if (bw.raw() == null) {
            return;
        }
        if (bw.raw() instanceof Plugin) {
            throw new IllegalStateException("'Plugin' cannot be component, please use 'LifecycleBean': " + bw.clz().getName());
        }
        String singletonHint = null;
        if (bw.raw() instanceof LifecycleBean) {
            int index = bw.index();
            if (index == 0) {
                index = IndexUtil.buildLifecycleIndex(bw.rawClz());
            }
            this.lifecycle(index + 1, (LifecycleBean)bw.raw());
            singletonHint = "LifecycleBean";
        }
        if (bw.raw() instanceof EventListener) {
            this.addEventListener(bw.clz(), bw);
            singletonHint = "EventListener";
        }
        if (this.app() == null) {
            return;
        }
        if (bw.raw() instanceof LoadBalance.Factory) {
            FactoryManager.getGlobal().loadBalanceFactory((LoadBalance.Factory)bw.raw());
            singletonHint = "LoadBalance.Factory";
        }
        if (bw.raw() instanceof Handler && (mapping = bw.clz().getAnnotation(Mapping.class)) != null) {
            this.app().router().add(bw);
            singletonHint = "Handler";
        }
        if (bw.raw() instanceof Serializer) {
            this.app().serializers().register(bw.name(), (Serializer)bw.raw());
            singletonHint = "Serializer";
        }
        if (bw.raw() instanceof Render) {
            if (Assert.isNotEmpty(bw.name())) {
                this.app().renders().register(bw.name(), (Render)bw.raw());
            }
            this.app().renders().register((Render)bw.raw());
            singletonHint = "Render";
        }
        if (bw.raw() instanceof EntityConverter) {
            this.app().chains().addEntityConverter((EntityConverter)bw.raw(), bw.index());
            singletonHint = "EntityConverter";
        }
        if (bw.raw() instanceof RenderFactory) {
            this.app().renders().register((RenderFactory)bw.raw());
            singletonHint = "RenderFactory";
        }
        if (bw.raw() instanceof ActionExecuteHandler) {
            this.app().chains().addEntityConverter(new EntityConverterFromExecutor((ActionExecuteHandler)bw.raw()), bw.index());
            singletonHint = "ActionExecuteHandler";
            log.warn("The ActionExecuteHandler will be deprecated. Please use EntityConverter instead: {}", (Object)bw.clz().getName());
        }
        if (bw.raw() instanceof Filter) {
            this.app().filter(bw.index(), (Filter)bw.raw());
            singletonHint = "Filter";
        }
        if (bw.raw() instanceof RouterInterceptor) {
            this.app().routerInterceptor(bw.index(), (RouterInterceptor)bw.raw());
            singletonHint = "RouterInterceptor";
        }
        if (bw.raw() instanceof ReturnValueHandler) {
            this.app().chains().addReturnHandler((ReturnValueHandler)bw.raw(), bw.index());
            singletonHint = "ReturnValueHandler";
        }
        if (bw.raw() instanceof MethodArgumentResolver) {
            this.app().chains().addArgumentResolver((MethodArgumentResolver)bw.raw(), bw.index());
            singletonHint = "MethodArgumentResolver";
        }
        if (bw.raw() instanceof Converter) {
            Converter c = (Converter)bw.raw();
            this.app().converters().register(c);
            singletonHint = "Converter";
        }
        if (bw.raw() instanceof ConverterFactory) {
            ConverterFactory cf = (ConverterFactory)bw.raw();
            this.app().converters().register(cf);
            singletonHint = "ConverterFactory";
        }
        if (!bw.singleton() && singletonHint != null) {
            log.warn(singletonHint + " does not support @Singleton(false), class=" + bw.clz().getName());
        }
    }

    private void addEventListener(Class<?> clz, BeanWrap bw) {
        Class<?>[] ets = GenericUtil.resolveTypeArguments(clz, EventListener.class);
        if (ets != null && ets.length > 0) {
            EventBus.subscribe(ets[0], bw.index(), (EventListener)bw.raw());
        }
    }

    public void beanExtractOrProxy(BeanWrap bw) {
        this.beanExtractOrProxy(bw, true, true);
    }

    public void beanExtractOrProxy(BeanWrap bw, boolean tryExtract, boolean tryProxy) {
        if (bw == null) {
            return;
        }
        boolean enableProxy = false;
        ArrayList<AbstractMap.SimpleEntry<Method, Annotation>> extraList = new ArrayList<AbstractMap.SimpleEntry<Method, Annotation>>();
        if (this.beanExtractors.size() > 0 || this.beanInterceptors.size() > 0) {
            ClassWrap clzWrap = ClassWrap.get(bw.clz());
            for (Method m : clzWrap.findPublicMethods()) {
                for (Annotation a : m.getAnnotations()) {
                    if (tryExtract && this.beanExtractors.containsKey(a.annotationType())) {
                        extraList.add(new AbstractMap.SimpleEntry<Method, Annotation>(m, a));
                    }
                    if (!tryProxy) continue;
                    enableProxy = enableProxy || this.beanInterceptorHas(a);
                }
            }
        }
        if (tryProxy) {
            boolean bl = enableProxy = enableProxy || this.beanInterceptorHas(bw.clz());
            if (enableProxy) {
                ProxyBinder.global().binding(bw);
            }
        }
        for (Map.Entry entry : extraList) {
            Method m;
            m = (Method)entry.getKey();
            Annotation a = (Annotation)entry.getValue();
            BeanExtractor be = (BeanExtractor)this.beanExtractors.get(a.annotationType());
            if (be == null) continue;
            try {
                this.methodGet(m);
                be.doExtract(bw, m, a);
            }
            catch (Throwable e) {
                e = Utils.throwableUnwrap(e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    public void beanInject(Object obj) {
        if (obj == null) {
            return;
        }
        ClassWrap clzWrap = ClassWrap.get(obj.getClass());
        ArrayList<FieldWrap> fwList = new ArrayList<FieldWrap>();
        for (FieldWrap fw : clzWrap.getAllFieldWraps()) {
            if (fw.getAnnoS().length <= 0) continue;
            fwList.add(fw);
        }
        for (FieldWrap fw : clzWrap.getStaticFieldWraps()) {
            if (fw.getAnnoS().length <= 0) continue;
            fwList.add(fw);
        }
        if (fwList.size() != 0) {
            InjectGather gather = new InjectGather(0, clzWrap.clz(), true, fwList.size(), null);
            this.gatherSet.add(gather);
            for (FieldWrap fw : fwList) {
                VarHolder vh = fw.holder(this, obj, gather);
                gather.add(vh);
                this.tryInject(vh, fw.getAnnoS());
            }
        }
    }

    public void beanExclude(Class<?> ... clzs) {
        for (Class<?> clz : clzs) {
            this.beanBuildedCached.add(clz);
        }
    }

    public void beanImport(Import anno) {
        if (anno != null) {
            for (Class<?> c1 : anno.value()) {
                this.beanMake(c1);
            }
            for (Class<?> c1 : anno.classes()) {
                this.beanMake(c1);
            }
            for (String p1 : anno.scanPackages()) {
                this.beanScan(p1);
            }
            for (Class<?> s1 : anno.scanPackageClasses()) {
                this.beanScan(s1);
            }
        }
    }

    public void beanScan(Class<?> source) {
        if (source.getPackage() != null) {
            this.beanScan(source.getClassLoader(), source.getPackage().getName());
        }
    }

    public void beanScan(String basePackage) {
        this.beanScan(this.getClassLoader(), basePackage);
    }

    public void beanScan(ClassLoader classLoader, String basePackage) {
        if (Utils.isEmpty(basePackage)) {
            return;
        }
        if (classLoader == null) {
            return;
        }
        String dir = basePackage.replace('.', '/');
        ScanUtil.scan(classLoader, dir, n -> n.endsWith(".class")).stream().sorted(Comparator.comparing(s -> s.length())).forEach(name -> {
            String className = name.substring(0, name.length() - 6);
            Class<?> clz = ClassUtil.loadClass(classLoader, className = className.replace('/', '.'));
            if (clz != null) {
                this.tryBuildBeanOfClass(clz);
            }
        });
    }

    @Nullable
    public BeanWrap beanMake(Class<?> clz) {
        int state = this.tryBuildBeanOfClass(clz);
        if (state == 1) {
            return null;
        }
        if (state == 2) {
            return this.getWrap(clz);
        }
        return this.wrapAndPut(clz);
    }

    protected void tryFill(Object obj, Annotation[] annS) {
        if (obj == null) {
            return;
        }
        for (Annotation anno : annS) {
            BeanInjector injector;
            TypeMap biMap = (TypeMap)this.beanInjectors.get(anno.annotationType());
            if (biMap == null || (injector = (BeanInjector)biMap.get(obj.getClass())) == null) continue;
            injector.doFill(obj, anno);
            return;
        }
    }

    protected void tryInject(VarHolder vh, Annotation[] annS) {
        for (Annotation a : annS) {
            BeanInjector injector;
            TypeMap biMap = (TypeMap)this.beanInjectors.get(a.annotationType());
            if (biMap == null || (injector = (BeanInjector)biMap.get(vh.getType())) == null) continue;
            injector.doInject(vh, a);
            return;
        }
        vh.setValue(null);
    }

    public void tryBuildBeanOfMethod(Method m, BeanWrap bw, BiConsumerEx<MethodWrap, Object> completionConsumer) throws Throwable {
        this.tryBuildBeanOfMethod(m, bw, 0, completionConsumer);
    }

    private void tryBuildBeanOfMethod(Method m, BeanWrap bw, int priority, BiConsumerEx<MethodWrap, Object> completionConsumer) throws Throwable {
        if (NativeDetector.isAotRuntime()) {
            this.methodGet(bw.rawClz(), m);
        }
        Condition mc = m.getAnnotation(Condition.class);
        if (!this.started && ConditionUtil.ifMissingBean(mc)) {
            priority = mc.priority() > 0 ? mc.priority() : priority;
            this.lifecycle(-98, priority, () -> this.tryBuildBeanOfMethod0(bw, m, mc, completionConsumer));
        } else {
            this.tryBuildBeanOfMethod0(bw, m, mc, completionConsumer);
        }
    }

    private void tryBuildBeanOfMethod0(BeanWrap bw, Method m, Condition mc, BiConsumerEx<MethodWrap, Object> completionConsumer) throws Throwable {
        if (!ConditionUtil.test(this, mc)) {
            return;
        }
        ClassUtil.accessibleAsTrue(m);
        MethodWrap mWrap = this.methodGet(bw.rawClz(), m);
        if (ConditionUtil.ifBean(mc)) {
            ConditionUtil.onBeanRun(mc, this, () -> this.tryBuildBeanOfMethod1(mWrap, bw, completionConsumer));
        } else {
            this.tryBuildBeanOfMethod1(mWrap, bw, completionConsumer);
        }
    }

    private void tryBuildBeanOfMethod1(MethodWrap mWrap, BeanWrap bw, BiConsumerEx<MethodWrap, Object> completionConsumer) throws Throwable {
        if (mWrap.getParamWraps().length == 0) {
            this.tryBuildBeanOfMethod2(mWrap, bw, new Object[0], completionConsumer);
        } else {
            this.tryBuildArgsOfMethod(bw.context(), 1, mWrap.getReturnType(), mWrap.getParamWraps(), args2 -> RunUtil.runOrThrow(() -> this.tryBuildBeanOfMethod2(mWrap, bw, (Object[])args2, completionConsumer)));
        }
    }

    protected void tryBuildArgsOfMethod(AppContext context, int label, Class<?> outType, ParamWrap[] paramAry, ConsumerEx<Object[]> completionConsumer) {
        InjectGather gather = new InjectGather(label, outType, true, paramAry.length, args2 -> completionConsumer.accept((Object[])args2));
        this.gatherSet.add(gather);
        for (ParamWrap pw1 : paramAry) {
            VarHolderOfParam vh = new VarHolderOfParam(context, pw1, gather);
            gather.add(vh);
            if (pw1.getAnnoS().length == 0) {
                this.beanInject(vh, null, true, false);
                continue;
            }
            this.tryInject(vh, pw1.getAnnoS());
        }
    }

    private void tryBuildBeanOfMethod2(MethodWrap mWrap, BeanWrap bw, Object[] args, BiConsumerEx<MethodWrap, Object> completionConsumer) {
        try {
            Object raw = mWrap.invoke(bw.raw(), args);
            if (raw != null) {
                this.tryFill(raw, mWrap.getAnnotations());
                completionConsumer.accept(mWrap, raw);
            }
        }
        catch (Throwable ex) {
            Class<?> declClz;
            Class<?> fileClz = declClz = mWrap.getDeclaringClz();
            if (declClz.isMemberClass()) {
                fileClz = declClz.getEnclosingClass();
            }
            StringBuilder buf = new StringBuilder();
            buf.append("Build bean of method failed: \r\n\tat ");
            buf.append(declClz.getName()).append(".");
            buf.append(mWrap.getName()).append("(").append(fileClz.getSimpleName()).append(".java:0)");
            throw new IllegalStateException(buf.toString(), ex);
        }
    }

    protected void tryBuildBeanOfMethod3(MethodWrap mWrap, BeanWrap bw, Object raw, Bean anno) {
        Class<?> beanClz = mWrap.getReturnType();
        ParameterizedType beanGtp = mWrap.getGenericReturnType();
        BeanWrap m_bw = null;
        if (raw instanceof BeanWrap) {
            m_bw = (BeanWrap)raw;
        } else {
            if (anno.autoInject() || anno.injected()) {
                this.beanInject(raw);
            }
            m_bw = new BeanWrap(this, beanClz, raw, null, false, anno.initMethod(), anno.destroyMethod());
        }
        String beanName = Utils.annoAlias(anno.value(), anno.name());
        m_bw.nameSet(beanName);
        m_bw.tagSet(anno.tag());
        m_bw.typedSet(anno.typed());
        m_bw.indexSet(anno.index());
        m_bw.done();
        if (anno.autoProxy()) {
            this.beanExtractOrProxy(m_bw);
        }
        if (anno.delivered()) {
            this.beanDeliver(m_bw);
        }
        this.beanRegister(m_bw, beanName, anno.typed());
        if (beanGtp instanceof ParameterizedType) {
            this.putWrap(beanGtp.getTypeName(), m_bw);
            m_bw.genericList().add(beanGtp);
        }
        this.beanPublish(m_bw);
    }

    protected int tryBuildBeanOfClass(Class<?> clz) {
        Condition cc = clz.getAnnotation(Condition.class);
        if (!this.started && ConditionUtil.ifMissingBean(cc)) {
            this.lifecycle(-99, cc.priority(), () -> this.tryBuildBeanOfClass0(clz, cc));
            return 1;
        }
        return this.tryBuildBeanOfClass0(clz, cc);
    }

    private int tryBuildBeanOfClass0(Class<?> clz, Condition cc) {
        if (!ConditionUtil.test(this, cc)) {
            return 1;
        }
        if (ConditionUtil.ifBean(cc)) {
            ConditionUtil.onBeanRun(cc, this, () -> this.tryBuildBeanOfClass1(clz));
            return 1;
        }
        return this.tryBuildBeanOfClass1(clz);
    }

    private int tryBuildBeanOfClass1(Class<?> clz) {
        Annotation[] annS = clz.getAnnotations();
        int state = 0;
        if (annS.length > 0) {
            if (this.beanBuildedCached.contains(clz)) {
                return 2;
            }
            this.beanBuildedCached.add(clz);
            for (Annotation a : annS) {
                BeanBuilder builder;
                TypeMap bbMap = (TypeMap)this.beanBuilders.get(a.annotationType());
                if (bbMap == null || (builder = (BeanBuilder)bbMap.get(clz)) == null) continue;
                try {
                    state = 2;
                    this.tryBuildBeanOfClass2(clz, builder, a);
                }
                catch (Throwable e) {
                    e = Utils.throwableUnwrap(e);
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new IllegalStateException(e);
                }
            }
        }
        return state;
    }

    private void tryBuildBeanOfClass2(Class<?> clz, BeanBuilder builder, Annotation anno) throws Throwable {
        Constructor<?> c1 = !clz.isInterface() ? clz.getDeclaredConstructors()[0] : null;
        if (c1 == null || c1.getParameterCount() == 0) {
            this.tryBuildBeanOfClass3(clz, builder, anno, null, null);
        } else {
            ConstructorWrap cw = new ConstructorWrap(clz, c1);
            this.tryBuildArgsOfMethod(this, 2, clz, cw.getParamWraps(), args2 -> this.tryBuildBeanOfClass3(clz, builder, anno, c1, (Object[])args2));
        }
    }

    private void tryBuildBeanOfClass3(Class<?> clz, BeanBuilder builder, Annotation anno, Constructor rawCon, Object[] rawConArgs) throws Throwable {
        BeanWrap bw = new BeanWrap(this, clz, rawCon, rawConArgs);
        builder.doBuild(clz, bw, anno);
        bw.done();
        this.putWrap(clz, bw);
    }

    public void lifecycle(LifecycleBean lifecycle) {
        this.lifecycle(0, (Lifecycle)lifecycle);
    }

    public void lifecycle(int index, LifecycleBean lifecycle) {
        lifecycle.setAppContext(this);
        this.lifecycle(index, (Lifecycle)lifecycle);
    }

    @Override
    public void lifecycle(Lifecycle lifecycle) {
        this.lifecycle(0, lifecycle);
    }

    @Override
    public void lifecycle(int index, Lifecycle lifecycle) {
        this.lifecycle(index, 0, lifecycle);
    }

    @Override
    public void lifecycle(int index, int priority, Lifecycle lifecycle) {
        this.lifecycleBeans.add(new RankEntity<Lifecycle>(lifecycle, index, priority));
        if (this.isStarting()) {
            RunUtil.runOrThrow(lifecycle::start);
        }
        if (this.isStarted()) {
            RunUtil.runOrThrow(lifecycle::postStart);
        }
    }

    public boolean isStarting() {
        return this.starting;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        this.starting = true;
        try {
            this.startBeanLifecycle();
            this.started = true;
            this.startInjectReview(2);
            this.startInjectReview(2);
            this.postStartBeanLifecycle();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void startBeanLifecycle() throws Throwable {
        ArrayList<RankEntity<Lifecycle>> beans = new ArrayList<RankEntity<Lifecycle>>(this.lifecycleBeans);
        Collections.sort(beans);
        for (RankEntity rankEntity : beans) {
            ((Lifecycle)rankEntity.target).start();
        }
    }

    private void postStartBeanLifecycle() throws Throwable {
        ArrayList<RankEntity<Lifecycle>> beans = new ArrayList<RankEntity<Lifecycle>>(this.lifecycleBeans);
        Collections.sort(beans);
        for (RankEntity rankEntity : beans) {
            ((Lifecycle)rankEntity.target).postStart();
        }
    }

    private void startInjectReview(int sel) throws Throwable {
        block5: {
            List<InjectGather> gatherList = null;
            gatherList = sel == 0 ? this.gatherSet.stream().filter(g1 -> !g1.isDone() && !g1.isMethod()).collect(Collectors.toList()) : (sel == 1 ? this.gatherSet.stream().filter(g1 -> !g1.isDone() && g1.isMethod()).collect(Collectors.toList()) : this.gatherSet.stream().filter(g1 -> !g1.isDone()).collect(Collectors.toList()));
            if (gatherList.size() <= 0) break block5;
            for (InjectGather gather : gatherList) {
                IndexUtil.buildGatherIndex(gather, gatherList);
            }
            if (sel > 0) {
                Collections.sort(gatherList);
                for (InjectGather g12 : gatherList) {
                    g12.check();
                }
            } else {
                for (InjectGather gather : gatherList) {
                    gather.commit();
                }
            }
        }
    }

    public void prestop() {
        this.started = false;
        try {
            ArrayList<RankEntity<Lifecycle>> beans = new ArrayList<RankEntity<Lifecycle>>(this.lifecycleBeans);
            Collections.sort(beans);
            for (RankEntity rankEntity : beans) {
                try {
                    ((Lifecycle)rankEntity.target).preStop();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable ignored) {
            log.warn("AppContext prestop error", ignored);
        }
    }

    public void stop() {
        this.started = false;
        try {
            ArrayList<RankEntity<Lifecycle>> beans = new ArrayList<RankEntity<Lifecycle>>(this.lifecycleBeans);
            Collections.sort(beans);
            for (RankEntity rankEntity : beans) {
                try {
                    ((Lifecycle)rankEntity.target).stop();
                }
                catch (Throwable throwable) {}
            }
            this.beanStop0();
        }
        catch (Throwable ignored) {
            log.warn("AppContext stop error", ignored);
        }
    }
}

