/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.decode;

import java.nio.ByteBuffer;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.utils.ByteTree;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.ServerHandler;
import org.smartboot.http.server.decode.AbstractDecoder;
import org.smartboot.http.server.decode.Decoder;
import org.smartboot.http.server.decode.HttpProtocolDecoder;
import org.smartboot.http.server.decode.HttpUriQueryDecoder;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.waf.UriWafDecoder;

class HttpUriDecoder
extends AbstractDecoder {
    private static final ByteTree.EndMatcher URI_END_MATCHER = endByte -> endByte <= 63 && (endByte == 32 || endByte == 63);
    private final HttpUriQueryDecoder uriQueryDecoder = new HttpUriQueryDecoder(this.getConfiguration());
    private final HttpProtocolDecoder protocolDecoder = new HttpProtocolDecoder(this.getConfiguration());

    public HttpUriDecoder(HttpServerConfiguration configuration) {
        super(configuration, new UriWafDecoder(configuration));
    }

    @Override
    public Decoder decode0(ByteBuffer byteBuffer, Request request) {
        ByteTree uriTreeNode = StringUtils.scanByteTree((ByteBuffer)byteBuffer, (ByteTree.EndMatcher)URI_END_MATCHER, this.getConfiguration().getUriByteTree());
        if (uriTreeNode != null) {
            request.setUri(uriTreeNode.getStringValue());
            if (uriTreeNode.getAttach() == null) {
                request.setServerHandler(request.getConfiguration().getHttpServerHandler());
            } else {
                request.setServerHandler((ServerHandler)uriTreeNode.getAttach());
            }
            switch (byteBuffer.get(byteBuffer.position() - 1)) {
                case 32: {
                    return this.protocolDecoder.decode(byteBuffer, request);
                }
                case 63: {
                    return this.uriQueryDecoder.decode(byteBuffer, request);
                }
            }
            throw new HttpException(HttpStatus.BAD_REQUEST);
        }
        return this;
    }
}

