/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HttpMethodEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.logging.Logger;
import org.smartboot.http.common.logging.LoggerFactory;
import org.smartboot.http.common.utils.DateUtils;
import org.smartboot.http.common.utils.Mimetypes;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpResponse;
import org.smartboot.http.server.HttpServerHandler;

public class HttpStaticResourceHandler
extends HttpServerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpStaticResourceHandler.class);
    private final File baseDir;

    public HttpStaticResourceHandler(String baseDir) {
        this.baseDir = new File(new File(baseDir).getAbsolutePath());
        if (!this.baseDir.isDirectory()) {
            throw new RuntimeException(baseDir + " is not a directory");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("dir is:{}", (Object)this.baseDir.getAbsolutePath());
        }
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response) throws IOException {
        File file;
        String fileName = request.getRequestURI();
        String method = request.getMethod();
        if (StringUtils.endsWith((CharSequence)fileName, (CharSequence)"/")) {
            fileName = fileName + "index.html";
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u8bf7\u6c42URL: " + fileName);
        }
        if (!(file = new File(this.baseDir, URLDecoder.decode(fileName, StandardCharsets.UTF_8.name()))).isFile()) {
            LOGGER.warn("file: {} not found!", (Object)request.getRequestURI());
            response.setHttpStatus(HttpStatus.NOT_FOUND);
            response.setHeader(HeaderNameEnum.CONTENT_TYPE.getName(), "text/html; charset=utf-8");
            if (!HttpMethodEnum.HEAD.getMethod().equals(method)) {
                throw new HttpException(HttpStatus.NOT_FOUND);
            }
            return;
        }
        Date lastModifyDate = new Date(file.lastModified() / 1000L * 1000L);
        try {
            String requestModified = request.getHeader(HeaderNameEnum.IF_MODIFIED_SINCE.getName());
            if (StringUtils.isNotBlank((CharSequence)requestModified) && lastModifyDate.getTime() <= DateUtils.parseLastModified((String)requestModified).getTime()) {
                response.setHttpStatus(HttpStatus.NOT_MODIFIED);
                return;
            }
        }
        catch (Exception e) {
            LOGGER.error("exception", (Throwable)e);
        }
        response.setHeader(HeaderNameEnum.LAST_MODIFIED.getName(), DateUtils.formatLastModified((Date)lastModifyDate));
        String contentType = Mimetypes.getInstance().getMimetype(file);
        response.setHeader(HeaderNameEnum.CONTENT_TYPE.getName(), contentType + "; charset=utf-8");
        if (HttpMethodEnum.HEAD.getMethod().equals(method)) {
            return;
        }
        response.setContentLength((int)file.length());
        try (FileInputStream fis = new FileInputStream(file);){
            int len;
            long fileSize = response.getContentLength();
            byte[] bytes = new byte[0x100000];
            for (long readPos = 0L; readPos < fileSize; readPos += (long)len) {
                len = fis.read(bytes);
                if (len == -1) {
                    throw new RuntimeException("EOF reached");
                }
                response.getOutputStream().write(bytes, 0, len);
            }
        }
    }
}

