/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.handler;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.smartboot.http.common.logging.Logger;
import org.smartboot.http.common.logging.LoggerFactory;
import org.smartboot.http.server.WebSocketHandler;
import org.smartboot.http.server.WebSocketRequest;
import org.smartboot.http.server.WebSocketResponse;
import org.smartboot.http.server.impl.WebSocketRequestImpl;
import org.smartboot.http.server.impl.WebSocketResponseImpl;
import org.smartboot.socket.util.StringUtils;

public class WebSocketDefaultHandler
extends WebSocketHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketDefaultHandler.class);

    @Override
    public void whenHeaderComplete(WebSocketRequestImpl request, WebSocketResponseImpl response) {
        this.onHandShake(request, response);
    }

    @Override
    public final void handle(WebSocketRequest request, WebSocketResponse response) throws IOException {
        try {
            switch (request.getFrameOpcode()) {
                case 1: {
                    this.handleTextMessage(request, response, new String(request.getPayload(), StandardCharsets.UTF_8));
                    break;
                }
                case 2: {
                    this.handleBinaryMessage(request, response, request.getPayload());
                    break;
                }
                case 8: {
                    try {
                        this.onClose(request, response);
                        break;
                    }
                    finally {
                        response.close();
                    }
                }
                case 9: {
                    this.handlePing(request, response);
                    break;
                }
                case 10: {
                    this.handlePong(request, response);
                    break;
                }
                case 0: {
                    LOGGER.warn("unSupport OPCODE_CONTINUE now,ignore payload: {}", (Object)StringUtils.toHexString((byte[])request.getPayload()));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        catch (Throwable throwable) {
            this.onError(request, throwable);
            throw throwable;
        }
    }

    public void handlePing(WebSocketRequest request, WebSocketResponse response) {
        response.pong(request.getPayload());
    }

    public void handlePong(WebSocketRequest request, WebSocketResponse response) {
        LOGGER.warn("receive pong...");
    }

    public void onHandShake(WebSocketRequest request, WebSocketResponse response) {
        LOGGER.warn("handShake success");
    }

    public void onClose(WebSocketRequest request, WebSocketResponse response) {
        LOGGER.warn("close connection");
    }

    public void handleTextMessage(WebSocketRequest request, WebSocketResponse response, String data) {
        System.out.println(data);
    }

    public void handleBinaryMessage(WebSocketRequest request, WebSocketResponse response, byte[] data) {
        System.out.println(data);
    }

    public void onError(WebSocketRequest request, Throwable throwable) {
        throwable.printStackTrace();
    }
}

