/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.smartboot.http.common.Cookie;
import org.smartboot.http.common.HeaderValue;
import org.smartboot.http.common.Reset;
import org.smartboot.http.common.enums.DecodePartEnum;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.enums.HttpTypeEnum;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.utils.ByteTree;
import org.smartboot.http.common.utils.HttpUtils;
import org.smartboot.http.common.utils.NumberUtils;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.Http2ServerHandler;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.ServerHandler;
import org.smartboot.http.server.WebSocketHandler;
import org.smartboot.http.server.impl.AbstractRequest;
import org.smartboot.http.server.impl.HttpRequestImpl;
import org.smartboot.http.server.impl.WebSocketRequestImpl;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.util.Attachment;

public final class Request
implements HttpRequest,
Reset {
    private static final Locale defaultLocale = Locale.getDefault();
    private static final int INIT_CONTENT_LENGTH = -2;
    private static final int NONE_CONTENT_LENGTH = -1;
    private final AioSession aioSession;
    private final List<HeaderValue> headers = new ArrayList<HeaderValue>(8);
    private final HttpServerConfiguration configuration;
    private ByteTree<Function<String, ServerHandler>> headerTemp;
    private Map<String, String[]> parameters;
    private String uri;
    private int headerSize = 0;
    private String method;
    private String protocol;
    private String requestUri;
    private String requestUrl;
    private String contentType;
    private String queryString;
    private String scheme;
    private int contentLength = -2;
    private String remoteAddr;
    private String remoteHost;
    private String hostHeader;
    private HttpTypeEnum type = null;
    private String formUrlencoded;
    private Cookie[] cookies;
    private Attachment attachment;
    private DecodePartEnum decodePartEnum = DecodePartEnum.HEADER_FINISH;
    private HttpRequestImpl httpRequest;
    private WebSocketRequestImpl webSocketRequest;
    private ServerHandler serverHandler;
    private int remainingThreshold;

    Request(HttpServerConfiguration configuration, AioSession aioSession) {
        this.configuration = configuration;
        this.aioSession = aioSession;
        this.remainingThreshold = configuration.getMaxRequestSize();
    }

    int getRemainingThreshold() {
        return this.remainingThreshold;
    }

    public DecodePartEnum getDecodePartEnum() {
        return this.decodePartEnum;
    }

    public void setDecodePartEnum(DecodePartEnum decodePartEnum) {
        this.decodePartEnum = decodePartEnum;
    }

    public AioSession getAioSession() {
        return this.aioSession;
    }

    public final String getHost() {
        if (this.hostHeader == null) {
            this.hostHeader = this.getHeader(HeaderNameEnum.HOST.getName());
        }
        return this.hostHeader;
    }

    void decodeSize(int size) {
        this.remainingThreshold -= size;
        if (this.remainingThreshold < 0) {
            throw new HttpException(HttpStatus.PAYLOAD_TOO_LARGE);
        }
    }

    @Override
    public final String getHeader(String headName) {
        for (int i = 0; i < this.headerSize; ++i) {
            HeaderValue headerValue = this.headers.get(i);
            if (!headerValue.getName().equalsIgnoreCase(headName)) continue;
            return headerValue.getValue();
        }
        return null;
    }

    @Override
    public final Collection<String> getHeaders(String name) {
        ArrayList<String> value = new ArrayList<String>(4);
        for (int i = 0; i < this.headerSize; ++i) {
            HeaderValue headerValue = this.headers.get(i);
            if (!headerValue.getName().equalsIgnoreCase(name)) continue;
            value.add(headerValue.getValue());
        }
        return value;
    }

    @Override
    public final Collection<String> getHeaderNames() {
        HashSet<String> nameSet = new HashSet<String>();
        for (int i = 0; i < this.headerSize; ++i) {
            nameSet.add(this.headers.get(i).getName());
        }
        return nameSet;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    @Override
    public InputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    public final void setHeadValue(String value) {
        ServerHandler replaceServerHandler;
        if (this.headerTemp.getAttach() != null && (replaceServerHandler = (ServerHandler)((Function)this.headerTemp.getAttach()).apply(value)) != null) {
            this.setServerHandler(replaceServerHandler);
        }
        this.setHeader(this.headerTemp.getStringValue(), value);
    }

    public final void setHeader(String headerName, String value) {
        if (this.headerSize < this.headers.size()) {
            HeaderValue headerValue = this.headers.get(this.headerSize);
            headerValue.setName(headerName);
            headerValue.setValue(value);
        } else {
            this.headers.add(new HeaderValue(headerName, value));
        }
        ++this.headerSize;
    }

    public HttpTypeEnum getRequestType() {
        if (this.type != null) {
            return this.type;
        }
        this.type = this.serverHandler instanceof WebSocketHandler ? HttpTypeEnum.WEBSOCKET : (this.serverHandler instanceof Http2ServerHandler ? HttpTypeEnum.HTTP_2 : HttpTypeEnum.HTTP);
        return this.type;
    }

    public ServerHandler getServerHandler() {
        return this.serverHandler;
    }

    public void setServerHandler(ServerHandler serverHandler) {
        this.serverHandler = serverHandler;
    }

    @Override
    public final String getRequestURI() {
        return this.requestUri;
    }

    public final void setRequestURI(String uri) {
        this.requestUri = uri;
    }

    @Override
    public final String getProtocol() {
        return this.protocol;
    }

    public final void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public final String getMethod() {
        return this.method;
    }

    @Override
    public boolean isSecure() {
        return this.configuration.isSecure();
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUri() {
        return this.uri;
    }

    public final void setUri(String uri) {
        this.uri = uri;
    }

    public void setHeaderTemp(ByteTree headerTemp) {
        this.headerTemp = headerTemp;
    }

    @Override
    public final String getRequestURL() {
        if (this.requestUrl != null) {
            return this.requestUrl;
        }
        this.requestUrl = this.requestUri.startsWith("/") ? this.getScheme() + "://" + this.getHeader(HeaderNameEnum.HOST.getName()) + this.getRequestURI() : this.requestUri;
        return this.requestUrl;
    }

    @Override
    public final String getScheme() {
        if (this.scheme == null) {
            return this.configuration.isSecure() ? "https" : "http";
        }
        return this.scheme;
    }

    public final void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @Override
    public final String getQueryString() {
        return this.queryString;
    }

    public final void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    @Override
    public final String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        this.contentType = this.getHeader(HeaderNameEnum.CONTENT_TYPE.getName());
        return this.contentType;
    }

    @Override
    public final int getContentLength() {
        if (this.contentLength > -2) {
            return this.contentLength;
        }
        this.contentLength = NumberUtils.toInt((String)this.getHeader(HeaderNameEnum.CONTENT_LENGTH.getName()), (int)-1);
        if (this.contentLength >= this.remainingThreshold) {
            throw new HttpException(HttpStatus.PAYLOAD_TOO_LARGE);
        }
        return this.contentLength;
    }

    @Override
    public final String getParameter(String name) {
        String[] arr = name != null ? this.getParameterValues(name) : null;
        return arr != null && arr.length > 0 ? arr[0] : null;
    }

    @Override
    public String[] getParameterValues(String name) {
        if (this.parameters != null) {
            return this.parameters.get(name);
        }
        this.parameters = new HashMap<String, String[]>();
        String urlParamStr = this.queryString;
        if (StringUtils.isNotBlank((CharSequence)urlParamStr)) {
            urlParamStr = StringUtils.substringBefore((String)urlParamStr, (String)"#");
            HttpUtils.decodeParamString((String)urlParamStr, this.parameters);
        }
        if (this.formUrlencoded != null) {
            HttpUtils.decodeParamString((String)this.formUrlencoded, this.parameters);
        }
        return this.getParameterValues(name);
    }

    @Override
    public final Map<String, String[]> getParameters() {
        if (this.parameters == null) {
            this.getParameter("");
        }
        return this.parameters;
    }

    @Override
    public final String getRemoteAddr() {
        if (this.remoteAddr != null) {
            return this.remoteAddr;
        }
        try {
            InetSocketAddress remote = this.aioSession.getRemoteAddress();
            InetAddress address = remote.getAddress();
            this.remoteAddr = address == null ? remote.getHostString() : address.getHostAddress();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.remoteAddr;
    }

    @Override
    public final InetSocketAddress getRemoteAddress() {
        try {
            return this.aioSession.getRemoteAddress();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final InetSocketAddress getLocalAddress() {
        try {
            return this.aioSession.getLocalAddress();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final String getRemoteHost() {
        if (this.remoteHost != null) {
            return this.remoteHost;
        }
        try {
            this.remoteHost = this.aioSession.getRemoteAddress().getHostString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.remoteHost;
    }

    @Override
    public final Locale getLocale() {
        return defaultLocale;
    }

    @Override
    public final Enumeration<Locale> getLocales() {
        return Collections.enumeration(Collections.singletonList(defaultLocale));
    }

    @Override
    public final String getCharacterEncoding() {
        return "utf8";
    }

    @Override
    public Cookie[] getCookies() {
        String value;
        if (this.cookies != null) {
            return this.cookies;
        }
        String cookieValue = this.getHeader(HeaderNameEnum.COOKIE.getName());
        if (StringUtils.isBlank((CharSequence)cookieValue)) {
            return new Cookie[0];
        }
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
        int state = 1;
        int startIndex = 0;
        int endIndex = 0;
        String name = null;
        block4: for (int i = 0; i < cookieValue.length(); ++i) {
            switch (state) {
                case 1: {
                    if (cookieValue.charAt(i) != '=') continue block4;
                    endIndex = i;
                    while (cookieValue.charAt(startIndex) == ' ' && startIndex < i) {
                        ++startIndex;
                    }
                    while (cookieValue.charAt(endIndex - 1) == ' ' && endIndex > startIndex) {
                        --endIndex;
                    }
                    name = cookieValue.substring(startIndex, endIndex);
                    startIndex = i + 1;
                    state = 2;
                    continue block4;
                }
                case 2: {
                    if (cookieValue.charAt(i) != ';') continue block4;
                    endIndex = i;
                    while (cookieValue.charAt(startIndex) == ' ' && startIndex < i) {
                        ++startIndex;
                    }
                    while (cookieValue.charAt(endIndex - 1) == ' ' && endIndex > startIndex) {
                        --endIndex;
                    }
                    value = cookieValue.substring(startIndex, endIndex);
                    cookieList.add(new Cookie(name, value));
                    startIndex = i + 1;
                    state = 1;
                }
            }
        }
        if (startIndex == cookieValue.length()) {
            cookieList.add(new Cookie(name, ""));
        } else if (endIndex < startIndex) {
            endIndex = cookieValue.length();
            while (cookieValue.charAt(startIndex) == ' ') {
                ++startIndex;
            }
            while (cookieValue.charAt(endIndex - 1) == ' ' && endIndex > startIndex) {
                --endIndex;
            }
            value = cookieValue.substring(startIndex, endIndex);
            cookieList.add(new Cookie(name, value));
        }
        this.cookies = new Cookie[cookieList.size()];
        cookieList.toArray(this.cookies);
        return this.cookies;
    }

    public String getFormUrlencoded() {
        return this.formUrlencoded;
    }

    public void setFormUrlencoded(String formUrlencoded) {
        this.formUrlencoded = formUrlencoded;
    }

    @Override
    public Attachment getAttachment() {
        return this.attachment;
    }

    @Override
    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
    }

    public AbstractRequest newAbstractRequest() {
        switch (this.getRequestType()) {
            case WEBSOCKET: {
                return this.newWebsocketRequest();
            }
            case HTTP: {
                return this.newHttpRequest();
            }
        }
        return null;
    }

    public HttpRequestImpl newHttpRequest() {
        if (this.httpRequest == null) {
            this.httpRequest = new HttpRequestImpl(this);
        }
        return this.httpRequest;
    }

    public WebSocketRequestImpl newWebsocketRequest() {
        if (this.webSocketRequest == null) {
            this.webSocketRequest = new WebSocketRequestImpl(this);
        }
        return this.webSocketRequest;
    }

    public HttpServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void reset() {
        this.remainingThreshold = this.configuration.getMaxRequestSize();
        this.headerSize = 0;
        this.method = null;
        this.uri = null;
        this.requestUrl = null;
        this.parameters = null;
        this.contentType = null;
        this.contentLength = -2;
        this.formUrlencoded = null;
        this.queryString = null;
        this.cookies = null;
        this.httpRequest = null;
        this.webSocketRequest = null;
        this.type = null;
        this.decodePartEnum = DecodePartEnum.HEADER_FINISH;
        this.scheme = null;
    }
}

