/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.nio.ByteBuffer;
import org.smartboot.http.common.enums.HeaderValueEnum;
import org.smartboot.http.common.enums.HttpMethodEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.utils.FixedLengthFrameDecoder;
import org.smartboot.http.common.utils.SmartDecoder;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpResponse;
import org.smartboot.http.server.ServerHandler;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.impl.RequestAttachment;

public abstract class HttpServerHandler
implements ServerHandler<HttpRequest, HttpResponse> {
    public boolean onBodyStream(ByteBuffer buffer, Request request) {
        if (HttpMethodEnum.GET.getMethod().equals(request.getMethod())) {
            return true;
        }
        int postLength = request.getContentLength();
        if (HttpMethodEnum.POST.getMethod().equals(request.getMethod()) && StringUtils.startsWith((CharSequence)request.getContentType(), (CharSequence)HeaderValueEnum.X_WWW_FORM_URLENCODED.getName())) {
            if (postLength < 0) {
                throw new HttpException(HttpStatus.LENGTH_REQUIRED);
            }
            if (postLength == 0) {
                return true;
            }
            RequestAttachment attachment = (RequestAttachment)request.getAioSession().getAttachment();
            SmartDecoder smartDecoder = attachment.getBodyDecoder();
            if (smartDecoder == null) {
                smartDecoder = new FixedLengthFrameDecoder(postLength);
                attachment.setBodyDecoder(smartDecoder);
            }
            if (smartDecoder.decode(buffer)) {
                request.setFormUrlencoded(new String(smartDecoder.getBuffer().array()));
                attachment.setBodyDecoder(null);
                return true;
            }
            return false;
        }
        return true;
    }
}

