/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util.tokens.impl;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.text.BreakIterator;
import java.util.Locale;
import org.tribuo.util.tokens.Token;
import org.tribuo.util.tokens.Tokenizer;

public class BreakIteratorTokenizer
implements Tokenizer {
    @Config(mandatory=true)
    private String localeStr;
    private Locale locale;
    private BreakIterator breakIterator;
    private CharSequence cs;
    private int start;
    private int startOffset;
    private int endOffset;
    private String token;
    private boolean ready;

    private BreakIteratorTokenizer() {
    }

    public BreakIteratorTokenizer(Locale locale) {
        this.locale = locale;
        this.localeStr = locale.toLanguageTag();
        this.breakIterator = BreakIterator.getWordInstance(locale);
        this.ready = false;
        this.cs = null;
    }

    public void postConfig() {
        this.locale = Locale.forLanguageTag(this.localeStr);
        this.breakIterator = BreakIterator.getWordInstance(this.locale);
        this.ready = false;
        this.cs = null;
    }

    public String getLanguageTag() {
        return this.localeStr;
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "Tokenizer");
    }

    @Override
    public void reset(CharSequence cs) {
        this.cs = cs;
        this.breakIterator.setText(cs.toString());
        this.start = this.breakIterator.first();
        this.startOffset = -1;
        this.endOffset = -1;
        this.token = null;
        this.ready = false;
    }

    @Override
    public boolean advance() {
        if (this.cs == null) {
            throw new IllegalStateException("BreakIteratorTokenizer has not been reset.");
        }
        int end = this.breakIterator.next();
        while (end != -1) {
            this.token = this.cs.subSequence(this.start, end).toString();
            this.startOffset = this.start;
            this.endOffset = end;
            this.start = end;
            if (!this.token.trim().isEmpty()) {
                this.ready = true;
                return true;
            }
            end = this.breakIterator.next();
        }
        return false;
    }

    @Override
    public String getText() {
        if (this.ready) {
            return this.token;
        }
        throw new IllegalStateException("BreakIteratorTokenizer is not ready.");
    }

    @Override
    public int getStart() {
        if (this.ready) {
            return this.startOffset;
        }
        throw new IllegalStateException("BreakIteratorTokenizer is not ready.");
    }

    @Override
    public int getEnd() {
        if (this.ready) {
            return this.endOffset;
        }
        throw new IllegalStateException("BreakIteratorTokenizer is not ready.");
    }

    @Override
    public Token.TokenType getType() {
        if (this.ready) {
            return Token.TokenType.WORD;
        }
        throw new IllegalStateException("BreakIteratorTokenizer is not ready.");
    }

    @Override
    public BreakIteratorTokenizer clone() {
        try {
            BreakIteratorTokenizer copy = (BreakIteratorTokenizer)super.clone();
            copy.postConfig();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)"BreakIteratorTokenizer is Cloneable, but clone call failed");
        }
    }
}

