/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.util.tokens.impl;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.Arrays;
import org.tribuo.util.tokens.Token;
import org.tribuo.util.tokens.Tokenizer;

public class SplitCharactersTokenizer
implements Tokenizer {
    public static final char[] DEFAULT_SPLIT_CHARACTERS = new char[]{'*', '(', ')', '&', '[', ']', '{', '}', '`', '\'', '|', ';', ':', '\\', '!', '-', '?'};
    public static final char[] DEFAULT_SPLIT_EXCEPTING_IN_DIGITS_CHARACTERS = new char[]{'.', ',', '/'};
    @Config(description="The characters to split on.")
    private char[] splitCharacters = DEFAULT_SPLIT_CHARACTERS;
    @Config(description="The characters to split on unless we're in a number.")
    private char[] splitXDigitsCharacters = DEFAULT_SPLIT_EXCEPTING_IN_DIGITS_CHARACTERS;
    private CharSequence cs;
    private int start;
    private int end;
    private int p;
    private StringBuilder token = new StringBuilder();
    private boolean ready;

    public SplitCharactersTokenizer() {
    }

    public SplitCharactersTokenizer(char[] splitCharacters, char[] splitXDigitsCharacters) {
        this.splitCharacters = splitCharacters;
        this.splitXDigitsCharacters = splitXDigitsCharacters;
    }

    public static SplitCharactersTokenizer createWhitespaceTokenizer() {
        return new SplitCharactersTokenizer(new char[0], new char[0]);
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "Tokenizer");
    }

    @Override
    public void reset(CharSequence cs) {
        this.cs = cs;
        this.start = -1;
        this.end = -1;
        this.p = 0;
        this.token.delete(0, this.token.length());
        this.ready = false;
    }

    @Override
    public boolean advance() {
        if (this.cs == null) {
            throw new IllegalStateException("SplitCharactersTokenizer has not been reset.");
        }
        if (this.p >= this.cs.length()) {
            return false;
        }
        this.token.delete(0, this.token.length());
        while (this.p < this.cs.length()) {
            char c = this.cs.charAt(this.p);
            boolean keepCharacter = !this.isSplitCharacter(c) && (!this.isSplitXDigitCharacter(c) || this.p != 0 && this.p != this.cs.length() - 1 && Character.isDigit(this.cs.charAt(this.p - 1)) && Character.isDigit(this.cs.charAt(this.p + 1)));
            ++this.p;
            if (keepCharacter) {
                if (this.token.length() == 0) {
                    this.start = this.p - 1;
                }
                this.token.append(c);
                this.end = this.p;
            }
            if (keepCharacter || this.token.length() <= 0) continue;
            break;
        }
        if (this.token.length() > 0) {
            this.ready = true;
            return true;
        }
        return false;
    }

    @Override
    public String getText() {
        if (this.ready) {
            return this.token.toString();
        }
        throw new IllegalStateException("SplitCharactersTokenizer is not ready.");
    }

    @Override
    public int getStart() {
        if (this.ready) {
            return this.start;
        }
        throw new IllegalStateException("SplitCharactersTokenizer is not ready.");
    }

    @Override
    public int getEnd() {
        if (this.ready) {
            return this.end;
        }
        throw new IllegalStateException("SplitCharactersTokenizer is not ready.");
    }

    @Override
    public Token.TokenType getType() {
        if (this.ready) {
            return Token.TokenType.WORD;
        }
        throw new IllegalStateException("SplitCharactersTokenizer is not ready.");
    }

    @Override
    public SplitCharactersTokenizer clone() {
        try {
            SplitCharactersTokenizer copy = (SplitCharactersTokenizer)super.clone();
            copy.token = new StringBuilder();
            copy.splitCharacters = this.splitCharacters == null ? null : Arrays.copyOf(this.splitCharacters, this.splitCharacters.length);
            copy.splitXDigitsCharacters = this.splitXDigitsCharacters == null ? null : Arrays.copyOf(this.splitXDigitsCharacters, this.splitXDigitsCharacters.length);
            copy.ready = false;
            copy.cs = null;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)"SplitCharactersTokenizer is Cloneable, but clone call failed");
        }
    }

    public boolean isSplitCharacter(char c) {
        return this.isCharacter(c, this.splitCharacters) || Character.isWhitespace(c);
    }

    public boolean isSplitXDigitCharacter(char c) {
        return this.isCharacter(c, this.splitXDigitsCharacters);
    }

    private boolean isCharacter(char c, char[] chars) {
        if (chars == null) {
            return false;
        }
        for (char ch : chars) {
            if (ch != c) continue;
            return true;
        }
        return false;
    }

    public char[] getSplitCharacters() {
        return Arrays.copyOf(this.splitCharacters, this.splitCharacters.length);
    }

    public char[] getSplitXDigitsCharacters() {
        return Arrays.copyOf(this.splitXDigitsCharacters, this.splitXDigitsCharacters.length);
    }
}

