/*
 * Decompiled with CFR 0.152.
 */
package net.gbicc.xbrl.conformance;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.gbicc.xbrl.conformance.ConformanceTest;
import net.gbicc.xbrl.conformance.TestCaseInfo;
import net.gbicc.xbrl.conformance.TestProgressListener;
import net.gbicc.xbrl.core.XbrlEnviroment;
import net.gbicc.xbrl.core.conformance.TestSession;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConformanceApplication {
    public static TestCaseInfo testEntryFile(File entry, String outputDir, String lang, TestProgressListener listener) throws IOException, InvalidFormatException {
        return ConformanceApplication.testEntryFile(entry, outputDir, lang, listener, false);
    }

    public static TestCaseInfo testEntryFile(File entry, String outputDir, String lang, TestProgressListener listener, boolean raiseDefaultAssertionMessage) throws IOException, InvalidFormatException {
        if (entry != null && entry.isFile() && entry.exists() && TestSession.isTestEntry((String)entry.getCanonicalPath())) {
            ExecutorService executor;
            TestCaseInfo caseInfo = new TestCaseInfo(entry.getCanonicalPath());
            ConformanceTest test = new ConformanceTest(entry.getCanonicalPath(), lang, listener, raiseDefaultAssertionMessage);
            test.executor = executor = XbrlEnviroment.ParallelEnabled ? Executors.newFixedThreadPool(XbrlEnviroment.parallelCount()) : null;
            test.setOutputDir(outputDir);
            caseInfo.setOutputFile(test.run());
            return caseInfo;
        }
        return null;
    }

    public static List<TestCaseInfo> testDir(File dir, String outputDir, String lang, TestProgressListener listener) throws InvalidFormatException, IOException {
        return ConformanceApplication.testDir(dir, outputDir, lang, listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TestCaseInfo> testDir(File dir, String outputDir, String lang, TestProgressListener listener, boolean raiseDefaultAssertionMesssage) throws InvalidFormatException, IOException {
        ExecutorService executor = XbrlEnviroment.ParallelEnabled ? Executors.newFixedThreadPool(XbrlEnviroment.parallelCount()) : null;
        ArrayList<TestCaseInfo> cases = null;
        try {
            TestFileFilter filter = new TestFileFilter();
            for (File subFileOrDir : dir.listFiles()) {
                File[] files;
                if (subFileOrDir.isFile()) {
                    if (!TestSession.isTestEntry((String)subFileOrDir.getCanonicalPath())) continue;
                    if (cases == null) {
                        cases = new ArrayList<TestCaseInfo>();
                    }
                    TestCaseInfo caseInfo = new TestCaseInfo(subFileOrDir.getCanonicalPath());
                    cases.add(caseInfo);
                    ConformanceTest test = new ConformanceTest(subFileOrDir.getCanonicalPath(), lang, listener, raiseDefaultAssertionMesssage);
                    test.executor = executor;
                    test.setOutputDir(outputDir);
                    caseInfo.setOutputFile(test.run());
                    continue;
                }
                if (!subFileOrDir.isDirectory() || (files = subFileOrDir.listFiles(filter)) == null) continue;
                for (File xmlFile : files) {
                    if (cases == null) {
                        cases = new ArrayList();
                    }
                    TestCaseInfo caseInfo = new TestCaseInfo(xmlFile.getCanonicalPath());
                    cases.add(caseInfo);
                    ConformanceTest test = new ConformanceTest(xmlFile.getCanonicalPath(), lang, listener, raiseDefaultAssertionMesssage);
                    test.setOutputDir(outputDir);
                    test.executor = executor;
                    caseInfo.setOutputFile(test.run());
                }
            }
            File[] fileArray = cases;
            return fileArray;
        }
        finally {
            if (executor != null) {
                executor.shutdown();
            }
        }
    }

    public static void main(String[] args) throws IOException, InvalidFormatException {
        StopWatch _stopwatch;
        block10: {
            File dir;
            String lang;
            String outputDir;
            block8: {
                String fileName;
                block9: {
                    File outFile;
                    _stopwatch = new StopWatch();
                    _stopwatch.start();
                    fileName = null;
                    outputDir = null;
                    lang = null;
                    try {
                        Options confOptions = new Options();
                        confOptions.addOption("h", false, "\u6253\u5370\u6b64\u5e2e\u52a9\u4fe1\u606f");
                        confOptions.addOption("testCase", true, "\u6d4b\u8bd5\u7b26\u5408\u6027\uff08\u517c\u5bb9\u6027\uff09\u6d4b\u8bd5\u7684\u5165\u53e3\u6587\u4ef6\u6216\u76ee\u5f55\uff0c\u5982\u679c\u4e0d\u8bbe\u7f6e\uff0c\u9996\u5148\u626b\u63cf\u5f53\u524d\u76ee\u5f55; \u5982\u679c\u627e\u4e0d\u5230\u5c06\u7ee7\u7eed\u626b\u63cf C:\\XBRL\\CAS-CONF\u76ee\u5f55.");
                        confOptions.addOption("output", true, "\u8bbe\u7f6e\u6d4b\u8bd5\u7ed3\u679c\u7684\u8f93\u51fa\u76ee\u5f55\uff0c\u9ed8\u8ba4\uff1a\u7528\u6237\u4e34\u65f6\u76ee\u5f55\u4e0b\u7684Conformance\u5b50\u76ee\u5f55.");
                        confOptions.addOption("lang", true, "\u8bbe\u7f6e\u6d88\u606f\u7684\u9ed8\u8ba4\u8bed\u8a00\uff0c\u9ed8\u8ba4\uff1a\u6839\u636e\u7cfb\u7edf\u73af\u5883\u5224\u65ad.");
                        BasicParser parser = new BasicParser();
                        CommandLine cl = parser.parse(confOptions, args);
                        if (cl.hasOption('h')) {
                            HelpFormatter f = new HelpFormatter();
                            f.printHelp("\u53ef\u9009\u53c2\u6570", confOptions);
                            return;
                        }
                        fileName = cl.getOptionValue("testCase");
                        outputDir = cl.getOptionValue("output");
                        lang = cl.getOptionValue("lang");
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    if (StringUtils.isEmpty(outputDir)) {
                        outputDir = System.getProperty("java.io.tmpdir");
                        outputDir = StringUtils.isEmpty((String)outputDir) ? (SystemUtils.IS_OS_WINDOWS ? "C:\\Temp\\Conformance" : "/tmp/conformance") : outputDir + File.separator + "Conformance";
                    }
                    if (!(outFile = new File(outputDir)).exists()) {
                        outFile.mkdirs();
                    }
                    if (fileName == null) break block8;
                    File tFile = new File(fileName);
                    if (!tFile.exists()) {
                        System.out.println("File: " + fileName + " not found.");
                        return;
                    }
                    if (!tFile.isFile()) break block9;
                    String fullName = tFile.getCanonicalPath();
                    ConformanceTest test = new ConformanceTest(fullName, lang, null, false);
                    test.setOutputDir(outputDir);
                    test.run();
                    break block10;
                }
                dir = new File(fileName);
                if (!dir.exists()) break block10;
                ConformanceApplication.testDir(dir, outputDir, lang, null);
                break block10;
            }
            List<TestCaseInfo> count = ConformanceApplication.testDir(new File("."), outputDir, lang, null);
            if ((count == null || count.size() == 0) && (dir = new File("C:\\XBRL\\CAS-CONF")).exists() && (count = ConformanceApplication.testDir(dir, outputDir, lang, null)) != null) {
                for (TestCaseInfo caseInfo : count) {
                    System.out.println(caseInfo.getOutputFile());
                }
            }
        }
        _stopwatch.split();
        throw new RuntimeException("Uncompilable source code - Erroneous sym type: system.io.Console.WriteLine");
    }

    static {
        throw new RuntimeException("Uncompilable source code - \u7a0b\u5e8f\u5305system.io\u4e0d\u5b58\u5728");
    }

    private static class TestFileFilter
    implements FilenameFilter {
        private TestFileFilter() {
        }

        public boolean accept(File dir, String name) {
            if (name != null && name.endsWith(".xml")) {
                File xmlFile = new File(dir, name);
                try {
                    return TestSession.isTestEntry((String)xmlFile.getCanonicalPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }

        static {
            throw new RuntimeException("Uncompilable source code - \u7a0b\u5e8f\u5305system.io\u4e0d\u5b58\u5728");
        }
    }
}

