/*
 * Decompiled with CFR 0.152.
 */
package net.gbicc.xbrl.conformance;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import net.gbicc.xbrl.conformance.TestProgressListener;
import net.gbicc.xbrl.core.LogWatch;
import net.gbicc.xbrl.core.XbrlDocument;
import net.gbicc.xbrl.core.conformance.AbstractNode;
import net.gbicc.xbrl.core.conformance.ITestTarget;
import net.gbicc.xbrl.core.conformance.TestCase;
import net.gbicc.xbrl.core.conformance.TestCaseDocument;
import net.gbicc.xbrl.core.conformance.TestSession;
import net.gbicc.xbrl.core.conformance.Variation;
import net.gbicc.xbrl.core.conformance.api.VariationOutput;
import net.gbicc.xbrl.core.formula.IAssertionResult;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import system.qizx.api.QName;
import system.qizx.xdm.XdmComment;
import system.qizx.xdm.XdmDocument;
import system.qizx.xdm.XdmElement;
import system.qizx.xdm.XdmNode;

class ConformanceTest {
    private String testCaseFileName;
    private String testCaseFileDirsParent;
    private int rowIndex;
    private Workbook xlWorkbook;
    private Sheet activeSheet;
    private CellStyle centerStyle;
    private CellStyle errorStyle;
    private File outputDir;
    private CreationHelper createHelper;
    private CellStyle hlink_style;
    private String testName;
    private boolean _pass = true;
    ExecutorService executor;
    private TestProgressListener listener;
    private boolean _raiseDefaultAssertionMessage;
    private String _today;
    private String lang;
    private Cell titleCell;
    private boolean[] testCaseKind = new boolean[]{true, false, false, false, false, false};
    private XdmDocument _resultXml;
    private String _resultXmlFile;
    private Stack<XdmElement> _resultStack = new Stack();
    private String _resultSubdir;

    public void setOutputDir(String dir) {
        this.outputDir = new File(dir);
    }

    private String getOutputFile(String srcFile) throws IOException {
        File f = new File(this.outputDir, srcFile.replace(this.testCaseFileDirsParent, ""));
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        return f.getCanonicalPath();
    }

    private String getOutputFileV2(String srcFile) throws IOException {
        int index = srcFile.lastIndexOf(92);
        if (index == -1) {
            index = srcFile.lastIndexOf(47);
        }
        String shortName = srcFile.substring(index + 1);
        File f = new File(this.outputDir, this._resultSubdir + File.separator + shortName);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        return f.getCanonicalPath();
    }

    ConformanceTest(String fileName, String lang, TestProgressListener listener, boolean raiseDefaultAssertionMessage) {
        this.listener = listener;
        this.testCaseFileName = fileName;
        this.testName = new File(this.testCaseFileName).getParentFile().getName();
        this.testCaseFileDirsParent = new File(this.testCaseFileName).getParentFile().getParent();
        this.lang = lang;
        Date today = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        this._today = sdf.format(today);
        this._raiseDefaultAssertionMessage = raiseDefaultAssertionMessage;
    }

    String run() throws InvalidFormatException, IOException {
        this.rowIndex = 1;
        this.xlWorkbook = new XSSFWorkbook();
        this.activeSheet = this.xlWorkbook.createSheet();
        this.xlWorkbook.setSheetName(0, "\u6d4b\u8bd5\u7ed3\u679c");
        this.createHelper = this.xlWorkbook.getCreationHelper();
        this.hlink_style = this.xlWorkbook.createCellStyle();
        Font hlink_font = this.xlWorkbook.createFont();
        hlink_font.setUnderline((byte)1);
        hlink_font.setColor(IndexedColors.BLUE.getIndex());
        this.hlink_style.setFont(hlink_font);
        this._resultXml = new XdmDocument();
        XdmElement root = this._resultXml.createElement("testcases");
        this._resultXml.appendChild((XdmNode)root);
        this._resultStack.add(root);
        this.createHeader();
        TestSession session = new TestSession();
        session.open(this.testCaseFileName);
        if (this.testCaseFileName.endsWith("xbrl.xml") || this.testCaseFileName.contains("XBRL GB Part1-Base Conformance Suite")) {
            this.testCaseKind[0] = true;
        } else if (this.testCaseFileName.endsWith("xdt.xml") || this.testCaseFileName.contains("XBRL GB Part2-Dimensions Conformance Suite")) {
            this.testCaseKind[1] = true;
        } else if (this.testCaseFileName.contains("XBRL GB Part3-Formula Conformance Suite")) {
            this.testCaseKind[2] = true;
        }
        this.test(session);
        for (int k = 4; k > -1; --k) {
            if (!this.testCaseKind[k]) continue;
            if (k == 2) {
                this.titleCell.setCellValue("\u88683\uff1a\u300a\u53ef\u6269\u5c55\u5546\u4e1a\u62a5\u544a\u8bed\u8a00(XBRL)\u6280\u672f\u89c4\u8303\u7b2c3\u90e8\u5206\uff1a\u516c\u5f0f\u300b\u7b26\u5408\u6027\u6d4b\u8bd5\u7ed3\u679c\u660e\u7ec6\u8868");
                this._resultXmlFile = "formula_result_" + this._today + ".xml";
                root.setAttribute("type", "formula");
                break;
            }
            if (k == 1) {
                this.titleCell.setCellValue("\u88682\uff1a\u300a\u53ef\u6269\u5c55\u5546\u4e1a\u62a5\u544a\u8bed\u8a00(XBRL)\u6280\u672f\u89c4\u8303\u7b2c2\u90e8\u5206\uff1a\u7ef4\u5ea6\u300b\u7b26\u5408\u6027\u6d4b\u8bd5\u7ed3\u679c\u660e\u7ec6\u8868");
                this._resultXmlFile = "dimensions_result" + this._today + ".xml";
                root.setAttribute("type", "dimensions");
                break;
            }
            if (k != 0) continue;
            this.titleCell.setCellValue("\u88681\uff1a\u300a\u53ef\u6269\u5c55\u5546\u4e1a\u62a5\u544a\u8bed\u8a00(XBRL)\u6280\u672f\u89c4\u8303\u7b2c1\u90e8\u5206\uff1a\u57fa\u7840\u300b\u7b26\u5408\u6027\u6d4b\u8bd5\u7ed3\u679c\u660e\u7ec6\u8868");
            this._resultXmlFile = "base_result_" + this._today + ".xml";
            root.setAttribute("type", "base");
            break;
        }
        if (!this.outputDir.exists()) {
            this.outputDir.mkdirs();
        }
        File testResult = new File(this.outputDir, this.testName + "-" + (this._pass ? "PASS" : "NOPASS") + ".xlsx");
        System.out.println("\u6d4b\u8bd5\u7ed3\u679c\uff1a" + testResult.getCanonicalPath());
        FileOutputStream out = new FileOutputStream(testResult);
        this.xlWorkbook.write((OutputStream)out);
        out.flush();
        out.close();
        try {
            File resultFile = new File(this.outputDir, this._resultXmlFile);
            if (resultFile.exists()) {
                resultFile.delete();
            }
            this._resultXml.save(resultFile.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return testResult.getCanonicalPath();
    }

    private void createHeader() {
        Row currRow = this.activeSheet.createRow(0);
        this.titleCell = currRow.createCell(0, 1);
        this.titleCell.setCellValue("\u300a\u53ef\u6269\u5c55\u5546\u4e1a\u62a5\u544a\u8bed\u8a00(XBRL)\u300b\u7b26\u5408\u6027\u6d4b\u8bd5\u7ed3\u679c\u660e\u7ec6\u8868");
        CellRangeAddress region = new CellRangeAddress(0, 0, 0, 5);
        this.activeSheet.addMergedRegion(region);
        CellStyle titleStyle = this.xlWorkbook.createCellStyle();
        titleStyle.setAlignment((short)2);
        titleStyle.setVerticalAlignment((short)1);
        Font titleFont = this.xlWorkbook.createFont();
        titleFont.setBoldweight((short)700);
        titleFont.setFontHeightInPoints((short)14);
        titleStyle.setFont(titleFont);
        this.titleCell.setCellStyle(titleStyle);
        currRow.setHeightInPoints(34.5f);
        currRow = this.activeSheet.createRow(1);
        Cell indexCell = currRow.createCell(0, 1);
        indexCell.setCellValue("\u5e8f\u53f7");
        Cell labelCell = currRow.createCell(1, 1);
        labelCell.setCellValue("\u6d4b\u8bd5\u6848\u4f8b\u540d\u79f0");
        Cell expCell = currRow.createCell(2, 1);
        expCell.setCellValue("\u53d8\u5f0f\u540d\u79f0");
        Cell runCell = currRow.createCell(3, 1);
        runCell.setCellValue("\u9884\u671f\u6d4b\u8bd5\u7ed3\u679c(\u662f\u5426\u6709\u6548\u3001\u9519\u8bef\u63d0\u793a\u3001\u6d4b\u8bd5\u53c2\u8003\u7ed3\u679c\u6587\u4ef6\u7b49)");
        Cell passCell = currRow.createCell(4, 1);
        passCell.setCellValue("\u5b9e\u9645\u6d4b\u8bd5\u7ed3\u679c(\u662f\u5426\u6709\u6548\u3001\u5b9e\u9645\u6d4b\u8bd5\u63d0\u793a\u3001\u5b9e\u9645\u6d4b\u8bd5\u7ed3\u679c\u6587\u4ef6\u7b49)");
        Cell passCell2 = currRow.createCell(5, 1);
        passCell2.setCellValue("\u6d4b\u8bd5\u7ed3\u8bba");
        CellStyle style = this.xlWorkbook.createCellStyle();
        style.setAlignment((short)2);
        style.setWrapText(true);
        style.setVerticalAlignment((short)1);
        currRow.getCell(0).setCellStyle(style);
        currRow.getCell(1).setCellStyle(style);
        currRow.getCell(2).setCellStyle(style);
        currRow.getCell(3).setCellStyle(style);
        currRow.getCell(4).setCellStyle(style);
        this.centerStyle = this.xlWorkbook.createCellStyle();
        this.centerStyle.setAlignment((short)2);
        this.centerStyle.setVerticalAlignment((short)1);
        this.errorStyle = this.xlWorkbook.createCellStyle();
        this.errorStyle.setAlignment((short)2);
        this.errorStyle.setVerticalAlignment((short)1);
        Font error_font = this.xlWorkbook.createFont();
        error_font.setColor(IndexedColors.RED.getIndex());
        this.errorStyle.setFont(error_font);
        this.activeSheet.setColumnWidth(0, 1536);
        this.activeSheet.setColumnWidth(1, 5888);
        this.activeSheet.setColumnWidth(2, 5888);
        this.activeSheet.setColumnWidth(3, 6656);
        this.activeSheet.setColumnWidth(4, 6656);
        this.activeSheet.setColumnWidth(5, 2048);
    }

    private void testVariation(Variation v) throws IOException {
        Object instance;
        VariationOutput output;
        if (this.listener != null) {
            this.listener.process(v.getLabel());
        }
        if ((output = v.run(this.executor, this.lang)).isFormulaCase()) {
            this.testCaseKind[2] = true;
        } else if (output.isDimensionCase()) {
            this.testCaseKind[1] = true;
        } else if (output.isXbrl21()) {
            this.testCaseKind[0] = true;
        }
        if (this.testCaseKind[2]) {
            this._resultSubdir = "formula_out";
        } else if (this.testCaseKind[1]) {
            this._resultSubdir = "dimensions_out";
        } else if (this.testCaseKind[0]) {
            this._resultSubdir = "base_out";
        }
        XdmElement ve = this._resultXml.createElement("variation");
        this._resultStack.peek().appendChild((XdmNode)ve);
        ve.setAttribute("id", v.getId());
        XdmElement result = this._resultXml.createElement("result");
        ve.appendChild((XdmNode)result);
        ++this.rowIndex;
        Row currRow = this.activeSheet.createRow(this.rowIndex);
        Cell indexCell = currRow.createCell(0, 0);
        indexCell.setCellValue((double)this.rowIndex);
        indexCell.setCellStyle(this.centerStyle);
        Cell labelCell = currRow.createCell(2, 1);
        labelCell.setCellValue(v.getLabel());
        if (!StringUtils.isEmpty((String)output.getEntryFile())) {
            Hyperlink link = this.createHelper.createHyperlink(1);
            throw new RuntimeException("Uncompilable source code - Erroneous ctor sym type: <any>");
        }
        String description = v.getDescription();
        if (!StringUtils.isEmpty((String)description)) {
            Drawing drawing = this.activeSheet.createDrawingPatriarch();
            ClientAnchor anchor = this.createHelper.createClientAnchor();
            anchor.setCol1(labelCell.getColumnIndex());
            anchor.setCol2(labelCell.getColumnIndex() + 3);
            anchor.setRow1(currRow.getRowNum());
            anchor.setRow2(currRow.getRowNum() + 6);
            Comment comment = drawing.createCellComment(anchor);
            RichTextString str = this.createHelper.createRichTextString(description);
            comment.setString(str);
            labelCell.setCellComment(comment);
        }
        Cell expCell = currRow.createCell(3, 1);
        expCell.setCellValue(v.getResutAsString());
        if (v.getResult() != null && v.getResult().getResultFile() != null) {
            Hyperlink link = this.createHelper.createHyperlink(1);
            URI remote = new File(v.getResult().getResultFile().getAbsolutePath()).toURI();
            String address = this.outputDir.toURI().relativize(remote).toASCIIString();
            link.setAddress(address);
            expCell.setHyperlink(link);
            expCell.setCellStyle(this.hlink_style);
        }
        if (v.getResult() != null && v.getResult().isExpected() || v.getResult() == null) {
            String vo = output.foundErrors() ? "invalid" : "valid";
            result.setAttribute("verify", vo);
        }
        Cell runCell = currRow.createCell(4, 1);
        String trace = output.getTrace();
        String outputInstanceFile = null;
        if (output.getOutputInstance() != null) {
            instance = v.getResult().getExpectedInstance();
            if (instance != null) {
                outputInstanceFile = this.getOutputFileV2(instance.getAbsolutePath());
            } else {
                XbrlDocument xbrlDocument = output.getOutputInstance().getOwnerDocument();
                XdmComment comment = xbrlDocument.createComment("GBICC XBRL Process Engine (XBRL-CORE) " + Variation.sdt.format(new Date()));
                xbrlDocument.prependChild((XdmNode)comment);
            }
            if (outputInstanceFile == null) {
                throw new RuntimeException("Uncompilable source code - Erroneous sym type: system.web.HttpUtility.toLocalPath");
            }
            output.getOutputInstance().getOwnerDocument().save(outputInstanceFile);
            String string = new File(outputInstanceFile).getName();
            trace = StringUtils.isEmpty((String)trace) ? string : trace + string;
            Hyperlink link = this.createHelper.createHyperlink(1);
            String address = this.outputDir.toURI().relativize(new File(outputInstanceFile).toURI()).toASCIIString();
            link.setAddress(address);
            runCell.setHyperlink(link);
            runCell.setCellStyle(this.hlink_style);
        }
        if (outputInstanceFile != null && v.getResult() != null && v.getResult().getExpectedInstance() != null) {
            instance = this._resultXml.createElement("instance");
            String string = outputInstanceFile.replace(this.outputDir.getAbsolutePath(), "");
            String outFile = string.startsWith("\\") ? string.substring(1) : string;
            instance.setInnerText(outFile);
            result.appendChild((XdmNode)instance);
        }
        if (v.getResult() != null && v.getResult().hasAssertionTest()) {
            for (Map.Entry entry : output.getAssertionResults().entrySet()) {
                XdmElement assertionTests = this._resultXml.createElement("assertionTests");
                result.appendChild((XdmNode)assertionTests);
                assertionTests.setAttribute("assertionID", ((IAssertionResult)entry.getValue()).getAssertionID());
                assertionTests.setAttribute("countSatisfied", Integer.toString(((IAssertionResult)entry.getValue()).getCountSatisfied()));
                assertionTests.setAttribute("countNotSatisfied", Integer.toString(((IAssertionResult)entry.getValue()).getCountNotSatisfied()));
            }
        }
        if (v.getResult() != null && v.getResult().getResultFile() != null) {
            throw new RuntimeException("Uncompilable source code - Erroneous sym type: system.web.HttpUtility.toLocalPath");
        }
        runCell.setCellValue(trace);
        if (v.getResult() != null && !v.getResult().isExpected() && output.isNamedErrorOccured()) {
            boolean expFound = false;
            QName qName = v.getResult().getErrorQName();
            if (qName != null && !qName.isEmpty() && output.hasError(qName)) {
                expFound = true;
                XdmElement errorE = this._resultXml.createElement("error");
                result.appendChild((XdmNode)errorE);
                errorE.setInnerText(v.getResult().getErrorPrefixedName(qName));
            }
            if (!expFound) {
                for (QName ecode : output.getOccuredErrors()) {
                    XdmElement errorE = this._resultXml.createElement("error");
                    result.appendChild((XdmNode)errorE);
                    errorE.setInnerText(v.getResult().getErrorPrefixedName(ecode));
                }
            }
        }
        Cell passCell = currRow.createCell(5, 1);
        passCell.setCellValue(v.getTestResult() != false ? "\u901a\u8fc7" : "\u5931\u8d25");
        passCell.setCellStyle(v.getTestResult() != false ? this.centerStyle : this.errorStyle);
        this._pass = this._pass && v.getTestResult() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTarget(ITestTarget target, int indent) throws IOException {
        if (target instanceof Variation) {
            this.testVariation((Variation)target);
        } else {
            int index;
            String uri;
            ++this.rowIndex;
            Row currRow = this.activeSheet.createRow(this.rowIndex);
            Cell indexCell = currRow.createCell(0, 0);
            indexCell.setCellValue((double)this.rowIndex);
            indexCell.setCellStyle(this.centerStyle);
            target.getChildren();
            Cell labelCell = currRow.createCell(1, 1);
            labelCell.setCellValue(target.getLabel());
            String description = target.getDescription();
            if (!StringUtils.isEmpty((String)description)) {
                Drawing drawing = this.activeSheet.createDrawingPatriarch();
                ClientAnchor anchor = this.createHelper.createClientAnchor();
                anchor.setCol1(labelCell.getColumnIndex());
                anchor.setCol2(labelCell.getColumnIndex() + 3);
                anchor.setRow1(currRow.getRowNum());
                anchor.setRow2(currRow.getRowNum() + 6);
                Comment comment = drawing.createCellComment(anchor);
                if (target instanceof TestCase) {
                    TestCase tc = (TestCase)target;
                    uri = tc.getUri();
                    index = uri.lastIndexOf("\\");
                    if (index == -1) {
                        index = uri.lastIndexOf("/");
                    }
                    if (index != -1) {
                        uri = uri.substring(index + 1);
                    }
                    description = description + " File: " + uri;
                    try {
                        Hyperlink link = this.createHelper.createHyperlink(1);
                        URI remote = new File(tc.getAbsoluteUri()).toURI();
                        String address = this.outputDir.toURI().relativize(remote).toASCIIString();
                        link.setAddress(address);
                        labelCell.setHyperlink(link);
                    }
                    catch (Exception ex) {
                        LogWatch.error((Object)ex);
                    }
                }
                RichTextString str = this.createHelper.createRichTextString(description);
                comment.setString(str);
                labelCell.setCellComment(comment);
            }
            if (indent != 0) {
                CellStyle style = this.xlWorkbook.createCellStyle();
                style.setIndention((short)indent);
                labelCell.setCellStyle(style);
            }
            for (AbstractNode e : target.getChildren()) {
                TestCase tc;
                if (!(e instanceof ITestTarget)) continue;
                TestCase testCase = tc = e instanceof TestCase ? (TestCase)e : null;
                if (tc != null) {
                    tc.getChildren();
                    XdmElement tcase = this._resultXml.createElement("testcase");
                    this._resultStack.peek().appendChild((XdmNode)tcase);
                    this._resultStack.add(tcase);
                    uri = tc.getUri();
                    if (uri == null) continue;
                    index = uri.lastIndexOf("\\");
                    if (index == -1) {
                        index = uri.lastIndexOf("/");
                    }
                    if (index != -1) {
                        uri = uri.substring(index + 1);
                    }
                    tcase.setAttribute("fileName", uri);
                }
                try {
                    this.testTarget((ITestTarget)e, indent + 1);
                }
                finally {
                    if (tc == null) continue;
                    this._resultStack.pop();
                }
            }
        }
    }

    private void test(TestSession session) throws IOException {
        TestCaseDocument _document = session.getDocument();
        if (_document != null && _document.getDocumentElement() != null && _document.getDocumentElement() instanceof ITestTarget) {
            ITestTarget v = (ITestTarget)_document.getDocumentElement();
            this.testTarget(v, 0);
        }
    }

    static {
        throw new RuntimeException("Uncompilable source code - \u7a0b\u5e8f\u5305system.web\u4e0d\u5b58\u5728");
    }
}

