/*
 * Decompiled with CFR 0.152.
 */
package net.gbicc.xbrl.cleaner;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.gbicc.xbrl.cleaner.Cas2015Cleaner;
import net.gbicc.xbrl.cleaner.ChangeConceptInfo;
import net.gbicc.xbrl.cleaner.CleanOption;
import net.gbicc.xbrl.cleaner.Cleaner;
import net.gbicc.xbrl.cleaner.ImportOptions;
import net.gbicc.xbrl.core.Arc;
import net.gbicc.xbrl.core.ArcEnd;
import net.gbicc.xbrl.core.ArcUse;
import net.gbicc.xbrl.core.ArcroleRef;
import net.gbicc.xbrl.core.ArcroleType;
import net.gbicc.xbrl.core.CalculationArc;
import net.gbicc.xbrl.core.Context;
import net.gbicc.xbrl.core.ContextElementType;
import net.gbicc.xbrl.core.Definition;
import net.gbicc.xbrl.core.DefinitionArc;
import net.gbicc.xbrl.core.EndDate;
import net.gbicc.xbrl.core.Entity;
import net.gbicc.xbrl.core.ExtendedLink;
import net.gbicc.xbrl.core.ExtendedLinkSummary;
import net.gbicc.xbrl.core.Fact;
import net.gbicc.xbrl.core.Footnote;
import net.gbicc.xbrl.core.FootnoteLink;
import net.gbicc.xbrl.core.GenericLabel;
import net.gbicc.xbrl.core.IXbrlDocument;
import net.gbicc.xbrl.core.Instant;
import net.gbicc.xbrl.core.Label;
import net.gbicc.xbrl.core.LabelLink;
import net.gbicc.xbrl.core.Linkbase;
import net.gbicc.xbrl.core.LinkbaseRef;
import net.gbicc.xbrl.core.Loc;
import net.gbicc.xbrl.core.Locator;
import net.gbicc.xbrl.core.LogWatch;
import net.gbicc.xbrl.core.OpenContextComponent;
import net.gbicc.xbrl.core.Period;
import net.gbicc.xbrl.core.PeriodType;
import net.gbicc.xbrl.core.PresentationArc;
import net.gbicc.xbrl.core.ProcessContext;
import net.gbicc.xbrl.core.QNameConstants;
import net.gbicc.xbrl.core.Relationship;
import net.gbicc.xbrl.core.RelationshipSet;
import net.gbicc.xbrl.core.Resource;
import net.gbicc.xbrl.core.RoleRef;
import net.gbicc.xbrl.core.RoleType;
import net.gbicc.xbrl.core.RoleTypeCollection;
import net.gbicc.xbrl.core.Scenario;
import net.gbicc.xbrl.core.SchemaRef;
import net.gbicc.xbrl.core.Segment;
import net.gbicc.xbrl.core.StartDate;
import net.gbicc.xbrl.core.TaxonomySet;
import net.gbicc.xbrl.core.Unit;
import net.gbicc.xbrl.core.UsedOn;
import net.gbicc.xbrl.core.UsedOnContainer;
import net.gbicc.xbrl.core.XbrlConcept;
import net.gbicc.xbrl.core.XbrlContentType;
import net.gbicc.xbrl.core.XbrlDocument;
import net.gbicc.xbrl.core.XbrlElement;
import net.gbicc.xbrl.core.XbrlHelper;
import net.gbicc.xbrl.core.XbrlInstance;
import net.gbicc.xbrl.core.XbrlLoader;
import net.gbicc.xbrl.core.XbrlSchema;
import net.gbicc.xbrl.core.XbrlUrlResolver;
import net.gbicc.xbrl.core.dimension.ExplicitMember;
import net.gbicc.xbrl.core.dimension.MemberElement;
import net.gbicc.xbrl.core.dimension.TypedMember;
import net.gbicc.xbrl.core.dimension.XdtCompiledHypercube;
import net.gbicc.xbrl.core.dimension.XdtCompiledMember;
import net.gbicc.xbrl.core.dimension.XdtComponent;
import net.gbicc.xbrl.core.dimension.XdtDRS;
import net.gbicc.xbrl.core.dimension.XdtDimension;
import net.gbicc.xbrl.core.dimension.XdtProcessor;
import net.gbicc.xbrl.core.extensions.CommonExtensions;
import net.gbicc.xbrl.filing.CasProcessor;
import net.gbicc.xbrl.filing.CasRedefineRoleType;
import net.gbicc.xbrl.filing.RoleVersion;
import net.gbicc.xbrl.filing.conv.CasReorderRoleTypes;
import net.gbicc.xbrl.filing.conv.RoleTypeRename;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import system.io.IOHelper;
import system.io.compression.IZipStream;
import system.io.compression.ZipStream;
import system.lang.BigDecimalConstants;
import system.lang.Int32;
import system.lang.MutableInteger;
import system.qizx.api.DataModelException;
import system.qizx.api.EvaluationException;
import system.qizx.api.IXdmSchemaInfo;
import system.qizx.api.Node;
import system.qizx.api.QName;
import system.qizx.xdm.IQName;
import system.qizx.xdm.XdmAttribute;
import system.qizx.xdm.XdmDocument;
import system.qizx.xdm.XdmElement;
import system.qizx.xdm.XdmNode;
import system.qizx.xdm.XdmText;
import system.util.Pair;
import system.web.HttpUtility;
import system.xml.XmlChar;
import system.xml.schema.XmlSchema;
import system.xml.schema.XmlSchemaElement;
import system.xml.schema.XmlSchemaExternal;
import system.xml.schema.XmlSchemaImport;
import system.xml.schema.XmlSchemaObject;
import system.xml.schema.XmlTypeCode;
import system.xml.schema.utils.NamespacePrefixList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasCleaner
extends Cleaner {
    private HashSet<QName> c;
    private Map<QName, List<QName>> d;
    private Map<QName, List<QName>> e;
    private Map<QName, List<Fact>> f;
    public static final String gbicc_URI = "http://report.gbicc.net/xbrl";
    public static final QName customDecimalsQName = IQName.get((String)"http://report.gbicc.net/xbrl", (String)"dec");
    private Set<Object> g;
    private HashSet<QName> h;
    private Map<QName, XbrlConcept> i;
    private Collection<RelationshipSet> j;
    private Collection<RelationshipSet> k;
    private Collection<RelationshipSet> l;
    private boolean m;
    private XbrlConcept n;
    private XbrlConcept o;
    private Collection<String> p = new HashSet<String>();
    private TaxonomySet q;
    private Map<a, Boolean> r;
    private Map<ExtendedLink, String> s;
    private String[] t;
    private Collection<RelationshipSet> u = null;
    private String v;
    protected String cas_NamespaceURI;
    protected String cas_SchemaLocation;
    protected String cas_EntrySchemaLocation;
    protected String cas_NamespaceURI_Part;
    private List<XbrlConcept> w;
    private static final Cleaner.a x = new Cleaner.a();
    private g y;
    private static final BigDecimal[] z = new BigDecimal[]{BigDecimalConstants.valueOf((String)"1"), BigDecimalConstants.valueOf((String)"0.1"), BigDecimalConstants.valueOf((String)"0.01"), BigDecimalConstants.valueOf((String)"0.001"), BigDecimalConstants.valueOf((String)"0.0001"), BigDecimalConstants.valueOf((String)"0.00001")};
    private CleanOption A;
    private HashSet<String> B = new HashSet();
    static final BigDecimal a = new BigDecimal("0.1");
    private Collection<RelationshipSet> C;
    private QName D;
    private QName E;
    private Map<Context, c> F;
    private Map<c, List<Context>> G;
    private Map<e, Object> H = new HashMap<e, Object>();

    public static CasCleaner create(XbrlInstance xbrlInstance, TaxonomySet dts) {
        TaxonomySet taxonomySet;
        TaxonomySet taxonomySet2 = taxonomySet = xbrlInstance != null ? xbrlInstance.getOwnerDTS() : dts;
        if (taxonomySet != null && taxonomySet.getSchema("http://xbrl.mof.gov.cn/taxonomy/2015-03-31/cas") != null) {
            return new Cas2015Cleaner(xbrlInstance, dts);
        }
        return new CasCleaner(xbrlInstance, dts, "CAS");
    }

    @Deprecated
    public CasCleaner(XbrlInstance xbrlInstance, TaxonomySet dts) {
        this(xbrlInstance, dts, "CAS");
    }

    protected CasCleaner(XbrlInstance xbrlInstance, TaxonomySet dts, String version) {
        super(xbrlInstance, dts);
        String string;
        this.initializeCas();
        this.a();
        this.getEntrySchema();
        this.q = dts.getBaseTaxonomySet();
        if (this.q == null) {
            this.t = CasProcessor.getIndustry(dts);
            if (this.t == null || this.t.length == 0) {
                XmlSchema[] xmlSchemaArray = dts.getSchemas();
                int n = xmlSchemaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    string = xmlSchemaArray[n2];
                    String string2 = string.getTargetNamespace();
                    if (string2 != null && string2.startsWith(this.cas_NamespaceURI_Part) && string.getXmlSchemaSet() != this.dts) {
                        TaxonomySet taxonomySet;
                        TaxonomySet taxonomySet2 = taxonomySet = string.getXmlSchemaSet() instanceof TaxonomySet ? (TaxonomySet)string.getXmlSchemaSet() : null;
                        if (taxonomySet != null && taxonomySet.getEntryFile() != null && taxonomySet.getEntryFile().startsWith(this.cas_NamespaceURI_Part)) {
                            this.q = taxonomySet;
                            break;
                        }
                    }
                    ++n2;
                }
            } else {
                XmlSchema[] xmlSchemaArray;
                string = dts.getNamespaceOfPrefix(this.t[0]);
                if (!StringUtils.isEmpty((String)string) && (xmlSchemaArray = dts.getSchemas(string)) != null && xmlSchemaArray.length == 1) {
                    String string3 = xmlSchemaArray[0].getSourceURI();
                    String string4 = string3.replace("_core_", "_entry_point_");
                    XbrlLoader xbrlLoader = XbrlLoader.create((TaxonomySet)dts);
                    xbrlLoader.load(string4);
                    if (xbrlLoader.getDocument(string4) != null) {
                        this.q = xbrlLoader.getActiveDTS();
                    }
                }
            }
        }
        if (this.q == null && dts.getSchemas(this.cas_NamespaceURI).length > 0) {
            string = this.cas_EntrySchemaLocation;
            XbrlLoader xbrlLoader = XbrlLoader.create((TaxonomySet)dts);
            xbrlLoader.load(string);
            this.q = xbrlLoader.getActiveDTS();
        }
    }

    private boolean a(String string, String string2) {
        if (string != null && string2 != null) {
            int n = string.lastIndexOf(47);
            int n2 = string2.lastIndexOf(47);
            if (n != -1 && n2 != -1) {
                return string.substring(0, n).equals(string2.substring(0, n2));
            }
            n = string.lastIndexOf(92);
            n2 = string2.lastIndexOf(92);
            if (n != -1 && n2 != -1) {
                return string.substring(0, n).equals(string2.substring(0, n2));
            }
        }
        return false;
    }

    private void a() {
        if (StringUtils.isEmpty((String)this.extendNamespaceURI)) {
            if (this.xbrlInstance != null) {
                XdmNode xdmNode = this.xbrlInstance.getFirstChild();
                while (xdmNode != null) {
                    SchemaRef schemaRef;
                    IXbrlDocument iXbrlDocument;
                    if (xdmNode instanceof SchemaRef && (iXbrlDocument = this.dts.getDocument((schemaRef = (SchemaRef)xdmNode).getDiscoveredUri(null))) != null && iXbrlDocument instanceof XbrlSchema && (!iXbrlDocument.isReadOnly() || this.a(iXbrlDocument.getBaseURI(), this.xbrlInstance.getOwnerDocument().getBaseURI()))) {
                        this.extendNamespaceURI = ((XbrlSchema)iXbrlDocument).getTargetNamespace();
                        break;
                    }
                    xdmNode = xdmNode.getNextSibling();
                }
            } else {
                IXbrlDocument iXbrlDocument = this.dts.getDocument(this.dts.getEntryFile());
                if (iXbrlDocument != null && iXbrlDocument instanceof XbrlSchema && !iXbrlDocument.isReadOnly()) {
                    this.extendNamespaceURI = ((XbrlSchema)iXbrlDocument).getTargetNamespace();
                }
            }
        }
    }

    private boolean a(XbrlInstance xbrlInstance, XbrlConcept xbrlConcept, Iterable<RelationshipSet> iterable, Set<QName> set, Set<QName> set2) {
        if (xbrlConcept != null && iterable != null) {
            HashSet<XbrlConcept> hashSet = new HashSet<XbrlConcept>();
            for (RelationshipSet relationshipSet : iterable) {
                if (this.a(xbrlInstance, xbrlConcept, relationshipSet, set, hashSet, set2)) {
                    return true;
                }
                hashSet.clear();
            }
        }
        return false;
    }

    private boolean a(XbrlConcept xbrlConcept, Collection<RelationshipSet> collection) {
        if (xbrlConcept != null && collection != null && !collection.isEmpty()) {
            for (RelationshipSet relationshipSet : collection) {
                if (!relationshipSet.contains((Object)xbrlConcept)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean a(XbrlInstance xbrlInstance, XbrlConcept xbrlConcept, RelationshipSet relationshipSet, Set<QName> set, Set<XbrlConcept> set2, Set<QName> set3) {
        List list = relationshipSet.getEffectiveChildren((Object)xbrlConcept);
        if (list != null && !list.isEmpty()) {
            for (Relationship relationship : list) {
                XbrlConcept xbrlConcept2 = relationship.toConcept();
                if (xbrlConcept2 == null || set2.contains(xbrlConcept2)) continue;
                set2.add(xbrlConcept2);
                QName qName = xbrlConcept2.getQName();
                if (xbrlConcept2.isDimension()) {
                    if (!this.a(qName, xbrlConcept2, relationshipSet)) continue;
                    this.a(set, relationshipSet, xbrlConcept2);
                    return true;
                }
                if (set3.contains(qName) || !xbrlConcept2.isAbstract() && !xbrlConcept2.isHypercube() && set.contains(qName)) {
                    this.a(set, relationshipSet, xbrlConcept2);
                    return true;
                }
                if (!this.a(xbrlInstance, xbrlConcept2, relationshipSet, set, set2, set3)) continue;
                this.a(set, relationshipSet, xbrlConcept2);
                return true;
            }
        }
        return false;
    }

    private boolean a(XbrlConcept xbrlConcept) {
        QName qName = xbrlConcept.getQName();
        for (XdtDRS xdtDRS : this.dts.getAllDRS().values()) {
            if (!xdtDRS.containsDimension(qName)) continue;
            for (XbrlConcept xbrlConcept2 : xdtDRS.getAllPrimaryItems()) {
                XdtCompiledHypercube[] xdtCompiledHypercubeArray = xdtDRS.tryGetHypercubes(xbrlConcept2);
                if (xdtCompiledHypercubeArray == null) continue;
                boolean bl = false;
                XdtCompiledHypercube[] xdtCompiledHypercubeArray2 = xdtCompiledHypercubeArray;
                int n = xdtCompiledHypercubeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    XdtCompiledHypercube xdtCompiledHypercube = xdtCompiledHypercubeArray2[n2];
                    if (xdtCompiledHypercube.containsDimension(qName)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl || !this.f.containsKey(xbrlConcept2.getQName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean a(QName qName, XbrlConcept xbrlConcept, RelationshipSet relationshipSet) {
        Object object;
        a a2 = new a(qName, relationshipSet);
        if (this.r != null && (object = this.r.get(a2)) != null) {
            return (Boolean)object;
        }
        object = relationshipSet.getRoleURI();
        for (XdtDRS xdtDRS : this.dts.getAllDRS().values()) {
            if (!CasCleaner.isPairURI((String)object, xdtDRS.getRole()) || !xdtDRS.containsDimension(qName)) continue;
            for (XbrlConcept xbrlConcept2 : xdtDRS.getAllPrimaryItems()) {
                XdtCompiledHypercube[] xdtCompiledHypercubeArray = xdtDRS.tryGetHypercubes(xbrlConcept2);
                if (xdtCompiledHypercubeArray == null) continue;
                boolean bl = false;
                XdtCompiledHypercube[] xdtCompiledHypercubeArray2 = xdtCompiledHypercubeArray;
                int n = xdtCompiledHypercubeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    XdtCompiledHypercube xdtCompiledHypercube = xdtCompiledHypercubeArray2[n2];
                    if (xdtCompiledHypercube.containsDimension(qName)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl || !this.f.containsKey(xbrlConcept2.getQName())) continue;
                if (this.r == null) {
                    this.r = new HashMap<a, Boolean>();
                }
                this.r.put(a2, true);
                return true;
            }
        }
        if (this.r == null) {
            this.r = new HashMap<a, Boolean>();
        }
        boolean bl = false;
        for (RelationshipSet relationshipSet2 : this.l) {
            if (!CasCleaner.isPairURI((String)object, relationshipSet2.getRoleURI())) continue;
            bl = true;
            break;
        }
        boolean bl2 = false;
        if (!bl) {
            LogWatch.error((Object)("not definitionLink for @" + (String)object));
            bl2 = this.a(relationshipSet, xbrlConcept, 0);
        }
        this.r.put(a2, bl2);
        return false;
    }

    private boolean a(RelationshipSet relationshipSet, XbrlConcept xbrlConcept, int n) {
        if (n > 100) {
            return false;
        }
        for (Relationship relationship : relationshipSet.getEffectiveChildren((Object)xbrlConcept)) {
            XbrlConcept xbrlConcept2 = relationship.toConcept();
            if (xbrlConcept2 == null) continue;
            if (this.c.contains(xbrlConcept2.getQName())) {
                return true;
            }
            if (!this.a(relationshipSet, xbrlConcept2, n + 1)) continue;
            return true;
        }
        return false;
    }

    private void a(Set<QName> set, RelationshipSet relationshipSet, XbrlConcept xbrlConcept) {
        Collection collection = relationshipSet.getParents((Object)xbrlConcept);
        for (Relationship relationship : collection) {
            XbrlConcept xbrlConcept2 = relationship.fromConcept();
            if (xbrlConcept2 == null) continue;
            set.add(xbrlConcept2.getQName());
        }
    }

    private String b(XbrlConcept xbrlConcept) {
        if (xbrlConcept != null) {
            List list = xbrlConcept.getLabels(this.dts);
            String string = null;
            for (Label label : list) {
                if (!"http://www.xbrl.org/2003/role/label".equals(label.getRole())) continue;
                if (label.getLang().startsWith("zh")) {
                    return label.getInnerText();
                }
                string = label.getInnerText();
            }
            return string == null ? "" : string;
        }
        return "";
    }

    private void b() {
        this.rebuildRelationshipSet();
        for (RelationshipSet relationshipSet : this.dts.getDefinitionRelationships()) {
            for (Relationship relationship : relationshipSet.getRelationships()) {
                if (!(relationship.arc() instanceof DefinitionArc)) continue;
                DefinitionArc definitionArc = (DefinitionArc)relationship.arc();
                if ("http://xbrl.org/int/dim/arcrole/all".equals(relationship.arcrole())) {
                    if (definitionArc.isClosed()) continue;
                    definitionArc.setClosed(true);
                    this.b.add(relationshipSet);
                    this._hasBugFixed = true;
                    continue;
                }
                if ("http://xbrl.org/int/dim/arcrole/all".equals(relationship.arcrole())) {
                    if (!definitionArc.isClosed()) continue;
                    definitionArc.setClosed(false);
                    this.b.add(relationshipSet);
                    this._hasBugFixed = true;
                    continue;
                }
                definitionArc.removeAttributeNode((QName)QNameConstants.contextElement);
                definitionArc.removeAttributeNode((QName)QNameConstants.closed);
            }
        }
        this.rebuildRelationshipSet();
    }

    @Override
    public boolean bugFix() {
        this._targetAction = Cleaner.TargetAction.BugFix;
        this._hasBugFixed = false;
        try {
            XbrlSchema xbrlSchema;
            Map map;
            this.az();
            this.bugFixDuplicateRoleTypeId();
            this.j();
            this.s();
            this.d();
            this.i();
            this.h();
            this.w();
            this.x();
            this.q();
            this.b();
            this.ar();
            this.bugFixDuplicateArc();
            this.y();
            this.ay();
            this.c();
            this.z();
            this.ae();
            this.ad();
            this.ao();
            this.rebuildRelationshipSet();
            this.m();
            this.o();
            this.k();
            this.l();
            this.am();
            this.g();
            this.f();
            this.e();
            this.G();
            this.T();
            XmlSchema[] xmlSchemaArray = this.dts.getSchemas(this.extendNamespaceURI);
            if (xmlSchemaArray != null && xmlSchemaArray.length > 0 && xmlSchemaArray[0] instanceof XbrlSchema && (map = (xbrlSchema = (XbrlSchema)xmlSchemaArray[0]).getElements()) != null && !map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    XbrlConcept xbrlConcept;
                    XbrlConcept xbrlConcept2 = xbrlConcept = entry.getValue() instanceof XbrlConcept ? (XbrlConcept)entry.getValue() : null;
                    if (xbrlConcept == null) continue;
                    try {
                        this.d(xbrlConcept);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            this.v();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this._hasBugFixed;
    }

    private void b(RelationshipSet relationshipSet) {
        List list2;
        for (List list2 : relationshipSet.getFromTargets()) {
            for (Relationship relationship : relationshipSet.getChildren(list2)) {
                if (relationship.isSingle() || relationship.size() <= 0) continue;
                Relationship[] relationshipArray = relationship.toArray();
                boolean bl = true;
                Relationship[] relationshipArray2 = relationshipArray;
                int n = relationshipArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Relationship relationship2 = relationshipArray2[n2];
                    if (!relationship2.isOptional()) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                if (!bl) continue;
                int n3 = 0;
                n2 = relationshipArray.length;
                while (n3 < n2 - 1) {
                    Relationship relationship3 = relationshipArray[n3];
                    relationship.remove(relationship3);
                    relationship3.purge(null);
                    relationshipSet.removeRelaionship(relationship3);
                    ++n3;
                }
            }
        }
        list2 = relationshipSet.getRelationships();
        int n = list2.size() - 1;
        while (n > -1) {
            Relationship relationship;
            relationship = (Relationship)list2.get(n);
            if (relationship.fromTarget() == relationship.toTarget()) {
                relationshipSet.purgeRelationship(relationship);
            }
            --n;
        }
    }

    private void c() {
        if (this.dts == null) {
            return;
        }
        for (RelationshipSet relationshipSet : this.dts.getDefinitionRelationships()) {
            this.b(relationshipSet);
        }
        for (RelationshipSet relationshipSet : this.dts.getPresentationRelationships()) {
            this.b(relationshipSet);
        }
        for (RelationshipSet relationshipSet : this.dts.getCalculationRelationships()) {
            this.b(relationshipSet);
        }
    }

    private void d() {
        if (this.xbrlInstance != null) {
            String string = this.xbrlInstance.getNamespaceOfPrefix("ifrs");
            String string2 = this.xbrlInstance.getNamespaceOfPrefix("ifrs-full");
            if (!StringUtils.isEmpty((String)string2) && StringUtils.equals((String)string, (String)string2)) {
                this.xbrlInstance.removeAttributeNode("xmlns:ifrs");
                this.xbrlInstance.getOwnerDocument().setModified(true);
                this._hasBugFixed = true;
                for (Context context : this.xbrlInstance.getContexts()) {
                    Iterator iterator = context.getDimensionContents().values().iterator();
                    while (iterator.hasNext()) {
                        MemberElement[] memberElementArray;
                        MemberElement[] memberElementArray2 = memberElementArray = (MemberElement[])iterator.next();
                        int n = memberElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ExplicitMember explicitMember;
                            String string3;
                            MemberElement memberElement = memberElementArray2[n2];
                            String string4 = memberElement.getAttributeValue((QName)QNameConstants.dimension);
                            if (!StringUtils.isEmpty((String)string4) && string4.startsWith("ifrs:")) {
                                memberElement.setAttribute((QName)QNameConstants.dimension, StringUtils.replaceOnce((String)string4, (String)"ifrs:", (String)"ifrs-full:"));
                            }
                            if (memberElement instanceof ExplicitMember && !StringUtils.isEmpty((String)(string3 = (explicitMember = (ExplicitMember)memberElement).getInnerText().trim())) && string3.startsWith("ifrs:")) {
                                explicitMember.setInnerText(StringUtils.replaceOnce((String)string3, (String)"ifrs:", (String)"ifrs-full:"));
                            }
                            ++n2;
                        }
                    }
                }
            }
        }
    }

    private void e() {
        Object object;
        Object object2;
        Object object3;
        List list;
        Object object4;
        RelationshipSet relationshipSet2;
        if (!this.getExtendMode().isReuseMode()) {
            return;
        }
        this.l = this.dts.getDefinitionRelationships();
        for (RelationshipSet relationshipSet2 : this.l) {
            for (Object e2 : relationshipSet2.getFromTargets()) {
                Relationship relationship;
                int n;
                object4 = relationshipSet2.getChildren(e2, "http://xbrl.org/int/dim/arcrole/domain-member");
                list = object4 instanceof List ? (List)object4 : new ArrayList(object4);
                int n2 = 0;
                while (n2 < list.size()) {
                    object3 = (Relationship)list.get(n2);
                    if (object3 != null && !object3.isSingle()) {
                        object2 = object3.toArray();
                        n = ((Relationship[])object2).length - 1;
                        while (n > 0) {
                            relationship = object2[n];
                            if (relationship != null && (object = object2[n - 1]) != null && relationship.isOptional() && object.isOptional()) {
                                if (!relationship.isReadOnly()) {
                                    object3 = object3.remove(relationship);
                                    list.set(n2, object3);
                                    relationshipSet2.purgeRelationship(relationship);
                                } else if (!object.isReadOnly()) {
                                    object3 = object3.remove((Relationship)object);
                                    list.set(n2, object3);
                                    relationshipSet2.purgeRelationship((Relationship)object);
                                }
                            }
                            --n;
                        }
                    }
                    if (object3 == null) {
                        list.remove(n2);
                    }
                    ++n2;
                }
                n2 = list.size() - 1;
                while (n2 > 0) {
                    object3 = (Relationship)list.get(n2);
                    if (object3 != null) {
                        object2 = object3.toTarget();
                        n = n2 - 1;
                        while (n > -1) {
                            relationship = (Relationship)list.get(n);
                            if (relationship != null && object2 == (object = relationship.toTarget()) && object3.isOptional() && relationship.isOptional()) {
                                if (!object3.isReadOnly() && object3.isSingle()) {
                                    if (relationshipSet2.purgeRelationship(object3)) {
                                        list.set(n2, null);
                                    }
                                } else if (!relationship.isReadOnly() && relationship.isSingle() && relationshipSet2.purgeRelationship(relationship)) {
                                    list.set(n, null);
                                }
                            }
                            --n;
                        }
                    }
                    --n2;
                }
            }
        }
        object4 = relationshipSet2 = this.dts.getDocuments();
        int n = ((RelationshipSet)object4).length;
        int n3 = 0;
        while (n3 < n) {
            block24: {
                RelationshipSet relationshipSet3 = object4[n3];
                if (!relationshipSet3.isReadOnly() && relationshipSet3.getContentType().contains(XbrlContentType.Linkbase) && relationshipSet3 instanceof XbrlDocument && (list = (XbrlDocument)relationshipSet3).getDocumentElement() instanceof Linkbase) {
                    Linkbase linkbase = (Linkbase)list.getDocumentElement();
                    object3 = this.b(linkbase);
                    object2 = new HashSet();
                    for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                        object = extendedLink.getNodeName();
                        if (object.equals(QNameConstants.definitionLink)) {
                            List list2 = extendedLink.getRelationships();
                            if (list2 == null || list2.size() == 0) {
                                if (extendedLink.elements().length != 0 || extendedLink.getParent() == null) continue;
                                extendedLink.getParent().removeChild((XdmNode)extendedLink);
                                continue;
                            }
                            String string = extendedLink.getRole();
                            if ("http://www.xbrl.org/2003/role/link".equals(string)) continue;
                            this.a(extendedLink, (Map<String, RoleRef>)object3);
                            continue;
                        }
                        break block24;
                    }
                    this.removeUnusedRoleRef(linkbase, (Set<String>)object2);
                }
            }
            ++n3;
        }
    }

    private void f() {
        XbrlSchema[] xbrlSchemaArray;
        XbrlSchema[] xbrlSchemaArray2 = xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray2[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                List list = xbrlSchema.getLinkbaseRefs();
                for (LinkbaseRef linkbaseRef : list) {
                    URI uRI = linkbaseRef.getDiscoveredUri(null);
                    if (uRI != null) {
                        IXbrlDocument iXbrlDocument = this.dts.getDocument(uRI);
                        if (iXbrlDocument != null && iXbrlDocument instanceof XbrlDocument) {
                            XbrlDocument xbrlDocument = (XbrlDocument)iXbrlDocument;
                            if (xbrlDocument.getDocumentElement() != null) continue;
                            LogWatch.warn((Object)("BugFix: remove empty file: " + linkbaseRef.getHref()));
                            xbrlSchema.removeLinkbaseRef(linkbaseRef);
                            xbrlSchema.setModified(true);
                            continue;
                        }
                        if (iXbrlDocument != null && !iXbrlDocument.getContentType().contains(XbrlContentType.FileNotFound)) continue;
                        LogWatch.warn((Object)("BugFix: remove empty file: " + linkbaseRef.getHref()));
                        xbrlSchema.removeLinkbaseRef(linkbaseRef);
                        xbrlSchema.setModified(true);
                        continue;
                    }
                    LogWatch.warn((Object)("BugFix: remove empty file: " + linkbaseRef.getHref()));
                    xbrlSchema.removeLinkbaseRef(linkbaseRef);
                    xbrlSchema.setModified(true);
                }
            }
            ++n2;
        }
    }

    private void g() {
        for (RelationshipSet relationshipSet : this.dts.getRelationshipSets((QName)QNameConstants.calculationLink)) {
            String string = relationshipSet.getRoleURI();
            RoleType roleType = this.dts.getRoleTypes().getSingle(string);
            if (roleType == null || roleType.canUsedOn((QName)QNameConstants.calculationLink)) continue;
            roleType.addUsedOn((QName)QNameConstants.calculationLink);
            this._hasBugFixed = true;
        }
    }

    private void h() {
        Object object;
        if (this.xbrlInstance == null) {
            return;
        }
        List list = this.xbrlInstance.getRelationshipSets();
        if (list == null) {
            return;
        }
        boolean bl = false;
        XdmNode xdmNode3 = this.xbrlInstance.getFirstChild();
        while (xdmNode3 != null) {
            if (xdmNode3 instanceof FootnoteLink) {
                FootnoteLink footnoteLink = (FootnoteLink)xdmNode3;
                if (StringUtils.isEmpty((String)footnoteLink.getAttributeValue((QName)QNameConstants.xlinkType))) {
                    footnoteLink.setAttribute((QName)QNameConstants.xlinkType, "extended");
                    this._hasBugFixed = true;
                }
                bl = this.a((ExtendedLink)footnoteLink) || bl;
                object = null;
                XdmNode xdmNode2 = xdmNode3.getFirstChild();
                while (xdmNode2 != null) {
                    Object object2;
                    object = xdmNode2.getNextSibling();
                    if (xdmNode2 instanceof Loc && ((object2 = (Loc)xdmNode2).getFinalTarget() == null || !(object2.getFinalTarget() instanceof Fact))) {
                        boolean bl2 = false;
                        for (RelationshipSet relationshipSet : list) {
                            if (!relationshipSet.getRoleURI().equals(footnoteLink.getRole()) || !relationshipSet.hasChildren(object2) && (object2.getFinalTarget() == null || !relationshipSet.hasChildren(object2.getFinalTarget()))) continue;
                            bl2 = true;
                        }
                        if (!bl2) {
                            footnoteLink.removeChild((XdmNode)object2);
                            this._hasBugFixed = true;
                        }
                    }
                    xdmNode2 = object;
                }
            }
            xdmNode3 = xdmNode3.getNextSibling();
        }
        for (XdmNode xdmNode3 : list) {
            object = null;
            for (XdmNode xdmNode2 : xdmNode3.getRelationships()) {
                ExtendedLink extendedLink = xdmNode2.getOwnerExtended();
                if (StringUtils.isEmpty((String)extendedLink.getAttributeValue((QName)QNameConstants.xlinkType))) {
                    extendedLink.setAttribute((QName)QNameConstants.xlinkType, "extended");
                    this._hasBugFixed = true;
                }
                if (xdmNode2.fromTarget() instanceof Fact || !(xdmNode2.fromTarget() instanceof Loc)) continue;
                if (object == null) {
                    object = new ArrayList();
                }
                object.add(xdmNode2);
            }
            if (object == null) continue;
            this.b.add(xdmNode3);
            for (XdmNode xdmNode2 : object) {
                xdmNode3.purgeOrProhibitTarget(xdmNode2.fromTarget());
                this._hasBugFixed = true;
                bl = true;
            }
            for (XdmNode xdmNode2 : object) {
                Footnote footnote;
                RelationshipSet relationshipSet;
                if (xdmNode3.hasParent(xdmNode2.toTarget()) || !(xdmNode2.toTarget() instanceof Footnote) || !((footnote = (Footnote)xdmNode2.toTarget()).getParent() instanceof ExtendedLink)) continue;
                relationshipSet = (ExtendedLink)footnote.getParent();
                relationshipSet.getRelationships().remove(xdmNode2);
                relationshipSet.removeChild((XdmNode)footnote);
                this._hasBugFixed = true;
                bl = true;
            }
        }
        if (bl) {
            xdmNode3 = this.xbrlInstance.getOwnerDTS().getHandlerContext();
            boolean bl3 = xdmNode3.getOptions().isValidateInstance();
            try {
                try {
                    xdmNode3.getOptions().setValidateInstance(false);
                    this.xbrlInstance.validateXbrl21();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    xdmNode3.getOptions().setValidateInstance(bl3);
                }
            }
            finally {
                xdmNode3.getOptions().setValidateInstance(bl3);
            }
        }
    }

    private void i() {
        XbrlConcept xbrlConcept;
        if (this.xbrlInstance == null) {
            return;
        }
        this.f = this.xbrlInstance.getAllFacts(true);
        for (List<Fact> list : this.f.values()) {
            for (Fact fact : list) {
                xbrlConcept = fact.getConcept();
                if (xbrlConcept == null || !xbrlConcept.isSimpleNumeric() || !"-0".equals(fact.getInnerText())) continue;
                fact.setInnerText("0");
                this._hasBugFixed = true;
            }
        }
        for (List<Fact> list : this.f.values()) {
            for (Fact fact : list) {
                String string;
                xbrlConcept = fact.getConcept();
                if (xbrlConcept == null || xbrlConcept.isNonNumeric() || !StringUtils.isEmpty((String)(string = fact.getDecimals())) || fact.isNil() || !StringUtils.isEmpty((String)fact.getPrecision())) continue;
                try {
                    if (fact.getAttribute((QName)QNameConstants.decimals) == null) continue;
                    String string2 = fact.getInnerText().trim();
                    int n = string2.indexOf(".");
                    if (string2.contains("e") || StringUtils.isEmpty((String)string2)) continue;
                    this._hasBugFixed = true;
                    if (n == -1) {
                        fact.setDecimals("0");
                        continue;
                    }
                    fact.setDecimals(Integer.toString(string2.length() - n - 1));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void j() {
        if (this.xbrlInstance == null) {
            return;
        }
        List list = this.xbrlInstance.getContexts();
        ArrayList<ExplicitMember> arrayList = new ArrayList<ExplicitMember>();
        ArrayList<void> arrayList2 = new ArrayList<void>();
        for (Context context : list) {
            Scenario scenario = context.getScenario();
            if (scenario != null) {
                void var7_9;
                arrayList2.clear();
                XdmNode throwable = scenario.getFirstChild();
                while (var7_9 != null) {
                    if (var7_9.getNodeNature() == 7) {
                        arrayList2.add(var7_9);
                    }
                    XdmNode xdmNode = var7_9.getNextSibling();
                }
                for (XdmNode xdmNode : arrayList2) {
                    xdmNode.getParent().removeChild(xdmNode);
                    this._hasBugFixed = true;
                }
            }
            try {
                XdmElement xdmElement;
                arrayList.clear();
                Iterator<Object> iterator = context.getDimensionContents().values().iterator();
                while (iterator.hasNext()) {
                    MemberElement[] memberElementArray;
                    MemberElement[] memberElementArray2 = memberElementArray = (MemberElement[])iterator.next();
                    int n = memberElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ExplicitMember explicitMember;
                        Object[] objectArray;
                        xdmElement = memberElementArray2[n2];
                        if (xdmElement instanceof ExplicitMember && (objectArray = this.dts.getDimensionDefault((explicitMember = (ExplicitMember)xdmElement).getDimension())) != null && ArrayUtils.contains((Object[])objectArray, (Object)explicitMember.getDimensionContent())) {
                            arrayList.add(explicitMember);
                        }
                        ++n2;
                    }
                }
                if (arrayList.size() <= 0) continue;
                for (ExplicitMember explicitMember : arrayList) {
                    xdmElement = explicitMember.getParent();
                    xdmElement.removeChild((XdmNode)explicitMember);
                    if (xdmElement.elements().length == 0) {
                        xdmElement.getParent().removeChild((XdmNode)xdmElement);
                    }
                    this._hasBugFixed = true;
                }
                context.process(this.getProcessContext());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void k() {
        c c2;
        Object object;
        Object object2;
        if (this.xbrlInstance == null) {
            return;
        }
        List list = this.xbrlInstance.getContexts();
        HashMap<String, Context[]> hashMap = new HashMap<String, Context[]>();
        int n = list.size() - 1;
        while (n > -1) {
            object2 = (Context)list.get(n);
            object = object2.getId();
            if (StringUtils.isEmpty((String)object)) {
                object2.getParent().removeChild((XdmNode)object2);
                list.remove(n);
                this._hasBugFixed = true;
            } else {
                Object object3 = (Context)hashMap.get(object);
                if (object3 != null) {
                    boolean bl = false;
                    Context context = object3;
                    int n2 = ((Context)context).length;
                    int n3 = 0;
                    while (n3 < n2) {
                        c2 = context[n3];
                        if (c2.XdtEqual((Context)object2)) {
                            this.fixBug("remove dup context: " + object);
                            object2.getParent().removeChild((XdmNode)object2);
                            list.remove(n);
                            this._hasBugFixed = true;
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!bl) {
                        hashMap.put((String)object, (Context[])CommonExtensions.add(Context[].class, (Object[])object3, (Object)object2));
                    }
                } else {
                    hashMap.put((String)object, new Context[]{object2});
                }
            }
            --n;
        }
        HashMap<c, ArrayList<Object>> hashMap2 = new HashMap<c, ArrayList<Object>>(list.size());
        object2 = new HashMap();
        object = null;
        for (Object object3 : list) {
            c2 = new c((Context)object3);
            ((HashMap)object2).put(object3, c2);
            object = (List)hashMap2.get(c2);
            if (object == null) {
                object = new ArrayList<Object>(2);
                object.add(object3);
                hashMap2.put(c2, (ArrayList<Object>)object);
                continue;
            }
            object.add(object3);
        }
        for (Object object3 : hashMap2.values()) {
            if (object3.size() <= 1) continue;
            this.a((List<Context>)object3);
        }
    }

    private void a(List<Context> list) {
        String string;
        String string2 = list.get(0).getId();
        int n = 1;
        while (n < list.size()) {
            string = list.get(n).getId();
            if (string.length() < string2.length()) {
                string2 = string;
            }
            ++n;
        }
        if (this.f == null) {
            this.f = this.xbrlInstance.getAllFacts(true);
        }
        n = list.size() - 1;
        while (n > -1) {
            string = list.get(n);
            String string3 = string.getId();
            if (!string3.equals(string2)) {
                string.getParent().removeChild((XdmNode)string);
                this.xbrlInstance.getOwnerDocument().setModified(true);
                for (List<Fact> list2 : this.f.values()) {
                    int n2 = 0;
                    int n3 = list2.size();
                    while (n2 < n3) {
                        Fact fact = list2.get(n2);
                        if (string3.equals(fact.getContextRef())) {
                            fact.setContextRef(string2);
                        }
                        ++n2;
                    }
                }
            }
            --n;
        }
    }

    private void l() {
        Object object;
        Object object2;
        Object object32;
        if (this.xbrlInstance == null) {
            return;
        }
        List list = this.xbrlInstance.getUnits();
        HashMap<Unit, Unit[]> hashMap = new HashMap<Unit, Unit[]>();
        int n = list.size() - 1;
        while (n > -1) {
            object32 = (Unit)list.get(n);
            Object object4 = object32.getId();
            if (StringUtils.isEmpty((String)object4)) {
                object32.getParent().removeChild((XdmNode)object32);
                list.remove(n);
                this._hasBugFixed = true;
            } else {
                object2 = (Unit[])hashMap.get(object4);
                if (object2 != null) {
                    boolean bl = false;
                    Unit[] unitArray = object2;
                    int n2 = ((Unit[])object2).length;
                    int n3 = 0;
                    while (n3 < n2) {
                        object = unitArray[n3];
                        if (object.SEqual((Unit)object32)) {
                            this.fixBug("remove dup unit: " + (String)object4);
                            object32.getParent().removeChild((XdmNode)object32);
                            list.remove(n);
                            this._hasBugFixed = true;
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!bl) {
                        hashMap.put((Unit)object4, (Unit[])CommonExtensions.add(Unit[].class, (Object[])object2, (Object)object32));
                    }
                } else {
                    hashMap.put((Unit)object4, new Unit[]{object32});
                }
            }
            --n;
        }
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>(list.size());
        for (Object object32 : list) {
            object2 = null;
            for (Map.Entry entry : hashMap2.entrySet()) {
                if (!((Unit)entry.getKey()).SEqual((Unit)object32)) continue;
                object2 = (List)entry.getValue();
                object2.add(object32);
            }
            if (object2 != null) continue;
            object2 = new ArrayList(2);
            object2.add(object32);
            hashMap2.put(object32, object2);
        }
        for (Object object32 : hashMap2.values()) {
            if (object32.size() <= 1) continue;
            this.b((List<Unit>)object32);
        }
        object32 = IQName.create((String)"CNY", (String)"http://www.xbrl.org/2003/iso4217");
        for (Object object4 : this.xbrlInstance.getUnits()) {
            QName[] qNameArray;
            if (object4.getDenominatorMeasures().length != 0 || (qNameArray = object4.getNumeratorMeasures()).length != 1 || !object32.equals(qNameArray[0]) || object4.getId().equals("U_RMB") || this.xbrlInstance.getUnit("U_RMB") != null) continue;
            object = object4.getId();
            object4.setId("U_RMB");
            this.xbrlInstance.getOwnerDocument().setModified(true);
            if (this.f == null) {
                this.f = this.xbrlInstance.getAllFacts(true);
            }
            for (List<Fact> list2 : this.f.values()) {
                int n4 = 0;
                int n5 = list2.size();
                while (n4 < n5) {
                    Fact fact = list2.get(n4);
                    if (((String)object).equals(fact.getUnitRef())) {
                        fact.setUnitRef("U_RMB");
                    }
                    ++n4;
                }
            }
        }
    }

    private void b(List<Unit> list) {
        String string;
        String string2 = list.get(0).getId();
        int n = 1;
        while (n < list.size()) {
            string = list.get(n).getId();
            if (string.length() < string2.length()) {
                string2 = string;
            }
            ++n;
        }
        if (this.f == null) {
            this.f = this.xbrlInstance.getAllFacts(true);
        }
        n = list.size() - 1;
        while (n > -1) {
            string = list.get(n);
            String string3 = string.getId();
            if (!string3.equals(string2)) {
                string.getParent().removeChild((XdmNode)string);
                this.xbrlInstance.getOwnerDocument().setModified(true);
                for (List<Fact> list2 : this.f.values()) {
                    int n2 = 0;
                    int n3 = list2.size();
                    while (n2 < n3) {
                        Fact fact = list2.get(n2);
                        if (string3.equals(fact.getUnitRef())) {
                            fact.setUnitRef(string2);
                        }
                        ++n2;
                    }
                }
            }
            --n;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void m() {
        IXbrlDocument[] iXbrlDocumentArray = this.dts.getDocuments();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<Object, QName> hashMap2 = new HashMap<Object, QName>();
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray;
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Object object;
                RoleType roleType;
                RoleRef roleRef;
                Object object2;
                void var10_12;
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                hashMap.clear();
                hashMap2.clear();
                XdmNode xdmNode = linkbase.getFirstChild();
                while (var10_12 != null) {
                    Object object3;
                    if (var10_12 instanceof RoleRef) {
                        object3 = (RoleRef)var10_12;
                        object2 = (RoleRef)hashMap.get(object3.getRoleURI());
                        if (object2 != null) {
                            object3.getParent().removeChild((XdmNode)object3);
                        } else {
                            hashMap.put(object3.getRoleURI(), object3);
                        }
                    } else if (var10_12 instanceof ExtendedLink) {
                        object3 = (ExtendedLink)var10_12;
                        object2 = object3.getRole();
                        if (!StringUtils.isEmpty((String)object2) && !"http://www.xbrl.org/2003/role/link".equals(object2)) {
                            roleRef = (RoleRef)hashMap.get(object2);
                            if (roleRef == null) {
                                hashMap2.put(object2, object3.getNodeName());
                            } else {
                                this.a(roleRef.getRoleType(), object3.getNodeName());
                            }
                        }
                        if (object3 instanceof LabelLink) {
                            roleRef = object3.getFirstChild();
                            while (roleRef != null) {
                                if (roleRef instanceof Label && !Label.isXbrl21StandardRole((String)(object2 = (roleType = (Label)roleRef).getRole()))) {
                                    hashMap2.put(object2, roleType.getNodeName());
                                }
                                roleRef = roleRef.getNextSibling();
                            }
                        }
                    }
                    XdmNode xdmNode2 = var10_12.getNextSibling();
                }
                for (Map.Entry entry : hashMap2.entrySet()) {
                    object2 = (String)entry.getKey();
                    roleRef = (RoleRef)hashMap.get(object2);
                    if (roleRef == null) {
                        roleType = this.dts.getRoleTypes().getSingle((String)object2);
                        if (roleType != null) {
                            linkbase.addRoleRef(roleType);
                            this.a(roleType, (QName)entry.getValue());
                            linkbase.getOwnerDocument().setModified(true);
                            continue;
                        }
                        object = (TaxonomySet)((XbrlSchema)XbrlLoader.getCoreSchema((String)"http://www.xbrl.org/2003/instance")).getXmlSchemaSet();
                        roleType = object.getRoleTypes().getSingle((String)object2);
                        if (roleType == null) continue;
                        linkbase.addRoleRef(roleType);
                        this.a(roleType, (QName)entry.getValue());
                        linkbase.getOwnerDocument().setModified(true);
                        continue;
                    }
                    roleType = this.dts.getRoleTypes().getSingle((String)object2);
                    this.a(roleType, (QName)entry.getValue());
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    String string;
                    int n3;
                    object2 = (String)entry.getKey();
                    roleRef = this.dts.getRoleTypes().getSingle((String)object2);
                    if (roleRef != null || (n3 = ((String)object2).indexOf("#")) == -1) continue;
                    object = ((String)object2).substring(n3 + 1);
                    RoleType[] roleTypeArray = this.dts.getRoleTypes().getRoleTypeById((String)object);
                    if (roleTypeArray == null || roleTypeArray.length != 1 || StringUtils.equals((String)(string = roleTypeArray[0].getRoleURI()), (String)object2)) continue;
                    RoleRef roleRef2 = (RoleRef)entry.getValue();
                    roleRef2.setRoleURI(string);
                    XdmNode xdmNode3 = linkbase.getFirstChild();
                    while (xdmNode3 != null) {
                        ExtendedLink extendedLink;
                        if (xdmNode3 instanceof ExtendedLink && StringUtils.equals((String)(extendedLink = (ExtendedLink)xdmNode3).getRole(), (String)object2)) {
                            extendedLink.setRole(string);
                        }
                        xdmNode3 = xdmNode3.getNextSibling();
                    }
                }
            }
            ++n2;
        }
    }

    private void a(RoleType roleType, QName qName) {
        if (roleType == null || qName == null || XbrlHelper.isReadOnly((XdmElement)roleType)) {
            return;
        }
        if (!roleType.canUsedOn(qName)) {
            UsedOn usedOn = roleType.createUsedOn(qName);
            roleType.appendChild((XdmNode)usedOn);
            this.fixBug("add usedOn: " + roleType.getRoleURI() + " -/- " + usedOn.prefixedName(qName));
            this.a((UsedOnContainer)roleType);
        }
    }

    private void n() {
        try {
            IXbrlDocument[] iXbrlDocumentArray;
            IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
            int n = iXbrlDocumentArray.length;
            int n2 = 0;
            while (n2 < n) {
                XbrlDocument xbrlDocument;
                IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
                if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                    Object object;
                    String string;
                    Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                    HashMap<String, ArcroleRef> hashMap = new HashMap<String, ArcroleRef>();
                    for (ArcroleRef arcroleRef2 : linkbase.getArcroleRefs()) {
                        string = arcroleRef2.getArcroleURI();
                        object = (ArcroleRef)hashMap.get(string);
                        if (object != null) {
                            arcroleRef2.getParent().removeChild((XdmNode)arcroleRef2);
                            continue;
                        }
                        hashMap.put(string, arcroleRef2);
                    }
                    if (hashMap.size() != 0) {
                        ArcroleRef arcroleRef2;
                        arcroleRef2 = linkbase.getFirstChild();
                        block4: while (arcroleRef2 != null) {
                            if (arcroleRef2.getNodeNature() == 2 && arcroleRef2 instanceof ExtendedLink) {
                                Iterator<Object> iterator = (ExtendedLink)arcroleRef2;
                                string = iterator.getFirstChild();
                                while (string != null) {
                                    if (string instanceof Arc) {
                                        object = ((Arc)string).getArcrole();
                                        hashMap.remove(object);
                                        if (hashMap.isEmpty()) break block4;
                                    }
                                    string = string.getNextSibling();
                                }
                            }
                            arcroleRef2 = arcroleRef2.getNextSibling();
                        }
                        if (!hashMap.isEmpty()) {
                            for (ArcroleRef arcroleRef2 : hashMap.values()) {
                                arcroleRef2.getParent().removeChild((XdmNode)arcroleRef2);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void o() {
        if (this.j == null) {
            this.j = this.dts.getPresentationRelationships();
        }
        HashSet hashSet = new HashSet();
        for (RelationshipSet relationshipSet : this.j) {
            hashSet.clear();
            relationshipSet.getAllTargets(hashSet);
            block1: for (Object e2 : hashSet) {
                XbrlConcept xbrlConcept;
                if (!(e2 instanceof XbrlConcept) || !(xbrlConcept = (XbrlConcept)e2).isHypercube()) continue;
                for (Relationship relationship : relationshipSet.getParents((Object)xbrlConcept)) {
                    Object object;
                    Relationship relationship2;
                    Arc arc;
                    Arc arc2;
                    List list = relationshipSet.getEffectiveChildren(relationship.fromTarget());
                    if (list == null || list.size() <= 0 || ((Relationship)list.get(0)).toTarget() == xbrlConcept) continue;
                    if (list.size() == 2) {
                        arc2 = ((Relationship)list.get(0)).arc();
                        arc = ((Relationship)list.get(1)).arc();
                        BigDecimal bigDecimal = ((Relationship)list.get(0)).arc().getOrder();
                        arc2.setOrder(arc.getOrder());
                        arc.setOrder(bigDecimal);
                        this._hasBugFixed = true;
                        this.b.add(relationshipSet);
                        continue;
                    }
                    arc2 = null;
                    arc = null;
                    int n = -1;
                    int n2 = -1;
                    int n3 = 0;
                    while (n3 < list.size()) {
                        relationship2 = (Relationship)list.get(n3);
                        object = relationship2.toConcept();
                        if (object == null) continue block1;
                        if (object == xbrlConcept) {
                            arc2 = relationship2;
                            n = n3;
                        } else {
                            if (object.isHypercube()) continue block1;
                            if (object != null && object.getName().endsWith("LineItems")) {
                                if (arc != null) continue block1;
                                arc = relationship2;
                                n2 = n3;
                            }
                        }
                        ++n3;
                    }
                    if (n2 == -1 || n == -1 || n2 > n) continue;
                    Arc arc3 = arc2.arc();
                    relationship2 = arc.arc();
                    object = ((Relationship)list.get(0)).arc().getOrder();
                    arc3.setOrder(relationship2.getOrder());
                    relationship2.setOrder((BigDecimal)object);
                    this._hasBugFixed = true;
                    this.b.add(relationshipSet);
                }
            }
        }
    }

    private void p() {
        try {
            for (RoleType roleType : this.dts.getRoleTypes()) {
                RelationshipSet relationshipSet3;
                Object object2;
                String string = roleType.getRoleURI();
                if (!roleType.getDefinitionText().endsWith("//REMOVED")) continue;
                List<RelationshipSet> list = this.f(string);
                boolean bl = true;
                for (RelationshipSet relationshipSet2 : list) {
                    if (!relationshipSet2.isReadOnly()) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                List<RelationshipSet> list2 = this.c(string);
                for (Object object2 : list2) {
                    if (!object2.isReadOnly()) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                object2 = this.b(string);
                Iterator<Object> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    relationshipSet3 = (RelationshipSet)iterator.next();
                    if (!relationshipSet3.isReadOnly()) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                for (RelationshipSet relationshipSet3 : list) {
                    for (Object e2 : new ArrayList(relationshipSet3.getFromTargets())) {
                        relationshipSet3.purgeOrProhibitTarget(e2);
                    }
                    this.b.add(relationshipSet3);
                }
                for (RelationshipSet relationshipSet3 : list2) {
                    for (Object e2 : new ArrayList(relationshipSet3.getFromTargets())) {
                        relationshipSet3.purgeOrProhibitTarget(e2);
                    }
                    this.b.add(relationshipSet3);
                }
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    relationshipSet3 = (RelationshipSet)iterator.next();
                    for (Object e2 : new ArrayList(relationshipSet3.getFromTargets())) {
                        relationshipSet3.purgeOrProhibitTarget(e2);
                    }
                    this.b.add(relationshipSet3);
                }
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)("removeRoleTypeREMOVED: " + exception.getMessage()));
            exception.printStackTrace();
        }
    }

    @Override
    public boolean reGenerateDefinitionLink() {
        this._hasBugFixed = false;
        this.q();
        this.ao();
        return this._hasBugFixed;
    }

    private void a(RelationshipSet relationshipSet, List<j> list) {
        List list2 = relationshipSet.getRootNodes();
        HashSet<Relationship> hashSet = new HashSet<Relationship>();
        for (Object e2 : list2) {
            hashSet.clear();
            if (e2 instanceof XbrlConcept && ((XbrlConcept)e2).isHypercube()) {
                for (Relationship relationship : relationshipSet.getParents(e2)) {
                    XbrlConcept xbrlConcept = relationship.fromConcept();
                    if (xbrlConcept == null) continue;
                    j j2 = new j(xbrlConcept, (XbrlConcept)e2, relationshipSet);
                    j2.e = relationship;
                    if (list.contains(j2)) continue;
                    list.add(j2);
                }
            }
            for (Relationship relationship : relationshipSet.getChildren(e2, "http://www.xbrl.org/2003/arcrole/parent-child")) {
                hashSet.add(relationship);
                this.a(relationshipSet, relationship.toTarget(), list, hashSet);
            }
        }
    }

    private void a(RelationshipSet relationshipSet, Object object, List<j> list, Set<Relationship> set) {
        if (object instanceof XbrlConcept && ((XbrlConcept)object).isHypercube()) {
            for (Relationship relationship : relationshipSet.getParents(object)) {
                XbrlConcept xbrlConcept = relationship.fromConcept();
                if (xbrlConcept == null) continue;
                j j2 = new j(xbrlConcept, (XbrlConcept)object, relationshipSet);
                j2.e = relationship;
                if (list.contains(j2)) continue;
                list.add(j2);
            }
        }
        if (object != null) {
            for (Relationship relationship : relationshipSet.getChildren(object, "http://www.xbrl.org/2003/arcrole/parent-child")) {
                if (set.contains(relationship)) continue;
                set.add(relationship);
                this.a(relationshipSet, relationship.toTarget(), list, set);
            }
        }
    }

    private boolean a(Iterable<ExtendedLink> iterable, String string) {
        if (iterable == null) {
            return true;
        }
        if (this.s == null) {
            this.s = new HashMap<ExtendedLink, String>();
        }
        for (ExtendedLink extendedLink : iterable) {
            String string2 = this.s.get(extendedLink);
            if (StringUtils.isEmpty((String)string2) || StringUtils.equals((String)string2, (String)string)) continue;
            return false;
        }
        for (ExtendedLink extendedLink : iterable) {
            this.s.put(extendedLink, string);
        }
        return true;
    }

    private void a(ExtendedLink extendedLink, String string) {
        if (this.s == null) {
            this.s = new HashMap<ExtendedLink, String>();
        }
        this.s.put(extendedLink, string);
    }

    private void q() {
        this.rebuildRelationshipSet();
        ArrayList<RelationshipSet> arrayList = new ArrayList<RelationshipSet>(this.dts.getPresentationRelationships());
        Collections.sort(arrayList, new i());
        this.j = arrayList;
        this.l = this.dts.getDefinitionRelationships();
        boolean bl = false;
        ArrayList<j> arrayList2 = new ArrayList<j>();
        for (RelationshipSet object2 : this.j) {
            arrayList2.clear();
            this.a(object2, arrayList2);
            if (arrayList2.size() == 0) continue;
            String string = object2.getRoleURI();
            List<Object> list = this.c(string);
            block1: for (j j2 : arrayList2) {
                XbrlConcept xbrlConcept = j2.a;
                for (RelationshipSet relationshipSet2 : list) {
                    for (Relationship relationship : relationshipSet2.getParents((Object)xbrlConcept)) {
                        if (relationship.fromConcept() != j2.d || !this.a(relationshipSet2.getExtendedLinks(), string)) continue;
                        j2.c = relationshipSet2;
                        j2.f = relationship;
                        continue block1;
                    }
                }
            }
            for (j j3 : arrayList2) {
                if (j3.c == null) {
                    this.reportBug(j3 + " @" + (String)string + " missing definition.");
                    if (!this.a(string, j3, list)) continue;
                    bl = true;
                    this._hasBugFixed = true;
                    this.fixBug("create definitionLink for " + j3 + " @" + (String)string, true);
                    continue;
                }
                if (!this.a(j3)) continue;
                bl = true;
            }
        }
        if (bl) {
            this.l = this.dts.getDefinitionRelationships();
            this.rebuildRelationshipSet();
        }
        this.l = this.dts.getDefinitionRelationships();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (RelationshipSet relationshipSet : this.l) {
            for (List<Object> list : relationshipSet.getFromTargets()) {
                List list2 = relationshipSet.getEffectiveChildren(list);
                if (list2.size() <= 1) continue;
                hashSet.clear();
                int n = list2.size() - 1;
                while (n > -1) {
                    RelationshipSet relationshipSet2;
                    relationshipSet2 = (Relationship)list2.get(n);
                    if (relationshipSet2.isOptional() && "http://xbrl.org/int/dim/arcrole/domain-member".equals(relationshipSet2.arcrole())) {
                        Object object = relationshipSet2.toTarget();
                        if (hashSet.contains(object)) {
                            relationshipSet2.purge(null);
                            this.b.add(relationshipSet);
                        } else {
                            hashSet.add(object);
                        }
                    }
                    --n;
                }
            }
        }
        this.rebuildRelationshipSet();
    }

    private boolean a(j j2) {
        XbrlConcept xbrlConcept;
        if (j2 == null || j2.e == null) {
            return false;
        }
        boolean bl = false;
        RelationshipSet relationshipSet = j2.c;
        ExtendedLinkSummary extendedLinkSummary = null;
        for (Relationship relationship : j2.b.getEffectiveChildren((Object)j2.a)) {
            xbrlConcept = relationship.toConcept();
            if (xbrlConcept == null || !xbrlConcept.isDimension()) continue;
            if (!relationshipSet.contains((Object)xbrlConcept)) {
                if (extendedLinkSummary == null) {
                    j2.g = extendedLinkSummary = this.a(j2.f);
                }
                if (extendedLinkSummary == null || !this.a(extendedLinkSummary, relationship, j2.b, j2)) continue;
                bl = true;
                this.b.add(j2.c);
                continue;
            }
            if (!this.a(j2, xbrlConcept, 0)) continue;
            bl = true;
            this.b.add(j2.c);
        }
        for (Relationship relationship : j2.b.getEffectiveChildren((Object)j2.d)) {
            if (relationship == j2.e || !relationship.isOptional() || (xbrlConcept = relationship.toConcept()) == null || xbrlConcept.isDimension() || xbrlConcept.isHypercube()) continue;
            if (extendedLinkSummary == null) {
                j2.g = extendedLinkSummary = this.a(j2.f);
            }
            if (this.a(extendedLinkSummary, relationship, j2, new HashSet<Relationship>()) <= 0) continue;
            bl = true;
        }
        return bl;
    }

    private boolean a(j j2, XbrlConcept xbrlConcept, int n) {
        if (xbrlConcept == null || n > 50) {
            return false;
        }
        boolean bl = false;
        for (Relationship relationship : j2.b.getEffectiveChildren((Object)xbrlConcept)) {
            String string;
            XbrlConcept xbrlConcept2 = relationship.toConcept();
            if (xbrlConcept2 == null || xbrlConcept2.isHypercube() || xbrlConcept2.isDimension()) continue;
            String string2 = string = xbrlConcept.isDimension() ? "http://xbrl.org/int/dim/arcrole/dimension-domain" : "http://xbrl.org/int/dim/arcrole/domain-member";
            if (!j2.c.containRelationship((Object)xbrlConcept, (Object)xbrlConcept2, string)) {
                Relationship relationship2;
                if (j2.g == null) {
                    j2.g = this.a(j2.f);
                }
                if (j2.g != null && (relationship2 = j2.g.addRelationship(xbrlConcept, xbrlConcept2, (QName)QNameConstants.definitionArc, string)) != null) {
                    this.fixBug("create relationship: " + relationship2);
                    relationship2.arc().getOwnerDocument().setModified(true);
                    relationship2.arc().setOrder(relationship.arc().getOrder());
                    bl = true;
                }
            }
            boolean bl2 = bl = this.a(j2, xbrlConcept2, n + 1) || bl;
        }
        return bl;
    }

    private ExtendedLinkSummary a(Relationship relationship) {
        Linkbase linkbase;
        RoleType roleType;
        if (!relationship.isReadOnly()) {
            return new ExtendedLinkSummary(relationship.arc().getOwnerExtended(), this.dts);
        }
        if (!relationship.isSingle()) {
            roleType = relationship.toArray();
            int n = ((Relationship[])roleType).length;
            int n2 = 0;
            while (n2 < n) {
                linkbase = roleType[n2];
                if (!linkbase.isReadOnly()) {
                    return new ExtendedLinkSummary(linkbase.arc().getOwnerExtended(), this.dts);
                }
                ++n2;
            }
        }
        if ((linkbase = this.r()) == null) {
            return null;
        }
        ExtendedLink extendedLink = linkbase.createExtendedLink((QName)QNameConstants.definitionLink);
        String string = relationship.getOwnerExtended().getRole();
        extendedLink.setRole(string);
        linkbase.appendChild((XdmNode)extendedLink);
        if (linkbase.getRoleRef(string) == null && (roleType = this.dts.getRoleTypes().getSingle(string)) != null) {
            RoleRef roleRef = linkbase.createRoleRef();
            roleRef.setRoleType(roleType);
            linkbase.prependChild((XdmNode)roleRef);
            linkbase.getOwnerDocument().setModified(true);
        }
        roleType = new ExtendedLinkSummary(extendedLink, this.dts);
        return roleType;
    }

    private boolean a(String string, j j2, List<RelationshipSet> list) {
        Relationship relationship4;
        Relationship relationship2;
        Relationship relationship3;
        String string2;
        Object object;
        boolean bl;
        Object object2;
        String string322;
        int n;
        XbrlConcept xbrlConcept = j2.a;
        RelationshipSet relationshipSet = j2.b;
        if (string.endsWith("201204f")) {
            n = 2;
        }
        n = 0;
        block0: for (String string322 : relationshipSet.getParents((Object)xbrlConcept)) {
            object2 = relationshipSet.getEffectiveChildren(string322.fromTarget()).iterator();
            while (object2.hasNext()) {
                Relationship relationship4 = (Relationship)object2.next();
                if (relationship4 == string322 || relationship4.toConcept() == null || relationship4.toConcept().isDimension()) continue;
                n = 1;
                continue block0;
            }
        }
        if (n == 0) {
            this.reportBug(j2 + " @" + relationshipSet.getRoleURI() + " no lineItems.");
            return false;
        }
        string322 = string;
        Object object3 = "";
        int n2 = string322.lastIndexOf("/");
        if (n2 != -1 && ((String)(object2 = string322.substring(n2 + 1))).length() > 6) {
            string322 = String.valueOf(string322.substring(0, n2 + 1)) + ((String)object2).substring(0, 6);
            object3 = ((String)object2).substring(6);
        }
        object2 = string322;
        boolean bl2 = true;
        char c2 = '`';
        if (StringUtils.isEmpty((String)object3)) {
            c2 = '`';
            while (true) {
                bl = false;
                for (RelationshipSet roleTypeArray2 : list) {
                    if (!((String)object2).equals(roleTypeArray2.getRoleURI()) || roleTypeArray2.getRelationships().size() == 0) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    char c3 = (char)(c2 + 1);
                    c2 = c3;
                    object2 = String.valueOf(string322) + c3;
                    bl2 = false;
                    continue;
                }
                break;
            }
        } else {
            object2 = string;
            c2 = (char)(((String)object3).charAt(0) - '\u0001');
            while (true) {
                bl = false;
                for (RelationshipSet relationshipSet2 : list) {
                    if (!((String)object2).equals(relationshipSet2.getRoleURI()) || relationshipSet2.getRelationships().size() == 0) continue;
                    bl = true;
                    break;
                }
                if (!bl) break;
                char c4 = (char)(c2 + 1);
                c2 = c4;
                object2 = String.valueOf(string322) + c4;
                bl2 = false;
            }
        }
        Linkbase linkbase = this.r();
        if (linkbase == null) {
            return false;
        }
        linkbase.setAttribute("xmlns:xbrldt", "http://xbrl.org/2005/xbrldt");
        RoleType[] roleTypeArray = this.dts.getRoleTypes().get(string322);
        if (!bl2) {
            object = null;
            if (roleTypeArray != null && roleTypeArray.length > 0) {
                string2 = roleTypeArray[0].getId();
                object = roleTypeArray[0].getDefinitionText();
                int n3 = ((String)object).indexOf("]");
                if (n3 != -1) {
                    object = ((String)object).substring(n3 + 1).trim();
                }
                if (!StringUtils.isEmpty((String)string2)) {
                    string2 = String.valueOf(string2) + c2;
                    if (linkbase.getRoleRef((String)object2) == null) {
                        relationship3 = this.createRoleType((String)object2, string2, (String)object);
                        relationship2 = linkbase.createRoleRef((String)object2, null);
                        linkbase.prependChild((XdmNode)relationship2);
                        relationship2.setRoleType((RoleType)relationship3);
                    }
                }
            }
        } else if (StringUtils.isEmpty((String)object3)) {
            if (roleTypeArray != null && roleTypeArray.length > 0) {
                object = roleTypeArray[0];
                if (linkbase.getRoleRef((String)object2) == null) {
                    string2 = linkbase.createRoleRef((String)object2, null);
                    linkbase.prependChild((XdmNode)string2);
                    string2.setRoleType((RoleType)object);
                }
            }
        } else {
            RoleType[] roleTypeArray2 = this.dts.getRoleTypes().get((String)object2);
            if (roleTypeArray2 != null && roleTypeArray2.length > 0) {
                object = roleTypeArray2[0];
                if (linkbase.getRoleRef((String)object2) == null) {
                    string2 = linkbase.createRoleRef((String)object2, null);
                    linkbase.prependChild((XdmNode)string2);
                    string2.setRoleType((RoleType)object);
                }
            }
        }
        object = linkbase.createExtendedLink((QName)QNameConstants.definitionLink);
        object.setRole((String)object2);
        linkbase.appendChild((XdmNode)object);
        this.a((ExtendedLink)object, relationshipSet.getRoleURI());
        string2 = this.dts.getRoleTypes().getSingle((String)object2);
        if (string2 != null && !string2.canUsedOn((QName)QNameConstants.definitionLink)) {
            UsedOn usedOn = string2.createUsedOn((QName)QNameConstants.definitionLink);
            string2.appendChild((XdmNode)usedOn);
        }
        ExtendedLinkSummary extendedLinkSummary = new ExtendedLinkSummary((ExtendedLink)object, this.dts);
        if (j2.c == null) {
            j2.c = extendedLinkSummary.getRelationshipSet();
        }
        if ((relationship2 = extendedLinkSummary.addRelationship((relationship3 = j2.e).fromConcept(), relationship3.toConcept(), (QName)QNameConstants.definitionArc, "http://xbrl.org/int/dim/arcrole/all")) == null) {
            return false;
        }
        DefinitionArc definitionArc = (DefinitionArc)relationship2.arc();
        definitionArc.setOrder(relationship3.arc().getOrder());
        definitionArc.setContextElement(ContextElementType.Scenario);
        definitionArc.setClosed(true);
        for (Relationship relationship4 : relationshipSet.getEffectiveChildren(relationship3.fromTarget())) {
            XbrlConcept xbrlConcept2;
            if (relationship4 == relationship3 || (xbrlConcept2 = relationship4.toConcept()) == null || xbrlConcept2.isDimension() || xbrlConcept2.isHypercube()) continue;
            this.a(extendedLinkSummary, relationship4, j2, new HashSet<Relationship>());
        }
        this.a(extendedLinkSummary, xbrlConcept, relationshipSet, j2);
        relationship4 = this.dts.getRelationshipSet((QName)QNameConstants.definitionLink, (String)object2);
        if (relationship4 != null) {
            this.b.add(relationship4);
            list.add((RelationshipSet)relationship4);
        } else {
            LogWatch.error((Object)("create definitionRS lost: " + (String)object2));
        }
        return true;
    }

    private boolean a(ExtendedLinkSummary extendedLinkSummary, XbrlConcept xbrlConcept, RelationshipSet relationshipSet, j j2) {
        XbrlConcept xbrlConcept2 = xbrlConcept;
        if (xbrlConcept2 == null || relationshipSet == null) {
            return false;
        }
        for (Relationship relationship : relationshipSet.getEffectiveChildren((Object)xbrlConcept)) {
            XbrlConcept xbrlConcept3 = relationship.toConcept();
            if (xbrlConcept3 == null || !xbrlConcept3.isDimension()) continue;
            Relationship relationship2 = extendedLinkSummary.addRelationship(xbrlConcept2, xbrlConcept3, (QName)QNameConstants.definitionArc, "http://xbrl.org/int/dim/arcrole/hypercube-dimension");
            if (relationship2 == null) {
                return false;
            }
            relationship2.arc().setOrder(relationship.arc().getOrder());
            List list = relationshipSet.getEffectiveChildren((Object)xbrlConcept3);
            for (Relationship relationship3 : list) {
                this.a(extendedLinkSummary, relationship3, relationshipSet, new HashSet<Relationship>(), j2);
                if (list.size() != 1) continue;
                QName qName = this.dts.getDefaultDimensionMember(xbrlConcept3.getQName());
                XbrlConcept xbrlConcept4 = relationship3.toConcept();
                if (xbrlConcept4 == null || qName != null && !qName.equals(xbrlConcept4.getQName())) continue;
                this.a(extendedLinkSummary, relationship3);
            }
        }
        return true;
    }

    private boolean a(ExtendedLinkSummary extendedLinkSummary, Relationship relationship, RelationshipSet relationshipSet, j j2) {
        XbrlConcept xbrlConcept = relationship.fromConcept();
        if (xbrlConcept == null || relationshipSet == null) {
            return false;
        }
        XbrlConcept xbrlConcept2 = relationship.toConcept();
        if (xbrlConcept2 == null || !xbrlConcept2.isDimension()) {
            return false;
        }
        Relationship relationship2 = extendedLinkSummary.addRelationship(xbrlConcept, xbrlConcept2, (QName)QNameConstants.definitionArc, "http://xbrl.org/int/dim/arcrole/hypercube-dimension");
        if (relationship2 == null) {
            return false;
        }
        relationship2.arc().setOrder(relationship.arc().getOrder());
        List list = relationshipSet.getEffectiveChildren((Object)xbrlConcept2);
        for (Relationship relationship3 : list) {
            this.a(extendedLinkSummary, relationship3, relationshipSet, new HashSet<Relationship>(), j2);
            if (list.size() != 1) continue;
            QName qName = this.dts.getDefaultDimensionMember(xbrlConcept2.getQName());
            XbrlConcept xbrlConcept3 = relationship3.toConcept();
            if (xbrlConcept3 == null || qName != null && !qName.equals(xbrlConcept3.getQName())) continue;
            this.a(extendedLinkSummary, relationship3);
        }
        return true;
    }

    private boolean a(ExtendedLinkSummary extendedLinkSummary, Relationship relationship, RelationshipSet relationshipSet, Set<Relationship> set, j j2) {
        if (set.contains(relationship)) {
            return true;
        }
        XbrlConcept xbrlConcept = relationship.fromConcept();
        XbrlConcept xbrlConcept2 = relationship.toConcept();
        if (xbrlConcept == null || xbrlConcept2 == null) {
            return false;
        }
        if (!extendedLinkSummary.containsRelationship(xbrlConcept, xbrlConcept2, "http://xbrl.org/int/dim/arcrole/dimension-domain")) {
            Relationship relationship2 = extendedLinkSummary.addRelationship(xbrlConcept, xbrlConcept2, (QName)QNameConstants.definitionArc, "http://xbrl.org/int/dim/arcrole/dimension-domain");
            if (relationship2 == null) {
                return false;
            }
            relationship2.arc().setOrder(relationship.arc().getOrder());
        }
        set.add(relationship);
        for (Relationship relationship2 : relationshipSet.getEffectiveChildren((Object)xbrlConcept2)) {
            this.a(extendedLinkSummary, relationship2, j2, set);
        }
        return true;
    }

    private boolean a(ExtendedLinkSummary extendedLinkSummary, Relationship relationship) {
        XbrlConcept xbrlConcept = relationship.fromConcept();
        XbrlConcept xbrlConcept2 = relationship.toConcept();
        if (xbrlConcept == null || xbrlConcept2 == null) {
            return false;
        }
        Relationship relationship2 = extendedLinkSummary.addRelationship(xbrlConcept, xbrlConcept2, (QName)QNameConstants.definitionArc, "http://xbrl.org/int/dim/arcrole/dimension-default");
        if (relationship2 == null) {
            return false;
        }
        relationship2.arc().setOrder("2.0");
        return true;
    }

    private int a(ExtendedLinkSummary extendedLinkSummary, Relationship relationship, j j2, Set<Relationship> set) {
        if (extendedLinkSummary == null || relationship == null) {
            return 0;
        }
        if (set.contains(relationship)) {
            return 0;
        }
        XbrlConcept xbrlConcept = relationship.fromConcept();
        XbrlConcept xbrlConcept2 = relationship.toConcept();
        if (xbrlConcept == null || xbrlConcept2 == null) {
            return 0;
        }
        int n = 0;
        if (!j2.c.containRelationship((Object)xbrlConcept, (Object)xbrlConcept2, "http://xbrl.org/int/dim/arcrole/domain-member")) {
            Relationship relationship2 = extendedLinkSummary.addRelationship(xbrlConcept, xbrlConcept2, (QName)QNameConstants.definitionArc, "http://xbrl.org/int/dim/arcrole/domain-member");
            if (relationship2 == null) {
                return 0;
            }
            relationship2.arc().setOrder(relationship.arc().getOrder());
            ++n;
        }
        set.add(relationship);
        for (Relationship relationship2 : j2.b.getEffectiveChildren((Object)xbrlConcept2)) {
            n += this.a(extendedLinkSummary, relationship2, j2, set);
        }
        return n;
    }

    private ExtendedLink c(RelationshipSet relationshipSet) {
        for (Relationship relationship : relationshipSet.getRelationships()) {
            if (relationship.isReadOnly()) continue;
            return relationship.arc().getOwnerExtended();
        }
        return null;
    }

    private Linkbase r() {
        RelationshipSet relationshipSet2;
        for (RelationshipSet relationshipSet2 : this.l) {
            for (Relationship relationship : relationshipSet2.getRelationships()) {
                if (relationship.isReadOnly()) continue;
                return relationship.arc().getOwnerExtended().getOwnerLinkbase();
            }
        }
        relationshipSet2 = null;
        IXbrlDocument[] iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                Object object = linkbase.getFirstChild();
                while (object != null) {
                    if (object.getNodeNature() == 2 && QNameConstants.definitionLink.equals((Object)object.getNodeName())) {
                        this.a(linkbase);
                        return linkbase;
                    }
                    object = object.getNextSibling();
                }
                object = xbrlDocument.getBaseURI();
                if (((String)object).endsWith("definition.xml") || ((String)object).endsWith("def.xml")) {
                    relationshipSet2 = linkbase;
                }
            }
            ++n2;
        }
        this.a((Linkbase)relationshipSet2);
        return relationshipSet2;
    }

    private void s() {
        if (this.xbrlInstance == null || StringUtils.isEmpty((String)this.extendNamespaceURI)) {
            return;
        }
        this.f = this.xbrlInstance.getAllFacts(true);
        try {
            for (Map.Entry<QName, List<Fact>> entry : this.f.entrySet()) {
                XbrlConcept xbrlConcept = this.dts.getConcept(entry.getKey());
                if (xbrlConcept != null || (xbrlConcept = this.dts.getConcept(entry.getKey().getLocalPart(), this.extendNamespaceURI)) == null) continue;
                boolean bl = xbrlConcept.getPeriodType() == PeriodType.Duration;
                for (Fact fact : entry.getValue()) {
                    boolean bl2;
                    Context context = fact.getContext();
                    boolean bl3 = context == null ? false : (bl2 = context.getPeriodType() == PeriodType.Duration);
                    if (bl != bl2) continue;
                    String string = fact.getNamespaceURI();
                    String string2 = fact.getPrefixOfNamespace(string);
                    Fact fact2 = this.xbrlInstance.createFact(xbrlConcept.getQName());
                    fact.copyTo(fact2);
                    XdmElement xdmElement = fact.getParent();
                    xdmElement.insertBefore((XdmNode)fact2, (XdmNode)fact);
                    xdmElement.removeChild((XdmNode)fact);
                    fact2.removeAttributeNode(string2, "http://www.w3.org/2000/xmlns/");
                    this._hasBugFixed = true;
                    this.fixBug("fact " + fact.getLocalName() + " ns: " + fact.getNamespaceURI() + " ->" + this.extendNamespaceURI);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean removeConcept(String qname) {
        QName qName;
        XbrlSchema xbrlSchema;
        this._targetAction = Cleaner.TargetAction.RemoveConcept;
        if (StringUtils.isEmpty((String)qname)) {
            IOHelper.writeMessage((OutputStream)this.out, (String)"\u8bf7\u63d0\u4f9b\u5220\u9664\u7684\u5143\u7d20\u540d\uff01");
            return false;
        }
        OutputStream outputStream = this.out;
        this.out = null;
        this.bugFix();
        this.out = outputStream;
        XbrlSchema xbrlSchema2 = null;
        XbrlSchema[] object2 = this.getEntrySchema();
        int n = object2.length;
        int n2 = 0;
        while (n2 < n) {
            xbrlSchema = object2[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                xbrlSchema2 = xbrlSchema;
            }
            ++n2;
        }
        if (xbrlSchema2 == null) {
            IOHelper.writeMessage((OutputStream)this.out, (String)"\u6ca1\u6709\u627e\u5230\u53ef\u7f16\u8f91\u7684\u5165\u53e3\u5206\u7c7b\u6807\u51c6\uff01");
            return false;
        }
        xbrlSchema = null;
        if (qname.contains(":")) {
            xbrlSchema = this.dts.getConcept(qname);
        } else {
            XmlSchemaElement xmlSchemaElement = xbrlSchema2.getElementByName(qname);
            if (xmlSchemaElement != null && xmlSchemaElement instanceof XbrlConcept) {
                xbrlSchema = (XbrlConcept)xmlSchemaElement;
            }
        }
        QName qName2 = qName = xbrlSchema != null ? xbrlSchema.getQName() : null;
        if (xbrlSchema == null) {
            n = qname.indexOf(":");
            if (n != -1) {
                String string = this.dts.getNamespaceOfPrefix(qname.substring(0, n));
                if (StringUtils.isEmpty((String)string)) {
                    IOHelper.writeMessage((OutputStream)this.out, (String)"\u89e3\u6790\u5143\u7d20\u540d\u5931\u8d25\uff0c\u524d\u7f00\u672a\u5b9a\u4e49\uff01");
                    return false;
                }
                qName = xbrlSchema2.createQName(string, qname.substring(n + 1));
            } else {
                qName = xbrlSchema2.createQName(xbrlSchema2.getTargetNamespace(), qname);
            }
        }
        if (this.xbrlInstance != null) {
            this.f = this.xbrlInstance.getAllFacts(true);
            List<Fact> list = this.f.get(qName);
            if (list != null) {
                for (Fact fact : list) {
                    IOHelper.writeMessage((OutputStream)this.out, (String)("remove " + fact.toString()));
                    this._hasBugFixed = true;
                    fact.getParent().removeChild((XdmNode)fact);
                    fact.getOwnerDocument().setModified(true);
                }
            }
            this.f.remove(qName);
            Map map = this.xbrlInstance.getAllItemsGroupByContext();
            for (Iterator<Object> iterator : this.xbrlInstance.getContexts()) {
                MemberElement[] memberElementArray;
                Map map2 = iterator.getDimensionContents();
                boolean bl = map2.containsKey(qName);
                if (!bl) {
                    Iterator iterator2 = map2.values().iterator();
                    block3: while (iterator2.hasNext()) {
                        MemberElement[] memberElementArray2 = memberElementArray = (MemberElement[])iterator2.next();
                        int n3 = memberElementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            MemberElement memberElement = memberElementArray2[n4];
                            if (memberElement instanceof ExplicitMember && qName.equals(((ExplicitMember)memberElement).getDimensionContent())) {
                                bl = true;
                                continue block3;
                            }
                            ++n4;
                        }
                    }
                }
                if (!bl) continue;
                memberElementArray = (MemberElement[])map.get(iterator);
                if (memberElementArray != null) {
                    for (Fact fact : memberElementArray) {
                        IOHelper.writeMessage((OutputStream)this.out, (String)("remove " + fact.toString()));
                        fact.getParent().removeChild((XdmNode)fact);
                        fact.getOwnerDocument().setModified(true);
                        this._hasBugFixed = true;
                    }
                }
                iterator.getParent().removeChild(iterator);
                iterator.getOwnerDocument().setModified(true);
                this._hasBugFixed = true;
            }
        }
        if (xbrlSchema != null) {
            XbrlSchema xbrlSchema3 = xbrlSchema.getSchema();
            if (xbrlSchema3.isReadOnly()) {
                for (RelationshipSet relationshipSet : this.dts.getRelationshipSets()) {
                    if (!relationshipSet.contains((Object)xbrlSchema)) continue;
                    QName qName3 = relationshipSet.getExtendedName();
                    if (QNameConstants.labelLink.equals((Object)qName3) || QNameConstants.referenceLink.equals((Object)qName3)) {
                        relationshipSet.removeTarget((Object)xbrlSchema, true);
                    } else {
                        relationshipSet.purgeOrProhibitTarget((Object)xbrlSchema, false);
                    }
                    this.b.add(relationshipSet);
                }
                IOHelper.writeMessage((OutputStream)this.out, (String)"\u5220\u9664\u5173\u7cfb\uff0c\u4fdd\u7559\u5b9a\u4e49.");
            } else if (xbrlSchema.getSchema().removeConcept(this.dts, (XbrlConcept)xbrlSchema, true)) {
                xbrlSchema3.setModified(true);
                this._hasBugFixed = true;
                IOHelper.writeMessage((OutputStream)this.out, (String)"\u5220\u9664\u5143\u7d20\u5b9a\u4e49\u53ca\u5176\u5173\u7cfb.");
            }
        }
        outputStream = this.out;
        this.out = null;
        if (this.b.size() > 0) {
            this.rebuildRelationshipSet();
        }
        return this._hasBugFixed;
    }

    public boolean adjustDecimals(String roleURI, String conceptId) {
        Object object;
        this._targetAction = Cleaner.TargetAction.AdjustDecimals;
        OutputStream outputStream = this.out;
        this.out = null;
        this.bugFix();
        this.out = outputStream;
        if (this.xbrlInstance == null) {
            return false;
        }
        XbrlConcept xbrlConcept = null;
        if (!StringUtils.isEmpty((String)conceptId) && (xbrlConcept = this.dts.getConceptById(conceptId)) == null) {
            IOHelper.writeMessage((OutputStream)this.out, (String)("\u6307\u5b9a\u7684\u6839\u5143\u7d20\u672a\u627e\u5230\uff1a" + conceptId));
            return false;
        }
        if (this.f == null) {
            this.f = this.xbrlInstance.getAllFacts(true);
        }
        ArrayList<RelationshipSet> arrayList = null;
        if (!StringUtils.isEmpty((String)roleURI)) {
            object = this.dts.getPresentationRelationships(roleURI);
            if (object == null) {
                IOHelper.writeMessage((OutputStream)this.out, (String)("\u5c55\u793a\u5173\u7cfb\u6ca1\u6709\u627e\u5230\uff1a" + roleURI));
                return false;
            }
            arrayList = new ArrayList();
            arrayList.add((RelationshipSet)object);
        } else {
            arrayList = new ArrayList<RelationshipSet>();
            arrayList.addAll(this.dts.getPresentationRelationships());
        }
        object = new d(xbrlConcept);
        for (RelationshipSet relationshipSet : arrayList) {
            this.a(relationshipSet, (d)object);
        }
        return this._hasBugFixed;
    }

    private void a(RelationshipSet relationshipSet, d d2) {
        if (this.f == null || this.f.size() == 0) {
            return;
        }
        Set<Object> set = d2.b;
        MutableInteger mutableInteger = d2.c;
        Set<XbrlConcept> set2 = d2.d;
        Set<XbrlConcept> set3 = d2.e;
        Set<XbrlConcept> set4 = d2.f;
        Set<XbrlConcept> set5 = d2.g;
        set.clear();
        set2.clear();
        set3.clear();
        set4.clear();
        set5.clear();
        if (d2.a == null) {
            relationshipSet.getAllTargets(set);
        } else {
            this.a(relationshipSet, (Object)d2.a, set, new HashSet<Relationship>());
        }
        int[] nArray = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
        boolean bl = false;
        for (Object object : set) {
            List<Fact> list;
            int n;
            XbrlConcept xbrlConcept;
            if (!(object instanceof XbrlConcept) || (xbrlConcept = (XbrlConcept)object).isAbstract() || xbrlConcept.isNonNumeric() || (n = CasProcessor.getConceptDataType(xbrlConcept)) == -1 || (list = this.f.get(xbrlConcept.getQName())) == null || list.size() == 0) continue;
            switch (n) {
                case 4: {
                    set2.add(xbrlConcept);
                    break;
                }
                case 6: {
                    set3.add(xbrlConcept);
                    break;
                }
                case 0: {
                    set4.add(xbrlConcept);
                    break;
                }
                case 2: {
                    set5.add(xbrlConcept);
                }
            }
            int n2 = Integer.MAX_VALUE;
            int n3 = Integer.MAX_VALUE;
            bl = true;
            for (Fact fact : list) {
                String string = fact.getDecimals();
                if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !Int32.tryParse((String)string, (MutableInteger)mutableInteger)) continue;
                if (n2 == Integer.MAX_VALUE || n2 > mutableInteger.intValue()) {
                    n2 = mutableInteger.intValue();
                }
                if (n3 != Integer.MAX_VALUE && n3 >= mutableInteger.intValue()) continue;
                n3 = mutableInteger.intValue();
            }
            if (n2 != Integer.MAX_VALUE && (nArray[n] == Integer.MAX_VALUE || nArray[n] > n2)) {
                nArray[n] = n2;
            }
            if (n3 == Integer.MAX_VALUE || nArray[n + 1] != Integer.MAX_VALUE && nArray[n + 1] >= n3) continue;
            nArray[n + 1] = n3;
        }
        if (bl) {
            if (nArray[4] != nArray[5]) {
                this.c(d2);
            }
            if (nArray[6] != nArray[7]) {
                this.d(d2);
            }
            if (nArray[2] != nArray[3]) {
                this.e(d2);
            }
            if (nArray[0] != nArray[1]) {
                this.a(d2);
            }
        }
    }

    private void a(d d2) {
        Pair<Integer, Integer> pair = this.b(d2);
        int n = (Integer)pair.value;
        if ((Integer)pair.value == 2) {
            for (XbrlConcept xbrlConcept : d2.f) {
                for (Fact fact : this.f.get(xbrlConcept.getQName())) {
                    String string = fact.getDecimals();
                    if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !StringUtils.isEmpty((String)fact.getAttributeValue(customDecimalsQName)) || !Int32.tryParse((String)string, (MutableInteger)d2.c) || d2.c.intValue() < 0 || d2.c.intValue() >= n) continue;
                    String string2 = fact.toString();
                    fact.setDecimals(Integer.toString(n));
                    String string3 = fact.getInnerText();
                    String string4 = Fact.getDecimalRoundedValue((String)string3, (int)n);
                    fact.setInnerText(string4);
                    this.fixBug(String.valueOf(string2) + " @decimals=" + d2.c + "->" + n);
                }
            }
        }
    }

    private Pair<Integer, Integer> a(XbrlConcept xbrlConcept, d d2) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        MutableInteger mutableInteger = d2.c;
        for (Fact fact : this.f.get(xbrlConcept.getQName())) {
            String string = fact.getDecimals();
            if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !StringUtils.isEmpty((String)fact.getAttributeValue(customDecimalsQName)) || !Int32.tryParse((String)string, (MutableInteger)mutableInteger)) continue;
            if (n == Integer.MAX_VALUE || n > mutableInteger.intValue()) {
                n = mutableInteger.intValue();
            }
            if (n2 != Integer.MAX_VALUE && n2 >= mutableInteger.intValue()) continue;
            n2 = mutableInteger.intValue();
        }
        return new Pair((Object)n, (Object)n2);
    }

    private Pair<Integer, Integer> b(d d2) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        MutableInteger mutableInteger = d2.c;
        for (XbrlConcept xbrlConcept : d2.f) {
            for (Fact fact : this.f.get(xbrlConcept.getQName())) {
                String string = fact.getDecimals();
                if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !StringUtils.isEmpty((String)fact.getAttributeValue(customDecimalsQName)) || !Int32.tryParse((String)string, (MutableInteger)mutableInteger)) continue;
                if (n == Integer.MAX_VALUE || n > mutableInteger.intValue()) {
                    n = mutableInteger.intValue();
                }
                if (n2 != Integer.MAX_VALUE && n2 >= mutableInteger.intValue()) continue;
                n2 = mutableInteger.intValue();
            }
        }
        return new Pair((Object)n, (Object)n2);
    }

    private void c(d d2) {
        for (XbrlConcept xbrlConcept : d2.d) {
            Pair<Integer, Integer> pair = this.a(xbrlConcept, d2);
            if ((Integer)pair.key == Integer.MAX_VALUE || pair.key == pair.value) continue;
            int n = (Integer)pair.value;
            for (Fact fact : this.f.get(xbrlConcept.getQName())) {
                String string = fact.getDecimals();
                if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !StringUtils.isEmpty((String)fact.getAttributeValue(customDecimalsQName)) || !Int32.tryParse((String)string, (MutableInteger)d2.c) || d2.c.intValue() >= n) continue;
                String string2 = fact.toString();
                fact.setDecimals(Integer.toString(n));
                String string3 = fact.getInnerText();
                String string4 = Fact.getDecimalRoundedValue((String)string3, (int)n);
                fact.setInnerText(string4);
                this.fixBug(String.valueOf(string2) + " @decimals=" + d2.c + "->" + n);
            }
        }
    }

    private void d(d d2) {
        for (XbrlConcept xbrlConcept : d2.e) {
            Pair<Integer, Integer> pair = this.a(xbrlConcept, d2);
            if ((Integer)pair.key == Integer.MAX_VALUE || pair.key == pair.value) continue;
            int n = (Integer)pair.value;
            for (Fact fact : this.f.get(xbrlConcept.getQName())) {
                String string = fact.getDecimals();
                if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !StringUtils.isEmpty((String)fact.getAttributeValue(customDecimalsQName)) || !Int32.tryParse((String)string, (MutableInteger)d2.c) || d2.c.intValue() >= n) continue;
                String string2 = fact.toString();
                fact.setDecimals(Integer.toString(n));
                String string3 = fact.getInnerText();
                String string4 = Fact.getDecimalRoundedValue((String)string3, (int)n);
                fact.setInnerText(string4);
                this.fixBug(String.valueOf(string2) + " @decimals=" + d2.c + "->" + n);
            }
        }
    }

    private void e(d d2) {
        for (XbrlConcept xbrlConcept : d2.g) {
            Pair<Integer, Integer> pair = this.a(xbrlConcept, d2);
            if ((Integer)pair.key == Integer.MAX_VALUE || pair.key == pair.value) continue;
            int n = (Integer)pair.value;
            for (Fact fact : this.f.get(xbrlConcept.getQName())) {
                String string = fact.getDecimals();
                if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !StringUtils.isEmpty((String)fact.getAttributeValue(customDecimalsQName)) || !Int32.tryParse((String)string, (MutableInteger)d2.c) || d2.c.intValue() >= n) continue;
                String string2 = fact.toString();
                fact.setDecimals(Integer.toString(n));
                String string3 = fact.getInnerText();
                String string4 = Fact.getDecimalRoundedValue((String)string3, (int)n);
                fact.setInnerText(string4);
                this.fixBug(String.valueOf(string2) + " @decimals=" + d2.c + "->" + n);
            }
        }
    }

    @Override
    protected RoleType createRoleType(String roleURI, String id, String definition) {
        XbrlSchema[] xbrlSchemaArray;
        XbrlSchema[] xbrlSchemaArray2 = xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray2[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                RoleType[] roleTypeArray = xbrlSchema.getRoleTypes().get(roleURI);
                if (roleTypeArray.length > 0) {
                    return roleTypeArray[0];
                }
                RoleType roleType = xbrlSchema.createRoleType(roleURI, id);
                xbrlSchema.addRoleType(roleType);
                Definition definition2 = roleType.createDefinition();
                String string = id;
                int n3 = Math.max(string.lastIndexOf("_"), string.lastIndexOf("-"));
                if (n3 != -1) {
                    string = string.substring(n3 + 1);
                }
                definition2.setInnerText("[" + string + "] " + definition);
                roleType.appendChild((XdmNode)definition2);
                UsedOn usedOn = roleType.createUsedOn((QName)QNameConstants.presentationLink);
                roleType.appendChild((XdmNode)usedOn);
                usedOn = roleType.createUsedOn((QName)QNameConstants.definitionLink);
                roleType.appendChild((XdmNode)usedOn);
                usedOn = roleType.createUsedOn((QName)QNameConstants.calculationLink);
                roleType.appendChild((XdmNode)usedOn);
                xbrlSchema.setModified(true);
                this.dts.getRoleTypes().add(roleType);
                return roleType;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Map<String, String> renameRoleURI2013() {
        RoleType roleType;
        this._targetAction = Cleaner.TargetAction.UpgradeRoleURI;
        OutputStream outputStream = this.out;
        this.out = null;
        this.bugFix();
        this.out = outputStream;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.getExtendMode().isRedefineMode()) {
            Object object;
            Object object2;
            Object object3;
            this.t = CasProcessor.getIndustry(this.dts);
            if (this.t == null || this.t.length == 0) {
                ArrayList<RoleType> object7 = new ArrayList<RoleType>((Collection<RoleType>)this.dts.getRoleTypes());
                for (Object object4 : object7) {
                    if (XbrlHelper.isReadOnly((XdmElement)object4)) continue;
                    roleType = RoleVersion.Unknown;
                    if (this instanceof Cas2015Cleaner) {
                        roleType = RoleVersion.V2015;
                    }
                    if (!((CasRedefineRoleType)(object3 = new CasRedefineRoleType((RoleType)object4, (RoleVersion)roleType))).isValid() || !StringUtils.isEmpty((String)((CasRedefineRoleType)object3).getCodeSuffix()) || ((CasRedefineRoleType)object3).getCodeCount() != 2 || !this.a(object7, (String)(object2 = object4.getRoleURI()), (String)(object = ((CasRedefineRoleType)object3).getCas2013URI()))) continue;
                    hashMap.put((String)object2, (String)object);
                }
            } else if (this.t.length == 1) {
                Object object4;
                String string = this.t[0];
                object4 = new net.gbicc.xbrl.cleaner.a(this.dts, this.q);
                ArrayList arrayList = new ArrayList(this.dts.getRoleTypes());
                object3 = arrayList.iterator();
                while (object3.hasNext()) {
                    String string2;
                    String string3;
                    roleType = (RoleType)object3.next();
                    if (XbrlHelper.isReadOnly((XdmElement)roleType)) continue;
                    object2 = RoleVersion.Unknown;
                    if (this instanceof Cas2015Cleaner) {
                        object2 = RoleVersion.V2015;
                    }
                    if (!((CasRedefineRoleType)(object = new CasRedefineRoleType(roleType, (RoleVersion)((Object)object2)))).isValid() || !StringUtils.isEmpty((String)((CasRedefineRoleType)object).getCodeSuffix()) || ((CasRedefineRoleType)object).getCodeCount() != 2 || !this.a(arrayList, string3 = roleType.getRoleURI(), string2 = ((net.gbicc.xbrl.cleaner.a)object4).a((CasRedefineRoleType)object, string))) continue;
                    hashMap.put(string3, string2);
                }
            }
        }
        if (hashMap.size() > 0) {
            roleType = this.dts.getDocuments();
            int n = ((IXbrlDocument[])roleType).length;
            int n2 = 0;
            while (n2 < n) {
                IXbrlDocument iXbrlDocument = roleType[n2];
                if (!iXbrlDocument.isReadOnly()) {
                    iXbrlDocument.setModified(true);
                }
                ++n2;
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                this.changeMenuRoleURI((String)entry.getKey(), (String)entry.getValue());
            }
            this.t();
        }
        this.fixBug("\u66f4\u65b0\u4e86" + hashMap.size() + "\u7ec4\u89d2\u8272.");
        return hashMap;
    }

    private void t() {
        IXbrlDocument[] iXbrlDocumentArray;
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                Map<String, RoleRef> map = this.b(linkbase);
                HashSet<String> hashSet = new HashSet<String>();
                for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                    PresentationArc presentationArc;
                    String string;
                    XdmNode xdmNode;
                    QName qName = extendedLink.getNodeName();
                    hashSet.add(extendedLink.getRole());
                    if (QNameConstants.presentationLink.equals((Object)qName)) {
                        xdmNode = extendedLink.getFirstChild();
                        while (xdmNode != null) {
                            if (xdmNode.isElement() && xdmNode instanceof PresentationArc && !StringUtils.isEmpty((String)(string = (presentationArc = (PresentationArc)xdmNode).getPreferredLabel()))) {
                                hashSet.add(string);
                            }
                            xdmNode = xdmNode.getNextSibling();
                        }
                        continue;
                    }
                    if (QNameConstants.definitionLink.equals((Object)qName)) {
                        xdmNode = extendedLink.getFirstChild();
                        while (xdmNode != null) {
                            if (xdmNode.isElement() && xdmNode instanceof DefinitionArc && !StringUtils.isEmpty((String)(string = (presentationArc = (DefinitionArc)xdmNode).getTargetRole()))) {
                                hashSet.add(string);
                            }
                            xdmNode = xdmNode.getNextSibling();
                        }
                        continue;
                    }
                    if (QNameConstants.calculationLink.equals((Object)qName)) continue;
                    presentationArc = extendedLink.getRelationships().iterator();
                    while (presentationArc.hasNext()) {
                        String string2;
                        xdmNode = (Relationship)presentationArc.next();
                        if (xdmNode.isRemoved() || !(xdmNode.toTarget() instanceof Resource) || StringUtils.isEmpty((String)(string2 = (string = (Resource)xdmNode.toTarget()).getRole()))) continue;
                        hashSet.add(string2);
                    }
                }
                for (String string : hashSet) {
                    map.remove(string);
                }
                if (map.size() > 0) {
                    for (RoleRef roleRef : map.values()) {
                        roleRef.getParent().removeChild((XdmNode)roleRef);
                    }
                    iXbrlDocument.setModified(true);
                }
            }
            ++n2;
        }
    }

    private boolean a(List<RoleType> list, String string, String string2) {
        if (string.equals(string2)) {
            return false;
        }
        for (RoleType roleType : list) {
            String string3 = roleType.getRoleURI();
            if (!string3.startsWith(string)) continue;
            String string4 = String.valueOf(string2) + string3.substring(string.length());
            roleType.setRoleURI(string4, new TaxonomySet[]{this.dts});
        }
        return true;
    }

    public String renameRoleURIs(List<RoleTypeRename> roleTypes) {
        if (roleTypes == null || roleTypes.size() == 0) {
            return null;
        }
        CasReorderRoleTypes casReorderRoleTypes = new CasReorderRoleTypes(this, this.dts);
        Map<String, String> map = casReorderRoleTypes.reorder(roleTypes);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.changeMenuRoleURI(entry.getKey(), entry.getValue());
        }
        return casReorderRoleTypes.getErrorMessage();
    }

    @Override
    public boolean renameRoleURI(String oldURI, String newURI, String newId) {
        Object object2;
        this._targetAction = Cleaner.TargetAction.ChangeRoleURI;
        if (StringUtils.isEmpty((String)oldURI) || StringUtils.isEmpty((String)newURI)) {
            return false;
        }
        OutputStream outputStream = this.out;
        this.out = null;
        this.bugFix();
        this.out = outputStream;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(oldURI);
        XbrlSchema xbrlSchema = null;
        RoleType roleType = this.getEntrySchema();
        int n = ((XbrlSchema[])roleType).length;
        int n2 = 0;
        while (n2 < n) {
            object2 = roleType[n2];
            if (object2 != null && !object2.isReadOnly()) {
                xbrlSchema = object2;
            }
            ++n2;
        }
        if (xbrlSchema == null) {
            return false;
        }
        object2 = null;
        n2 = oldURI.lastIndexOf("/");
        if (n2 != -1) {
            object2 = oldURI.substring(n2 + 1);
            if (((String)object2).length() != 6) {
                this.fixBug("old roleURI: " + oldURI + ": the code after '/' length != 6.", true);
                return false;
            }
        } else {
            this.fixBug("old roleURI: " + oldURI + " is invalid.", true);
            return false;
        }
        RoleType[] roleTypeArray = this.dts.getRoleTypes().get(oldURI);
        if (roleTypeArray == null || roleTypeArray.length == 0) {
            roleTypeArray = xbrlSchema.getRoleTypes().get(oldURI);
        }
        if (roleTypeArray == null || roleTypeArray.length == 0) {
            this.fixBug("old roleURI: " + oldURI + " is not exists.", true);
            return false;
        }
        Object object3 = roleTypeArray;
        int n3 = roleTypeArray.length;
        int n4 = 0;
        while (n4 < n3) {
            roleType = object3[n4];
            if (roleType.getOwnerDocument().isReadOnly()) {
                this.fixBug("old roleURI: " + oldURI + " is readOnly.", true);
                return false;
            }
            ++n4;
        }
        roleType = roleTypeArray[0];
        if (oldURI.equals(newURI)) {
            if (!roleType.getId().equals(newId)) {
                if (xbrlSchema.getElementById(newId) != null) {
                    throw new IllegalArgumentException("new id: " + newId + " is used.");
                }
                ArrayList<Linkbase> arrayList = new ArrayList<Linkbase>();
                for (RelationshipSet relationshipSet : this.dts.getRelationshipSets(oldURI)) {
                    for (Linkbase linkbase2 : this.getLinkbases(relationshipSet.getExtendedLinks())) {
                        if (linkbase2.getOwnerDocument().isReadOnly()) {
                            return false;
                        }
                        arrayList.add(linkbase2);
                    }
                }
                roleType.setId(newId);
                xbrlSchema.setModified(true);
                for (Linkbase linkbase : arrayList) {
                    Linkbase linkbase2;
                    linkbase2 = linkbase.getRoleRef(oldURI);
                    if (linkbase2 == null) continue;
                    linkbase2.setRoleType(roleType);
                    linkbase.getOwnerDocument().setModified(true);
                }
            }
            return true;
        }
        RoleType[] roleTypeArray2 = this.dts.getRoleTypes().get(newURI);
        if (roleTypeArray2 != null && roleTypeArray2.length != 0) {
            this.fixBug("new roleURI: " + newURI + " is exists.", true);
            return false;
        }
        RelationshipSet relationshipSet = this.dts.getPresentationRelationships(oldURI);
        object3 = roleType.getDefinitionText();
        n2 = ((String)object3).indexOf("]");
        if (n2 != -1) {
            object3 = ((String)object3).substring(n2 + 1).trim();
        }
        HashSet<Linkbase> hashSet2 = new HashSet<Linkbase>();
        List<RelationshipSet> list = this.c(oldURI);
        ArrayList<RelationshipSet> arrayList = new ArrayList<RelationshipSet>(list);
        if (relationshipSet != null) {
            arrayList.add(relationshipSet);
        }
        arrayList.addAll(this.b(oldURI));
        HashSet<Object> hashSet3 = new HashSet<Object>();
        for (RelationshipSet relationshipSet2 : arrayList) {
            RoleRef roleRef;
            Object object;
            Linkbase linkbase2;
            Collection collection2;
            String string = relationshipSet2.getRoleURI();
            hashSet.add(string);
            String string2 = string.replace(oldURI, newURI);
            n2 = string2.lastIndexOf(47);
            if (n2 == -1) continue;
            String string3 = string2.substring(n2 + 1);
            String string4 = roleType.getId();
            String string5 = string4.replace((CharSequence)object2, string3);
            RoleType roleType2 = null;
            if (!hashSet3.contains(string2)) {
                hashSet3.add(string2);
                roleType2 = this.createRoleType(string2, string5, (String)object3);
                for (Collection collection2 : roleType.getUsedOns()) {
                    try {
                        linkbase2 = collection2.getQName();
                        if (roleType2.canUsedOn((QName)linkbase2)) continue;
                        object = roleType2.createUsedOn((QName)linkbase2);
                        roleType2.appendChild((XdmNode)object);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.fixBug("create roleType = " + (String)string2);
                this._hasBugFixed = true;
                this.changeMenuRoleURI(string, string2);
            } else {
                roleType2 = this.dts.getRoleTypes().getSingle(string2);
            }
            collection2 = relationshipSet2.getExtendedLinks();
            Collection<Linkbase> collection3 = this.getLinkbases(collection2);
            object = collection3.iterator();
            while (object.hasNext()) {
                linkbase2 = (Linkbase)object.next();
                hashSet2.add(linkbase2);
                roleRef = linkbase2.getRoleRef(string2);
                if (roleRef != null) continue;
                roleRef = linkbase2.createRoleRef(string2, null);
                linkbase2.prependChild((XdmNode)roleRef);
                roleRef.setRoleType(roleType2);
            }
            for (Linkbase linkbase2 : collection2) {
                linkbase2.setRole(string2);
            }
            this.dts.removeRelationshipSets(relationshipSet2);
            for (Linkbase linkbase2 : collection2) {
                roleRef = new ExtendedLinkSummary((ExtendedLink)linkbase2, this.dts);
                RelationshipSet relationshipSet3 = roleRef.getRelationshipSet();
                if (relationshipSet3 == null) continue;
                this.b.add(relationshipSet3);
            }
        }
        outputStream = this.out;
        this.out = null;
        ArrayList<String> arrayList2 = new ArrayList<String>(1);
        arrayList2.add(newURI);
        if (hashSet2 != null && hashSet2.size() > 0) {
            HashSet<String> hashSet4 = new HashSet<String>();
            for (Linkbase linkbase : hashSet2) {
                this.removeUnusedRoleRef(linkbase, hashSet4, arrayList2);
            }
        }
        if (this.b.size() > 0) {
            this.rebuildRelationshipSet();
            for (String string : hashSet) {
                this.a(string);
            }
        }
        return this._hasBugFixed;
    }

    protected void removeUnusedRoleRef(Linkbase linkbase, Set<String> roleURIs, List<String> ignoreRoleURIs) {
        String string;
        ExtendedLink extendedLink2;
        List list = linkbase.getRoleRefs();
        List list2 = linkbase.getExtendedLinks();
        for (ExtendedLink extendedLink2 : list2) {
            string = extendedLink2.getRole();
            if (string == null) continue;
            if (extendedLink2.isEmpty() && !ignoreRoleURIs.contains(string)) {
                if (extendedLink2.getParent() == null) continue;
                extendedLink2.getParent().removeChild((XdmNode)extendedLink2);
                continue;
            }
            roleURIs.add(string);
        }
        extendedLink2 = new HashSet();
        int n = list.size() - 1;
        while (n > -1) {
            string = (RoleRef)list.get(n);
            String string2 = string.getRoleURI();
            if (extendedLink2.contains(string2)) {
                string.getOwnerDocument().setModified(true);
                string.getParent().removeChild((XdmNode)string);
                this.fixBug("remove dup roleRef = " + string2, true);
            } else {
                extendedLink2.add(string2);
                if (string2 != null && !roleURIs.contains(string2) && string.getParent() != null) {
                    string.getOwnerDocument().setModified(true);
                    string.getParent().removeChild((XdmNode)string);
                }
            }
            --n;
        }
    }

    public boolean changeConcepts(List<Pair<String, String>> changePairs) {
        if (changePairs == null || changePairs.size() == 0) {
            return true;
        }
        ArrayList<ChangeConceptInfo> arrayList = new ArrayList<ChangeConceptInfo>();
        for (Pair<String, String> pair : changePairs) {
            arrayList.add(new ChangeConceptInfo(pair));
        }
        return this.changeConceptNameAndLabel(arrayList);
    }

    @Override
    public boolean changeConceptNameAndLabel(List<ChangeConceptInfo> changePairs) {
        Object object;
        this._targetAction = Cleaner.TargetAction.ChangeConceptName;
        if (changePairs == null || changePairs.size() == 0) {
            return false;
        }
        OutputStream outputStream = this.out;
        this.out = null;
        this.bugFix();
        this.out = outputStream;
        Object object2 = null;
        XbrlSchema[] xbrlSchemaArray = this.getEntrySchema();
        boolean bl = xbrlSchemaArray.length;
        boolean bl2 = false;
        while (bl2 < bl) {
            object = xbrlSchemaArray[bl2];
            if (object != null && !object.isReadOnly()) {
                object2 = object;
            }
            bl2 += 1;
        }
        if (object2 == null) {
            return false;
        }
        if (this.xbrlInstance != null) {
            this.f = this.xbrlInstance.getAllFacts(true);
        }
        object = object2.getTargetNamespace();
        bl2 = this.isCurrentFiscalYearComplete();
        for (ChangeConceptInfo changeConceptInfo : changePairs) {
            XbrlConcept xbrlConcept;
            boolean bl3;
            boolean bl4;
            XbrlConcept xbrlConcept2;
            String string;
            String string2;
            Object object3 = object;
            String string3 = changeConceptInfo.getOldConceptName();
            String string4 = changeConceptInfo.getOldConceptName();
            String string5 = changeConceptInfo.getNewConceptName();
            int n = changeConceptInfo.getOldConceptName().indexOf(":");
            if (n != -1) {
                string2 = changeConceptInfo.getOldConceptName().substring(0, n);
                string3 = changeConceptInfo.getOldConceptName().substring(n + 1);
                object3 = this.dts.getNamespaceOfPrefix(string2);
                if (StringUtils.isEmpty((String)object3)) {
                    this.fixBug("Old concept: " + changeConceptInfo.getOldConceptName() + " prefix is not valid.", true);
                    continue;
                }
            } else {
                string4 = String.valueOf(object2.defaultPrefix()) + ":" + string3;
            }
            string2 = string5;
            Object object4 = object;
            n = string5.indexOf(":");
            if (n != -1) {
                string = string5.substring(0, n);
                string2 = string5.substring(n + 1);
                object4 = this.dts.getNamespaceOfPrefix(string);
                if (StringUtils.isEmpty((String)object4)) {
                    this.fixBug("New concept: " + string5 + " prefix is not valid.", true);
                    continue;
                }
            }
            if (!XmlChar.isNCName((String)string2)) {
                this.fixBug("New concept: " + string5 + " localName is not valid.", true);
                continue;
            }
            string = this.dts.getConcept(string3, (String)object3);
            XmlSchemaElement xmlSchemaElement = null;
            if (((String)object4).equals(object)) {
                xmlSchemaElement = object2.getElementByName(string2);
            } else {
                xbrlConcept2 = this.dts.getSchemas((String)object4);
                if (xbrlConcept2 != null && ((XmlSchema[])xbrlConcept2).length > 0) {
                    XbrlConcept xbrlConcept3 = xbrlConcept2;
                    bl4 = ((XmlSchema[])xbrlConcept3).length;
                    bl3 = false;
                    while (bl3 < bl4) {
                        xbrlConcept = xbrlConcept3[bl3];
                        xmlSchemaElement = xbrlConcept.getElementByName(string2);
                        if (xmlSchemaElement != null) break;
                        bl3 += 1;
                    }
                }
                if (xmlSchemaElement == null) {
                    this.fixBug("New concept: " + string5 + " is not found in the DTS.", true);
                    continue;
                }
            }
            if (changeConceptInfo.isChangeLabel() && string != null && string instanceof XbrlConcept) {
                xbrlConcept2 = (XbrlConcept)string;
                this.a(xbrlConcept2, changeConceptInfo);
            }
            if (!changeConceptInfo.isChangeName()) continue;
            if (string == null) {
                this.fixBug("Old concept: " + string3 + " not found.", true);
                xbrlConcept2 = (XbrlConcept)xmlSchemaElement;
                xbrlConcept = object2.createQName((String)object3, string3);
                if (xmlSchemaElement != null && xmlSchemaElement instanceof XbrlConcept) {
                    this.changeMenuConcept(string4, string5);
                    if (this.a((QName)xbrlConcept, xbrlConcept2, false)) {
                        this.a(xmlSchemaElement.getQName());
                        this.fixBug("Change missing old concept: " + changeConceptInfo.getOldConceptName() + " to " + string5 + ".", true);
                    }
                }
                this.a((QName)xbrlConcept, xbrlConcept2);
                if (this.q != null && xbrlConcept2.getLabels(this.dts).size() == 0) {
                    this.a(xbrlConcept2, this.q.getLabelRelationships(), this.dts.getLabelRelationships());
                } else {
                    this.y();
                }
                this.fixBug("change concept: " + string4 + " --> " + xbrlConcept2.getPrefixedName());
                continue;
            }
            if (!(string instanceof XbrlConcept)) {
                this.fixBug("Old concept: " + changeConceptInfo.getOldConceptName() + " is not an Xbrl concept.", true);
                continue;
            }
            xbrlConcept2 = (XbrlConcept)string;
            if (!xbrlConcept2.isItem()) {
                this.fixBug("Old concept: " + changeConceptInfo.getOldConceptName() + " is not a top item concept.", true);
                continue;
            }
            xbrlConcept = null;
            bl3 = false;
            bl4 = false;
            if (xmlSchemaElement != null) {
                if (xmlSchemaElement instanceof XbrlConcept) {
                    xbrlConcept = (XbrlConcept)xmlSchemaElement;
                    bl3 = true;
                } else {
                    this.fixBug("New concept: " + string5 + " is not an Xbrl concept.", true);
                    continue;
                }
            }
            if (bl3 && this.f != null && xbrlConcept != null && this.f.containsKey(xbrlConcept2.getQName())) {
                if (xbrlConcept.isAbstract()) {
                    this.fixBug("New concept: " + string5 + " is abstract, old concept is used in instance.", true);
                    continue;
                }
                if (xbrlConcept.isNumeric() != xbrlConcept2.isNumeric() || xbrlConcept.isMonetaryItem() != xbrlConcept2.isMonetaryItem()) {
                    this.fixBug("Old concept: " + changeConceptInfo.getOldConceptName() + "'s dataType is differenct from the new concept.", true);
                    continue;
                }
                if (xbrlConcept.getPeriodType() != xbrlConcept2.getPeriodType()) {
                    boolean bl5;
                    boolean bl6 = bl5 = bl2 && this.canChangeContext(bl2, this.f.get(xbrlConcept2.getQName()));
                    if (!bl5) {
                        this.fixBug("Old concept: " + changeConceptInfo.getOldConceptName() + "'s periodType is differenct from the new concept.", true);
                        continue;
                    }
                    bl4 = true;
                }
            }
            if (xbrlConcept == null) {
                xbrlConcept = this.a((XbrlSchema)object2, string2, xbrlConcept2);
            }
            if (xbrlConcept == null) continue;
            if (bl3) {
                this.c(xbrlConcept2);
            }
            this.a(xbrlConcept2, xbrlConcept);
            this.a(xbrlConcept2.getQName(), xbrlConcept, bl4);
            if (xbrlConcept2.getSchema() == object2) {
                object2.removeItem((XmlSchemaObject)xbrlConcept2);
            }
            if (this.q != null && xbrlConcept.getLabels(this.dts).size() == 0) {
                this.a(xbrlConcept, this.q.getLabelRelationships(), this.dts.getLabelRelationships());
            } else {
                this.y();
            }
            this.a(xbrlConcept.getQName());
            this.fixBug("change concept: " + xbrlConcept2.getPrefixedName() + " --> " + xbrlConcept.getPrefixedName());
            this.changeMenuConcept(string4, string5);
        }
        return this._hasBugFixed;
    }

    private void a(XbrlConcept xbrlConcept, ChangeConceptInfo changeConceptInfo) {
        if (StringUtils.isEmpty((String)changeConceptInfo.getNewEnglishLabel())) {
            return;
        }
        if (this.u == null) {
            this.u = this.dts.getLabelRelationships();
        }
        for (RelationshipSet relationshipSet : this.u) {
            for (Relationship relationship : relationshipSet.getEffectiveChildren((Object)xbrlConcept)) {
                Label label;
                boolean bl;
                Object object;
                if (relationship.arc().getUse() != ArcUse.Optional || (object = relationship.toTarget()) == null || !(object instanceof Label) || !(bl = "http://www.xbrl.org/2003/role/label".equals((label = (Label)object).getRole())) || !label.getLang().startsWith("en") || StringUtils.isEmpty((String)changeConceptInfo.getNewEnglishLabel()) || label.getInnerText().equals(changeConceptInfo.getNewEnglishLabel())) continue;
                label.setInnerText(changeConceptInfo.getNewEnglishLabel());
                this.fixBug("change concept label: " + xbrlConcept.getPrefixedName() + " --> " + changeConceptInfo.getNewEnglishLabel());
                this._hasBugFixed = true;
                label.getOwnerDocument().setModified(true);
            }
        }
    }

    private void a(QName qName) {
        if (this.xbrlInstance == null) {
            return;
        }
        this.f = this.xbrlInstance.getAllFacts(true);
        List<Fact> list = this.f.get(qName);
        if (list == null || list.size() == 0) {
            return;
        }
        int n = list.size() - 1;
        while (n > 0) {
            Fact fact = list.get(n);
            int n2 = n - 1;
            while (n2 > -1) {
                Fact fact2 = list.get(n2);
                if (fact.getParent() == fact2.getParent() && this.a(fact, fact2)) {
                    fact.getParent().removeChild((XdmNode)fact);
                    list.remove(n);
                    break;
                }
                --n2;
            }
            --n;
        }
    }

    private boolean a(Fact fact, Fact fact2) {
        Context context;
        Context context2 = fact.getContext();
        if (context2 != (context = fact2.getContext())) {
            if (context2 == null || context == null) {
                return false;
            }
            if (!context2.SEqual((XbrlElement)context)) {
                return false;
            }
        }
        if (fact.isDuplicate(fact2)) {
            return fact.getInnerText().equals(fact2.getInnerText());
        }
        return false;
    }

    private void c(XbrlConcept xbrlConcept) {
        if (xbrlConcept == null) {
            return;
        }
        for (RelationshipSet relationshipSet : this.dts.getLabelRelationships()) {
            relationshipSet.purgeOrProhibitTarget((Object)xbrlConcept);
            this._hasBugFixed = true;
        }
        for (RelationshipSet relationshipSet : this.dts.getReferenceRelationships()) {
            relationshipSet.purgeOrProhibitTarget((Object)xbrlConcept);
            this._hasBugFixed = true;
        }
    }

    private void a(XbrlConcept xbrlConcept, XbrlConcept xbrlConcept2) {
        IXbrlDocument[] iXbrlDocumentArray = this.dts.getDocuments();
        ArrayList<Locator> arrayList = new ArrayList<Locator>();
        ArrayList<Locator> arrayList2 = new ArrayList<Locator>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray;
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                    Locator locator;
                    arrayList.clear();
                    arrayList2.clear();
                    XdmNode xdmNode = extendedLink.getFirstChild();
                    while (xdmNode != null) {
                        if (xdmNode instanceof Locator) {
                            locator = (Locator)xdmNode;
                            Object object = locator.getFinalTarget();
                            if (object == xbrlConcept2) {
                                arrayList2.add(locator);
                            } else if (object == xbrlConcept) {
                                arrayList.add(locator);
                            }
                        }
                        xdmNode = xdmNode.getNextSibling();
                    }
                    if (arrayList.size() <= 0) continue;
                    hashMap.clear();
                    boolean bl = arrayList2.size() > 0;
                    this._hasBugFixed = true;
                    int n3 = 0;
                    int n4 = arrayList.size();
                    while (n3 < n4) {
                        Locator locator2 = (Locator)arrayList.get(n3);
                        String string = locator2.getLabel();
                        String string2 = xbrlConcept.getName();
                        String string3 = xbrlConcept2.getName();
                        String string4 = (String)hashMap.get(string);
                        if (string4 == null) {
                            string4 = string.equals(string2) ? string3 : (string.contains(string2) ? string.replace(string2, string3) : string3);
                            if (bl) {
                                String string5 = string4;
                                int n5 = 1;
                                while (this.a((List<Locator>)arrayList2, string5)) {
                                    string5 = String.valueOf(string4) + "_cc_" + ++n5;
                                }
                                string4 = string5;
                            }
                            hashMap.put(string, string4);
                        }
                        locator2.setTarget((Object)xbrlConcept2);
                        locator2.setLabel(string4);
                        this.a(extendedLink, string, string4);
                        ++n3;
                    }
                    locator = this.dts.getRelationshipSet(extendedLink.getNodeName(), extendedLink.getRole());
                    if (locator == null) continue;
                    this.b.add(locator);
                }
            }
            ++n2;
        }
        this.rebuildRelationshipSet();
    }

    private void a(QName qName, XbrlConcept xbrlConcept) {
        String string = this.dts.getPrefixOfNamespaceURI(qName.getNamespaceURI());
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        String string2 = "#" + string + "_" + qName.getLocalPart();
        IXbrlDocument[] iXbrlDocumentArray = this.dts.getDocuments();
        ArrayList<Locator> arrayList = new ArrayList<Locator>();
        ArrayList<Locator> arrayList2 = new ArrayList<Locator>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray;
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                    String string3;
                    Locator locator;
                    arrayList.clear();
                    arrayList2.clear();
                    XdmNode xdmNode = extendedLink.getFirstChild();
                    while (xdmNode != null) {
                        if (xdmNode instanceof Locator) {
                            locator = (Locator)xdmNode;
                            Object object = locator.getFinalTarget();
                            string3 = locator.getHref();
                            if (object == xbrlConcept) {
                                arrayList2.add(locator);
                            } else if (string3.endsWith(string2)) {
                                arrayList.add(locator);
                            }
                        }
                        xdmNode = xdmNode.getNextSibling();
                    }
                    if (arrayList.size() <= 0) continue;
                    hashMap.clear();
                    boolean bl = arrayList2.size() > 0;
                    this._hasBugFixed = true;
                    int n3 = 0;
                    int n4 = arrayList.size();
                    while (n3 < n4) {
                        string3 = (Locator)arrayList.get(n3);
                        String string4 = string3.getLabel();
                        String string5 = qName.getLocalPart();
                        String string6 = xbrlConcept.getName();
                        String string7 = (String)hashMap.get(string4);
                        if (string7 == null) {
                            string7 = string4.equals(string5) ? string6 : (string4.contains(string5) ? string4.replace(string5, string6) : string6);
                            if (bl) {
                                String string8 = string7;
                                int n5 = 1;
                                while (this.a((List<Locator>)arrayList2, string8)) {
                                    string8 = String.valueOf(string7) + "_cc_" + ++n5;
                                }
                                string7 = string8;
                            }
                            hashMap.put(string4, string7);
                        }
                        string3.setTarget((Object)xbrlConcept);
                        string3.setLabel(string7);
                        this.a(extendedLink, string4, string7);
                        ++n3;
                    }
                    locator = this.dts.getRelationshipSet(extendedLink.getNodeName(), extendedLink.getRole());
                    if (locator == null) continue;
                    this.b.add(locator);
                }
            }
            ++n2;
        }
        this.rebuildRelationshipSet();
    }

    private boolean a(List<Locator> list, String string) {
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            Locator locator = list.get(n);
            if (locator.getLabel().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void a(ExtendedLink extendedLink, String string, String string2) {
        XdmNode xdmNode = extendedLink.getFirstChild();
        while (xdmNode != null) {
            if (xdmNode instanceof Arc) {
                Arc arc = (Arc)xdmNode;
                if (arc.getFrom().equals(string)) {
                    arc.setFrom(string2);
                }
                if (arc.getTo().equals(string)) {
                    arc.setTo(string2);
                }
            }
            xdmNode = xdmNode.getNextSibling();
        }
    }

    private XbrlConcept a(XbrlSchema xbrlSchema, String string, XbrlConcept xbrlConcept) {
        String string2 = xbrlSchema.defaultPrefix();
        xbrlSchema.setModified(true);
        XbrlConcept xbrlConcept2 = new XbrlConcept((XmlSchema)xbrlSchema, true);
        xbrlConcept2.addNamespaces(xbrlConcept.getNamespaceContext());
        xbrlConcept2.setName(string);
        xbrlConcept2.setId(String.valueOf(string2) + "_" + string);
        if (xbrlConcept.getSchemaTypeName() != null && !xbrlConcept.getSchemaTypeName().isEmpty()) {
            xbrlConcept2.setSchemaTypeName(xbrlConcept.getSchemaTypeName());
        }
        xbrlConcept2.setPeriodType(xbrlConcept.getPeriodType());
        xbrlConcept2.setBalance(xbrlConcept.getBalance());
        if (xbrlConcept.getRefName() != null) {
            xbrlConcept2.getRef().setTargetQName(xbrlConcept.getRefName());
        }
        xbrlConcept2.setSubstitutionGroup(xbrlConcept.getSubstitutionGroup());
        xbrlConcept2.setNillable(xbrlConcept.isNillable());
        xbrlConcept2.setAbstract(xbrlConcept.isAbstract());
        xbrlConcept2.setMinOccurs(xbrlConcept.getMinOccurs());
        xbrlConcept2.setMaxOccurs(xbrlConcept.getMaxOccurs());
        xbrlConcept2.setDefaultValue(xbrlConcept.getDefaultValue());
        xbrlConcept2.setFixedValue(xbrlConcept.getFixedValue());
        xbrlConcept2.setFinal(xbrlConcept.getFinal());
        xbrlConcept2.setBlock(xbrlConcept.getBlock());
        XdmAttribute[] xdmAttributeArray = xbrlConcept.getUnhandledAttributes();
        if (xdmAttributeArray != null) {
            XdmAttribute[] xdmAttributeArray2 = xdmAttributeArray;
            int n = xdmAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                XdmAttribute xdmAttribute = xdmAttributeArray2[n2];
                xbrlConcept2.addUnhandledAttribute(xdmAttribute);
                ++n2;
            }
        }
        XbrlHelper.processConcept((XbrlConcept)xbrlConcept2);
        return xbrlConcept2;
    }

    private void u() {
        if (this.xbrlInstance == null) {
            return;
        }
        String string = this.xbrlInstance.getAttributeValue((QName)QNameConstants.schemaLocation);
        if (!StringUtils.contains((String)string, (String)"http://xbrl.org/2006/xbrldi")) {
            if (!StringUtils.isEmpty((String)string)) {
                string = String.valueOf(string) + " ";
            }
            this.xbrlInstance.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            string = String.valueOf(string) + "http://xbrl.org/2006/xbrldi" + " " + "http://www.xbrl.org/2006/xbrldi-2006.xsd";
            this.xbrlInstance.setAttribute((QName)QNameConstants.schemaLocation, string);
            this.xbrlInstance.getOwnerDocument().setModified(true);
            this._hasBugFixed = true;
        }
    }

    private void v() {
        if (this.xbrlInstance == null) {
            return;
        }
        this.u();
        this.f = this.xbrlInstance.getAllFacts(true);
        for (Map.Entry<QName, List<Fact>> entry : this.f.entrySet()) {
            XbrlConcept xbrlConcept = this.dts.getConcept(entry.getKey());
            if (xbrlConcept == null) continue;
            boolean bl = xbrlConcept.getPeriodType() == PeriodType.Duration;
            for (Fact fact : entry.getValue()) {
                boolean bl2;
                Context context = fact.getContext();
                if (context == null) continue;
                boolean bl3 = bl2 = context.getPeriodType() == PeriodType.Duration;
            }
        }
        this.E();
        this.bugFixRemoveDuplicateFacts();
    }

    private void w() {
        try {
            XmlSchema xmlSchema;
            XmlSchema xmlSchema2;
            XmlSchema xmlSchema3;
            HashMap<XmlSchema, XmlSchema> hashMap = new HashMap<XmlSchema, XmlSchema>();
            IXbrlDocument iXbrlDocument = this.dts.getSchemas();
            int n = ((XmlSchema[])iXbrlDocument).length;
            int n2 = 0;
            while (n2 < n) {
                XmlSchema[] xmlSchemaArray;
                XmlSchema xmlSchema4 = iXbrlDocument[n2];
                String string = xmlSchema4.getTargetNamespace();
                if (!StringUtils.isEmpty((String)string) && (xmlSchemaArray = this.dts.getSchemas(string)) != null && xmlSchemaArray.length > 1) {
                    xmlSchema3 = null;
                    Object object = xmlSchemaArray;
                    int n3 = xmlSchemaArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        xmlSchema2 = object[n4];
                        if (xmlSchema2.getSourceURI() != null && xmlSchema2.getSourceURI().startsWith("http:")) {
                            xmlSchema3 = xmlSchema2;
                            break;
                        }
                        ++n4;
                    }
                    if (xmlSchema3 != null) {
                        object = xmlSchemaArray;
                        n3 = xmlSchemaArray.length;
                        n4 = 0;
                        while (n4 < n3) {
                            xmlSchema2 = object[n4];
                            if (xmlSchema2 != xmlSchema3 && xmlSchema2.getSourceURI() != null && !xmlSchema2.getSourceURI().startsWith("http:") && xmlSchema2.getElements().size() == xmlSchema3.getElements().size()) {
                                hashMap.put(xmlSchema2, xmlSchema3);
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
            boolean bl = hashMap.size() > 0;
            HashMap<String, Loc[]> hashMap2 = new HashMap<String, Loc[]>();
            xmlSchema3 = xmlSchema = this.dts.getDocuments();
            int n5 = ((IXbrlDocument[])xmlSchema3).length;
            int n6 = 0;
            while (n6 < n5) {
                iXbrlDocument = xmlSchema3[n6];
                if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xmlSchema2 = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                    Linkbase linkbase = (Linkbase)xmlSchema2.getDocumentElement();
                    for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                        Object object;
                        boolean bl2 = extendedLink.getNodeName().equals(QNameConstants.definitionLink);
                        if (bl2) {
                            hashMap2.clear();
                        }
                        boolean bl3 = false;
                        XdmNode xdmNode = null;
                        XdmNode xdmNode22 = extendedLink.getFirstChild();
                        while (xdmNode22 != null) {
                            xdmNode = xdmNode22.getNextSibling();
                            if (xdmNode22.getNodeNature() == 2 && xdmNode22 instanceof Loc) {
                                XbrlConcept xbrlConcept;
                                String string;
                                String string2;
                                object = (Loc)xdmNode22;
                                Object object2 = object.getFinalTarget();
                                if (object2 == null || object2 == object) {
                                    string2 = object.getHref();
                                    this.reportBug("link:loc lost target, " + string2);
                                    int n7 = string2.lastIndexOf("#");
                                    if (n7 != -1) {
                                        string = string2.substring(n7 + 1);
                                        xbrlConcept = this.dts.getConceptById(string);
                                        if (xbrlConcept != null) {
                                            XmlSchemaElement xmlSchemaElement;
                                            if (bl && hashMap.containsKey(xbrlConcept.getSchema()) && (xmlSchemaElement = ((XmlSchema)hashMap.get(xbrlConcept.getSchema())).getElementByName(xbrlConcept.getQName())) instanceof XbrlConcept) {
                                                xbrlConcept = (XbrlConcept)xmlSchemaElement;
                                            }
                                            object.setTarget((Object)xbrlConcept);
                                            string2 = object.getHref();
                                            object.getOwnerDocument().setModified(true);
                                            this.fixBug("link:loc @xlink:href='" + string2 + "'");
                                            bl3 = true;
                                        } else {
                                            String string3 = string2.substring(0, n7);
                                            if (StringUtils.endsWithIgnoreCase((String)string3, (String)".xsd")) {
                                                extendedLink.removeChild(xdmNode22);
                                                extendedLink.getOwnerDocument().setModified(true);
                                                this.fixBug("link:loc @xlink:href='" + string2 + "' removed.");
                                                bl3 = true;
                                            }
                                        }
                                    }
                                } else if (bl && object2 instanceof XbrlConcept && hashMap.containsKey((string2 = (XbrlConcept)object2).getSchema())) {
                                    String string4 = object.getHref();
                                    this.reportBug("link:loc error target, " + string4);
                                    string = ((XmlSchema)hashMap.get(string2.getSchema())).getElementByName(string2.getQName());
                                    if (string instanceof XbrlConcept) {
                                        object.setTarget((Object)((XbrlConcept)string));
                                        string4 = object.getHref();
                                        object.getOwnerDocument().setModified(true);
                                        this.fixBug("link:loc @xlink:href='" + string4 + "'");
                                        bl3 = true;
                                    }
                                }
                                if (bl2) {
                                    string2 = object.getLabel();
                                    Loc[] locArray = (Loc[])hashMap2.get(string2);
                                    if (locArray == null) {
                                        hashMap2.put(string2, new Loc[]{object});
                                    } else {
                                        string = object.getHref();
                                        Loc[] locArray2 = locArray;
                                        int n8 = locArray.length;
                                        int n9 = 0;
                                        while (n9 < n8) {
                                            xbrlConcept = locArray2[n9];
                                            String string5 = xbrlConcept.getHref();
                                            if (string.equals(string5)) {
                                                object.getParent().removeChild((XdmNode)object);
                                                bl3 = true;
                                                this.fixBug("remove dup link:loc@definitionLink xlink:label=\"" + string2 + "\" xlink:role=\"" + extendedLink.getRole() + "\"", true);
                                            }
                                            ++n9;
                                        }
                                    }
                                }
                            }
                            xdmNode22 = xdmNode;
                        }
                        if (bl3) {
                            xdmNode22 = extendedLink.getNodeName();
                            object = this.dts.getRelationshipSet((QName)xdmNode22, extendedLink.getRole());
                            if (object == null) {
                                object = this.dts.createRelationshipSet(extendedLink);
                            }
                            if (!this.b.contains(object)) {
                                this.b.add(object);
                            }
                        }
                        if (this._targetAction != Cleaner.TargetAction.Clean || !bl) continue;
                        for (XdmNode xdmNode22 : hashMap.keySet()) {
                            this.dts.removeSchema((XmlSchema)xdmNode22);
                        }
                        if (this.xbrlInstance == null) continue;
                        this.xbrlInstance.clearCache();
                    }
                }
                ++n6;
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)("fix locator: " + exception.getMessage()));
        }
    }

    private boolean a(ExtendedLink extendedLink) {
        String string;
        Arc arc2;
        boolean bl = false;
        ExtendedLinkSummary extendedLinkSummary = new ExtendedLinkSummary(extendedLink, this.dts);
        ArrayList<Arc> arrayList = new ArrayList<Arc>();
        for (Arc arc2 : extendedLinkSummary.getArcs()) {
            if (extendedLinkSummary.hasArcEnd(arc2.getFrom()) && extendedLinkSummary.hasArcEnd(arc2.getTo())) continue;
            extendedLink.removeChild((XdmNode)arc2);
            extendedLink.getOwnerDocument().setModified(true);
            this.fixBug("remove arc miss end: " + arc2.toString() + " = " + arc2.getFrom() + " - " + arc2.getTo());
            this._hasBugFixed = true;
            bl = true;
            arrayList.add(arc2);
        }
        extendedLinkSummary.getArcs().removeAll(arrayList);
        arc2 = null;
        XdmNode xdmNode = extendedLink.getFirstChild();
        while (xdmNode != null) {
            arc2 = xdmNode.getNextSibling();
            if (xdmNode instanceof Loc) {
                string = ((Loc)xdmNode).getLabel();
                boolean bl2 = true;
                for (Arc arc3 : extendedLinkSummary.getArcs()) {
                    if (!string.equals(arc3.getFrom())) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    extendedLink.removeChild((XdmNode)((Loc)xdmNode));
                    this.fixBug("remove useless loc: " + string);
                    this._hasBugFixed = true;
                }
            }
            xdmNode = arc2;
        }
        extendedLinkSummary = null;
        if (bl) {
            xdmNode = extendedLink.getNodeName();
            string = this.dts.getRelationshipSet((QName)xdmNode, extendedLink.getRole());
            if (string == null) {
                string = this.dts.createRelationshipSet(extendedLink);
            }
            if (!this.b.contains(string)) {
                this.b.add(string);
            }
        }
        return bl;
    }

    private void x() {
        try {
            IXbrlDocument[] iXbrlDocumentArray;
            IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
            int n = iXbrlDocumentArray.length;
            int n2 = 0;
            while (n2 < n) {
                XbrlDocument xbrlDocument;
                IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
                if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                    Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                    for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                        Arc arc2;
                        if (!extendedLink.isSyntaxError()) continue;
                        boolean bl = false;
                        ExtendedLinkSummary extendedLinkSummary = new ExtendedLinkSummary(extendedLink, this.dts);
                        for (Arc arc2 : extendedLinkSummary.getArcs()) {
                            if (extendedLinkSummary.hasArcEnd(arc2.getFrom()) && extendedLinkSummary.hasArcEnd(arc2.getTo())) continue;
                            extendedLink.removeChild((XdmNode)arc2);
                            extendedLink.getOwnerDocument().setModified(true);
                            this.fixBug("remove arc miss end: " + arc2.toString() + " = " + arc2.getFrom() + " - " + arc2.getTo());
                            this._hasBugFixed = true;
                            bl = true;
                        }
                        extendedLinkSummary = null;
                        if (!bl) continue;
                        arc2 = extendedLink.getNodeName();
                        RelationshipSet relationshipSet = this.dts.getRelationshipSet((QName)arc2, extendedLink.getRole());
                        if (relationshipSet == null) {
                            relationshipSet = this.dts.createRelationshipSet(extendedLink);
                        }
                        if (this.b.contains(relationshipSet)) continue;
                        this.b.add(relationshipSet);
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)("fix arc: " + exception.getMessage()));
        }
    }

    private void y() {
        if (this.q == null) {
            return;
        }
        try {
            RelationshipSet relationshipSet;
            XbrlDocument xbrlDocument;
            Collection collection = this.dts.getLabelRelationships();
            Collection collection2 = this.q.getLabelRelationships();
            if (this.j == null) {
                this.j = this.dts.getPresentationRelationships();
            }
            RelationshipSet relationshipSet2 = new HashSet();
            for (RelationshipSet relationshipSet3 : this.j) {
                relationshipSet3.getAllTargets(relationshipSet2);
            }
            boolean bl = false;
            for (Iterator<Object> iterator : relationshipSet2) {
                bl = false;
                xbrlDocument = collection.iterator();
                block4: while (xbrlDocument.hasNext()) {
                    relationshipSet = (RelationshipSet)xbrlDocument.next();
                    for (Relationship relationship : relationshipSet.getEffectiveChildren(iterator)) {
                        Label label;
                        Iterator iterator2;
                        if (relationship.arc().getUse() != ArcUse.Optional || (iterator2 = relationship.toTarget()) == null || !(iterator2 instanceof Label) || !"http://www.xbrl.org/2003/role/label".equals((label = (Label)iterator2).getRole())) continue;
                        bl = true;
                        break block4;
                    }
                }
                if (bl || !(iterator instanceof XbrlConcept)) continue;
                this.a((XbrlConcept)iterator, collection2, collection);
            }
            relationshipSet = relationshipSet2 = this.dts.getDocuments();
            int n = ((IXbrlDocument[])relationshipSet).length;
            int n2 = 0;
            while (n2 < n) {
                RelationshipSet relationshipSet4 = relationshipSet[n2];
                if (!relationshipSet4.isReadOnly() && relationshipSet4.getContentType().contains(XbrlContentType.Linkbase) && relationshipSet4 instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)relationshipSet4).getDocumentElement() instanceof Linkbase) {
                    Relationship relationship;
                    relationship = (Linkbase)xbrlDocument.getDocumentElement();
                    for (ExtendedLink extendedLink : relationship.getExtendedLinks()) {
                        if (!extendedLink.isSyntaxError() || !extendedLink.getNodeName().equals(QNameConstants.presentationLink)) continue;
                        for (Label label : extendedLink.getRelationships()) {
                            RelationshipSet relationshipSet52;
                            XbrlConcept xbrlConcept;
                            PresentationArc presentationArc;
                            String string;
                            Arc arc = label.arc();
                            if (!(arc instanceof PresentationArc) || StringUtils.isEmpty((String)(string = (presentationArc = (PresentationArc)arc).getPreferredLabel())) || (xbrlConcept = label.toConcept()) == null) continue;
                            int n3 = 0;
                            block9: for (RelationshipSet relationshipSet52 : collection) {
                                for (Relationship relationship2 : relationshipSet52.getEffectiveChildren((Object)xbrlConcept)) {
                                    String string2;
                                    Label label2;
                                    Object object;
                                    if (relationship2.arc().getUse() == ArcUse.Optional && (object = relationship2.toTarget()) != null && object instanceof Label && string.equals((label2 = (Label)object).getRole()) && (n3 += ((string2 = label2.getLang()).startsWith("zh") ? 2 : 0) + (string2.startsWith("zh") ? 1 : 0)) == 3) break block9;
                                }
                            }
                            if (n3 == 3 || !this.a(xbrlConcept, collection2, collection) || (relationshipSet52 = this.dts.getRelationshipSet((QName)QNameConstants.labelLink, extendedLink.getRole())) == null) continue;
                            this.b.add(relationshipSet52);
                        }
                    }
                }
                ++n2;
            }
            this.rebuildRelationshipSet();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean a(XbrlConcept xbrlConcept, Collection<RelationshipSet> collection, Collection<RelationshipSet> collection2) {
        g g2 = this.K();
        if (g2.a()) {
            return false;
        }
        boolean bl = false;
        for (RelationshipSet relationshipSet : collection) {
            for (Relationship relationship : relationshipSet.getEffectiveChildren((Object)xbrlConcept)) {
                if (!relationship.isOptional() || !(relationship.toTarget() instanceof Label)) continue;
                Label label = (Label)relationship.toTarget();
                String string = label.getRole();
                boolean bl2 = false;
                block2: for (RelationshipSet relationshipSet2 : collection2) {
                    for (Relationship relationship2 : relationshipSet2.getEffectiveChildren((Object)xbrlConcept)) {
                        Label label2;
                        Object object;
                        if (relationship2.arc().getUse() != ArcUse.Optional || (object = relationship2.toTarget()) == null || !(object instanceof Label) || !string.equals((label2 = (Label)object).getRole()) || !label2.getLang().equals(label.getLang())) continue;
                        bl2 = true;
                        break block2;
                    }
                }
                if (bl2 || !this.a(xbrlConcept, label, g2)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private void z() {
        Object object;
        QName qName;
        XmlSchema[] xmlSchemaArray;
        this.r = null;
        this.f = this.byInstance ? this.xbrlInstance.getAllFacts(true) : new HashMap();
        this.h = new HashSet();
        if (this.byInstance) {
            for (Context context : this.xbrlInstance.getContexts()) {
                this.h.addAll(context.getDimensionContents().keySet());
                xmlSchemaArray = context.getDimensionContents().values().iterator();
                while (xmlSchemaArray.hasNext()) {
                    QName qName2 = qName = (QName)xmlSchemaArray.next();
                    int n = ((MemberElement[])qName2).length;
                    int n2 = 0;
                    while (n2 < n) {
                        QName qName3;
                        object = qName2[n2];
                        if (object instanceof ExplicitMember && (qName3 = ((ExplicitMember)object).getDimensionContent()) != null && !qName3.isEmpty()) {
                            this.h.add(qName3);
                        }
                        ++n2;
                    }
                }
            }
        }
        this.c = new HashSet();
        this.c.addAll(this.f.keySet());
        this.c.addAll(this.h);
        this.d = new HashMap<QName, List<QName>>();
        this.e = new HashMap<QName, List<QName>>();
        for (QName qName4 : this.dts.hasDefaultDimensions()) {
            QName[] qNameArray = this.dts.getDimensionDefault(qName4);
            int n = qNameArray.length;
            int n3 = 0;
            while (n3 < n) {
                qName = qNameArray[n3];
                List<QName> list = this.e.get(qName);
                if (list == null) {
                    list = new ArrayList<QName>(1);
                    this.e.put(qName, list);
                }
                list.add(qName4);
                if (!this.h.contains(qName4)) {
                    list = this.d.get(qName);
                    if (list == null) {
                        list = new ArrayList<QName>(1);
                        this.d.put(qName, list);
                    }
                    list.add(qName4);
                }
                ++n3;
            }
        }
        this.i = null;
        this.j = this.dts.getPresentationRelationships();
        this.l = this.dts.getDefinitionRelationships();
        this.k = this.dts.getCalculationRelationships();
        this.g = new HashSet<Object>();
        for (RelationshipSet relationshipSet : this.j) {
            relationshipSet.getAllTargets(this.g);
        }
        this.v = this.cas_NamespaceURI;
        xmlSchemaArray = this.dts.getSchemas();
        int n = xmlSchemaArray.length;
        int n4 = 0;
        while (n4 < n) {
            XmlSchema xmlSchema = xmlSchemaArray[n4];
            object = xmlSchema.getTargetNamespace();
            if (!StringUtils.isEmpty((String)object) && !((String)object).startsWith("http://www.xbrl.org/") && !((String)object).startsWith("http://xbrl.org/") && ((String)object).startsWith(this.cas_NamespaceURI_Part)) {
                if (((String)object).equals(this.cas_NamespaceURI)) {
                    this.v = this.cas_NamespaceURI;
                } else {
                    String string = xmlSchema.getPrefixOfNamespace((String)object);
                    if ("cas".equals(string)) {
                        this.v = object;
                    }
                }
            }
            ++n4;
        }
        this.n = this.dts.getConcept("SeparateMember", StringUtils.isEmpty((String)this.v) ? this.cas_NamespaceURI : this.v);
        if (this.n != null) {
            this.h.add(this.n.getQName());
        }
        this.o = this.dts.getConcept("ConsolidatedAndIndividualFinancialStatementAxis", StringUtils.isEmpty((String)this.v) ? this.cas_NamespaceURI : this.v);
    }

    protected void initializeCas() {
        this.cas_NamespaceURI = "http://xbrl.mof.gov.cn/taxonomy/2010-09-30/cas";
        this.cas_SchemaLocation = "http://xbrl.mof.gov.cn/taxonomy/2010-09-30/cas_core_2010-09-30.xsd";
        this.cas_EntrySchemaLocation = "http://xbrl.mof.gov.cn/taxonomy/2010-09-30/cas_entry_point_2010-09-30.xsd";
        this.cas_NamespaceURI_Part = "http://xbrl.mof.gov.cn/taxonomy/";
    }

    private void a(boolean bl, boolean bl2) {
        XbrlSchema xbrlSchema;
        Map map;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashSet<QName> hashSet = new HashSet<QName>();
        HashSet<QName> hashSet2 = new HashSet<QName>();
        XmlSchema[] xmlSchemaArray = this.dts.getSchemas(this.extendNamespaceURI);
        if (xmlSchemaArray != null && xmlSchemaArray.length > 0 && xmlSchemaArray[0] instanceof XbrlSchema && (map = (xbrlSchema = (XbrlSchema)xmlSchemaArray[0]).getElements()) != null && !map.isEmpty()) {
            Object object;
            Object object2;
            for (Map.Entry entry : map.entrySet()) {
                object2 = (QName)entry.getKey();
                XbrlConcept xbrlConcept = object = entry.getValue() instanceof XbrlConcept ? (XbrlConcept)entry.getValue() : null;
                if (object == null) continue;
                this.d((XbrlConcept)object);
                if (this.byInstance) {
                    if (this.c.contains(object2)) continue;
                    boolean bl3 = this.a(this.xbrlInstance, (XbrlConcept)object, (Iterable<RelationshipSet>)this.j, (Set<QName>)hashSet, (Set<QName>)this.c);
                    boolean bl4 = this.a(this.xbrlInstance, (XbrlConcept)object, (Iterable<RelationshipSet>)this.l, (Set<QName>)hashSet2, (Set<QName>)this.c);
                    if (bl3 || bl4) continue;
                    if (this.d.containsKey(object2)) {
                        if (this.i == null) {
                            this.i = new HashMap<QName, XbrlConcept>();
                        }
                        this.i.put((QName)object2, (XbrlConcept)object);
                        continue;
                    }
                    if (object.isDimension()) {
                        if (this.a((XbrlConcept)object)) continue;
                        arrayList.add(object2);
                        continue;
                    }
                    arrayList.add(object2);
                    continue;
                }
                if (this.a((XbrlConcept)object, this.j) || this.a((XbrlConcept)object, this.l)) continue;
                arrayList.add(object2);
            }
            if (bl) {
                if (this.byInstance) {
                    ArrayList<XbrlConcept> arrayList2 = new ArrayList<XbrlConcept>();
                    for (QName qName : arrayList) {
                        if (hashSet.contains(qName) || hashSet2.contains(qName) || (object = this.dts.getConcept(qName)) == null) continue;
                        arrayList2.add((XbrlConcept)object);
                    }
                    if (this.w == null) {
                        this.w = new ArrayList<XbrlConcept>();
                    }
                    xbrlSchema.removeConcepts(this.dts, arrayList2, true, this.w);
                    if (this.i != null) {
                        this.a(this.dts, xbrlSchema, this.i, this.d, this.f.keySet());
                    }
                } else {
                    for (QName qName : arrayList) {
                        object2 = this.dts.getConcept(qName);
                        object = this.b((XbrlConcept)object2);
                        if (xbrlSchema.removeConcept(this.dts, (XbrlConcept)object2, true)) {
                            this.fixBug("remove concept: " + object2 + " label: " + (String)object);
                            continue;
                        }
                        if (this.w == null) {
                            this.w = new ArrayList<XbrlConcept>();
                        }
                        this.w.add((XbrlConcept)object2);
                    }
                }
            }
        }
        this.D();
        if (bl && this.xbrlInstance != null) {
            this.ai();
            this.S();
            this.C();
            this.A();
            this.aw();
        }
        if (bl2) {
            this.B();
        }
        if (bl && this.xbrlInstance != null) {
            this.I();
            this.Z();
            this.au();
            this.as();
            this.ah();
            this.an();
            this.ag();
            this.af();
            this.ac();
            this.ab();
            this.o();
            this.removeUnusedMenu();
            this.au();
            this.as();
        }
    }

    private void A() {
    }

    private void B() {
        try {
            this.j = this.dts.getPresentationRelationships();
            boolean bl = false;
            net.gbicc.xbrl.cleaner.b b2 = new net.gbicc.xbrl.cleaner.b(this.dts, this);
            for (RelationshipSet relationshipSet : this.j) {
                boolean bl2 = bl = b2.a(relationshipSet) || bl;
            }
            if (bl) {
                this.j = this.dts.getPresentationRelationships();
                this.l = this.dts.getDefinitionRelationships();
                this.rebuildRelationshipSet();
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)exception);
        }
    }

    private void C() {
        Object object2;
        if (this.xbrlInstance == null) {
            return;
        }
        if (this.f == null || this.f.size() == 0) {
            this.f = this.xbrlInstance.getFacts(true);
        }
        for (Object object2 : this.dts.getPresentationRelationships()) {
            this.e((RelationshipSet)object2);
        }
        object2 = null;
        Collection collection = this.dts.getDefinitionRelationships();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RelationshipSet relationshipSet = (RelationshipSet)iterator.next();
            if (!this.e(relationshipSet)) continue;
            if (object2 == null) {
                object2 = new HashSet();
                this.a(collection, (Set<String>)object2);
            }
            if (object2.contains(relationshipSet.getRoleURI())) continue;
            this.d(relationshipSet);
        }
        this.rebuildRelationshipSet();
    }

    private void a(Collection<RelationshipSet> collection, Set<String> set) {
        for (RelationshipSet relationshipSet : collection) {
            for (Relationship relationship : relationshipSet.getRelationships()) {
                DefinitionArc definitionArc;
                String string;
                if (!(relationship.arc() instanceof DefinitionArc) || StringUtils.isEmpty((String)(string = (definitionArc = (DefinitionArc)relationship.arc()).getTargetRole()))) continue;
                set.add(string);
                set.add(relationshipSet.getRoleURI());
            }
        }
    }

    private void d(RelationshipSet relationshipSet) {
        boolean bl = false;
        for (Object object : relationshipSet.getRelationships()) {
            XbrlConcept xbrlConcept = object.fromConcept();
            if (!XbrlHelper.isStandardArcrole((String)object.arcrole()) && (xbrlConcept == null || !xbrlConcept.isHypercube())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (Object object : new ArrayList(relationshipSet.getFromTargets())) {
                relationshipSet.purgeOrProhibitTarget(object);
            }
        }
    }

    private boolean e(RelationshipSet relationshipSet) {
        List list;
        Object object5;
        int n = 0;
        ArrayList<Object> arrayList = null;
        ArrayList<Object> arrayList2 = null;
        for (Collection collection : new ArrayList(relationshipSet.getToTargets())) {
            if (!(collection instanceof XbrlConcept) || !(object5 = (XbrlConcept)collection).isHypercube()) continue;
            Object object2 = relationshipSet.getParents(object5);
            if (object2.size() != 1) {
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Object>();
                }
                arrayList2.add(object5);
                continue;
            }
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Relationship relationship = (Relationship)iterator.next();
                list = relationshipSet.getEffectiveChildren(relationship.fromTarget());
                boolean bl = false;
                boolean bl2 = true;
                block2: for (Relationship relationship2 : list) {
                    Object object3;
                    Object object42;
                    XbrlConcept xbrlConcept;
                    if (relationship2.toTarget() == object5 || (xbrlConcept = relationship2.toConcept()) == null) continue;
                    if (xbrlConcept.getName().endsWith("LineItems") || xbrlConcept.getName().endsWith("LineItem")) {
                        bl = true;
                        break;
                    }
                    if (relationshipSet.getEffectiveChildren((Object)xbrlConcept).size() > 0) {
                        bl = true;
                        break;
                    }
                    if (xbrlConcept.isAbstract()) continue;
                    HashSet<QName> hashSet = new HashSet<QName>();
                    for (Object object42 : relationshipSet.getEffectiveChildren(object5)) {
                        object3 = object42.toConcept();
                        if (object3 == null || !object3.isDimension()) continue;
                        hashSet.add(object3.getQName());
                    }
                    object42 = this.f.get(xbrlConcept.getQName());
                    if (object42 == null || object42.size() <= 0) continue;
                    object3 = object42.iterator();
                    while (object3.hasNext()) {
                        Fact fact = (Fact)object3.next();
                        Context context = fact.getContext();
                        if (context == null || context.getDimensionContents().size() <= 0) continue;
                        boolean bl3 = false;
                        for (QName qName : hashSet) {
                            if (!context.getDimensionContents().containsKey(qName)) continue;
                            bl3 = true;
                            break;
                        }
                        if (!bl3) continue;
                        bl2 = false;
                        continue block2;
                    }
                }
                if (!bl && bl2) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                    }
                    arrayList.add(object5);
                    continue;
                }
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList();
                }
                arrayList2.add(object5);
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            Collection collection;
            collection = null;
            HashSet hashSet = new HashSet();
            if (arrayList2 != null) {
                for (Object object5 : arrayList2) {
                    this.b(relationshipSet, object5, hashSet);
                }
            }
            object5 = new HashSet();
            for (Object object2 : arrayList) {
                ((HashSet)object5).clear();
                boolean bl = this.a(relationshipSet, object2, (HashSet<Object>)object5);
                if (!bl) continue;
                if (hashSet.size() > 0) {
                    Iterator iterator = ((HashSet)object5).iterator();
                    while (iterator.hasNext()) {
                        list = iterator.next();
                        if (!hashSet.contains(list)) continue;
                        bl = false;
                        break;
                    }
                }
                if (!bl) continue;
                Iterator iterator = ((HashSet)object5).iterator();
                while (iterator.hasNext()) {
                    list = iterator.next();
                    if (collection == null) {
                        collection = new HashSet();
                    }
                    collection.add((List)list);
                }
            }
            if (collection != null) {
                relationshipSet.purgeOrProhibitTargets(collection);
                ++n;
                this._hasBugFixed = true;
                this.b.add(relationshipSet);
            }
        }
        return n > 0;
    }

    private boolean a(RelationshipSet relationshipSet, Object object, HashSet<Object> hashSet) {
        if (hashSet.contains(object)) {
            return true;
        }
        hashSet.add(object);
        for (Relationship relationship : relationshipSet.getEffectiveChildren(object)) {
            if (relationship.isReadOnly()) {
                return false;
            }
            if (this.a(relationshipSet, relationship.toTarget(), hashSet)) continue;
            return false;
        }
        return true;
    }

    private void b(RelationshipSet relationshipSet, Object object, HashSet<Object> hashSet) {
        if (hashSet.contains(object)) {
            return;
        }
        hashSet.add(object);
        for (Relationship relationship : relationshipSet.getEffectiveChildren(object)) {
            this.b(relationshipSet, relationship.toTarget(), hashSet);
        }
    }

    private void D() {
        if (this.w == null || this.w.size() == 0) {
            return;
        }
        try {
            Collection collection = this.dts.getLabelRelationships();
            int n = this.w.size() - 1;
            while (n > -1) {
                XbrlConcept xbrlConcept = this.w.get(n);
                for (RelationshipSet relationshipSet : collection) {
                    if (!relationshipSet.contains((Object)xbrlConcept)) continue;
                    for (ExtendedLink extendedLink : relationshipSet.getExtendedLinks()) {
                        if (!(extendedLink instanceof LabelLink)) continue;
                        ((LabelLink)extendedLink).removeConceptLabel(xbrlConcept);
                    }
                }
                if (xbrlConcept.getSchema().removeConcept(this.dts, xbrlConcept, true)) {
                    this.w.remove(n);
                }
                --n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void a(String string, Set<String> set) {
        Object object;
        XmlSchema[] xmlSchemaArray = this.dts.getSchemas(string);
        String string2 = null;
        if (xmlSchemaArray != null && xmlSchemaArray.length > 0) {
            object = xmlSchemaArray[0];
            string2 = object.getPrefixOfNamespace(object.getTargetNamespace());
        }
        if (StringUtils.isEmpty(string2)) {
            if (gbicc_URI.equals(string)) {
                object = this.xbrlInstance.getNamespaceOfPrefix("gbicc");
                if (StringUtils.isEmpty((String)object)) {
                    string2 = "gbicc";
                } else {
                    object = this.xbrlInstance.getNamespaceOfPrefix("gbc989");
                    if (StringUtils.isEmpty((String)object)) {
                        string2 = "gbc989";
                    }
                }
            } else if ("http://www.xbrl.org/2003/iso4217".equals(string)) {
                string2 = "iso4217";
            }
        }
        if (StringUtils.isEmpty(string2)) {
            object = "ns";
            int n = 1;
            while (!StringUtils.isEmpty((String)this.xbrlInstance.getNamespaceOfPrefix((String)object))) {
                object = "ns" + ++n;
            }
            if (StringUtils.isEmpty((String)this.xbrlInstance.getNamespaceOfPrefix((String)object))) {
                string2 = object;
            }
        }
        if (!StringUtils.isEmpty(string2)) {
            this.xbrlInstance.setAttribute("xmlns:" + string2, string);
            set.add(string);
        }
    }

    private void E() {
        try {
            String string;
            if (this.xbrlInstance == null) {
                return;
            }
            HashSet<String> hashSet = new HashSet<String>();
            XdmNode xdmNode = this.xbrlInstance.getFirstNS();
            while (xdmNode != null) {
                string = xdmNode.getInnerText().trim();
                hashSet.add(string);
                xdmNode = xdmNode.getNextSibling();
            }
            xdmNode = this.xbrlInstance.getFirstChild();
            while (xdmNode != null) {
                if (xdmNode.isElement()) {
                    string = (XdmElement)xdmNode;
                    if (!hashSet.contains(string.getNamespaceURI())) {
                        this.a(string.getNamespaceURI(), hashSet);
                    }
                    Node[] nodeArray = string.getAttributes();
                    int n = nodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        XdmAttribute xdmAttribute;
                        String string2;
                        Node node = nodeArray[n2];
                        if (node.getNodeNature() == 3 && node instanceof XdmAttribute && !StringUtils.isEmpty((String)(string2 = (xdmAttribute = (XdmAttribute)node).getNamespaceURI())) && !hashSet.contains(string.getNamespaceURI())) {
                            this.a(string.getNamespaceURI(), hashSet);
                        }
                        ++n2;
                    }
                }
                xdmNode = xdmNode.getNextSibling();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void F() {
        try {
            void var2_4;
            if (this.xbrlInstance == null) {
                return;
            }
            HashSet<String> hashSet = new HashSet<String>();
            XdmNode object22 = this.xbrlInstance.getFirstNS();
            while (var2_4 != null) {
                Iterator iterator = var2_4.getInnerText().trim();
                hashSet.add((String)((Object)iterator));
                XdmNode xdmNode = var2_4.getNextSibling();
            }
            this.a((XdmElement)this.xbrlInstance, hashSet);
            if (!hashSet.isEmpty()) {
                for (Context context : this.xbrlInstance.getContexts()) {
                    for (Map.Entry entry : context.getDimensionContents().entrySet()) {
                        hashSet.remove(((QName)entry.getKey()).getNamespaceURI());
                        MemberElement[] memberElementArray = (MemberElement[])entry.getValue();
                        int n = memberElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MemberElement memberElement = memberElementArray[n2];
                            if (memberElement instanceof ExplicitMember) {
                                try {
                                    hashSet.remove(((ExplicitMember)memberElement).getDimensionContent().getNamespaceURI());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            ++n2;
                        }
                    }
                    if (hashSet.isEmpty()) break;
                }
            }
            if (!hashSet.isEmpty()) {
                for (Unit unit : this.xbrlInstance.getUnits()) {
                    try {
                        QName[] qNameArray = unit.getNumeratorMeasures();
                        int n = qNameArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            QName qName = qNameArray[n3];
                            hashSet.remove(qName.getNamespaceURI());
                            ++n3;
                        }
                        qNameArray = unit.getDenominatorMeasures();
                        n = qNameArray.length;
                        n3 = 0;
                        while (n3 < n) {
                            QName qName = qNameArray[n3];
                            hashSet.remove(qName.getNamespaceURI());
                            ++n3;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (hashSet.isEmpty()) break;
                }
            }
            for (String string : hashSet) {
                String string2 = this.xbrlInstance.getNamespacePrefix(string);
                if (StringUtils.isEmpty((String)string2)) continue;
                this.xbrlInstance.removeAttributeNode(string2, "http://www.w3.org/2000/xmlns/");
                this._hasBugFixed = true;
                this.xbrlInstance.getOwnerDocument().setModified(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void a(XdmElement xdmElement, Set<String> set) {
        IXdmSchemaInfo iXdmSchemaInfo;
        if (set.isEmpty()) {
            return;
        }
        set.remove(xdmElement.getNamespaceURI());
        try {
            Node[] nodeArray = xdmElement.getAttributes();
            int n = nodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                iXdmSchemaInfo = nodeArray[n2];
                if (iXdmSchemaInfo instanceof XdmAttribute) {
                    set.remove(((XdmAttribute)iXdmSchemaInfo).getNamespaceURI());
                }
                ++n2;
            }
            if (set.isEmpty()) {
                return;
            }
        }
        catch (DataModelException dataModelException) {
            dataModelException.printStackTrace();
        }
        iXdmSchemaInfo = xdmElement.getSchemaInfo();
        if (iXdmSchemaInfo != null && iXdmSchemaInfo.getDataType() != null && iXdmSchemaInfo.getDataType().getTypeCode() == XmlTypeCode.QName) {
            try {
                QName qName = xdmElement.getQName();
                set.remove(qName.getNamespaceURI());
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
        XdmNode xdmNode = xdmElement.getFirstChild();
        while (xdmNode != null) {
            if (xdmNode.getNodeNature() == 2) {
                this.a((XdmElement)xdmNode, set);
            }
            if (set.isEmpty()) {
                return;
            }
            xdmNode = xdmNode.getNextSibling();
        }
    }

    private void G() {
        boolean bl = true;
        this.l = this.dts.getDefinitionRelationships();
        for (RelationshipSet relationshipSet : this.l) {
            RoleType roleType = this.dts.getRoleTypes().getSingle(relationshipSet.getRoleURI());
            if (roleType == null || XmlChar.isNCName((String)roleType.getId())) continue;
            bl = false;
            break;
        }
        if (!bl) {
            this.H();
        }
    }

    private void H() {
        this.rebuildRelationshipSet();
        this.l = this.dts.getDefinitionRelationships();
        for (RelationshipSet object22 : this.l) {
            if (object22.getRelationships().size() != 0) continue;
            this.dts.removeRelationshipSets(object22.getRoleURI(), object22.getExtendedName());
        }
        this.l = this.dts.getDefinitionRelationships();
        HashSet<Linkbase> hashSet = new HashSet<Linkbase>();
        for (Object object3 : this.dts.getPresentationRelationships()) {
            List<RelationshipSet> list;
            String string;
            int n;
            int n2;
            int n3;
            String string2 = object3.getRoleURI();
            RoleType roleType = this.dts.getRoleTypes().getSingle(string2);
            if (roleType == null || (n3 = Math.max(n2 = string2.lastIndexOf(47), n = string2.lastIndexOf("-"))) == -1 || (string = string2.substring(n3 + 1)).length() != 6 || (list = this.c(string2)) == null || list.size() == 0) continue;
            Collections.sort(list, x);
            int n4 = list.size();
            ArrayList<Object> arrayList = null;
            int string22 = 0;
            while (string22 < n4) {
                String n7 = string22 == 0 ? string2 : String.valueOf(string2) + (char)(96 + string22);
                boolean string3 = false;
                int relationshipSet = list.size() - 1;
                while (relationshipSet > -1) {
                    if (list.get(relationshipSet).getRoleURI().equals(n7)) {
                        string3 = true;
                        list.remove(relationshipSet);
                        break;
                    }
                    --relationshipSet;
                }
                if (!string3) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                    }
                    arrayList.add(n7);
                }
                ++string22;
            }
            if (arrayList == null || list.size() <= 0 || list.size() != arrayList.size()) continue;
            String string3 = roleType.getDefinitionText();
            n3 = string3.indexOf("]");
            if (n3 != -1) {
                string3 = string3.substring(n3 + 1).trim();
            }
            int n5 = 0;
            while (n5 < arrayList.size()) {
                block19: {
                    Object object;
                    RoleType roleType2;
                    Collection<Linkbase> collection;
                    Collection collection2;
                    RelationshipSet relationshipSet;
                    String string4;
                    block20: {
                        string4 = (String)arrayList.get(n5);
                        relationshipSet = list.get(n5);
                        if (relationshipSet.isReadOnly()) break block19;
                        collection2 = relationshipSet.getExtendedLinks();
                        collection = this.getLinkbases(collection2);
                        roleType2 = this.dts.getRoleTypes().getSingle(string4);
                        if (roleType2 != null) break block20;
                        n3 = Math.max(string4.lastIndexOf(47), string4.lastIndexOf(45));
                        Object object2 = string4.substring(n3 + 1);
                        String string5 = roleType.getId();
                        object = string5.replace(string, (CharSequence)object2);
                        if (((String)object).equals(string5)) break block19;
                        roleType2 = this.createRoleType(string4, (String)object, string3);
                    }
                    if (roleType2 != null) {
                        for (Object object2 : collection) {
                            hashSet.add((Linkbase)object2);
                            object = object2.getRoleRef(string4);
                            if (object != null) continue;
                            object = object2.createRoleRef(string4, null);
                            object2.prependChild((XdmNode)object);
                            object.setRoleType(roleType2);
                        }
                        for (Object object2 : collection2) {
                            object2.setRole(string4);
                        }
                        this.dts.removeRelationshipSets(relationshipSet);
                        for (Object object2 : collection2) {
                            object = new ExtendedLinkSummary((ExtendedLink)object2, this.dts);
                            RelationshipSet relationshipSet2 = object.getRelationshipSet();
                            if (relationshipSet2 == null) continue;
                            this.b.add(relationshipSet2);
                            break;
                        }
                        this.b(relationshipSet.getRoleURI(), string4);
                    }
                }
                ++n5;
            }
        }
        if (hashSet != null && hashSet.size() > 0) {
            Object object3;
            object3 = new HashSet();
            for (Linkbase linkbase : hashSet) {
                this.removeUnusedRoleRef(linkbase, (Set<String>)object3);
            }
        }
        if (this.b.size() > 0) {
            this.rebuildRelationshipSet();
        }
    }

    private void b(String string, String string2) {
        RoleRef roleRef;
        RelationshipSet relationshipSet = this.dts.getRelationshipSet((QName)QNameConstants.calculationLink, string);
        if (relationshipSet == null) {
            return;
        }
        HashSet<Linkbase> hashSet = new HashSet<Linkbase>();
        Collection collection = relationshipSet.getExtendedLinks();
        Collection<Linkbase> collection2 = this.getLinkbases(collection);
        RoleType roleType = this.dts.getRoleTypes().getSingle(string2);
        if (roleType == null) {
            return;
        }
        for (Linkbase linkbase : collection2) {
            hashSet.add(linkbase);
            roleRef = linkbase.getRoleRef(string2);
            if (roleRef != null) continue;
            roleRef = linkbase.createRoleRef(string2, null);
            linkbase.prependChild((XdmNode)roleRef);
            roleRef.setRoleType(roleType);
        }
        for (Linkbase linkbase : collection) {
            linkbase.setRole(string2);
        }
        this.dts.removeRelationshipSets(relationshipSet);
        for (Linkbase linkbase : collection) {
            roleRef = new ExtendedLinkSummary((ExtendedLink)linkbase, this.dts);
            RelationshipSet relationshipSet2 = roleRef.getRelationshipSet();
            if (relationshipSet2 == null) continue;
            this.b.add(relationshipSet2);
            break;
        }
    }

    private void I() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.dts.getPresentationRelationships());
        arrayList.addAll(this.dts.getDefinitionRelationships());
        HashSet<Relationship> hashSet = new HashSet<Relationship>();
        ArrayList<XbrlConcept> arrayList2 = new ArrayList<XbrlConcept>();
        for (RelationshipSet relationshipSet : arrayList) {
            Object object;
            hashSet.clear();
            arrayList2.clear();
            List list = relationshipSet.getRootNodes();
            int n = list.size() - 1;
            while (n > -1) {
                Object object2;
                object = list.get(n);
                if (object instanceof XbrlConcept && (object2 = (XbrlConcept)object).isDimension()) {
                    arrayList2.add((XbrlConcept)object2);
                    list.remove(n);
                }
                --n;
            }
            if (arrayList2.size() <= 0) continue;
            HashSet<Object> hashSet2 = new HashSet<Object>();
            object = new HashSet();
            for (Object object2 : list) {
                hashSet2.add(object2);
                this.a(relationshipSet, object2, hashSet2, hashSet);
            }
            for (Object object2 : arrayList2) {
                Object object32;
                object.clear();
                object.add(object2);
                this.a(relationshipSet, object2, (Set<Object>)object, hashSet);
                boolean bl = true;
                for (Object object32 : object) {
                    if (!hashSet2.contains(object32)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    relationshipSet.purgeOrProhibitTargets((Collection)object);
                    this.b.add(relationshipSet);
                    continue;
                }
                if (this.c.contains(object2.getQName())) continue;
                object32 = new HashSet();
                for (Relationship relationship : new ArrayList(relationshipSet.getEffectiveChildren(object2))) {
                    if (hashSet2.contains(relationship.toTarget())) continue;
                    object32.add(relationship.toTarget());
                }
                object32.add((XbrlConcept)object2);
                relationshipSet.purgeOrProhibitTargets((Collection)object32);
                this.b.add(relationshipSet);
            }
        }
        this.rebuildRelationshipSet();
        this.J();
    }

    private void J() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.dts.getPresentationRelationships());
        arrayList.addAll(this.dts.getDefinitionRelationships());
        HashSet<Relationship> hashSet = new HashSet<Relationship>();
        ArrayList<XbrlConcept> arrayList2 = new ArrayList<XbrlConcept>();
        for (RelationshipSet relationshipSet : arrayList) {
            Object object;
            hashSet.clear();
            arrayList2.clear();
            List list = relationshipSet.getRootNodes();
            int n = list.size() - 1;
            while (n > -1) {
                Object object2;
                object = list.get(n);
                if (object instanceof XbrlConcept && relationshipSet.containValidTarget(object) && (object2 = (XbrlConcept)object).isAbstract() && QNameConstants.nonnumDomainItemType.equals((Object)object2.getSchemaTypeName())) {
                    arrayList2.add((XbrlConcept)object2);
                    list.remove(n);
                }
                --n;
            }
            if (arrayList2.size() <= 0) continue;
            HashSet<Object> hashSet2 = new HashSet<Object>();
            object = new HashSet();
            for (Object object2 : list) {
                hashSet2.add(object2);
                this.a(relationshipSet, object2, hashSet2, hashSet);
            }
            for (Object object2 : arrayList2) {
                Object object32;
                object.clear();
                object.add(object2);
                this.a(relationshipSet, object2, (Set<Object>)object, hashSet);
                boolean bl = true;
                for (Object object32 : object) {
                    if (!hashSet2.contains(object32)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    relationshipSet.purgeOrProhibitTargets((Collection)object);
                    this.b.add(relationshipSet);
                    continue;
                }
                if (this.c.contains(object2.getQName())) continue;
                object32 = new HashSet();
                for (Relationship relationship : new ArrayList(relationshipSet.getEffectiveChildren(object2))) {
                    if (hashSet2.contains(relationship.toTarget())) continue;
                    object32.add(relationship.toTarget());
                }
                object32.add((XbrlConcept)object2);
                relationshipSet.purgeOrProhibitTargets((Collection)object32);
                this.b.add(relationshipSet);
            }
        }
        this.rebuildRelationshipSet();
    }

    private void a(RelationshipSet relationshipSet, Object object, Set<Object> set, Set<Relationship> set2) {
        for (Relationship relationship : relationshipSet.getEffectiveChildren(object)) {
            if (set2.contains(relationship)) continue;
            set2.add(relationship);
            set.add(relationship.toTarget());
            this.a(relationshipSet, relationship.toTarget(), set, set2);
        }
    }

    private g K() {
        if (this.y == null) {
            IXbrlDocument[] iXbrlDocumentArray;
            this.y = new g();
            IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
            int n = iXbrlDocumentArray.length;
            int n2 = 0;
            while (n2 < n) {
                XbrlDocument xbrlDocument;
                String string;
                IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
                if (iXbrlDocument != null && !iXbrlDocument.isReadOnly() && iXbrlDocument instanceof XbrlDocument && (string = iXbrlDocument.getBaseURI()) != null && (string.endsWith("cn.xml") || string.endsWith("en.xml")) && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() != null && xbrlDocument.getDocumentElement() instanceof Linkbase) {
                    for (ExtendedLink extendedLink : ((Linkbase)xbrlDocument.getDocumentElement()).getExtendedLinks()) {
                        if (!extendedLink.getNodeName().equals(QNameConstants.labelLink)) continue;
                        if (string.endsWith("cn.xml")) {
                            this.y.a = xbrlDocument;
                            break;
                        }
                        if (!string.endsWith("en.xml")) break;
                        this.y.b = xbrlDocument;
                        break;
                    }
                }
                ++n2;
            }
        }
        return this.y;
    }

    private void L() {
        try {
            g g2 = this.K();
            if (g2.a()) {
                return;
            }
            Map<ExtendedLink, ExtendedLinkSummary> map = null;
            Collection collection = this.dts.getLabelRelationships();
            ArrayList arrayList = new ArrayList();
            for (RelationshipSet relationshipSet : collection) {
                for (Object e2 : relationshipSet.getFromTargets()) {
                    if (!(e2 instanceof XbrlConcept)) continue;
                    arrayList.clear();
                    arrayList.addAll(relationshipSet.getEffectiveChildren(e2));
                    for (Relationship relationship : arrayList) {
                        Label label;
                        String string;
                        if (!(relationship.toTarget() instanceof Label) || StringUtils.isEmpty((String)(string = (label = (Label)relationship.toTarget()).getLang()))) continue;
                        if (string.startsWith("zh")) {
                            if (label.getOwnerDocument() == g2.a) continue;
                            if (map == null) {
                                map = g2.b();
                            }
                            this.a(relationshipSet, relationship, label, g2.a, map);
                            continue;
                        }
                        if (!string.startsWith("en") || label.getOwnerDocument() == g2.b) continue;
                        if (map == null || map.size() == 0) {
                            map = g2.b();
                        }
                        this.a(relationshipSet, relationship, label, g2.b, map);
                    }
                }
            }
            this.a(g2);
            this.rebuildRelationshipSet();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogWatch.error((Object)exception);
        }
    }

    private void a(g g2) {
        if (this.q == null) {
            return;
        }
        try {
            Collection collection2;
            HashSet hashSet = new HashSet();
            for (Collection collection2 : this.dts.getPresentationRelationships()) {
                collection2.getAllTargets(hashSet);
            }
            collection2 = this.dts.getLabelRelationships();
            for (Iterator iterator : hashSet) {
                List list;
                RelationshipSet relationshipSet;
                boolean bl = false;
                XbrlConcept xbrlConcept = collection2.iterator();
                while (xbrlConcept.hasNext()) {
                    relationshipSet = (RelationshipSet)xbrlConcept.next();
                    if (!relationshipSet.contains(iterator)) continue;
                    bl = true;
                    break;
                }
                if (bl || !(iterator instanceof XbrlConcept) || (xbrlConcept = this.q.getConcept((relationshipSet = (XbrlConcept)iterator).getQName())) == null || (list = xbrlConcept.getLabels(this.q)).isEmpty()) continue;
                for (Label label : list) {
                    this.a((XbrlConcept)relationshipSet, label, g2);
                }
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)exception);
        }
    }

    private boolean a(XbrlConcept xbrlConcept, Label label, g g2) {
        ArcEnd arcEnd;
        Object object;
        int n;
        Relationship relationship;
        XbrlDocument xbrlDocument;
        String string = label.getLang();
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        Object object2 = string.startsWith("zh") ? g2.a : (xbrlDocument = string.startsWith("en") ? g2.b : null);
        if (xbrlDocument == null) {
            return false;
        }
        Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
        Map<ExtendedLink, ExtendedLinkSummary> map = g2.b();
        Loc loc = null;
        Object object3 = null;
        List list = linkbase.getExtendedLinks((QName)QNameConstants.labelLink);
        if (list == null || list.size() == 0) {
            return false;
        }
        ExtendedLink extendedLink = (ExtendedLink)list.get(0);
        Object object4 = extendedLink.getRelationships().iterator();
        while (object4.hasNext()) {
            relationship = (Relationship)object4.next();
            if (relationship.fromConcept() != xbrlConcept) continue;
            loc = (Loc)relationship.fromPoint();
            object3 = relationship.fromLabel();
            break;
        }
        if (loc == null) {
            relationship = map.get(extendedLink);
            if (relationship == null) {
                return false;
            }
            object4 = xbrlConcept.getQName().getLocalPart();
            if (relationship.hasArcEnd((String)object4)) {
                n = 0;
                object = relationship.getArcEnds((String)object4);
                Object object5 = object.iterator();
                while (object5.hasNext()) {
                    arcEnd = (ArcEnd)object5.next();
                    if (!(arcEnd instanceof Loc) || ((Loc)arcEnd).getFinalTarget() != xbrlConcept) continue;
                    n = 1;
                    loc = (Loc)arcEnd;
                    object3 = object4;
                    break;
                }
                if (n == 0) {
                    int n2 = 1;
                    object5 = String.valueOf(object4) + "_" + ++n2;
                    while (relationship.hasArcEnd((String)object5)) {
                        object5 = String.valueOf(object4) + "_" + ++n2;
                    }
                    object3 = object5;
                }
            } else {
                object3 = object4;
            }
            if (loc == null) {
                loc = extendedLink.createLoc(null, (String)object3);
                extendedLink.appendChild((XdmNode)loc);
                loc.setTarget((Object)xbrlConcept);
                relationship.putEnd((ArcEnd)loc);
            }
        }
        if ((relationship = map.get(extendedLink)).hasArcEnd((String)(object4 = label.getLabel()))) {
            n = 1;
            object = String.valueOf(object4) + "_" + ++n;
            while (relationship.hasArcEnd((String)object)) {
                object = String.valueOf(object4) + "_" + ++n;
            }
            object4 = object;
        }
        Label label2 = (Label)extendedLink.createResource((QName)QNameConstants.label, (String)object4, label.getRole());
        label2.setLang(label.getLang());
        label2.setInnerText(label.getInnerText());
        label2.setTitle(label.getTitle());
        extendedLink.appendChild((XdmNode)label2);
        relationship.putEnd((ArcEnd)label2);
        object = extendedLink.createArc((QName)QNameConstants.labelArc, "http://www.xbrl.org/2003/arcrole/concept-label", "1.0");
        object.setFrom((String)object3);
        object.setTo((String)object4);
        extendedLink.appendChild((XdmNode)object);
        relationship.addRelationship((XbrlElement)loc, (XbrlElement)label2, (Arc)object);
        arcEnd = relationship.getRelationshipSet();
        if (arcEnd != null) {
            this.b.add(arcEnd);
        }
        return true;
    }

    private boolean a(RelationshipSet relationshipSet, Relationship relationship, Label label, XbrlDocument xbrlDocument, Map<ExtendedLink, ExtendedLinkSummary> map) {
        ArcEnd arcEnd;
        Object object;
        List list;
        Object object2;
        Object object3;
        if (relationship == null || relationship.isReadOnly() || xbrlDocument == null || !(xbrlDocument.getDocumentElement() instanceof Linkbase)) {
            return false;
        }
        XbrlConcept xbrlConcept = relationship.fromConcept();
        Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
        Loc loc = null;
        Object object4 = null;
        ExtendedLink extendedLink = null;
        Object object5 = relationshipSet.getEffectiveChildren(relationship.fromTarget()).iterator();
        while (object5.hasNext()) {
            object3 = (Relationship)object5.next();
            if (object3 == relationship || object3.fromPoint().getOwnerDocument() != xbrlDocument || object3.isRemoved() || !(object3.fromPoint() instanceof Loc)) continue;
            loc = (Loc)object3.fromPoint();
            object4 = object3.fromLabel();
            extendedLink = (ExtendedLink)loc.getParent();
            break;
        }
        if (loc == null) {
            object3 = linkbase.getExtendedLinks((QName)QNameConstants.labelLink, relationshipSet.getRoleURI());
            if (object3 == null || object3.size() == 0) {
                extendedLink = linkbase.createExtendedLink((QName)QNameConstants.labelLink);
                extendedLink.setRole(relationshipSet.getRoleURI());
                linkbase.appendChild((XdmNode)extendedLink);
                map.put(extendedLink, new ExtendedLinkSummary(extendedLink, this.dts));
            } else {
                extendedLink = (ExtendedLink)object3.get(0);
            }
            object5 = map.get(extendedLink);
            if (object5 == null) {
                return false;
            }
            object2 = xbrlConcept.getQName().getLocalPart();
            if (object5.hasArcEnd((String)object2)) {
                boolean bl = false;
                list = object5.getArcEnds((String)object2);
                object = list.iterator();
                while (object.hasNext()) {
                    arcEnd = (ArcEnd)object.next();
                    if (!(arcEnd instanceof Loc) || ((Loc)arcEnd).getFinalTarget() != xbrlConcept || ((Loc)arcEnd).getParent() == null) continue;
                    bl = true;
                    object4 = object2;
                    loc = (Loc)arcEnd;
                    break;
                }
                if (!bl) {
                    int n = 1;
                    object = String.valueOf(object2) + "_" + ++n;
                    while (object5.hasArcEnd((String)object)) {
                        object = String.valueOf(object2) + "_" + ++n;
                    }
                    object4 = object;
                }
            } else {
                object4 = object2;
            }
            if (loc == null) {
                loc = extendedLink.createLoc(null, (String)object4);
                extendedLink.appendChild((XdmNode)loc);
                loc.setTarget((Object)xbrlConcept);
                object5.putEnd((ArcEnd)loc);
            }
        }
        if (extendedLink == null) {
            System.err.println("move label labelLink is null.");
            return false;
        }
        object3 = map.get(extendedLink);
        if (object3 == null) {
            object3 = new ExtendedLinkSummary(extendedLink, this.dts);
            map.put(extendedLink, (ExtendedLinkSummary)object3);
        }
        if (object3.hasArcEnd((String)(object5 = label.getLabel()))) {
            int n = 1;
            String string = String.valueOf(object5) + "_" + ++n;
            while (object3.hasArcEnd(string)) {
                string = String.valueOf(object5) + "_" + ++n;
            }
            object5 = string;
        }
        object2 = (Label)extendedLink.createResource((QName)QNameConstants.label, (String)object5, label.getRole());
        object2.setLang(label.getLang());
        object2.setInnerText(label.getInnerText());
        String string = label.getId();
        if (object2.getOwnerDocument().getElementById(string) == null) {
            object2.setId(string);
        }
        object2.setTitle(label.getTitle());
        extendedLink.appendChild((XdmNode)object2);
        object3.putEnd((ArcEnd)object2);
        list = extendedLink.createArc((QName)QNameConstants.labelArc, relationship.arcrole(), relationship.arc().getOrder().toPlainString());
        list.setFrom((String)object4);
        list.setTo((String)object5);
        list.setTitle(relationship.arc().getTitle());
        extendedLink.appendChild((XdmNode)list);
        object3.addRelationship((XbrlElement)loc, (XbrlElement)object2, (Arc)list);
        arcEnd = object3.getRelationshipSet();
        if (arcEnd != null) {
            this.b.add(arcEnd);
        }
        Object object6 = object = relationship.isSingle() ? null : new ArrayList();
        if (!relationship.purge((Collection)object)) {
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Relationship relationship2 = (Relationship)iterator.next();
                    relationshipSet.removeRelaionship(relationship2);
                }
            }
            return false;
        }
        relationshipSet.removeRelaionship(relationship);
        this.b.add(relationshipSet);
        this.fixBug("move label " + xbrlConcept.getPrefixedName() + " " + label.getLang(), true);
        return true;
    }

    private void M() {
        XbrlSchema[] xbrlSchemaArray;
        this.rebuildRelationshipSet();
        Map<String, Collection<QName>> map = null;
        XbrlSchema[] xbrlSchemaArray2 = xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray2[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                for (RoleType roleType : xbrlSchema.getRoleTypes()) {
                    Object object;
                    QName qName;
                    Object object22;
                    String string = roleType.getRoleURI();
                    for (Object object22 : roleType.getUsedOns()) {
                        try {
                            qName = object22.getQName();
                            if (this.dts.getRelationshipSet(qName, string) != null) continue;
                            if (map == null) {
                                map = this.N();
                            }
                            if ((object = map.get(string)) != null && object.contains(qName)) continue;
                            roleType.removeChild((XdmNode)object22);
                            this.fixBug("remove " + qName.getLocalPart() + " from roleType = " + string, true);
                        }
                        catch (EvaluationException evaluationException) {
                            evaluationException.printStackTrace();
                        }
                    }
                    object22 = this.dts.getRelationshipSets(string);
                    Collection collection = roleType.getUsedOns();
                    object = object22.iterator();
                    while (object.hasNext()) {
                        qName = (RelationshipSet)object.next();
                        try {
                            UsedOn usedOn;
                            boolean bl = false;
                            Iterator iterator = collection.iterator();
                            while (iterator.hasNext()) {
                                usedOn = (UsedOn)iterator.next();
                                if (!qName.getExtendedName().equals(usedOn.getQName())) continue;
                                bl = true;
                                break;
                            }
                            if (bl) continue;
                            usedOn = roleType.createUsedOn(qName.getExtendedName());
                            roleType.appendChild((XdmNode)usedOn);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private Map<String, Collection<QName>> N() {
        IXbrlDocument[] iXbrlDocumentArray;
        HashMap<String, Collection<QName>> hashMap = new HashMap<String, Collection<QName>>();
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (iXbrlDocument != null && !iXbrlDocument.isReadOnly() && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() != null && xbrlDocument.getDocumentElement() instanceof Linkbase) {
                for (ExtendedLink extendedLink : ((Linkbase)xbrlDocument.getDocumentElement()).getExtendedLinks()) {
                    String string = extendedLink.getRole();
                    if (StringUtils.isEmpty((String)string)) {
                        string = "http://www.xbrl.org/2003/role/link";
                    }
                    QName qName = extendedLink.getNodeName();
                    HashSet<QName> hashSet = (HashSet<QName>)hashMap.get(string);
                    if (hashSet == null) {
                        hashSet = new HashSet<QName>();
                        hashMap.put(string, hashSet);
                    }
                    hashSet.add(qName);
                }
            }
            ++n2;
        }
        return hashMap;
    }

    private void O() {
        XdmNode[] xdmNodeArray;
        XdmNode[] xdmNodeArray2;
        XbrlSchema[] xbrlSchemaArray;
        if (this.xbrlInstance != null) {
            this.a((XdmDocument)this.xbrlInstance.getOwnerDocument());
        }
        XbrlSchema[] xbrlSchemaArray2 = xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            xdmNodeArray2 = xbrlSchemaArray2[n2];
            if (xdmNodeArray2 != null && !xdmNodeArray2.isReadOnly() && (xdmNodeArray = xdmNodeArray2.getHeaderComments()) != null && xdmNodeArray.length > 0) {
                XdmNode[] xdmNodeArray3;
                ArrayList<XdmNode[]> arrayList = new ArrayList<XdmNode[]>();
                XdmNode[] xdmNodeArray4 = xdmNodeArray;
                int n3 = xdmNodeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    xdmNodeArray3 = xdmNodeArray4[n4];
                    if (xdmNodeArray3 != null && !xdmNodeArray3.getInnerText().contains("Fujitsu")) {
                        arrayList.add(xdmNodeArray3);
                    }
                    ++n4;
                }
                if (arrayList.size() == 0) {
                    xdmNodeArray2.setHeaderComments(null);
                } else {
                    xdmNodeArray3 = arrayList.toArray(new XdmNode[arrayList.size()]);
                    xdmNodeArray2.setHeaderComments(xdmNodeArray3);
                }
            }
            ++n2;
        }
        xdmNodeArray = xdmNodeArray2 = this.dts.getDocuments();
        int n5 = xdmNodeArray2.length;
        n = 0;
        while (n < n5) {
            XdmNode xdmNode = xdmNodeArray[n];
            if (xdmNode != null && !xdmNode.isReadOnly() && xdmNode instanceof XdmDocument) {
                this.a((XdmDocument)xdmNode);
            }
            ++n;
        }
    }

    private void a(XdmDocument xdmDocument) {
        if (xdmDocument == null) {
            return;
        }
        XdmNode xdmNode = xdmDocument.getFirstChild();
        while (xdmNode != null) {
            XdmText xdmText;
            XdmNode xdmNode2 = xdmNode.getNextSibling();
            if (xdmNode.getNodeNature() == 6 && xdmNode instanceof XdmText && (xdmText = (XdmText)xdmNode).getInnerText().contains("Fujitsu")) {
                xdmDocument.removeChild((XdmNode)xdmText);
            }
            xdmNode = xdmNode2;
        }
    }

    private void P() {
        if (this.xbrlInstance == null) {
            return;
        }
        XdmNode xdmNode = null;
        XdmNode xdmNode22 = this.xbrlInstance.getFirstChild();
        while (xdmNode22 != null) {
            if (xdmNode22.getNodeNature() == 2 && xdmNode22 instanceof Fact) {
                xdmNode = xdmNode22;
                break;
            }
            xdmNode22 = xdmNode22.getNextSibling();
        }
        if (xdmNode == null) {
            return;
        }
        for (XdmNode xdmNode22 : this.xbrlInstance.getUnits()) {
            this.xbrlInstance.insertBefore(xdmNode22, xdmNode);
            this._hasBugFixed = true;
        }
    }

    private void Q() {
        IXbrlDocument[] iXbrlDocumentArray;
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                ExtendedLink extendedLink = null;
                Object object = linkbase.getFirstChild();
                while (object != null) {
                    if (object.getNodeNature() == 2 && object instanceof ExtendedLink) {
                        extendedLink = (ExtendedLink)object;
                        break;
                    }
                    object = object.getNextSibling();
                }
                if (extendedLink != null) {
                    object = this.b(linkbase);
                    for (RoleRef roleRef : object.values()) {
                        linkbase.insertBefore((XdmNode)roleRef, (XdmNode)extendedLink);
                    }
                }
            }
            ++n2;
        }
    }

    private void R() {
        for (RelationshipSet relationshipSet : this.dts.getRelationshipSets()) {
            QName qName = relationshipSet.getExtendedName();
            if (qName.equals(QNameConstants.genericLink) || qName.equals(QNameConstants.labelLink)) continue;
            this.f(relationshipSet);
        }
    }

    public void updateOrderAttributeOfArcs() {
        this.R();
    }

    private void b(RelationshipSet relationshipSet, List<Relationship> list) {
        BigDecimal bigDecimal = null;
        BigDecimal bigDecimal2 = null;
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        int n5 = list.size();
        while (n4 < n5) {
            Relationship relationship = list.get(n4);
            if (relationship.isReadOnly()) {
                if (n == 0) {
                    bigDecimal = relationship.arc().getOrder();
                    n2 = n4;
                    bigDecimal2 = null;
                    n3 = -1;
                } else {
                    bigDecimal2 = relationship.arc().getOrder();
                    n3 = n4;
                    this.a(list, bigDecimal, bigDecimal2, n2, n3);
                    n2 = n3;
                    n3 = -1;
                    bigDecimal = bigDecimal2;
                    bigDecimal2 = null;
                    n = 0;
                }
            } else {
                ++n;
            }
            ++n4;
        }
        if (bigDecimal != null || bigDecimal2 != null) {
            this.a(list, bigDecimal, bigDecimal2, n2, n3);
        }
    }

    private void a(List<Relationship> list, BigDecimal bigDecimal, BigDecimal bigDecimal2, int n, int n2) {
        BigDecimal bigDecimal3;
        int n3 = -1;
        int n4 = -1;
        if (bigDecimal == null) {
            bigDecimal = BigDecimal.ZERO;
            n3 = 0;
            n4 = n2 - 1;
        } else if (bigDecimal2 == null) {
            bigDecimal2 = BigDecimalConstants.valueOf((String)"100000000");
            n3 = n + 1;
            n4 = list.size() - 1;
        } else {
            if (bigDecimal.compareTo(bigDecimal2) >= 0) {
                return;
            }
            n3 = n + 1;
            n4 = n2 - 1;
        }
        if (n3 > n4 || n3 < 0 || n4 < 0) {
            return;
        }
        int n5 = n4 - n3 + 1;
        BigDecimal bigDecimal4 = null;
        BigDecimal bigDecimal5 = new BigDecimal(n5 + 1);
        int n6 = 0;
        while (n6 < z.length) {
            bigDecimal3 = z[n6];
            if (bigDecimal.add(bigDecimal3.multiply(bigDecimal5)).compareTo(bigDecimal2) < 0) {
                bigDecimal4 = bigDecimal3;
                break;
            }
            ++n6;
        }
        if (bigDecimal4 == null) {
            return;
        }
        n6 = n3;
        while (n6 <= n4) {
            bigDecimal3 = list.get(n6);
            if (bigDecimal3.isSingle()) {
                bigDecimal3.arc().setOrder(bigDecimal4.multiply(new BigDecimal(n6 + 1)));
                bigDecimal3.arc().getOwnerDocument().setModified(true);
            } else {
                Relationship[] relationshipArray = bigDecimal3.toArray();
                int n7 = relationshipArray.length;
                int n8 = 0;
                while (n8 < n7) {
                    Relationship relationship = relationshipArray[n8];
                    relationship.arc().setOrder(bigDecimal4.multiply(new BigDecimal(n6 + 1)));
                    relationship.arc().getOwnerDocument().setModified(true);
                    ++n8;
                }
            }
            ++n6;
        }
    }

    private void f(RelationshipSet relationshipSet) {
        for (Object e2 : relationshipSet.getFromTargets()) {
            Object object2;
            List list = relationshipSet.getChildren(e2);
            if (list.size() == 0) continue;
            boolean bl = true;
            boolean bl2 = true;
            BigDecimal bigDecimal = BigDecimal.ZERO;
            for (Object object2 : list) {
                if (!object2.isReadOnly()) {
                    bl2 = false;
                }
                if (!object2.isOptional() && object2.arc().getOrder().compareTo(bigDecimal) > 0) {
                    bigDecimal = object2.arc().getOrder();
                }
                if (!object2.isOptional() || !object2.isReadOnly() && object2.isSingle()) continue;
                bl = false;
                break;
            }
            if (bl2) continue;
            if (!bl) {
                this.b(relationshipSet, list);
                continue;
            }
            object2 = relationshipSet.getEffectiveChildren(e2);
            if (object2.size() == 0) continue;
            int n = (int)Math.ceil(bigDecimal.doubleValue());
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Relationship relationship = (Relationship)iterator.next();
                double d2 = ++n;
                if (relationship.isSingle()) {
                    relationship.arc().setOrder(BigDecimalConstants.valueOf((String)Double.toString(d2)));
                    continue;
                }
                Relationship[] relationshipArray = relationship.toArray();
                int n2 = relationshipArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Relationship relationship2 = relationshipArray[n3];
                    relationship2.arc().setOrder(BigDecimalConstants.valueOf((String)Double.toString(d2)));
                    ++n3;
                }
            }
        }
    }

    private boolean d(String string) {
        RoleType[] roleTypeArray = this.dts.getRoleTypes().get(string);
        if (roleTypeArray != null) {
            RoleType[] roleTypeArray2 = roleTypeArray;
            int n = roleTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                RoleType roleType = roleTypeArray2[n2];
                String string2 = roleType.getDefinitionText();
                if (string2 != null && (string2.contains("Separate") || string2.contains("Separated"))) {
                    return true;
                }
                if (this.m) {
                    for (RelationshipSet relationshipSet : this.genericLinkRS) {
                        for (Relationship relationship : relationshipSet.getEffectiveChildren((Object)roleType)) {
                            GenericLabel genericLabel;
                            if (!(relationship.toTarget() instanceof GenericLabel) || (string2 = (genericLabel = (GenericLabel)relationship.toTarget()).getInnerText()) == null || !string2.contains("Separate") && !string2.contains("Separated")) continue;
                            return true;
                        }
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private void S() {
        RelationshipSet relationshipSet2;
        if (this.xbrlInstance == null) {
            return;
        }
        if (this.n == null || this.o == null) {
            return;
        }
        QName qName = this.o.getQName();
        QName qName2 = this.n.getQName();
        this.genericLinkRS = this.dts.getRelationshipSets((QName)QNameConstants.genericLink);
        this.m = this.genericLinkRS != null && this.genericLinkRS.size() > 0;
        Collection collection = this.dts.getPresentationRelationships();
        ArrayList<RelationshipSet> arrayList = new ArrayList<RelationshipSet>();
        ArrayList<RelationshipSet> arrayList2 = new ArrayList<RelationshipSet>();
        for (RelationshipSet relationshipSet2 : collection) {
            String string = relationshipSet2.getRoleURI();
            if (!this.d(string)) {
                arrayList.add(relationshipSet2);
                continue;
            }
            if (relationshipSet2.contains((Object)this.n)) {
                arrayList2.add(relationshipSet2);
                continue;
            }
            arrayList.add(relationshipSet2);
        }
        relationshipSet2 = new HashSet();
        for (RelationshipSet relationshipSet3 : arrayList2) {
            Object object6;
            Object object2;
            Object object3;
            Object object42;
            relationshipSet2.clear();
            relationshipSet3.getAllTargets((Set)relationshipSet2);
            if (relationshipSet2.size() == 0) continue;
            boolean bl = true;
            block2: for (Object object42 : relationshipSet2) {
                if (!(object42 instanceof XbrlConcept)) {
                    bl = false;
                    break;
                }
                object3 = (XbrlConcept)object42;
                if (object3.isAbstract() || (object2 = this.f.get(object3.getQName())) == null || object2.size() == 0) continue;
                Object object52 = object2.iterator();
                while (object52.hasNext()) {
                    MemberElement memberElement;
                    object6 = object52.next();
                    Context context = object6.getContext();
                    if (context == null || (memberElement = context.getDimensionValue(qName)) == null || !qName2.equals(memberElement.getDimensionContent())) continue;
                    bl = false;
                    break block2;
                }
                boolean bl2 = false;
                for (Object object52 : arrayList) {
                    if (!object52.contains(object42)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            relationshipSet3.purgeOrProhibitTargets((Collection)relationshipSet2);
            object42 = relationshipSet3.getRoleURI();
            this.fixBug("remove roleURI=\"" + object42 + "\"", true);
            List<RelationshipSet> list = this.c((String)object42);
            object2 = list.iterator();
            while (object2.hasNext()) {
                object3 = (RelationshipSet)object2.next();
                relationshipSet2.clear();
                object3.getAllTargets((Set)relationshipSet2);
                for (Object object6 : relationshipSet2) {
                    object3.purgeOrProhibitTarget(object6);
                }
            }
            object3 = this.b((String)object42);
            object6 = object3.iterator();
            while (object6.hasNext()) {
                object2 = (RelationshipSet)object6.next();
                relationshipSet2.clear();
                object2.getAllTargets((Set)relationshipSet2);
                for (Object object52 : relationshipSet2) {
                    object2.purgeOrProhibitTarget(object52);
                }
            }
        }
    }

    private void b(boolean bl, boolean bl2) {
        this.az();
        this.bugFixDuplicateRoleTypeId();
        this.j();
        this.s();
        this.d();
        this.i();
        this.h();
        this.u();
        this.w();
        this.x();
        this.q();
        this.ax();
        this.ay();
        this.b();
        this.bugFixDuplicateArc();
        this.y();
        this.ar();
        this.c();
        this.z();
        this.ao();
        this.p();
        this.rebuildRelationshipSet();
        this.m();
        this.W();
        this.k();
        this.l();
        this.am();
        if (this.getOptions().isCommonClear()) {
            g g2 = this.K();
            try {
                g2.a(true);
                this.a(bl, bl2);
            }
            finally {
                g2.a(false);
            }
        }
        try {
            this.H();
            this.Q();
            this.P();
            this.M();
            this.L();
            this.R();
            this.O();
            this.F();
            this.V();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.ar();
        this.X();
        this.n();
        this.U();
        if (bl && this.xbrlInstance != null) {
            this.as();
            this.at();
            this.ab();
        }
    }

    private void T() {
        Collection collection = this.dts.getLabelRelationships();
        HashSet<f> hashSet = new HashSet<f>();
        HashMap<Label, RelationshipSet> hashMap = null;
        for (RelationshipSet object : collection) {
            for (Object e2 : object.getFromTargets()) {
                if (!(e2 instanceof XbrlConcept)) continue;
                XbrlConcept xbrlConcept = (XbrlConcept)e2;
                hashSet.clear();
                for (Relationship relationship : object.getEffectiveChildren((Object)xbrlConcept)) {
                    if (!(relationship.toTarget() instanceof Label)) continue;
                    Label label = (Label)relationship.toTarget();
                    String string = label.getRole();
                    f f2 = new f();
                    f2.b(string);
                    f2.a(label.getLang());
                    if (hashSet.contains(f2)) {
                        if (hashMap == null) {
                            hashMap = new HashMap<Label, RelationshipSet>();
                        }
                        hashMap.put(label, object);
                        continue;
                    }
                    hashSet.add(f2);
                }
            }
        }
        if (hashMap != null && hashMap.size() > 0) {
            try {
                for (Map.Entry entry : hashMap.entrySet()) {
                    ((RelationshipSet)entry.getValue()).purgeOrProhibitTarget(entry.getKey(), false);
                    this.b.add((RelationshipSet)entry.getValue());
                    this._hasBugFixed = true;
                }
                this.rebuildRelationshipSet();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void U() {
        Object object;
        String string;
        PresentationArc presentationArc;
        List list;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Collection collection = this.dts.getLabelRelationships();
        for (RelationshipSet object2 : collection) {
            Object object3;
            list = object2.getRootNodes();
            int list2 = list.size() - 1;
            while (list2 > -1) {
                Object e2 = list.get(list2);
                if (!object2.hasParent(e2) && !object2.hasChildren(e2) && e2 instanceof Label && (object3 = (Label)e2).getParent() != null) {
                    object3.getParent().removeChild((XdmNode)object3);
                    object2.removeTarget(e2, true);
                }
                --list2;
            }
            for (Object e3 : object2.getFromTargets()) {
                if (!(e3 instanceof XbrlConcept)) continue;
                object3 = (XbrlConcept)e3;
                Object object4 = null;
                presentationArc = object2.getEffectiveChildren(object3).iterator();
                while (presentationArc.hasNext()) {
                    Relationship relationship = (Relationship)presentationArc.next();
                    if (!(relationship.toTarget() instanceof Label) || "http://www.xbrl.org/2003/role/label".equals(string = (object = (Label)relationship.toTarget()).getRole())) continue;
                    if (object4 == null) {
                        object4 = (List)hashMap.get(object3);
                    }
                    if (object4 == null) {
                        object4 = new ArrayList();
                        hashMap.put(object3, object4);
                    }
                    if (object4.contains(string)) continue;
                    object4.add(string);
                }
            }
        }
        this.j = this.dts.getPresentationRelationships();
        for (Map.Entry entry : hashMap.entrySet()) {
            list = (XbrlConcept)entry.getKey();
            List list2 = (List)entry.getValue();
            for (RelationshipSet relationshipSet : this.j) {
                for (Object object4 : relationshipSet.getParents((Object)list)) {
                    if (!(object4.arc() instanceof PresentationArc) || StringUtils.isEmpty((String)(object = (presentationArc = (PresentationArc)object4.arc()).getPreferredLabel())) || "http://www.xbrl.org/2003/role/label".equals(object)) continue;
                    list2.remove(object);
                }
            }
            if (list2.size() <= 0) continue;
            for (String string2 : list2) {
                for (Object object4 : collection) {
                    object = new ArrayList(object4.getEffectiveChildren((Object)list)).iterator();
                    while (object.hasNext()) {
                        String string3;
                        presentationArc = (Relationship)object.next();
                        if (!(presentationArc.toTarget() instanceof Label) || !string2.equals(string3 = (string = (Label)presentationArc.toTarget()).getRole()) || string.getOwnerDocument().isReadOnly()) continue;
                        object4.purgeOrProhibitTarget((Object)string);
                    }
                }
            }
        }
    }

    private void V() {
        IXbrlDocument[] iXbrlDocumentArray;
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Linkbase linkbase;
            String string;
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase && !StringUtils.isEmpty((String)(string = (linkbase = (Linkbase)xbrlDocument.getDocumentElement()).getNamespacePrefix("http://xbrl.org/2005/xbrldt")))) {
                boolean bl = false;
                XdmNode xdmNode = linkbase.getFirstChild();
                while (xdmNode != null) {
                    if (xdmNode.getNodeNature() == 2 && xdmNode.getNodeName().equals(QNameConstants.presentationLink)) {
                        bl = true;
                        XdmNode xdmNode2 = xdmNode.getFirstChild();
                        while (xdmNode2 != null) {
                            if (xdmNode2.getNodeNature() == 2 && xdmNode2 instanceof PresentationArc) {
                                PresentationArc presentationArc = (PresentationArc)xdmNode2;
                                presentationArc.removeAttributeNode((QName)QNameConstants.usable);
                                presentationArc.removeAttributeNode((QName)QNameConstants.closed);
                                presentationArc.removeAttributeNode((QName)QNameConstants.contextElement);
                                presentationArc.removeAttributeNode((QName)QNameConstants.targetRole);
                            }
                            xdmNode2 = xdmNode2.getNextSibling();
                        }
                    }
                    xdmNode = xdmNode.getNextSibling();
                }
                if (bl) {
                    linkbase.removeAttributeNode(string, "http://www.w3.org/2000/xmlns/");
                }
            }
            ++n2;
        }
    }

    private void W() {
        if (this.xbrlInstance == null) {
            return;
        }
        try {
            String string3;
            Node node;
            Fact fact2 = this.xbrlInstance.getAttributes();
            int n = ((Node[])fact2).length;
            int n2 = 0;
            while (n2 < n) {
                node = fact2[n2];
                QName qName = node.getNodeName();
                string3 = qName.getNamespaceURI();
                if (!StringUtils.isEmpty((String)string3) && gbicc_URI.equals(string3)) {
                    this.xbrlInstance.removeAttributeNode(qName);
                    this._hasBugFixed = true;
                }
                ++n2;
            }
            node = new ArrayList();
            for (List<Fact> list : this.f.values()) {
                for (Fact fact2 : list) {
                    node.clear();
                    Node[] nodeArray = fact2.getAttributes();
                    int n3 = nodeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        string3 = nodeArray[n4];
                        QName qName = string3.getNodeName();
                        String string2 = qName.getNamespaceURI();
                        if (!StringUtils.isEmpty((String)string2) && gbicc_URI.equals(string2)) {
                            fact2.removeAttributeNode(qName);
                            this._hasBugFixed = true;
                            node.add(string2);
                        }
                        ++n4;
                    }
                    if (node.size() <= 0) continue;
                    for (String string3 : node) {
                        String string4 = fact2.getNamespacePrefix(string3);
                        if (StringUtils.isEmpty((String)string4)) continue;
                        fact2.removeAttributeNode(string4, "http://www.w3.org/2000/xmlns/");
                    }
                }
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)("remove metaInfo: " + exception.getMessage()));
        }
    }

    private boolean a(Fact fact) {
        String string;
        XbrlConcept xbrlConcept;
        String string2 = fact.getLocalName();
        if (string2.contains("The") && (xbrlConcept = this.dts.getConcept(string = string2.replace("The", ""), fact.getNamespaceURI())) != null) {
            Fact fact2 = this.xbrlInstance.createFact(xbrlConcept.getQName());
            fact.copyTo(fact2);
            fact.getParent().insertBefore((XdmNode)fact2, (XdmNode)fact);
            fact.getParent().removeChild((XdmNode)fact);
            this.fixBug("change fact: " + string2 + " --> " + string);
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean a(Context var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean a(QName qName, XbrlConcept xbrlConcept, boolean bl) {
        HashSet<Context> hashSet;
        if (this.xbrlInstance == null) {
            return false;
        }
        boolean bl2 = false;
        QName qName2 = xbrlConcept.getQName();
        this.f = this.xbrlInstance.getAllFacts(true);
        List<Fact> list = this.f.get(qName);
        HashSet<Context> hashSet2 = hashSet = bl ? new HashSet<Context>() : null;
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                Fact fact = list.get(n);
                Context context = fact.getContext();
                Fact fact2 = this.xbrlInstance.createFact(qName2);
                fact.copyTo(fact2);
                fact.getParent().insertBefore((XdmNode)fact2, (XdmNode)fact);
                fact.getParent().removeChild((XdmNode)fact);
                list.set(n, fact2);
                fact.getOwnerDocument().setModified(true);
                bl2 = true;
                this.fixBug("change fact: " + qName.getLocalPart() + " --> " + qName2.getLocalPart());
                if (bl && context != null && context.getPeriodType() != xbrlConcept.getPeriodType()) {
                    hashSet.add(context);
                    this.changeFactContext(fact2, xbrlConcept, context);
                }
                ++n;
            }
        }
        for (Context context : this.xbrlInstance.getContexts()) {
            boolean bl3 = bl2 = this.a(context, qName, qName2) || bl2;
        }
        if (hashSet != null) {
            for (Context context : hashSet) {
                if (this.xbrlInstance.isUsed(context)) continue;
                context.getParent().removeChild((XdmNode)context);
                context.getOwnerDocument().setModified(true);
            }
        }
        this.f = this.xbrlInstance.getAllFacts(true);
        return bl2;
    }

    private boolean a(Context context, QName qName, QName qName2) {
        String string;
        boolean bl;
        block18: {
            Scenario scenario = context.getScenario();
            Segment segment = context.getSegment();
            bl = false;
            try {
                try {
                    OpenContextComponent[] openContextComponentArray = new OpenContextComponent[]{scenario, segment};
                    int n = openContextComponentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        string = openContextComponentArray[n2];
                        if (string != null) {
                            XdmNode xdmNode = string.getFirstChild();
                            while (xdmNode != null) {
                                if (xdmNode instanceof MemberElement) {
                                    ExplicitMember explicitMember;
                                    QName qName3;
                                    MemberElement memberElement = (MemberElement)xdmNode;
                                    QName qName4 = memberElement.getDimension();
                                    if (qName.equals(qName4)) {
                                        memberElement.setDimension(qName2);
                                        context.getOwnerDocument().setModified(true);
                                        bl = true;
                                    }
                                    if (memberElement instanceof ExplicitMember && qName.equals(qName3 = (explicitMember = (ExplicitMember)memberElement).getDimensionContent())) {
                                        explicitMember.setDimensionContent(qName2);
                                        context.getOwnerDocument().setModified(true);
                                        bl = true;
                                    }
                                }
                                xdmNode = xdmNode.getNextSibling();
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    LogWatch.error((Object)("changeContext: " + exception.getMessage()));
                    if (bl) {
                        context.process(this.getProcessContext());
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    context.process(this.getProcessContext());
                }
                throw throwable;
            }
            if (bl) {
                context.process(this.getProcessContext());
            }
        }
        if (bl) {
            String string2;
            string = context.getId();
            if (!string.equals(string2 = string.replace(qName.getLocalPart(), qName2.getLocalPart()))) {
                context.setId(string2);
                for (List list : this.f.values()) {
                    for (XdmNode xdmNode : list) {
                        if (!string.equals(xdmNode.getContextRef())) continue;
                        xdmNode.setContextRef(string2);
                    }
                }
                context.getOwnerDocument().setModified(true);
            }
            this.fixBug("context: " + context.getId());
        }
        return bl;
    }

    private void X() {
        Object object2;
        MemberElement[] memberElementArray;
        Map.Entry<QName, List<Fact>> entry22;
        if (this.xbrlInstance == null) {
            return;
        }
        if (this.getOptions().isFixMissingConceptForThe() && this.f != null) {
            for (Map.Entry<QName, List<Fact>> context : this.f.entrySet()) {
                if (this.dts.getConcept(context.getKey()) != null) continue;
                for (XdtProcessor xdtProcessor : context.getValue()) {
                    this.a((Fact)xdtProcessor);
                }
            }
            entry22 = this.xbrlInstance.getContexts().iterator();
            while (entry22.hasNext()) {
                Context bl = (Context)entry22.next();
                boolean bl2 = true;
                block3: for (Map.Entry entry : bl.getDimensionContents().entrySet()) {
                    if (this.dts.getConcept((QName)entry.getKey()) == null) {
                        bl2 = false;
                        this.reportBug("axis missing: " + entry.getKey() + " @" + bl.getId());
                        break;
                    }
                    memberElementArray = (MemberElement[])entry.getValue();
                    int n = memberElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        object2 = memberElementArray[n2];
                        if (object2 instanceof ExplicitMember && this.dts.getConcept(((ExplicitMember)object2).getDimensionContent()) == null) {
                            bl2 = false;
                            this.reportBug("member missing: " + entry.getKey() + " @" + bl.getId());
                            break block3;
                        }
                        ++n2;
                    }
                }
                if (bl2) continue;
                this.a(bl);
            }
            this.f = this.xbrlInstance.getAllFacts(true);
        }
        if (this.f != null && this.getOptions().isFixInstance()) {
            this.Y();
        }
        if (this.getOptions().isRemoveUnbindedFacts() && this.f != null) {
            boolean list;
            boolean context = false;
            for (Map.Entry<QName, List<Fact>> entry22 : this.f.entrySet()) {
                if (this.dts.getConcept((QName)entry22.getKey()) != null) continue;
                for (Fact fact : (List)entry22.getValue()) {
                    list = true;
                    fact.getParent().removeChild((XdmNode)fact);
                    this.fixBug("remove fact: " + fact);
                }
            }
            if (list) {
                this.f = this.xbrlInstance.getAllFacts(true);
            }
        }
        if (this.getOptions().isRemoveInvalidXdtFacts() && this.f != null) {
            boolean bl;
            XdtProcessor xdtProcessor;
            this.rebuildRelationshipSet();
            boolean bl3 = false;
            entry22 = this.getProcessContext();
            xdtProcessor = new XdtProcessor(this.dts);
            for (List list : this.f.values()) {
                for (Object object2 : list) {
                    if (xdtProcessor.isXdtValid((Fact)object2, (ProcessContext)entry22, null)) continue;
                    bl = true;
                    object2.getParent().removeChild((XdmNode)object2);
                    this.fixBug("remove xdt invalid fact: " + object2.toString());
                }
            }
            if (bl) {
                this.f = this.xbrlInstance.getAllFacts(true);
            }
        }
        if (this.getOptions().isRemoveUnbindedContexts() && this.xbrlInstance != null) {
            entry22 = this.xbrlInstance.getContexts().iterator();
            while (entry22.hasNext()) {
                Context context = (Context)entry22.next();
                boolean bl = true;
                block10: for (Map.Entry entry : context.getDimensionContents().entrySet()) {
                    if (this.dts.getConcept((QName)entry.getKey()) == null) {
                        bl = false;
                        this.reportBug("axis missing: " + entry.getKey() + " @" + context.getId());
                        break;
                    }
                    memberElementArray = (MemberElement[])entry.getValue();
                    int n = memberElementArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        object2 = memberElementArray[n3];
                        if (object2 instanceof ExplicitMember && this.dts.getConcept(((ExplicitMember)object2).getDimensionContent()) == null) {
                            bl = false;
                            this.reportBug("member missing: " + entry.getKey() + " @" + context.getId());
                            break block10;
                        }
                        ++n3;
                    }
                }
                if (bl) continue;
                String string = context.getId();
                for (Object object3 : this.xbrlInstance.getAllFacts(true).values()) {
                    Iterator iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        Fact fact = (Fact)iterator.next();
                        if (!string.equals(fact.getContextRef())) continue;
                        fact.getParent().removeChild((XdmNode)fact);
                        this.fixBug("remove fact: " + fact + ", error context.");
                    }
                }
                context.getParent().removeChild((XdmNode)context);
                this.fixBug("remove context: " + string + ", missing axis or member.");
            }
        }
        if (this.getOptions().isRemoveUnusedContexts() && this.xbrlInstance != null) {
            List list = XbrlHelper.removeUnusedContexts((XbrlInstance)this.xbrlInstance);
            if (list != null && list.size() > 0) {
                this._hasBugFixed = true;
            }
            if ((entry22 = XbrlHelper.removeUnusedUnits((XbrlInstance)this.xbrlInstance)) != null && entry22.size() > 0) {
                this._hasBugFixed = true;
            }
        }
        this.bugFixRemoveDuplicateFacts();
    }

    private void Y() {
        if (this.xbrlInstance == null) {
            return;
        }
        if (this.f == null) {
            this.f = this.xbrlInstance.getFacts(true);
        }
        b b2 = null;
        for (Map.Entry<QName, List<Fact>> entry : this.f.entrySet()) {
            XbrlConcept xbrlConcept = this.dts.getConcept(entry.getKey());
            if (xbrlConcept == null) continue;
            boolean bl = xbrlConcept.getPeriodType() == PeriodType.Duration;
            for (Fact fact : entry.getValue()) {
                String string;
                boolean bl2;
                Context context = fact.getContext();
                boolean bl3 = bl2 = context.getPeriodType() == PeriodType.Duration;
                if (bl2 == bl) continue;
                if (b2 == null) {
                    b2 = new b();
                }
                if (bl2 && xbrlConcept.getPeriodType() == PeriodType.Instant) {
                    string = b2.a(context);
                    if (StringUtils.isEmpty((String)string)) continue;
                    fact.setContextRef(string);
                    this.fixBug("change contextRef " + fact.toString());
                    continue;
                }
                if (bl2 || xbrlConcept.getPeriodType() != PeriodType.Duration || StringUtils.isEmpty((String)(string = b2.b(context)))) continue;
                fact.setContextRef(string);
                this.fixBug("change contextRef " + fact.toString());
            }
        }
    }

    public void setOptions(CleanOption option) {
        this.A = option;
    }

    public CleanOption getOptions() {
        if (this.A == null) {
            this.A = new CleanOption();
        }
        return this.A;
    }

    private void Z() {
        IXbrlDocument[] iXbrlDocumentArray;
        if (this.getExtendMode().isReuseMode()) {
            this.aa();
            return;
        }
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                Map<String, RoleRef> map = this.b(linkbase);
                HashSet<String> hashSet = new HashSet<String>();
                boolean bl = false;
                for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                    Object object;
                    Iterator iterator;
                    Object object2;
                    Object object3;
                    Object object42;
                    QName qName = extendedLink.getNodeName();
                    if (!qName.equals(QNameConstants.definitionLink) && !qName.equals(QNameConstants.presentationLink)) continue;
                    bl = true;
                    ArrayList arrayList = extendedLink.getRelationships();
                    if (arrayList == null || arrayList.size() == 0) {
                        if (extendedLink.elements().length != 0 || extendedLink.getParent() == null) continue;
                        extendedLink.getParent().removeChild((XdmNode)extendedLink);
                        continue;
                    }
                    arrayList = new ArrayList(arrayList);
                    String string = extendedLink.getRole();
                    if (!"http://www.xbrl.org/2003/role/link".equals(string)) {
                        this.a(extendedLink, map);
                    }
                    HashSet<Object> hashSet2 = new HashSet<Object>();
                    for (Object object42 : arrayList) {
                        if (object42.isRemoved()) continue;
                        object3 = object42.fromConcept();
                        if (object3 != null) {
                            hashSet2.add(object3);
                        }
                        if ((object2 = object42.toConcept()) != null) {
                            hashSet2.add(object2);
                            continue;
                        }
                        if (!(object42.toTarget() instanceof Resource) || (iterator = (object = (Resource)object42.toTarget()).getRole()) == null) continue;
                        hashSet.add((String)((Object)iterator));
                    }
                    if (this.byInstance) {
                        object42 = this.dts.getRelationshipSet(qName, extendedLink.getRole());
                        if (object42 == null) {
                            System.out.println("NULL = " + extendedLink.getRole());
                            continue;
                        }
                        boolean bl2 = true;
                        object2 = object42.getRelationships().iterator();
                        while (object2.hasNext()) {
                            object3 = (Relationship)object2.next();
                            object = object3.fromConcept();
                            if (object != null && this.f.containsKey(object.getQName())) {
                                bl2 = false;
                                break;
                            }
                            object = object3.toConcept();
                            if (object == null || !this.f.containsKey(object.getQName())) continue;
                            bl2 = false;
                            break;
                        }
                        if (!bl2) continue;
                        object3 = new HashSet();
                        object42.getAllTargets((Set)object3);
                        object42.purgeOrProhibitTarget(object3);
                        continue;
                    }
                    if (!qName.equals(QNameConstants.definitionLink)) continue;
                    object42 = this.f(extendedLink.getRole());
                    RelationshipSet relationshipSet = this.dts.getRelationshipSet((QName)QNameConstants.definitionLink, extendedLink.getRole());
                    if (relationshipSet == null) continue;
                    boolean bl3 = true;
                    object = relationshipSet.getRelationships().iterator();
                    block4: while (object.hasNext()) {
                        object2 = (Relationship)object.next();
                        iterator = object2.fromTarget();
                        Object object5 = object2.toTarget();
                        Iterator iterator2 = object42.iterator();
                        while (iterator2.hasNext()) {
                            RelationshipSet relationshipSet2 = (RelationshipSet)iterator2.next();
                            if (!relationshipSet2.contains(iterator) && !relationshipSet2.contains(object5)) continue;
                            bl3 = false;
                            break block4;
                        }
                    }
                    if (!bl3) continue;
                    object2 = new HashSet();
                    relationshipSet.getAllTargets((Set)object2);
                    relationshipSet.purgeOrProhibitTarget(object2);
                    iterator = ((HashSet)object2).iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        this.fixBug("remove " + object + " @" + relationshipSet);
                    }
                }
                if (bl) {
                    this.removeUnusedRoleRef(linkbase, hashSet);
                }
            }
            ++n2;
        }
    }

    private void aa() {
        IXbrlDocument[] iXbrlDocumentArray;
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                Map<String, RoleRef> map = this.b(linkbase);
                HashSet<String> hashSet = new HashSet<String>();
                boolean bl = false;
                for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                    Object object;
                    HashSet hashSet22;
                    Object object22;
                    QName qName = extendedLink.getNodeName();
                    if (!qName.equals(QNameConstants.definitionLink) && !qName.equals(QNameConstants.presentationLink)) continue;
                    bl = true;
                    ArrayList arrayList = extendedLink.getRelationships();
                    if (arrayList == null || arrayList.size() == 0) {
                        if (extendedLink.elements().length != 0 || extendedLink.getParent() == null) continue;
                        extendedLink.getParent().removeChild((XdmNode)extendedLink);
                        continue;
                    }
                    arrayList = new ArrayList(arrayList);
                    String string = extendedLink.getRole();
                    if (!"http://www.xbrl.org/2003/role/link".equals(string)) {
                        this.a(extendedLink, map);
                    }
                    for (Object object22 : arrayList) {
                        Resource resource;
                        if (object22.isRemoved() || !(object22.toTarget() instanceof Resource) || (hashSet22 = (resource = (Resource)object22.toTarget()).getRole()) == null) continue;
                        hashSet.add((String)((Object)hashSet22));
                    }
                    if (this.byInstance) {
                        object22 = this.dts.getRelationshipSet(qName, extendedLink.getRole());
                        if (object22 == null) continue;
                        boolean bl2 = true;
                        boolean bl3 = false;
                        block3: for (HashSet hashSet22 : object22.getFromTargets()) {
                            Object object3 = object = hashSet22 instanceof XbrlConcept ? (XbrlConcept)hashSet22 : null;
                            if (object != null && this.f.containsKey(object.getQName())) {
                                bl2 = false;
                            }
                            for (Object object4 : object22.getChildren((Object)hashSet22)) {
                                if (!object4.isOptional()) continue;
                                if (!bl3) {
                                    bl3 = true;
                                }
                                if ((object = object4.toConcept()) == null || !this.f.containsKey(object.getQName())) continue;
                                bl2 = false;
                                break block3;
                            }
                        }
                        if (!bl2 || !bl3) continue;
                        hashSet22 = new HashSet();
                        object22.getAllTargets((Set)hashSet22);
                        object22.purgeOrProhibitTargets(hashSet22);
                        continue;
                    }
                    if (!qName.equals(QNameConstants.definitionLink)) continue;
                    object22 = this.f(extendedLink.getRole());
                    RelationshipSet relationshipSet = this.dts.getRelationshipSet((QName)QNameConstants.definitionLink, extendedLink.getRole());
                    if (relationshipSet == null) continue;
                    boolean bl4 = true;
                    block5: for (HashSet hashSet22 : relationshipSet.getRelationships()) {
                        Object object4;
                        object = hashSet22.fromTarget();
                        object4 = hashSet22.toTarget();
                        Iterator iterator = object22.iterator();
                        while (iterator.hasNext()) {
                            RelationshipSet relationshipSet2 = (RelationshipSet)iterator.next();
                            if (!relationshipSet2.contains(object) && !relationshipSet2.contains(object4)) continue;
                            bl4 = false;
                            break block5;
                        }
                    }
                    if (!bl4) continue;
                    hashSet22 = new HashSet();
                    relationshipSet.getAllTargets(hashSet22);
                    relationshipSet.purgeOrProhibitTarget(hashSet22);
                    object = hashSet22.iterator();
                    while (object.hasNext()) {
                        Iterator iterator = object.next();
                        this.fixBug("remove " + iterator + " @" + relationshipSet);
                    }
                }
                if (bl) {
                    this.removeUnusedRoleRef(linkbase, hashSet);
                }
            }
            ++n2;
        }
    }

    private void ab() {
        XbrlSchema[] xbrlSchemaArray;
        XbrlSchema[] xbrlSchemaArray2 = xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray2[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                ArrayList<XbrlConcept> arrayList = new ArrayList<XbrlConcept>();
                Map map = xbrlSchema.getElements();
                if (map != null && !map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        XbrlConcept xbrlConcept;
                        QName qName = (QName)entry.getKey();
                        XbrlConcept xbrlConcept2 = xbrlConcept = entry.getValue() instanceof XbrlConcept ? (XbrlConcept)entry.getValue() : null;
                        if (xbrlConcept == null || this.c.contains(qName) || this.a(xbrlConcept, this.j) || this.a(xbrlConcept, this.l)) continue;
                        arrayList.add(xbrlConcept);
                    }
                }
                for (XbrlConcept xbrlConcept : arrayList) {
                    if (!xbrlSchema.removeConcept(this.dts, xbrlConcept, true)) continue;
                    this.fixBug("remove concept: " + xbrlConcept + " not used.", true);
                }
            }
            ++n2;
        }
    }

    private void ac() {
        XbrlSchema[] xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                for (LinkbaseRef linkbaseRef : xbrlSchema.getLinkbaseRefs()) {
                    IXbrlDocument iXbrlDocument = this.dts.getDocument(linkbaseRef.getDiscoveredUri(null));
                    if (!this.a(iXbrlDocument)) continue;
                    xbrlSchema.removeLinkbaseRef(linkbaseRef);
                }
            }
            ++n2;
        }
    }

    private void ad() {
        try {
            XbrlSchema[] xbrlSchemaArray = this.getEntrySchema();
            int n = xbrlSchemaArray.length;
            int n2 = 0;
            while (n2 < n) {
                XbrlSchema xbrlSchema = xbrlSchemaArray[n2];
                if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                    for (LinkbaseRef linkbaseRef : xbrlSchema.getLinkbaseRefs()) {
                        IXbrlDocument iXbrlDocument = this.dts.getDocument(linkbaseRef.getDiscoveredUri(null));
                        if (iXbrlDocument != null && !iXbrlDocument.getContentType().contains(XbrlContentType.FileNotFound)) continue;
                        this._hasBugFixed = true;
                        xbrlSchema.removeLinkbaseRef(linkbaseRef);
                        xbrlSchema.setModified(true);
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)("removeNotFoundLinkbaseRef: " + exception.getMessage()));
        }
    }

    private void ae() {
        try {
            IXbrlDocument[] iXbrlDocumentArray = this.dts.getDocuments();
            int n = iXbrlDocumentArray.length;
            int n2 = 0;
            while (n2 < n) {
                XbrlDocument xbrlDocument;
                IXbrlDocument iXbrlDocument = iXbrlDocumentArray[n2];
                if (iXbrlDocument != null && !iXbrlDocument.isReadOnly() && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                    RoleType[] roleTypeArray;
                    String string;
                    String string2;
                    int n3;
                    IXbrlDocument iXbrlDocument2;
                    URI uRI;
                    Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                    for (RoleRef roleRef : linkbase.getRoleRefs()) {
                        uRI = roleRef.getDiscoveredUri(null);
                        iXbrlDocument2 = this.dts.getDocument(uRI);
                        if (iXbrlDocument2 != null && !iXbrlDocument2.getContentType().contains(XbrlContentType.FileNotFound)) continue;
                        if (uRI != null && (n3 = (string2 = uRI.toString()).indexOf("#")) != -1) {
                            string = string2.substring(n3 + 1);
                            roleTypeArray = this.dts.getRoleTypes().getRoleTypeById(string);
                            if (roleTypeArray.length == 1) {
                                roleRef.setRoleType(roleTypeArray[0]);
                                continue;
                            }
                            if (roleTypeArray.length > 1) {
                                LogWatch.warn((Object)"More RoleType with same roleURI. @removeNotFoundRoleRef");
                            }
                        }
                        this._hasBugFixed = true;
                        linkbase.removeChild((XdmNode)roleRef);
                        linkbase.getOwnerDocument().setModified(true);
                    }
                    for (RoleRef roleRef : linkbase.getArcroleRefs()) {
                        uRI = roleRef.getDiscoveredUri(null);
                        iXbrlDocument2 = this.dts.getDocument(uRI);
                        if (iXbrlDocument2 != null && !iXbrlDocument2.getContentType().contains(XbrlContentType.FileNotFound)) continue;
                        if (uRI != null && (n3 = (string2 = uRI.toString()).indexOf("#")) != -1) {
                            string = string2.substring(n3 + 1);
                            roleTypeArray = this.dts.getArcroleTypes().getArcroleTypeById(string);
                            if (roleTypeArray.length == 1) {
                                roleRef.setArcroleType((ArcroleType)roleTypeArray[0]);
                                continue;
                            }
                            if (roleTypeArray.length > 1) {
                                LogWatch.warn((Object)"More ArcroleType with same arcroleURI. @removeNotFoundRoleRef");
                            }
                        }
                        this._hasBugFixed = true;
                        linkbase.removeChild((XdmNode)roleRef);
                        linkbase.getOwnerDocument().setModified(true);
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)("removeNotFoundRoleRef: " + exception.getMessage()));
        }
    }

    private boolean a(IXbrlDocument iXbrlDocument) {
        XbrlDocument xbrlDocument;
        if (iXbrlDocument != null && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
            return ((Linkbase)xbrlDocument.getDocumentElement()).isEmpty();
        }
        return false;
    }

    private void af() {
        XbrlSchema[] xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                ArrayList arrayList = new ArrayList(xbrlSchema.getExternals());
                for (XmlSchemaExternal xmlSchemaExternal : arrayList) {
                    String string;
                    XbrlSchema xbrlSchema2;
                    if (!(xmlSchemaExternal instanceof XmlSchemaImport)) continue;
                    XmlSchemaImport xmlSchemaImport = (XmlSchemaImport)xmlSchemaExternal;
                    XmlSchema xmlSchema = xmlSchemaImport.getSchema();
                    if (xmlSchema == null && (xbrlSchema2 = this.dts.getSchemas(xmlSchemaImport.getNamespace())) != null && ((XbrlSchema)xbrlSchema2).length > 0) {
                        xmlSchema = xbrlSchema2[0];
                    }
                    if (xmlSchema == null || !(xmlSchema instanceof XbrlSchema) || !(xbrlSchema2 = (XbrlSchema)xmlSchema).isReadOnly() || !xbrlSchema2.getElements().isEmpty() || !xbrlSchema2.getAttributes().isEmpty() || !xbrlSchema2.getArcroleTypes().isEmpty() || xbrlSchema2.getRoleTypes().isEmpty() || StringUtils.isEmpty((String)(string = xbrlSchema2.getTargetNamespace()))) continue;
                    NamespacePrefixList namespacePrefixList = xbrlSchema.getNamespaceContext();
                    Iterator iterator = namespacePrefixList.getPrefixes(string);
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        namespacePrefixList.remove(string2, string);
                    }
                }
            }
            ++n2;
        }
    }

    private void ag() {
        XbrlSchema[] xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                ArrayList arrayList = new ArrayList(xbrlSchema.getExternals());
                for (XmlSchemaExternal xmlSchemaExternal : arrayList) {
                    XbrlSchema xbrlSchema2;
                    if (!(xmlSchemaExternal instanceof XmlSchemaImport)) continue;
                    XmlSchemaImport xmlSchemaImport = (XmlSchemaImport)xmlSchemaExternal;
                    XmlSchema xmlSchema = xmlSchemaImport.getSchema();
                    if (xmlSchema == null && (xbrlSchema2 = this.dts.getSchemas(xmlSchemaImport.getNamespace())) != null && ((XbrlSchema)xbrlSchema2).length > 0) {
                        xmlSchema = xbrlSchema2[0];
                    }
                    if (xmlSchema == null || !(xmlSchema instanceof XbrlSchema)) continue;
                    xbrlSchema2 = (XbrlSchema)xmlSchema;
                    this.a(xbrlSchema2, (XmlSchema)xbrlSchema, xmlSchemaImport);
                }
            }
            ++n2;
        }
    }

    private void a(XbrlSchema xbrlSchema, XmlSchema xmlSchema, XmlSchemaImport xmlSchemaImport) {
        if (xbrlSchema.isReadOnly() && xbrlSchema.getElements().isEmpty() && xbrlSchema.getArcroleTypes().isEmpty() && !xbrlSchema.getRoleTypes().isEmpty()) {
            boolean bl = false;
            block0: for (Object object : xbrlSchema.getRoleTypes()) {
                for (Iterator iterator : this.dts.getRelationshipSets(object.getRoleURI())) {
                    if (iterator.getRelationships().size() == 0) continue;
                    bl = true;
                    break block0;
                }
            }
            if (!bl) {
                boolean bl2;
                Object object;
                object = xbrlSchema.getTargetNamespace();
                if (!StringUtils.isEmpty((String)object)) {
                    Iterator iterator;
                    Iterator iterator2 = xmlSchema.getNamespaceContext();
                    iterator = iterator2.getPrefixes((String)object);
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        iterator2.remove(string, (String)object);
                    }
                }
                if (bl2 = this.a(xbrlSchema, (XbrlSchema)xmlSchema)) {
                    xmlSchema.removeItem((XmlSchemaObject)xmlSchemaImport);
                    for (Iterator iterator : xbrlSchema.getRoleTypes()) {
                        this.dts.getRoleTypes().remove((Object)iterator);
                        this.p.add(iterator.getRoleURI());
                    }
                }
            }
        }
    }

    private boolean a(XbrlSchema xbrlSchema, XbrlSchema xbrlSchema2) {
        Object object2;
        ArrayList<Object> arrayList = null;
        for (Object object2 : this.dts.getRelationshipSets((QName)QNameConstants.genericLink)) {
            for (RoleType roleType : xbrlSchema.getRoleTypes()) {
                for (Relationship relationship3 : object2.getEffectiveChildren((Object)roleType)) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                    }
                    if (relationship3.isSingle()) {
                        arrayList.add(relationship3);
                        continue;
                    }
                    Relationship[] relationshipArray = relationship3.toArray();
                    int n = relationshipArray.length;
                    int relationship4 = 0;
                    while (relationship4 < n) {
                        Relationship relationship2 = relationshipArray[relationship4];
                        arrayList.add(relationship2);
                        ++relationship4;
                    }
                }
            }
        }
        if (arrayList == null || arrayList.size() == 0) {
            return true;
        }
        object2 = new ArrayList();
        for (Relationship relationship : arrayList) {
            Relationship relationship3;
            Iterator iterator = relationship.arc().getOwnerDocument();
            if (object2.contains(iterator) || !iterator.isReadOnly()) continue;
            Linkbase linkbase = relationship3 = iterator.getDocumentElement() instanceof Linkbase ? (Linkbase)iterator.getDocumentElement() : null;
            if (relationship3 == null) continue;
            for (ExtendedLink extendedLink : relationship3.getExtendedLinks()) {
                for (Relationship relationship4 : extendedLink.getRelationships()) {
                    if (arrayList.contains(relationship4)) continue;
                    return false;
                }
            }
            for (ExtendedLink extendedLink : xbrlSchema2.getLinkbaseRefs()) {
                URI uRI = extendedLink.getDiscoveredUri(null);
                if (iterator != this.dts.getDocument(uRI)) continue;
                xbrlSchema2.removeLinkbaseRef((LinkbaseRef)extendedLink);
            }
            object2.add(iterator);
        }
        return true;
    }

    @Override
    public boolean clean(boolean removeRelationship, boolean buildAllDomainMember) {
        this._targetAction = Cleaner.TargetAction.Clean;
        try {
            this.b(removeRelationship, buildAllDomainMember);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this._hasBugFixed;
    }

    private void ah() {
        RelationshipSet relationshipSet2;
        HashSet hashSet = new HashSet();
        for (RelationshipSet relationshipSet2 : this.j) {
            relationshipSet2.getAllTargets(hashSet);
        }
        for (RelationshipSet relationshipSet2 : this.l) {
            relationshipSet2.getAllTargets(hashSet);
        }
        for (RelationshipSet relationshipSet2 : this.dts.getLabelRelationships()) {
            for (Object e2 : relationshipSet2.getRootNodes()) {
                if (e2 instanceof XbrlConcept) {
                    if (hashSet.contains(e2)) continue;
                    relationshipSet2.purgeOrProhibitTarget(e2);
                    continue;
                }
                boolean cfr_ignored_0 = e2 instanceof Loc;
            }
        }
        for (RelationshipSet relationshipSet2 : this.dts.getReferenceRelationships()) {
            for (Object e2 : relationshipSet2.getRootNodes()) {
                if (!(e2 instanceof XbrlConcept) || hashSet.contains(e2)) continue;
                relationshipSet2.purgeOrProhibitTarget(e2);
            }
        }
        RelationshipSet relationshipSet3 = relationshipSet2 = this.dts.getDocuments();
        int n = ((RelationshipSet)relationshipSet3).length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            Iterator<Object> iterator = relationshipSet3[n2];
            if (!iterator.isReadOnly() && iterator.getContentType().contains(XbrlContentType.Linkbase) && iterator instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iterator).getDocumentElement() instanceof Linkbase) {
                for (ExtendedLink extendedLink : ((Linkbase)xbrlDocument.getDocumentElement()).getExtendedLinks()) {
                    this.b(extendedLink);
                }
            }
            ++n2;
        }
    }

    private void a(TaxonomySet taxonomySet, XbrlSchema xbrlSchema, Map<QName, XbrlConcept> map, Map<QName, List<QName>> map2, Collection<QName> collection) {
        if (map == null) {
            return;
        }
        for (Map.Entry<QName, XbrlConcept> entry : map.entrySet()) {
            boolean bl = false;
            block1: for (QName qName : map2.get(entry.getKey())) {
                for (XdtDRS xdtDRS : taxonomySet.getAllDRS().values()) {
                    if (!xdtDRS.containsDimension(qName)) continue;
                    for (XbrlConcept xbrlConcept : xdtDRS.getAllPrimaryItems()) {
                        XdtCompiledHypercube[] xdtCompiledHypercubeArray = xdtDRS.tryGetHypercubes(xbrlConcept);
                        if (xdtCompiledHypercubeArray == null) continue;
                        boolean bl2 = false;
                        XdtCompiledHypercube[] xdtCompiledHypercubeArray2 = xdtCompiledHypercubeArray;
                        int n = xdtCompiledHypercubeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            XdtCompiledHypercube xdtCompiledHypercube = xdtCompiledHypercubeArray2[n2];
                            if (xdtCompiledHypercube.containsDimension(qName)) {
                                bl2 = true;
                                break;
                            }
                            ++n2;
                        }
                        if (!bl2 || !collection.contains(xbrlConcept.getQName())) continue;
                        bl = true;
                        break block1;
                    }
                }
            }
            if (bl) continue;
            xbrlSchema.removeConcept(taxonomySet, entry.getValue(), true);
        }
    }

    private Map<String, RoleRef> b(Linkbase linkbase) {
        HashMap<String, RoleRef> hashMap = new HashMap<String, RoleRef>();
        for (RoleRef roleRef : linkbase.getRoleRefs()) {
            hashMap.put(roleRef.getRoleURI(), roleRef);
        }
        return hashMap;
    }

    private void ai() {
        IXbrlDocument[] iXbrlDocumentArray;
        if (this.getExtendMode().isReuseMode()) {
            this.aj();
            return;
        }
        if (this.xbrlInstance == null) {
            return;
        }
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                Map<String, RoleRef> map = this.b(linkbase);
                HashSet<String> hashSet = new HashSet<String>();
                for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                    QName qName = extendedLink.getNodeName();
                    boolean bl = qName.equals(QNameConstants.definitionLink);
                    ArrayList arrayList = extendedLink.getRelationships();
                    if (arrayList == null) {
                        if (extendedLink.elements().length != 0 || extendedLink.getParent() == null) continue;
                        extendedLink.getParent().removeChild((XdmNode)extendedLink);
                        continue;
                    }
                    arrayList = new ArrayList(arrayList);
                    String string = extendedLink.getRole();
                    if (!"http://www.xbrl.org/2003/role/link".equals(string)) {
                        this.a(extendedLink, map);
                    }
                    HashSet<XbrlConcept> hashSet2 = new HashSet<XbrlConcept>();
                    for (Relationship relationship : arrayList) {
                        Resource resource;
                        String string2;
                        XbrlConcept xbrlConcept;
                        if (relationship.isRemoved() || bl && "http://xbrl.org/int/dim/arcrole/dimension-default".equals(relationship.arcrole())) continue;
                        XbrlConcept xbrlConcept2 = relationship.fromConcept();
                        if (xbrlConcept2 != null) {
                            hashSet2.add(xbrlConcept2);
                        }
                        if ((xbrlConcept = relationship.toConcept()) != null) {
                            hashSet2.add(xbrlConcept);
                            continue;
                        }
                        if (!(relationship.toTarget() instanceof Resource) || (string2 = (resource = (Resource)relationship.toTarget()).getRole()) == null) continue;
                        hashSet.add(string2);
                    }
                    if (this.byInstance) {
                        if (qName.equals(QNameConstants.presentationLink)) {
                            this.a(hashSet2, this.dts.getRelationshipSet(qName, extendedLink.getRole()));
                        } else if (qName.equals(QNameConstants.calculationLink)) {
                            this.j(this.dts.getRelationshipSet(qName, extendedLink.getRole()));
                        }
                    }
                    this.b(extendedLink);
                }
                this.removeUnusedRoleRef(linkbase, hashSet);
            }
            ++n2;
        }
    }

    private void aj() {
        Object object;
        Object object2;
        Object object3;
        IXbrlDocument[] iXbrlDocumentArray;
        if (this.xbrlInstance == null) {
            return;
        }
        Object object4 = iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            object3 = object4[n2];
            if (!object3.isReadOnly() && object3.getContentType().contains(XbrlContentType.Linkbase) && object3 instanceof XbrlDocument && (object2 = (XbrlDocument)object3).getDocumentElement() instanceof Linkbase) {
                object = object2.getDocumentElement();
                Relationship relationship = this.b((Linkbase)object);
                HashSet hashSet = new HashSet();
                for (ExtendedLink extendedLink : object.getExtendedLinks()) {
                    List list = extendedLink.getRelationships();
                    if (list == null || list.size() == 0) {
                        if (extendedLink.elements().length != 0 || extendedLink.getParent() == null) continue;
                        extendedLink.getParent().removeChild((XdmNode)extendedLink);
                        continue;
                    }
                    String string = extendedLink.getRole();
                    if (!"http://www.xbrl.org/2003/role/link".equals(string)) {
                        this.a(extendedLink, (Map<String, RoleRef>)relationship);
                    }
                    this.b(extendedLink);
                }
                this.removeUnusedRoleRef((Linkbase)object, hashSet);
            }
            ++n2;
        }
        if (this.byInstance) {
            object3 = new HashSet();
            for (RelationshipSet relationshipSet : this.dts.getPresentationRelationships()) {
                ((HashSet)object3).clear();
                object2 = relationshipSet.getFromTargets().iterator();
                while (object2.hasNext()) {
                    object = object4 = object2.next();
                    for (Relationship relationship : relationshipSet.getChildren(object4)) {
                        ExtendedLink extendedLink;
                        if (!relationship.isOptional()) continue;
                        extendedLink = relationship.toConcept();
                        if (extendedLink != null) {
                            ((HashSet)object3).add(extendedLink);
                        }
                        if (object == null || !(object instanceof XbrlConcept)) continue;
                        ((HashSet)object3).add((XbrlConcept)object);
                        object = null;
                    }
                }
                this.a((Collection<XbrlConcept>)object3, relationshipSet);
            }
            for (RelationshipSet relationshipSet : this.dts.getCalculationRelationships()) {
                this.j(relationshipSet);
            }
        }
    }

    private void b(ExtendedLink extendedLink) {
        block8: {
            QName qName = extendedLink.getNodeName();
            if (!qName.equals(QNameConstants.calculationLink) && !qName.equals(QNameConstants.presentationLink) && !qName.equals(QNameConstants.definitionLink) && !qName.equals(QNameConstants.labelLink) && !qName.equals(QNameConstants.referenceLink)) break block8;
            List list = extendedLink.getRelationships();
            if (list.size() == 0) {
                XdmNode xdmNode = extendedLink.getFirstChild();
                while (xdmNode != null) {
                    if (xdmNode.getNodeNature() == 2) {
                        extendedLink.removeChild(xdmNode);
                    }
                    xdmNode = xdmNode.getNextSibling();
                }
            } else {
                XdmNode xdmNode;
                HashSet<String> hashSet = new HashSet<String>();
                XdmNode xdmNode2 = extendedLink.getFirstChild();
                while (xdmNode2 != null) {
                    if (xdmNode2.getNodeNature() == 2 && xdmNode2 instanceof Arc) {
                        xdmNode = (Arc)xdmNode2;
                        hashSet.add(xdmNode.getFrom());
                        hashSet.add(xdmNode.getTo());
                    }
                    xdmNode2 = xdmNode2.getNextSibling();
                }
                xdmNode2 = extendedLink.getFirstChild();
                while (xdmNode2 != null) {
                    Loc loc;
                    String string;
                    xdmNode = xdmNode2.getNextSibling();
                    if (xdmNode2.getNodeNature() == 2 && xdmNode2 instanceof Loc && !hashSet.contains(string = (loc = (Loc)xdmNode2).getLabel())) {
                        extendedLink.removeChild(xdmNode2);
                        extendedLink.getOwnerDocument().setModified(true);
                        LogWatch.warn((Object)("Remove orphan: " + extendedLink.getNodeName().getLocalPart() + " xlink:label=" + string));
                    }
                    xdmNode2 = xdmNode;
                }
            }
        }
    }

    private void ak() {
        Map<String, RoleRef> map = null;
        this.l = this.dts.getDefinitionRelationships();
        for (RelationshipSet relationshipSet : this.l) {
            char c2;
            String string;
            int n;
            RoleType[] roleTypeArray;
            String string2 = relationshipSet.getRoleURI();
            if ("http://www.xbrl.org/2003/role/link".equals(string2) || (roleTypeArray = this.dts.getRoleTypes().get(string2)) != null && roleTypeArray.length != 0 || (n = string2.lastIndexOf("/")) == -1 || (string = string2.substring(n + 1)).length() != 7 || (c2 = string.charAt(string.length() - 1)) < 'a' || c2 > 'z') continue;
            String string3 = string2.substring(0, string2.length() - 1);
            RoleType[] roleTypeArray2 = this.dts.getRoleTypes().get(string3);
            if (roleTypeArray2 == null || roleTypeArray2.length == 0) continue;
            if (map == null) {
                map = this.al();
            }
            String string4 = roleTypeArray2[0].getDefinitionText();
            String string5 = this.a(string2, map);
            if (string5 == null) continue;
            int n2 = string4.indexOf("]");
            if (n2 != -1) {
                string4 = string4.substring(n2 + 1).trim();
            }
            if (this.createRoleType(string2, string5, string4) == null) continue;
            this._hasBugFixed = true;
            this.fixBug("create roleType = " + string2);
        }
    }

    private String a(String string, Map<String, RoleRef> map) {
        String string2;
        int n;
        RoleRef roleRef = map.get(string);
        if (roleRef != null && (n = (string2 = roleRef.getHref()).lastIndexOf(35)) != -1) {
            return string2.substring(n + 1);
        }
        return null;
    }

    private Map<String, RoleRef> al() {
        IXbrlDocument[] iXbrlDocumentArray;
        HashMap<String, RoleRef> hashMap = new HashMap<String, RoleRef>();
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                hashMap.putAll(this.b(linkbase));
            }
            ++n2;
        }
        return hashMap;
    }

    private void d(XbrlConcept xbrlConcept) {
        int n;
        String string;
        if (xbrlConcept == null) {
            return;
        }
        String string2 = xbrlConcept.getName();
        String string3 = xbrlConcept.getPrefixedName();
        QName qName = xbrlConcept.getSchemaTypeName();
        for (Label label : xbrlConcept.getLabels(this.dts)) {
            if (!label.getLang().startsWith("en") || (string = label.getInnerText()).length() <= 0 || Character.isUpperCase(string.charAt(0))) continue;
            string = String.valueOf(Character.toUpperCase(string.charAt(0))) + string.substring(1);
            label.setInnerText(string);
            label.getOwnerDocument().setModified(true);
            this.fixBug(String.valueOf(string3) + " upper label = " + string);
        }
        if (string2.endsWith("Abstract")) {
            if (!xbrlConcept.isAbstract() && !this.f.containsKey(xbrlConcept.getQName())) {
                xbrlConcept.setAbstract(true);
                this.e(xbrlConcept);
                this.fixBug(String.valueOf(string3) + ".setAbstract(true)");
            }
            for (Label label : xbrlConcept.getLabels(this.dts)) {
                string = label.getInnerText();
                if (!string.endsWith(" [abstract]")) {
                    n = string.lastIndexOf(91);
                    if (n != -1) {
                        string = String.valueOf(string.substring(0, n).trim()) + " [abstract]";
                        label.setInnerText(string);
                        label.getOwnerDocument().setModified(true);
                        this.fixBug(String.valueOf(string3) + ".setLabel() " + label.getInnerText());
                    } else {
                        string = String.valueOf(string.trim()) + " [abstract]";
                        label.setInnerText(string);
                        label.getOwnerDocument().setModified(true);
                        this.fixBug(String.valueOf(string3) + ".setLabel() " + label.getInnerText());
                    }
                }
                if ((n = string.lastIndexOf("\u8be6\u7ec6\u62ab\u9732")) <= 0) continue;
                boolean bl = false;
                char c2 = string.charAt(n - 1);
                char c3 = string.charAt(n + 4);
                if (c2 != '(' && c2 != '\uff08' && c3 != ')' && c3 != '\uff09') {
                    string = String.valueOf(string.substring(0, n)) + "\uff08\u8be6\u7ec6\u62ab\u9732\uff09" + string.substring(n + 4);
                    bl = true;
                }
                if (string.contains(" \uff08\u8be6\u7ec6\u62ab\u9732\uff09")) {
                    string = string.replace(" \uff08\u8be6\u7ec6\u62ab\u9732\uff09", "\uff08\u8be6\u7ec6\u62ab\u9732\uff09");
                    bl = true;
                }
                if (!bl) continue;
                label.setInnerText(string);
                label.getOwnerDocument().setModified(true);
            }
        } else if (string2.endsWith("LineItems") || string2.endsWith("LineItem")) {
            if (!xbrlConcept.isAbstract() && !this.f.containsKey(xbrlConcept.getQName())) {
                xbrlConcept.setAbstract(true);
                this.e(xbrlConcept);
                this.fixBug(String.valueOf(string3) + ".setAbstract(true)");
            }
            if (!(xbrlConcept.getPeriodType() == PeriodType.Duration || this.byInstance && this.c.contains(xbrlConcept.getQName()))) {
                xbrlConcept.setPeriodType(PeriodType.Duration);
                this.e(xbrlConcept);
                this.fixBug(String.valueOf(string3) + " periodType = duration");
            }
            for (Label label : xbrlConcept.getLabels(this.dts)) {
                string = label.getInnerText();
                if (string.endsWith(" [line items]")) continue;
                n = string.lastIndexOf(91);
                if (n != -1) {
                    string = String.valueOf(string.substring(0, n).trim()) + " [line items]";
                    label.setInnerText(string);
                    label.getOwnerDocument().setModified(true);
                    this.fixBug(String.valueOf(string3) + ".setLabel() " + label.getInnerText());
                    continue;
                }
                string = String.valueOf(string.trim()) + " [line items]";
                label.setInnerText(string);
                label.getOwnerDocument().setModified(true);
                this.fixBug(String.valueOf(string3) + ".setLabel() " + label.getInnerText());
            }
        }
        if (QNameConstants.nonnumDomainItemType.equals((Object)qName)) {
            if (!xbrlConcept.isAbstract() && !this.f.containsKey(xbrlConcept.getQName())) {
                xbrlConcept.setAbstract(true);
                this.e(xbrlConcept);
                this.fixBug(String.valueOf(string3) + ".setAbstract(true)");
            }
            for (Label label : xbrlConcept.getLabels(this.dts)) {
                string = label.getInnerText();
                if (string.endsWith(" [member]")) continue;
                n = string.lastIndexOf(91);
                if (n != -1) {
                    string = String.valueOf(string.substring(0, n).trim()) + " [member]";
                    label.setInnerText(string);
                    label.getOwnerDocument().setModified(true);
                    this.fixBug(String.valueOf(string3) + ".setLabel() " + label.getInnerText());
                    continue;
                }
                string = String.valueOf(string.trim()) + " [member]";
                label.setInnerText(string);
                label.getOwnerDocument().setModified(true);
                this.fixBug(String.valueOf(string3) + ".setLabel() " + label.getInnerText());
            }
        } else if (QNameConstants.nonnumEscapedItemType.equals((Object)qName) || QNameConstants.nonnumTextBlockItemType.equals((Object)qName)) {
            for (Label label : xbrlConcept.getLabels(this.dts)) {
                string = label.getInnerText();
                if (string.endsWith(" [text block]")) continue;
                n = string.lastIndexOf(91);
                if (n != -1) {
                    string = String.valueOf(string.substring(0, n).trim()) + " [text block]";
                    label.setInnerText(string);
                    label.getOwnerDocument().setModified(true);
                    this.fixBug(String.valueOf(string3) + ".setLabel() " + label.getInnerText());
                    continue;
                }
                string = String.valueOf(string.trim()) + " [text block]";
                label.setInnerText(string);
                label.getOwnerDocument().setModified(true);
                this.fixBug(String.valueOf(string3) + ".setLabel() " + label.getInnerText());
            }
        }
        if (xbrlConcept.isDimension()) {
            if (!xbrlConcept.isAbstract()) {
                xbrlConcept.setAbstract(true);
            }
            for (Label label : xbrlConcept.getLabels(this.dts)) {
                string = label.getInnerText();
                if (string.endsWith(" [axis]")) continue;
                n = string.lastIndexOf(91);
                if (n != -1) {
                    string = String.valueOf(string.substring(0, n).trim()) + " [axis]";
                    label.setInnerText(string);
                    label.getOwnerDocument().setModified(true);
                    this.fixBug(String.valueOf(string3) + ".setLabel() " + label.getInnerText());
                    continue;
                }
                string = String.valueOf(string.trim()) + " [axis]";
                label.setInnerText(string);
                label.getOwnerDocument().setModified(true);
                this.fixBug(String.valueOf(string3) + ".setLabel() " + label.getInnerText());
            }
        } else if (xbrlConcept.isHypercube()) {
            if (!xbrlConcept.isAbstract()) {
                xbrlConcept.setAbstract(true);
                this.e(xbrlConcept);
            }
            for (Label label : xbrlConcept.getLabels(this.dts)) {
                string = label.getInnerText();
                if (string.endsWith(" [table]")) continue;
                n = string.lastIndexOf(91);
                if (n != -1) {
                    string = String.valueOf(string.substring(0, n).trim()) + " [table]";
                    label.setInnerText(string);
                    label.getOwnerDocument().setModified(true);
                    this.fixBug(String.valueOf(string3) + ".setLabel() " + label.getInnerText());
                    continue;
                }
                string = String.valueOf(string.trim()) + " [table]";
                label.setInnerText(string);
                label.getOwnerDocument().setModified(true);
                this.fixBug(String.valueOf(string3) + ".setLabel() " + label.getInnerText());
            }
        }
        if (!xbrlConcept.isNillable()) {
            xbrlConcept.setNillable(true);
            this.e(xbrlConcept);
        }
    }

    private void am() {
        if (this.dts == null) {
            return;
        }
        ArrayList<Label> arrayList = new ArrayList<Label>();
        ArrayList<Label> arrayList2 = new ArrayList<Label>();
        for (RelationshipSet relationshipSet : this.dts.getLabelRelationships()) {
            for (Object e2 : relationshipSet.getFromTargets()) {
                if (!(e2 instanceof XbrlConcept)) continue;
                arrayList.clear();
                arrayList2.clear();
                for (Relationship relationship : relationshipSet.getEffectiveChildren(e2)) {
                    int n;
                    Label label;
                    if (relationship.isSingle()) {
                        if (!(relationship.toTarget() instanceof Label) || arrayList.contains(label = (Label)relationship.toTarget())) continue;
                        n = 0;
                        for (Label label2 : arrayList) {
                            if (!label2.getLang().equals(label.getLang()) || !label2.getRole().equals(label.getRole())) continue;
                            arrayList2.add(label);
                            n = 1;
                            break;
                        }
                        if (n != 0) continue;
                        arrayList.add(label);
                        continue;
                    }
                    Relationship[] relationshipArray = relationship.toArray();
                    int n2 = relationshipArray.length;
                    n = 0;
                    while (n < n2) {
                        Label label3;
                        label = relationshipArray[n];
                        if (label.toTarget() instanceof Label && !arrayList.contains(label3 = (Label)label.toTarget())) {
                            boolean bl = false;
                            for (Label label4 : arrayList) {
                                if (!label4.getLang().equals(label3.getLang()) || !label4.getRole().equals(label3.getRole())) continue;
                                arrayList2.add(label3);
                                bl = true;
                                break;
                            }
                            if (!bl) {
                                arrayList.add(label3);
                            }
                        }
                        ++n;
                    }
                }
                if (arrayList2.isEmpty()) continue;
                for (Label label : arrayList2) {
                    relationshipSet.purgeOrProhibitTarget((Object)label);
                }
            }
        }
    }

    private void a(UsedOnContainer usedOnContainer) {
        XmlSchemaObject xmlSchemaObject;
        if (usedOnContainer != null && (xmlSchemaObject = usedOnContainer.getParentSchemaObject()) != null && xmlSchemaObject.getSchema() instanceof XbrlSchema) {
            ((XbrlSchema)xmlSchemaObject.getSchema()).setModified(true);
        }
    }

    private void e(XbrlConcept xbrlConcept) {
        if (xbrlConcept != null && xbrlConcept.getSchema() instanceof XbrlSchema) {
            xbrlConcept.getSchema().setModified(true);
        }
    }

    private void a(ExtendedLink extendedLink, Map<String, RoleRef> map) {
        try {
            String string = extendedLink.getRole();
            RoleType[] roleTypeArray = this.dts.getRoleTypes().get(string);
            if (roleTypeArray != null && roleTypeArray.length > 0) {
                Linkbase linkbase;
                RoleType roleType = roleTypeArray[0];
                if (!roleType.canUsedOn(extendedLink.getNodeName()) && !XbrlHelper.isReadOnly((XdmElement)roleType)) {
                    linkbase = roleType.createUsedOn(extendedLink.getNodeName());
                    roleType.appendChild((XdmNode)linkbase);
                    this.fixBug("add usedOn: " + string + " -/- " + linkbase.prefixedName(extendedLink.getNodeName()));
                    this.a((UsedOnContainer)roleType);
                }
                if (!map.containsKey(string)) {
                    linkbase = extendedLink.getOwnerLinkbase();
                    RoleRef roleRef = linkbase.createRoleRef();
                    roleRef.setRoleType(roleType);
                    linkbase.prependChild((XdmNode)roleRef);
                    linkbase.getOwnerDocument().setModified(true);
                    this.fixBug("add roleRef: " + string + " -/- " + roleRef.getHref() + " -/- " + HttpUtility.getFileName((String)extendedLink.getOwnerDocument().getBaseURI()));
                }
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)("bugFixRoleRef: " + exception.getMessage()));
        }
    }

    private void an() {
        XbrlSchema[] xbrlSchemaArray;
        XbrlSchema[] xbrlSchemaArray2 = xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray2[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                List list = xbrlSchema.getLinkbaseRefs();
                for (LinkbaseRef linkbaseRef : list) {
                    Linkbase linkbase;
                    IXbrlDocument iXbrlDocument;
                    URI uRI = linkbaseRef.getDiscoveredUri(null);
                    if (uRI == null || (iXbrlDocument = this.dts.getDocument(uRI)) == null || !(iXbrlDocument instanceof XbrlDocument)) continue;
                    XbrlDocument xbrlDocument = (XbrlDocument)iXbrlDocument;
                    if (xbrlDocument.getDocumentElement() == null) {
                        LogWatch.warn((Object)("BugFix: remove empty file: " + xbrlDocument.getBaseURI()));
                        xbrlSchema.removeLinkbaseRef(linkbaseRef);
                        xbrlSchema.setModified(true);
                        continue;
                    }
                    if (!xbrlDocument.getDocumentElement().getNodeName().equals(QNameConstants.linkbase) || !(linkbase = (Linkbase)xbrlDocument.getDocumentElement()).isEmpty()) continue;
                    xbrlSchema.removeLinkbaseRef(linkbaseRef);
                    xbrlSchema.setModified(true);
                }
            }
            ++n2;
        }
    }

    private boolean ao() {
        boolean bl = false;
        this.j = this.dts.getPresentationRelationships();
        for (RelationshipSet relationshipSet : this.j) {
            for (Object e2 : relationshipSet.getFromTargets()) {
                QName qName;
                XbrlConcept xbrlConcept;
                if (!(e2 instanceof XbrlConcept) || !(xbrlConcept = (XbrlConcept)e2).isDimension() || (qName = this.dts.getDefaultDimensionMember(xbrlConcept.getQName())) != null) continue;
                List list = relationshipSet.getEffectiveChildren(e2);
                if (list.size() != 1) {
                    LogWatch.warn((Object)(String.valueOf(xbrlConcept.getPrefixedName()) + " missing default member @" + relationshipSet.toString()));
                    continue;
                }
                if (!this.a(relationshipSet, xbrlConcept, ((Relationship)list.get(0)).toConcept())) continue;
                bl = true;
                this._hasBugFixed = true;
                this.fixBug("create " + xbrlConcept.getPrefixedName() + " axis-default " + ((Relationship)list.get(0)).toConcept().getPrefixedName() + "@" + relationshipSet.getRoleURI());
            }
        }
        return bl;
    }

    private boolean a(RelationshipSet relationshipSet, XbrlConcept xbrlConcept, XbrlConcept xbrlConcept2) {
        if (xbrlConcept2 == null) {
            return false;
        }
        ExtendedLink extendedLink = null;
        List<RelationshipSet> list = this.c(relationshipSet.getRoleURI());
        for (RelationshipSet relationshipSet2 : list) {
            Relationship relationship;
            List list2;
            if (!relationshipSet2.contains((Object)xbrlConcept) || (list2 = relationshipSet2.getEffectiveChildren((Object)xbrlConcept)).size() != 1 || ((Relationship)list2.get(0)).toTarget() != xbrlConcept2 || !(relationship = (Relationship)list2.get(0)).arcrole().equals("http://xbrl.org/int/dim/arcrole/dimension-domain") || relationship.arc().getOwnerDocument().isReadOnly()) continue;
            String string = relationship.toLabel();
            int n = 2;
            String string2 = String.valueOf(string) + "_" + n;
            extendedLink = relationship.arc().getOwnerExtended();
            while (this.b(extendedLink, string2)) {
                string2 = String.valueOf(string) + "_" + ++n;
            }
            Loc loc = extendedLink.createLoc(null, string2);
            extendedLink.appendChild((XdmNode)loc);
            loc.setTarget((Object)xbrlConcept2);
            Arc arc = extendedLink.createArc((QName)QNameConstants.definitionArc, "http://xbrl.org/int/dim/arcrole/dimension-default", "2.0");
            extendedLink.appendChild((XdmNode)arc);
            arc.setFrom(relationship.fromLabel());
            arc.setTo(string2);
            if (extendedLink.addRelationship(arc, relationship.fromPoint(), (XbrlElement)loc) == null) continue;
            this.b.add(relationshipSet2);
            this._hasBugFixed = true;
            return true;
        }
        return false;
    }

    private boolean b(ExtendedLink extendedLink, String string) {
        XdmNode xdmNode = extendedLink.getFirstChild();
        while (xdmNode != null) {
            if (xdmNode.getNodeNature() == 2 && xdmNode instanceof Loc && ((Loc)xdmNode).getLabel().equals(string)) {
                return true;
            }
            xdmNode = xdmNode.getNextSibling();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void ap() {
        try {
            XbrlSchema[] xbrlSchemaArray = this.getEntrySchema();
            int n = xbrlSchemaArray.length;
            int n2 = 0;
            while (n2 < n) {
                XbrlSchema xbrlSchema = xbrlSchemaArray[n2];
                if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object422;
                    for (Object object422 : xbrlSchema.getRoleTypes()) {
                        object3 = object422.getDefinition();
                        if (object3 != null) {
                            object2 = object3.getInnerText();
                            if (object2.startsWith("[RT_")) {
                                object2 = object2.replace("[RT_", "[");
                                object3.setInnerText((String)object2);
                            }
                            int n3 = object2.indexOf("[");
                            int n4 = object2.indexOf("]");
                            if (n3 == 0 && n4 > n3 && n4 != 7 && n4 != 8) {
                                String string2 = object2.substring(1, n4);
                                String string5 = object422.getRoleURI();
                                int n5 = Math.max(string5.lastIndexOf("/"), Math.max(string5.lastIndexOf("-"), string5.lastIndexOf("_")));
                                if (!(n5 == -1 || ((String)(object = string5.substring(n5 + 1))).length() != 6 && ((String)object).length() != 7 || ((String)object).equals(string2))) {
                                    object2 = "[" + (String)object + object2.substring(n4);
                                    object3.setInnerText((String)object2);
                                }
                            }
                        }
                        object2 = object422.getFirstChild();
                        while (object2 != null) {
                            XdmElement xdmElement;
                            XdmNode xdmNode = object2.getNextSibling();
                            if (object2 instanceof XdmElement && !"http://www.xbrl.org/2003/linkbase".equals((xdmElement = (XdmElement)object2).getNamespaceURI()) && "definition".equals(xdmElement.getLocalName())) {
                                object422.removeChild((XdmNode)object2);
                            }
                            object2 = xdmNode;
                        }
                    }
                    object422 = new ArrayList(xbrlSchema.getRoleTypes().getRoleURIs());
                    object3 = object422.iterator();
                    while (object3.hasNext()) {
                        void var12_28;
                        String string3 = (String)object3.next();
                        object2 = this.dts.getRoleTypes().get(string3);
                        if (((RoleType[])object2).length <= 1) continue;
                        RoleType string4 = null;
                        HashSet<QName> hashSet = new HashSet<QName>();
                        int n6 = 0;
                        while (n6 < ((RoleType[])object2).length) {
                            RoleType n9 = object2[n6];
                            if (n9 != null) {
                                if (XbrlHelper.isReadOnly((XdmElement)n9)) {
                                    string4 = n9;
                                }
                                object = n9.getUsedOns().iterator();
                                while (object.hasNext()) {
                                    UsedOn usedOn = (UsedOn)object.next();
                                    hashSet.add(usedOn.getQName());
                                }
                            }
                            ++n6;
                        }
                        if (string4 != null) {
                            void var12_24;
                            object = object2;
                            int n7 = ((RoleType[])object2).length;
                            boolean bl = false;
                            while (var12_24 < n7) {
                                IXbrlDocument iXbrlDocument;
                                RoleType roleType = object[var12_24];
                                if (roleType != null && roleType != string4 && !XbrlHelper.isReadOnly((XdmElement)roleType) && (iXbrlDocument = this.dts.getDocument(roleType.getOwnerDocument().getBaseURI())) instanceof XbrlSchema) {
                                    ((XbrlSchema)iXbrlDocument).removeRoleType(roleType);
                                    iXbrlDocument.setModified(true);
                                    this.fixBug("remove roleType = " + roleType.getRoleURI());
                                    this._hasBugFixed = true;
                                }
                                ++var12_24;
                            }
                            continue;
                        }
                        RoleType roleType = object2[0];
                        if (!XbrlHelper.isReadOnly((XdmElement)roleType)) {
                            for (QName qName : hashSet) {
                                if (roleType.canUsedOn(qName)) continue;
                                roleType.appendChild((XdmNode)roleType.createUsedOn(qName));
                                object = this.dts.getDocument(roleType.getOwnerDocument().getBaseURI());
                                if (object == null) continue;
                                object.setModified(true);
                            }
                        }
                        boolean bl = true;
                        while (var12_28 < ((RoleType[])object2).length) {
                            RoleType roleType2 = object2[var12_28];
                            if (roleType2 != null && !XbrlHelper.isReadOnly((XdmElement)roleType2) && (object = this.dts.getDocument(roleType2.getOwnerDocument().getBaseURI())) instanceof XbrlSchema) {
                                xbrlSchema.removeRoleType(roleType2);
                                xbrlSchema.setModified(true);
                                this.dts.getRoleTypes().remove((Object)roleType2);
                                this.fixBug("remove roleType = " + roleType2.getRoleURI());
                                this._hasBugFixed = true;
                                object2[var12_28] = null;
                            }
                            ++var12_28;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)("bugFix: roleType " + exception.getMessage()));
        }
    }

    private void aq() {
        RoleTypeCollection roleTypeCollection = this.dts.getRoleTypes();
        this.genericLinkRS = this.dts.getRelationshipSets((QName)QNameConstants.genericLink);
        for (RoleType roleType : roleTypeCollection) {
            String string;
            boolean bl;
            String string2;
            RoleType roleType2;
            char c2;
            String string3;
            if (roleType.getOwnerDocument().isReadOnly() || StringUtils.isEmpty((String)(string3 = roleType.getRoleURI())) || ((c2 = string3.charAt(string3.length() - 1)) < 'a' || c2 > 'z') && (c2 < 'A' || c2 > 'Z') || (roleType2 = roleTypeCollection.getSingle(string2 = string3.substring(0, string3.length() - 1))) == null) continue;
            String string4 = roleType.getDefinitionText();
            String string5 = roleType2.getDefinitionText();
            int n = string4.indexOf("]");
            int n2 = string5.indexOf("]");
            if (n2 == -1) continue;
            String string6 = string5.substring(n2 + 1);
            boolean bl2 = bl = n == -1;
            if (!bl && string6.equals(string = string4.substring(n + 1))) continue;
            string = String.valueOf(string4.substring(0, n + 1)) + string6;
            roleType.setDefinitionText(string);
            this.a((UsedOnContainer)roleType);
        }
    }

    private void ar() {
        this.aq();
        if (this.getExtendMode().isReuseMode()) {
            this.ap();
            return;
        }
        if (!this.getExtendMode().isRedefineMode()) {
            return;
        }
        try {
            XbrlSchema[] xbrlSchemaArray = this.getEntrySchema();
            int n = xbrlSchemaArray.length;
            int n2 = 0;
            while (n2 < n) {
                XbrlSchema xbrlSchema = xbrlSchemaArray[n2];
                if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                    Iterator iterator;
                    String string;
                    Object object;
                    Object object2;
                    Object object32;
                    for (Object object32 : xbrlSchema.getRoleTypes()) {
                        String string2;
                        StringBuilder stringBuilder;
                        String string3;
                        int n3;
                        String string4;
                        int n4;
                        object2 = object32.getDefinition();
                        if (object2 != null) {
                            object = object2.getInnerText();
                            if (object.startsWith("[RT_")) {
                                object = object.replace("[RT_", "[");
                                object2.setInnerText((String)object);
                            }
                            int n5 = object.indexOf("[");
                            n4 = object.indexOf("]");
                            if (n5 == 0 && n4 > n5 && n4 != 7 && n4 != 8) {
                                string4 = object.substring(1, n4);
                                string = object32.getRoleURI();
                                n3 = Math.max(string.lastIndexOf("/"), Math.max(string.lastIndexOf("-"), string.lastIndexOf("_")));
                                if (!(n3 == -1 || ((String)((Object)(iterator = (string = string.substring(n3 + 1))))).length() != 6 && ((String)((Object)iterator)).length() != 7 || ((String)((Object)iterator)).equals(string4))) {
                                    object = "[" + iterator + object.substring(n4);
                                    object2.setInnerText((String)object);
                                }
                            }
                        }
                        object = object32.getFirstChild();
                        while (object != null) {
                            XdmElement xdmElement;
                            XdmNode xdmNode = object.getNextSibling();
                            if (object instanceof XdmElement && !"http://www.xbrl.org/2003/linkbase".equals((xdmElement = (XdmElement)object).getNamespaceURI()) && "definition".equals(xdmElement.getLocalName())) {
                                object32.removeChild((XdmNode)object);
                            }
                            object = xdmNode;
                        }
                        String string5 = object32.getRoleURI();
                        n4 = string5.lastIndexOf(47);
                        if (n4 == -1) continue;
                        string = string4 = string5.substring(n4 + 1);
                        if (string4.length() > 6) {
                            string4 = string4.substring(0, 6);
                        }
                        if (string4.length() != 6 || (n3 = string4.charAt(5) - 49) < 0 || n3 > 3 || (iterator = CasProcessor.rules[n3]) == null) continue;
                        Definition definition = object32.getDefinition();
                        if (definition == null) {
                            definition = object32.createDefinition();
                            string3 = object32.getFirstChild();
                            if (string3 == null) {
                                object32.appendChild((XdmNode)definition);
                            } else {
                                object32.insertBefore((XdmNode)definition, (XdmNode)string3);
                            }
                        }
                        if ((string3 = definition.getInnerText()).contains(((CasProcessor.RoleTypeRule)((Object)iterator)).markText2)) continue;
                        String string6 = ((CasProcessor.RoleTypeRule)((Object)iterator)).markText;
                        int n6 = string3.indexOf("]");
                        int n7 = string3.indexOf(string6);
                        if (n6 == -1) {
                            stringBuilder = new StringBuilder("[").append(string).append("] ").append(string6).append(" - ");
                            if (n7 != -1) {
                                stringBuilder.append(string3.substring(n7 + string6.length()).trim());
                            } else {
                                string2 = string3.trim();
                                if (StringUtils.isEmpty((String)string2) && (string2 = this.e(string5)).contains(string6)) {
                                    string2 = string2.replace(String.valueOf(string6) + " - ", "");
                                }
                                stringBuilder.append(string2);
                            }
                            definition.setInnerText(stringBuilder.toString());
                            this.a((UsedOnContainer)object32);
                            this.fixBug("set roleType definition = " + stringBuilder.toString());
                            this._hasBugFixed = true;
                            continue;
                        }
                        if (n7 > n6) {
                            stringBuilder = new StringBuilder(string3.substring(0, n6 + 1));
                            stringBuilder.append(" ").append(string6).append(" - ");
                            stringBuilder.append(string3.substring(n7 + string6.length()).trim());
                            definition.setInnerText(stringBuilder.toString());
                            this.a((UsedOnContainer)object32);
                            this.fixBug("set roleType definition = " + stringBuilder.toString());
                            this._hasBugFixed = true;
                            continue;
                        }
                        stringBuilder = new StringBuilder(string3.substring(0, n6 + 1));
                        stringBuilder.append(" ").append(string6).append(" - ");
                        if (string3.length() > n6 + 1) {
                            string2 = string3.substring(n6 + 1).trim();
                            int n8 = 0;
                            while (n8 < 4) {
                                CasProcessor.RoleTypeRule roleTypeRule = CasProcessor.rules[n8];
                                if (string2.startsWith(roleTypeRule.markText2)) {
                                    string2 = string2.substring(roleTypeRule.markText2.length());
                                }
                                ++n8;
                            }
                            stringBuilder.append(string2);
                        }
                        definition.setInnerText(stringBuilder.toString());
                        this.a((UsedOnContainer)object32);
                        this.fixBug("set roleType definition = " + stringBuilder.toString());
                        this._hasBugFixed = true;
                    }
                    object32 = new ArrayList(xbrlSchema.getRoleTypes().getRoleURIs());
                    object2 = object32.iterator();
                    while (object2.hasNext()) {
                        String string7 = (String)object2.next();
                        object = this.dts.getRoleTypes().get(string7);
                        if (((RoleType[])object).length <= 1) continue;
                        int n9 = 0;
                        while (n9 < ((RoleType[])object).length - 1) {
                            RoleType roleType = object[n9];
                            if (roleType != null && !XbrlHelper.isReadOnly((XdmElement)roleType)) {
                                int n10 = n9 + 1;
                                while (n10 < ((RoleType[])object).length) {
                                    string = object[n10];
                                    if (string != null && !XbrlHelper.isReadOnly((XdmElement)string) && roleType.getId().equals(string.getId())) {
                                        iterator = string.getUsedOns().iterator();
                                        while (iterator.hasNext()) {
                                            UsedOn usedOn = (UsedOn)iterator.next();
                                            try {
                                                if (roleType.canUsedOn(usedOn.getQName())) continue;
                                                roleType.appendChild((XdmNode)usedOn);
                                            }
                                            catch (EvaluationException evaluationException) {
                                                evaluationException.printStackTrace();
                                            }
                                        }
                                        xbrlSchema.removeRoleType((RoleType)string);
                                        xbrlSchema.setModified(true);
                                        this.dts.getRoleTypes().remove((Object)string);
                                        this.fixBug("remove roleType = " + string.getRoleURI());
                                        this._hasBugFixed = true;
                                        object[n10] = null;
                                    }
                                    ++n10;
                                }
                            }
                            ++n9;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)("bugFix: roleType " + exception.getMessage()));
        }
        this.ak();
    }

    private String e(String string) {
        RoleType[] roleTypeArray;
        char c2 = string.charAt(string.length() - 1);
        if (c2 >= 'a' && c2 <= 'z') {
            string = string.substring(0, string.length() - 1);
        }
        if ((roleTypeArray = this.dts.getRoleTypes().get(string)) != null && roleTypeArray.length != 0) {
            String string2 = roleTypeArray[0].getDefinitionText();
            int n = string2.indexOf("]");
            if (n > -1) {
                string2 = string2.substring(n + 1).trim();
            }
            return string2;
        }
        return "";
    }

    void a(String string) {
        boolean bl = false;
        this.rebuildRelationshipSet();
        ArrayList arrayList = new ArrayList(this.dts.getRoleTypes());
        Set<String> set = null;
        for (RoleType roleType : arrayList) {
            Object object2;
            if (roleType.getOwnerDocument().isReadOnly()) continue;
            String string2 = roleType.getRoleURI();
            boolean bl2 = false;
            for (Object object2 : this.dts.getRelationshipSets(string2)) {
                if (object2.getRelationships().size() == 0) continue;
                bl2 = true;
                break;
            }
            if (bl2 || !string2.equals(string)) continue;
            if (set == null) {
                set = this.getReferencedRoleTypes(this.dts);
            }
            if (set.contains(string2)) continue;
            object2 = roleType.getOwnerDocument().getDocUri();
            this.dts.getRoleTypes().remove((Object)roleType);
            this.p.add(roleType.getRoleURI());
            IXbrlDocument iXbrlDocument = this.dts.getDocument((URI)object2);
            if (iXbrlDocument != null && iXbrlDocument instanceof XbrlSchema) {
                if (!((XbrlSchema)iXbrlDocument).removeRoleType(roleType)) continue;
                this.dts.getRoleTypes().remove((Object)roleType);
                this.p.add(roleType.getRoleURI());
                if (this.genericLinkRS == null) {
                    this.genericLinkRS = this.dts.getRelationshipSets((QName)QNameConstants.genericLink);
                }
                for (RelationshipSet relationshipSet : this.genericLinkRS) {
                    relationshipSet.purgeOrProhibitTarget((Object)roleType);
                    boolean bl3 = bl = relationshipSet.getRelationships().size() == 0 || bl;
                }
                continue;
            }
            LogWatch.error((Object)("roleType:" + string2 + ", the schema file not found."));
        }
        if (bl) {
            this.removeUnusedGenericLink();
        }
    }

    private void as() {
        Object object;
        boolean bl = false;
        this.rebuildRelationshipSet();
        HashSet<RoleType> hashSet = new HashSet<RoleType>((Collection<RoleType>)this.dts.getRoleTypes());
        Object object2 = this.getEntrySchema();
        int n = ((XbrlSchema[])object2).length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            for (RoleType roleType : object.getRoleTypes()) {
                hashSet.add(roleType);
            }
            ++n2;
        }
        object = null;
        for (RoleType roleType : hashSet) {
            Object object32;
            if (roleType.getOwnerDocument().isReadOnly()) continue;
            object2 = roleType.getRoleURI();
            boolean bl2 = false;
            block3: for (Object object32 : this.dts.getRelationshipSets((String)object2)) {
                if (object32.getRelationships().size() == 0) continue;
                for (Relationship relationship : object32.getRelationships()) {
                    if (relationship.isRemoved()) continue;
                    bl2 = true;
                    break block3;
                }
            }
            if (bl2) continue;
            if (object == null) {
                object = this.getReferencedRoleTypes(this.dts);
            }
            if (object.contains(object2)) continue;
            object32 = roleType.getOwnerDocument().getDocUri();
            this.dts.getRoleTypes().remove((Object)roleType);
            this.p.add(roleType.getRoleURI());
            IXbrlDocument iXbrlDocument = this.dts.getDocument((URI)object32);
            if (iXbrlDocument != null && iXbrlDocument instanceof XbrlSchema) {
                if (!((XbrlSchema)iXbrlDocument).removeRoleType(roleType)) continue;
                this.dts.getRoleTypes().remove((Object)roleType);
                this.p.add(roleType.getRoleURI());
                if (this.genericLinkRS == null) {
                    this.genericLinkRS = this.dts.getRelationshipSets((QName)QNameConstants.genericLink);
                }
                for (Relationship relationship : this.genericLinkRS) {
                    relationship.purgeOrProhibitTarget((Object)roleType);
                    boolean bl3 = bl = relationship.getRelationships().size() == 0 || bl;
                }
                continue;
            }
            LogWatch.error((Object)("roleType:" + (String)object2 + ", the schema file not found."));
        }
        if (bl) {
            this.removeUnusedGenericLink();
        }
    }

    private void at() {
        XbrlSchema[] xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray[n2];
            for (RoleType roleType : new ArrayList(xbrlSchema.getRoleTypes())) {
                if (roleType.getUsedOns().size() != 0) continue;
                xbrlSchema.removeRoleType(roleType);
            }
            ++n2;
        }
    }

    public static final boolean isPairURI(String thisURI, String roleURI) {
        if (Math.abs(thisURI.length() - roleURI.length()) <= 1) {
            boolean bl;
            boolean bl2 = bl = thisURI.equals(roleURI) || thisURI.startsWith(roleURI) || roleURI.startsWith(thisURI);
            if (bl) {
                return true;
            }
        }
        return false;
    }

    private List<RelationshipSet> f(String string) {
        String string2 = string;
        int n = string.lastIndexOf("/");
        if (n + 7 == string.length() - 1) {
            string2 = String.valueOf(string.substring(0, n + 1)) + string.substring(n + 1, string.length() - 1);
        }
        ArrayList<RelationshipSet> arrayList = new ArrayList<RelationshipSet>();
        for (RelationshipSet relationshipSet : this.j) {
            if (!CasCleaner.isPairURI(string2, relationshipSet.getRoleURI())) continue;
            arrayList.add(relationshipSet);
        }
        return arrayList;
    }

    List<RelationshipSet> b(String string) {
        String string2 = string;
        int n = string.lastIndexOf("/");
        if (n + 7 == string.length() - 1) {
            string2 = String.valueOf(string.substring(0, n + 1)) + string.substring(n + 1, string.length() - 1);
        }
        ArrayList<RelationshipSet> arrayList = new ArrayList<RelationshipSet>();
        for (RelationshipSet relationshipSet : this.k) {
            if (!CasCleaner.isPairURI(string2, relationshipSet.getRoleURI())) continue;
            arrayList.add(relationshipSet);
        }
        return arrayList;
    }

    List<RelationshipSet> c(String string) {
        String string2 = string;
        int n = string.lastIndexOf("/");
        if (n + 7 == string.length() - 1) {
            string2 = String.valueOf(string.substring(0, n + 1)) + string.substring(n + 1, string.length() - 1);
        }
        ArrayList<RelationshipSet> arrayList = new ArrayList<RelationshipSet>();
        for (RelationshipSet relationshipSet : this.l) {
            if (!CasCleaner.isPairURI(string2, relationshipSet.getRoleURI())) continue;
            arrayList.add(relationshipSet);
        }
        return arrayList;
    }

    private boolean a(XdtDimension xdtDimension, XdtCompiledMember xdtCompiledMember) {
        if (xdtDimension == null || xdtCompiledMember == null) {
            return false;
        }
        Collection collection = xdtCompiledMember.getChildren();
        if (collection != null && collection.size() > 0) {
            for (XdtComponent xdtComponent : collection) {
                XbrlConcept xbrlConcept = xdtComponent.getConcept();
                QName qName = xbrlConcept.getQName();
                if (this.e.containsKey(qName) || this.h.contains(qName)) {
                    return true;
                }
                XdtCompiledMember xdtCompiledMember2 = xdtDimension.getCompiledMember(xbrlConcept);
                if (!this.a(xdtDimension, xdtCompiledMember2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean b(XdtDimension xdtDimension, XdtCompiledMember xdtCompiledMember) {
        if (xdtDimension == null || xdtCompiledMember == null) {
            return false;
        }
        Collection collection = xdtCompiledMember.getChildren();
        if (collection != null && collection.size() > 0) {
            for (XdtComponent xdtComponent : collection) {
                XbrlConcept xbrlConcept = xdtComponent.getConcept();
                if (this.g.contains(xbrlConcept)) {
                    return true;
                }
                XdtCompiledMember xdtCompiledMember2 = xdtDimension.getCompiledMember(xbrlConcept);
                if (!this.b(xdtDimension, xdtCompiledMember2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean a(XdtDRS xdtDRS, XdtComponent xdtComponent) {
        if (xdtDRS == null || xdtComponent == null) {
            return false;
        }
        Collection collection = xdtComponent.getDomainMembers();
        if (collection != null && collection.size() > 0) {
            for (XdtComponent xdtComponent2 : collection) {
                XbrlConcept xbrlConcept = xdtComponent2.getConcept();
                QName qName = xbrlConcept.getQName();
                if (this.f.containsKey(qName) || this.e.containsKey(qName) || this.h.contains(qName)) {
                    return true;
                }
                if (!this.a(xdtDRS, xdtComponent2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean b(XdtDRS xdtDRS, XdtComponent xdtComponent) {
        if (xdtDRS == null || xdtComponent == null) {
            return false;
        }
        Collection collection = xdtComponent.getDomainMembers();
        if (collection != null && collection.size() > 0) {
            for (XdtComponent xdtComponent2 : collection) {
                XbrlConcept xbrlConcept = xdtComponent2.getConcept();
                if (this.g.contains(xbrlConcept)) {
                    return true;
                }
                if (!this.b(xdtDRS, xdtComponent2)) continue;
                return true;
            }
        }
        return false;
    }

    private void g(RelationshipSet relationshipSet) {
        if (!relationshipSet.getExtendedName().equals(QNameConstants.definitionLink)) {
            return;
        }
        XdtDRS xdtDRS = (XdtDRS)this.dts.getAllDRS().get(relationshipSet.getRoleURI());
        if (xdtDRS == null) {
            return;
        }
        HashSet<XbrlConcept> hashSet = new HashSet<XbrlConcept>();
        if (this.byInstance) {
            for (XbrlConcept xbrlConcept : xdtDRS.getAllPrimaryItems()) {
                XdtComponent xdtComponent;
                QName qName = xbrlConcept.getQName();
                if (this.f.containsKey(qName) || (xdtComponent = xdtDRS.tryGetComponent(xbrlConcept)) == null || this.a(xdtDRS, xdtComponent)) continue;
                hashSet.add(xbrlConcept);
            }
        } else {
            for (XbrlConcept xbrlConcept : xdtDRS.getAllPrimaryItems()) {
                XdtComponent xdtComponent;
                if (this.g.contains(xbrlConcept) || (xdtComponent = xdtDRS.tryGetComponent(xbrlConcept)) == null || this.b(xdtDRS, xdtComponent)) continue;
                hashSet.add(xbrlConcept);
            }
        }
        relationshipSet.purgeOrProhibitTargets(hashSet);
    }

    private void h(RelationshipSet relationshipSet) {
        if (!relationshipSet.getExtendedName().equals(QNameConstants.definitionLink)) {
            return;
        }
        XdtDRS xdtDRS = (XdtDRS)this.dts.getAllDRS().get(relationshipSet.getRoleURI());
        if (xdtDRS == null) {
            return;
        }
        HashSet<XbrlConcept> hashSet = new HashSet<XbrlConcept>();
        if (this.byInstance) {
            Iterator iterator = xdtDRS.getHasHypercubes().values().iterator();
            while (iterator.hasNext()) {
                XdtCompiledHypercube[] xdtCompiledHypercubeArray;
                XdtCompiledHypercube[] xdtCompiledHypercubeArray2 = xdtCompiledHypercubeArray = (XdtCompiledHypercube[])iterator.next();
                int n = xdtCompiledHypercubeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    XdtCompiledHypercube xdtCompiledHypercube = xdtCompiledHypercubeArray2[n2];
                    if (xdtCompiledHypercube != null) {
                        XdtDimension[] xdtDimensionArray = xdtCompiledHypercube.getDimensions();
                        int n3 = xdtDimensionArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            XdtDimension xdtDimension = xdtDimensionArray[n4];
                            for (XbrlConcept xbrlConcept : xdtDimension.getMembers()) {
                                QName qName = xbrlConcept.getQName();
                                if (this.e.containsKey(qName) || this.h.contains(qName) || this.a(xdtDimension, xdtDimension.getCompiledMember(xbrlConcept))) continue;
                                hashSet.add(xbrlConcept);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        } else {
            Iterator iterator = xdtDRS.getHasHypercubes().values().iterator();
            while (iterator.hasNext()) {
                XdtCompiledHypercube[] xdtCompiledHypercubeArray;
                XdtCompiledHypercube[] xdtCompiledHypercubeArray3 = xdtCompiledHypercubeArray = (XdtCompiledHypercube[])iterator.next();
                int n = xdtCompiledHypercubeArray.length;
                int n5 = 0;
                while (n5 < n) {
                    XdtCompiledHypercube xdtCompiledHypercube = xdtCompiledHypercubeArray3[n5];
                    if (xdtCompiledHypercube != null) {
                        XdtDimension[] xdtDimensionArray = xdtCompiledHypercube.getDimensions();
                        int n6 = xdtDimensionArray.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            XdtDimension xdtDimension = xdtDimensionArray[n7];
                            for (XbrlConcept xbrlConcept : xdtDimension.getMembers()) {
                                if (this.g.contains(xbrlConcept) || this.b(xdtDimension, xdtDimension.getCompiledMember(xbrlConcept))) continue;
                                hashSet.add(xbrlConcept);
                            }
                            ++n7;
                        }
                    }
                    ++n5;
                }
            }
        }
        relationshipSet.purgeOrProhibitTargets(hashSet);
    }

    private void i(RelationshipSet relationshipSet) {
        Object object;
        Object object2;
        XbrlConcept xbrlConcept;
        Object object32;
        this.h(relationshipSet);
        this.g(relationshipSet);
        HashSet hashSet = new HashSet();
        relationshipSet.getAllTargets(hashSet);
        ArrayList<XbrlConcept> arrayList = new ArrayList<XbrlConcept>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (Object object4 : hashSet) {
            if (!(object4 instanceof XbrlConcept)) continue;
            object32 = (XbrlConcept)object4;
            if (object32.isHypercube()) {
                arrayList.add((XbrlConcept)object32);
                continue;
            }
            if (!object32.isDimension()) continue;
            arrayList2.add(object32);
        }
        for (XbrlConcept xbrlConcept2 : arrayList2) {
            object32 = relationshipSet.getEffectiveChildren((Object)xbrlConcept2);
            if (object32.size() != 0) continue;
            relationshipSet.purgeOrProhibitTarget((Object)xbrlConcept2);
            if (!xbrlConcept2.getName().equals("Axis")) continue;
            this.fixBug("remove " + xbrlConcept2 + " @" + relationshipSet + " check table", true);
        }
        hashSet.clear();
        hashSet = null;
        if (arrayList.size() == 0) {
            return;
        }
        for (XbrlConcept xbrlConcept3 : arrayList) {
            for (Object object32 : relationshipSet.getParents((Object)xbrlConcept3)) {
                xbrlConcept = object32.fromConcept();
                if (xbrlConcept == null || (object2 = relationshipSet.getEffectiveChildren((Object)xbrlConcept)).size() != 1 || (object = ((Relationship)object2.get(0)).toConcept()) != xbrlConcept3) continue;
                relationshipSet.purgeOrProhibitTarget((Object)xbrlConcept);
                this.fixBug("remove " + xbrlConcept + " @" + relationshipSet + " check table", true);
            }
        }
        for (XbrlConcept xbrlConcept4 : arrayList) {
            object32 = relationshipSet.getEffectiveChildren((Object)xbrlConcept4);
            if (object32.size() != 0) continue;
            relationshipSet.purgeOrProhibitTarget((Object)xbrlConcept4);
            this.fixBug("remove " + xbrlConcept4 + " @" + relationshipSet + " check table", true);
        }
        for (XbrlConcept xbrlConcept5 : arrayList) {
            if (relationshipSet.getParents((Object)xbrlConcept5).size() != 0) continue;
            object32 = new HashSet();
            HashSet hashSet2 = new HashSet();
            hashSet2.add(xbrlConcept5);
            if (!this.a(relationshipSet, xbrlConcept5, (HashSet<ExtendedLink>)object32, hashSet2) || ((HashSet)object32).size() != 1) continue;
            object2 = ((HashSet)object32).iterator();
            while (object2.hasNext()) {
                xbrlConcept = (ExtendedLink)object2.next();
                if (this.a((ExtendedLink)xbrlConcept, hashSet2)) {
                    Iterator iterator = hashSet2.iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        relationshipSet.purgeOrProhibitTarget(object);
                        this.fixBug("remove " + object + " @" + relationshipSet + " no parent.", true);
                    }
                    continue;
                }
                relationshipSet.purgeOrProhibitTarget((Object)xbrlConcept5);
                this.fixBug("remove " + xbrlConcept5 + " @" + relationshipSet + " no parent.", true);
            }
        }
        if (relationshipSet.getExtendedName().equals(QNameConstants.definitionLink) && !this.B.contains(relationshipSet.getRoleURI())) {
            boolean bl;
            boolean bl2 = true;
            for (Relationship relationship : relationshipSet.getRelationships()) {
                if (relationship.arcrole().equals("http://xbrl.org/int/dim/arcrole/domain-member")) continue;
                bl = false;
                break;
            }
            if (bl) {
                relationshipSet.purgeOrProhibitTargets(relationshipSet.getFromTargets());
                this.fixBug("remove " + relationshipSet + " no table.", true);
            }
        }
    }

    private boolean a(ExtendedLink extendedLink, HashSet<Object> hashSet) {
        for (Relationship relationship : extendedLink.getRelationships()) {
            if (!hashSet.contains(relationship.fromTarget())) {
                return false;
            }
            if (hashSet.contains(relationship.toTarget())) continue;
            return false;
        }
        return true;
    }

    private boolean a(RelationshipSet relationshipSet, XbrlConcept xbrlConcept, HashSet<ExtendedLink> hashSet, HashSet<Object> hashSet2) {
        for (Relationship relationship : relationshipSet.getEffectiveChildren((Object)xbrlConcept)) {
            XbrlConcept xbrlConcept2 = relationship.toConcept();
            if (xbrlConcept2 != null) {
                if (hashSet2.contains(xbrlConcept2)) continue;
                hashSet2.add(xbrlConcept2);
                hashSet.add(relationship.arc().getOwnerExtended());
                if (this.a(relationshipSet, xbrlConcept2, hashSet, hashSet2)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void j(RelationshipSet relationshipSet) {
        if (relationshipSet == null) {
            return;
        }
        String string = relationshipSet.getRoleURI();
        HashSet<XbrlConcept> hashSet = new HashSet<XbrlConcept>();
        List<RelationshipSet> list = this.b(string);
        for (RelationshipSet relationshipSet2 : list) {
            ArrayList arrayList = new ArrayList(relationshipSet2.getFromTargets());
            hashSet.clear();
            for (Object e2 : arrayList) {
                XbrlConcept xbrlConcept;
                XbrlConcept xbrlConcept2 = xbrlConcept = e2 instanceof XbrlConcept ? (XbrlConcept)e2 : null;
                if (xbrlConcept == null) continue;
                QName qName = xbrlConcept.getQName();
                if (!this.f.containsKey(qName)) {
                    hashSet.add(xbrlConcept);
                }
                ArrayList arrayList2 = new ArrayList(relationshipSet2.getEffectiveChildren((Object)xbrlConcept));
                for (Relationship relationship : arrayList2) {
                    XbrlConcept xbrlConcept3 = relationship.toConcept();
                    if (xbrlConcept3 == null || this.f.containsKey(xbrlConcept3.getQName())) continue;
                    hashSet.add(xbrlConcept3);
                }
                if (hashSet.size() == 0) continue;
                relationshipSet2.purgeOrProhibitTargets(hashSet);
            }
        }
    }

    private void a(Collection<XbrlConcept> collection, RelationshipSet relationshipSet) {
        if (relationshipSet == null) {
            return;
        }
        String string = relationshipSet.getRoleURI();
        HashSet<QName> hashSet = new HashSet<QName>();
        HashSet<QName> hashSet2 = new HashSet<QName>();
        List<RelationshipSet> list = this.f(string);
        List<RelationshipSet> list2 = this.c(string);
        HashSet<XbrlConcept> hashSet3 = new HashSet<XbrlConcept>();
        if (this.byInstance) {
            Object object;
            QName qName;
            for (XbrlConcept xbrlConcept : collection) {
                boolean bl;
                boolean bl2;
                if (xbrlConcept == null) continue;
                qName = xbrlConcept.getQName();
                if (xbrlConcept.isDimension() && this.a(qName, xbrlConcept, relationshipSet)) continue;
                object = null;
                if (this.e.containsKey(qName)) {
                    object = false;
                    bl2 = false;
                    for (QName qName2 : this.e.get(qName)) {
                        if (!this.a(qName2, xbrlConcept, relationshipSet)) continue;
                        bl2 = true;
                        object = true;
                    }
                    if (bl2) continue;
                }
                if (xbrlConcept == null || this.c.contains(qName)) continue;
                boolean bl3 = bl2 = object != null ? (Boolean)object : false;
                if (!bl2) {
                    bl2 = this.a(this.xbrlInstance, xbrlConcept, list, hashSet, this.c);
                }
                boolean bl4 = bl2 ? true : (bl = object != null ? (Boolean)object : false);
                if (!bl) {
                    bl = this.a(this.xbrlInstance, xbrlConcept, list2, hashSet2, this.c);
                }
                if (bl2 || bl) continue;
                if (this.d.containsKey(qName)) {
                    if (this.i == null) {
                        this.i = new HashMap<QName, XbrlConcept>();
                    }
                    this.i.put(qName, xbrlConcept);
                    continue;
                }
                if (xbrlConcept == this.n) continue;
                hashSet3.add(xbrlConcept);
            }
            if (relationshipSet.getExtendedName().equals(QNameConstants.definitionLink)) {
                relationshipSet.purgeOrProhibitTargets(hashSet3);
                this.i(relationshipSet);
            } else {
                for (XbrlConcept xbrlConcept : this.dts.getRelationshipSets()) {
                    qName = xbrlConcept.getExtendedName();
                    if (qName.equals(QNameConstants.labelLink) || qName.equals(QNameConstants.referenceLink) || qName.equals(QNameConstants.calculationLink) || !CasCleaner.isPairURI((String)(object = xbrlConcept.getRoleURI()), string)) continue;
                    xbrlConcept.purgeOrProhibitTargets(hashSet3);
                    this.i((RelationshipSet)xbrlConcept);
                }
            }
        } else if (relationshipSet.getExtendedName().equals(QNameConstants.definitionLink)) {
            this.i(relationshipSet);
        }
    }

    private void au() {
        XbrlSchema[] xbrlSchemaArray;
        if (!this.byInstance) {
            return;
        }
        XbrlSchema[] xbrlSchemaArray2 = xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray2[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                Map<String, h> map = this.a(xbrlSchema);
                for (h h2 : map.values()) {
                    if (h2.a || h2.d == null) continue;
                    Linkbase linkbase = h2.d;
                    Boolean bl = null;
                    for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                        if (!extendedLink.getNodeName().equals(QNameConstants.presentationLink) && !extendedLink.getNodeName().equals(QNameConstants.definitionLink) && !extendedLink.getNodeName().equals(QNameConstants.calculationLink) && !extendedLink.getNodeName().equals(QNameConstants.referenceLink) && !extendedLink.getNodeName().equals(QNameConstants.labelLink)) continue;
                        if (this.c(extendedLink)) {
                            bl = true;
                            break;
                        }
                        if (bl != null) continue;
                        bl = false;
                    }
                    if (bl == null || bl.booleanValue()) continue;
                    xbrlSchema.removeLinkbaseRef(h2.c);
                    h2.a = true;
                    this.dts.removeRelationships(linkbase.getOwnerDocument());
                }
            }
            ++n2;
        }
    }

    private boolean c(ExtendedLink extendedLink) {
        if (this.byInstance) {
            for (Relationship relationship : extendedLink.getRelationships()) {
                XbrlConcept xbrlConcept = relationship.toConcept();
                if (xbrlConcept != null && this.f.containsKey(xbrlConcept.getQName())) {
                    return true;
                }
                XbrlConcept xbrlConcept2 = relationship.fromConcept();
                if (xbrlConcept2 == null || !this.f.containsKey(xbrlConcept2.getQName())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private Map<String, h> a(XbrlSchema xbrlSchema) {
        HashMap<String, h> hashMap = new HashMap<String, h>();
        for (LinkbaseRef linkbaseRef : xbrlSchema.getLinkbaseRefs()) {
            Linkbase linkbase = this.a(linkbaseRef);
            if (linkbase == null || !linkbase.getOwnerDocument().isReadOnly()) continue;
            h h2 = new h();
            h2.b = linkbase.getOwnerDocument().getBaseURI();
            h2.d = linkbase;
            h2.c = linkbaseRef;
            hashMap.put(h2.b, h2);
        }
        return hashMap;
    }

    private Linkbase a(LinkbaseRef linkbaseRef) {
        XbrlDocument xbrlDocument;
        IXbrlDocument iXbrlDocument;
        URI uRI = linkbaseRef.getDiscoveredUri(null);
        if (uRI != null && (iXbrlDocument = this.dts.getDocument(uRI)) != null && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
            return (Linkbase)xbrlDocument.getDocumentElement();
        }
        return null;
    }

    public boolean importHistory(ImportOptions options) {
        XmlSchema xmlSchema;
        int n;
        XbrlSchema xbrlSchema;
        TaxonomySet taxonomySet;
        block15: {
            block14: {
                String string;
                XbrlUrlResolver xbrlUrlResolver;
                block13: {
                    if (this.dts == null || options == null || options.isEmpty() || options.getDtsBytes() == null) {
                        return false;
                    }
                    if (options.out != null) {
                        this.out = options.out;
                    }
                    xbrlUrlResolver = new XbrlUrlResolver();
                    ZipStream zipStream = new ZipStream(options.getDtsBytes());
                    xbrlUrlResolver.addZipMapping(ZipStream.FILE_DOMAIN, (IZipStream)zipStream);
                    string = null;
                    for (String string2 : zipStream.getEntries()) {
                        if (!string2.endsWith(".xsd")) continue;
                        string = string2;
                        break;
                    }
                    if (string != null) break block13;
                    IOHelper.writeMessage((OutputStream)this.out, (String)"\u6ca1\u6709\u627e\u5230\u5386\u53f2\u62a5\u544a\u7684\u5165\u53e3\u5206\u7c7b\u6807\u51c6\u6587\u4ef6\uff01");
                    return false;
                }
                try {
                    String string2;
                    if (string.startsWith("/")) {
                        string = string.substring(1);
                    }
                    string = String.valueOf(ZipStream.FILE_DOMAIN) + string;
                    string2 = this.q != null ? XbrlLoader.create((TaxonomySet)this.q) : new XbrlLoader();
                    string2.getHandlerContext().setXmlResolver(xbrlUrlResolver);
                    string2.getHandlerContext().setDefaultSilence(true);
                    string2.load(string);
                    taxonomySet = string2.getActiveDTS();
                    xbrlSchema = null;
                    XmlSchema[] xmlSchemaArray = taxonomySet.getSchemas();
                    n = xmlSchemaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        XbrlSchema xbrlSchema2;
                        xmlSchema = xmlSchemaArray[n2];
                        if (xmlSchema instanceof XbrlSchema && !(xbrlSchema2 = (XbrlSchema)xmlSchema).isReadOnly()) {
                            xbrlSchema = xbrlSchema2;
                            break;
                        }
                        ++n2;
                    }
                    if (xbrlSchema != null) break block14;
                    IOHelper.writeMessage((OutputStream)this.out, (String)"\u6ca1\u6709\u627e\u5230\u5386\u53f2\u62a5\u544a\u7684\u5165\u53e3\u6a21\u5f0f\u6587\u4ef6\uff01");
                    return false;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    IOHelper.writeMessage((OutputStream)this.out, (String)exception.getMessage());
                    return false;
                }
            }
            xmlSchema = this.getSingleEntry();
            if (xmlSchema != null) break block15;
            IOHelper.writeMessage((OutputStream)this.out, (String)"\u6ca1\u6709\u627e\u5230\u5f53\u524d\u62a5\u544a\u7684\u5165\u53e3\u5206\u7c7b\u6807\u51c6\u6587\u4ef6\uff01");
            return false;
        }
        OutputStream outputStream = this.out;
        this.out = null;
        this.bugFix();
        this.out = outputStream;
        n = 0;
        int n3 = 0;
        if (options.isImportConcept()) {
            n = this.a((XbrlSchema)xmlSchema, xbrlSchema, taxonomySet);
        }
        if (options.isImportRelaitonship()) {
            n3 = this.a(taxonomySet);
        }
        return n != 0 || n3 != 0;
    }

    private int a(TaxonomySet taxonomySet) {
        int n = 0;
        ArrayList<Relationship> arrayList = new ArrayList<Relationship>();
        for (RelationshipSet relationshipSet : taxonomySet.getRelationshipSets()) {
            RelationshipSet relationshipSet2;
            QName qName = relationshipSet.getExtendedName();
            boolean bl = qName.equals(QNameConstants.presentationLink);
            if (!bl && !qName.equals(QNameConstants.calculationLink) || (relationshipSet2 = this.dts.getRelationshipSet(qName, relationshipSet.getRoleURI())) == null) continue;
            String string = bl ? "http://www.xbrl.org/2003/arcrole/parent-child" : "http://www.xbrl.org/2003/arcrole/summation-item";
            IQName iQName = bl ? QNameConstants.presentationArc : QNameConstants.calculationArc;
            ExtendedLinkSummary extendedLinkSummary = null;
            for (Object e2 : relationshipSet.getFromTargets()) {
                if (!(e2 instanceof XbrlConcept)) continue;
                arrayList.clear();
                XbrlConcept xbrlConcept = (XbrlConcept)e2;
                XbrlConcept xbrlConcept2 = this.dts.getConcept(xbrlConcept.getQName());
                if (xbrlConcept2 == null) continue;
                for (Relationship relationship : relationshipSet.getEffectiveChildren(e2)) {
                    Object object;
                    Object object2;
                    XbrlConcept xbrlConcept3;
                    XbrlConcept xbrlConcept4;
                    if (!relationship.isOptional() || !(relationship.arc() instanceof PresentationArc) || (xbrlConcept4 = relationship.toConcept()) == null || (xbrlConcept3 = this.dts.getConcept(xbrlConcept4.getQName())) == null) continue;
                    Relationship relationship2 = null;
                    relationship2 = bl ? this.a(relationshipSet2, (Object)xbrlConcept2, xbrlConcept3, relationship) : this.b(relationshipSet2, xbrlConcept2, xbrlConcept3, relationship);
                    if (relationship2 != null) {
                        arrayList.add(relationship2);
                        continue;
                    }
                    if (extendedLinkSummary == null) {
                        object2 = this.c(relationshipSet2);
                        if (object2 == null) continue;
                        extendedLinkSummary = new ExtendedLinkSummary((ExtendedLink)object2, this.dts);
                    }
                    object2 = arrayList.isEmpty() ? BigDecimal.ZERO : ((Relationship)arrayList.get(arrayList.size() - 1)).arc().getOrder();
                    object2 = ((BigDecimal)object2).add(a);
                    relationship2 = extendedLinkSummary.addRelationship(xbrlConcept2, xbrlConcept3, (QName)iQName, string, ((BigDecimal)object2).toPlainString());
                    if (bl) {
                        object = ((PresentationArc)relationship.arc()).getPreferredLabel();
                        if (!StringUtils.isEmpty((String)object)) {
                            ((PresentationArc)relationship2.arc()).setAttribute((QName)QNameConstants.preferredLabel, (String)object);
                        }
                    } else {
                        object = ((CalculationArc)relationship.arc()).getWeight();
                        ((CalculationArc)relationship2.arc()).setAttribute((QName)QNameConstants.weight, ((BigDecimal)object).toPlainString());
                    }
                    ++n;
                    arrayList.add(relationship2);
                }
            }
        }
        IOHelper.writeMessage((OutputStream)this.out, (String)("\u5bfc\u5165" + n + "\u4e2a\u5143\u7d20\u5173\u7cfb\uff1b"));
        if (n != 0) {
            this._hasBugFixed = true;
        }
        return n;
    }

    private Relationship a(RelationshipSet relationshipSet, Object object, Object object2, Relationship relationship) {
        for (Relationship relationship2 : relationshipSet.getEffectiveChildren(object)) {
            if (relationship2.toTarget() != object2 || !relationship2.isOptional() || !(relationship2.arc() instanceof PresentationArc)) continue;
            PresentationArc presentationArc = (PresentationArc)relationship2.arc();
            PresentationArc presentationArc2 = (PresentationArc)relationship.arc();
            if (!presentationArc.getPreferredLabel().equals(presentationArc2.getPreferredLabel())) continue;
            return relationship2;
        }
        return null;
    }

    private Relationship b(RelationshipSet relationshipSet, Object object, Object object2, Relationship relationship) {
        for (Relationship relationship2 : relationshipSet.getEffectiveChildren(object)) {
            if (relationship2.toTarget() != object2 || !relationship2.isOptional()) continue;
            return relationship2;
        }
        return null;
    }

    private int a(XbrlSchema xbrlSchema, XbrlSchema xbrlSchema2, TaxonomySet taxonomySet) {
        int n = 0;
        for (Map.Entry entry : xbrlSchema2.getElements().entrySet()) {
            QName qName = (QName)entry.getKey();
            XmlSchemaElement xmlSchemaElement = xbrlSchema.getElementByName(qName.getLocalPart());
            if (xmlSchemaElement != null || !(entry.getValue() instanceof XbrlConcept) || !this.a((XbrlConcept)entry.getValue(), xbrlSchema, taxonomySet)) continue;
            ++n;
        }
        IOHelper.writeMessage((OutputStream)this.out, (String)("\u5bfc\u5165" + n + "\u4e2a\u6269\u5c55\u5143\u7d20\uff1b"));
        if (n != 0) {
            this._hasBugFixed = true;
        }
        return n;
    }

    private boolean a(XbrlConcept xbrlConcept, XbrlSchema xbrlSchema, TaxonomySet taxonomySet) {
        if (this.C == null) {
            this.C = taxonomySet.getLabelRelationships();
        }
        if (this.C == null || this.C.size() == 0) {
            return false;
        }
        String string = xbrlSchema.getTargetNamespace();
        String string2 = xbrlConcept.getName();
        XbrlConcept xbrlConcept2 = new XbrlConcept((XmlSchema)xbrlSchema, true);
        xbrlConcept2.setName(string2);
        xbrlConcept2.setSchemaTypeName(xbrlConcept.getSchemaTypeName());
        xbrlConcept2.setId(String.valueOf(xbrlSchema.getPrefixOfNamespace(string)) + "_" + string2);
        xbrlConcept2.setPeriodType(xbrlConcept.getPeriodType());
        xbrlConcept2.setBalance(xbrlConcept.getBalance());
        xbrlConcept2.setSubstitutionGroup(xbrlConcept.getSubstitutionGroup());
        xbrlConcept2.setAbstract(xbrlConcept.isAbstract());
        xbrlConcept2.setNillable(xbrlConcept.isNillable());
        xbrlConcept2.setDefaultValue(xbrlConcept.getDefaultValue());
        xbrlConcept2.setFixedValue(xbrlConcept.getFixedValue());
        XbrlHelper.processConcept((XbrlConcept)xbrlConcept2);
        boolean bl = false;
        g g2 = this.K();
        if (g2 != null) {
            for (RelationshipSet relationshipSet : this.C) {
                for (Relationship relationship : relationshipSet.getEffectiveChildren((Object)xbrlConcept)) {
                    if (!relationship.isOptional() || !(relationship.toTarget() instanceof Label)) continue;
                    bl = true;
                    Label label = (Label)relationship.toTarget();
                    this.a(xbrlConcept2, label, g2);
                }
            }
        }
        if (!bl) {
            xbrlSchema.removeItem((XmlSchemaObject)xbrlConcept2);
            return false;
        }
        return true;
    }

    private Set<Fact> av() {
        RelationshipSet relationshipSet2;
        HashSet<Fact> hashSet = new HashSet<Fact>();
        this.j = this.dts.getPresentationRelationships();
        HashSet hashSet2 = new HashSet();
        for (RelationshipSet relationshipSet2 : this.j) {
            if (!relationshipSet2.getRoleURI().endsWith("1")) continue;
            relationshipSet2.getAllConcepts(hashSet2);
        }
        relationshipSet2 = this.dts.getConcept("ifrs:ComponentsOfEquityAxis");
        this.D = relationshipSet2 != null ? relationshipSet2.getQName() : null;
        this.E = this.o != null ? this.o.getQName() : null;
        for (XbrlConcept xbrlConcept : hashSet2) {
            List<Fact> list;
            if (xbrlConcept.isAbstract() || (list = this.f.get(xbrlConcept.getQName())) == null) continue;
            block2: for (Fact fact : list) {
                for (QName qName : fact.getContext().getDimensionContents().keySet()) {
                    if ((this.E == null || !qName.equals(this.E)) && (this.D == null || !this.D.equals(qName))) continue block2;
                }
                hashSet.add(fact);
            }
        }
        return hashSet;
    }

    private void aw() {
        if (!this.getExtendMode().isRedefineMode() || this.f == null) {
            return;
        }
        HashSet hashSet = new HashSet();
        Set<Fact> set = this.av();
        block0: for (RelationshipSet relationshipSet : this.j) {
            String string;
            RelationshipSet relationshipSet2;
            String string2 = relationshipSet.getRoleURI();
            if (!string2.endsWith("4") || (relationshipSet2 = this.dts.getPresentationRelationships(string = String.valueOf(string2.substring(0, string2.length() - 1)) + "2")) != null && relationshipSet2.getRelationships().size() != 0) continue;
            hashSet.clear();
            relationshipSet.getAllConcepts(hashSet);
            for (XbrlConcept xbrlConcept : hashSet) {
                List<Fact> list;
                if (xbrlConcept.isAbstract() || (list = this.f.get(xbrlConcept.getQName())) == null) continue;
                for (Fact fact : list) {
                    if (!set.contains(fact)) continue block0;
                }
            }
            relationshipSet.purgeOrProhibitTargets(hashSet);
            this.b.add(relationshipSet);
            for (RelationshipSet relationshipSet3 : this.c(string2)) {
                relationshipSet3.purgeOrProhibitTargets(hashSet);
                this.b.add(relationshipSet3);
            }
            for (RelationshipSet relationshipSet4 : this.b(string2)) {
                relationshipSet4.purgeOrProhibitTargets(hashSet);
                this.b.add(relationshipSet4);
            }
        }
        this.rebuildRelationshipSet();
    }

    protected void bugFixRemoveDuplicateFacts() {
        try {
            c c2;
            if (this.dts == null || this.f == null || this.xbrlInstance == null) {
                return;
            }
            List list = this.xbrlInstance.getContexts();
            this.G = new HashMap<c, List<Context>>(list.size());
            this.F = new HashMap<Context, c>();
            List<Context> list2 = null;
            for (Context object : list) {
                c2 = new c(object);
                this.F.put(object, c2);
                list2 = this.G.get(c2);
                if (list2 == null) {
                    list2 = new ArrayList<Context>(2);
                    list2.add(object);
                    this.G.put(c2, list2);
                    continue;
                }
                list2.add(object);
            }
            for (Map.Entry entry : this.f.entrySet()) {
                c2 = this.dts.getConcept((QName)entry.getKey());
                if (c2 == null || !c2.isItem()) continue;
                this.a((XbrlConcept)c2, (List)entry.getValue());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected Context getUniqueContext(Context c2) {
        if (c2 == null) {
            return null;
        }
        c c3 = this.F.get(c2);
        if (c3 == null) {
            return c2;
        }
        List<Context> list = this.G.get(c3);
        if (list != null) {
            return list.get(0);
        }
        return c2;
    }

    private void a(XbrlConcept xbrlConcept, List<Fact> list) {
        List<Fact> list2;
        Object object;
        if (list == null || list.size() < 2) {
            return;
        }
        this.H.clear();
        boolean bl = false;
        for (Fact object2 : list) {
            object = net.gbicc.xbrl.cleaner.CasCleaner$e.a(object2, this.getUniqueContext(object2.getContext()));
            Object object3 = this.H.get(object);
            if (object3 != null) {
                if (object3 instanceof Fact) {
                    list2 = new ArrayList<Fact>();
                    list2.add((Fact)object3);
                    list2.add(object2);
                    this.H.put((e)object, list2);
                } else if (object3 instanceof List) {
                    list2 = (List)object3;
                    list2.add(object2);
                }
                bl = true;
                continue;
            }
            this.H.put((e)object, object2);
        }
        if (bl) {
            for (Object object4 : this.H.values()) {
                if (!(object4 instanceof List) || (object = (List)object4).size() <= 1) continue;
                int n = 1;
                while (n < object.size()) {
                    list2 = (Fact)object.get(n);
                    list2.getParent().removeChild(list2);
                    this._hasBugFixed = true;
                    ++n;
                }
            }
        }
    }

    private void ax() {
        QName qName;
        if (this.dts == null) {
            return;
        }
        if (this.j == null) {
            this.j = this.dts.getPresentationRelationships();
        }
        for (RelationshipSet relationshipSet : this.dts.getDefinitionRelationships()) {
            if (this.f(relationshipSet.getRoleURI()).size() != 0) continue;
            ArrayList<ExtendedLink> arrayList = new ArrayList<ExtendedLink>();
            qName = relationshipSet.getRelationships().toArray(new Relationship[relationshipSet.getRelationships().size()]);
            int n = ((Relationship[])qName).length;
            int n2 = 0;
            while (n2 < n) {
                QName qName2 = qName[n2];
                ExtendedLink extendedLink = qName2.arc().getOwnerExtended();
                relationshipSet.purgeOrProhibitRelationship((Relationship)qName2);
                if (!arrayList.contains(extendedLink)) {
                    arrayList.add(extendedLink);
                }
                ++n2;
            }
            for (ExtendedLink extendedLink : arrayList) {
                if (extendedLink.getParent() == null) continue;
                extendedLink.getOwnerDocument().setModified(true);
                extendedLink.getParent().removeChild((XdmNode)extendedLink);
            }
            this.dts.getRelationshipSets().remove(relationshipSet);
        }
        IXbrlDocument[] iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n3 = 0;
        while (n3 < n) {
            RelationshipSet relationshipSet;
            relationshipSet = iXbrlDocumentArray[n3];
            Linkbase linkbase = XbrlHelper.getLinkbase((IXbrlDocument)relationshipSet);
            if (linkbase != null) {
                XdmNode xdmNode = linkbase.getFirstChild();
                while (xdmNode != null) {
                    if (xdmNode.isElement() && !(qName = xdmNode.getNodeName()).equals(QNameConstants.roleRef) && !qName.equals(QNameConstants.arcroleRef)) {
                        if (!qName.equals(QNameConstants.definitionLink)) break;
                        boolean bl = false;
                        XdmNode xdmNode2 = xdmNode.getFirstChild();
                        while (xdmNode2 != null) {
                            if (xdmNode2 instanceof Arc) {
                                bl = true;
                                break;
                            }
                            xdmNode2 = xdmNode2.getNextSibling();
                        }
                        if (!bl) {
                            linkbase.removeChild(xdmNode);
                            linkbase.getOwnerDocument().setModified(true);
                        }
                    }
                    xdmNode = xdmNode.getNextSibling();
                }
            }
            ++n3;
        }
        this.l = this.dts.getDefinitionRelationships();
    }

    private void ay() {
        if (this.dts == null) {
            return;
        }
        for (RelationshipSet relationshipSet : this.dts.getPresentationRelationships()) {
            relationshipSet.purgeOrphanRoots();
        }
        for (RelationshipSet relationshipSet : this.dts.getDefinitionRelationships()) {
            relationshipSet.purgeOrphanRoots();
        }
        for (RelationshipSet relationshipSet : this.dts.getCalculationRelationships()) {
            relationshipSet.purgeOrphanRoots();
        }
    }

    @Override
    public boolean bugFixTextBlock() {
        if (this.xbrlInstance == null) {
            return false;
        }
        boolean bl = false;
        XdmNode xdmNode = this.xbrlInstance.getFirstChild();
        while (xdmNode != null) {
            QName qName;
            Fact fact;
            XbrlConcept xbrlConcept;
            if (xdmNode instanceof Fact && (xbrlConcept = (fact = (Fact)xdmNode).getConcept()) != null && (qName = xbrlConcept.getSchemaTypeName()) != null && (QNameConstants.nonnumEscapedItemType.equals((Object)qName) || QNameConstants.nonnumTextBlockItemType.equals((Object)qName))) {
                String string = fact.getInnerText();
                Pattern pattern = Pattern.compile("<TABLE style='MARGIN: auto auto auto -.*pt;'");
                Matcher matcher = pattern.matcher(string);
                if (matcher.find()) {
                    string = string.replaceAll("<TABLE style='MARGIN: auto auto auto -.*pt;'", "<TABLE style=''");
                    fact.setInnerText(string);
                    bl = true;
                }
            }
            xdmNode = xdmNode.getNextSibling();
        }
        return bl;
    }

    private void az() {
        String string;
        XbrlConcept xbrlConcept;
        XbrlSchema[] xbrlSchemaArray;
        if (this.xbrlInstance == null) {
            return;
        }
        if (this.f == null) {
            this.f = this.xbrlInstance.getFacts(true);
        }
        String string2 = "http://xbrl.mof.gov.cn/taxonomy/2015-03-31/cas";
        String string3 = "http://xbrl.ifrs.org/taxonomy/2014-03-05/ifrs-full";
        if (this.dts.getSchema(string2) != null && this.dts.getSchema(string3) != null) {
            xbrlSchemaArray = this.getEntrySchema();
            int n = xbrlSchemaArray.length;
            int n2 = 0;
            while (n2 < n) {
                xbrlConcept = xbrlSchemaArray[n2];
                string = xbrlConcept.getNamespaceOfPrefix("ifrs");
                if (!StringUtils.isEmpty((String)string)) {
                    xbrlConcept.getNamespaceContext().remove("ifrs", string);
                    xbrlConcept.getNamespaceContext().add("ifrs-full", string3);
                    xbrlConcept.setModified(true);
                }
                ++n2;
            }
        }
        if ((xbrlConcept = this.dts.getConcept("ifrs:NameOfReportingEntityOrOtherMeansOfIdentification")) != null) {
            XbrlConcept xbrlConcept2 = xbrlConcept;
            List<Fact> list = this.f.get(xbrlConcept.getQName());
            if ((list == null || list.size() == 0) && (xbrlConcept = this.dts.getConcept("ifrs-full:NameOfReportingEntityOrOtherMeansOfIdentification")) != null) {
                list = this.f.get(xbrlConcept.getQName());
                xbrlSchemaArray = this.getEntrySchema();
                if (list != null && list.size() > 0 && xbrlConcept2 != xbrlConcept && xbrlSchemaArray != null && xbrlSchemaArray.length == 1) {
                    string = xbrlSchemaArray[0];
                    String string4 = xbrlConcept.getSchema().getTargetNamespace();
                    String string5 = xbrlConcept.getSchema().getSourceURI();
                    String string6 = xbrlConcept2.getSchema().getTargetNamespace();
                    for (XmlSchemaExternal xmlSchemaExternal : string.getExternals()) {
                        XmlSchemaImport xmlSchemaImport;
                        if (!(xmlSchemaExternal instanceof XmlSchemaImport) || !StringUtils.equals((String)string6, (String)(xmlSchemaImport = (XmlSchemaImport)xmlSchemaExternal).getNamespace()) || !string5.startsWith("http://")) continue;
                        xmlSchemaImport.setNamespace(string4);
                        xmlSchemaImport.setSchemaLocation(string5);
                        String string7 = string;
                        string7.setModified(true);
                        string7.getNamespaceContext().remove("ifrs", string6);
                        string7.getNamespaceContext().remove("ifrs-full", string4);
                        break;
                    }
                }
            }
        }
    }

    static class a {
        private QName a;
        private RelationshipSet b;
        private int c;

        public a(QName qName, RelationshipSet relationshipSet) {
            this.a = qName;
            this.b = relationshipSet;
        }

        public int hashCode() {
            if (this.c == 0) {
                this.c = this.a.hashCode() * 31 + this.b.hashCode();
            }
            return this.c;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof a) {
                a a2 = (a)o;
                return a2.a.equals(this.a) && a2.b == this.b;
            }
            return false;
        }
    }

    class b {
        private Map<String, String> b = new HashMap<String, String>();
        private Map<String, String> c = new HashMap<String, String>();
        private List<Context> d;

        b() {
            this.d = new ArrayList<Context>(CasCleaner.this.xbrlInstance.getContexts());
        }

        private Context c(Context context) {
            String string;
            block6: {
                if (context == null || context.getPeriodType() == PeriodType.Instant) {
                    return context;
                }
                string = context.getPeriod().getEndDate();
                if (!StringUtils.isEmpty((String)string)) break block6;
                return null;
            }
            try {
                Scenario scenario = context.getScenario();
                for (Context context2 : this.d) {
                    Scenario scenario2;
                    Period period;
                    String string2;
                    if (context2 == context || context2.getPeriodType() == PeriodType.Duration || !string.equals(string2 = (period = context2.getPeriod()).getInstant()) || !context2.getEntity().XdtEqual(context.getEntity()) || scenario != (scenario2 = context2.getScenario()) && (scenario == null || !scenario.XdtEqual((OpenContextComponent)scenario2))) continue;
                    return context2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            string = this.f(context);
            if (string != null) {
                this.d.add((Context)string);
            }
            return string;
        }

        private Context d(Context context) {
            String string;
            block6: {
                if (context == null || context.getPeriodType() == PeriodType.Duration) {
                    return context;
                }
                string = context.getPeriod().getInstant();
                if (!StringUtils.isEmpty((String)string)) break block6;
                return null;
            }
            try {
                Scenario scenario = context.getScenario();
                for (Context context2 : this.d) {
                    Scenario scenario2;
                    Period period;
                    String string2;
                    if (context2 == context || context2.getPeriodType() == PeriodType.Instant || !string.equals(string2 = (period = context2.getPeriod()).getEndDate()) || !context2.getEntity().XdtEqual(context.getEntity()) || scenario != (scenario2 = context2.getScenario()) && (scenario == null || !scenario.XdtEqual((OpenContextComponent)scenario2))) continue;
                    return context2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            string = this.g(context);
            if (string != null) {
                this.d.add((Context)string);
            }
            return string;
        }

        private String e(Context context) {
            Object object;
            XdmNode xdmNode;
            StringBuilder stringBuilder = new StringBuilder();
            Period period = context.getPeriod();
            if (context.getPeriodType() == PeriodType.Instant) {
                stringBuilder.append("c_instant_").append(period.getInstant());
            } else {
                stringBuilder.append("c_duration_").append(period.getStartDate()).append("_").append(period.getEndDate());
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (context.getSegment() != null) {
                xdmNode = context.getSegment().getFirstChild();
                while (xdmNode != null) {
                    if (xdmNode.getNodeNature() == 2) {
                        if (xdmNode instanceof ExplicitMember) {
                            object = (ExplicitMember)xdmNode;
                            arrayList.add(String.valueOf(object.getDimension().getLocalPart()) + "_" + object.getDimensionContent().getLocalPart());
                        } else if (xdmNode instanceof TypedMember) {
                            object = (TypedMember)xdmNode;
                            arrayList.add(String.valueOf(object.getDimension().getLocalPart()) + "_" + object.getInnerText());
                        } else {
                            arrayList.add(String.valueOf(xdmNode.getLocalName()) + "_" + xdmNode.getInnerText());
                        }
                    }
                    xdmNode = xdmNode.getNextSibling();
                }
            }
            if (context.getScenario() != null) {
                xdmNode = context.getScenario().getFirstChild();
                while (xdmNode != null) {
                    if (xdmNode.getNodeNature() == 2) {
                        if (xdmNode instanceof ExplicitMember) {
                            object = (ExplicitMember)xdmNode;
                            arrayList.add(String.valueOf(object.getDimension().getLocalPart()) + "_" + object.getDimensionContent().getLocalPart());
                        } else if (xdmNode instanceof TypedMember) {
                            object = (TypedMember)xdmNode;
                            arrayList.add(String.valueOf(object.getDimension().getLocalPart()) + "_" + object.getInnerText());
                        } else {
                            arrayList.add(String.valueOf(xdmNode.getLocalName()) + "_" + xdmNode.getInnerText());
                        }
                    }
                    xdmNode = xdmNode.getNextSibling();
                }
            }
            xdmNode = arrayList.toArray(new String[arrayList.size()]);
            Arrays.sort((Object[])xdmNode);
            XdmNode xdmNode2 = xdmNode;
            int n = ((XdmNode)xdmNode2).length;
            int n2 = 0;
            while (n2 < n) {
                object = xdmNode2[n2];
                stringBuilder.append("_").append((String)object);
                ++n2;
            }
            object = stringBuilder.toString();
            object = ((String)object).replace("-", "");
            object = ((String)object).replace(" ", "");
            return object;
        }

        private Context f(Context context) {
            try {
                Object object;
                Context context2 = CasCleaner.this.xbrlInstance.createContext();
                XbrlDocument xbrlDocument = CasCleaner.this.xbrlInstance.getOwnerDocument();
                Entity entity = (Entity)xbrlDocument.importNode((Node)context.getEntity(), true);
                context2.appendChild((XdmNode)entity);
                Period period = context2.createPeriod();
                Instant instant = period.createInstant();
                instant.setInnerText(context.getPeriod().getEndDate());
                period.appendChild((XdmNode)instant);
                context2.appendChild((XdmNode)period);
                Scenario scenario = context.getScenario();
                if (scenario != null) {
                    object = (Scenario)xbrlDocument.importNode((Node)scenario, true);
                    context2.appendChild((XdmNode)object);
                }
                context.getParent().insertBefore((XdmNode)context2, (XdmNode)context);
                Object object2 = object = this.e(context2);
                int n = 1;
                if (xbrlDocument.getElementById((String)object2) != null) {
                    object2 = String.valueOf(object) + ++n;
                }
                context2.setId((String)object2);
                return context2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        private Context g(Context context) {
            try {
                Object object;
                Context context2 = CasCleaner.this.xbrlInstance.createContext();
                XbrlDocument xbrlDocument = CasCleaner.this.xbrlInstance.getOwnerDocument();
                Entity entity = (Entity)xbrlDocument.importNode((Node)context.getEntity(), true);
                context2.appendChild((XdmNode)entity);
                Period period = context2.createPeriod();
                String string = context.getPeriod().getInstant();
                StartDate startDate = period.createStartDate();
                startDate.setInnerText(String.valueOf(string.substring(0, 4)) + "-01-01");
                period.appendChild((XdmNode)startDate);
                EndDate endDate = period.createEndDate();
                endDate.setInnerText(string);
                period.appendChild((XdmNode)endDate);
                context2.appendChild((XdmNode)period);
                Scenario scenario = context.getScenario();
                if (scenario != null) {
                    object = (Scenario)xbrlDocument.importNode((Node)scenario, true);
                    context2.appendChild((XdmNode)object);
                }
                context.getParent().insertBefore((XdmNode)context2, (XdmNode)context);
                Object object2 = object = this.e(context2);
                int n = 1;
                if (xbrlDocument.getElementById((String)object2) != null) {
                    object2 = String.valueOf(object) + ++n;
                }
                context2.setId((String)object2);
                return context2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public String a(Context context) {
            String string = context.getId();
            String string2 = this.b.get(string);
            if (string2 == null) {
                Context context2 = this.c(context);
                String string3 = context2 == null ? "" : context2.getId();
                this.b.put(string, string3);
                if (!StringUtils.isEmpty((String)string3)) {
                    this.c.put(string3, string);
                }
                return string3;
            }
            return string2;
        }

        public String b(Context context) {
            String string = context.getId();
            String string2 = this.c.get(string);
            if (string2 == null) {
                Context context2 = this.d(context);
                String string3 = context2 == null ? "" : context2.getId();
                this.c.put(string, string3);
                if (!StringUtils.isEmpty((String)string3)) {
                    this.b.put(string3, string);
                }
                return string3;
            }
            return string2;
        }
    }

    private static class c {
        private int a;
        private Context b;

        public c(Context context) {
            this.b = context;
            this.a = context.computeHashCode();
        }

        public int hashCode() {
            return this.a;
        }

        public boolean equals(Object o) {
            c c2;
            c c3 = c2 = o instanceof c ? (c)o : null;
            if (c2 == null) {
                return false;
            }
            if (c2.b == this.b) {
                return true;
            }
            return this.b.XdtEqual(c2.b);
        }
    }

    private static class d {
        final XbrlConcept a;
        Set<Object> b = new HashSet<Object>();
        MutableInteger c = new MutableInteger();
        Set<XbrlConcept> d = new HashSet<XbrlConcept>();
        Set<XbrlConcept> e = new HashSet<XbrlConcept>();
        Set<XbrlConcept> f = new HashSet<XbrlConcept>();
        Set<XbrlConcept> g = new HashSet<XbrlConcept>();

        d(XbrlConcept xbrlConcept) {
            this.a = xbrlConcept;
        }
    }

    static class e {
        XbrlConcept a;
        XdmElement b;
        Unit c;
        Context d;
        private int e;

        e() {
        }

        public static e a(Fact fact, Context context) {
            e e2 = new e();
            e2.a = fact.getConcept();
            e2.b = fact.getParent();
            e2.c = fact.getUnit();
            e2.d = context;
            return e2;
        }

        public boolean equals(Object o) {
            if (o instanceof e) {
                e e2 = (e)o;
                if (o.hashCode() == e2.hashCode()) {
                    return this.d == e2.d && this.c == e2.c && this.a == e2.a && this.b == e2.b;
                }
            }
            return false;
        }

        public int hashCode() {
            if (this.e == 0) {
                this.e = (this.d != null ? this.d.hashCode() : 0) + (this.c == null ? 0 : this.c.hashCode()) * 10 + this.b.hashCode() * 1000 + this.a.hashCode() * 10000;
            }
            return this.e;
        }
    }

    static class f {
        int a;
        private String b;
        private String c;

        f() {
        }

        public String a() {
            return this.c;
        }

        public void a(String string) {
            this.c = string != null ? string : "";
            this.a = 0;
        }

        public String b() {
            return this.b;
        }

        public void b(String string) {
            this.b = string != null ? string : "";
            this.a = 0;
        }

        public int hashCode() {
            if (this.a == 0) {
                this.a = this.b().hashCode() + this.a().hashCode() * 17;
            }
            return this.a;
        }

        public boolean equals(Object oth) {
            if (oth instanceof f) {
                f f2 = (f)oth;
                return this.b.equals(f2.b) && this.c.equals(f2.c);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class g {
        XbrlDocument a = null;
        XbrlDocument b = null;
        Map<ExtendedLink, ExtendedLinkSummary> c = null;

        g() {
        }

        void a(boolean bl) {
            this.a(this.a, bl);
            this.a(this.b, bl);
        }

        private void a(XbrlDocument xbrlDocument, boolean bl) {
            XdmNode xdmNode = xbrlDocument.getDocumentElement().getFirstChild();
            while (xdmNode != null) {
                if (xdmNode instanceof LabelLink) {
                    ((LabelLink)xdmNode).optimzeDelete(bl);
                }
                xdmNode = xdmNode.getNextSibling();
            }
        }

        public boolean a() {
            return this.a == null || this.b == null;
        }

        private void a(XbrlDocument xbrlDocument, Map<ExtendedLink, ExtendedLinkSummary> map) {
            XdmNode xdmNode = xbrlDocument.getDocumentElement().getFirstChild();
            while (xdmNode != null) {
                if (xdmNode instanceof ExtendedLink) {
                    ExtendedLink extendedLink = (ExtendedLink)xdmNode;
                    map.put(extendedLink, new ExtendedLinkSummary(extendedLink, CasCleaner.this.dts));
                }
                xdmNode = xdmNode.getNextSibling();
            }
        }

        public Map<ExtendedLink, ExtendedLinkSummary> b() {
            this.c = new HashMap<ExtendedLink, ExtendedLinkSummary>();
            this.a(this.a, this.c);
            this.a(this.b, this.c);
            return this.c;
        }
    }

    static class h {
        private String b;
        private LinkbaseRef c;
        private Linkbase d;
        public boolean a;

        h() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class i
    implements Comparator<RelationshipSet> {
        private i() {
        }

        public int a(RelationshipSet relationshipSet, RelationshipSet relationshipSet2) {
            String string = relationshipSet.getRoleURI();
            String string2 = relationshipSet2.getRoleURI();
            return string.compareTo(string2);
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((RelationshipSet)object, (RelationshipSet)object2);
        }
    }

    static class j {
        XbrlConcept a;
        RelationshipSet b;
        RelationshipSet c;
        XbrlConcept d;
        Relationship e;
        Relationship f;
        ExtendedLinkSummary g;

        public String toString() {
            return this.d + " ->" + this.a;
        }

        public int hashCode() {
            return this.a.getQName().hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof j) {
                j j2 = (j)o;
                if (j2.d == this.d && j2.a == this.a) {
                    return true;
                }
            }
            return false;
        }

        j(XbrlConcept xbrlConcept, XbrlConcept xbrlConcept2, RelationshipSet relationshipSet) {
            this.d = xbrlConcept;
            this.a = xbrlConcept2;
            this.b = relationshipSet;
        }
    }
}

