/*
 * Decompiled with CFR 0.152.
 */
package net.gbicc.xbrl.cleaner;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.gbicc.xbrl.cleaner.ChangeConceptInfo;
import net.gbicc.xbrl.core.Arc;
import net.gbicc.xbrl.core.ArcEnd;
import net.gbicc.xbrl.core.ArcroleRef;
import net.gbicc.xbrl.core.ArcroleType;
import net.gbicc.xbrl.core.Context;
import net.gbicc.xbrl.core.Definition;
import net.gbicc.xbrl.core.EndDate;
import net.gbicc.xbrl.core.ExtendedLink;
import net.gbicc.xbrl.core.ExtendedLinkSummary;
import net.gbicc.xbrl.core.Fact;
import net.gbicc.xbrl.core.Footnote;
import net.gbicc.xbrl.core.FootnoteLink;
import net.gbicc.xbrl.core.IXbrlDocument;
import net.gbicc.xbrl.core.Instant;
import net.gbicc.xbrl.core.Linkbase;
import net.gbicc.xbrl.core.Loc;
import net.gbicc.xbrl.core.LogWatch;
import net.gbicc.xbrl.core.Pair;
import net.gbicc.xbrl.core.Period;
import net.gbicc.xbrl.core.PeriodType;
import net.gbicc.xbrl.core.ProcessContext;
import net.gbicc.xbrl.core.QNameConstants;
import net.gbicc.xbrl.core.Relationship;
import net.gbicc.xbrl.core.RelationshipSet;
import net.gbicc.xbrl.core.Resource;
import net.gbicc.xbrl.core.RoleRef;
import net.gbicc.xbrl.core.RoleType;
import net.gbicc.xbrl.core.StartDate;
import net.gbicc.xbrl.core.TaxonomySet;
import net.gbicc.xbrl.core.Unit;
import net.gbicc.xbrl.core.UsedOn;
import net.gbicc.xbrl.core.XbrlConcept;
import net.gbicc.xbrl.core.XbrlContentType;
import net.gbicc.xbrl.core.XbrlDocument;
import net.gbicc.xbrl.core.XbrlElement;
import net.gbicc.xbrl.core.XbrlHelper;
import net.gbicc.xbrl.core.XbrlInstance;
import net.gbicc.xbrl.core.XbrlSchema;
import net.gbicc.xbrl.core.dimension.XdtConstants;
import net.gbicc.xbrl.core.dimension.XdtProcessor;
import net.gbicc.xbrl.filing.ExtendMode;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.QName;
import system.qizx.api.DataModelException;
import system.qizx.api.ItemSequence;
import system.qizx.api.Node;
import system.qizx.xdm.XdmElement;
import system.qizx.xdm.XdmNode;
import system.xml.NameTable;
import system.xml.XmlNameTable;
import system.xml.schema.XmlSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Cleaner {
    protected final boolean byInstance;
    protected final XbrlInstance xbrlInstance;
    protected final TaxonomySet dts;
    protected XbrlSchema[] _entrySchemas;
    protected String extendNamespaceURI;
    private ExtendMode a;
    Collection<RelationshipSet> b = new HashSet<RelationshipSet>();
    private String c;
    private String d;
    protected OutputStream out;
    private Document e;
    private boolean f;
    private static QName g = QName.get((String)"roleURI");
    private static QName h = QName.get((String)"rootElement");
    protected Collection<String> removedRoleTypes = new HashSet<String>();
    protected boolean _hasBugFixed;
    private ProcessContext i;
    private Set<Linkbase> j;
    protected TargetAction _targetAction = TargetAction.None;
    private List<FootnoteLink> k;
    protected Collection<RelationshipSet> genericLinkRS;

    public String getCurrentFiscalYearEndDate() {
        return this.c;
    }

    protected void clearUnusedContextAndUnit() {
        boolean bl;
        String string;
        if (this.xbrlInstance == null) {
            return;
        }
        List list = this.xbrlInstance.getUnits();
        List list2 = this.xbrlInstance.getContexts();
        Map map = this.xbrlInstance.getAllFacts(true);
        for (Unit unit : list) {
            string = unit.getId();
            bl = false;
            block1: for (List list3 : map.values()) {
                for (Fact fact : list3) {
                    if (!StringUtils.equals((String)string, (String)fact.getUnitRef())) continue;
                    bl = true;
                    continue block1;
                }
            }
            if (bl) continue;
            unit.getParent().removeChild((XdmNode)unit);
        }
        for (Unit unit : list2) {
            string = unit.getId();
            bl = false;
            block4: for (List list3 : map.values()) {
                for (Fact fact : list3) {
                    if (!StringUtils.equals((String)string, (String)fact.getContextRef())) continue;
                    bl = true;
                    continue block4;
                }
            }
            if (bl) continue;
            unit.getParent().removeChild((XdmNode)unit);
        }
    }

    public void setCurrentFiscalYearEndDate(String currentFiscalYearEndDate) {
        this.c = currentFiscalYearEndDate;
    }

    protected boolean isCurrentFiscalYearComplete() {
        return !StringUtils.isEmpty((String)this.c) && this.c.startsWith("--") && !StringUtils.isEmpty((String)this.d) && this.d.startsWith("--");
    }

    public String getCurrentFiscalYearStartDate() {
        return this.d;
    }

    public void setCurrentFiscalYearStartDate(String currentFiscalYearStartDate) {
        this.d = currentFiscalYearStartDate;
    }

    public abstract boolean changeConceptNameAndLabel(List<ChangeConceptInfo> var1);

    public void setLogStream(OutputStream out) {
        this.out = out;
    }

    public void setMenuDocument(Document menu) {
        this.e = menu;
    }

    public Document getMenuDocument() {
        return this.e;
    }

    public boolean isMenuChanged() {
        return this.f;
    }

    protected void changeMenuRoleURI(String oldURI, String newURI) {
        if (this.e == null || StringUtils.isEmpty((String)oldURI) || StringUtils.isEmpty((String)newURI)) {
            return;
        }
        this.a(this.e.getRootElement(), oldURI, newURI);
    }

    public void changeRoleURIs() {
    }

    private void a(Element element, String string, String string2) {
        for (Object e2 : element.elements()) {
            Element element2 = (Element)e2;
            Attribute attribute = element2.attribute(g);
            if (attribute != null && string.equals(attribute.getValue())) {
                attribute.setValue(string2);
                this.f = true;
            }
            this.a(element2, string, string2);
        }
    }

    protected XbrlSchema getSingleEntry() {
        XbrlSchema[] xbrlSchemaArray = this.getEntrySchema();
        if (xbrlSchemaArray != null && xbrlSchemaArray.length > 0) {
            XbrlSchema[] xbrlSchemaArray2 = xbrlSchemaArray;
            int n = xbrlSchemaArray.length;
            int n2 = 0;
            while (n2 < n) {
                XbrlSchema xbrlSchema = xbrlSchemaArray2[n2];
                if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                    return xbrlSchema;
                }
                ++n2;
            }
        }
        return null;
    }

    protected void changeMenuConcept(String oldQName, String newQName) {
        String string;
        if (this.e == null || StringUtils.isEmpty((String)oldQName) || StringUtils.isEmpty((String)newQName)) {
            return;
        }
        XbrlSchema xbrlSchema = this.getSingleEntry();
        if (xbrlSchema == null) {
            return;
        }
        if (!oldQName.contains(":")) {
            string = xbrlSchema.getPrefixOfNamespace(this.extendNamespaceURI);
            if (StringUtils.isEmpty((String)string)) {
                return;
            }
            oldQName = String.valueOf(string) + ":" + oldQName;
        }
        if (!newQName.contains(":")) {
            string = xbrlSchema.getPrefixOfNamespace(this.extendNamespaceURI);
            if (StringUtils.isEmpty((String)string)) {
                return;
            }
            newQName = String.valueOf(string) + ":" + newQName;
        }
        if ((string = this.dts.getConcept(newQName)) == null) {
            return;
        }
        this.b(this.e.getRootElement(), oldQName.replace(":", "_"), newQName.replace(":", "_"));
    }

    private void b(Element element, String string, String string2) {
        for (Object e2 : element.elements()) {
            Element element2 = (Element)e2;
            Attribute attribute = element2.attribute(h);
            if (attribute != null && string.equals(attribute.getValue())) {
                attribute.setValue(string2);
                this.f = true;
            }
            this.b(element2, string, string2);
        }
    }

    protected void removeUnusedMenu() {
        if (this.removedRoleTypes.size() == 0 || this.xbrlInstance == null) {
            return;
        }
        try {
            boolean bl;
            XdmElement xdmElement;
            Node node;
            ItemSequence itemSequence;
            String string = this.xbrlInstance.getOwnerDocument().getBaseURI();
            string = string.startsWith("file:") ? String.valueOf(new File(new URI(string)).getParent()) + File.separator + "menu.xml" : String.valueOf(new File(string).getParent()) + File.separator + "menu.xml";
            if (!new File(string).exists()) {
                return;
            }
            XbrlDocument xbrlDocument = new XbrlDocument(string, (XmlNameTable)new NameTable());
            xbrlDocument.load(string);
            ArrayList<XdmElement> arrayList = new ArrayList<XdmElement>();
            for (String string2 : this.removedRoleTypes) {
                itemSequence = xbrlDocument.selectItems("//*[@roleURI='" + string2 + "']");
                while (itemSequence.moveToNextItem()) {
                    if (!itemSequence.isNode() || !((node = itemSequence.getNode()) instanceof XdmElement) || !(xdmElement = (XdmElement)node).getLocalName().equals("text") && !xdmElement.getLocalName().equals("table")) continue;
                    arrayList.add(xdmElement);
                }
            }
            for (XdmElement xdmElement2 : arrayList) {
                xdmElement2.getParent().removeChild((XdmNode)xdmElement2);
            }
            this.removedRoleTypes.clear();
            boolean bl2 = true;
            while (bl) {
                bl = false;
                Iterator<String> iterator = xbrlDocument.selectItems("/menu//node[not(*)]");
                while (iterator.moveToNextItem()) {
                    if (!iterator.isNode() || !((itemSequence = iterator.getNode()) instanceof XdmElement) || (xdmElement = (node = (XdmElement)itemSequence).getParent()) == null || xdmElement == xbrlDocument) continue;
                    xdmElement.removeChild((XdmNode)node);
                    bl = true;
                }
            }
            xbrlDocument.save(string);
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void reportBug(String message) {
        if (StringUtils.isEmpty((String)message)) {
            return;
        }
        if (!message.startsWith("bug")) {
            message = "bug: " + message;
        }
        System.out.println(message);
        if (this.out != null) {
            try {
                if (message != null) {
                    this.out.write(message.getBytes("UTF-8"));
                    if (!message.endsWith("\n")) {
                        this.out.write("\r\n".getBytes());
                    }
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected void fixBug(String message) {
        message = "fix: " + message;
        System.out.println(message);
        this._hasBugFixed = true;
        if (this.out != null) {
            try {
                if (message != null) {
                    this.out.write(message.getBytes("UTF-8"));
                    if (!message.endsWith("\n")) {
                        this.out.write("\r\n".getBytes());
                    }
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected void fixBug(String message, boolean forXSD) {
        if (this.byInstance) {
            if (this.out != null) {
                this.fixBug(message);
            }
        } else {
            this.fixBug(message);
        }
    }

    protected void changeFactContext(Fact newFact, XbrlConcept newConcept, Context oldCtx) {
        PeriodType periodType = newConcept.getPeriodType();
        Pair pair = oldCtx.getPeriodDuration();
        String string = ((String)pair.getValue()).substring(0, 4);
        XdmNode xdmNode = null;
        XdmNode xdmNode2 = this.xbrlInstance.getFirstChild();
        while (xdmNode2 != null) {
            if (xdmNode2 instanceof Context || xdmNode2 instanceof Unit || xdmNode2 instanceof Fact) {
                xdmNode = xdmNode2;
                break;
            }
            xdmNode2 = xdmNode2.getNextSibling();
        }
        if (periodType == PeriodType.Duration) {
            try {
                xdmNode2 = null;
                String string2 = this.d.replaceFirst("-", string);
                String string3 = this.c.replaceFirst("-", string);
                for (Context context : this.xbrlInstance.getContexts()) {
                    if (!context.XdtEqual(oldCtx, string2, string3)) continue;
                    xdmNode2 = context;
                    break;
                }
                if (xdmNode2 == null) {
                    Context context;
                    xdmNode2 = (Context)oldCtx.getOwnerDocument().importNode((Node)oldCtx, true);
                    context = xdmNode2.getPeriod();
                    context.removeAll();
                    StartDate startDate = context.createStartDate();
                    startDate.setInnerText(string2);
                    context.appendChild((XdmNode)startDate);
                    EndDate endDate = context.createEndDate();
                    endDate.setInnerText(string3);
                    context.appendChild((XdmNode)endDate);
                    this.xbrlInstance.insertBefore(xdmNode2, xdmNode);
                    xdmNode2.process(this.i);
                    String string4 = xdmNode2.getCompuatedId();
                    int n = 1;
                    String string5 = string4;
                    XbrlDocument xbrlDocument = this.xbrlInstance.getOwnerDocument();
                    while (xbrlDocument.getElementById(string5) != null) {
                        string5 = String.valueOf(string4) + ++n;
                    }
                    if (string5 != string4) {
                        string4 = string5;
                    }
                    xdmNode2.setId(string4);
                    xbrlDocument.setModified(true);
                    this.fixBug("create context " + string4);
                }
                newFact.setContextRef(xdmNode2.getId());
            }
            catch (DataModelException dataModelException) {
                dataModelException.printStackTrace();
            }
        } else if (periodType == PeriodType.Instant) {
            try {
                xdmNode2 = null;
                String string6 = (String)pair.getValue();
                for (Context context : this.xbrlInstance.getContexts()) {
                    if (!context.XdtEqual(oldCtx, null, string6)) continue;
                    xdmNode2 = context;
                    break;
                }
                if (xdmNode2 == null) {
                    Context context;
                    xdmNode2 = (Context)oldCtx.getOwnerDocument().importNode((Node)oldCtx, true);
                    context = xdmNode2.getPeriod();
                    context.removeAll();
                    Instant instant = context.createInstant();
                    instant.setInnerText(string6);
                    context.appendChild((XdmNode)instant);
                    this.xbrlInstance.insertBefore(xdmNode2, xdmNode);
                    xdmNode2.process(this.i);
                    String string7 = xdmNode2.getCompuatedId();
                    int n = 1;
                    String string8 = string7;
                    XbrlDocument xbrlDocument = this.xbrlInstance.getOwnerDocument();
                    while (xbrlDocument.getElementById(string8) != null) {
                        string8 = String.valueOf(string7) + ++n;
                    }
                    if (string8 != string7) {
                        string7 = string8;
                    }
                    xdmNode2.setId(string7);
                    xbrlDocument.setModified(true);
                    this.fixBug("create context " + string7);
                }
                newFact.setContextRef(xdmNode2.getId());
            }
            catch (DataModelException dataModelException) {
                dataModelException.printStackTrace();
            }
        }
    }

    protected ProcessContext getProcessContext() {
        if (this.i == null) {
            this.i = new ProcessContext(this.dts);
        }
        return this.i;
    }

    protected boolean canChangeContext(boolean baseInfoOK, List<Fact> facts) {
        if (!baseInfoOK) {
            return false;
        }
        if (facts == null || facts.size() == 0) {
            return true;
        }
        String string = this.d.substring(1);
        String string2 = this.c.substring(1);
        for (Fact fact : facts) {
            Context context = fact.getContext();
            if (context == null) continue;
            Period period = context.getPeriod();
            if (period == null) {
                return false;
            }
            Pair pair = period.getPeriodDuration();
            if (!StringUtils.isEmpty((String)((String)pair.getKey())) && !((String)pair.getKey()).endsWith(string)) {
                return false;
            }
            if (StringUtils.isEmpty((String)((String)pair.getValue())) || ((String)pair.getValue()).endsWith(string2)) continue;
            return false;
        }
        return true;
    }

    public void setExtendNamespaceURI(String nsURI) {
        this.extendNamespaceURI = nsURI;
    }

    public boolean bugFix() {
        return false;
    }

    public boolean reGenerateDefinitionLink() {
        return false;
    }

    public boolean clean() {
        return this.clean(true);
    }

    public boolean clean(boolean removeRelationship) {
        return this.clean(removeRelationship, false);
    }

    public boolean clean(boolean removeRelationship, boolean buildAllDomainMember) {
        return false;
    }

    public Map<String, String> renameRoleURI2013() {
        return new HashMap<String, String>(0);
    }

    public Cleaner(XbrlInstance xbrlInstance, TaxonomySet dts) {
        this.dts = dts;
        this.xbrlInstance = xbrlInstance;
        this.byInstance = this.xbrlInstance != null;
    }

    void a(RelationshipSet relationshipSet) {
        if (relationshipSet != null) {
            this.b.add(relationshipSet);
        }
    }

    protected XbrlSchema[] getEntrySchema() {
        if (this._entrySchemas != null) {
            return this._entrySchemas;
        }
        String string = this.extendNamespaceURI;
        if (StringUtils.isEmpty((String)string)) {
            return new XbrlSchema[0];
        }
        XmlSchema[] xmlSchemaArray = this.dts.getSchemas(string);
        if (xmlSchemaArray == null || xmlSchemaArray.length == 0) {
            XmlSchema[] xmlSchemaArray2 = this.dts.getSchemas();
            int n = xmlSchemaArray2.length;
            int n2 = 0;
            while (n2 < n) {
                XbrlSchema xbrlSchema;
                XmlSchema xmlSchema = xmlSchemaArray2[n2];
                if (xmlSchema instanceof XbrlSchema && !(xbrlSchema = (XbrlSchema)xmlSchema).isReadOnly() && string.equals(xbrlSchema.getTargetNamespace())) {
                    this._entrySchemas = new XbrlSchema[]{xbrlSchema};
                    return this._entrySchemas;
                }
                ++n2;
            }
            this._entrySchemas = new XbrlSchema[0];
            return this._entrySchemas;
        }
        if (xmlSchemaArray.length == 1) {
            if (xmlSchemaArray[0] instanceof XbrlSchema) {
                this._entrySchemas = new XbrlSchema[]{(XbrlSchema)xmlSchemaArray[0]};
                return this._entrySchemas;
            }
            this._entrySchemas = new XbrlSchema[0];
            return this._entrySchemas;
        }
        this._entrySchemas = new XbrlSchema[xmlSchemaArray.length];
        int n = 0;
        int n3 = 0;
        while (n3 < xmlSchemaArray.length) {
            if (xmlSchemaArray[n3] instanceof XbrlSchema) {
                this._entrySchemas[n++] = (XbrlSchema)xmlSchemaArray[n3];
            }
            ++n3;
        }
        return this._entrySchemas;
    }

    protected RoleType createRoleType(String roleURI, String id, String definition) {
        XbrlSchema[] xbrlSchemaArray;
        XbrlSchema[] xbrlSchemaArray2 = xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray2[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                Definition definition2;
                RoleType roleType = xbrlSchema.createRoleType(roleURI, id);
                xbrlSchema.addRoleType(roleType);
                if (!StringUtils.isEmpty((String)definition)) {
                    definition2 = roleType.createDefinition();
                    if (definition.startsWith("[") && definition.contains("]")) {
                        int n3 = definition.contains("][") || definition.contains("] [") ? definition.lastIndexOf("]") : definition.indexOf("]");
                        definition = definition.substring(n3 + 1);
                        String string = id;
                        n3 = string.indexOf("_");
                        if (n3 != -1) {
                            string = string.substring(n3 + 1);
                        }
                        definition = "[" + string + "] " + definition;
                    }
                    definition2.setInnerText(definition);
                    roleType.appendChild((XdmNode)definition2);
                }
                definition2 = roleType.createUsedOn((system.qizx.api.QName)QNameConstants.presentationLink);
                roleType.appendChild((XdmNode)definition2);
                definition2 = roleType.createUsedOn((system.qizx.api.QName)QNameConstants.definitionLink);
                roleType.appendChild((XdmNode)definition2);
                definition2 = roleType.createUsedOn((system.qizx.api.QName)QNameConstants.calculationLink);
                roleType.appendChild((XdmNode)definition2);
                this.dts.getRoleTypes().add(roleType);
                return roleType;
            }
            ++n2;
        }
        return null;
    }

    void a(Linkbase linkbase, String string) {
        ArcroleType arcroleType = this.dts.getArcroleTypes().getSingle(string);
        if (arcroleType != null) {
            ArcroleRef arcroleRef = linkbase.createArcroleRef();
            arcroleRef.setArcroleType(arcroleType);
            linkbase.prependChild((XdmNode)arcroleRef);
        }
    }

    void a(Linkbase linkbase) {
        if (linkbase == null) {
            return;
        }
        if (this.j == null) {
            this.j = new HashSet<Linkbase>();
        }
        if (this.j.contains(linkbase)) {
            return;
        }
        this.j.add(linkbase);
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : linkbase.getArcroleRefs()) {
            String string = object.getArcroleURI();
            hashSet.add(string);
        }
        for (Object object : XdtConstants.getXdtArcroles()) {
            if (hashSet.contains(object)) continue;
            this.a(linkbase, (String)object);
        }
    }

    protected String getNextLabel(ExtendedLinkSummary summary, String label) {
        int n = label.indexOf("_");
        if (n != -1) {
            label = label.substring(0, n);
        }
        int n2 = 2;
        String string = String.valueOf(label) + "_" + n2;
        while (summary.getArcEnds(string).size() != 0) {
            string = String.valueOf(label) + "_" + ++n2;
        }
        return string;
    }

    protected void bugFixDuplicateArc() {
        try {
            IXbrlDocument[] iXbrlDocumentArray = this.dts.getDocuments();
            HashMap<b, Arc> hashMap = new HashMap<b, Arc>();
            IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray;
            int n = iXbrlDocumentArray.length;
            int n2 = 0;
            while (n2 < n) {
                XbrlDocument xbrlDocument;
                IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
                if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                    Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                    for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                        if (!extendedLink.isSyntaxError()) continue;
                        hashMap.clear();
                        ExtendedLinkSummary extendedLinkSummary = new ExtendedLinkSummary(extendedLink, this.dts);
                        for (Arc arc : extendedLinkSummary.getArcs()) {
                            String string;
                            String string2 = arc.getFrom();
                            b b2 = new b(string2, string = arc.getTo());
                            if (hashMap.containsKey(b2)) {
                                Object object;
                                List list = extendedLinkSummary.getArcEnds(string);
                                if (list.size() == 1 && list.get(0) instanceof XdmElement) {
                                    XdmElement xdmElement = (XdmElement)list.get(0);
                                    object = null;
                                    try {
                                        object = xdmElement.getOwnerDocument().importNode((Node)xdmElement, true);
                                    }
                                    catch (DataModelException dataModelException) {
                                        dataModelException.printStackTrace();
                                    }
                                    if (object instanceof ArcEnd && object instanceof XdmElement) {
                                        ArcEnd arcEnd = (ArcEnd)object;
                                        String string3 = this.getNextLabel(extendedLinkSummary, string);
                                        arcEnd.setLabel(string3);
                                        xdmElement.getParent().insertBefore((XdmNode)arcEnd, (XdmNode)xdmElement);
                                        arc.setTo(string3);
                                        extendedLinkSummary.putEnd(arcEnd);
                                        this.b.add(this.dts.getRelationshipSet(extendedLink.getNodeName(), extendedLink.getRole()));
                                        this._hasBugFixed = true;
                                        continue;
                                    }
                                    LogWatch.error((Object)("dup arc, fix error, clone end is not an ArcEnd." + string + " @" + extendedLink.getRole()));
                                    continue;
                                }
                                boolean bl = false;
                                if (extendedLink != null && QNameConstants.labelLink.equals((Object)extendedLink.getNodeName())) {
                                    arc.getParent().removeChild((XdmNode)arc);
                                    extendedLink.getOwnerDocument().setModified(true);
                                    object = extendedLink.getRelationships();
                                    int n3 = object.size() - 1;
                                    while (n3 > -1) {
                                        if (((Relationship)object.get(n3)).arc() == arc) {
                                            object.remove(n3);
                                        }
                                        --n3;
                                    }
                                    this.b.add(this.dts.getRelationshipSet(extendedLink.getNodeName(), extendedLink.getRole()));
                                    this._hasBugFixed = true;
                                    bl = true;
                                }
                                if (bl) continue;
                                LogWatch.error((Object)("dup arc, dup label, not fix." + string + " @" + extendedLink.getRole()));
                                continue;
                            }
                            hashMap.put(b2, arc);
                        }
                    }
                }
                ++n2;
            }
            this.rebuildRelationshipSet();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void rebuildRelationshipSet() {
        RelationshipSet relationshipSet;
        RelationshipSet relationshipSet22;
        if (this.b == null || this.b.size() == 0) {
            return;
        }
        boolean bl = false;
        for (RelationshipSet relationshipSet22 : this.b) {
            relationshipSet22.clear();
            boolean bl2 = bl = bl || relationshipSet22.getExtendedName().equals(QNameConstants.definitionLink);
        }
        RelationshipSet relationshipSet3 = relationshipSet22 = this.dts.getDocuments();
        int n = ((RelationshipSet)relationshipSet3).length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            relationshipSet = relationshipSet3[n2];
            if (relationshipSet.getContentType().contains(XbrlContentType.Linkbase) && relationshipSet instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)relationshipSet).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                    RelationshipSet relationshipSet4 = this.dts.getRelationshipSet(extendedLink.getNodeName(), extendedLink.getRole());
                    if (!this.b.contains(relationshipSet4)) continue;
                    for (Object object : extendedLink.getRelationships()) {
                        relationshipSet4.addRelaionship(object);
                    }
                    for (Object object : extendedLink.getTargets()) {
                        if (relationshipSet4.contains(object)) continue;
                        relationshipSet4.addRoot(object);
                    }
                }
            }
            ++n2;
        }
        if (bl) {
            relationshipSet = new XdtProcessor(this.dts);
            relationshipSet.procesDTS(this.getProcessContext());
            relationshipSet = null;
        }
        this.b.clear();
    }

    public void rebuildRelationshipSet(RelationshipSet rs) {
        if (rs != null) {
            String string = rs.getRoleURI();
            this.b.add(rs);
            Collection collection = this.dts.getRelationshipSets(rs.getExtendedName());
            for (RelationshipSet relationshipSet : collection) {
                if (relationshipSet.getRoleURI().equals(string) || !relationshipSet.getRoleURI().startsWith(string)) continue;
                this.b.add(relationshipSet);
            }
        }
        this.rebuildRelationshipSet();
    }

    public boolean renameRoleURI(String oldURI, String newURI, String newId) {
        Object object;
        this._targetAction = TargetAction.ChangeRoleURI;
        if (StringUtils.isEmpty((String)oldURI) || StringUtils.isEmpty((String)newURI)) {
            return false;
        }
        OutputStream outputStream = this.out;
        this.out = null;
        this.bugFix();
        this.out = outputStream;
        XbrlSchema xbrlSchema = null;
        RoleType roleType = this.getEntrySchema();
        int n = ((XbrlSchema[])roleType).length;
        int n2 = 0;
        while (n2 < n) {
            object = roleType[n2];
            if (object != null && !object.isReadOnly()) {
                xbrlSchema = object;
            }
            ++n2;
        }
        if (xbrlSchema == null) {
            return false;
        }
        object = null;
        n2 = oldURI.lastIndexOf("/");
        if (n2 == -1) {
            this.fixBug("old roleURI: " + oldURI + " is invalid.", true);
            return false;
        }
        object = oldURI.substring(n2 + 1);
        RoleType[] roleTypeArray = this.dts.getRoleTypes().get(oldURI);
        if (roleTypeArray == null || roleTypeArray.length == 0) {
            roleTypeArray = xbrlSchema.getRoleTypes().get(oldURI);
        }
        if (roleTypeArray == null || roleTypeArray.length == 0) {
            this.fixBug("old roleURI: " + oldURI + " is not exists.", true);
            return false;
        }
        Object object2 = roleTypeArray;
        int n3 = roleTypeArray.length;
        int n4 = 0;
        while (n4 < n3) {
            roleType = object2[n4];
            if (roleType.getOwnerDocument().isReadOnly()) {
                this.fixBug("old roleURI: " + oldURI + " is readOnly.", true);
                return false;
            }
            ++n4;
        }
        roleType = roleTypeArray[0];
        if (oldURI.equals(newURI)) {
            if (!roleType.getId().equals(newId)) {
                if (xbrlSchema.getElementById(newId) != null) {
                    throw new IllegalArgumentException("new id: " + newId + " is used.");
                }
                ArrayList<Linkbase> arrayList = new ArrayList<Linkbase>();
                for (RelationshipSet relationshipSet : this.dts.getRelationshipSets(oldURI)) {
                    for (Linkbase linkbase2 : this.getLinkbases(relationshipSet.getExtendedLinks())) {
                        if (linkbase2.getOwnerDocument().isReadOnly()) {
                            return false;
                        }
                        arrayList.add(linkbase2);
                    }
                }
                roleType.setId(newId);
                xbrlSchema.setModified(true);
                for (Linkbase linkbase : arrayList) {
                    Linkbase linkbase2;
                    linkbase2 = linkbase.getRoleRef(oldURI);
                    if (linkbase2 == null) continue;
                    linkbase2.setRoleType(roleType);
                    linkbase.getOwnerDocument().setModified(true);
                }
            }
            return true;
        }
        RoleType[] roleTypeArray2 = this.dts.getRoleTypes().get(newURI);
        if (roleTypeArray2 != null && roleTypeArray2.length != 0) {
            this.fixBug("new roleURI: " + newURI + " is exists.", true);
            return false;
        }
        HashSet<Linkbase> hashSet = new HashSet<Linkbase>();
        object2 = new HashSet();
        ArrayList<RelationshipSet> arrayList = new ArrayList<RelationshipSet>();
        for (Object object3 : this.dts.getRelationshipSets(oldURI)) {
            arrayList.add((RelationshipSet)object3);
        }
        for (Object object3 : arrayList) {
            RoleRef roleRef;
            UsedOn usedOn;
            Linkbase linkbase2;
            Collection collection2;
            String string = object3.getRoleURI();
            String string2 = string.replace(oldURI, newURI);
            n2 = string2.lastIndexOf(47);
            if (n2 == -1) continue;
            String string3 = string2.substring(n2 + 1);
            String string4 = roleType.getId();
            String string5 = StringUtils.isEmpty((String)newId) ? string4.replace((CharSequence)object, string3) : newId;
            RoleType roleType2 = null;
            if (!((HashSet)object2).contains(string2)) {
                ((HashSet)object2).add(string2);
                roleType2 = this.createRoleType(string2, string5, roleType.getDefinitionText());
                for (Collection collection2 : roleType.getUsedOns()) {
                    try {
                        linkbase2 = collection2.getQName();
                        if (roleType2.canUsedOn((system.qizx.api.QName)linkbase2)) continue;
                        usedOn = roleType2.createUsedOn((system.qizx.api.QName)linkbase2);
                        roleType2.appendChild((XdmNode)usedOn);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.fixBug("create roleType = " + string2);
                this._hasBugFixed = true;
                this.changeMenuRoleURI(string, string2);
            } else {
                roleType2 = this.dts.getRoleTypes().getSingle(string2);
            }
            collection2 = object3.getExtendedLinks();
            Collection<Linkbase> collection3 = this.getLinkbases(collection2);
            usedOn = collection3.iterator();
            while (usedOn.hasNext()) {
                linkbase2 = usedOn.next();
                hashSet.add(linkbase2);
                roleRef = linkbase2.getRoleRef(string2);
                if (roleRef != null) continue;
                roleRef = linkbase2.createRoleRef(string2, null);
                linkbase2.prependChild((XdmNode)roleRef);
                roleRef.setRoleType(roleType2);
            }
            for (Linkbase linkbase2 : collection2) {
                linkbase2.setRole(string2);
            }
            this.dts.removeRelationshipSets(object3);
            for (Linkbase linkbase2 : collection2) {
                roleRef = new ExtendedLinkSummary((ExtendedLink)linkbase2, this.dts);
                RelationshipSet relationshipSet = roleRef.getRelationshipSet();
                if (relationshipSet == null) continue;
                this.b.add(relationshipSet);
            }
        }
        outputStream = this.out;
        this.out = null;
        if (hashSet != null && hashSet.size() > 0) {
            Object object3;
            object3 = new HashSet();
            for (Linkbase linkbase : hashSet) {
                this.removeUnusedRoleRef(linkbase, (Set<String>)object3);
            }
        }
        if (this.b.size() > 0) {
            this.rebuildRelationshipSet();
        }
        this.a(roleType);
        return this._hasBugFixed;
    }

    public void mergeFootnote() {
        Object object;
        Object object2;
        Fact fact;
        Object object32;
        Object object4;
        Object object5;
        RelationshipSet relationshipSet2;
        HashMap<String, Fact> hashMap = new HashMap<String, Fact>();
        HashMap<Object, Fact> hashMap2 = new HashMap<Object, Fact>();
        HashMap<Object, RelationshipSet> hashMap3 = new HashMap<Object, RelationshipSet>();
        for (RelationshipSet relationshipSet2 : this.xbrlInstance.getRelationshipSets()) {
            for (Object object6 : relationshipSet2.getRelationships()) {
                if (!(object6.toTarget() instanceof Footnote) || !(object6.fromTarget() instanceof Fact)) continue;
                object5 = (Fact)object6.fromTarget();
                object4 = (Footnote)object6.toTarget();
                object32 = object4.getInnerText().replaceAll(" ", "");
                fact = new ArrayList();
                object2 = relationshipSet2.getParentTargets(object4);
                if (object2.size() > 1) {
                    if (hashMap2.containsKey(object4)) {
                        if (!((List)hashMap2.get(object4)).contains(object5)) {
                            ((List)hashMap2.get(object4)).add(object5);
                        }
                    } else {
                        fact.add((Fact)object5);
                        hashMap2.put(object4, fact);
                    }
                    if (hashMap3.containsKey(object32)) {
                        if (((List)hashMap3.get(object32)).contains(object4)) continue;
                        ((List)hashMap3.get(object32)).add(object4);
                        continue;
                    }
                    RelationshipSet relationshipSet3 = new ArrayList();
                    relationshipSet3.add(object4);
                    hashMap3.put(object32, relationshipSet3);
                    continue;
                }
                if (hashMap.containsKey(object32)) {
                    if (((List)hashMap.get(object32)).contains(object5)) continue;
                    ((List)hashMap.get(object32)).add(object5);
                    continue;
                }
                fact.add((Fact)object5);
                hashMap.put((String)object32, fact);
            }
        }
        relationshipSet2 = new ArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (List)entry.getValue();
            if (object.size() < 2) {
                relationshipSet2.add(((String)entry.getKey()).replaceAll(" ", ""));
                continue;
            }
            object4 = object.iterator();
            while (object4.hasNext()) {
                object5 = (Fact)object4.next();
                for (Object object32 : this.xbrlInstance.getRelationshipSets()) {
                    object32.purgeRelationships(object5);
                }
            }
        }
        for (String string : relationshipSet2) {
            if (hashMap3.containsKey(string.replaceAll(" ", ""))) {
                object = (List)hashMap.get(string);
                object4 = object.iterator();
                while (object4.hasNext()) {
                    object5 = (Fact)object4.next();
                    for (Object object32 : this.xbrlInstance.getRelationshipSets()) {
                        object32.purgeRelationships(object5);
                    }
                }
                continue;
            }
            hashMap.remove(string);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object = (String)entry.getKey();
            object5 = (List)entry.getValue();
            object4 = null;
            if (hashMap3.containsKey(((String)object).replaceAll(" ", ""))) {
                object4 = (Footnote)((List)hashMap3.get(object)).get(0);
            }
            this.a((List<Fact>)object5, (Footnote)object4, (String)object);
        }
        for (Map.Entry entry : hashMap3.entrySet()) {
            object = (List)entry.getValue();
            if (object.size() < 2) continue;
            object5 = new ArrayList();
            int n = 1;
            while (n < object.size()) {
                object32 = (List)hashMap2.get(object.get(n));
                object2 = object32.iterator();
                while (object2.hasNext()) {
                    fact = (Fact)object2.next();
                    for (RelationshipSet relationshipSet3 : this.xbrlInstance.getRelationshipSets()) {
                        relationshipSet3.purgeRelationships((Object)fact);
                    }
                }
                object5.addAll(object32);
                ++n;
            }
            this.a((List<Fact>)object5, (Footnote)object.get(0), (String)entry.getKey());
        }
        hashMap2 = null;
        hashMap = null;
        relationshipSet2 = null;
        hashMap3 = null;
    }

    private void a(List<Fact> list, Footnote footnote, String string) {
        FootnoteLink footnoteLink = this.a((String)null);
        ExtendedLinkSummary extendedLinkSummary = new ExtendedLinkSummary((ExtendedLink)footnoteLink, this.xbrlInstance.getOwnerDTS());
        if (footnote == null) {
            int n = XbrlHelper.getMaxFactId((XbrlDocument)this.xbrlInstance.getOwnerDocument());
            String string3 = "footnote_dp" + ++n;
            string3 = extendedLinkSummary.getNextLabel(string3);
            footnote = footnoteLink.createFootnote(string3, string, "zh");
            footnoteLink.appendChild((XdmNode)footnote);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5408\u5e76\u811a\u6ce8 \uff1a label=" + footnote.getLabel() + "@value=[" + footnote.getInnerText() + "]\r\n  \u5305\u542b \uff1a\r\n");
        for (Fact fact : list) {
            ArcEnd arcEnd2;
            Loc loc = null;
            String string4 = fact.getId();
            if (StringUtils.isEmpty((String)string4)) {
                XbrlHelper.setFactId((Fact)fact);
            }
            for (ArcEnd arcEnd2 : extendedLinkSummary.getArcEnds(fact.getId())) {
                Loc loc2;
                if (!(arcEnd2 instanceof Loc) || (loc2 = (Loc)arcEnd2).getTarget() != fact) continue;
                loc = loc2;
                break;
            }
            if (loc == null) {
                string4 = extendedLinkSummary.getNextLabel(string4);
                loc = footnoteLink.createLoc((Object)fact, string4);
                footnoteLink.appendChild((XdmNode)loc);
            }
            arcEnd2 = footnoteLink.createArc((system.qizx.api.QName)QNameConstants.footnoteArc, "http://www.xbrl.org/2003/arcrole/fact-footnote", "1.0");
            arcEnd2.setFrom(loc.getLabel());
            arcEnd2.setTo(footnote.getLabel());
            footnoteLink.appendChild((XdmNode)arcEnd2);
            extendedLinkSummary.addRelationship(this.xbrlInstance, (XbrlElement)loc, (XbrlElement)footnote, (Arc)arcEnd2);
            stringBuffer.append(" > \u5143\u7d20\uff1a" + fact + "\r\n");
            this._hasBugFixed = true;
        }
        this.fixBug(stringBuffer.toString());
    }

    private FootnoteLink a(String string) {
        FootnoteLink footnoteLink2;
        if (StringUtils.isEmpty((String)string)) {
            string = "http://www.xbrl.org/2003/role/link";
        }
        if (this.k == null) {
            this.k = this.xbrlInstance.getFootnoteLinks();
        }
        for (FootnoteLink footnoteLink2 : this.k) {
            if (!footnoteLink2.getRole().equals(string)) continue;
            return footnoteLink2;
        }
        footnoteLink2 = this.xbrlInstance.createFootnoteLink();
        this.xbrlInstance.appendChild((XdmNode)footnoteLink2);
        this.k.add(footnoteLink2);
        return footnoteLink2;
    }

    private boolean a(RoleType roleType) {
        if (roleType == null) {
            return false;
        }
        boolean bl = false;
        this.rebuildRelationshipSet();
        Set<String> set = null;
        if (roleType.getOwnerDocument().isReadOnly()) {
            return false;
        }
        String string = roleType.getRoleURI();
        boolean bl2 = false;
        for (Object object : this.dts.getRelationshipSets(string)) {
            if (object.getRelationships().size() == 0) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            if (set == null) {
                set = this.getReferencedRoleTypes(this.dts);
            }
            if (!set.contains(string)) {
                Object object;
                object = roleType.getOwnerDocument().getDocUri();
                this.dts.getRoleTypes().remove((Object)roleType);
                this.removedRoleTypes.add(roleType.getRoleURI());
                IXbrlDocument iXbrlDocument = this.dts.getDocument((URI)object);
                if (iXbrlDocument != null && iXbrlDocument instanceof XbrlSchema) {
                    if (((XbrlSchema)iXbrlDocument).removeRoleType(roleType)) {
                        this.dts.getRoleTypes().remove((Object)roleType);
                        this.removedRoleTypes.add(roleType.getRoleURI());
                        if (this.genericLinkRS == null) {
                            this.genericLinkRS = this.dts.getRelationshipSets((system.qizx.api.QName)QNameConstants.genericLink);
                        }
                        for (RelationshipSet relationshipSet : this.genericLinkRS) {
                            relationshipSet.purgeOrProhibitTarget((Object)roleType);
                            boolean bl3 = bl = relationshipSet.getRelationships().size() == 0 || bl;
                        }
                    }
                } else {
                    LogWatch.error((Object)("roleType:" + string + ", the schema file not found."));
                }
            }
        }
        if (bl) {
            this.removeUnusedGenericLink();
        }
        return true;
    }

    protected Set<String> getReferencedRoleTypes(TaxonomySet dts) {
        IXbrlDocument[] iXbrlDocumentArray;
        HashSet<String> hashSet = new HashSet<String>();
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                List list = linkbase.getRoleRefs();
                int n3 = list.size() - 1;
                while (n3 > -1) {
                    RoleRef roleRef = (RoleRef)list.get(n3);
                    String string = roleRef.getRoleURI();
                    if (string != null) {
                        hashSet.add(string);
                    }
                    --n3;
                }
            }
            ++n2;
        }
        return hashSet;
    }

    protected void removeUnusedGenericLink() {
        IXbrlDocument[] iXbrlDocumentArray;
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                XbrlDocument xbrlDocument;
                IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
                if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                    Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                    HashSet<String> hashSet = new HashSet<String>();
                    for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                        if (extendedLink.getNodeName().equals(QNameConstants.genericLink)) {
                            ArrayList arrayList = extendedLink.getRelationships();
                            if (arrayList != null) {
                                arrayList = new ArrayList(arrayList);
                            }
                            if (extendedLink.isEmpty() && extendedLink.getParent() != null) {
                                extendedLink.getParent().removeChild((XdmNode)extendedLink);
                                continue;
                            }
                            for (Relationship relationship : arrayList) {
                                Resource resource;
                                String string;
                                if (!(relationship.toTarget() instanceof Resource) || (string = (resource = (Resource)relationship.toTarget()).getRole()) == null) continue;
                                hashSet.add(string);
                            }
                            continue;
                        }
                        break block7;
                    }
                    this.removeUnusedRoleRef(linkbase, hashSet);
                }
            }
            ++n2;
        }
    }

    protected void removeUnusedRoleRef(Linkbase linkbase, Set<String> roleURIs) {
        String string;
        ExtendedLink extendedLink2;
        List list = linkbase.getRoleRefs();
        List list2 = linkbase.getExtendedLinks();
        for (ExtendedLink extendedLink2 : list2) {
            string = extendedLink2.getRole();
            if (string == null) continue;
            if (extendedLink2.isEmpty()) {
                if (extendedLink2.getParent() == null) continue;
                extendedLink2.getParent().removeChild((XdmNode)extendedLink2);
                continue;
            }
            roleURIs.add(string);
        }
        extendedLink2 = new HashSet();
        int n = list.size() - 1;
        while (n > -1) {
            string = (RoleRef)list.get(n);
            String string2 = string.getRoleURI();
            if (extendedLink2.contains(string2)) {
                string.getOwnerDocument().setModified(true);
                string.getParent().removeChild((XdmNode)string);
                this.fixBug("remove dup roleRef = " + string2, true);
            } else {
                extendedLink2.add(string2);
                if (string2 != null && !roleURIs.contains(string2) && string.getParent() != null) {
                    string.getOwnerDocument().setModified(true);
                    string.getParent().removeChild((XdmNode)string);
                }
            }
            --n;
        }
    }

    protected Collection<Linkbase> getLinkbases(Collection<ExtendedLink> xlinks) {
        HashSet<Linkbase> hashSet = new HashSet<Linkbase>();
        for (ExtendedLink extendedLink : xlinks) {
            Linkbase linkbase = extendedLink.getOwnerLinkbase();
            if (linkbase == null || hashSet.contains(linkbase)) continue;
            hashSet.add(linkbase);
        }
        return hashSet;
    }

    public ExtendMode getExtendMode() {
        if (this.a == null) {
            this.a = ExtendMode.None;
        }
        if (this.a == ExtendMode.None && this.dts != null) {
            this.a = ExtendMode.Redefine;
            IXbrlDocument[] iXbrlDocumentArray = this.dts.getDocuments();
            int n = iXbrlDocumentArray.length;
            int n2 = 0;
            block0: while (n2 < n) {
                XbrlDocument xbrlDocument;
                IXbrlDocument iXbrlDocument = iXbrlDocumentArray[n2];
                if (iXbrlDocument != null && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && !iXbrlDocument.getContentType().contains(XbrlContentType.FileNotFound) && iXbrlDocument.isReadOnly() && iXbrlDocument.getBaseURI() != null && !iXbrlDocument.getBaseURI().startsWith("http://zip.local/") && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                    Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                    XdmNode xdmNode = linkbase.getFirstChild();
                    while (xdmNode != null) {
                        if (xdmNode.getNodeNature() == 2 && (QNameConstants.presentationLink.equals((Object)xdmNode.getNodeName()) || QNameConstants.definitionLink.equals((Object)xdmNode.getNodeName()) || QNameConstants.calculationLink.equals((Object)xdmNode.getNodeName()))) {
                            this.a = ExtendMode.Reuse;
                            break block0;
                        }
                        xdmNode = xdmNode.getNextSibling();
                    }
                }
                ++n2;
            }
        }
        return this.a;
    }

    public void setExtendMode(ExtendMode extendMode) {
        this.a = extendMode;
    }

    public boolean bugFixTextBlock() {
        return false;
    }

    protected void bugFixDuplicateRoleTypeId() {
        if (this.dts == null) {
            return;
        }
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : this.dts.getRoleTypes().getRoleTypeIds()) {
                arrayList.add(string);
            }
            for (String string : arrayList) {
                RoleType[] roleTypeArray = this.dts.getRoleTypes().getRoleTypeById(string);
                if (roleTypeArray == null || roleTypeArray.length <= 1) continue;
                RoleType[] roleTypeArray2 = roleTypeArray;
                int n = roleTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object;
                    RoleType roleType = roleTypeArray2[n2];
                    boolean bl = false;
                    IXbrlDocument iXbrlDocument = this.dts.getRelationshipSets(roleType.getRoleURI()).iterator();
                    if (iXbrlDocument.hasNext()) {
                        object = (RelationshipSet)iXbrlDocument.next();
                        bl = true;
                    }
                    if (!bl && (iXbrlDocument = this.dts.getDocument((String)(object = roleType.getOwnerDocument().getBaseURI()))) != null && iXbrlDocument instanceof XbrlSchema) {
                        XbrlSchema xbrlSchema = (XbrlSchema)iXbrlDocument;
                        xbrlSchema.removeRoleType(roleType);
                        this.dts.getRoleTypes().remove((Object)roleType);
                        xbrlSchema.setModified(true);
                    }
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class a
    implements Comparator<RelationshipSet> {
        a() {
        }

        public int a(RelationshipSet relationshipSet, RelationshipSet relationshipSet2) {
            return relationshipSet.getRoleURI().compareTo(relationshipSet2.getRoleURI());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((RelationshipSet)object, (RelationshipSet)object2);
        }
    }

    static final class b {
        private String a;
        private String b;
        private int c;

        public boolean equals(Object obj) {
            if (obj != null && this.hashCode() == obj.hashCode() && obj instanceof b) {
                b b2 = (b)obj;
                return this.a.equals(b2.a) && this.b.equals(b2.b);
            }
            return false;
        }

        public int hashCode() {
            if (this.c == 0) {
                this.c = this.a.hashCode() + this.b.hashCode();
            }
            return this.c;
        }

        public String toString() {
            return String.valueOf(this.a) + " - " + this.b;
        }

        b(String string, String string2) {
            this.a = string == null ? "" : string;
            this.b = string2 == null ? "" : string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TargetAction {
        None,
        BugFix,
        Clean,
        ChangeConceptName,
        ChangeRoleURI,
        RemoveConcept,
        AdjustDecimals,
        UpgradeRoleURI;

    }
}

