/*
 * Decompiled with CFR 0.152.
 */
package net.gbicc.xbrl.cleaner;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.gbicc.xbrl.cleaner.ChangeConceptInfo;
import net.gbicc.xbrl.cleaner.CleanOption;
import net.gbicc.xbrl.cleaner.Cleaner;
import net.gbicc.xbrl.cleaner.ImportOptions;
import net.gbicc.xbrl.core.Arc;
import net.gbicc.xbrl.core.ArcEnd;
import net.gbicc.xbrl.core.ArcUse;
import net.gbicc.xbrl.core.ArcroleRef;
import net.gbicc.xbrl.core.CalculationArc;
import net.gbicc.xbrl.core.Context;
import net.gbicc.xbrl.core.ContextElementType;
import net.gbicc.xbrl.core.Definition;
import net.gbicc.xbrl.core.DefinitionArc;
import net.gbicc.xbrl.core.EndDate;
import net.gbicc.xbrl.core.Entity;
import net.gbicc.xbrl.core.ExtendedLink;
import net.gbicc.xbrl.core.ExtendedLinkSummary;
import net.gbicc.xbrl.core.Fact;
import net.gbicc.xbrl.core.Footnote;
import net.gbicc.xbrl.core.GenericLabel;
import net.gbicc.xbrl.core.IXbrlDocument;
import net.gbicc.xbrl.core.Instant;
import net.gbicc.xbrl.core.Label;
import net.gbicc.xbrl.core.Linkbase;
import net.gbicc.xbrl.core.LinkbaseRef;
import net.gbicc.xbrl.core.Loc;
import net.gbicc.xbrl.core.Locator;
import net.gbicc.xbrl.core.LogWatch;
import net.gbicc.xbrl.core.OpenContextComponent;
import net.gbicc.xbrl.core.Period;
import net.gbicc.xbrl.core.PeriodType;
import net.gbicc.xbrl.core.PresentationArc;
import net.gbicc.xbrl.core.ProcessContext;
import net.gbicc.xbrl.core.QNameConstants;
import net.gbicc.xbrl.core.Relationship;
import net.gbicc.xbrl.core.RelationshipSet;
import net.gbicc.xbrl.core.Resource;
import net.gbicc.xbrl.core.RoleRef;
import net.gbicc.xbrl.core.RoleType;
import net.gbicc.xbrl.core.Scenario;
import net.gbicc.xbrl.core.SchemaRef;
import net.gbicc.xbrl.core.Segment;
import net.gbicc.xbrl.core.StartDate;
import net.gbicc.xbrl.core.TaxonomySet;
import net.gbicc.xbrl.core.Unit;
import net.gbicc.xbrl.core.UsedOn;
import net.gbicc.xbrl.core.XbrlConcept;
import net.gbicc.xbrl.core.XbrlContentType;
import net.gbicc.xbrl.core.XbrlDocument;
import net.gbicc.xbrl.core.XbrlElement;
import net.gbicc.xbrl.core.XbrlHelper;
import net.gbicc.xbrl.core.XbrlInstance;
import net.gbicc.xbrl.core.XbrlLoader;
import net.gbicc.xbrl.core.XbrlSchema;
import net.gbicc.xbrl.core.XbrlUrlResolver;
import net.gbicc.xbrl.core.dimension.ExplicitMember;
import net.gbicc.xbrl.core.dimension.MemberElement;
import net.gbicc.xbrl.core.dimension.TypedMember;
import net.gbicc.xbrl.core.dimension.XdtCompiledHypercube;
import net.gbicc.xbrl.core.dimension.XdtCompiledMember;
import net.gbicc.xbrl.core.dimension.XdtComponent;
import net.gbicc.xbrl.core.dimension.XdtDRS;
import net.gbicc.xbrl.core.dimension.XdtDimension;
import net.gbicc.xbrl.core.dimension.XdtProcessor;
import net.gbicc.xbrl.core.extensions.CommonExtensions;
import net.gbicc.xbrl.filing.CasProcessor;
import org.apache.commons.lang.StringUtils;
import system.io.IOHelper;
import system.io.compression.IZipStream;
import system.io.compression.ZipStream;
import system.lang.BigDecimalConstants;
import system.lang.Int32;
import system.lang.MutableInteger;
import system.qizx.api.DataModelException;
import system.qizx.api.EvaluationException;
import system.qizx.api.IXdmSchemaInfo;
import system.qizx.api.Node;
import system.qizx.api.QName;
import system.qizx.xdm.IQName;
import system.qizx.xdm.XdmAttribute;
import system.qizx.xdm.XdmDocument;
import system.qizx.xdm.XdmElement;
import system.qizx.xdm.XdmNode;
import system.qizx.xdm.XdmText;
import system.util.Pair;
import system.web.HttpUtility;
import system.xml.XmlChar;
import system.xml.schema.XmlSchema;
import system.xml.schema.XmlSchemaElement;
import system.xml.schema.XmlSchemaExternal;
import system.xml.schema.XmlSchemaImport;
import system.xml.schema.XmlSchemaObject;
import system.xml.schema.XmlTypeCode;
import system.xml.schema.utils.NamespacePrefixList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShanghaiCleaner
extends Cleaner {
    private HashSet<QName> c;
    private Map<QName, List<QName>> d;
    private Map<QName, List<QName>> e;
    private Map<QName, List<Fact>> f;
    public static final QName customDecimalsQName = IQName.get((String)"http://report.gbicc.net/xbrl", (String)"dec");
    private Set<Object> g;
    private HashSet<QName> h;
    private Map<QName, XbrlConcept> i;
    private Collection<RelationshipSet> j;
    private Collection<RelationshipSet> k;
    private Collection<RelationshipSet> l;
    private Collection<RelationshipSet> m;
    private boolean n;
    private XbrlConcept o;
    private TaxonomySet p;
    private Map<a, Boolean> q;
    private Collection<RelationshipSet> r = null;
    private String s;
    private static final Cleaner.a t = new Cleaner.a();
    private d u;
    private CleanOption v;
    private HashSet<String> w = new HashSet();
    static final BigDecimal a = new BigDecimal("0.1");
    private Collection<RelationshipSet> x;

    public ShanghaiCleaner(XbrlInstance xbrlInstance, TaxonomySet dts) {
        super(xbrlInstance, dts);
        this.a();
        this.getEntrySchema();
        XmlSchema[] xmlSchemaArray = dts.getSchemas();
        int n = xmlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XmlSchema xmlSchema = xmlSchemaArray[n2];
            String string = xmlSchema.getTargetNamespace();
            if (string != null && string.startsWith("http://xbrl.mof.gov.cn/taxonomy/") && xmlSchema.getXmlSchemaSet() != this.dts) {
                TaxonomySet taxonomySet;
                TaxonomySet taxonomySet2 = taxonomySet = xmlSchema.getXmlSchemaSet() instanceof TaxonomySet ? (TaxonomySet)xmlSchema.getXmlSchemaSet() : null;
                if (taxonomySet != null && taxonomySet.getEntryFile() != null && taxonomySet.getEntryFile().startsWith("http://xbrl.mof.gov.cn/taxonomy/")) {
                    this.p = taxonomySet;
                    break;
                }
            }
            ++n2;
        }
    }

    private boolean a(String string, String string2) {
        if (string != null && string2 != null) {
            int n = string.lastIndexOf(47);
            int n2 = string2.lastIndexOf(47);
            if (n != -1 && n2 != -1) {
                return string.substring(0, n).equals(string2.substring(0, n2));
            }
            n = string.lastIndexOf(92);
            n2 = string2.lastIndexOf(92);
            if (n != -1 && n2 != -1) {
                return string.substring(0, n).equals(string2.substring(0, n2));
            }
        }
        return false;
    }

    private void a() {
        if (StringUtils.isEmpty((String)this.extendNamespaceURI)) {
            if (this.xbrlInstance != null) {
                XdmNode xdmNode = this.xbrlInstance.getFirstChild();
                while (xdmNode != null) {
                    SchemaRef schemaRef;
                    IXbrlDocument iXbrlDocument;
                    if (xdmNode instanceof SchemaRef && (iXbrlDocument = this.dts.getDocument((schemaRef = (SchemaRef)xdmNode).getDiscoveredUri(null))) != null && iXbrlDocument instanceof XbrlSchema && (!iXbrlDocument.isReadOnly() || this.a(iXbrlDocument.getBaseURI(), this.xbrlInstance.getOwnerDocument().getBaseURI()))) {
                        this.extendNamespaceURI = ((XbrlSchema)iXbrlDocument).getTargetNamespace();
                        break;
                    }
                    xdmNode = xdmNode.getNextSibling();
                }
            } else {
                IXbrlDocument iXbrlDocument = this.dts.getDocument(this.dts.getEntryFile());
                if (iXbrlDocument != null && iXbrlDocument instanceof XbrlSchema && !iXbrlDocument.isReadOnly()) {
                    this.extendNamespaceURI = ((XbrlSchema)iXbrlDocument).getTargetNamespace();
                }
            }
        }
    }

    private boolean a(XbrlInstance xbrlInstance, XbrlConcept xbrlConcept, Iterable<RelationshipSet> iterable, Set<QName> set, Set<QName> set2) {
        if (xbrlConcept != null && iterable != null) {
            HashSet<XbrlConcept> hashSet = new HashSet<XbrlConcept>();
            for (RelationshipSet relationshipSet : iterable) {
                if (this.a(xbrlInstance, xbrlConcept, relationshipSet, set, hashSet, set2)) {
                    return true;
                }
                hashSet.clear();
            }
        }
        return false;
    }

    private boolean a(XbrlConcept xbrlConcept, Collection<RelationshipSet> collection) {
        if (xbrlConcept != null && collection != null && !collection.isEmpty()) {
            for (RelationshipSet relationshipSet : collection) {
                if (!relationshipSet.contains((Object)xbrlConcept)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean a(XbrlInstance xbrlInstance, XbrlConcept xbrlConcept, RelationshipSet relationshipSet, Set<QName> set, Set<XbrlConcept> set2, Set<QName> set3) {
        List list = relationshipSet.getChildren((Object)xbrlConcept);
        if (list != null && !list.isEmpty()) {
            for (Relationship relationship : list) {
                XbrlConcept xbrlConcept2 = relationship.toConcept();
                if (xbrlConcept2 == null || set2.contains(xbrlConcept2)) continue;
                set2.add(xbrlConcept2);
                QName qName = xbrlConcept2.getQName();
                if (xbrlConcept2.isDimension()) {
                    if (!this.a(qName, xbrlConcept2, relationshipSet)) continue;
                    this.a(set, relationshipSet, xbrlConcept2);
                    return true;
                }
                if (set3.contains(qName) || !xbrlConcept2.isAbstract() && !xbrlConcept2.isHypercube() && set.contains(qName)) {
                    this.a(set, relationshipSet, xbrlConcept2);
                    return true;
                }
                if (!this.a(xbrlInstance, xbrlConcept2, relationshipSet, set, set2, set3)) continue;
                this.a(set, relationshipSet, xbrlConcept2);
                return true;
            }
        }
        return false;
    }

    private boolean a(QName qName, XbrlConcept xbrlConcept, RelationshipSet relationshipSet) {
        Object object;
        a a2 = new a(qName, relationshipSet);
        if (this.q != null && (object = this.q.get(a2)) != null) {
            return (Boolean)object;
        }
        object = relationshipSet.getRoleURI();
        for (XdtDRS xdtDRS : this.dts.getAllDRS().values()) {
            if (!ShanghaiCleaner.isPairURI((String)object, xdtDRS.getRole()) || !xdtDRS.containsDimension(qName)) continue;
            for (XbrlConcept xbrlConcept2 : xdtDRS.getAllPrimaryItems()) {
                XdtCompiledHypercube[] xdtCompiledHypercubeArray = xdtDRS.tryGetHypercubes(xbrlConcept2);
                if (xdtCompiledHypercubeArray == null) continue;
                boolean bl = false;
                XdtCompiledHypercube[] xdtCompiledHypercubeArray2 = xdtCompiledHypercubeArray;
                int n = xdtCompiledHypercubeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    XdtCompiledHypercube xdtCompiledHypercube = xdtCompiledHypercubeArray2[n2];
                    if (xdtCompiledHypercube.containsDimension(qName)) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl || !this.f.containsKey(xbrlConcept2.getQName())) continue;
                if (this.q == null) {
                    this.q = new HashMap<a, Boolean>();
                }
                this.q.put(a2, true);
                return true;
            }
        }
        if (this.q == null) {
            this.q = new HashMap<a, Boolean>();
        }
        boolean bl = false;
        for (RelationshipSet relationshipSet2 : this.l) {
            if (!ShanghaiCleaner.isPairURI((String)object, relationshipSet2.getRoleURI())) continue;
            bl = true;
            break;
        }
        boolean bl2 = false;
        if (!bl) {
            LogWatch.error((Object)("not definitionLink for @" + (String)object));
            bl2 = this.a(relationshipSet, xbrlConcept, 0);
        }
        this.q.put(a2, bl2);
        return false;
    }

    private boolean a(RelationshipSet relationshipSet, XbrlConcept xbrlConcept, int n) {
        if (n > 100) {
            return false;
        }
        for (Relationship relationship : relationshipSet.getChildren((Object)xbrlConcept)) {
            XbrlConcept xbrlConcept2 = relationship.toConcept();
            if (xbrlConcept2 == null) continue;
            if (this.c.contains(xbrlConcept2.getQName())) {
                return true;
            }
            if (!this.a(relationshipSet, xbrlConcept2, n + 1)) continue;
            return true;
        }
        return false;
    }

    private void a(Set<QName> set, RelationshipSet relationshipSet, XbrlConcept xbrlConcept) {
        Collection collection = relationshipSet.getParents((Object)xbrlConcept);
        for (Relationship relationship : collection) {
            XbrlConcept xbrlConcept2 = relationship.fromConcept();
            if (xbrlConcept2 == null) continue;
            set.add(xbrlConcept2.getQName());
        }
    }

    private void b() {
        this.rebuildRelationshipSet();
        for (RelationshipSet relationshipSet : this.dts.getDefinitionRelationships()) {
            for (Relationship relationship : relationshipSet.getRelationships()) {
                if (!(relationship.arc() instanceof DefinitionArc)) continue;
                DefinitionArc definitionArc = (DefinitionArc)relationship.arc();
                if ("http://xbrl.org/int/dim/arcrole/all".equals(relationship.arcrole())) {
                    if (definitionArc.isClosed()) continue;
                    definitionArc.setClosed(true);
                    this.b.add(relationshipSet);
                    this._hasBugFixed = true;
                    continue;
                }
                if ("http://xbrl.org/int/dim/arcrole/all".equals(relationship.arcrole())) {
                    if (!definitionArc.isClosed()) continue;
                    definitionArc.setClosed(false);
                    this.b.add(relationshipSet);
                    this._hasBugFixed = true;
                    continue;
                }
                definitionArc.removeAttributeNode((QName)QNameConstants.contextElement);
                definitionArc.removeAttributeNode((QName)QNameConstants.closed);
            }
        }
        this.rebuildRelationshipSet();
    }

    @Override
    public boolean bugFix() {
        this._targetAction = Cleaner.TargetAction.BugFix;
        this._hasBugFixed = false;
        try {
            this.o();
            this.f();
            this.e();
            this.r();
            this.s();
            this.m();
            this.b();
            this.aa();
            this.bugFixDuplicateArc();
            this.t();
            this.u();
            this.Q();
            this.Z();
            this.rebuildRelationshipSet();
            this.i();
            this.k();
            this.h();
            this.X();
            this.d();
            this.c();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.q();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return this._hasBugFixed;
    }

    private void a(XbrlInstance xbrlInstance) {
        XdmNode xdmNode = xbrlInstance.getFirstChild();
        while (xdmNode != null) {
            if (xdmNode instanceof Fact) {
                Fact fact = (Fact)xdmNode;
                if (fact.isTuple()) {
                    XbrlHelper.normalizeTuple((Fact)fact);
                } else if (fact.isItem() && StringUtils.isEmpty((String)fact.getInnerText())) {
                    fact.setAttribute((QName)QNameConstants.nil, "true");
                }
            }
            xdmNode = xdmNode.getNextSibling();
        }
    }

    private void c() {
        XbrlSchema[] xbrlSchemaArray;
        XbrlSchema[] xbrlSchemaArray2 = xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray2[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                List list = xbrlSchema.getLinkbaseRefs();
                for (LinkbaseRef linkbaseRef : list) {
                    URI uRI = linkbaseRef.getDiscoveredUri(null);
                    if (uRI != null) {
                        IXbrlDocument iXbrlDocument = this.dts.getDocument(uRI);
                        if (iXbrlDocument != null && iXbrlDocument instanceof XbrlDocument) {
                            XbrlDocument xbrlDocument = (XbrlDocument)iXbrlDocument;
                            if (xbrlDocument.getDocumentElement() != null) continue;
                            LogWatch.warn((Object)("BugFix: remove empty file: " + linkbaseRef.getHref()));
                            xbrlSchema.removeLinkbaseRef(linkbaseRef);
                            xbrlSchema.setModified(true);
                            continue;
                        }
                        if (iXbrlDocument != null && !iXbrlDocument.getContentType().contains(XbrlContentType.FileNotFound)) continue;
                        LogWatch.warn((Object)("BugFix: remove empty file: " + linkbaseRef.getHref()));
                        xbrlSchema.removeLinkbaseRef(linkbaseRef);
                        xbrlSchema.setModified(true);
                        continue;
                    }
                    LogWatch.warn((Object)("BugFix: remove empty file: " + linkbaseRef.getHref()));
                    xbrlSchema.removeLinkbaseRef(linkbaseRef);
                    xbrlSchema.setModified(true);
                }
            }
            ++n2;
        }
    }

    private void d() {
        for (RelationshipSet relationshipSet : this.dts.getRelationshipSets((QName)QNameConstants.calculationLink)) {
            String string = relationshipSet.getRoleURI();
            RoleType roleType = this.dts.getRoleTypes().getSingle(string);
            if (roleType == null || roleType.canUsedOn((QName)QNameConstants.calculationLink)) continue;
            roleType.addUsedOn((QName)QNameConstants.calculationLink);
            this._hasBugFixed = true;
        }
    }

    private void e() {
        if (this.xbrlInstance == null) {
            return;
        }
        List list = this.xbrlInstance.getRelationshipSets();
        if (list == null) {
            return;
        }
        for (RelationshipSet relationshipSet : list) {
            ArrayList<Relationship> arrayList = null;
            for (Relationship relationship : relationshipSet.getRelationships()) {
                if (relationship.fromTarget() instanceof Fact || !(relationship.fromTarget() instanceof Loc)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Relationship>();
                }
                arrayList.add(relationship);
            }
            if (arrayList == null) continue;
            this.b.add(relationshipSet);
            for (Relationship relationship : arrayList) {
                relationshipSet.purgeRelationships(relationship.fromTarget());
                this._hasBugFixed = true;
            }
            for (Relationship relationship : arrayList) {
                Footnote footnote;
                if (relationshipSet.hasParent(relationship.toTarget()) || !(relationship.toTarget() instanceof Footnote) || !((footnote = (Footnote)relationship.toTarget()).getParent() instanceof ExtendedLink)) continue;
                ExtendedLink extendedLink = (ExtendedLink)footnote.getParent();
                extendedLink.getRelationships().remove(relationship);
                extendedLink.removeChild((XdmNode)footnote);
                this._hasBugFixed = true;
            }
        }
    }

    private void f() {
        if (this.xbrlInstance == null) {
            return;
        }
        this.f = this.xbrlInstance.getAllFacts(true);
        for (List<Fact> list : this.f.values()) {
            for (Fact fact : list) {
                String string;
                XbrlConcept xbrlConcept = fact.getConcept();
                if (xbrlConcept == null || xbrlConcept.isNonNumeric() || !StringUtils.isEmpty((String)(string = fact.getDecimals())) || fact.isNil() || !StringUtils.isEmpty((String)fact.getPrecision())) continue;
                try {
                    if (fact.getAttribute((QName)QNameConstants.decimals) == null) continue;
                    String string2 = fact.getInnerText().trim();
                    int n = string2.indexOf(".");
                    if (string2.contains("e") || StringUtils.isEmpty((String)string2)) continue;
                    this._hasBugFixed = true;
                    if (n == -1) {
                        fact.setDecimals("0");
                        continue;
                    }
                    fact.setDecimals(Integer.toString(string2.length() - n - 1));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void g() {
        if (this.xbrlInstance == null) {
            return;
        }
        ArrayList<XdmNode> arrayList = new ArrayList<XdmNode>();
        for (Context context : this.xbrlInstance.getContexts()) {
            Scenario scenario = context.getScenario();
            if (scenario == null) continue;
            arrayList.clear();
            XdmNode xdmNode2 = scenario.getFirstChild();
            while (xdmNode2 != null) {
                if (xdmNode2.getNodeNature() == 7) {
                    arrayList.add(xdmNode2);
                }
                xdmNode2 = xdmNode2.getNextSibling();
            }
            for (XdmNode xdmNode2 : arrayList) {
                xdmNode2.getParent().removeChild(xdmNode2);
                this._hasBugFixed = true;
            }
        }
    }

    private void h() {
        if (this.xbrlInstance == null) {
            return;
        }
        List list = this.xbrlInstance.getContexts();
        HashMap<String, Context[]> hashMap = new HashMap<String, Context[]>();
        int n = list.size() - 1;
        while (n > -1) {
            Context context = (Context)list.get(n);
            String string = context.getId();
            if (StringUtils.isEmpty((String)string)) {
                context.getParent().removeChild((XdmNode)context);
                list.remove(n);
                this._hasBugFixed = true;
            } else {
                Object[] objectArray = (Context[])hashMap.get(string);
                if (objectArray != null) {
                    boolean bl = false;
                    Object[] objectArray2 = objectArray;
                    int n2 = objectArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        Context context2 = objectArray2[n3];
                        if (context2.XdtEqual(context)) {
                            this.fixBug("remove dup context: " + string);
                            context.getParent().removeChild((XdmNode)context);
                            list.remove(n);
                            this._hasBugFixed = true;
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!bl) {
                        hashMap.put(string, (Context[])CommonExtensions.add(Context[].class, (Object[])objectArray, (Object)context));
                    }
                } else {
                    hashMap.put(string, new Context[]{context});
                }
            }
            --n;
        }
    }

    private void i() {
        IXbrlDocument[] iXbrlDocumentArray;
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                HashMap<String, RoleRef> hashMap = new HashMap<String, RoleRef>();
                for (RoleRef roleRef : linkbase.getRoleRefs()) {
                    RoleRef roleRef2 = (RoleRef)hashMap.get(roleRef.getRoleURI());
                    if (roleRef2 != null) {
                        roleRef.getParent().removeChild((XdmNode)roleRef);
                        continue;
                    }
                    hashMap.put(roleRef.getRoleURI(), roleRef);
                }
            }
            ++n2;
        }
    }

    private void j() {
        try {
            IXbrlDocument[] iXbrlDocumentArray;
            IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
            int n = iXbrlDocumentArray.length;
            int n2 = 0;
            while (n2 < n) {
                XbrlDocument xbrlDocument;
                IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
                if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                    Object object;
                    String string;
                    Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                    HashMap<String, ArcroleRef> hashMap = new HashMap<String, ArcroleRef>();
                    for (ArcroleRef arcroleRef2 : linkbase.getArcroleRefs()) {
                        string = arcroleRef2.getArcroleURI();
                        object = (ArcroleRef)hashMap.get(string);
                        if (object != null) {
                            arcroleRef2.getParent().removeChild((XdmNode)arcroleRef2);
                            continue;
                        }
                        hashMap.put(string, arcroleRef2);
                    }
                    if (hashMap.size() != 0) {
                        ArcroleRef arcroleRef2;
                        arcroleRef2 = linkbase.getFirstChild();
                        block4: while (arcroleRef2 != null) {
                            if (arcroleRef2.getNodeNature() == 2 && arcroleRef2 instanceof ExtendedLink) {
                                Iterator<Object> iterator = (ExtendedLink)arcroleRef2;
                                string = iterator.getFirstChild();
                                while (string != null) {
                                    if (string instanceof Arc) {
                                        object = ((Arc)string).getArcrole();
                                        hashMap.remove(object);
                                        if (hashMap.isEmpty()) break block4;
                                    }
                                    string = string.getNextSibling();
                                }
                            }
                            arcroleRef2 = arcroleRef2.getNextSibling();
                        }
                        if (!hashMap.isEmpty()) {
                            for (ArcroleRef arcroleRef2 : hashMap.values()) {
                                arcroleRef2.getParent().removeChild((XdmNode)arcroleRef2);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void k() {
        if (this.j == null) {
            this.j = this.dts.getPresentationRelationships();
        }
        HashSet hashSet = new HashSet();
        for (RelationshipSet relationshipSet : this.j) {
            hashSet.clear();
            relationshipSet.getAllTargets(hashSet);
            block1: for (Object e2 : hashSet) {
                XbrlConcept xbrlConcept;
                if (!(e2 instanceof XbrlConcept) || !(xbrlConcept = (XbrlConcept)e2).isHypercube()) continue;
                for (Relationship relationship : relationshipSet.getParents((Object)xbrlConcept)) {
                    Object object;
                    Relationship relationship2;
                    Arc arc;
                    Arc arc2;
                    List list = relationshipSet.getChildren(relationship.fromTarget());
                    if (list == null || list.size() <= 0 || ((Relationship)list.get(0)).toTarget() == xbrlConcept) continue;
                    if (list.size() == 2) {
                        arc2 = ((Relationship)list.get(0)).arc();
                        arc = ((Relationship)list.get(1)).arc();
                        BigDecimal bigDecimal = ((Relationship)list.get(0)).arc().getOrder();
                        arc2.setOrder(arc.getOrder());
                        arc.setOrder(bigDecimal);
                        this._hasBugFixed = true;
                        this.b.add(relationshipSet);
                        continue;
                    }
                    arc2 = null;
                    arc = null;
                    int n = -1;
                    int n2 = -1;
                    int n3 = 0;
                    while (n3 < list.size()) {
                        relationship2 = (Relationship)list.get(n3);
                        object = relationship2.toConcept();
                        if (object == null) continue block1;
                        if (object == xbrlConcept) {
                            arc2 = relationship2;
                            n = n3;
                        } else {
                            if (object.isHypercube()) continue block1;
                            if (object != null && object.getName().endsWith("LineItems")) {
                                if (arc != null) continue block1;
                                arc = relationship2;
                                n2 = n3;
                            }
                        }
                        ++n3;
                    }
                    if (n2 == -1 || n == -1 || n2 > n) continue;
                    Arc arc3 = arc2.arc();
                    relationship2 = arc.arc();
                    object = ((Relationship)list.get(0)).arc().getOrder();
                    arc3.setOrder(relationship2.getOrder());
                    relationship2.setOrder((BigDecimal)object);
                    this._hasBugFixed = true;
                    this.b.add(relationshipSet);
                }
            }
        }
    }

    private void l() {
        try {
            for (RoleType roleType : this.dts.getRoleTypes()) {
                RelationshipSet relationshipSet3;
                Object object2;
                String string = roleType.getRoleURI();
                if (!roleType.getDefinitionText().endsWith("//REMOVED")) continue;
                List<RelationshipSet> list = this.c(string);
                boolean bl = true;
                for (RelationshipSet relationshipSet2 : list) {
                    if (!relationshipSet2.isReadOnly()) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                List<RelationshipSet> list2 = this.e(string);
                for (Object object2 : list2) {
                    if (!object2.isReadOnly()) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                object2 = this.d(string);
                Iterator<Object> iterator = object2.iterator();
                while (iterator.hasNext()) {
                    relationshipSet3 = (RelationshipSet)iterator.next();
                    if (!relationshipSet3.isReadOnly()) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                for (RelationshipSet relationshipSet3 : list) {
                    for (Object e2 : new ArrayList(relationshipSet3.getFromTargets())) {
                        relationshipSet3.purgeRelationships(e2);
                    }
                    this.b.add(relationshipSet3);
                }
                for (RelationshipSet relationshipSet3 : list2) {
                    for (Object e2 : new ArrayList(relationshipSet3.getFromTargets())) {
                        relationshipSet3.purgeRelationships(e2);
                    }
                    this.b.add(relationshipSet3);
                }
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    relationshipSet3 = (RelationshipSet)iterator.next();
                    for (Object e2 : new ArrayList(relationshipSet3.getFromTargets())) {
                        relationshipSet3.purgeRelationships(e2);
                    }
                    this.b.add(relationshipSet3);
                }
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)("removeRoleTypeREMOVED: " + exception.getMessage()));
            exception.printStackTrace();
        }
    }

    private void m() {
        Object object;
        Object object2;
        this.rebuildRelationshipSet();
        this.j = this.dts.getPresentationRelationships();
        this.l = this.dts.getDefinitionRelationships();
        boolean bl = false;
        ArrayList<RelationshipSet> arrayList = new ArrayList<RelationshipSet>();
        for (RelationshipSet object32 : this.j) {
            XbrlConcept xbrlConcept;
            Object object33;
            arrayList.clear();
            for (Object object33 : object32.getFromTargets()) {
                if (!(object33 instanceof XbrlConcept) || !((XbrlConcept)object33).isHypercube()) continue;
                for (Relationship relationship : object32.getParents(object33)) {
                    xbrlConcept = relationship.fromConcept();
                    if (xbrlConcept == null) continue;
                    object2 = new f(xbrlConcept, (XbrlConcept)object33, object32);
                    object2.e = relationship;
                    arrayList.add((RelationshipSet)object2);
                }
            }
            if (arrayList.size() == 0) continue;
            object33 = object32.getRoleURI();
            Object object4 = this.e((String)object33);
            block3: for (f f2 : arrayList) {
                xbrlConcept = f2.a;
                object = object4.iterator();
                while (object.hasNext()) {
                    object2 = (RelationshipSet)object.next();
                    for (Relationship relationship : object2.getParents((Object)xbrlConcept)) {
                        if (relationship.fromConcept() != f2.d) continue;
                        f2.c = object2;
                        f2.f = relationship;
                        continue block3;
                    }
                }
            }
            for (f f3 : arrayList) {
                if (f3.c == null) {
                    this.reportBug(f3 + " @" + (String)object33 + " missing definition.");
                    if (!this.a(f3, (List<RelationshipSet>)object4)) continue;
                    bl = true;
                    this._hasBugFixed = true;
                    this.fixBug("create definitionLink for " + f3 + " @" + (String)object33, true);
                    continue;
                }
                if (!this.a(f3)) continue;
                bl = true;
            }
        }
        if (bl) {
            this.l = this.dts.getDefinitionRelationships();
            this.rebuildRelationshipSet();
        }
        this.l = this.dts.getDefinitionRelationships();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (RelationshipSet relationshipSet : this.l) {
            for (Object object4 : relationshipSet.getFromTargets()) {
                List list = relationshipSet.getChildren(object4);
                if (list.size() <= 1) continue;
                hashSet.clear();
                int n = list.size() - 1;
                while (n > -1) {
                    object2 = (Relationship)list.get(n);
                    if (object2.isOptional() && "http://xbrl.org/int/dim/arcrole/domain-member".equals(object2.arcrole())) {
                        object = object2.toTarget();
                        if (hashSet.contains(object)) {
                            object2.purge(null);
                            this.b.add(relationshipSet);
                        } else {
                            hashSet.add(object);
                        }
                    }
                    --n;
                }
            }
        }
        this.rebuildRelationshipSet();
    }

    private boolean a(f f2) {
        XbrlConcept xbrlConcept;
        if (f2 == null || f2.e == null) {
            return false;
        }
        boolean bl = false;
        RelationshipSet relationshipSet = f2.c;
        ExtendedLinkSummary extendedLinkSummary = null;
        for (Relationship relationship : f2.b.getChildren((Object)f2.a)) {
            xbrlConcept = relationship.toConcept();
            if (xbrlConcept == null || !xbrlConcept.isDimension()) continue;
            if (!relationshipSet.contains((Object)xbrlConcept)) {
                if (extendedLinkSummary == null) {
                    f2.g = extendedLinkSummary = this.a(f2.f);
                }
                if (extendedLinkSummary == null || !this.a(extendedLinkSummary, relationship, f2.b)) continue;
                bl = true;
                this.b.add(f2.c);
                continue;
            }
            if (!this.a(f2, xbrlConcept, 0)) continue;
            bl = true;
            this.b.add(f2.c);
        }
        for (Relationship relationship : f2.b.getChildren((Object)f2.d)) {
            if (relationship == f2.e || (xbrlConcept = relationship.toConcept()) == null || xbrlConcept.isDimension() || xbrlConcept.isHypercube()) continue;
            if (extendedLinkSummary == null) {
                f2.g = extendedLinkSummary = this.a(f2.f);
            }
            if (this.b(extendedLinkSummary, relationship, f2.b, new HashSet<Relationship>()) <= 0) continue;
            bl = true;
        }
        return bl;
    }

    private boolean a(f f2, XbrlConcept xbrlConcept, int n) {
        if (xbrlConcept == null || n > 50) {
            return false;
        }
        boolean bl = false;
        for (Relationship relationship : f2.b.getChildren((Object)xbrlConcept)) {
            String string;
            XbrlConcept xbrlConcept2 = relationship.toConcept();
            if (xbrlConcept2 == null || xbrlConcept2.isHypercube() || xbrlConcept2.isDimension()) continue;
            String string2 = string = xbrlConcept.isDimension() ? "http://xbrl.org/int/dim/arcrole/dimension-domain" : "http://xbrl.org/int/dim/arcrole/domain-member";
            if (!f2.c.containRelationship((Object)xbrlConcept, (Object)xbrlConcept2, string)) {
                Relationship relationship2;
                if (f2.g == null) {
                    f2.g = this.a(f2.f);
                }
                if (f2.g != null && (relationship2 = f2.g.addRelationship(xbrlConcept, xbrlConcept2, (QName)QNameConstants.definitionArc, string)) != null) {
                    this.fixBug("create relationship: " + relationship2);
                    relationship2.arc().getOwnerDocument().setModified(true);
                    relationship2.arc().setOrder(relationship.arc().getOrder());
                    bl = true;
                }
            }
            boolean bl2 = bl = this.a(f2, xbrlConcept2, n + 1) || bl;
        }
        return bl;
    }

    private ExtendedLinkSummary a(Relationship relationship) {
        Linkbase linkbase;
        if (!relationship.isReadOnly()) {
            return new ExtendedLinkSummary(relationship.arc().getOwnerExtended(), this.dts);
        }
        if (!relationship.isSingle()) {
            Relationship[] relationshipArray = relationship.toArray();
            int n = relationshipArray.length;
            int n2 = 0;
            while (n2 < n) {
                linkbase = relationshipArray[n2];
                if (!linkbase.isReadOnly()) {
                    return new ExtendedLinkSummary(linkbase.arc().getOwnerExtended(), this.dts);
                }
                ++n2;
            }
        }
        if ((linkbase = this.n()) == null) {
            return null;
        }
        ExtendedLink extendedLink = linkbase.createExtendedLink((QName)QNameConstants.definitionLink);
        extendedLink.setRole(relationship.getOwnerExtended().getRole());
        linkbase.appendChild((XdmNode)extendedLink);
        ExtendedLinkSummary extendedLinkSummary = new ExtendedLinkSummary(extendedLink, this.dts);
        return extendedLinkSummary;
    }

    private boolean a(f f2, List<RelationshipSet> list) {
        Relationship relationship4;
        ExtendedLinkSummary extendedLinkSummary;
        Relationship relationship2;
        Relationship relationship3;
        String string;
        Object object;
        Object object222;
        XbrlConcept xbrlConcept = f2.a;
        RelationshipSet relationshipSet = f2.b;
        boolean bl = false;
        block0: for (Object object222 : relationshipSet.getParents((Object)xbrlConcept)) {
            for (Relationship relationship4 : relationshipSet.getChildren(object222.fromTarget())) {
                if (relationship4 == object222 || relationship4.toConcept() == null || relationship4.toConcept().isDimension()) continue;
                bl = true;
                continue block0;
            }
        }
        if (!bl) {
            return false;
        }
        Object object3 = object222 = relationshipSet.getRoleURI();
        char c2 = '`';
        while (true) {
            boolean bl2 = false;
            for (RelationshipSet roleTypeArray2 : list) {
                if (!((String)object3).equals(roleTypeArray2.getRoleURI())) continue;
                bl2 = true;
                break;
            }
            if (!bl2) break;
            char c3 = (char)(c2 + 1);
            c2 = c3;
            object3 = String.valueOf(object222) + c3;
        }
        Linkbase linkbase = this.n();
        if (linkbase == null) {
            return false;
        }
        RoleType[] roleTypeArray = this.dts.getRoleTypes().get((String)object222);
        if ('`' != c2) {
            object = null;
            if (roleTypeArray != null && roleTypeArray.length > 0) {
                string = roleTypeArray[0].getId();
                object = roleTypeArray[0].getDefinitionText();
                int usedOn = ((String)object).indexOf("]");
                if (usedOn != -1) {
                    object = ((String)object).substring(usedOn + 1).trim();
                }
                if (!StringUtils.isEmpty((String)string)) {
                    string = String.valueOf(string) + c2;
                    relationship3 = this.createRoleType((String)object3, string, (String)object);
                    relationship2 = linkbase.createRoleRef((String)object3, null);
                    linkbase.prependChild((XdmNode)relationship2);
                    relationship2.setRoleType((RoleType)relationship3);
                }
            }
        } else if (roleTypeArray != null && roleTypeArray.length > 0) {
            object = roleTypeArray[0];
            string = linkbase.createRoleRef((String)object3, null);
            linkbase.prependChild((XdmNode)string);
            string.setRoleType((RoleType)object);
        }
        object = linkbase.createExtendedLink((QName)QNameConstants.definitionLink);
        object.setRole((String)object3);
        linkbase.appendChild((XdmNode)object);
        string = this.dts.getRoleTypes().getSingle((String)object3);
        if (string != null && !string.canUsedOn((QName)QNameConstants.definitionLink)) {
            UsedOn extendedLinkSummary2 = string.createUsedOn((QName)QNameConstants.definitionLink);
            string.appendChild((XdmNode)extendedLinkSummary2);
        }
        if ((relationship2 = (extendedLinkSummary = new ExtendedLinkSummary((ExtendedLink)object, this.dts)).addRelationship((relationship3 = f2.e).fromConcept(), relationship3.toConcept(), (QName)QNameConstants.definitionArc, "http://xbrl.org/int/dim/arcrole/all")) == null) {
            return false;
        }
        DefinitionArc definitionArc = (DefinitionArc)relationship2.arc();
        definitionArc.setOrder(relationship3.arc().getOrder());
        definitionArc.setContextElement(ContextElementType.Scenario);
        definitionArc.setClosed(true);
        for (Relationship relationship4 : relationshipSet.getChildren(relationship3.fromTarget())) {
            XbrlConcept xbrlConcept2;
            if (relationship4 == relationship3 || (xbrlConcept2 = relationship4.toConcept()) == null || xbrlConcept2.isDimension() || xbrlConcept2.isHypercube()) continue;
            this.b(extendedLinkSummary, relationship4, relationshipSet, new HashSet<Relationship>());
        }
        this.a(extendedLinkSummary, xbrlConcept, relationshipSet);
        relationship4 = this.dts.getRelationshipSet((QName)QNameConstants.definitionLink, (String)object3);
        if (relationship4 != null) {
            this.b.add(relationship4);
            list.add((RelationshipSet)relationship4);
        } else {
            LogWatch.error((Object)("create definitionRS lost: " + (String)object3));
        }
        return true;
    }

    private boolean a(ExtendedLinkSummary extendedLinkSummary, XbrlConcept xbrlConcept, RelationshipSet relationshipSet) {
        XbrlConcept xbrlConcept2 = xbrlConcept;
        if (xbrlConcept2 == null || relationshipSet == null) {
            return false;
        }
        for (Relationship relationship : relationshipSet.getChildren((Object)xbrlConcept)) {
            XbrlConcept xbrlConcept3 = relationship.toConcept();
            if (xbrlConcept3 == null || !xbrlConcept3.isDimension()) continue;
            Relationship relationship2 = extendedLinkSummary.addRelationship(xbrlConcept2, xbrlConcept3, (QName)QNameConstants.definitionArc, "http://xbrl.org/int/dim/arcrole/hypercube-dimension");
            if (relationship2 == null) {
                return false;
            }
            relationship2.arc().setOrder(relationship.arc().getOrder());
            List list = relationshipSet.getChildren((Object)xbrlConcept3);
            for (Relationship relationship3 : list) {
                this.a(extendedLinkSummary, relationship3, relationshipSet, new HashSet<Relationship>());
                if (list.size() != 1) continue;
                QName qName = this.dts.getDefaultDimensionMember(xbrlConcept3.getQName());
                XbrlConcept xbrlConcept4 = relationship3.toConcept();
                if (xbrlConcept4 == null || qName != null && !qName.equals(xbrlConcept4.getQName())) continue;
                this.a(extendedLinkSummary, relationship3);
            }
        }
        return true;
    }

    private boolean a(ExtendedLinkSummary extendedLinkSummary, Relationship relationship, RelationshipSet relationshipSet) {
        XbrlConcept xbrlConcept = relationship.fromConcept();
        if (xbrlConcept == null || relationshipSet == null) {
            return false;
        }
        XbrlConcept xbrlConcept2 = relationship.toConcept();
        if (xbrlConcept2 == null || !xbrlConcept2.isDimension()) {
            return false;
        }
        Relationship relationship2 = extendedLinkSummary.addRelationship(xbrlConcept, xbrlConcept2, (QName)QNameConstants.definitionArc, "http://xbrl.org/int/dim/arcrole/hypercube-dimension");
        if (relationship2 == null) {
            return false;
        }
        relationship2.arc().setOrder(relationship.arc().getOrder());
        List list = relationshipSet.getChildren((Object)xbrlConcept2);
        for (Relationship relationship3 : list) {
            this.a(extendedLinkSummary, relationship3, relationshipSet, new HashSet<Relationship>());
            if (list.size() != 1) continue;
            QName qName = this.dts.getDefaultDimensionMember(xbrlConcept2.getQName());
            XbrlConcept xbrlConcept3 = relationship3.toConcept();
            if (xbrlConcept3 == null || qName != null && !qName.equals(xbrlConcept3.getQName())) continue;
            this.a(extendedLinkSummary, relationship3);
        }
        return true;
    }

    private boolean a(ExtendedLinkSummary extendedLinkSummary, Relationship relationship, RelationshipSet relationshipSet, Set<Relationship> set) {
        if (set.contains(relationship)) {
            return true;
        }
        XbrlConcept xbrlConcept = relationship.fromConcept();
        XbrlConcept xbrlConcept2 = relationship.toConcept();
        if (xbrlConcept == null || xbrlConcept2 == null) {
            return false;
        }
        if (!extendedLinkSummary.containsRelationship(xbrlConcept, xbrlConcept2, "http://xbrl.org/int/dim/arcrole/dimension-domain")) {
            Relationship relationship2 = extendedLinkSummary.addRelationship(xbrlConcept, xbrlConcept2, (QName)QNameConstants.definitionArc, "http://xbrl.org/int/dim/arcrole/dimension-domain");
            if (relationship2 == null) {
                return false;
            }
            relationship2.arc().setOrder(relationship.arc().getOrder());
        }
        set.add(relationship);
        for (Relationship relationship2 : relationshipSet.getChildren((Object)xbrlConcept2)) {
            this.b(extendedLinkSummary, relationship2, relationshipSet, set);
        }
        return true;
    }

    private boolean a(ExtendedLinkSummary extendedLinkSummary, Relationship relationship) {
        XbrlConcept xbrlConcept = relationship.fromConcept();
        XbrlConcept xbrlConcept2 = relationship.toConcept();
        if (xbrlConcept == null || xbrlConcept2 == null) {
            return false;
        }
        Relationship relationship2 = extendedLinkSummary.addRelationship(xbrlConcept, xbrlConcept2, (QName)QNameConstants.definitionArc, "http://xbrl.org/int/dim/arcrole/dimension-default");
        if (relationship2 == null) {
            return false;
        }
        relationship2.arc().setOrder("2.0");
        return true;
    }

    private int b(ExtendedLinkSummary extendedLinkSummary, Relationship relationship, RelationshipSet relationshipSet, Set<Relationship> set) {
        if (extendedLinkSummary == null || relationship == null) {
            return 0;
        }
        if (set.contains(relationship)) {
            return 0;
        }
        XbrlConcept xbrlConcept = relationship.fromConcept();
        XbrlConcept xbrlConcept2 = relationship.toConcept();
        if (xbrlConcept == null || xbrlConcept2 == null) {
            return 0;
        }
        int n = 0;
        if (!extendedLinkSummary.containsRelationship(xbrlConcept, xbrlConcept2, "http://xbrl.org/int/dim/arcrole/domain-member")) {
            Relationship relationship2 = extendedLinkSummary.addRelationship(xbrlConcept, xbrlConcept2, (QName)QNameConstants.definitionArc, "http://xbrl.org/int/dim/arcrole/domain-member");
            if (relationship2 == null) {
                return 0;
            }
            relationship2.arc().setOrder(relationship.arc().getOrder());
            ++n;
        }
        set.add(relationship);
        for (Relationship relationship2 : relationshipSet.getChildren((Object)xbrlConcept2)) {
            n += this.b(extendedLinkSummary, relationship2, relationshipSet, set);
        }
        return n;
    }

    private ExtendedLink b(RelationshipSet relationshipSet) {
        for (Relationship relationship : relationshipSet.getRelationships()) {
            if (relationship.isReadOnly()) continue;
            return relationship.arc().getOwnerExtended();
        }
        return null;
    }

    private Linkbase n() {
        RelationshipSet relationshipSet2;
        for (RelationshipSet relationshipSet2 : this.l) {
            for (Relationship relationship : relationshipSet2.getRelationships()) {
                if (relationship.isReadOnly()) continue;
                return relationship.arc().getOwnerExtended().getOwnerLinkbase();
            }
        }
        relationshipSet2 = null;
        IXbrlDocument[] iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                Object object = linkbase.getFirstChild();
                while (object != null) {
                    if (object.getNodeNature() == 2 && QNameConstants.definitionLink.equals((Object)object.getNodeName())) {
                        this.a(linkbase);
                        return linkbase;
                    }
                    object = object.getNextSibling();
                }
                object = xbrlDocument.getBaseURI();
                if (((String)object).endsWith("definition.xml") || ((String)object).endsWith("def.xml")) {
                    relationshipSet2 = linkbase;
                }
            }
            ++n2;
        }
        this.a((Linkbase)relationshipSet2);
        return relationshipSet2;
    }

    private void o() {
        if (this.xbrlInstance == null || StringUtils.isEmpty((String)this.extendNamespaceURI)) {
            return;
        }
        this.f = this.xbrlInstance.getAllFacts(true);
        try {
            for (Map.Entry<QName, List<Fact>> entry : this.f.entrySet()) {
                XbrlConcept xbrlConcept = this.dts.getConcept(entry.getKey());
                if (xbrlConcept != null || (xbrlConcept = this.dts.getConcept(entry.getKey().getLocalPart(), this.extendNamespaceURI)) == null) continue;
                boolean bl = xbrlConcept.getPeriodType() == PeriodType.Duration;
                for (Fact fact : entry.getValue()) {
                    boolean bl2;
                    Context context = fact.getContext();
                    boolean bl3 = context == null ? false : (bl2 = context.getPeriodType() == PeriodType.Duration);
                    if (bl != bl2) continue;
                    String string = fact.getNamespaceURI();
                    String string2 = fact.getPrefixOfNamespace(string);
                    Fact fact2 = this.xbrlInstance.createFact(xbrlConcept.getQName());
                    fact.copyTo(fact2);
                    XdmElement xdmElement = fact.getParent();
                    xdmElement.insertBefore((XdmNode)fact2, (XdmNode)fact);
                    xdmElement.removeChild((XdmNode)fact);
                    fact2.removeAttributeNode(string2, "http://www.w3.org/2000/xmlns/");
                    this._hasBugFixed = true;
                    this.fixBug("fact " + fact.getLocalName() + " ns: " + fact.getNamespaceURI() + " ->" + this.extendNamespaceURI);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean removeConcept(String qname) {
        QName qName;
        XbrlSchema xbrlSchema;
        this._targetAction = Cleaner.TargetAction.RemoveConcept;
        if (StringUtils.isEmpty((String)qname)) {
            IOHelper.writeMessage((OutputStream)this.out, (String)"\u8bf7\u63d0\u4f9b\u5220\u9664\u7684\u5143\u7d20\u540d\uff01");
            return false;
        }
        OutputStream outputStream = this.out;
        this.out = null;
        this.bugFix();
        this.out = outputStream;
        XbrlSchema xbrlSchema2 = null;
        Object object22 = this.getEntrySchema();
        int n = ((XbrlSchema[])object22).length;
        int n2 = 0;
        while (n2 < n) {
            xbrlSchema = object22[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                xbrlSchema2 = xbrlSchema;
            }
            ++n2;
        }
        if (xbrlSchema2 == null) {
            IOHelper.writeMessage((OutputStream)this.out, (String)"\u6ca1\u6709\u627e\u5230\u53ef\u7f16\u8f91\u7684\u5165\u53e3\u5206\u7c7b\u6807\u51c6\uff01");
            return false;
        }
        xbrlSchema = null;
        if (qname.contains(":")) {
            xbrlSchema = this.dts.getConcept(qname);
        } else {
            XmlSchemaElement xmlSchemaElement = xbrlSchema2.getElementByName(qname);
            if (xmlSchemaElement != null && xmlSchemaElement instanceof XbrlConcept) {
                xbrlSchema = (XbrlConcept)xmlSchemaElement;
            }
        }
        if (xbrlSchema != null && xbrlSchema.getSchema().isReadOnly()) {
            IOHelper.writeMessage((OutputStream)this.out, (String)(String.valueOf(qname) + "\u5143\u7d20\u6240\u5728Schema\u6587\u4ef6\u4e0d\u53ef\u4fee\u6539\uff01"));
            return false;
        }
        QName qName2 = qName = xbrlSchema != null ? xbrlSchema.getQName() : null;
        if (xbrlSchema == null) {
            n = qname.indexOf(":");
            if (n != -1) {
                object22 = this.dts.getNamespaceOfPrefix(qname.substring(0, n));
                if (StringUtils.isEmpty((String)object22)) {
                    IOHelper.writeMessage((OutputStream)this.out, (String)"\u89e3\u6790\u5143\u7d20\u540d\u5931\u8d25\uff0c\u524d\u7f00\u672a\u5b9a\u4e49\uff01");
                    return false;
                }
                qName = xbrlSchema2.createQName((String)object22, qname.substring(n + 1));
            } else {
                qName = xbrlSchema2.createQName(xbrlSchema2.getTargetNamespace(), qname);
            }
        }
        if (this.xbrlInstance != null) {
            this.f = this.xbrlInstance.getAllFacts(true);
            List<Fact> list = this.f.get(qName);
            if (list != null) {
                for (Object object22 : list) {
                    IOHelper.writeMessage((OutputStream)this.out, (String)("remove " + object22.toString()));
                    this._hasBugFixed = true;
                    object22.getParent().removeChild((XdmNode)object22);
                    object22.getOwnerDocument().setModified(true);
                }
            }
            this.f.remove(qName);
            object22 = this.xbrlInstance.getAllItemsGroupByContext();
            for (Context context : this.xbrlInstance.getContexts()) {
                MemberElement[] memberElementArray;
                Map map = context.getDimensionContents();
                boolean bl = map.containsKey(qName);
                if (!bl) {
                    Iterator iterator = map.values().iterator();
                    block3: while (iterator.hasNext()) {
                        MemberElement[] memberElementArray2 = memberElementArray = (MemberElement[])iterator.next();
                        int n3 = memberElementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            MemberElement memberElement = memberElementArray2[n4];
                            if (memberElement instanceof ExplicitMember && qName.equals(((ExplicitMember)memberElement).getDimensionContent())) {
                                bl = true;
                                continue block3;
                            }
                            ++n4;
                        }
                    }
                }
                if (!bl) continue;
                memberElementArray = (MemberElement[])object22.get(context);
                if (memberElementArray != null) {
                    for (Fact fact : memberElementArray) {
                        IOHelper.writeMessage((OutputStream)this.out, (String)("remove " + fact.toString()));
                        fact.getParent().removeChild((XdmNode)fact);
                        fact.getOwnerDocument().setModified(true);
                        this._hasBugFixed = true;
                    }
                }
                context.getParent().removeChild((XdmNode)context);
                context.getOwnerDocument().setModified(true);
                this._hasBugFixed = true;
            }
        }
        if (xbrlSchema != null) {
            XbrlSchema xbrlSchema3 = xbrlSchema.getSchema();
            if (xbrlSchema.getSchema().removeConcept(this.dts, (XbrlConcept)xbrlSchema, true)) {
                xbrlSchema3.setModified(true);
                this._hasBugFixed = true;
                IOHelper.writeMessage((OutputStream)this.out, (String)"\u5220\u9664\u5143\u7d20\u5b9a\u4e49\u53ca\u5176\u5173\u7cfb.");
            }
        }
        outputStream = this.out;
        this.out = null;
        if (this.b.size() > 0) {
            this.rebuildRelationshipSet();
            this.ab();
        }
        return this._hasBugFixed;
    }

    public boolean adjustDecimals(String roleURI, String conceptId) {
        Object object;
        this._targetAction = Cleaner.TargetAction.AdjustDecimals;
        OutputStream outputStream = this.out;
        this.out = null;
        this.bugFix();
        this.out = outputStream;
        if (this.xbrlInstance == null) {
            return false;
        }
        XbrlConcept xbrlConcept = null;
        if (!StringUtils.isEmpty((String)conceptId) && (xbrlConcept = this.dts.getConceptById(conceptId)) == null) {
            IOHelper.writeMessage((OutputStream)this.out, (String)("\u6307\u5b9a\u7684\u6839\u5143\u7d20\u672a\u627e\u5230\uff1a" + conceptId));
            return false;
        }
        if (this.f == null) {
            this.f = this.xbrlInstance.getAllFacts(true);
        }
        ArrayList<RelationshipSet> arrayList = null;
        if (!StringUtils.isEmpty((String)roleURI)) {
            object = this.dts.getPresentationRelationships(roleURI);
            if (object == null) {
                IOHelper.writeMessage((OutputStream)this.out, (String)("\u5c55\u793a\u5173\u7cfb\u6ca1\u6709\u627e\u5230\uff1a" + roleURI));
                return false;
            }
            arrayList = new ArrayList();
            arrayList.add((RelationshipSet)object);
        } else {
            arrayList = new ArrayList<RelationshipSet>();
            arrayList.addAll(this.dts.getPresentationRelationships());
        }
        object = new c(xbrlConcept);
        for (RelationshipSet relationshipSet : arrayList) {
            this.a(relationshipSet, (c)object);
        }
        return this._hasBugFixed;
    }

    private void a(RelationshipSet relationshipSet, c c2) {
        if (this.f == null || this.f.size() == 0) {
            return;
        }
        Set<Object> set = c2.b;
        MutableInteger mutableInteger = c2.c;
        Set<XbrlConcept> set2 = c2.d;
        Set<XbrlConcept> set3 = c2.e;
        Set<XbrlConcept> set4 = c2.f;
        Set<XbrlConcept> set5 = c2.g;
        set.clear();
        set2.clear();
        set3.clear();
        set4.clear();
        set5.clear();
        if (c2.a == null) {
            relationshipSet.getAllTargets(set);
        } else {
            this.a(relationshipSet, (Object)c2.a, set, new HashSet<Relationship>());
        }
        int[] nArray = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
        boolean bl = false;
        for (Object object : set) {
            List<Fact> list;
            int n;
            XbrlConcept xbrlConcept;
            if (!(object instanceof XbrlConcept) || (xbrlConcept = (XbrlConcept)object).isAbstract() || xbrlConcept.isNonNumeric() || (n = CasProcessor.getConceptDataType(xbrlConcept)) == -1 || (list = this.f.get(xbrlConcept.getQName())) == null || list.size() == 0) continue;
            switch (n) {
                case 4: {
                    set2.add(xbrlConcept);
                    break;
                }
                case 6: {
                    set3.add(xbrlConcept);
                    break;
                }
                case 0: {
                    set4.add(xbrlConcept);
                    break;
                }
                case 2: {
                    set5.add(xbrlConcept);
                }
            }
            int n2 = Integer.MAX_VALUE;
            int n3 = Integer.MAX_VALUE;
            bl = true;
            for (Fact fact : list) {
                String string = fact.getDecimals();
                if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !Int32.tryParse((String)string, (MutableInteger)mutableInteger)) continue;
                if (n2 == Integer.MAX_VALUE || n2 > mutableInteger.intValue()) {
                    n2 = mutableInteger.intValue();
                }
                if (n3 != Integer.MAX_VALUE && n3 >= mutableInteger.intValue()) continue;
                n3 = mutableInteger.intValue();
            }
            if (n2 != Integer.MAX_VALUE && (nArray[n] == Integer.MAX_VALUE || nArray[n] > n2)) {
                nArray[n] = n2;
            }
            if (n3 == Integer.MAX_VALUE || nArray[n + 1] != Integer.MAX_VALUE && nArray[n + 1] >= n3) continue;
            nArray[n + 1] = n3;
        }
        if (bl) {
            if (nArray[4] != nArray[5]) {
                this.c(c2);
            }
            if (nArray[6] != nArray[7]) {
                this.d(c2);
            }
            if (nArray[2] != nArray[3]) {
                this.e(c2);
            }
            if (nArray[0] != nArray[1]) {
                this.a(c2);
            }
        }
    }

    private void a(c c2) {
        Pair<Integer, Integer> pair = this.b(c2);
        int n = (Integer)pair.value;
        if ((Integer)pair.value == 2) {
            for (XbrlConcept xbrlConcept : c2.f) {
                for (Fact fact : this.f.get(xbrlConcept.getQName())) {
                    String string = fact.getDecimals();
                    if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !StringUtils.isEmpty((String)fact.getAttributeValue(customDecimalsQName)) || !Int32.tryParse((String)string, (MutableInteger)c2.c) || c2.c.intValue() < 0 || c2.c.intValue() >= n) continue;
                    String string2 = fact.toString();
                    fact.setDecimals(Integer.toString(n));
                    String string3 = fact.getInnerText();
                    String string4 = Fact.getDecimalRoundedValue((String)string3, (int)n);
                    fact.setInnerText(string4);
                    this.fixBug(String.valueOf(string2) + " @decimals=" + c2.c + "->" + n);
                }
            }
        }
    }

    private Pair<Integer, Integer> a(XbrlConcept xbrlConcept, c c2) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        MutableInteger mutableInteger = c2.c;
        for (Fact fact : this.f.get(xbrlConcept.getQName())) {
            String string = fact.getDecimals();
            if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !StringUtils.isEmpty((String)fact.getAttributeValue(customDecimalsQName)) || !Int32.tryParse((String)string, (MutableInteger)mutableInteger)) continue;
            if (n == Integer.MAX_VALUE || n > mutableInteger.intValue()) {
                n = mutableInteger.intValue();
            }
            if (n2 != Integer.MAX_VALUE && n2 >= mutableInteger.intValue()) continue;
            n2 = mutableInteger.intValue();
        }
        return new Pair((Object)n, (Object)n2);
    }

    private Pair<Integer, Integer> b(c c2) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        MutableInteger mutableInteger = c2.c;
        for (XbrlConcept xbrlConcept : c2.f) {
            for (Fact fact : this.f.get(xbrlConcept.getQName())) {
                String string = fact.getDecimals();
                if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !StringUtils.isEmpty((String)fact.getAttributeValue(customDecimalsQName)) || !Int32.tryParse((String)string, (MutableInteger)mutableInteger)) continue;
                if (n == Integer.MAX_VALUE || n > mutableInteger.intValue()) {
                    n = mutableInteger.intValue();
                }
                if (n2 != Integer.MAX_VALUE && n2 >= mutableInteger.intValue()) continue;
                n2 = mutableInteger.intValue();
            }
        }
        return new Pair((Object)n, (Object)n2);
    }

    private void c(c c2) {
        for (XbrlConcept xbrlConcept : c2.d) {
            Pair<Integer, Integer> pair = this.a(xbrlConcept, c2);
            if ((Integer)pair.key == Integer.MAX_VALUE || pair.key == pair.value) continue;
            int n = (Integer)pair.value;
            for (Fact fact : this.f.get(xbrlConcept.getQName())) {
                String string = fact.getDecimals();
                if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !StringUtils.isEmpty((String)fact.getAttributeValue(customDecimalsQName)) || !Int32.tryParse((String)string, (MutableInteger)c2.c) || c2.c.intValue() >= n) continue;
                String string2 = fact.toString();
                fact.setDecimals(Integer.toString(n));
                String string3 = fact.getInnerText();
                String string4 = Fact.getDecimalRoundedValue((String)string3, (int)n);
                fact.setInnerText(string4);
                this.fixBug(String.valueOf(string2) + " @decimals=" + c2.c + "->" + n);
            }
        }
    }

    private void d(c c2) {
        for (XbrlConcept xbrlConcept : c2.e) {
            Pair<Integer, Integer> pair = this.a(xbrlConcept, c2);
            if ((Integer)pair.key == Integer.MAX_VALUE || pair.key == pair.value) continue;
            int n = (Integer)pair.value;
            for (Fact fact : this.f.get(xbrlConcept.getQName())) {
                String string = fact.getDecimals();
                if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !StringUtils.isEmpty((String)fact.getAttributeValue(customDecimalsQName)) || !Int32.tryParse((String)string, (MutableInteger)c2.c) || c2.c.intValue() >= n) continue;
                String string2 = fact.toString();
                fact.setDecimals(Integer.toString(n));
                String string3 = fact.getInnerText();
                String string4 = Fact.getDecimalRoundedValue((String)string3, (int)n);
                fact.setInnerText(string4);
                this.fixBug(String.valueOf(string2) + " @decimals=" + c2.c + "->" + n);
            }
        }
    }

    private void e(c c2) {
        for (XbrlConcept xbrlConcept : c2.g) {
            Pair<Integer, Integer> pair = this.a(xbrlConcept, c2);
            if ((Integer)pair.key == Integer.MAX_VALUE || pair.key == pair.value) continue;
            int n = (Integer)pair.value;
            for (Fact fact : this.f.get(xbrlConcept.getQName())) {
                String string = fact.getDecimals();
                if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !StringUtils.isEmpty((String)fact.getAttributeValue(customDecimalsQName)) || !Int32.tryParse((String)string, (MutableInteger)c2.c) || c2.c.intValue() >= n) continue;
                String string2 = fact.toString();
                fact.setDecimals(Integer.toString(n));
                String string3 = fact.getInnerText();
                String string4 = Fact.getDecimalRoundedValue((String)string3, (int)n);
                fact.setInnerText(string4);
                this.fixBug(String.valueOf(string2) + " @decimals=" + c2.c + "->" + n);
            }
        }
    }

    public boolean changeConcepts(List<Pair<String, String>> changePairs) {
        if (changePairs == null || changePairs.size() == 0) {
            return true;
        }
        ArrayList<ChangeConceptInfo> arrayList = new ArrayList<ChangeConceptInfo>();
        for (Pair<String, String> pair : changePairs) {
            arrayList.add(new ChangeConceptInfo(pair));
        }
        return this.changeConceptNameAndLabel(arrayList);
    }

    @Override
    public boolean changeConceptNameAndLabel(List<ChangeConceptInfo> changePairs) {
        Object object;
        this._targetAction = Cleaner.TargetAction.ChangeConceptName;
        if (changePairs == null || changePairs.size() == 0) {
            return false;
        }
        OutputStream outputStream = this.out;
        this.out = null;
        this.bugFix();
        this.out = outputStream;
        Object object2 = null;
        XbrlSchema[] xbrlSchemaArray = this.getEntrySchema();
        boolean bl = xbrlSchemaArray.length;
        boolean bl2 = false;
        while (bl2 < bl) {
            object = xbrlSchemaArray[bl2];
            if (object != null && !object.isReadOnly()) {
                object2 = object;
            }
            bl2 += 1;
        }
        if (object2 == null) {
            return false;
        }
        if (this.xbrlInstance != null) {
            this.f = this.xbrlInstance.getAllFacts(true);
        }
        object = object2.getTargetNamespace();
        bl2 = this.isCurrentFiscalYearComplete();
        for (ChangeConceptInfo changeConceptInfo : changePairs) {
            XbrlConcept xbrlConcept;
            boolean bl3;
            boolean bl4;
            XbrlConcept xbrlConcept2;
            String string;
            String string2;
            Object object3 = object;
            String string3 = changeConceptInfo.getOldConceptName();
            String string4 = changeConceptInfo.getOldConceptName();
            String string5 = changeConceptInfo.getNewConceptName();
            int n = changeConceptInfo.getOldConceptName().indexOf(":");
            if (n != -1) {
                string2 = changeConceptInfo.getOldConceptName().substring(0, n);
                string3 = changeConceptInfo.getOldConceptName().substring(n + 1);
                object3 = this.dts.getNamespaceOfPrefix(string2);
                if (StringUtils.isEmpty((String)object3)) {
                    this.fixBug("Old concept: " + changeConceptInfo.getOldConceptName() + " prefix is not valid.", true);
                    continue;
                }
            } else {
                string4 = String.valueOf(object2.defaultPrefix()) + ":" + string3;
            }
            string2 = string5;
            Object object4 = object;
            n = string5.indexOf(":");
            if (n != -1) {
                string = string5.substring(0, n);
                string2 = string5.substring(n + 1);
                object4 = this.dts.getNamespaceOfPrefix(string);
                if (StringUtils.isEmpty((String)object4)) {
                    this.fixBug("New concept: " + string5 + " prefix is not valid.", true);
                    continue;
                }
            }
            if (!XmlChar.isNCName((String)string2)) {
                this.fixBug("New concept: " + string5 + " localName is not valid.", true);
                continue;
            }
            string = this.dts.getConcept(string3, (String)object3);
            XmlSchemaElement xmlSchemaElement = null;
            if (((String)object4).equals(object)) {
                xmlSchemaElement = object2.getElementByName(string2);
            } else {
                xbrlConcept2 = this.dts.getSchemas((String)object4);
                if (xbrlConcept2 != null && ((XmlSchema[])xbrlConcept2).length > 0) {
                    XbrlConcept xbrlConcept3 = xbrlConcept2;
                    bl4 = ((XmlSchema[])xbrlConcept3).length;
                    bl3 = false;
                    while (bl3 < bl4) {
                        xbrlConcept = xbrlConcept3[bl3];
                        xmlSchemaElement = xbrlConcept.getElementByName(string2);
                        if (xmlSchemaElement != null) break;
                        bl3 += 1;
                    }
                }
                if (xmlSchemaElement == null) {
                    this.fixBug("New concept: " + string5 + " is not found in the DTS.", true);
                    continue;
                }
            }
            if (changeConceptInfo.isChangeLabel() && string != null && string instanceof XbrlConcept) {
                xbrlConcept2 = (XbrlConcept)string;
                this.a(xbrlConcept2, changeConceptInfo);
            }
            if (!changeConceptInfo.isChangeName()) continue;
            if (string == null) {
                this.fixBug("Old concept: " + string3 + " not found.", true);
                xbrlConcept2 = object2.createQName((String)object3, string3);
                if (xmlSchemaElement == null || !(xmlSchemaElement instanceof XbrlConcept)) continue;
                this.changeMenuConcept(string4, string5);
                if (!this.a((QName)xbrlConcept2, (XbrlConcept)xmlSchemaElement, false)) continue;
                this.a(xmlSchemaElement.getQName());
                this.fixBug("Change missing old concept: " + changeConceptInfo.getOldConceptName() + " to " + string5 + ".", true);
                continue;
            }
            if (!(string instanceof XbrlConcept)) {
                this.fixBug("Old concept: " + changeConceptInfo.getOldConceptName() + " is not an Xbrl concept.", true);
                continue;
            }
            xbrlConcept2 = (XbrlConcept)string;
            if (!xbrlConcept2.isItem()) {
                this.fixBug("Old concept: " + changeConceptInfo.getOldConceptName() + " is not a top item concept.", true);
                continue;
            }
            xbrlConcept = null;
            bl3 = false;
            bl4 = false;
            if (xmlSchemaElement != null) {
                if (xmlSchemaElement instanceof XbrlConcept) {
                    xbrlConcept = (XbrlConcept)xmlSchemaElement;
                    bl3 = true;
                } else {
                    this.fixBug("New concept: " + string5 + " is not an Xbrl concept.", true);
                    continue;
                }
            }
            if (bl3 && this.f != null && xbrlConcept != null && this.f.containsKey(xbrlConcept2.getQName())) {
                if (xbrlConcept.isAbstract()) {
                    this.fixBug("New concept: " + string5 + " is abstract, old concept is used in instance.", true);
                    continue;
                }
                if (xbrlConcept.isNumeric() != xbrlConcept2.isNumeric() || xbrlConcept.isMonetaryItem() != xbrlConcept2.isMonetaryItem()) {
                    this.fixBug("Old concept: " + changeConceptInfo.getOldConceptName() + "'s dataType is differenct from the new concept.", true);
                    continue;
                }
                if (xbrlConcept.getPeriodType() != xbrlConcept2.getPeriodType()) {
                    boolean bl5;
                    boolean bl6 = bl5 = bl2 && this.canChangeContext(bl2, this.f.get(xbrlConcept2.getQName()));
                    if (!bl5) {
                        this.fixBug("Old concept: " + changeConceptInfo.getOldConceptName() + "'s periodType is differenct from the new concept.", true);
                        continue;
                    }
                    bl4 = true;
                }
            }
            if (xbrlConcept == null) {
                xbrlConcept = this.a((XbrlSchema)object2, string2, xbrlConcept2);
            }
            if (xbrlConcept == null) continue;
            if (bl3) {
                this.a(xbrlConcept2);
            }
            this.a(xbrlConcept2, xbrlConcept);
            this.a(xbrlConcept2.getQName(), xbrlConcept, bl4);
            if (xbrlConcept2.getSchema() == object2) {
                object2.removeItem((XmlSchemaObject)xbrlConcept2);
            }
            if (this.p != null && xbrlConcept.getLabels(this.dts).size() == 0) {
                this.a(xbrlConcept, this.p.getLabelRelationships(), this.dts.getLabelRelationships());
            } else {
                this.t();
            }
            this.a(xbrlConcept.getQName());
            this.fixBug("change concept: " + xbrlConcept2.getPrefixedName() + " --> " + xbrlConcept.getPrefixedName());
            this.changeMenuConcept(string4, string5);
        }
        return this._hasBugFixed;
    }

    private void a(XbrlConcept xbrlConcept, ChangeConceptInfo changeConceptInfo) {
        if (this.r == null) {
            this.r = this.dts.getLabelRelationships();
        }
        for (RelationshipSet relationshipSet : this.r) {
            for (Relationship relationship : relationshipSet.getChildren((Object)xbrlConcept)) {
                Label label;
                boolean bl;
                Object object;
                if (relationship.arc().getUse() != ArcUse.Optional || (object = relationship.toTarget()) == null || !(object instanceof Label) || !(bl = "http://www.xbrl.org/2003/role/label".equals((label = (Label)object).getRole())) || !label.getLang().startsWith("en") || StringUtils.isEmpty((String)changeConceptInfo.getNewEnglishLabel()) || label.getInnerText().equals(changeConceptInfo.getNewEnglishLabel())) continue;
                label.setInnerText(changeConceptInfo.getNewEnglishLabel());
                this.fixBug("change concept label: " + xbrlConcept.getPrefixedName() + " --> " + changeConceptInfo.getNewEnglishLabel());
                this._hasBugFixed = true;
                label.getOwnerDocument().setModified(true);
            }
        }
    }

    private void a(QName qName) {
        if (this.xbrlInstance == null) {
            return;
        }
        this.f = this.xbrlInstance.getAllFacts(true);
        List<Fact> list = this.f.get(qName);
        if (list == null || list.size() == 0) {
            return;
        }
        int n = list.size() - 1;
        while (n > 0) {
            Fact fact = list.get(n);
            int n2 = n - 1;
            while (n2 > -1) {
                Fact fact2 = list.get(n2);
                if (fact.getParent() == fact2.getParent() && this.a(fact, fact2)) {
                    fact.getParent().removeChild((XdmNode)fact);
                    list.remove(n);
                    break;
                }
                --n2;
            }
            --n;
        }
    }

    private boolean a(Fact fact, Fact fact2) {
        Context context;
        Context context2 = fact.getContext();
        if (context2 != (context = fact2.getContext())) {
            if (context2 == null || context == null) {
                return false;
            }
            if (!context2.SEqual((XbrlElement)context)) {
                return false;
            }
        }
        if (fact.isDuplicate(fact2)) {
            return fact.getInnerText().equals(fact2.getInnerText());
        }
        return false;
    }

    private void a(XbrlConcept xbrlConcept) {
        if (xbrlConcept == null) {
            return;
        }
        for (RelationshipSet relationshipSet : this.dts.getLabelRelationships()) {
            relationshipSet.purgeRelationships((Object)xbrlConcept);
            this._hasBugFixed = true;
        }
        for (RelationshipSet relationshipSet : this.dts.getReferenceRelationships()) {
            relationshipSet.purgeRelationships((Object)xbrlConcept);
            this._hasBugFixed = true;
        }
    }

    private void a(XbrlConcept xbrlConcept, XbrlConcept xbrlConcept2) {
        IXbrlDocument[] iXbrlDocumentArray = this.dts.getDocuments();
        ArrayList<Locator> arrayList = new ArrayList<Locator>();
        ArrayList<Locator> arrayList2 = new ArrayList<Locator>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray;
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                    Locator locator;
                    arrayList.clear();
                    arrayList2.clear();
                    XdmNode xdmNode = extendedLink.getFirstChild();
                    while (xdmNode != null) {
                        if (xdmNode instanceof Locator) {
                            locator = (Locator)xdmNode;
                            Object object = locator.getFinalTarget();
                            if (object == xbrlConcept2) {
                                arrayList2.add(locator);
                            } else if (object == xbrlConcept) {
                                arrayList.add(locator);
                            }
                        }
                        xdmNode = xdmNode.getNextSibling();
                    }
                    if (arrayList.size() <= 0) continue;
                    hashMap.clear();
                    boolean bl = arrayList2.size() > 0;
                    this._hasBugFixed = true;
                    int n3 = 0;
                    int n4 = arrayList.size();
                    while (n3 < n4) {
                        Locator locator2 = (Locator)arrayList.get(n3);
                        String string = locator2.getLabel();
                        String string2 = xbrlConcept.getName();
                        String string3 = xbrlConcept2.getName();
                        String string4 = (String)hashMap.get(string);
                        if (string4 == null) {
                            string4 = string.equals(string2) ? string3 : (string.contains(string2) ? string.replace(string2, string3) : string3);
                            if (bl) {
                                String string5 = string4;
                                int n5 = 1;
                                while (this.a(arrayList2, string5)) {
                                    string5 = String.valueOf(string4) + "_cc_" + ++n5;
                                }
                                string4 = string5;
                            }
                            hashMap.put(string, string4);
                        }
                        locator2.setTarget((Object)xbrlConcept2);
                        locator2.setLabel(string4);
                        this.a(extendedLink, string, string4);
                        ++n3;
                    }
                    locator = this.dts.getRelationshipSet(extendedLink.getNodeName(), extendedLink.getRole());
                    if (locator == null) continue;
                    this.b.add(locator);
                }
            }
            ++n2;
        }
        this.rebuildRelationshipSet();
    }

    private boolean a(List<Locator> list, String string) {
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            Locator locator = list.get(n);
            if (locator.getLabel().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void a(ExtendedLink extendedLink, String string, String string2) {
        XdmNode xdmNode = extendedLink.getFirstChild();
        while (xdmNode != null) {
            if (xdmNode instanceof Arc) {
                Arc arc = (Arc)xdmNode;
                if (arc.getFrom().equals(string)) {
                    arc.setFrom(string2);
                }
                if (arc.getTo().equals(string)) {
                    arc.setTo(string2);
                }
            }
            xdmNode = xdmNode.getNextSibling();
        }
    }

    private XbrlConcept a(XbrlSchema xbrlSchema, String string, XbrlConcept xbrlConcept) {
        String string2 = xbrlSchema.defaultPrefix();
        xbrlSchema.setModified(true);
        XbrlConcept xbrlConcept2 = new XbrlConcept((XmlSchema)xbrlSchema, true);
        xbrlConcept2.addNamespaces(xbrlConcept.getNamespaceContext());
        xbrlConcept2.setName(string);
        xbrlConcept2.setId(String.valueOf(string2) + "_" + string);
        if (xbrlConcept.getSchemaTypeName() != null && !xbrlConcept.getSchemaTypeName().isEmpty()) {
            xbrlConcept2.setSchemaTypeName(xbrlConcept.getSchemaTypeName());
        }
        xbrlConcept2.setPeriodType(xbrlConcept.getPeriodType());
        xbrlConcept2.setBalance(xbrlConcept.getBalance());
        if (xbrlConcept.getRefName() != null) {
            xbrlConcept2.getRef().setTargetQName(xbrlConcept.getRefName());
        }
        xbrlConcept2.setSubstitutionGroup(xbrlConcept.getSubstitutionGroup());
        xbrlConcept2.setNillable(xbrlConcept.isNillable());
        xbrlConcept2.setAbstract(xbrlConcept.isAbstract());
        xbrlConcept2.setMinOccurs(xbrlConcept.getMinOccurs());
        xbrlConcept2.setMaxOccurs(xbrlConcept.getMaxOccurs());
        xbrlConcept2.setDefaultValue(xbrlConcept.getDefaultValue());
        xbrlConcept2.setFixedValue(xbrlConcept.getFixedValue());
        xbrlConcept2.setFinal(xbrlConcept.getFinal());
        xbrlConcept2.setBlock(xbrlConcept.getBlock());
        XdmAttribute[] xdmAttributeArray = xbrlConcept.getUnhandledAttributes();
        if (xdmAttributeArray != null) {
            XdmAttribute[] xdmAttributeArray2 = xdmAttributeArray;
            int n = xdmAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                XdmAttribute xdmAttribute = xdmAttributeArray2[n2];
                xbrlConcept2.addUnhandledAttribute(xdmAttribute);
                ++n2;
            }
        }
        XbrlHelper.processConcept((XbrlConcept)xbrlConcept2);
        return xbrlConcept2;
    }

    private void p() {
        if (this.xbrlInstance == null) {
            return;
        }
        String string = this.xbrlInstance.getAttributeValue((QName)QNameConstants.schemaLocation);
        if (!StringUtils.contains((String)string, (String)"http://xbrl.org/2006/xbrldi")) {
            if (!StringUtils.isEmpty((String)string)) {
                string = String.valueOf(string) + " ";
            }
            this.xbrlInstance.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            string = String.valueOf(string) + "http://xbrl.org/2006/xbrldi" + " " + "http://www.xbrl.org/2006/xbrldi-2006.xsd";
            this.xbrlInstance.setAttribute((QName)QNameConstants.schemaLocation, string);
            this.xbrlInstance.getOwnerDocument().setModified(true);
            this._hasBugFixed = true;
        }
    }

    private void q() {
        if (this.xbrlInstance == null) {
            return;
        }
        this.p();
        this.a(this.xbrlInstance);
        this.g();
        this.f = this.xbrlInstance.getAllFacts(true);
        for (Map.Entry<QName, List<Fact>> entry : this.f.entrySet()) {
            XbrlConcept xbrlConcept = this.dts.getConcept(entry.getKey());
            if (xbrlConcept == null) continue;
            boolean bl = xbrlConcept.getPeriodType() == PeriodType.Duration;
            for (Fact fact : entry.getValue()) {
                boolean bl2;
                Context context = fact.getContext();
                if (context == null) continue;
                boolean bl3 = bl2 = context.getPeriodType() == PeriodType.Duration;
            }
        }
    }

    private void r() {
        try {
            XmlSchema xmlSchema;
            XmlSchema xmlSchema2;
            XmlSchema xmlSchema3;
            HashMap<XmlSchema, XmlSchema> hashMap = new HashMap<XmlSchema, XmlSchema>();
            IXbrlDocument iXbrlDocument = this.dts.getSchemas();
            int n = ((XmlSchema[])iXbrlDocument).length;
            int n2 = 0;
            while (n2 < n) {
                XmlSchema[] xmlSchemaArray;
                XmlSchema xmlSchema4 = iXbrlDocument[n2];
                String string = xmlSchema4.getTargetNamespace();
                if (!StringUtils.isEmpty((String)string) && (xmlSchemaArray = this.dts.getSchemas(string)) != null && xmlSchemaArray.length > 1) {
                    xmlSchema3 = null;
                    Object object = xmlSchemaArray;
                    int n3 = xmlSchemaArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        xmlSchema2 = object[n4];
                        if (xmlSchema2.getSourceURI() != null && xmlSchema2.getSourceURI().startsWith("http:")) {
                            xmlSchema3 = xmlSchema2;
                            break;
                        }
                        ++n4;
                    }
                    if (xmlSchema3 != null) {
                        object = xmlSchemaArray;
                        n3 = xmlSchemaArray.length;
                        n4 = 0;
                        while (n4 < n3) {
                            xmlSchema2 = object[n4];
                            if (xmlSchema2 != xmlSchema3 && xmlSchema2.getSourceURI() != null && !xmlSchema2.getSourceURI().startsWith("http:") && xmlSchema2.getElements().size() == xmlSchema3.getElements().size()) {
                                hashMap.put(xmlSchema2, xmlSchema3);
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
            boolean bl = hashMap.size() > 0;
            HashMap<String, Loc[]> hashMap2 = new HashMap<String, Loc[]>();
            xmlSchema3 = xmlSchema = this.dts.getDocuments();
            int n5 = ((IXbrlDocument[])xmlSchema3).length;
            int n6 = 0;
            while (n6 < n5) {
                iXbrlDocument = xmlSchema3[n6];
                if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xmlSchema2 = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                    Linkbase linkbase = (Linkbase)xmlSchema2.getDocumentElement();
                    for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                        Object object;
                        boolean bl2 = extendedLink.getNodeName().equals(QNameConstants.definitionLink);
                        if (bl2) {
                            hashMap2.clear();
                        }
                        boolean bl3 = false;
                        XdmNode xdmNode2 = extendedLink.getFirstChild();
                        while (xdmNode2 != null) {
                            if (xdmNode2.getNodeNature() == 2 && xdmNode2 instanceof Loc) {
                                String string;
                                XbrlConcept xbrlConcept;
                                String string2;
                                object = (Loc)xdmNode2;
                                Object object2 = object.getFinalTarget();
                                if (object2 == null || object2 == object) {
                                    string2 = object.getHref();
                                    this.reportBug("link:loc lost target, " + string2);
                                    int n7 = string2.lastIndexOf("#");
                                    if (n7 != -1 && (xbrlConcept = this.dts.getConceptById(string = string2.substring(n7 + 1))) != null) {
                                        XmlSchemaElement xmlSchemaElement;
                                        if (bl && hashMap.containsKey(xbrlConcept.getSchema()) && (xmlSchemaElement = ((XmlSchema)hashMap.get(xbrlConcept.getSchema())).getElementByName(xbrlConcept.getQName())) instanceof XbrlConcept) {
                                            xbrlConcept = (XbrlConcept)xmlSchemaElement;
                                        }
                                        object.setTarget((Object)xbrlConcept);
                                        string2 = object.getHref();
                                        this.fixBug("link:loc @xlink:href='" + string2 + "'");
                                        bl3 = true;
                                    }
                                } else if (bl && object2 instanceof XbrlConcept && hashMap.containsKey((string2 = (XbrlConcept)object2).getSchema())) {
                                    String string3 = object.getHref();
                                    this.reportBug("link:loc error target, " + string3);
                                    string = ((XmlSchema)hashMap.get(string2.getSchema())).getElementByName(string2.getQName());
                                    if (string instanceof XbrlConcept) {
                                        object.setTarget((Object)((XbrlConcept)string));
                                        string3 = object.getHref();
                                        this.fixBug("link:loc @xlink:href='" + string3 + "'");
                                        bl3 = true;
                                    }
                                }
                                if (bl2) {
                                    string2 = object.getLabel();
                                    Loc[] locArray = (Loc[])hashMap2.get(string2);
                                    if (locArray == null) {
                                        hashMap2.put(string2, new Loc[]{object});
                                    } else {
                                        string = object.getHref();
                                        Loc[] locArray2 = locArray;
                                        int n8 = locArray.length;
                                        int n9 = 0;
                                        while (n9 < n8) {
                                            xbrlConcept = locArray2[n9];
                                            String string4 = xbrlConcept.getHref();
                                            if (string.equals(string4)) {
                                                object.getParent().removeChild((XdmNode)object);
                                                bl3 = true;
                                                this.fixBug("remove dup link:loc@definitionLink xlink:label=\"" + string2 + "\" xlink:role=\"" + extendedLink.getRole() + "\"", true);
                                            }
                                            ++n9;
                                        }
                                    }
                                }
                            }
                            xdmNode2 = xdmNode2.getNextSibling();
                        }
                        if (bl3) {
                            xdmNode2 = extendedLink.getNodeName();
                            object = this.dts.getRelationshipSet((QName)xdmNode2, extendedLink.getRole());
                            if (object == null) {
                                object = this.dts.createRelationshipSet(extendedLink);
                            }
                            if (!this.b.contains(object)) {
                                this.b.add(object);
                            }
                        }
                        if (this._targetAction != Cleaner.TargetAction.Clean || !bl) continue;
                        for (XdmNode xdmNode2 : hashMap.keySet()) {
                            this.dts.removeSchema((XmlSchema)xdmNode2);
                        }
                        if (this.xbrlInstance == null) continue;
                        this.xbrlInstance.clearCache();
                    }
                }
                ++n6;
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)("fix locator: " + exception.getMessage()));
        }
    }

    private void s() {
        try {
            IXbrlDocument[] iXbrlDocumentArray;
            IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
            int n = iXbrlDocumentArray.length;
            int n2 = 0;
            while (n2 < n) {
                XbrlDocument xbrlDocument;
                IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
                if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                    Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                    for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                        Arc arc2;
                        if (!extendedLink.isSyntaxError()) continue;
                        boolean bl = false;
                        ExtendedLinkSummary extendedLinkSummary = new ExtendedLinkSummary(extendedLink, this.dts);
                        for (Arc arc2 : extendedLinkSummary.getArcs()) {
                            if (extendedLinkSummary.hasArcEnd(arc2.getFrom()) && extendedLinkSummary.hasArcEnd(arc2.getTo())) continue;
                            extendedLink.removeChild((XdmNode)arc2);
                            this.fixBug("remove arc miss end: " + arc2.toString() + " = " + arc2.getFrom() + " - " + arc2.getTo());
                            this._hasBugFixed = true;
                            bl = true;
                        }
                        extendedLinkSummary = null;
                        if (!bl) continue;
                        arc2 = extendedLink.getNodeName();
                        RelationshipSet relationshipSet = this.dts.getRelationshipSet((QName)arc2, extendedLink.getRole());
                        if (relationshipSet == null) {
                            relationshipSet = this.dts.createRelationshipSet(extendedLink);
                        }
                        if (this.b.contains(relationshipSet)) continue;
                        this.b.add(relationshipSet);
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)("fix arc: " + exception.getMessage()));
        }
    }

    private void t() {
        if (this.p == null) {
            return;
        }
        try {
            RelationshipSet relationshipSet;
            XbrlDocument xbrlDocument;
            Collection collection = this.dts.getLabelRelationships();
            Collection collection2 = this.p.getLabelRelationships();
            if (this.j == null) {
                this.j = this.dts.getPresentationRelationships();
            }
            RelationshipSet relationshipSet2 = new HashSet();
            for (RelationshipSet relationshipSet3 : this.j) {
                relationshipSet3.getAllTargets(relationshipSet2);
            }
            boolean bl = false;
            for (Iterator<Object> iterator : relationshipSet2) {
                bl = false;
                xbrlDocument = collection.iterator();
                block4: while (xbrlDocument.hasNext()) {
                    relationshipSet = (RelationshipSet)xbrlDocument.next();
                    for (Relationship relationship : relationshipSet.getChildren(iterator)) {
                        Label label;
                        Iterator iterator2;
                        if (relationship.arc().getUse() != ArcUse.Optional || (iterator2 = relationship.toTarget()) == null || !(iterator2 instanceof Label) || !"http://www.xbrl.org/2003/role/label".equals((label = (Label)iterator2).getRole())) continue;
                        bl = true;
                        break block4;
                    }
                }
                if (bl || !(iterator instanceof XbrlConcept)) continue;
                this.a((XbrlConcept)iterator, collection2, collection);
            }
            relationshipSet = relationshipSet2 = this.dts.getDocuments();
            int n = ((IXbrlDocument[])relationshipSet).length;
            int n2 = 0;
            while (n2 < n) {
                RelationshipSet relationshipSet4 = relationshipSet[n2];
                if (!relationshipSet4.isReadOnly() && relationshipSet4.getContentType().contains(XbrlContentType.Linkbase) && relationshipSet4 instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)relationshipSet4).getDocumentElement() instanceof Linkbase) {
                    Relationship relationship;
                    relationship = (Linkbase)xbrlDocument.getDocumentElement();
                    for (ExtendedLink extendedLink : relationship.getExtendedLinks()) {
                        if (!extendedLink.isSyntaxError() || !extendedLink.getNodeName().equals(QNameConstants.presentationLink)) continue;
                        for (Label label : extendedLink.getRelationships()) {
                            RelationshipSet relationshipSet52;
                            XbrlConcept xbrlConcept;
                            PresentationArc presentationArc;
                            String string;
                            Arc arc = label.arc();
                            if (!(arc instanceof PresentationArc) || StringUtils.isEmpty((String)(string = (presentationArc = (PresentationArc)arc).getPreferredLabel())) || (xbrlConcept = label.toConcept()) == null) continue;
                            int n3 = 0;
                            block9: for (RelationshipSet relationshipSet52 : collection) {
                                for (Relationship relationship2 : relationshipSet52.getChildren((Object)xbrlConcept)) {
                                    String string2;
                                    Label label2;
                                    Object object;
                                    if (relationship2.arc().getUse() == ArcUse.Optional && (object = relationship2.toTarget()) != null && object instanceof Label && string.equals((label2 = (Label)object).getRole()) && (n3 += ((string2 = label2.getLang()).startsWith("zh") ? 2 : 0) + (string2.startsWith("zh") ? 1 : 0)) == 3) break block9;
                                }
                            }
                            if (n3 == 3 || !this.a(xbrlConcept, collection2, collection) || (relationshipSet52 = this.dts.getRelationshipSet((QName)QNameConstants.labelLink, extendedLink.getRole())) == null) continue;
                            this.b.add(relationshipSet52);
                        }
                    }
                }
                ++n2;
            }
            this.rebuildRelationshipSet();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean a(XbrlConcept xbrlConcept, Collection<RelationshipSet> collection, Collection<RelationshipSet> collection2) {
        d d2 = this.A();
        if (d2.a()) {
            return false;
        }
        boolean bl = false;
        for (RelationshipSet relationshipSet : collection) {
            for (Relationship relationship : relationshipSet.getChildren((Object)xbrlConcept)) {
                if (!relationship.isOptional() || !(relationship.toTarget() instanceof Label)) continue;
                Label label = (Label)relationship.toTarget();
                String string = label.getRole();
                boolean bl2 = false;
                block2: for (RelationshipSet relationshipSet2 : collection2) {
                    for (Relationship relationship2 : relationshipSet2.getChildren((Object)xbrlConcept)) {
                        Label label2;
                        Object object;
                        if (relationship2.arc().getUse() != ArcUse.Optional || (object = relationship2.toTarget()) == null || !(object instanceof Label) || !string.equals((label2 = (Label)object).getRole()) || !label2.getLang().equals(label.getLang())) continue;
                        bl2 = true;
                        break block2;
                    }
                }
                if (bl2 || !this.a(xbrlConcept, label, d2)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private void u() {
        Object object;
        QName qName;
        XmlSchema[] xmlSchemaArray;
        this.q = null;
        this.f = this.byInstance ? this.xbrlInstance.getAllFacts(true) : new HashMap();
        this.h = new HashSet();
        if (this.byInstance) {
            for (Context context : this.xbrlInstance.getContexts()) {
                this.h.addAll(context.getDimensionContents().keySet());
                xmlSchemaArray = context.getDimensionContents().values().iterator();
                while (xmlSchemaArray.hasNext()) {
                    QName qName2 = qName = (QName)xmlSchemaArray.next();
                    int n = ((MemberElement[])qName2).length;
                    int n2 = 0;
                    while (n2 < n) {
                        QName qName3;
                        object = qName2[n2];
                        if (object instanceof ExplicitMember && (qName3 = ((ExplicitMember)object).getDimensionContent()) != null && !qName3.isEmpty()) {
                            this.h.add(qName3);
                        }
                        ++n2;
                    }
                }
            }
        }
        this.c = new HashSet();
        this.c.addAll(this.f.keySet());
        this.c.addAll(this.h);
        this.d = new HashMap<QName, List<QName>>();
        this.e = new HashMap<QName, List<QName>>();
        for (QName qName4 : this.dts.hasDefaultDimensions()) {
            QName[] qNameArray = this.dts.getDimensionDefault(qName4);
            int n = qNameArray.length;
            int n3 = 0;
            while (n3 < n) {
                qName = qNameArray[n3];
                List<QName> list = this.e.get(qName);
                if (list == null) {
                    list = new ArrayList<QName>(1);
                    this.e.put(qName, list);
                }
                list.add(qName4);
                if (!this.h.contains(qName4)) {
                    list = this.d.get(qName);
                    if (list == null) {
                        list = new ArrayList<QName>(1);
                        this.d.put(qName, list);
                    }
                    list.add(qName4);
                }
                ++n3;
            }
        }
        this.i = null;
        this.j = this.dts.getPresentationRelationships();
        this.l = this.dts.getDefinitionRelationships();
        this.k = this.dts.getCalculationRelationships();
        this.g = new HashSet<Object>();
        for (RelationshipSet relationshipSet : this.j) {
            relationshipSet.getAllTargets(this.g);
        }
        this.s = "http://xbrl.mof.gov.cn/taxonomy/2010-09-30/cas";
        xmlSchemaArray = this.dts.getSchemas();
        int n = xmlSchemaArray.length;
        int n4 = 0;
        while (n4 < n) {
            XmlSchema xmlSchema = xmlSchemaArray[n4];
            object = xmlSchema.getTargetNamespace();
            if (!StringUtils.isEmpty((String)object) && !((String)object).startsWith("http://www.xbrl.org/") && !((String)object).startsWith("http://xbrl.org/") && ((String)object).startsWith("http://xbrl.mof.gov.cn/taxonomy/")) {
                if (((String)object).equals("http://xbrl.mof.gov.cn/taxonomy/2010-09-30/cas")) {
                    this.s = "http://xbrl.mof.gov.cn/taxonomy/2010-09-30/cas";
                } else {
                    String string = xmlSchema.getPrefixOfNamespace((String)object);
                    if ("cas".equals(string)) {
                        this.s = object;
                    }
                }
            }
            ++n4;
        }
        this.o = this.dts.getConcept("SeparateMember", StringUtils.isEmpty((String)this.s) ? "http://xbrl.mof.gov.cn/taxonomy/2010-09-30/cas" : this.s);
    }

    @Override
    public boolean clean() {
        return this.clean(false);
    }

    private void a(boolean bl, boolean bl2) {
        bl = false;
        if (bl && this.xbrlInstance != null) {
            this.U();
            this.I();
            this.w();
        }
        if (bl2) {
            this.v();
        }
        if (bl && this.xbrlInstance != null) {
            this.N();
            this.ac();
            this.ab();
            this.T();
            this.Y();
            this.S();
            this.R();
            this.P();
            this.z();
            this.O();
            this.k();
            this.removeUnusedMenu();
        }
    }

    private void v() {
        try {
            this.j = this.dts.getPresentationRelationships();
            boolean bl = false;
            net.gbicc.xbrl.cleaner.b b2 = new net.gbicc.xbrl.cleaner.b(this.dts, this);
            for (RelationshipSet relationshipSet : this.j) {
                boolean bl2 = bl = b2.a(relationshipSet) || bl;
            }
            if (bl) {
                this.j = this.dts.getPresentationRelationships();
                this.l = this.dts.getDefinitionRelationships();
                this.rebuildRelationshipSet();
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)exception);
        }
    }

    private void w() {
        Object object2;
        if (this.xbrlInstance == null) {
            return;
        }
        if (this.f == null || this.f.size() == 0) {
            this.f = this.xbrlInstance.getFacts(true);
        }
        for (Object object2 : this.dts.getPresentationRelationships()) {
            this.d((RelationshipSet)object2);
        }
        object2 = null;
        Collection collection = this.dts.getDefinitionRelationships();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RelationshipSet relationshipSet = (RelationshipSet)iterator.next();
            if (!this.d(relationshipSet)) continue;
            if (object2 == null) {
                object2 = new HashSet();
                this.a(collection, (Set<String>)object2);
            }
            if (object2.contains(relationshipSet.getRoleURI())) continue;
            this.c(relationshipSet);
        }
        this.rebuildRelationshipSet();
    }

    private void a(Collection<RelationshipSet> collection, Set<String> set) {
        for (RelationshipSet relationshipSet : collection) {
            for (Relationship relationship : relationshipSet.getRelationships()) {
                DefinitionArc definitionArc;
                String string;
                if (!(relationship.arc() instanceof DefinitionArc) || StringUtils.isEmpty((String)(string = (definitionArc = (DefinitionArc)relationship.arc()).getTargetRole()))) continue;
                set.add(string);
                set.add(relationshipSet.getRoleURI());
            }
        }
    }

    private void c(RelationshipSet relationshipSet) {
        boolean bl = false;
        for (Object object : relationshipSet.getRelationships()) {
            XbrlConcept xbrlConcept = object.fromConcept();
            if (!XbrlHelper.isStandardArcrole((String)object.arcrole()) && (xbrlConcept == null || !xbrlConcept.isHypercube())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (Object object : new ArrayList(relationshipSet.getFromTargets())) {
                relationshipSet.purgeRelationships(object);
            }
        }
    }

    private boolean d(RelationshipSet relationshipSet) {
        Iterator iterator;
        Iterator iterator2;
        int n = 0;
        ArrayList<Object> arrayList = null;
        ArrayList<Object> arrayList2 = null;
        for (Object object5 : new ArrayList(relationshipSet.getToTargets())) {
            Object object2;
            if (!(object5 instanceof XbrlConcept) || !(object2 = (XbrlConcept)object5).isHypercube()) continue;
            Collection collection = relationshipSet.getParents(object2);
            if (collection.size() != 1) {
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Object>();
                }
                arrayList2.add(object2);
                continue;
            }
            iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                Relationship relationship = (Relationship)iterator2.next();
                iterator = relationshipSet.getChildren(relationship.fromTarget());
                boolean bl = false;
                boolean bl2 = true;
                Iterator iterator3 = iterator.iterator();
                block2: while (iterator3.hasNext()) {
                    Object object3;
                    Object object42;
                    XbrlConcept xbrlConcept;
                    Relationship relationship2 = (Relationship)iterator3.next();
                    if (relationship2.toTarget() == object2 || (xbrlConcept = relationship2.toConcept()) == null) continue;
                    if (xbrlConcept.getName().endsWith("LineItems") || xbrlConcept.getName().endsWith("LineItem")) {
                        bl = true;
                        break;
                    }
                    if (relationshipSet.getChildren((Object)xbrlConcept).size() > 0) {
                        bl = true;
                        break;
                    }
                    if (xbrlConcept.isAbstract()) continue;
                    HashSet<QName> hashSet = new HashSet<QName>();
                    for (Object object42 : relationshipSet.getChildren(object2)) {
                        object3 = object42.toConcept();
                        if (object3 == null || !object3.isDimension()) continue;
                        hashSet.add(object3.getQName());
                    }
                    object42 = this.f.get(xbrlConcept.getQName());
                    if (object42 == null || object42.size() <= 0) continue;
                    object3 = object42.iterator();
                    while (object3.hasNext()) {
                        Fact fact = (Fact)object3.next();
                        Context context = fact.getContext();
                        if (context == null || context.getDimensionContents().size() <= 0) continue;
                        boolean bl3 = false;
                        for (QName qName : hashSet) {
                            if (!context.getDimensionContents().containsKey(qName)) continue;
                            bl3 = true;
                            break;
                        }
                        if (!bl3) continue;
                        bl2 = false;
                        continue block2;
                    }
                }
                if (!bl && bl2) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                    }
                    arrayList.add(object2);
                    continue;
                }
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList();
                }
                arrayList2.add(object2);
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            Object object6;
            Object object5;
            object5 = new HashSet();
            if (arrayList2 != null) {
                for (Object object6 : arrayList2) {
                    this.b(relationshipSet, object6, (HashSet<Object>)object5);
                }
            }
            object6 = new HashSet();
            for (Object object2 : arrayList) {
                ((HashSet)object6).clear();
                boolean bl = this.a(relationshipSet, object2, (HashSet<Object>)object6);
                if (!bl) continue;
                if (((HashSet)object5).size() > 0) {
                    iterator = ((HashSet)object6).iterator();
                    while (iterator.hasNext()) {
                        iterator2 = iterator.next();
                        if (!((HashSet)object5).contains(iterator2)) continue;
                        bl = false;
                        break;
                    }
                }
                if (!bl) continue;
                iterator = ((HashSet)object6).iterator();
                while (iterator.hasNext()) {
                    iterator2 = iterator.next();
                    relationshipSet.purgeRelationships(iterator2);
                }
                ++n;
                this.fixBug("remove no lineItems: " + object2 + " from " + relationshipSet.toString());
                this.b.add(relationshipSet);
            }
        }
        return n > 0;
    }

    private boolean a(RelationshipSet relationshipSet, Object object, HashSet<Object> hashSet) {
        if (hashSet.contains(object)) {
            return true;
        }
        hashSet.add(object);
        for (Relationship relationship : relationshipSet.getChildren(object)) {
            if (relationship.isReadOnly()) {
                return false;
            }
            if (this.a(relationshipSet, relationship.toTarget(), hashSet)) continue;
            return false;
        }
        return true;
    }

    private void b(RelationshipSet relationshipSet, Object object, HashSet<Object> hashSet) {
        if (hashSet.contains(object)) {
            return;
        }
        hashSet.add(object);
        for (Relationship relationship : relationshipSet.getChildren(object)) {
            this.b(relationshipSet, relationship.toTarget(), hashSet);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void x() {
        try {
            void var2_4;
            if (this.xbrlInstance == null) {
                return;
            }
            HashSet<String> hashSet = new HashSet<String>();
            XdmNode object22 = this.xbrlInstance.getFirstNS();
            while (var2_4 != null) {
                Iterator iterator = var2_4.getInnerText().trim();
                hashSet.add((String)((Object)iterator));
                XdmNode xdmNode = var2_4.getNextSibling();
            }
            this.a((XdmElement)this.xbrlInstance, hashSet);
            if (!hashSet.isEmpty()) {
                for (Context context : this.xbrlInstance.getContexts()) {
                    for (Map.Entry entry : context.getDimensionContents().entrySet()) {
                        hashSet.remove(((QName)entry.getKey()).getNamespaceURI());
                        MemberElement[] memberElementArray = (MemberElement[])entry.getValue();
                        int n = memberElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MemberElement memberElement = memberElementArray[n2];
                            if (memberElement instanceof ExplicitMember) {
                                try {
                                    hashSet.remove(((ExplicitMember)memberElement).getDimensionContent().getNamespaceURI());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            ++n2;
                        }
                    }
                    if (hashSet.isEmpty()) break;
                }
            }
            if (!hashSet.isEmpty()) {
                for (Unit unit : this.xbrlInstance.getUnits()) {
                    try {
                        QName[] qNameArray = unit.getNumeratorMeasures();
                        int n = qNameArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            QName qName = qNameArray[n3];
                            hashSet.remove(qName.getNamespaceURI());
                            ++n3;
                        }
                        qNameArray = unit.getDenominatorMeasures();
                        n = qNameArray.length;
                        n3 = 0;
                        while (n3 < n) {
                            QName qName = qNameArray[n3];
                            hashSet.remove(qName.getNamespaceURI());
                            ++n3;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (hashSet.isEmpty()) break;
                }
            }
            for (String string : hashSet) {
                String string2 = this.xbrlInstance.getNamespacePrefix(string);
                if (StringUtils.isEmpty((String)string2)) continue;
                this.xbrlInstance.removeAttributeNode(string2, "http://www.w3.org/2000/xmlns/");
                this._hasBugFixed = true;
                this.xbrlInstance.getOwnerDocument().setModified(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void a(XdmElement xdmElement, Set<String> set) {
        IXdmSchemaInfo iXdmSchemaInfo;
        if (set.isEmpty()) {
            return;
        }
        set.remove(xdmElement.getNamespaceURI());
        try {
            Node[] nodeArray = xdmElement.getAttributes();
            int n = nodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                iXdmSchemaInfo = nodeArray[n2];
                if (iXdmSchemaInfo instanceof XdmAttribute) {
                    set.remove(((XdmAttribute)iXdmSchemaInfo).getNamespaceURI());
                }
                ++n2;
            }
            if (set.isEmpty()) {
                return;
            }
        }
        catch (DataModelException dataModelException) {
            dataModelException.printStackTrace();
        }
        iXdmSchemaInfo = xdmElement.getSchemaInfo();
        if (iXdmSchemaInfo != null && iXdmSchemaInfo.getDataType() != null && iXdmSchemaInfo.getDataType().getTypeCode() == XmlTypeCode.QName) {
            try {
                QName qName = xdmElement.getQName();
                set.remove(qName.getNamespaceURI());
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
        XdmNode xdmNode = xdmElement.getFirstChild();
        while (xdmNode != null) {
            if (xdmNode.getNodeNature() == 2) {
                this.a((XdmElement)xdmNode, set);
            }
            if (set.isEmpty()) {
                return;
            }
            xdmNode = xdmNode.getNextSibling();
        }
    }

    private void y() {
        this.rebuildRelationshipSet();
        this.l = this.dts.getDefinitionRelationships();
        for (RelationshipSet object22 : this.l) {
            if (object22.getRelationships().size() != 0) continue;
            this.dts.removeRelationshipSets(object22.getRoleURI(), object22.getExtendedName());
        }
        this.l = this.dts.getDefinitionRelationships();
        HashSet<Linkbase> hashSet = new HashSet<Linkbase>();
        for (Object object3 : this.dts.getPresentationRelationships()) {
            List<RelationshipSet> list;
            String string;
            int n;
            String string2 = object3.getRoleURI();
            RoleType roleType = this.dts.getRoleTypes().getSingle(string2);
            if (roleType == null || (n = string2.lastIndexOf(47)) == -1 || (string = string2.substring(n + 1)).length() != 6 || (list = this.e(string2)) == null || list.size() == 0) continue;
            Collections.sort(list, t);
            int n2 = list.size();
            ArrayList<Object> arrayList = null;
            int string22 = 0;
            while (string22 < n2) {
                String n5 = string22 == 0 ? string2 : String.valueOf(string2) + (char)(96 + string22);
                boolean string4 = false;
                int relationshipSet = list.size() - 1;
                while (relationshipSet > -1) {
                    if (list.get(relationshipSet).getRoleURI().equals(n5)) {
                        string4 = true;
                        list.remove(relationshipSet);
                        break;
                    }
                    --relationshipSet;
                }
                if (!string4) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                    }
                    arrayList.add(n5);
                }
                ++string22;
            }
            if (arrayList == null || list.size() <= 0 || list.size() != arrayList.size()) continue;
            String string3 = roleType.getDefinitionText();
            n = string3.indexOf("]");
            if (n != -1) {
                string3 = string3.substring(n + 1).trim();
            }
            int n3 = 0;
            while (n3 < arrayList.size()) {
                block19: {
                    String string4;
                    RoleType roleType2;
                    Collection<Linkbase> collection;
                    Collection collection2;
                    RelationshipSet relationshipSet;
                    String string5;
                    block20: {
                        string5 = (String)arrayList.get(n3);
                        relationshipSet = list.get(n3);
                        if (relationshipSet.isReadOnly()) break block19;
                        collection2 = relationshipSet.getExtendedLinks();
                        collection = this.getLinkbases(collection2);
                        roleType2 = this.dts.getRoleTypes().getSingle(string5);
                        if (roleType2 != null) break block20;
                        n = string5.lastIndexOf(47);
                        String string6 = string5.substring(n + 1);
                        String string7 = roleType.getId();
                        string4 = string7.replace(string, string6);
                        if (string4.equals(string7)) break block19;
                        roleType2 = this.createRoleType(string5, string4, string3);
                    }
                    if (roleType2 != null) {
                        for (Linkbase linkbase : collection) {
                            hashSet.add(linkbase);
                            string4 = linkbase.getRoleRef(string5);
                            if (string4 != null) continue;
                            string4 = linkbase.createRoleRef(string5, null);
                            linkbase.prependChild((XdmNode)string4);
                            string4.setRoleType(roleType2);
                        }
                        for (ExtendedLink extendedLink : collection2) {
                            extendedLink.setRole(string5);
                        }
                        this.dts.removeRelationshipSets(relationshipSet);
                        for (ExtendedLink extendedLink : collection2) {
                            string4 = new ExtendedLinkSummary(extendedLink, this.dts);
                            RelationshipSet relationshipSet2 = string4.getRelationshipSet();
                            if (relationshipSet2 == null) continue;
                            this.b.add(relationshipSet2);
                            break;
                        }
                    }
                }
                ++n3;
            }
        }
        if (hashSet != null && hashSet.size() > 0) {
            Object object3;
            object3 = new HashSet();
            for (Linkbase linkbase : hashSet) {
                this.removeUnusedRoleRef(linkbase, (Set<String>)object3);
            }
        }
        if (this.b.size() > 0) {
            this.rebuildRelationshipSet();
            this.ab();
        }
    }

    private void z() {
        this.j = this.dts.getPresentationRelationships();
        HashSet<Relationship> hashSet = new HashSet<Relationship>();
        ArrayList<XbrlConcept> arrayList = new ArrayList<XbrlConcept>();
        for (RelationshipSet relationshipSet : this.j) {
            Object object;
            hashSet.clear();
            arrayList.clear();
            List list = relationshipSet.getRootNodes();
            int n = list.size() - 1;
            while (n > -1) {
                Object object2;
                object = list.get(n);
                if (object instanceof XbrlConcept && (object2 = (XbrlConcept)object).isDimension()) {
                    arrayList.add((XbrlConcept)object2);
                    list.remove(n);
                }
                --n;
            }
            if (arrayList.size() <= 0) continue;
            HashSet<Object> hashSet2 = new HashSet<Object>();
            object = new HashSet();
            for (Object object2 : list) {
                hashSet2.add(object2);
                this.a(relationshipSet, object2, hashSet2, hashSet);
            }
            for (Object object2 : arrayList) {
                object.clear();
                object.add(object2);
                this.a(relationshipSet, object2, (Set<Object>)object, hashSet);
                boolean bl = true;
                for (Object object3 : object) {
                    if (!hashSet2.contains(object3)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    this.fixBug("remove top axis: " + object2 + " @" + relationshipSet);
                    for (Object object3 : object) {
                        relationshipSet.purgeRelationships(object3);
                    }
                    continue;
                }
                if (this.c.contains(object2.getQName())) continue;
                this.fixBug("remove top axis: " + object2 + " @" + relationshipSet);
                for (Object object3 : new ArrayList(relationshipSet.getChildren(object2))) {
                    if (hashSet2.contains(object3.toTarget())) continue;
                    relationshipSet.purgeRelationships(object3.toTarget());
                }
                relationshipSet.purgeRelationships(object2);
            }
        }
    }

    private void a(RelationshipSet relationshipSet, Object object, Set<Object> set, Set<Relationship> set2) {
        for (Relationship relationship : relationshipSet.getChildren(object)) {
            if (set2.contains(relationship)) continue;
            set2.add(relationship);
            set.add(relationship.toTarget());
            this.a(relationshipSet, relationship.toTarget(), set, set2);
        }
    }

    private d A() {
        if (this.u == null) {
            IXbrlDocument[] iXbrlDocumentArray;
            this.u = new d();
            IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
            int n = iXbrlDocumentArray.length;
            int n2 = 0;
            while (n2 < n) {
                XbrlDocument xbrlDocument;
                String string;
                IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
                if (iXbrlDocument != null && !iXbrlDocument.isReadOnly() && iXbrlDocument instanceof XbrlDocument && (string = iXbrlDocument.getBaseURI()) != null && (string.endsWith("cn.xml") || string.endsWith("en.xml")) && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() != null && xbrlDocument.getDocumentElement() instanceof Linkbase) {
                    for (ExtendedLink extendedLink : ((Linkbase)xbrlDocument.getDocumentElement()).getExtendedLinks()) {
                        if (!extendedLink.getNodeName().equals(QNameConstants.labelLink)) continue;
                        if (string.endsWith("cn.xml")) {
                            this.u.a = xbrlDocument;
                            break;
                        }
                        if (!string.endsWith("en.xml")) break;
                        this.u.b = xbrlDocument;
                        break;
                    }
                }
                ++n2;
            }
        }
        return this.u;
    }

    private void B() {
        try {
            d d2 = this.A();
            if (d2.a()) {
                return;
            }
            Map<ExtendedLink, ExtendedLinkSummary> map = null;
            Collection collection = this.dts.getLabelRelationships();
            ArrayList arrayList = new ArrayList();
            for (RelationshipSet relationshipSet : collection) {
                for (Object e2 : relationshipSet.getFromTargets()) {
                    if (!(e2 instanceof XbrlConcept)) continue;
                    arrayList.clear();
                    arrayList.addAll(relationshipSet.getChildren(e2));
                    for (Relationship relationship : arrayList) {
                        Label label;
                        String string;
                        if (!(relationship.toTarget() instanceof Label) || StringUtils.isEmpty((String)(string = (label = (Label)relationship.toTarget()).getLang()))) continue;
                        if (string.startsWith("zh")) {
                            if (label.getOwnerDocument() == d2.a) continue;
                            if (map == null) {
                                map = d2.b();
                            }
                            this.a(relationshipSet, relationship, label, d2.a, map);
                            continue;
                        }
                        if (!string.startsWith("en") || label.getOwnerDocument() == d2.b) continue;
                        if (map == null || map.size() == 0) {
                            map = d2.b();
                        }
                        this.a(relationshipSet, relationship, label, d2.b, map);
                    }
                }
            }
            this.a(d2);
            this.rebuildRelationshipSet();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogWatch.error((Object)exception);
        }
    }

    private void a(d d2) {
        if (this.p == null) {
            return;
        }
        try {
            Collection collection2;
            HashSet hashSet = new HashSet();
            for (Collection collection2 : this.dts.getPresentationRelationships()) {
                collection2.getAllTargets(hashSet);
            }
            collection2 = this.dts.getLabelRelationships();
            for (Iterator iterator : hashSet) {
                List list;
                RelationshipSet relationshipSet;
                boolean bl = false;
                XbrlConcept xbrlConcept = collection2.iterator();
                while (xbrlConcept.hasNext()) {
                    relationshipSet = (RelationshipSet)xbrlConcept.next();
                    if (!relationshipSet.contains(iterator)) continue;
                    bl = true;
                    break;
                }
                if (bl || !(iterator instanceof XbrlConcept) || (xbrlConcept = this.p.getConcept((relationshipSet = (XbrlConcept)iterator).getQName())) == null || (list = xbrlConcept.getLabels(this.p)).isEmpty()) continue;
                for (Label label : list) {
                    this.a((XbrlConcept)relationshipSet, label, d2);
                }
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)exception);
        }
    }

    private boolean a(XbrlConcept xbrlConcept, Label label, d d2) {
        ArcEnd arcEnd;
        Object object;
        int n;
        Relationship relationship;
        XbrlDocument xbrlDocument;
        String string = label.getLang();
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        Object object2 = string.startsWith("zh") ? d2.a : (xbrlDocument = string.startsWith("en") ? d2.b : null);
        if (xbrlDocument == null) {
            return false;
        }
        Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
        Map<ExtendedLink, ExtendedLinkSummary> map = d2.b();
        Loc loc = null;
        Object object3 = null;
        List list = linkbase.getExtendedLinks((QName)QNameConstants.labelLink);
        if (list == null || list.size() == 0) {
            return false;
        }
        ExtendedLink extendedLink = (ExtendedLink)list.get(0);
        Object object4 = extendedLink.getRelationships().iterator();
        while (object4.hasNext()) {
            relationship = (Relationship)object4.next();
            if (relationship.fromConcept() != xbrlConcept) continue;
            loc = (Loc)relationship.fromPoint();
            object3 = relationship.fromLabel();
            break;
        }
        if (loc == null) {
            relationship = map.get(extendedLink);
            if (relationship == null) {
                return false;
            }
            object4 = xbrlConcept.getQName().getLocalPart();
            if (relationship.hasArcEnds((String)object4)) {
                n = 0;
                object = relationship.getArcEnds((String)object4);
                Object object5 = object.iterator();
                while (object5.hasNext()) {
                    arcEnd = (ArcEnd)object5.next();
                    if (!(arcEnd instanceof Loc) || ((Loc)arcEnd).getFinalTarget() != xbrlConcept) continue;
                    n = 1;
                    loc = (Loc)arcEnd;
                    object3 = object4;
                    break;
                }
                if (n == 0) {
                    int n2 = 1;
                    object5 = String.valueOf(object4) + "_" + ++n2;
                    while (relationship.hasArcEnds((String)object5)) {
                        object5 = String.valueOf(object4) + "_" + ++n2;
                    }
                    object3 = object5;
                }
            } else {
                object3 = object4;
            }
            if (loc == null) {
                loc = extendedLink.createLoc(null, (String)object3);
                extendedLink.appendChild((XdmNode)loc);
                loc.setTarget((Object)xbrlConcept);
                relationship.putEnd((ArcEnd)loc);
            }
        }
        if ((relationship = map.get(extendedLink)).hasArcEnds((String)(object4 = label.getLabel()))) {
            n = 1;
            object = String.valueOf(object4) + "_" + ++n;
            while (relationship.hasArcEnds((String)object)) {
                object = String.valueOf(object4) + "_" + ++n;
            }
            object4 = object;
        }
        Label label2 = (Label)extendedLink.createResource((QName)QNameConstants.label, (String)object4, label.getRole());
        label2.setLang(label.getLang());
        label2.setInnerText(label.getInnerText());
        label2.setTitle(label.getTitle());
        extendedLink.appendChild((XdmNode)label2);
        relationship.putEnd((ArcEnd)label2);
        object = extendedLink.createArc((QName)QNameConstants.labelArc, "http://www.xbrl.org/2003/arcrole/concept-label", "1.0");
        object.setFrom((String)object3);
        object.setTo((String)object4);
        extendedLink.appendChild((XdmNode)object);
        relationship.addRelationship((XbrlElement)loc, (XbrlElement)label2, (Arc)object);
        arcEnd = relationship.getRelationshipSet();
        if (arcEnd != null) {
            this.b.add(arcEnd);
        }
        return true;
    }

    private boolean a(RelationshipSet relationshipSet, Relationship relationship, Label label, XbrlDocument xbrlDocument, Map<ExtendedLink, ExtendedLinkSummary> map) {
        ArcEnd arcEnd2;
        List list;
        Object object;
        Object object2;
        if (relationship == null || relationship.isReadOnly() || xbrlDocument == null || !(xbrlDocument.getDocumentElement() instanceof Linkbase)) {
            return false;
        }
        XbrlConcept xbrlConcept = relationship.fromConcept();
        Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
        Loc loc = null;
        Object object3 = null;
        ExtendedLink extendedLink = null;
        Object object4 = relationshipSet.getChildren(relationship.fromTarget()).iterator();
        while (object4.hasNext()) {
            object2 = (Relationship)object4.next();
            if (object2 == relationship || object2.fromPoint().getOwnerDocument() != xbrlDocument || !(object2.fromPoint() instanceof Loc)) continue;
            loc = (Loc)object2.fromPoint();
            object3 = object2.fromLabel();
            extendedLink = (ExtendedLink)loc.getParent();
            break;
        }
        if (loc == null) {
            object2 = linkbase.getExtendedLinks((QName)QNameConstants.labelLink, relationshipSet.getRoleURI());
            if (object2 == null || object2.size() == 0) {
                extendedLink = linkbase.createExtendedLink((QName)QNameConstants.labelLink);
                extendedLink.setRole(relationshipSet.getRoleURI());
                linkbase.appendChild((XdmNode)extendedLink);
                map.put(extendedLink, new ExtendedLinkSummary(extendedLink, this.dts));
            } else {
                extendedLink = (ExtendedLink)object2.get(0);
            }
            object4 = map.get(extendedLink);
            if (object4 == null) {
                return false;
            }
            object = xbrlConcept.getQName().getLocalPart();
            if (object4.hasArcEnds((String)object)) {
                boolean bl = false;
                list = object4.getArcEnds((String)object);
                for (ArcEnd arcEnd2 : list) {
                    if (!(arcEnd2 instanceof Loc) || ((Loc)arcEnd2).getFinalTarget() != xbrlConcept) continue;
                    bl = true;
                    object3 = object;
                    loc = (Loc)arcEnd2;
                    break;
                }
                if (!bl) {
                    int n = 1;
                    Object object5 = String.valueOf(object) + "_" + ++n;
                    while (object4.hasArcEnds((String)object5)) {
                        object5 = String.valueOf(object) + "_" + ++n;
                    }
                    object3 = object5;
                }
            } else {
                object3 = object;
            }
            if (loc == null) {
                loc = extendedLink.createLoc(null, (String)object3);
                extendedLink.appendChild((XdmNode)loc);
                loc.setTarget((Object)xbrlConcept);
                object4.putEnd((ArcEnd)loc);
            }
        }
        if ((object2 = map.get(extendedLink)) == null) {
            object2 = new ExtendedLinkSummary(extendedLink, this.dts);
            map.put(extendedLink, (ExtendedLinkSummary)object2);
        }
        if (object2.hasArcEnds((String)(object4 = label.getLabel()))) {
            int n = 1;
            String string = String.valueOf(object4) + "_" + ++n;
            while (object2.hasArcEnds(string)) {
                string = String.valueOf(object4) + "_" + ++n;
            }
            object4 = string;
        }
        object = (Label)extendedLink.createResource((QName)QNameConstants.label, (String)object4, label.getRole());
        object.setLang(label.getLang());
        object.setInnerText(label.getInnerText());
        String string = label.getId();
        if (object.getOwnerDocument().getElementById(string) == null) {
            object.setId(string);
        }
        object.setTitle(label.getTitle());
        extendedLink.appendChild((XdmNode)object);
        object2.putEnd((ArcEnd)object);
        list = extendedLink.createArc((QName)QNameConstants.labelArc, relationship.arcrole(), relationship.arc().getOrder().toPlainString());
        list.setFrom((String)object3);
        list.setTo((String)object4);
        list.setTitle(relationship.arc().getTitle());
        extendedLink.appendChild((XdmNode)list);
        object2.addRelationship((XbrlElement)loc, (XbrlElement)object, (Arc)list);
        arcEnd2 = object2.getRelationshipSet();
        if (arcEnd2 != null) {
            this.b.add(arcEnd2);
        }
        if (!relationship.purge(null)) {
            return false;
        }
        this.b.add(relationshipSet);
        this.fixBug("move label " + xbrlConcept.getPrefixedName() + " " + label.getLang(), true);
        return true;
    }

    private void C() {
        XbrlSchema[] xbrlSchemaArray;
        this.rebuildRelationshipSet();
        Map<String, Collection<QName>> map = null;
        XbrlSchema[] xbrlSchemaArray2 = xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray2[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                for (RoleType roleType : xbrlSchema.getRoleTypes()) {
                    Object object;
                    QName qName;
                    Object object22;
                    String string = roleType.getRoleURI();
                    for (Object object22 : roleType.getUsedOns()) {
                        try {
                            qName = object22.getQName();
                            if (this.dts.getRelationshipSet(qName, string) != null) continue;
                            if (map == null) {
                                map = this.D();
                            }
                            if ((object = map.get(string)) != null && object.contains(qName)) continue;
                            roleType.removeChild((XdmNode)object22);
                            this.fixBug("remove " + qName.getLocalPart() + " from roleType = " + string, true);
                        }
                        catch (EvaluationException evaluationException) {
                            evaluationException.printStackTrace();
                        }
                    }
                    object22 = this.dts.getRelationshipSets(string);
                    Collection collection = roleType.getUsedOns();
                    object = object22.iterator();
                    while (object.hasNext()) {
                        qName = (RelationshipSet)object.next();
                        try {
                            UsedOn usedOn;
                            boolean bl = false;
                            Iterator iterator = collection.iterator();
                            while (iterator.hasNext()) {
                                usedOn = (UsedOn)iterator.next();
                                if (!qName.getExtendedName().equals(usedOn.getQName())) continue;
                                bl = true;
                                break;
                            }
                            if (bl) continue;
                            usedOn = roleType.createUsedOn(qName.getExtendedName());
                            roleType.appendChild((XdmNode)usedOn);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private Map<String, Collection<QName>> D() {
        IXbrlDocument[] iXbrlDocumentArray;
        HashMap<String, Collection<QName>> hashMap = new HashMap<String, Collection<QName>>();
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (iXbrlDocument != null && !iXbrlDocument.isReadOnly() && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() != null && xbrlDocument.getDocumentElement() instanceof Linkbase) {
                for (ExtendedLink extendedLink : ((Linkbase)xbrlDocument.getDocumentElement()).getExtendedLinks()) {
                    String string = extendedLink.getRole();
                    if (StringUtils.isEmpty((String)string)) {
                        string = "http://www.xbrl.org/2003/role/link";
                    }
                    QName qName = extendedLink.getNodeName();
                    HashSet<QName> hashSet = (HashSet<QName>)hashMap.get(string);
                    if (hashSet == null) {
                        hashSet = new HashSet<QName>();
                        hashMap.put(string, hashSet);
                    }
                    hashSet.add(qName);
                }
            }
            ++n2;
        }
        return hashMap;
    }

    private void E() {
        XdmNode[] xdmNodeArray;
        XdmNode[] xdmNodeArray2;
        XbrlSchema[] xbrlSchemaArray;
        if (this.xbrlInstance != null) {
            this.a((XdmDocument)this.xbrlInstance.getOwnerDocument());
        }
        XbrlSchema[] xbrlSchemaArray2 = xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            xdmNodeArray2 = xbrlSchemaArray2[n2];
            if (xdmNodeArray2 != null && !xdmNodeArray2.isReadOnly() && (xdmNodeArray = xdmNodeArray2.getHeaderComments()) != null && xdmNodeArray.length > 0) {
                XdmNode[] xdmNodeArray3;
                ArrayList<XdmNode[]> arrayList = new ArrayList<XdmNode[]>();
                XdmNode[] xdmNodeArray4 = xdmNodeArray;
                int n3 = xdmNodeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    xdmNodeArray3 = xdmNodeArray4[n4];
                    if (xdmNodeArray3 != null && !xdmNodeArray3.getInnerText().contains("Fujitsu")) {
                        arrayList.add(xdmNodeArray3);
                    }
                    ++n4;
                }
                if (arrayList.size() == 0) {
                    xdmNodeArray2.setHeaderComments(null);
                } else {
                    xdmNodeArray3 = arrayList.toArray(new XdmNode[arrayList.size()]);
                    xdmNodeArray2.setHeaderComments(xdmNodeArray3);
                }
            }
            ++n2;
        }
        xdmNodeArray = xdmNodeArray2 = this.dts.getDocuments();
        int n5 = xdmNodeArray2.length;
        n = 0;
        while (n < n5) {
            XdmNode xdmNode = xdmNodeArray[n];
            if (xdmNode != null && !xdmNode.isReadOnly() && xdmNode instanceof XdmDocument) {
                this.a((XdmDocument)xdmNode);
            }
            ++n;
        }
    }

    private void a(XdmDocument xdmDocument) {
        if (xdmDocument == null) {
            return;
        }
        XdmNode xdmNode = xdmDocument.getFirstChild();
        while (xdmNode != null) {
            XdmText xdmText;
            XdmNode xdmNode2 = xdmNode.getNextSibling();
            if (xdmNode.getNodeNature() == 6 && xdmNode instanceof XdmText && (xdmText = (XdmText)xdmNode).getInnerText().contains("Fujitsu")) {
                xdmDocument.removeChild((XdmNode)xdmText);
            }
            xdmNode = xdmNode2;
        }
    }

    private void F() {
        if (this.xbrlInstance == null) {
            return;
        }
        XdmNode xdmNode = null;
        XdmNode xdmNode22 = this.xbrlInstance.getFirstChild();
        while (xdmNode22 != null) {
            if (xdmNode22.getNodeNature() == 2 && xdmNode22 instanceof Fact) {
                xdmNode = xdmNode22;
                break;
            }
            xdmNode22 = xdmNode22.getNextSibling();
        }
        if (xdmNode == null) {
            return;
        }
        for (XdmNode xdmNode22 : this.xbrlInstance.getUnits()) {
            this.xbrlInstance.insertBefore(xdmNode22, xdmNode);
            this._hasBugFixed = true;
        }
    }

    private void G() {
        IXbrlDocument[] iXbrlDocumentArray;
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                ExtendedLink extendedLink = null;
                Object object = linkbase.getFirstChild();
                while (object != null) {
                    if (object.getNodeNature() == 2 && object instanceof ExtendedLink) {
                        extendedLink = (ExtendedLink)object;
                        break;
                    }
                    object = object.getNextSibling();
                }
                if (extendedLink != null) {
                    object = this.b(linkbase);
                    for (RoleRef roleRef : object.values()) {
                        linkbase.insertBefore((XdmNode)roleRef, (XdmNode)extendedLink);
                    }
                }
            }
            ++n2;
        }
    }

    private void H() {
        for (RelationshipSet relationshipSet : this.dts.getRelationshipSets()) {
            if (relationshipSet.getExtendedName().equals(QNameConstants.genericLink)) continue;
            this.e(relationshipSet);
        }
    }

    private void e(RelationshipSet relationshipSet) {
        for (Object e2 : relationshipSet.getFromTargets()) {
            boolean bl = true;
            for (Relationship relationship : relationshipSet.getChildren(e2)) {
                if (!relationship.isReadOnly()) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            int n = 0;
            for (Relationship relationship : relationshipSet.getChildren(e2)) {
                double d2 = ++n;
                if (relationship.isSingle()) {
                    relationship.arc().setOrder(BigDecimalConstants.valueOf((String)Double.toString(d2)));
                    continue;
                }
                Relationship[] relationshipArray = relationship.toArray();
                int n2 = relationshipArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Relationship relationship2 = relationshipArray[n3];
                    relationship2.arc().setOrder(BigDecimalConstants.valueOf((String)Double.toString(d2)));
                    ++n3;
                }
            }
        }
    }

    private boolean a(String string) {
        RoleType[] roleTypeArray = this.dts.getRoleTypes().get(string);
        if (roleTypeArray != null) {
            RoleType[] roleTypeArray2 = roleTypeArray;
            int n = roleTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                RoleType roleType = roleTypeArray2[n2];
                String string2 = roleType.getDefinitionText();
                if (string2 != null && (string2.contains("Separate") || string2.contains("Separated"))) {
                    return true;
                }
                if (this.n) {
                    for (RelationshipSet relationshipSet : this.m) {
                        for (Relationship relationship : relationshipSet.getChildren((Object)roleType)) {
                            GenericLabel genericLabel;
                            if (!(relationship.toTarget() instanceof GenericLabel) || (string2 = (genericLabel = (GenericLabel)relationship.toTarget()).getInnerText()) == null || !string2.contains("Separate") && !string2.contains("Separated")) continue;
                            return true;
                        }
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private void I() {
        RelationshipSet relationshipSet2;
        if (this.xbrlInstance == null) {
            return;
        }
        if (this.o == null) {
            return;
        }
        this.m = this.dts.getRelationshipSets((QName)QNameConstants.genericLink);
        this.n = this.m != null && this.m.size() > 0;
        Collection collection = this.dts.getPresentationRelationships();
        ArrayList<RelationshipSet> arrayList = new ArrayList<RelationshipSet>();
        ArrayList<RelationshipSet> arrayList2 = new ArrayList<RelationshipSet>();
        for (RelationshipSet relationshipSet2 : collection) {
            String string = relationshipSet2.getRoleURI();
            if (!this.a(string)) {
                arrayList.add(relationshipSet2);
                continue;
            }
            if (relationshipSet2.contains((Object)this.o)) continue;
            arrayList2.add(relationshipSet2);
        }
        relationshipSet2 = new HashSet();
        for (RelationshipSet relationshipSet3 : arrayList2) {
            Object object4;
            Object object2;
            Object object32;
            relationshipSet2.clear();
            relationshipSet3.getAllTargets((Set)relationshipSet2);
            if (relationshipSet2.size() == 0) continue;
            boolean bl = true;
            for (Object object32 : relationshipSet2) {
                if (!(object32 instanceof XbrlConcept)) {
                    bl = false;
                    break;
                }
                object2 = (XbrlConcept)object32;
                if (object2.isAbstract() || !this.f.containsKey(object2.getQName())) continue;
                boolean bl2 = false;
                for (Object object4 : arrayList) {
                    if (!object4.contains(object32)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            for (Object object32 : relationshipSet2) {
                relationshipSet3.purgeRelationships(object32);
            }
            object32 = relationshipSet3.getRoleURI();
            this.fixBug("remove roleURI=\"" + object32 + "\"", true);
            List<RelationshipSet> list = this.e((String)object32);
            RelationshipSet relationshipSet4 = list.iterator();
            while (relationshipSet4.hasNext()) {
                object2 = (RelationshipSet)relationshipSet4.next();
                relationshipSet2.clear();
                object2.getAllTargets((Set)relationshipSet2);
                for (Object object4 : relationshipSet2) {
                    object2.purgeRelationships(object4);
                }
            }
            object2 = this.d((String)object32);
            object4 = object2.iterator();
            while (object4.hasNext()) {
                relationshipSet4 = (RelationshipSet)object4.next();
                relationshipSet2.clear();
                relationshipSet4.getAllTargets((Set)relationshipSet2);
                for (Iterator iterator : relationshipSet2) {
                    relationshipSet4.purgeRelationships(iterator);
                }
            }
        }
    }

    private void b(boolean bl, boolean bl2) {
        this.g();
        this.o();
        this.f();
        this.e();
        this.p();
        this.r();
        this.s();
        this.m();
        this.b();
        this.bugFixDuplicateArc();
        this.t();
        this.aa();
        this.u();
        this.Z();
        this.l();
        this.rebuildRelationshipSet();
        this.i();
        this.K();
        this.h();
        this.X();
        if (this.getOptions().isCommonClear()) {
            this.a(bl, bl2);
        }
        try {
            this.y();
            this.G();
            this.F();
            this.C();
            this.B();
            this.H();
            this.E();
            this.x();
            this.J();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.L();
        this.j();
    }

    private void J() {
        IXbrlDocument[] iXbrlDocumentArray;
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Linkbase linkbase;
            String string;
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase && !StringUtils.isEmpty((String)(string = (linkbase = (Linkbase)xbrlDocument.getDocumentElement()).getNamespacePrefix("http://xbrl.org/2005/xbrldt")))) {
                boolean bl = false;
                XdmNode xdmNode = linkbase.getFirstChild();
                while (xdmNode != null) {
                    if (xdmNode.getNodeNature() == 2 && xdmNode.getNodeName().equals(QNameConstants.presentationLink)) {
                        bl = true;
                        XdmNode xdmNode2 = xdmNode.getFirstChild();
                        while (xdmNode2 != null) {
                            if (xdmNode2.getNodeNature() == 2 && xdmNode2 instanceof PresentationArc) {
                                PresentationArc presentationArc = (PresentationArc)xdmNode2;
                                presentationArc.removeAttributeNode((QName)QNameConstants.usable);
                                presentationArc.removeAttributeNode((QName)QNameConstants.closed);
                                presentationArc.removeAttributeNode((QName)QNameConstants.contextElement);
                                presentationArc.removeAttributeNode((QName)QNameConstants.targetRole);
                            }
                            xdmNode2 = xdmNode2.getNextSibling();
                        }
                    }
                    xdmNode = xdmNode.getNextSibling();
                }
                if (bl) {
                    linkbase.removeAttributeNode(string, "http://www.w3.org/2000/xmlns/");
                }
            }
            ++n2;
        }
    }

    private void K() {
        if (this.xbrlInstance == null) {
            return;
        }
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (List<Fact> list : this.f.values()) {
                for (Fact fact : list) {
                    arrayList.clear();
                    Node[] nodeArray = fact.getAttributes();
                    int n = nodeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Node node = nodeArray[n2];
                        QName qName = node.getNodeName();
                        String string = qName.getNamespaceURI();
                        if (!(StringUtils.isEmpty((String)string) || string.equals("http://www.xbrl.org/2003/instance") || string.equals("http://xbrl.org/2006/xbrldi"))) {
                            fact.removeAttributeNode(qName);
                            this._hasBugFixed = true;
                            arrayList.add(string);
                        }
                        ++n2;
                    }
                    if (arrayList.size() <= 0) continue;
                    for (String string : arrayList) {
                        String string2 = fact.getNamespacePrefix(string);
                        if (StringUtils.isEmpty((String)string2)) continue;
                        fact.removeAttributeNode(string2, "http://www.w3.org/2000/xmlns/");
                    }
                }
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)("remove metaInfo: " + exception.getMessage()));
        }
    }

    private boolean a(Fact fact) {
        String string;
        XbrlConcept xbrlConcept;
        String string2 = fact.getLocalName();
        if (string2.contains("The") && (xbrlConcept = this.dts.getConcept(string = string2.replace("The", ""), fact.getNamespaceURI())) != null) {
            Fact fact2 = this.xbrlInstance.createFact(xbrlConcept.getQName());
            fact.copyTo(fact2);
            fact.getParent().insertBefore((XdmNode)fact2, (XdmNode)fact);
            fact.getParent().removeChild((XdmNode)fact);
            this.fixBug("change fact: " + string2 + " --> " + string);
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean a(Context var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean a(QName qName, XbrlConcept xbrlConcept, boolean bl) {
        HashSet<Context> hashSet;
        if (this.xbrlInstance == null) {
            return false;
        }
        boolean bl2 = false;
        QName qName2 = xbrlConcept.getQName();
        this.f = this.xbrlInstance.getAllFacts(true);
        List<Fact> list = this.f.get(qName);
        HashSet<Context> hashSet2 = hashSet = bl ? new HashSet<Context>() : null;
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                Fact fact = list.get(n);
                Context context = fact.getContext();
                Fact fact2 = this.xbrlInstance.createFact(qName2);
                fact.copyTo(fact2);
                fact.getParent().insertBefore((XdmNode)fact2, (XdmNode)fact);
                fact.getParent().removeChild((XdmNode)fact);
                list.set(n, fact2);
                fact.getOwnerDocument().setModified(true);
                bl2 = true;
                this.fixBug("change fact: " + qName.getLocalPart() + " --> " + qName2.getLocalPart());
                if (bl && context != null && context.getPeriodType() != xbrlConcept.getPeriodType()) {
                    hashSet.add(context);
                    this.changeFactContext(fact2, xbrlConcept, context);
                }
                ++n;
            }
        }
        for (Context context : this.xbrlInstance.getContexts()) {
            boolean bl3 = bl2 = this.a(context, qName, qName2) || bl2;
        }
        if (hashSet != null) {
            for (Context context : hashSet) {
                if (this.xbrlInstance.isUsed(context)) continue;
                context.getParent().removeChild((XdmNode)context);
                context.getOwnerDocument().setModified(true);
            }
        }
        this.f = this.xbrlInstance.getAllFacts(true);
        return bl2;
    }

    private boolean a(Context context, QName qName, QName qName2) {
        String string;
        boolean bl;
        block15: {
            Scenario scenario = context.getScenario();
            Segment segment = context.getSegment();
            bl = false;
            try {
                try {
                    OpenContextComponent[] openContextComponentArray = new OpenContextComponent[]{scenario, segment};
                    int n = openContextComponentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        string = openContextComponentArray[n2];
                        if (string != null) {
                            XdmNode xdmNode = string.getFirstChild();
                            while (xdmNode != null) {
                                if (xdmNode instanceof MemberElement) {
                                    ExplicitMember explicitMember;
                                    QName qName3;
                                    MemberElement memberElement = (MemberElement)xdmNode;
                                    QName qName4 = memberElement.getDimension();
                                    if (qName.equals(qName4)) {
                                        memberElement.setDimension(qName2);
                                        context.getOwnerDocument().setModified(true);
                                        bl = true;
                                    }
                                    if (memberElement instanceof ExplicitMember && qName.equals(qName3 = (explicitMember = (ExplicitMember)memberElement).getDimensionContent())) {
                                        explicitMember.setDimensionContent(qName2);
                                        context.getOwnerDocument().setModified(true);
                                        bl = true;
                                    }
                                }
                                xdmNode = xdmNode.getNextSibling();
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    LogWatch.error((Object)("changeContext: " + exception.getMessage()));
                    context.process(this.getProcessContext());
                    break block15;
                }
            }
            catch (Throwable throwable) {
                context.process(this.getProcessContext());
                throw throwable;
            }
            context.process(this.getProcessContext());
        }
        if (bl) {
            String string2;
            string = context.getId();
            if (!string.equals(string2 = string.replace(qName.getLocalPart(), qName2.getLocalPart()))) {
                context.setId(string2);
                for (List list : this.f.values()) {
                    for (XdmNode xdmNode : list) {
                        if (!string.equals(xdmNode.getContextRef())) continue;
                        xdmNode.setContextRef(string2);
                    }
                }
                context.getOwnerDocument().setModified(true);
            }
            this.fixBug("context: " + context.getId());
        }
        return bl;
    }

    private void L() {
        Object object2;
        MemberElement[] memberElementArray;
        Map.Entry<QName, List<Fact>> entry22;
        if (this.xbrlInstance == null) {
            return;
        }
        if (this.getOptions().isFixMissingConceptForThe() && this.f != null) {
            for (Map.Entry<QName, List<Fact>> context : this.f.entrySet()) {
                if (this.dts.getConcept(context.getKey()) != null) continue;
                for (XdtProcessor xdtProcessor : context.getValue()) {
                    this.a((Fact)xdtProcessor);
                }
            }
            entry22 = this.xbrlInstance.getContexts().iterator();
            while (entry22.hasNext()) {
                Context bl = (Context)entry22.next();
                boolean bl2 = true;
                block3: for (Map.Entry entry : bl.getDimensionContents().entrySet()) {
                    if (this.dts.getConcept((QName)entry.getKey()) == null) {
                        bl2 = false;
                        this.reportBug("axis missing: " + entry.getKey() + " @" + bl.getId());
                        break;
                    }
                    memberElementArray = (MemberElement[])entry.getValue();
                    int n = memberElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        object2 = memberElementArray[n2];
                        if (object2 instanceof ExplicitMember && this.dts.getConcept(((ExplicitMember)object2).getDimensionContent()) == null) {
                            bl2 = false;
                            this.reportBug("member missing: " + entry.getKey() + " @" + bl.getId());
                            break block3;
                        }
                        ++n2;
                    }
                }
                if (bl2) continue;
                this.a(bl);
            }
            this.f = this.xbrlInstance.getAllFacts(true);
        }
        if (this.f != null && this.getOptions().isFixInstance()) {
            this.M();
        }
        if (this.getOptions().isRemoveUnbindedFacts() && this.f != null) {
            boolean list;
            boolean context = false;
            for (Map.Entry<QName, List<Fact>> entry22 : this.f.entrySet()) {
                if (this.dts.getConcept((QName)entry22.getKey()) != null) continue;
                for (Fact fact : (List)entry22.getValue()) {
                    list = true;
                    fact.getParent().removeChild((XdmNode)fact);
                    this.fixBug("remove fact: " + fact);
                }
            }
            if (list) {
                this.f = this.xbrlInstance.getAllFacts(true);
            }
        }
        if (this.getOptions().isRemoveInvalidXdtFacts() && this.f != null) {
            boolean bl;
            XdtProcessor xdtProcessor;
            this.rebuildRelationshipSet();
            boolean bl3 = false;
            entry22 = this.getProcessContext();
            xdtProcessor = new XdtProcessor(this.dts);
            for (List list : this.f.values()) {
                for (Object object2 : list) {
                    if (xdtProcessor.isXdtValid((Fact)object2, (ProcessContext)entry22, null)) continue;
                    bl = true;
                    object2.getParent().removeChild((XdmNode)object2);
                    this.fixBug("remove xdt invalid fact: " + object2.toString());
                }
            }
            if (bl) {
                this.f = this.xbrlInstance.getAllFacts(true);
            }
        }
        if (this.getOptions().isRemoveUnbindedContexts() && this.xbrlInstance != null) {
            entry22 = this.xbrlInstance.getContexts().iterator();
            while (entry22.hasNext()) {
                Context context = (Context)entry22.next();
                boolean bl = true;
                block10: for (Map.Entry entry : context.getDimensionContents().entrySet()) {
                    if (this.dts.getConcept((QName)entry.getKey()) == null) {
                        bl = false;
                        this.reportBug("axis missing: " + entry.getKey() + " @" + context.getId());
                        break;
                    }
                    memberElementArray = (MemberElement[])entry.getValue();
                    int n = memberElementArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        object2 = memberElementArray[n3];
                        if (object2 instanceof ExplicitMember && this.dts.getConcept(((ExplicitMember)object2).getDimensionContent()) == null) {
                            bl = false;
                            this.reportBug("member missing: " + entry.getKey() + " @" + context.getId());
                            break block10;
                        }
                        ++n3;
                    }
                }
                if (bl) continue;
                String string = context.getId();
                for (Object object3 : this.xbrlInstance.getAllFacts(true).values()) {
                    Iterator iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        Fact fact = (Fact)iterator.next();
                        if (!string.equals(fact.getContextRef())) continue;
                        fact.getParent().removeChild((XdmNode)fact);
                        this.fixBug("remove fact: " + fact + ", error context.");
                    }
                }
                context.getParent().removeChild((XdmNode)context);
                this.fixBug("remove context: " + string + ", missing axis or member.");
            }
        }
        if (this.getOptions().isRemoveUnusedContexts() && this.xbrlInstance != null) {
            List list = XbrlHelper.removeUnusedContexts((XbrlInstance)this.xbrlInstance);
            if (list != null && list.size() > 0) {
                this._hasBugFixed = true;
            }
            if ((entry22 = XbrlHelper.removeUnusedUnits((XbrlInstance)this.xbrlInstance)) != null && entry22.size() > 0) {
                this._hasBugFixed = true;
            }
        }
    }

    private void M() {
        if (this.xbrlInstance == null) {
            return;
        }
        if (this.f == null) {
            this.f = this.xbrlInstance.getFacts(true);
        }
        b b2 = null;
        for (Map.Entry<QName, List<Fact>> entry : this.f.entrySet()) {
            XbrlConcept xbrlConcept = this.dts.getConcept(entry.getKey());
            if (xbrlConcept == null) continue;
            boolean bl = xbrlConcept.getPeriodType() == PeriodType.Duration;
            for (Fact fact : entry.getValue()) {
                String string;
                boolean bl2;
                if (fact.isTuple()) continue;
                Context context = fact.getContext();
                boolean bl3 = bl2 = context.getPeriodType() == PeriodType.Duration;
                if (bl2 == bl) continue;
                if (b2 == null) {
                    b2 = new b();
                }
                if (bl2 && xbrlConcept.getPeriodType() == PeriodType.Instant) {
                    string = b2.a(context);
                    if (StringUtils.isEmpty((String)string)) continue;
                    fact.setContextRef(string);
                    this.fixBug("change contextRef " + fact.toString());
                    continue;
                }
                if (bl2 || xbrlConcept.getPeriodType() != PeriodType.Duration || StringUtils.isEmpty((String)(string = b2.b(context)))) continue;
                fact.setContextRef(string);
                this.fixBug("change contextRef " + fact.toString());
            }
        }
    }

    public void setOptions(CleanOption option) {
        this.v = option;
    }

    public CleanOption getOptions() {
        if (this.v == null) {
            this.v = new CleanOption();
        }
        return this.v;
    }

    private void N() {
        IXbrlDocument[] iXbrlDocumentArray;
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                Map<String, RoleRef> map = this.b(linkbase);
                HashSet<String> hashSet = new HashSet<String>();
                boolean bl = false;
                for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                    Object object;
                    Iterator iterator;
                    Object object2;
                    Object object3;
                    Object object42;
                    QName qName = extendedLink.getNodeName();
                    if (!qName.equals(QNameConstants.definitionLink) && !qName.equals(QNameConstants.presentationLink)) continue;
                    bl = true;
                    ArrayList arrayList = extendedLink.getRelationships();
                    if (arrayList == null) {
                        if (extendedLink.elements().length != 0 || extendedLink.getParent() == null) continue;
                        extendedLink.getParent().removeChild((XdmNode)extendedLink);
                        continue;
                    }
                    arrayList = new ArrayList(arrayList);
                    String string = extendedLink.getRole();
                    if (!"http://www.xbrl.org/2003/role/link".equals(string)) {
                        this.a(extendedLink, map);
                    }
                    HashSet<Object> hashSet2 = new HashSet<Object>();
                    for (Object object42 : arrayList) {
                        if (object42.isRemoved()) continue;
                        object3 = object42.fromConcept();
                        if (object3 != null) {
                            hashSet2.add(object3);
                        }
                        if ((object2 = object42.toConcept()) != null) {
                            hashSet2.add(object2);
                            continue;
                        }
                        if (!(object42.toTarget() instanceof Resource) || (iterator = (object = (Resource)object42.toTarget()).getRole()) == null) continue;
                        hashSet.add((String)((Object)iterator));
                    }
                    if (this.byInstance) {
                        object42 = this.dts.getRelationshipSet(qName, extendedLink.getRole());
                        if (object42 == null) {
                            System.out.println("NULL = " + extendedLink.getRole());
                            continue;
                        }
                        boolean bl2 = true;
                        object2 = object42.getRelationships().iterator();
                        while (object2.hasNext()) {
                            object3 = (Relationship)object2.next();
                            object = object3.fromConcept();
                            if (object != null && this.f.containsKey(object.getQName())) {
                                bl2 = false;
                                break;
                            }
                            object = object3.toConcept();
                            if (object == null || !this.f.containsKey(object.getQName())) continue;
                            bl2 = false;
                            break;
                        }
                        if (!bl2) continue;
                        object3 = new HashSet();
                        object42.getAllTargets((Set)object3);
                        object = ((HashSet)object3).iterator();
                        while (object.hasNext()) {
                            object2 = object.next();
                            object42.purgeRelationships(object2);
                        }
                        continue;
                    }
                    if (!qName.equals(QNameConstants.definitionLink)) continue;
                    object42 = this.c(extendedLink.getRole());
                    RelationshipSet relationshipSet = this.dts.getRelationshipSet((QName)QNameConstants.definitionLink, extendedLink.getRole());
                    if (relationshipSet == null) continue;
                    boolean bl3 = true;
                    object = relationshipSet.getRelationships().iterator();
                    block5: while (object.hasNext()) {
                        object2 = (Relationship)object.next();
                        iterator = object2.fromTarget();
                        Object object5 = object2.toTarget();
                        Iterator iterator2 = object42.iterator();
                        while (iterator2.hasNext()) {
                            RelationshipSet relationshipSet2 = (RelationshipSet)iterator2.next();
                            if (!relationshipSet2.contains(iterator) && !relationshipSet2.contains(object5)) continue;
                            bl3 = false;
                            break block5;
                        }
                    }
                    if (!bl3) continue;
                    object2 = new HashSet();
                    relationshipSet.getAllTargets((Set)object2);
                    iterator = ((HashSet)object2).iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        relationshipSet.purgeRelationships(object);
                        this.fixBug("remove " + object + " @" + relationshipSet);
                    }
                }
                if (bl) {
                    this.removeUnusedRoleRef(linkbase, hashSet);
                }
            }
            ++n2;
        }
    }

    private void O() {
        XbrlSchema[] xbrlSchemaArray;
        XbrlSchema[] xbrlSchemaArray2 = xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray2[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                ArrayList<XbrlConcept> arrayList = new ArrayList<XbrlConcept>();
                Map map = xbrlSchema.getElements();
                if (map != null && !map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        XbrlConcept xbrlConcept;
                        QName qName = (QName)entry.getKey();
                        XbrlConcept xbrlConcept2 = xbrlConcept = entry.getValue() instanceof XbrlConcept ? (XbrlConcept)entry.getValue() : null;
                        if (xbrlConcept == null || this.c.contains(qName) || this.a(xbrlConcept, this.j) || this.a(xbrlConcept, this.l)) continue;
                        arrayList.add(xbrlConcept);
                    }
                }
                for (XbrlConcept xbrlConcept : arrayList) {
                    if (!xbrlSchema.removeConcept(this.dts, xbrlConcept, true)) continue;
                    this.fixBug("remove concept: " + xbrlConcept + " not used.", true);
                }
            }
            ++n2;
        }
    }

    private void P() {
        XbrlSchema[] xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                for (LinkbaseRef linkbaseRef : xbrlSchema.getLinkbaseRefs()) {
                    IXbrlDocument iXbrlDocument = this.dts.getDocument(linkbaseRef.getDiscoveredUri(null));
                    if (!this.a(iXbrlDocument)) continue;
                    xbrlSchema.removeLinkbaseRef(linkbaseRef);
                }
            }
            ++n2;
        }
    }

    private void Q() {
        try {
            XbrlSchema[] xbrlSchemaArray = this.getEntrySchema();
            int n = xbrlSchemaArray.length;
            int n2 = 0;
            while (n2 < n) {
                XbrlSchema xbrlSchema = xbrlSchemaArray[n2];
                if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                    for (LinkbaseRef linkbaseRef : xbrlSchema.getLinkbaseRefs()) {
                        IXbrlDocument iXbrlDocument = this.dts.getDocument(linkbaseRef.getDiscoveredUri(null));
                        if (iXbrlDocument != null) continue;
                        this._hasBugFixed = true;
                        xbrlSchema.removeLinkbaseRef(linkbaseRef);
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)("removeNotFoundLinkbaseRef: " + exception.getMessage()));
        }
    }

    private boolean a(IXbrlDocument iXbrlDocument) {
        XbrlDocument xbrlDocument;
        if (iXbrlDocument != null && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
            return ((Linkbase)xbrlDocument.getDocumentElement()).isEmpty();
        }
        return false;
    }

    private void R() {
        XbrlSchema[] xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                ArrayList arrayList = new ArrayList(xbrlSchema.getExternals());
                for (XmlSchemaExternal xmlSchemaExternal : arrayList) {
                    String string;
                    XbrlSchema xbrlSchema2;
                    if (!(xmlSchemaExternal instanceof XmlSchemaImport)) continue;
                    XmlSchemaImport xmlSchemaImport = (XmlSchemaImport)xmlSchemaExternal;
                    XmlSchema xmlSchema = xmlSchemaImport.getSchema();
                    if (xmlSchema == null && (xbrlSchema2 = this.dts.getSchemas(xmlSchemaImport.getNamespace())) != null && ((XbrlSchema)xbrlSchema2).length > 0) {
                        xmlSchema = xbrlSchema2[0];
                    }
                    if (xmlSchema == null || !(xmlSchema instanceof XbrlSchema) || !(xbrlSchema2 = (XbrlSchema)xmlSchema).isReadOnly() || !xbrlSchema2.getElements().isEmpty() || !xbrlSchema2.getAttributes().isEmpty() || !xbrlSchema2.getArcroleTypes().isEmpty() || xbrlSchema2.getRoleTypes().isEmpty() || StringUtils.isEmpty((String)(string = xbrlSchema2.getTargetNamespace()))) continue;
                    NamespacePrefixList namespacePrefixList = xbrlSchema.getNamespaceContext();
                    Iterator iterator = namespacePrefixList.getPrefixes(string);
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        namespacePrefixList.remove(string2, string);
                    }
                }
            }
            ++n2;
        }
    }

    private void S() {
        XbrlSchema[] xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                ArrayList arrayList = new ArrayList(xbrlSchema.getExternals());
                for (XmlSchemaExternal xmlSchemaExternal : arrayList) {
                    XbrlSchema xbrlSchema2;
                    if (!(xmlSchemaExternal instanceof XmlSchemaImport)) continue;
                    XmlSchemaImport xmlSchemaImport = (XmlSchemaImport)xmlSchemaExternal;
                    XmlSchema xmlSchema = xmlSchemaImport.getSchema();
                    if (xmlSchema == null && (xbrlSchema2 = this.dts.getSchemas(xmlSchemaImport.getNamespace())) != null && ((XbrlSchema)xbrlSchema2).length > 0) {
                        xmlSchema = xbrlSchema2[0];
                    }
                    if (xmlSchema == null || !(xmlSchema instanceof XbrlSchema)) continue;
                    xbrlSchema2 = (XbrlSchema)xmlSchema;
                    this.a(xbrlSchema2, (XmlSchema)xbrlSchema, xmlSchemaImport);
                }
            }
            ++n2;
        }
    }

    private void a(XbrlSchema xbrlSchema, XmlSchema xmlSchema, XmlSchemaImport xmlSchemaImport) {
        if (xbrlSchema.isReadOnly() && xbrlSchema.getElements().isEmpty() && xbrlSchema.getArcroleTypes().isEmpty() && !xbrlSchema.getRoleTypes().isEmpty()) {
            boolean bl = false;
            block0: for (Object object : xbrlSchema.getRoleTypes()) {
                for (Iterator iterator : this.dts.getRelationshipSets(object.getRoleURI())) {
                    if (iterator.getRelationships().size() == 0) continue;
                    bl = true;
                    break block0;
                }
            }
            if (!bl) {
                boolean bl2;
                Object object;
                object = xbrlSchema.getTargetNamespace();
                if (!StringUtils.isEmpty((String)object)) {
                    Iterator iterator;
                    Iterator iterator2 = xmlSchema.getNamespaceContext();
                    iterator = iterator2.getPrefixes((String)object);
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        iterator2.remove(string, (String)object);
                    }
                }
                if (bl2 = this.a(xbrlSchema, (XbrlSchema)xmlSchema)) {
                    xmlSchema.removeItem((XmlSchemaObject)xmlSchemaImport);
                    for (Iterator iterator : xbrlSchema.getRoleTypes()) {
                        this.dts.getRoleTypes().remove((Object)iterator);
                        this.removedRoleTypes.add(iterator.getRoleURI());
                    }
                }
            }
        }
    }

    private boolean a(XbrlSchema xbrlSchema, XbrlSchema xbrlSchema2) {
        Object object2;
        ArrayList<Object> arrayList = null;
        for (Object object2 : this.dts.getRelationshipSets((QName)QNameConstants.genericLink)) {
            for (RoleType roleType : xbrlSchema.getRoleTypes()) {
                for (Relationship relationship3 : object2.getChildren((Object)roleType)) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                    }
                    if (relationship3.isSingle()) {
                        arrayList.add(relationship3);
                        continue;
                    }
                    Relationship[] relationshipArray = relationship3.toArray();
                    int n = relationshipArray.length;
                    int relationship4 = 0;
                    while (relationship4 < n) {
                        Relationship relationship2 = relationshipArray[relationship4];
                        arrayList.add(relationship2);
                        ++relationship4;
                    }
                }
            }
        }
        if (arrayList == null || arrayList.size() == 0) {
            return true;
        }
        object2 = new ArrayList();
        for (Relationship relationship : arrayList) {
            Relationship relationship3;
            Iterator iterator = relationship.arc().getOwnerDocument();
            if (object2.contains(iterator) || !iterator.isReadOnly()) continue;
            Linkbase linkbase = relationship3 = iterator.getDocumentElement() instanceof Linkbase ? (Linkbase)iterator.getDocumentElement() : null;
            if (relationship3 == null) continue;
            for (ExtendedLink extendedLink : relationship3.getExtendedLinks()) {
                for (Relationship relationship4 : extendedLink.getRelationships()) {
                    if (arrayList.contains(relationship4)) continue;
                    return false;
                }
            }
            for (ExtendedLink extendedLink : xbrlSchema2.getLinkbaseRefs()) {
                URI uRI = extendedLink.getDiscoveredUri(null);
                if (iterator != this.dts.getDocument(uRI)) continue;
                xbrlSchema2.removeLinkbaseRef((LinkbaseRef)extendedLink);
            }
            object2.add(iterator);
        }
        return true;
    }

    @Override
    public boolean clean(boolean removeRelationship, boolean buildAllDomainMember) {
        this._targetAction = Cleaner.TargetAction.Clean;
        try {
            this.b(removeRelationship, buildAllDomainMember);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (!this.c.contains(QNameConstants.explicitMember) && !this.c.contains(QNameConstants.typedMember)) {
            this.xbrlInstance.removeAttributeNode("xmlns:xbrldi");
            String string = this.xbrlInstance.getAttributeValue((QName)QNameConstants.schemaLocation);
            if (string.contains("http://www.xbrl.org/2006/xbrldi-2006.xsd")) {
                string = string.replace("http://www.xbrl.org/2006/xbrldi-2006.xsd", "");
                if (StringUtils.isEmpty((String)(string = string.replace("http://xbrl.org/2006/xbrldi", "").trim()))) {
                    this.xbrlInstance.removeAttributeNode((QName)QNameConstants.schemaLocation);
                } else {
                    this.xbrlInstance.setAttribute((QName)QNameConstants.schemaLocation, string);
                }
                this._hasBugFixed = true;
                this.xbrlInstance.getOwnerDocument().setModified(true);
            }
        }
        return this._hasBugFixed;
    }

    private void T() {
        RelationshipSet relationshipSet2;
        HashSet hashSet = new HashSet();
        for (RelationshipSet relationshipSet2 : this.j) {
            relationshipSet2.getAllTargets(hashSet);
        }
        for (RelationshipSet relationshipSet2 : this.l) {
            relationshipSet2.getAllTargets(hashSet);
        }
        for (RelationshipSet relationshipSet2 : this.dts.getLabelRelationships()) {
            for (Object e2 : relationshipSet2.getRootNodes()) {
                if (e2 instanceof XbrlConcept) {
                    if (hashSet.contains(e2)) continue;
                    relationshipSet2.purgeRelationships(e2);
                    continue;
                }
                boolean cfr_ignored_0 = e2 instanceof Loc;
            }
        }
        for (RelationshipSet relationshipSet2 : this.dts.getReferenceRelationships()) {
            for (Object e2 : relationshipSet2.getRootNodes()) {
                if (!(e2 instanceof XbrlConcept) || hashSet.contains(e2)) continue;
                relationshipSet2.purgeRelationships(e2);
            }
        }
        RelationshipSet relationshipSet3 = relationshipSet2 = this.dts.getDocuments();
        int n = ((RelationshipSet)relationshipSet3).length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            Iterator<Object> iterator = relationshipSet3[n2];
            if (!iterator.isReadOnly() && iterator.getContentType().contains(XbrlContentType.Linkbase) && iterator instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iterator).getDocumentElement() instanceof Linkbase) {
                for (ExtendedLink extendedLink : ((Linkbase)xbrlDocument.getDocumentElement()).getExtendedLinks()) {
                    this.a(extendedLink);
                }
            }
            ++n2;
        }
    }

    private Map<String, RoleRef> b(Linkbase linkbase) {
        HashMap<String, RoleRef> hashMap = new HashMap<String, RoleRef>();
        for (RoleRef roleRef : linkbase.getRoleRefs()) {
            hashMap.put(roleRef.getRoleURI(), roleRef);
        }
        return hashMap;
    }

    private void U() {
        IXbrlDocument[] iXbrlDocumentArray;
        if (this.xbrlInstance == null) {
            return;
        }
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                Map<String, RoleRef> map = this.b(linkbase);
                HashSet<String> hashSet = new HashSet<String>();
                for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                    QName qName = extendedLink.getNodeName();
                    boolean bl = qName.equals(QNameConstants.definitionLink);
                    ArrayList arrayList = extendedLink.getRelationships();
                    if (arrayList == null) {
                        if (extendedLink.elements().length != 0 || extendedLink.getParent() == null) continue;
                        extendedLink.getParent().removeChild((XdmNode)extendedLink);
                        continue;
                    }
                    arrayList = new ArrayList(arrayList);
                    String string = extendedLink.getRole();
                    if (!"http://www.xbrl.org/2003/role/link".equals(string)) {
                        this.a(extendedLink, map);
                    }
                    HashSet<XbrlConcept> hashSet2 = new HashSet<XbrlConcept>();
                    for (Relationship relationship : arrayList) {
                        Resource resource;
                        String string2;
                        XbrlConcept xbrlConcept;
                        if (relationship.isRemoved() || bl && "http://xbrl.org/int/dim/arcrole/dimension-default".equals(relationship.arcrole())) continue;
                        XbrlConcept xbrlConcept2 = relationship.fromConcept();
                        if (xbrlConcept2 != null) {
                            hashSet2.add(xbrlConcept2);
                        }
                        if ((xbrlConcept = relationship.toConcept()) != null) {
                            hashSet2.add(xbrlConcept);
                            continue;
                        }
                        if (!(relationship.toTarget() instanceof Resource) || (string2 = (resource = (Resource)relationship.toTarget()).getRole()) == null) continue;
                        hashSet.add(string2);
                    }
                    if (this.byInstance) {
                        if (qName.equals(QNameConstants.presentationLink)) {
                            this.a(hashSet2, this.dts.getRelationshipSet(qName, extendedLink.getRole()));
                        } else if (qName.equals(QNameConstants.calculationLink)) {
                            this.i(this.dts.getRelationshipSet(qName, extendedLink.getRole()));
                        }
                    }
                    this.a(extendedLink);
                }
                this.removeUnusedRoleRef(linkbase, hashSet);
            }
            ++n2;
        }
    }

    private void a(ExtendedLink extendedLink) {
        block8: {
            QName qName = extendedLink.getNodeName();
            if (!qName.equals(QNameConstants.calculationLink) && !qName.equals(QNameConstants.presentationLink) && !qName.equals(QNameConstants.definitionLink) && !qName.equals(QNameConstants.labelLink) && !qName.equals(QNameConstants.referenceLink)) break block8;
            List list = extendedLink.getRelationships();
            if (list.size() == 0) {
                XdmNode xdmNode = extendedLink.getFirstChild();
                while (xdmNode != null) {
                    if (xdmNode.getNodeNature() == 2) {
                        extendedLink.removeChild(xdmNode);
                    }
                    xdmNode = xdmNode.getNextSibling();
                }
            } else {
                XdmNode xdmNode;
                HashSet<String> hashSet = new HashSet<String>();
                XdmNode xdmNode2 = extendedLink.getFirstChild();
                while (xdmNode2 != null) {
                    if (xdmNode2.getNodeNature() == 2 && xdmNode2 instanceof Arc) {
                        xdmNode = (Arc)xdmNode2;
                        hashSet.add(xdmNode.getFrom());
                        hashSet.add(xdmNode.getTo());
                    }
                    xdmNode2 = xdmNode2.getNextSibling();
                }
                xdmNode2 = extendedLink.getFirstChild();
                while (xdmNode2 != null) {
                    Loc loc;
                    String string;
                    xdmNode = xdmNode2.getNextSibling();
                    if (xdmNode2.getNodeNature() == 2 && xdmNode2 instanceof Loc && !hashSet.contains(string = (loc = (Loc)xdmNode2).getLabel())) {
                        extendedLink.removeChild(xdmNode2);
                        LogWatch.warn((Object)("Remove orphan: " + extendedLink.getNodeName().getLocalPart() + " xlink:label=" + string));
                    }
                    xdmNode2 = xdmNode;
                }
            }
        }
    }

    private void V() {
        Map<String, RoleRef> map = null;
        this.l = this.dts.getDefinitionRelationships();
        for (RelationshipSet relationshipSet : this.l) {
            char c2;
            String string;
            int n;
            RoleType[] roleTypeArray;
            String string2 = relationshipSet.getRoleURI();
            if ("http://www.xbrl.org/2003/role/link".equals(string2) || (roleTypeArray = this.dts.getRoleTypes().get(string2)) != null && roleTypeArray.length != 0 || (n = string2.lastIndexOf("/")) == -1 || (string = string2.substring(n + 1)).length() != 7 || (c2 = string.charAt(string.length() - 1)) < 'a' || c2 > 'z') continue;
            String string3 = string2.substring(0, string2.length() - 1);
            RoleType[] roleTypeArray2 = this.dts.getRoleTypes().get(string3);
            if (roleTypeArray2 == null || roleTypeArray2.length == 0) continue;
            if (map == null) {
                map = this.W();
            }
            String string4 = roleTypeArray2[0].getDefinitionText();
            String string5 = this.a(string2, map);
            if (string5 == null) continue;
            int n2 = string4.indexOf("]");
            if (n2 != -1) {
                string4 = string4.substring(n2 + 1).trim();
            }
            if (this.createRoleType(string2, string5, string4) == null) continue;
            this._hasBugFixed = true;
            this.fixBug("create roleType = " + string2);
        }
    }

    private String a(String string, Map<String, RoleRef> map) {
        String string2;
        int n;
        RoleRef roleRef = map.get(string);
        if (roleRef != null && (n = (string2 = roleRef.getHref()).lastIndexOf(35)) != -1) {
            return string2.substring(n + 1);
        }
        return null;
    }

    private Map<String, RoleRef> W() {
        IXbrlDocument[] iXbrlDocumentArray;
        HashMap<String, RoleRef> hashMap = new HashMap<String, RoleRef>();
        IXbrlDocument[] iXbrlDocumentArray2 = iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlDocument xbrlDocument;
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray2[n2];
            if (!iXbrlDocument.isReadOnly() && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                hashMap.putAll(this.b(linkbase));
            }
            ++n2;
        }
        return hashMap;
    }

    private void X() {
        if (this.dts == null) {
            return;
        }
        ArrayList<Label> arrayList = new ArrayList<Label>();
        ArrayList<Label> arrayList2 = new ArrayList<Label>();
        for (RelationshipSet relationshipSet : this.dts.getLabelRelationships()) {
            for (Object e2 : relationshipSet.getFromTargets()) {
                if (!(e2 instanceof XbrlConcept)) continue;
                arrayList.clear();
                arrayList2.clear();
                for (Relationship relationship : relationshipSet.getChildren(e2)) {
                    int n;
                    Label label;
                    if (relationship.isSingle()) {
                        if (!(relationship.toTarget() instanceof Label) || arrayList.contains(label = (Label)relationship.toTarget())) continue;
                        n = 0;
                        for (Label label2 : arrayList) {
                            if (!label2.getLang().equals(label.getLang()) || !label2.getRole().equals(label.getRole())) continue;
                            arrayList2.add(label);
                            n = 1;
                            break;
                        }
                        if (n != 0) continue;
                        arrayList.add(label);
                        continue;
                    }
                    Relationship[] relationshipArray = relationship.toArray();
                    int n2 = relationshipArray.length;
                    n = 0;
                    while (n < n2) {
                        Label label3;
                        label = relationshipArray[n];
                        if (label.toTarget() instanceof Label && !arrayList.contains(label3 = (Label)label.toTarget())) {
                            boolean bl = false;
                            for (Label label4 : arrayList) {
                                if (!label4.getLang().equals(label3.getLang()) || !label4.getRole().equals(label3.getRole())) continue;
                                arrayList2.add(label3);
                                bl = true;
                                break;
                            }
                            if (!bl) {
                                arrayList.add(label3);
                            }
                        }
                        ++n;
                    }
                }
                if (arrayList2.isEmpty()) continue;
                for (Label label : arrayList2) {
                    relationshipSet.purgeRelationships((Object)label);
                }
            }
        }
    }

    private void a(ExtendedLink extendedLink, Map<String, RoleRef> map) {
        try {
            String string = extendedLink.getRole();
            RoleType[] roleTypeArray = this.dts.getRoleTypes().get(string);
            if (roleTypeArray != null && roleTypeArray.length > 0) {
                UsedOn usedOn;
                RoleType roleType = roleTypeArray[0];
                if (!roleType.canUsedOn(extendedLink.getNodeName())) {
                    usedOn = roleType.createUsedOn(extendedLink.getNodeName());
                    roleType.appendChild((XdmNode)usedOn);
                    this.fixBug("add usedOn: " + string + " -/- " + usedOn.prefixedName(extendedLink.getNodeName()));
                }
                if (!map.containsKey(string)) {
                    usedOn = extendedLink.getOwnerLinkbase();
                    RoleRef roleRef = usedOn.createRoleRef();
                    roleRef.setRoleType(roleType);
                    usedOn.prependChild((XdmNode)roleRef);
                    this.fixBug("add roleRef: " + string + " -/- " + roleRef.getHref() + " -/- " + HttpUtility.getFileName((String)extendedLink.getOwnerDocument().getBaseURI()));
                }
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)("bugFixRoleRef: " + exception.getMessage()));
        }
    }

    private void Y() {
        XbrlSchema[] xbrlSchemaArray;
        XbrlSchema[] xbrlSchemaArray2 = xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray2[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                List list = xbrlSchema.getLinkbaseRefs();
                for (LinkbaseRef linkbaseRef : list) {
                    Linkbase linkbase;
                    IXbrlDocument iXbrlDocument;
                    URI uRI = linkbaseRef.getDiscoveredUri(null);
                    if (uRI == null || (iXbrlDocument = this.dts.getDocument(uRI)) == null || !(iXbrlDocument instanceof XbrlDocument)) continue;
                    XbrlDocument xbrlDocument = (XbrlDocument)iXbrlDocument;
                    if (xbrlDocument.getDocumentElement() == null) {
                        LogWatch.warn((Object)("BugFix: remove empty file: " + xbrlDocument.getBaseURI()));
                        xbrlSchema.removeLinkbaseRef(linkbaseRef);
                        xbrlSchema.setModified(true);
                        continue;
                    }
                    if (!xbrlDocument.getDocumentElement().getNodeName().equals(QNameConstants.linkbase) || !(linkbase = (Linkbase)xbrlDocument.getDocumentElement()).isEmpty()) continue;
                    xbrlSchema.removeLinkbaseRef(linkbaseRef);
                    xbrlSchema.setModified(true);
                }
            }
            ++n2;
        }
    }

    private boolean Z() {
        boolean bl = false;
        this.j = this.dts.getPresentationRelationships();
        for (RelationshipSet relationshipSet : this.j) {
            for (Object e2 : relationshipSet.getFromTargets()) {
                QName qName;
                XbrlConcept xbrlConcept;
                if (!(e2 instanceof XbrlConcept) || !(xbrlConcept = (XbrlConcept)e2).isDimension() || (qName = this.dts.getDefaultDimensionMember(xbrlConcept.getQName())) != null) continue;
                List list = relationshipSet.getChildren(e2);
                if (list.size() != 1) {
                    LogWatch.warn((Object)(String.valueOf(xbrlConcept.getPrefixedName()) + " missing default member @" + relationshipSet.toString()));
                    continue;
                }
                if (!this.a(relationshipSet, xbrlConcept, ((Relationship)list.get(0)).toConcept())) continue;
                bl = true;
                this._hasBugFixed = true;
                this.fixBug("create " + xbrlConcept.getPrefixedName() + " axis-default " + ((Relationship)list.get(0)).toConcept().getPrefixedName() + "@" + relationshipSet.getRoleURI());
            }
        }
        return bl;
    }

    private boolean a(RelationshipSet relationshipSet, XbrlConcept xbrlConcept, XbrlConcept xbrlConcept2) {
        if (xbrlConcept2 == null) {
            return false;
        }
        ExtendedLink extendedLink = null;
        List<RelationshipSet> list = this.e(relationshipSet.getRoleURI());
        for (RelationshipSet relationshipSet2 : list) {
            Relationship relationship;
            List list2;
            if (!relationshipSet2.contains((Object)xbrlConcept) || (list2 = relationshipSet2.getChildren((Object)xbrlConcept)).size() != 1 || ((Relationship)list2.get(0)).toTarget() != xbrlConcept2 || !(relationship = (Relationship)list2.get(0)).arcrole().equals("http://xbrl.org/int/dim/arcrole/dimension-domain") || relationship.arc().getOwnerDocument().isReadOnly()) continue;
            String string = relationship.toLabel();
            int n = 2;
            String string2 = String.valueOf(string) + "_" + n;
            extendedLink = relationship.arc().getOwnerExtended();
            while (this.a(extendedLink, string2)) {
                string2 = String.valueOf(string) + "_" + ++n;
            }
            Loc loc = extendedLink.createLoc(null, string2);
            extendedLink.appendChild((XdmNode)loc);
            loc.setTarget((Object)xbrlConcept2);
            Arc arc = extendedLink.createArc((QName)QNameConstants.definitionArc, "http://xbrl.org/int/dim/arcrole/dimension-default", "2.0");
            extendedLink.appendChild((XdmNode)arc);
            arc.setFrom(relationship.fromLabel());
            arc.setTo(string2);
            if (extendedLink.addRelationship(arc, relationship.fromPoint(), (XbrlElement)loc) == null) continue;
            this.b.add(relationshipSet2);
            this._hasBugFixed = true;
            return true;
        }
        return false;
    }

    private boolean a(ExtendedLink extendedLink, String string) {
        XdmNode xdmNode = extendedLink.getFirstChild();
        while (xdmNode != null) {
            if (xdmNode.getNodeNature() == 2 && xdmNode instanceof Loc && ((Loc)xdmNode).getLabel().equals(string)) {
                return true;
            }
            xdmNode = xdmNode.getNextSibling();
        }
        return false;
    }

    private void aa() {
        try {
            XbrlSchema[] xbrlSchemaArray = this.getEntrySchema();
            int n = xbrlSchemaArray.length;
            int n2 = 0;
            while (n2 < n) {
                XbrlSchema xbrlSchema = xbrlSchemaArray[n2];
                if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                    Object object;
                    String string;
                    RoleType[] roleTypeArray;
                    Object object2;
                    Object object32;
                    for (Object object32 : xbrlSchema.getRoleTypes()) {
                        String string2;
                        StringBuilder stringBuilder;
                        String string3;
                        int n3;
                        String string4;
                        String string5;
                        object2 = object32.getDefinition();
                        if (object2 != null && (roleTypeArray = object2.getInnerText()).startsWith("[RT_")) {
                            roleTypeArray = roleTypeArray.replace("[RT_", "[");
                            object2.setInnerText((String)roleTypeArray);
                        }
                        roleTypeArray = object32.getFirstChild();
                        while (roleTypeArray != null) {
                            XdmElement xdmElement;
                            string5 = roleTypeArray.getNextSibling();
                            if (roleTypeArray instanceof XdmElement && !"http://www.xbrl.org/2003/linkbase".equals((xdmElement = (XdmElement)roleTypeArray).getNamespaceURI()) && "definition".equals(xdmElement.getLocalName())) {
                                object32.removeChild((XdmNode)roleTypeArray);
                            }
                            roleTypeArray = string5;
                        }
                        string5 = object32.getRoleURI();
                        int n4 = string5.lastIndexOf(47);
                        if (n4 == -1) continue;
                        string = string4 = string5.substring(n4 + 1);
                        if (string4.length() > 6) {
                            string4 = string4.substring(0, 6);
                        }
                        if (string4.length() != 6 || (n3 = string4.charAt(5) - 49) < 0 || n3 > 3 || (object = CasProcessor.rules[n3]) == null) continue;
                        Definition definition = object32.getDefinition();
                        if (definition == null) {
                            definition = object32.createDefinition();
                            string3 = object32.getFirstChild();
                            if (string3 == null) {
                                object32.appendChild((XdmNode)definition);
                            } else {
                                object32.insertBefore((XdmNode)definition, (XdmNode)string3);
                            }
                        }
                        if ((string3 = definition.getInnerText()).contains(((CasProcessor.RoleTypeRule)object).markText2)) continue;
                        String string6 = ((CasProcessor.RoleTypeRule)object).markText;
                        int n5 = string3.indexOf("]");
                        int n6 = string3.indexOf(string6);
                        if (n5 == -1) {
                            stringBuilder = new StringBuilder("[").append(string).append("] ").append(string6).append(" - ");
                            if (n6 != -1) {
                                stringBuilder.append(string3.substring(n6 + string6.length()).trim());
                            } else {
                                string2 = string3.trim();
                                if (StringUtils.isEmpty((String)string2) && (string2 = this.b(string5)).contains(string6)) {
                                    string2 = string2.replace(String.valueOf(string6) + " - ", "");
                                }
                                stringBuilder.append(string2);
                            }
                            definition.setInnerText(stringBuilder.toString());
                            this.fixBug("set roleType definition = " + stringBuilder.toString());
                            this._hasBugFixed = true;
                            continue;
                        }
                        if (n6 > n5) {
                            stringBuilder = new StringBuilder(string3.substring(0, n5 + 1));
                            stringBuilder.append(" ").append(string6).append(" - ");
                            stringBuilder.append(string3.substring(n6 + string6.length()).trim());
                            definition.setInnerText(stringBuilder.toString());
                            this.fixBug("set roleType definition = " + stringBuilder.toString());
                            this._hasBugFixed = true;
                            continue;
                        }
                        stringBuilder = new StringBuilder(string3.substring(0, n5 + 1));
                        stringBuilder.append(" ").append(string6).append(" - ");
                        if (string3.length() > n5 + 1) {
                            string2 = string3.substring(n5 + 1).trim();
                            int n7 = 0;
                            while (n7 < 4) {
                                CasProcessor.RoleTypeRule roleTypeRule = CasProcessor.rules[n7];
                                if (string2.startsWith(roleTypeRule.markText2)) {
                                    string2 = string2.substring(roleTypeRule.markText2.length());
                                }
                                ++n7;
                            }
                            stringBuilder.append(string2);
                        }
                        definition.setInnerText(stringBuilder.toString());
                        this.fixBug("set roleType definition = " + stringBuilder.toString());
                        this._hasBugFixed = true;
                    }
                    object32 = new ArrayList(xbrlSchema.getRoleTypes().getRoleURIs());
                    object2 = object32.iterator();
                    while (object2.hasNext()) {
                        String string7 = (String)object2.next();
                        roleTypeArray = this.dts.getRoleTypes().get(string7);
                        if (roleTypeArray.length <= 1) continue;
                        int n8 = 0;
                        while (n8 < roleTypeArray.length - 1) {
                            RoleType roleType = roleTypeArray[n8];
                            if (roleType != null) {
                                int n9 = n8 + 1;
                                while (n9 < roleTypeArray.length) {
                                    string = roleTypeArray[n9];
                                    if (string != null && roleType.getId().equals(string.getId())) {
                                        object = string.getUsedOns().iterator();
                                        while (object.hasNext()) {
                                            UsedOn usedOn = (UsedOn)object.next();
                                            try {
                                                if (roleType.canUsedOn(usedOn.getQName())) continue;
                                                roleType.appendChild((XdmNode)usedOn);
                                            }
                                            catch (EvaluationException evaluationException) {
                                                evaluationException.printStackTrace();
                                            }
                                        }
                                        xbrlSchema.removeRoleType((RoleType)string);
                                        this.fixBug("remove roleType = " + string.getRoleURI());
                                        this._hasBugFixed = true;
                                        roleTypeArray[n9] = null;
                                    }
                                    ++n9;
                                }
                            }
                            ++n8;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            LogWatch.error((Object)("bugFix: roleType " + exception.getMessage()));
        }
        this.V();
    }

    private String b(String string) {
        RoleType[] roleTypeArray;
        char c2 = string.charAt(string.length() - 1);
        if (c2 >= 'a' && c2 <= 'z') {
            string = string.substring(0, string.length() - 1);
        }
        if ((roleTypeArray = this.dts.getRoleTypes().get(string)) != null && roleTypeArray.length != 0) {
            String string2 = roleTypeArray[0].getDefinitionText();
            int n = string2.indexOf("]");
            if (n > -1) {
                string2 = string2.substring(n + 1).trim();
            }
            return string2;
        }
        return "";
    }

    private void ab() {
        boolean bl = false;
        this.rebuildRelationshipSet();
        ArrayList arrayList = new ArrayList(this.dts.getRoleTypes());
        Set<String> set = null;
        for (RoleType roleType : arrayList) {
            Object object2;
            if (roleType.getOwnerDocument().isReadOnly()) continue;
            String string = roleType.getRoleURI();
            boolean bl2 = false;
            for (Object object2 : this.dts.getRelationshipSets(string)) {
                if (object2.getRelationships().size() == 0) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            if (set == null) {
                set = this.getReferencedRoleTypes(this.dts);
            }
            if (set.contains(string)) continue;
            object2 = roleType.getOwnerDocument().getDocUri();
            this.dts.getRoleTypes().remove((Object)roleType);
            this.removedRoleTypes.add(roleType.getRoleURI());
            IXbrlDocument iXbrlDocument = this.dts.getDocument((URI)object2);
            if (iXbrlDocument != null && iXbrlDocument instanceof XbrlSchema) {
                if (!((XbrlSchema)iXbrlDocument).removeRoleType(roleType)) continue;
                this.dts.getRoleTypes().remove((Object)roleType);
                this.removedRoleTypes.add(roleType.getRoleURI());
                if (this.m == null) {
                    this.m = this.dts.getRelationshipSets((QName)QNameConstants.genericLink);
                }
                for (RelationshipSet relationshipSet : this.m) {
                    relationshipSet.purgeRelationships((Object)roleType);
                    boolean bl3 = bl = relationshipSet.getRelationships().size() == 0 || bl;
                }
                continue;
            }
            LogWatch.error((Object)("roleType:" + string + ", the schema file not found."));
        }
        if (bl) {
            this.removeUnusedGenericLink();
        }
    }

    public static final boolean isPairURI(String thisURI, String roleURI) {
        if (Math.abs(thisURI.length() - roleURI.length()) <= 1) {
            return thisURI.equals(roleURI) || thisURI.startsWith(roleURI) || roleURI.startsWith(thisURI);
        }
        return false;
    }

    private List<RelationshipSet> c(String string) {
        ArrayList<RelationshipSet> arrayList = new ArrayList<RelationshipSet>();
        for (RelationshipSet relationshipSet : this.j) {
            if (!ShanghaiCleaner.isPairURI(string, relationshipSet.getRoleURI())) continue;
            arrayList.add(relationshipSet);
        }
        return arrayList;
    }

    private List<RelationshipSet> d(String string) {
        ArrayList<RelationshipSet> arrayList = new ArrayList<RelationshipSet>();
        for (RelationshipSet relationshipSet : this.k) {
            if (!ShanghaiCleaner.isPairURI(string, relationshipSet.getRoleURI())) continue;
            arrayList.add(relationshipSet);
        }
        return arrayList;
    }

    private List<RelationshipSet> e(String string) {
        ArrayList<RelationshipSet> arrayList = new ArrayList<RelationshipSet>();
        for (RelationshipSet relationshipSet : this.l) {
            if (!ShanghaiCleaner.isPairURI(string, relationshipSet.getRoleURI())) continue;
            arrayList.add(relationshipSet);
        }
        return arrayList;
    }

    private boolean a(XdtDimension xdtDimension, XdtCompiledMember xdtCompiledMember) {
        if (xdtDimension == null || xdtCompiledMember == null) {
            return false;
        }
        Collection collection = xdtCompiledMember.getChildren();
        if (collection != null && collection.size() > 0) {
            for (XdtComponent xdtComponent : collection) {
                XbrlConcept xbrlConcept = xdtComponent.getConcept();
                QName qName = xbrlConcept.getQName();
                if (this.e.containsKey(qName) || this.h.contains(qName)) {
                    return true;
                }
                XdtCompiledMember xdtCompiledMember2 = xdtDimension.getCompiledMember(xbrlConcept);
                if (!this.a(xdtDimension, xdtCompiledMember2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean b(XdtDimension xdtDimension, XdtCompiledMember xdtCompiledMember) {
        if (xdtDimension == null || xdtCompiledMember == null) {
            return false;
        }
        Collection collection = xdtCompiledMember.getChildren();
        if (collection != null && collection.size() > 0) {
            for (XdtComponent xdtComponent : collection) {
                XbrlConcept xbrlConcept = xdtComponent.getConcept();
                if (this.g.contains(xbrlConcept)) {
                    return true;
                }
                XdtCompiledMember xdtCompiledMember2 = xdtDimension.getCompiledMember(xbrlConcept);
                if (!this.b(xdtDimension, xdtCompiledMember2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean a(XdtDRS xdtDRS, XdtComponent xdtComponent) {
        if (xdtDRS == null || xdtComponent == null) {
            return false;
        }
        Collection collection = xdtComponent.getDomainMembers();
        if (collection != null && collection.size() > 0) {
            for (XdtComponent xdtComponent2 : collection) {
                XbrlConcept xbrlConcept = xdtComponent2.getConcept();
                QName qName = xbrlConcept.getQName();
                if (this.f.containsKey(qName) || this.e.containsKey(qName) || this.h.contains(qName)) {
                    return true;
                }
                if (!this.a(xdtDRS, xdtComponent2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean b(XdtDRS xdtDRS, XdtComponent xdtComponent) {
        if (xdtDRS == null || xdtComponent == null) {
            return false;
        }
        Collection collection = xdtComponent.getDomainMembers();
        if (collection != null && collection.size() > 0) {
            for (XdtComponent xdtComponent2 : collection) {
                XbrlConcept xbrlConcept = xdtComponent2.getConcept();
                if (this.g.contains(xbrlConcept)) {
                    return true;
                }
                if (!this.b(xdtDRS, xdtComponent2)) continue;
                return true;
            }
        }
        return false;
    }

    private void f(RelationshipSet relationshipSet) {
        if (!relationshipSet.getExtendedName().equals(QNameConstants.definitionLink)) {
            return;
        }
        XdtDRS xdtDRS = (XdtDRS)this.dts.getAllDRS().get(relationshipSet.getRoleURI());
        if (xdtDRS == null) {
            return;
        }
        if (this.byInstance) {
            for (XbrlConcept xbrlConcept : xdtDRS.getAllPrimaryItems()) {
                XdtComponent xdtComponent;
                QName qName = xbrlConcept.getQName();
                if (this.f.containsKey(qName) || (xdtComponent = xdtDRS.tryGetComponent(xbrlConcept)) == null || this.a(xdtDRS, xdtComponent)) continue;
                relationshipSet.purgeRelationships((Object)xbrlConcept);
            }
        } else {
            for (XbrlConcept xbrlConcept : xdtDRS.getAllPrimaryItems()) {
                XdtComponent xdtComponent;
                if (this.g.contains(xbrlConcept) || (xdtComponent = xdtDRS.tryGetComponent(xbrlConcept)) == null || this.b(xdtDRS, xdtComponent)) continue;
                relationshipSet.purgeRelationships((Object)xbrlConcept);
            }
        }
    }

    private void g(RelationshipSet relationshipSet) {
        if (!relationshipSet.getExtendedName().equals(QNameConstants.definitionLink)) {
            return;
        }
        XdtDRS xdtDRS = (XdtDRS)this.dts.getAllDRS().get(relationshipSet.getRoleURI());
        if (xdtDRS == null) {
            return;
        }
        if (this.byInstance) {
            Iterator iterator = xdtDRS.getHasHypercubes().values().iterator();
            while (iterator.hasNext()) {
                XdtCompiledHypercube[] xdtCompiledHypercubeArray;
                XdtCompiledHypercube[] xdtCompiledHypercubeArray2 = xdtCompiledHypercubeArray = (XdtCompiledHypercube[])iterator.next();
                int n = xdtCompiledHypercubeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    XdtCompiledHypercube xdtCompiledHypercube = xdtCompiledHypercubeArray2[n2];
                    if (xdtCompiledHypercube != null) {
                        XdtDimension[] xdtDimensionArray = xdtCompiledHypercube.getDimensions();
                        int n3 = xdtDimensionArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            XdtDimension xdtDimension = xdtDimensionArray[n4];
                            for (XbrlConcept xbrlConcept : xdtDimension.getMembers()) {
                                QName qName = xbrlConcept.getQName();
                                if (this.e.containsKey(qName) || this.h.contains(qName) || this.a(xdtDimension, xdtDimension.getCompiledMember(xbrlConcept))) continue;
                                relationshipSet.purgeRelationships((Object)xbrlConcept);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        } else {
            Iterator iterator = xdtDRS.getHasHypercubes().values().iterator();
            while (iterator.hasNext()) {
                XdtCompiledHypercube[] xdtCompiledHypercubeArray;
                XdtCompiledHypercube[] xdtCompiledHypercubeArray3 = xdtCompiledHypercubeArray = (XdtCompiledHypercube[])iterator.next();
                int n = xdtCompiledHypercubeArray.length;
                int n5 = 0;
                while (n5 < n) {
                    XdtCompiledHypercube xdtCompiledHypercube = xdtCompiledHypercubeArray3[n5];
                    if (xdtCompiledHypercube != null) {
                        XdtDimension[] xdtDimensionArray = xdtCompiledHypercube.getDimensions();
                        int n6 = xdtDimensionArray.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            XdtDimension xdtDimension = xdtDimensionArray[n7];
                            for (XbrlConcept xbrlConcept : xdtDimension.getMembers()) {
                                if (this.g.contains(xbrlConcept) || this.b(xdtDimension, xdtDimension.getCompiledMember(xbrlConcept))) continue;
                                relationshipSet.purgeRelationships((Object)xbrlConcept);
                            }
                            ++n7;
                        }
                    }
                    ++n5;
                }
            }
        }
    }

    private void h(RelationshipSet relationshipSet) {
        Iterator<XbrlConcept> iterator;
        Object object;
        Object object22;
        this.g(relationshipSet);
        this.f(relationshipSet);
        HashSet hashSet = new HashSet();
        relationshipSet.getAllTargets(hashSet);
        ArrayList<XbrlConcept> arrayList = new ArrayList<XbrlConcept>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (Object object3 : hashSet) {
            if (!(object3 instanceof XbrlConcept)) continue;
            object22 = (XbrlConcept)object3;
            if (object22.isHypercube()) {
                arrayList.add((XbrlConcept)object22);
                continue;
            }
            if (!object22.isDimension()) continue;
            arrayList2.add(object22);
        }
        for (XbrlConcept xbrlConcept : arrayList2) {
            object22 = relationshipSet.getChildren((Object)xbrlConcept);
            if (object22.size() != 0) continue;
            relationshipSet.purgeOrProhibitTarget((Object)xbrlConcept);
            if (!xbrlConcept.getName().equals("Axis")) continue;
            this.fixBug("remove " + xbrlConcept + " @" + relationshipSet + " check table", true);
        }
        hashSet.clear();
        hashSet = null;
        if (arrayList.size() == 0) {
            return;
        }
        for (XbrlConcept xbrlConcept : arrayList) {
            for (Object object22 : relationshipSet.getParents((Object)xbrlConcept)) {
                Object object3;
                XbrlConcept xbrlConcept2 = object22.fromConcept();
                if (xbrlConcept2 == null || (object3 = relationshipSet.getChildren((Object)xbrlConcept2)).size() != 1 || (object = ((Relationship)object3.get(0)).toConcept()) != xbrlConcept) continue;
                relationshipSet.purgeOrProhibitTarget((Object)xbrlConcept2);
                this.fixBug("remove " + xbrlConcept2 + " @" + relationshipSet + " check table", true);
            }
        }
        for (XbrlConcept xbrlConcept : arrayList) {
            object22 = relationshipSet.getChildren((Object)xbrlConcept);
            if (object22.size() != 0) continue;
            relationshipSet.purgeOrProhibitTarget((Object)xbrlConcept);
            this.fixBug("remove " + xbrlConcept + " @" + relationshipSet + " check table", true);
        }
        for (XbrlConcept xbrlConcept : arrayList) {
            if (relationshipSet.getParents((Object)xbrlConcept).size() != 0) continue;
            object22 = new HashSet();
            iterator = new HashSet();
            ((HashSet)((Object)iterator)).add(xbrlConcept);
            if (!this.a(relationshipSet, xbrlConcept, (HashSet<ExtendedLink>)object22, (HashSet<Object>)((Object)iterator)) || object22.size() != 1) continue;
            for (XbrlConcept xbrlConcept2 : object22) {
                if (this.a((ExtendedLink)xbrlConcept2, (HashSet<Object>)((Object)iterator))) {
                    Iterator iterator2 = ((HashSet)((Object)iterator)).iterator();
                    while (iterator2.hasNext()) {
                        object = iterator2.next();
                        relationshipSet.purgeRelationships(object);
                        this.fixBug("remove " + object + " @" + relationshipSet + " no parent.", true);
                    }
                    continue;
                }
                relationshipSet.purgeRelationships((Object)xbrlConcept);
                this.fixBug("remove " + xbrlConcept + " @" + relationshipSet + " no parent.", true);
            }
        }
        if (relationshipSet.getExtendedName().equals(QNameConstants.definitionLink) && !this.w.contains(relationshipSet.getRoleURI())) {
            boolean bl;
            boolean bl2 = true;
            for (Object object5 : relationshipSet.getRelationships()) {
                if (object5.arcrole().equals("http://xbrl.org/int/dim/arcrole/domain-member")) continue;
                bl = false;
                break;
            }
            if (bl) {
                Object object5;
                object5 = new ArrayList(relationshipSet.getFromTargets());
                iterator = ((ArrayList)object5).iterator();
                while (iterator.hasNext()) {
                    object22 = iterator.next();
                    relationshipSet.purgeRelationships(object22);
                    this.fixBug("remove " + object22 + " @" + relationshipSet + " no table.", true);
                }
            }
        }
    }

    private boolean a(ExtendedLink extendedLink, HashSet<Object> hashSet) {
        for (Relationship relationship : extendedLink.getRelationships()) {
            if (!hashSet.contains(relationship.fromTarget())) {
                return false;
            }
            if (hashSet.contains(relationship.toTarget())) continue;
            return false;
        }
        return true;
    }

    private boolean a(RelationshipSet relationshipSet, XbrlConcept xbrlConcept, HashSet<ExtendedLink> hashSet, HashSet<Object> hashSet2) {
        for (Relationship relationship : relationshipSet.getChildren((Object)xbrlConcept)) {
            XbrlConcept xbrlConcept2 = relationship.toConcept();
            if (xbrlConcept2 != null) {
                if (hashSet2.contains(xbrlConcept2)) continue;
                hashSet2.add(xbrlConcept2);
                hashSet.add(relationship.arc().getOwnerExtended());
                if (this.a(relationshipSet, xbrlConcept2, hashSet, hashSet2)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void i(RelationshipSet relationshipSet) {
        if (relationshipSet == null) {
            return;
        }
        String string = relationshipSet.getRoleURI();
        List<RelationshipSet> list = this.d(string);
        for (RelationshipSet relationshipSet2 : list) {
            ArrayList arrayList = new ArrayList(relationshipSet2.getFromTargets());
            for (Object e2 : arrayList) {
                XbrlConcept xbrlConcept;
                XbrlConcept xbrlConcept2 = xbrlConcept = e2 instanceof XbrlConcept ? (XbrlConcept)e2 : null;
                if (xbrlConcept == null) continue;
                QName qName = xbrlConcept.getQName();
                if (!this.f.containsKey(qName)) {
                    relationshipSet2.purgeOrProhibitTarget((Object)xbrlConcept);
                }
                ArrayList arrayList2 = new ArrayList(relationshipSet2.getChildren((Object)xbrlConcept));
                for (Relationship relationship : arrayList2) {
                    XbrlConcept xbrlConcept3 = relationship.toConcept();
                    if (xbrlConcept3 == null || this.f.containsKey(xbrlConcept3.getQName())) continue;
                    relationshipSet2.purgeRelationships((Object)xbrlConcept3);
                }
            }
        }
    }

    private void a(Collection<XbrlConcept> collection, RelationshipSet relationshipSet) {
        if (relationshipSet == null) {
            return;
        }
        String string = relationshipSet.getRoleURI();
        HashSet<QName> hashSet = new HashSet<QName>();
        HashSet<QName> hashSet2 = new HashSet<QName>();
        List<RelationshipSet> list = this.c(string);
        List<RelationshipSet> list2 = this.e(string);
        ArrayList<XbrlConcept> arrayList = new ArrayList<XbrlConcept>();
        if (this.byInstance) {
            Object object;
            QName qName;
            for (XbrlConcept xbrlConcept : collection) {
                boolean bl;
                boolean bl2;
                boolean bl22;
                if (xbrlConcept == null) continue;
                qName = xbrlConcept.getQName();
                if (xbrlConcept.isDimension() && this.a(qName, xbrlConcept, relationshipSet)) continue;
                object = null;
                if (this.e.containsKey(qName)) {
                    object = false;
                    bl22 = false;
                    for (QName object2 : this.e.get(qName)) {
                        if (!this.a(object2, xbrlConcept, relationshipSet)) continue;
                        bl22 = true;
                        object = true;
                    }
                    if (bl22) continue;
                }
                if (xbrlConcept == null || this.c.contains(qName)) continue;
                boolean bl3 = bl22 = object != null ? (Boolean)object : false;
                if (!bl22) {
                    bl22 = this.a(this.xbrlInstance, xbrlConcept, list, hashSet, this.c);
                }
                boolean bl4 = bl22 ? true : (bl2 = object != null ? (Boolean)object : false);
                if (!bl2) {
                    bl = this.a(this.xbrlInstance, xbrlConcept, list2, hashSet2, this.c);
                }
                if (bl22 || bl) continue;
                if (this.d.containsKey(qName)) {
                    if (this.i == null) {
                        this.i = new HashMap<QName, XbrlConcept>();
                    }
                    this.i.put(qName, xbrlConcept);
                    continue;
                }
                arrayList.add(xbrlConcept);
            }
            if (relationshipSet.getExtendedName().equals(QNameConstants.definitionLink)) {
                for (XbrlConcept xbrlConcept : arrayList) {
                    if (!relationshipSet.contains((Object)xbrlConcept)) continue;
                    relationshipSet.purgeRelationships((Object)xbrlConcept);
                }
                this.h(relationshipSet);
            } else {
                for (XbrlConcept xbrlConcept : this.dts.getRelationshipSets()) {
                    qName = xbrlConcept.getExtendedName();
                    if (qName.equals(QNameConstants.labelLink) || qName.equals(QNameConstants.referenceLink) || qName.equals(QNameConstants.calculationLink) || !ShanghaiCleaner.isPairURI((String)(object = xbrlConcept.getRoleURI()), string)) continue;
                    for (XbrlConcept xbrlConcept2 : arrayList) {
                        if (!xbrlConcept.contains((Object)xbrlConcept2)) continue;
                        this.fixBug("remove concept: " + xbrlConcept2 + " @" + xbrlConcept + " parent-child", true);
                        xbrlConcept.purgeRelationships((Object)xbrlConcept2);
                    }
                    this.h((RelationshipSet)xbrlConcept);
                }
            }
        } else if (relationshipSet.getExtendedName().equals(QNameConstants.definitionLink)) {
            this.h(relationshipSet);
        }
    }

    private void ac() {
        XbrlSchema[] xbrlSchemaArray;
        if (!this.byInstance) {
            return;
        }
        XbrlSchema[] xbrlSchemaArray2 = xbrlSchemaArray = this.getEntrySchema();
        int n = xbrlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            XbrlSchema xbrlSchema = xbrlSchemaArray2[n2];
            if (xbrlSchema != null && !xbrlSchema.isReadOnly()) {
                Map<String, e> map = this.a(xbrlSchema);
                for (e e2 : map.values()) {
                    if (e2.a || e2.d == null) continue;
                    Linkbase linkbase = e2.d;
                    Boolean bl = null;
                    for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                        if (!extendedLink.getNodeName().equals(QNameConstants.presentationLink) && !extendedLink.getNodeName().equals(QNameConstants.definitionLink) && !extendedLink.getNodeName().equals(QNameConstants.calculationLink) && !extendedLink.getNodeName().equals(QNameConstants.referenceLink) && !extendedLink.getNodeName().equals(QNameConstants.labelLink)) continue;
                        if (this.b(extendedLink)) {
                            bl = true;
                            break;
                        }
                        if (bl != null) continue;
                        bl = false;
                    }
                    if (bl == null || bl.booleanValue()) continue;
                    xbrlSchema.removeLinkbaseRef(e2.c);
                    e2.a = true;
                    this.dts.removeRelationships(linkbase.getOwnerDocument());
                }
            }
            ++n2;
        }
    }

    private boolean b(ExtendedLink extendedLink) {
        if (this.byInstance) {
            for (Relationship relationship : extendedLink.getRelationships()) {
                XbrlConcept xbrlConcept = relationship.toConcept();
                if (xbrlConcept != null && this.f.containsKey(xbrlConcept.getQName())) {
                    return true;
                }
                XbrlConcept xbrlConcept2 = relationship.fromConcept();
                if (xbrlConcept2 == null || !this.f.containsKey(xbrlConcept2.getQName())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private Map<String, e> a(XbrlSchema xbrlSchema) {
        HashMap<String, e> hashMap = new HashMap<String, e>();
        for (LinkbaseRef linkbaseRef : xbrlSchema.getLinkbaseRefs()) {
            Linkbase linkbase = this.a(linkbaseRef);
            if (linkbase == null || !linkbase.getOwnerDocument().isReadOnly()) continue;
            e e2 = new e();
            e2.b = linkbase.getOwnerDocument().getBaseURI();
            e2.d = linkbase;
            e2.c = linkbaseRef;
            hashMap.put(e2.b, e2);
        }
        return hashMap;
    }

    private Linkbase a(LinkbaseRef linkbaseRef) {
        XbrlDocument xbrlDocument;
        IXbrlDocument iXbrlDocument;
        URI uRI = linkbaseRef.getDiscoveredUri(null);
        if (uRI != null && (iXbrlDocument = this.dts.getDocument(uRI)) != null && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
            return (Linkbase)xbrlDocument.getDocumentElement();
        }
        return null;
    }

    public boolean importHistory(ImportOptions options) {
        XmlSchema xmlSchema;
        int n;
        XbrlSchema xbrlSchema;
        TaxonomySet taxonomySet;
        block15: {
            block14: {
                String string;
                XbrlUrlResolver xbrlUrlResolver;
                block13: {
                    if (this.dts == null || options == null || options.isEmpty() || options.getDtsBytes() == null) {
                        return false;
                    }
                    if (options.out != null) {
                        this.out = options.out;
                    }
                    xbrlUrlResolver = new XbrlUrlResolver();
                    ZipStream zipStream = new ZipStream(options.getDtsBytes());
                    xbrlUrlResolver.addZipMapping(ZipStream.FILE_DOMAIN, (IZipStream)zipStream);
                    string = null;
                    for (String string2 : zipStream.getEntries()) {
                        if (!string2.endsWith(".xsd")) continue;
                        string = string2;
                        break;
                    }
                    if (string != null) break block13;
                    IOHelper.writeMessage((OutputStream)this.out, (String)"\u6ca1\u6709\u627e\u5230\u5386\u53f2\u62a5\u544a\u7684\u5165\u53e3\u5206\u7c7b\u6807\u51c6\u6587\u4ef6\uff01");
                    return false;
                }
                try {
                    String string2;
                    if (string.startsWith("/")) {
                        string = string.substring(1);
                    }
                    string = String.valueOf(ZipStream.FILE_DOMAIN) + string;
                    string2 = this.p != null ? XbrlLoader.create((TaxonomySet)this.p) : new XbrlLoader();
                    string2.getHandlerContext().setXmlResolver(xbrlUrlResolver);
                    string2.getHandlerContext().setDefaultSilence(true);
                    string2.load(string);
                    taxonomySet = string2.getActiveDTS();
                    xbrlSchema = null;
                    XmlSchema[] xmlSchemaArray = taxonomySet.getSchemas();
                    n = xmlSchemaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        XbrlSchema xbrlSchema2;
                        xmlSchema = xmlSchemaArray[n2];
                        if (xmlSchema instanceof XbrlSchema && !(xbrlSchema2 = (XbrlSchema)xmlSchema).isReadOnly()) {
                            xbrlSchema = xbrlSchema2;
                            break;
                        }
                        ++n2;
                    }
                    if (xbrlSchema != null) break block14;
                    IOHelper.writeMessage((OutputStream)this.out, (String)"\u6ca1\u6709\u627e\u5230\u5386\u53f2\u62a5\u544a\u7684\u5165\u53e3\u6a21\u5f0f\u6587\u4ef6\uff01");
                    return false;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    IOHelper.writeMessage((OutputStream)this.out, (String)exception.getMessage());
                    return false;
                }
            }
            xmlSchema = this.getSingleEntry();
            if (xmlSchema != null) break block15;
            IOHelper.writeMessage((OutputStream)this.out, (String)"\u6ca1\u6709\u627e\u5230\u5f53\u524d\u62a5\u544a\u7684\u5165\u53e3\u5206\u7c7b\u6807\u51c6\u6587\u4ef6\uff01");
            return false;
        }
        OutputStream outputStream = this.out;
        this.out = null;
        this.bugFix();
        this.out = outputStream;
        n = 0;
        int n3 = 0;
        if (options.isImportConcept()) {
            n = this.a((XbrlSchema)xmlSchema, xbrlSchema, taxonomySet);
        }
        if (options.isImportRelaitonship()) {
            n3 = this.a(taxonomySet);
        }
        return n != 0 || n3 != 0;
    }

    private int a(TaxonomySet taxonomySet) {
        int n = 0;
        ArrayList<Relationship> arrayList = new ArrayList<Relationship>();
        for (RelationshipSet relationshipSet : taxonomySet.getRelationshipSets()) {
            RelationshipSet relationshipSet2;
            QName qName = relationshipSet.getExtendedName();
            boolean bl = qName.equals(QNameConstants.presentationLink);
            if (!bl && !qName.equals(QNameConstants.calculationLink) || (relationshipSet2 = this.dts.getRelationshipSet(qName, relationshipSet.getRoleURI())) == null) continue;
            String string = bl ? "http://www.xbrl.org/2003/arcrole/parent-child" : "http://www.xbrl.org/2003/arcrole/summation-item";
            IQName iQName = bl ? QNameConstants.presentationArc : QNameConstants.calculationArc;
            ExtendedLinkSummary extendedLinkSummary = null;
            for (Object e2 : relationshipSet.getFromTargets()) {
                if (!(e2 instanceof XbrlConcept)) continue;
                arrayList.clear();
                XbrlConcept xbrlConcept = (XbrlConcept)e2;
                XbrlConcept xbrlConcept2 = this.dts.getConcept(xbrlConcept.getQName());
                if (xbrlConcept2 == null) continue;
                for (Relationship relationship : relationshipSet.getChildren(e2)) {
                    Object object;
                    Object object2;
                    XbrlConcept xbrlConcept3;
                    XbrlConcept xbrlConcept4;
                    if (!relationship.isOptional() || !(relationship.arc() instanceof PresentationArc) || (xbrlConcept4 = relationship.toConcept()) == null || (xbrlConcept3 = this.dts.getConcept(xbrlConcept4.getQName())) == null) continue;
                    Relationship relationship2 = null;
                    relationship2 = bl ? this.a(relationshipSet2, (Object)xbrlConcept2, xbrlConcept3, relationship) : this.b(relationshipSet2, xbrlConcept2, xbrlConcept3, relationship);
                    if (relationship2 != null) {
                        arrayList.add(relationship2);
                        continue;
                    }
                    if (extendedLinkSummary == null) {
                        object2 = this.b(relationshipSet2);
                        if (object2 == null) continue;
                        extendedLinkSummary = new ExtendedLinkSummary((ExtendedLink)object2, this.dts);
                    }
                    object2 = arrayList.isEmpty() ? BigDecimal.ZERO : ((Relationship)arrayList.get(arrayList.size() - 1)).arc().getOrder();
                    object2 = ((BigDecimal)object2).add(a);
                    relationship2 = extendedLinkSummary.addRelationship(xbrlConcept2, xbrlConcept3, (QName)iQName, string, ((BigDecimal)object2).toPlainString());
                    if (bl) {
                        object = ((PresentationArc)relationship.arc()).getPreferredLabel();
                        if (!StringUtils.isEmpty((String)object)) {
                            ((PresentationArc)relationship2.arc()).setAttribute((QName)QNameConstants.preferredLabel, (String)object);
                        }
                    } else {
                        object = ((CalculationArc)relationship.arc()).getWeight();
                        ((CalculationArc)relationship2.arc()).setAttribute((QName)QNameConstants.weight, ((BigDecimal)object).toPlainString());
                    }
                    ++n;
                    arrayList.add(relationship2);
                }
            }
        }
        IOHelper.writeMessage((OutputStream)this.out, (String)("\u5bfc\u5165" + n + "\u4e2a\u5143\u7d20\u5173\u7cfb\uff1b"));
        if (n != 0) {
            this._hasBugFixed = true;
        }
        return n;
    }

    private Relationship a(RelationshipSet relationshipSet, Object object, Object object2, Relationship relationship) {
        for (Relationship relationship2 : relationshipSet.getChildren(object)) {
            if (relationship2.toTarget() != object2 || !relationship2.isOptional() || !(relationship2.arc() instanceof PresentationArc)) continue;
            PresentationArc presentationArc = (PresentationArc)relationship2.arc();
            PresentationArc presentationArc2 = (PresentationArc)relationship.arc();
            if (!presentationArc.getPreferredLabel().equals(presentationArc2.getPreferredLabel())) continue;
            return relationship2;
        }
        return null;
    }

    private Relationship b(RelationshipSet relationshipSet, Object object, Object object2, Relationship relationship) {
        for (Relationship relationship2 : relationshipSet.getChildren(object)) {
            if (relationship2.toTarget() != object2 || !relationship2.isOptional()) continue;
            return relationship2;
        }
        return null;
    }

    private int a(XbrlSchema xbrlSchema, XbrlSchema xbrlSchema2, TaxonomySet taxonomySet) {
        int n = 0;
        for (Map.Entry entry : xbrlSchema2.getElements().entrySet()) {
            QName qName = (QName)entry.getKey();
            XmlSchemaElement xmlSchemaElement = xbrlSchema.getElementByName(qName.getLocalPart());
            if (xmlSchemaElement != null || !(entry.getValue() instanceof XbrlConcept) || !this.a((XbrlConcept)entry.getValue(), xbrlSchema, taxonomySet)) continue;
            ++n;
        }
        IOHelper.writeMessage((OutputStream)this.out, (String)("\u5bfc\u5165" + n + "\u4e2a\u6269\u5c55\u5143\u7d20\uff1b"));
        if (n != 0) {
            this._hasBugFixed = true;
        }
        return n;
    }

    private boolean a(XbrlConcept xbrlConcept, XbrlSchema xbrlSchema, TaxonomySet taxonomySet) {
        if (this.x == null) {
            this.x = taxonomySet.getLabelRelationships();
        }
        if (this.x == null || this.x.size() == 0) {
            return false;
        }
        String string = xbrlSchema.getTargetNamespace();
        String string2 = xbrlConcept.getName();
        XbrlConcept xbrlConcept2 = new XbrlConcept((XmlSchema)xbrlSchema, true);
        xbrlConcept2.setName(string2);
        xbrlConcept2.setSchemaTypeName(xbrlConcept.getSchemaTypeName());
        xbrlConcept2.setId(String.valueOf(xbrlSchema.getPrefixOfNamespace(string)) + "_" + string2);
        xbrlConcept2.setPeriodType(xbrlConcept.getPeriodType());
        xbrlConcept2.setBalance(xbrlConcept.getBalance());
        xbrlConcept2.setSubstitutionGroup(xbrlConcept.getSubstitutionGroup());
        xbrlConcept2.setAbstract(xbrlConcept.isAbstract());
        xbrlConcept2.setNillable(xbrlConcept.isNillable());
        xbrlConcept2.setDefaultValue(xbrlConcept.getDefaultValue());
        xbrlConcept2.setFixedValue(xbrlConcept.getFixedValue());
        XbrlHelper.processConcept((XbrlConcept)xbrlConcept2);
        boolean bl = false;
        d d2 = this.A();
        if (d2 != null) {
            for (RelationshipSet relationshipSet : this.x) {
                for (Relationship relationship : relationshipSet.getChildren((Object)xbrlConcept)) {
                    if (!relationship.isOptional() || !(relationship.toTarget() instanceof Label)) continue;
                    bl = true;
                    Label label = (Label)relationship.toTarget();
                    this.a(xbrlConcept2, label, d2);
                }
            }
        }
        if (!bl) {
            xbrlSchema.removeItem((XmlSchemaObject)xbrlConcept2);
            return false;
        }
        return true;
    }

    static class a {
        private QName a;
        private RelationshipSet b;
        private int c;

        public a(QName qName, RelationshipSet relationshipSet) {
            this.a = qName;
            this.b = relationshipSet;
        }

        public int hashCode() {
            if (this.c == 0) {
                this.c = this.a.hashCode() * 31 + this.b.hashCode();
            }
            return this.c;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof a) {
                a a2 = (a)o;
                return a2.a.equals(this.a) && a2.b == this.b;
            }
            return false;
        }
    }

    class b {
        private Map<String, String> b = new HashMap<String, String>();
        private Map<String, String> c = new HashMap<String, String>();
        private List<Context> d;

        b() {
            this.d = new ArrayList<Context>(ShanghaiCleaner.this.xbrlInstance.getContexts());
        }

        private Context c(Context context) {
            String string;
            block6: {
                if (context == null || context.getPeriodType() == PeriodType.Instant) {
                    return context;
                }
                string = context.getPeriod().getEndDate();
                if (!StringUtils.isEmpty((String)string)) break block6;
                return null;
            }
            try {
                Scenario scenario = context.getScenario();
                for (Context context2 : this.d) {
                    Scenario scenario2;
                    Period period;
                    String string2;
                    if (context2 == context || context2.getPeriodType() == PeriodType.Duration || !string.equals(string2 = (period = context2.getPeriod()).getInstant()) || !context2.getEntity().XdtEqual(context.getEntity()) || scenario != (scenario2 = context2.getScenario()) && (scenario == null || !scenario.XdtEqual((OpenContextComponent)scenario2))) continue;
                    return context2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            string = this.f(context);
            if (string != null) {
                this.d.add((Context)string);
            }
            return string;
        }

        private Context d(Context context) {
            String string;
            block6: {
                if (context == null || context.getPeriodType() == PeriodType.Duration) {
                    return context;
                }
                string = context.getPeriod().getInstant();
                if (!StringUtils.isEmpty((String)string)) break block6;
                return null;
            }
            try {
                Scenario scenario = context.getScenario();
                for (Context context2 : this.d) {
                    Scenario scenario2;
                    Period period;
                    String string2;
                    if (context2 == context || context2.getPeriodType() == PeriodType.Instant || !string.equals(string2 = (period = context2.getPeriod()).getEndDate()) || !context2.getEntity().XdtEqual(context.getEntity()) || scenario != (scenario2 = context2.getScenario()) && (scenario == null || !scenario.XdtEqual((OpenContextComponent)scenario2))) continue;
                    return context2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            string = this.g(context);
            if (string != null) {
                this.d.add((Context)string);
            }
            return string;
        }

        private String e(Context context) {
            Object object;
            XdmNode xdmNode;
            StringBuilder stringBuilder = new StringBuilder();
            Period period = context.getPeriod();
            if (context.getPeriodType() == PeriodType.Instant) {
                stringBuilder.append("c_instant_").append(period.getInstant());
            } else {
                stringBuilder.append("c_duration_").append(period.getStartDate()).append("_").append(period.getEndDate());
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (context.getSegment() != null) {
                xdmNode = context.getSegment().getFirstChild();
                while (xdmNode != null) {
                    if (xdmNode.getNodeNature() == 2) {
                        if (xdmNode instanceof ExplicitMember) {
                            object = (ExplicitMember)xdmNode;
                            arrayList.add(String.valueOf(object.getDimension().getLocalPart()) + "_" + object.getDimensionContent().getLocalPart());
                        } else if (xdmNode instanceof TypedMember) {
                            object = (TypedMember)xdmNode;
                            arrayList.add(String.valueOf(object.getDimension().getLocalPart()) + "_" + object.getInnerText());
                        } else {
                            arrayList.add(String.valueOf(xdmNode.getLocalName()) + "_" + xdmNode.getInnerText());
                        }
                    }
                    xdmNode = xdmNode.getNextSibling();
                }
            }
            if (context.getScenario() != null) {
                xdmNode = context.getScenario().getFirstChild();
                while (xdmNode != null) {
                    if (xdmNode.getNodeNature() == 2) {
                        if (xdmNode instanceof ExplicitMember) {
                            object = (ExplicitMember)xdmNode;
                            arrayList.add(String.valueOf(object.getDimension().getLocalPart()) + "_" + object.getDimensionContent().getLocalPart());
                        } else if (xdmNode instanceof TypedMember) {
                            object = (TypedMember)xdmNode;
                            arrayList.add(String.valueOf(object.getDimension().getLocalPart()) + "_" + object.getInnerText());
                        } else {
                            arrayList.add(String.valueOf(xdmNode.getLocalName()) + "_" + xdmNode.getInnerText());
                        }
                    }
                    xdmNode = xdmNode.getNextSibling();
                }
            }
            xdmNode = arrayList.toArray(new String[arrayList.size()]);
            Arrays.sort((Object[])xdmNode);
            XdmNode xdmNode2 = xdmNode;
            int n = ((XdmNode)xdmNode2).length;
            int n2 = 0;
            while (n2 < n) {
                object = xdmNode2[n2];
                stringBuilder.append("_").append((String)object);
                ++n2;
            }
            object = stringBuilder.toString();
            object = ((String)object).replace("-", "");
            object = ((String)object).replace(" ", "");
            return object;
        }

        private Context f(Context context) {
            try {
                Object object;
                Context context2 = ShanghaiCleaner.this.xbrlInstance.createContext();
                XbrlDocument xbrlDocument = ShanghaiCleaner.this.xbrlInstance.getOwnerDocument();
                Entity entity = (Entity)xbrlDocument.importNode((Node)context.getEntity(), true);
                context2.appendChild((XdmNode)entity);
                Period period = context2.createPeriod();
                Instant instant = period.createInstant();
                instant.setInnerText(context.getPeriod().getEndDate());
                period.appendChild((XdmNode)instant);
                context2.appendChild((XdmNode)period);
                Scenario scenario = context.getScenario();
                if (scenario != null) {
                    object = (Scenario)xbrlDocument.importNode((Node)scenario, true);
                    context2.appendChild((XdmNode)object);
                }
                context.getParent().insertBefore((XdmNode)context2, (XdmNode)context);
                Object object2 = object = this.e(context2);
                int n = 1;
                if (xbrlDocument.getElementById((String)object2) != null) {
                    object2 = String.valueOf(object) + ++n;
                }
                context2.setId((String)object2);
                return context2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        private Context g(Context context) {
            try {
                Object object;
                Context context2 = ShanghaiCleaner.this.xbrlInstance.createContext();
                XbrlDocument xbrlDocument = ShanghaiCleaner.this.xbrlInstance.getOwnerDocument();
                Entity entity = (Entity)xbrlDocument.importNode((Node)context.getEntity(), true);
                context2.appendChild((XdmNode)entity);
                Period period = context2.createPeriod();
                String string = context.getPeriod().getInstant();
                StartDate startDate = period.createStartDate();
                startDate.setInnerText(String.valueOf(string.substring(0, 4)) + "-01-01");
                period.appendChild((XdmNode)startDate);
                EndDate endDate = period.createEndDate();
                endDate.setInnerText(string);
                period.appendChild((XdmNode)endDate);
                context2.appendChild((XdmNode)period);
                Scenario scenario = context.getScenario();
                if (scenario != null) {
                    object = (Scenario)xbrlDocument.importNode((Node)scenario, true);
                    context2.appendChild((XdmNode)object);
                }
                context.getParent().insertBefore((XdmNode)context2, (XdmNode)context);
                Object object2 = object = this.e(context2);
                int n = 1;
                if (xbrlDocument.getElementById((String)object2) != null) {
                    object2 = String.valueOf(object) + ++n;
                }
                context2.setId((String)object2);
                return context2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public String a(Context context) {
            String string = context.getId();
            String string2 = this.b.get(string);
            if (string2 == null) {
                Context context2 = this.c(context);
                String string3 = context2 == null ? "" : context2.getId();
                this.b.put(string, string3);
                if (!StringUtils.isEmpty((String)string3)) {
                    this.c.put(string3, string);
                }
                return string3;
            }
            return string2;
        }

        public String b(Context context) {
            String string = context.getId();
            String string2 = this.c.get(string);
            if (string2 == null) {
                Context context2 = this.d(context);
                String string3 = context2 == null ? "" : context2.getId();
                this.c.put(string, string3);
                if (!StringUtils.isEmpty((String)string3)) {
                    this.b.put(string3, string);
                }
                return string3;
            }
            return string2;
        }
    }

    private static class c {
        final XbrlConcept a;
        Set<Object> b = new HashSet<Object>();
        MutableInteger c = new MutableInteger();
        Set<XbrlConcept> d = new HashSet<XbrlConcept>();
        Set<XbrlConcept> e = new HashSet<XbrlConcept>();
        Set<XbrlConcept> f = new HashSet<XbrlConcept>();
        Set<XbrlConcept> g = new HashSet<XbrlConcept>();

        c(XbrlConcept xbrlConcept) {
            this.a = xbrlConcept;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class d {
        XbrlDocument a = null;
        XbrlDocument b = null;
        Map<ExtendedLink, ExtendedLinkSummary> c = null;

        d() {
        }

        public boolean a() {
            return this.a == null || this.b == null;
        }

        private void a(XbrlDocument xbrlDocument, Map<ExtendedLink, ExtendedLinkSummary> map) {
            XdmNode xdmNode = xbrlDocument.getDocumentElement().getFirstChild();
            while (xdmNode != null) {
                if (xdmNode instanceof ExtendedLink) {
                    ExtendedLink extendedLink = (ExtendedLink)xdmNode;
                    map.put(extendedLink, new ExtendedLinkSummary(extendedLink, ShanghaiCleaner.this.dts));
                }
                xdmNode = xdmNode.getNextSibling();
            }
        }

        public Map<ExtendedLink, ExtendedLinkSummary> b() {
            this.c = new HashMap<ExtendedLink, ExtendedLinkSummary>();
            this.a(this.a, this.c);
            this.a(this.b, this.c);
            return this.c;
        }
    }

    static class e {
        private String b;
        private LinkbaseRef c;
        private Linkbase d;
        public boolean a;

        e() {
        }
    }

    static class f {
        XbrlConcept a;
        RelationshipSet b;
        RelationshipSet c;
        XbrlConcept d;
        Relationship e;
        Relationship f;
        ExtendedLinkSummary g;

        public String toString() {
            return this.d + " ->" + this.a;
        }

        f(XbrlConcept xbrlConcept, XbrlConcept xbrlConcept2, RelationshipSet relationshipSet) {
            this.d = xbrlConcept;
            this.a = xbrlConcept2;
            this.b = relationshipSet;
        }
    }
}

