/*
 * Decompiled with CFR 0.152.
 */
package net.gbicc.xbrl.filing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.gbicc.xbrl.core.IXbrlDocument;
import net.gbicc.xbrl.core.Relationship;
import net.gbicc.xbrl.core.RelationshipSet;
import net.gbicc.xbrl.core.RoleType;
import net.gbicc.xbrl.core.TaxonomySet;
import net.gbicc.xbrl.core.XbrlConcept;
import net.gbicc.xbrl.core.XbrlInstance;
import net.gbicc.xbrl.core.XbrlLoader;
import net.gbicc.xbrl.core.dimension.XdtCompiledHypercube;
import net.gbicc.xbrl.core.dimension.XdtComponent;
import net.gbicc.xbrl.core.dimension.XdtDRS;
import net.gbicc.xbrl.filing.CasProcessor;
import net.gbicc.xbrl.filing.CasRedefineRoleType;
import net.gbicc.xbrl.filing.DisclosureSystemType;
import net.gbicc.xbrl.filing.g;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import system.lang.GenericMutable;
import system.qizx.api.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cas2015Processor
extends CasProcessor {
    private final List<String> j = new ArrayList<String>();
    private List<XbrlConcept> k = new ArrayList<XbrlConcept>();

    public Cas2015Processor(DisclosureSystemType type) {
        super(type);
        this.catalog = "Cas2015filing".toUpperCase();
        this.j.add("http://xbrl.mof.gov.cn/taxonomy/2015-03-31/bnk/labels");
        this.j.add("http://xbrl.mof.gov.cn/taxonomy/2015-03-31/bnk/linkbases");
        this.j.add("http://xbrl.mof.gov.cn/taxonomy/2015-03-31/cas/labels");
        this.j.add("http://xbrl.mof.gov.cn/taxonomy/2015-03-31/cas/dimensions");
        this.j.add("http://xbrl.mof.gov.cn/taxonomy/2015-03-31/cas/linkbases");
        this.j.add("http://xbrl.mof.gov.cn/taxonomy/2015-03-31/ogi/labels");
        this.j.add("http://xbrl.mof.gov.cn/taxonomy/2015-03-31/ogi/linkbases");
        this.initNamespace();
    }

    @Override
    protected int getVersion() {
        return 2015;
    }

    @Override
    protected void initNamespace() {
        this.cas_NamespaceURI = "http://xbrl.mof.gov.cn/taxonomy/2015-03-31/cas";
        this.ogi_NamespaceURI = "http://xbrl.mof.gov.cn/taxonomy/2015-03-31/cas/ogi";
        this.bnk_NamespaceURI = "http://xbrl.mof.gov.cn/taxonomy/2015-03-31/cas/bnk";
        this.cas_SchemaLocation = "http://xbrl.mof.gov.cn/taxonomy/2015-03-31/cas/cas_core_2015-03-31.xsd";
        this.cas_EntryPointLocation = "http://xbrl.mof.gov.cn/taxonomy/2015-03-31/cas_entry_point_2015-03-31.xsd";
        this.ogi_EntryPointLocation = "http://xbrl.mof.gov.cn/taxonomy/2015-03-31/ogi_entry_point_2015-03-31.xsd";
        this.bnk_EntryPointLocation = "http://xbrl.mof.gov.cn/taxonomy/2015-03-31/bnk_entry_point_2015-03-31.xsd";
        this.role130000URI = "http://xbrl.mof.gov.cn/role/cas/cas_30_2015-03-31_role-130000";
    }

    protected void checkReuse() {
        boolean bl = true;
        IXbrlDocument[] iXbrlDocumentArray = this.dts.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray[n2];
            String string = iXbrlDocument.getBaseURI();
            for (String string2 : this.j) {
                if (!string.startsWith(string2)) continue;
                bl = false;
            }
            ++n2;
        }
        if (!bl) {
            this.sendMessage("559");
        }
    }

    @Override
    protected void processInstance(XbrlInstance instance) {
        super.processInstance(instance);
        this.checkReuse();
    }

    private void a(RelationshipSet relationshipSet, XbrlConcept xbrlConcept, TaxonomySet[] relationshipSet2, List<RelationshipSet> list, g g2, String string, CasRedefineRoleType casRedefineRoleType, int n, a a2) {
        TaxonomySet taxonomySet;
        if (relationshipSet == null) {
            return;
        }
        String string2 = casRedefineRoleType.getCode1();
        if (StringUtils.isEmpty((String)string2) || !casRedefineRoleType.isValid()) {
            return;
        }
        if (!xbrlConcept.isAbstract() || StringUtils.equals((String)this.getExtendNamespaceURI(), (String)xbrlConcept.getQName().getNamespaceURI())) {
            return;
        }
        a2.a.add(xbrlConcept);
        boolean bl = false;
        this.k.clear();
        RelationshipSet relationshipSet32 = relationshipSet2;
        int n2 = ((TaxonomySet[])relationshipSet32).length;
        int n3 = 0;
        while (n3 < n2) {
            taxonomySet = relationshipSet32[n3];
            XbrlConcept xbrlConcept2 = taxonomySet.getConcept(xbrlConcept.getQName());
            if (xbrlConcept2 != null) {
                RelationshipSet relationshipSet4;
                String string3;
                int n4;
                int n5;
                String[] stringArray;
                String[] stringArray2;
                if (!this.k.contains(xbrlConcept2)) {
                    this.k.add(xbrlConcept2);
                }
                if (g2.e && (stringArray2 = g2.d.get(string2)) != null) {
                    stringArray = stringArray2;
                    n5 = stringArray2.length;
                    n4 = 0;
                    while (n4 < n5) {
                        string3 = stringArray[n4];
                        relationshipSet4 = taxonomySet.getPresentationRelationships(string3);
                        if (relationshipSet4 != null && relationshipSet4.contains((Object)xbrlConcept2)) {
                            bl = true;
                            break;
                        }
                        ++n4;
                    }
                }
                if (bl) break;
                stringArray2 = g2.c.get(string2);
                if (stringArray2 != null) {
                    stringArray = stringArray2;
                    n5 = stringArray2.length;
                    n4 = 0;
                    while (n4 < n5) {
                        string3 = stringArray[n4];
                        relationshipSet4 = taxonomySet.getPresentationRelationships(string3);
                        if (relationshipSet4 != null && relationshipSet4.contains((Object)xbrlConcept2)) {
                            bl = true;
                            break;
                        }
                        ++n4;
                    }
                }
                if (bl) break;
            }
            ++n3;
        }
        if (!bl) {
            taxonomySet = null;
            block3: for (XbrlConcept xbrlConcept3 : this.k) {
                for (RelationshipSet relationshipSet32 : list) {
                    if (!relationshipSet32.contains((Object)xbrlConcept3)) continue;
                    taxonomySet = relationshipSet32;
                    continue block3;
                }
            }
            if (taxonomySet != null) {
                if (!a2.d.contains(string)) {
                    a2.d.add(string);
                    this.sendMessage("516", new Object[]{this.d(xbrlConcept), this.a(taxonomySet.getRoleURI(), (TaxonomySet[])relationshipSet2), string, this.a(string), this.b(casRedefineRoleType.getCode1(), (TaxonomySet[])relationshipSet2)});
                }
            } else if (n < 2) {
                for (Relationship relationship : relationshipSet.getChildren((Object)xbrlConcept)) {
                    if (relationship.toConcept() == null || !relationship.toConcept().isAbstract()) continue;
                    this.a(relationshipSet, relationship.toConcept(), (TaxonomySet[])relationshipSet2, list, g2, string, casRedefineRoleType, n + 1, a2);
                }
            }
        }
    }

    @Override
    protected void checkRoleURICode1(g checker, Map<String, CasRedefineRoleType> redefine) {
        Object object;
        ArrayList<RelationshipSet> arrayList;
        if (this.d == null) {
            return;
        }
        RelationshipSet relationshipSet = null;
        if (checker.e) {
            arrayList = new ArrayList<RelationshipSet>();
            arrayList.add((RelationshipSet)this.d);
            if (this.d.getBaseTaxonomySet() != null) {
                arrayList.add((RelationshipSet)this.d.getBaseTaxonomySet());
            }
            relationshipSet = arrayList.toArray(new TaxonomySet[arrayList.size()]);
        } else {
            relationshipSet = new TaxonomySet[]{this.d};
        }
        arrayList = new ArrayList();
        RelationshipSet relationshipSet2 = relationshipSet;
        int n = ((TaxonomySet[])relationshipSet2).length;
        int n2 = 0;
        while (n2 < n) {
            object = relationshipSet2[n2];
            arrayList.addAll(object.getPresentationRelationships());
            ++n2;
        }
        object = new a();
        object.f = relationshipSet;
        object.e = arrayList;
        object.h = checker;
        for (Map.Entry<String, CasRedefineRoleType> entry : redefine.entrySet()) {
            relationshipSet2 = this.dts.getPresentationRelationships(entry.getKey());
            if (relationshipSet2 == null) continue;
            object.c = entry.getKey();
            object.i = entry.getValue();
            object.g = entry.getValue().getCode1();
            object.a.clear();
            for (Object e2 : relationshipSet2.getRootNodes()) {
                if (!(e2 instanceof XbrlConcept)) continue;
                this.a(relationshipSet2, (XbrlConcept)e2, (TaxonomySet[])relationshipSet, arrayList, checker, entry.getKey(), entry.getValue(), 0, (a)object);
            }
            if (object.d.contains(object.c) || StringUtils.isEmpty((String)object.g)) continue;
            object.b.clear();
            relationshipSet2.getAllConcepts(object.b);
            for (XbrlConcept xbrlConcept : object.b) {
                if (!xbrlConcept.isHypercube()) continue;
                for (Relationship relationship : relationshipSet2.getParents((Object)xbrlConcept)) {
                    XbrlConcept xbrlConcept2 = relationship.fromConcept();
                    if (xbrlConcept2 == null || object.a.contains(xbrlConcept2)) continue;
                    this.a((a)object, xbrlConcept2, xbrlConcept);
                }
            }
        }
    }

    private void a(a a2, XbrlConcept xbrlConcept, XbrlConcept xbrlConcept2) {
        TaxonomySet taxonomySet;
        boolean bl = false;
        TaxonomySet[] taxonomySetArray = a2.f;
        int n = a2.f.length;
        int n2 = 0;
        while (n2 < n) {
            RelationshipSet relationshipSet;
            String string;
            int n3;
            int n4;
            String[] stringArray;
            String[] stringArray2;
            taxonomySet = taxonomySetArray[n2];
            if (a2.h.e && (stringArray2 = a2.h.d.get(a2.g)) != null) {
                stringArray = stringArray2;
                n4 = stringArray2.length;
                n3 = 0;
                while (n3 < n4) {
                    string = stringArray[n3];
                    relationshipSet = taxonomySet.getPresentationRelationships(string);
                    if (relationshipSet != null && relationshipSet.containRelationship((Object)xbrlConcept, (Object)xbrlConcept2, "http://www.xbrl.org/2003/arcrole/parent-child")) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            }
            if (bl) break;
            stringArray2 = a2.h.c.get(a2.g);
            if (stringArray2 != null) {
                stringArray = stringArray2;
                n4 = stringArray2.length;
                n3 = 0;
                while (n3 < n4) {
                    string = stringArray[n3];
                    relationshipSet = taxonomySet.getPresentationRelationships(string);
                    if (relationshipSet != null && relationshipSet.containRelationship((Object)xbrlConcept, (Object)xbrlConcept2, "http://www.xbrl.org/2003/arcrole/parent-child")) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            }
            if (bl) break;
            ++n2;
        }
        if (!bl) {
            taxonomySet = null;
            for (RelationshipSet relationshipSet : a2.e) {
                if (relationshipSet == null || !relationshipSet.containRelationship((Object)xbrlConcept, (Object)xbrlConcept2, "http://www.xbrl.org/2003/arcrole/parent-child")) continue;
                taxonomySet = relationshipSet;
                break;
            }
            if (taxonomySet != null) {
                if (!a2.d.contains(a2.c)) {
                    a2.d.add(a2.c);
                    this.sendMessage("516", new Object[]{String.valueOf(this.d(xbrlConcept)) + " - " + this.d(xbrlConcept2), this.a(taxonomySet.getRoleURI(), a2.f), a2.c, this.a(a2.c), this.b(a2.i.getCode1(), a2.f)});
                }
            } else {
                this.a(a2, xbrlConcept2);
            }
        }
    }

    private void a(a a2, XbrlConcept xbrlConcept) {
        TaxonomySet taxonomySet;
        boolean bl = false;
        TaxonomySet[] taxonomySetArray = a2.f;
        int n = a2.f.length;
        int n2 = 0;
        while (n2 < n) {
            RelationshipSet relationshipSet;
            String string;
            int n3;
            int n4;
            String[] stringArray;
            String[] stringArray2;
            taxonomySet = taxonomySetArray[n2];
            if (a2.h.e && (stringArray2 = a2.h.d.get(a2.g)) != null) {
                stringArray = stringArray2;
                n4 = stringArray2.length;
                n3 = 0;
                while (n3 < n4) {
                    string = stringArray[n3];
                    relationshipSet = taxonomySet.getPresentationRelationships(string);
                    if (relationshipSet != null && relationshipSet.contains((Object)xbrlConcept)) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            }
            if (bl) break;
            stringArray2 = a2.h.c.get(a2.g);
            if (stringArray2 != null) {
                stringArray = stringArray2;
                n4 = stringArray2.length;
                n3 = 0;
                while (n3 < n4) {
                    string = stringArray[n3];
                    relationshipSet = taxonomySet.getPresentationRelationships(string);
                    if (relationshipSet != null && relationshipSet.contains((Object)xbrlConcept)) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
            }
            if (bl) break;
            ++n2;
        }
        if (!bl) {
            taxonomySet = null;
            for (RelationshipSet relationshipSet : a2.e) {
                if (relationshipSet == null || !relationshipSet.contains((Object)xbrlConcept)) continue;
                taxonomySet = relationshipSet;
                break;
            }
            if (taxonomySet != null && !a2.d.contains(a2.c)) {
                a2.d.add(a2.c);
                this.sendMessage("516", new Object[]{this.d(xbrlConcept), this.a(taxonomySet.getRoleURI(), a2.f), a2.c, this.a(a2.c), this.b(a2.i.getCode1(), a2.f)});
            }
        }
    }

    @Override
    void a(String[] stringArray) {
        Object object;
        List<Object> list;
        Map.Entry entry;
        GenericMutable genericMutable2;
        HashSet<String> hashSet = new HashSet<String>();
        Collection collection = this.dts.getAllDRS().values();
        Collection collection2 = this.d.getAllDRS().values();
        HashMap<String, ArrayList<Object>> hashMap = new HashMap<String, ArrayList<Object>>();
        HashMap<Object, ArrayList<Object>> hashMap2 = new HashMap<Object, ArrayList<Object>>();
        for (GenericMutable genericMutable2 : this.d.getPresentationRelationships()) {
            RoleType roleType = this.d.getRoleTypes().getSingle(genericMutable2.getRoleURI());
            if (roleType == null || !((CasProcessor.d)((Object)(entry = new CasProcessor.d(this, roleType)))).a()) continue;
            list = (List)hashMap.get(((CasProcessor.d)((Object)entry)).b);
            if (list == null) {
                list = new ArrayList<Object>();
                hashMap.put(((CasProcessor.d)((Object)entry)).b, (ArrayList<Object>)list);
            }
            list.add(entry);
            object = ((CasProcessor.d)((Object)entry)).d;
            if (StringUtils.isEmpty((String)object)) {
                object = ((CasProcessor.d)((Object)entry)).c;
            }
            if (StringUtils.isEmpty((String)object)) continue;
            list = (List)hashMap2.get(object);
            if (list == null) {
                list = new ArrayList<Object>(4);
                hashMap2.put(object, (ArrayList<Object>)list);
            }
            list.add(entry);
        }
        genericMutable2 = new GenericMutable();
        for (XdtDRS xdtDRS : collection) {
            list = xdtDRS.getDirectHasHyperCubes().entrySet().iterator();
            while (list.hasNext()) {
                entry = list.next();
                object = ((XdtComponent)entry.getKey()).getConcept();
                if (object == null) continue;
                XdtCompiledHypercube[] xdtCompiledHypercubeArray = (XdtCompiledHypercube[])entry.getValue();
                int n = xdtCompiledHypercubeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string;
                    XdtCompiledHypercube xdtCompiledHypercube = xdtCompiledHypercubeArray[n2];
                    XbrlConcept xbrlConcept = xdtCompiledHypercube.getConcept();
                    CasRedefineRoleType casRedefineRoleType = (CasRedefineRoleType)this.g.get(xdtDRS.getRole());
                    if (casRedefineRoleType != null && (string = casRedefineRoleType.getCode1()) != null && string.length() == 6 && string.charAt(0) != '6') {
                        XdtCompiledHypercube xdtCompiledHypercube2;
                        Object object2;
                        Object object32;
                        String string2 = null;
                        genericMutable2.value = "";
                        String string3 = null;
                        boolean bl = false;
                        block4: for (Object object32 : collection2) {
                            if (bl) break;
                            object2 = object32.tryGetHypercubes((XbrlConcept)object);
                            if (object2 == null) continue;
                            XdtCompiledHypercube[] xdtCompiledHypercubeArray2 = object2;
                            int n3 = ((XdtCompiledHypercube[])object2).length;
                            int n4 = 0;
                            while (n4 < n3) {
                                xdtCompiledHypercube2 = xdtCompiledHypercubeArray2[n4];
                                if (xdtCompiledHypercube2.getConcept() == xbrlConcept) {
                                    string3 = object32.getRole();
                                    string2 = this.a(string3, (GenericMutable<String>)genericMutable2);
                                    if (StringUtils.equals((String)string, (String)((String)genericMutable2.value)) || StringUtils.isEmpty((String)((String)genericMutable2.value)) && StringUtils.equals((String)string, (String)string2)) {
                                        bl = true;
                                        continue block4;
                                    }
                                }
                                ++n4;
                            }
                        }
                        if (!bl && xdtCompiledHypercube.getDimensions().length == 1 && xdtCompiledHypercube.getDimensions()[0].getConcept() == this.c && (object32 = (List)hashMap2.get(string)) != null) {
                            object2 = object32.iterator();
                            while (object2.hasNext()) {
                                CasProcessor.d d2 = (CasProcessor.d)object2.next();
                                xdtCompiledHypercube2 = this.d.getPresentationRelationships(d2.e);
                                if (xdtCompiledHypercube2 == null || !xdtCompiledHypercube2.containValidTarget(object) || !StringUtils.equals((String)string, (String)d2.d)) continue;
                                bl = true;
                                break;
                            }
                        }
                        if (!bl && string2 != null) {
                            hashSet.add(xdtDRS.getRole());
                            this.sendMessage("516", new Object[]{String.valueOf(this.d((XbrlConcept)object)) + " - " + this.d(xbrlConcept), this.a(string3, this.d), xdtDRS.getRole(), this.a(xdtDRS.getRole()), this.d(string)});
                        }
                    }
                    ++n2;
                }
            }
        }
        for (XdtDRS xdtDRS : this.dts.getPresentationRelationships()) {
            if (hashSet.contains(xdtDRS.getRoleURI()) || (entry = this.dts.getRoleTypes().getSingle(xdtDRS.getRoleURI())) == null || !((CasProcessor.d)((Object)(list = new CasProcessor.d(this, (RoleType)entry, true)))).a() || (object = (List)hashMap.get(((CasProcessor.d)((Object)list)).b)) == null || object.size() == 0) continue;
            boolean bl = false;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                CasProcessor.d d3 = (CasProcessor.d)iterator.next();
                if (!StringUtils.equals((String)d3.d, (String)((CasProcessor.d)((Object)list)).c) && (!StringUtils.equals((String)d3.c, (String)((CasProcessor.d)((Object)list)).c) || !StringUtils.isEmpty((String)d3.d))) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            CasProcessor.d d4 = (CasProcessor.d)object.get(0);
            this.sendMessage("516", new Object[]{((CasProcessor.d)((Object)list)).b, d4.e, ((CasProcessor.d)((Object)list)).d, ((CasProcessor.d)((Object)list)).e, d4.c});
        }
    }

    @Override
    protected void checkAxisDefault() {
        try {
            TaxonomySet taxonomySet = this.dts.getBaseTaxonomySet();
            if (taxonomySet == null || taxonomySet == XbrlLoader.getXbrlCore()) {
                taxonomySet = this.d;
            }
            if (taxonomySet == null) {
                return;
            }
            Collection collection = this.dts.hasDefaultDimensions();
            for (QName qName : collection) {
                QName[] qNameArray = this.dts.getDimensionDefault(qName);
                if (qNameArray == null) continue;
                QName[] qNameArray2 = qNameArray;
                int n = qNameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    QName qName2 = qNameArray2[n2];
                    Object[] objectArray = taxonomySet.getDimensionDefault(qName);
                    if (objectArray != null && objectArray.length > 0 && !ArrayUtils.contains((Object[])objectArray, (Object)qName2)) {
                        XbrlConcept xbrlConcept = this.dts.getConcept(qName);
                        XbrlConcept xbrlConcept2 = this.dts.getConcept(qName2);
                        XbrlConcept xbrlConcept3 = taxonomySet.getConcept((QName)objectArray[0]);
                        this.sendMessage("562.1", new Object[]{String.valueOf(this.d(xbrlConcept)) + " - " + (xbrlConcept != null ? xbrlConcept.getPrefixedName() : qName.toString()), String.valueOf(this.d(xbrlConcept2)) + " - " + (xbrlConcept2 != null ? xbrlConcept2.getPrefixedName() : qName2.toString()), String.valueOf(this.d(xbrlConcept3)) + " - " + (xbrlConcept3 != null ? xbrlConcept3.getPrefixedName() : objectArray[0].toString())});
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class a {
        Set<XbrlConcept> a = new HashSet<XbrlConcept>();
        Set<XbrlConcept> b = new HashSet<XbrlConcept>();
        String c;
        Set<String> d = new HashSet<String>();
        ArrayList<RelationshipSet> e;
        TaxonomySet[] f;
        String g;
        g h;
        CasRedefineRoleType i;

        private a() {
        }
    }
}

