/*
 * Decompiled with CFR 0.152.
 */
package net.gbicc.xbrl.filing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Pattern;
import net.gbicc.xbrl.core.ArcUse;
import net.gbicc.xbrl.core.BalanceType;
import net.gbicc.xbrl.core.Context;
import net.gbicc.xbrl.core.ContextElementType;
import net.gbicc.xbrl.core.ExtendedLink;
import net.gbicc.xbrl.core.Fact;
import net.gbicc.xbrl.core.GenericLabel;
import net.gbicc.xbrl.core.IXbrlDocument;
import net.gbicc.xbrl.core.Label;
import net.gbicc.xbrl.core.Linkbase;
import net.gbicc.xbrl.core.LinkbaseRef;
import net.gbicc.xbrl.core.PeriodType;
import net.gbicc.xbrl.core.PresentationArc;
import net.gbicc.xbrl.core.ProcessContext;
import net.gbicc.xbrl.core.QNameConstants;
import net.gbicc.xbrl.core.Relationship;
import net.gbicc.xbrl.core.RelationshipSet;
import net.gbicc.xbrl.core.RoleType;
import net.gbicc.xbrl.core.RoleTypeCollection;
import net.gbicc.xbrl.core.SchemaRef;
import net.gbicc.xbrl.core.TaxonomySet;
import net.gbicc.xbrl.core.Unit;
import net.gbicc.xbrl.core.UsedOn;
import net.gbicc.xbrl.core.XbrlConcept;
import net.gbicc.xbrl.core.XbrlDocument;
import net.gbicc.xbrl.core.XbrlHelper;
import net.gbicc.xbrl.core.XbrlInstance;
import net.gbicc.xbrl.core.XbrlLoader;
import net.gbicc.xbrl.core.XbrlMessage;
import net.gbicc.xbrl.core.XbrlSchema;
import net.gbicc.xbrl.core.dimension.ExplicitMember;
import net.gbicc.xbrl.core.dimension.MemberElement;
import net.gbicc.xbrl.core.dimension.XdtCompiledHypercube;
import net.gbicc.xbrl.core.dimension.XdtCompiledMember;
import net.gbicc.xbrl.core.dimension.XdtComponent;
import net.gbicc.xbrl.core.dimension.XdtDRS;
import net.gbicc.xbrl.core.dimension.XdtDimension;
import net.gbicc.xbrl.filing.Cas2015Processor;
import net.gbicc.xbrl.filing.CasComponentModelCheck;
import net.gbicc.xbrl.filing.CasRedefineRoleType;
import net.gbicc.xbrl.filing.DisclosureSystemType;
import net.gbicc.xbrl.filing.ExtendMode;
import net.gbicc.xbrl.filing.RoleVersion;
import net.gbicc.xbrl.filing.e;
import net.gbicc.xbrl.filing.f;
import net.gbicc.xbrl.filing.g;
import net.gbicc.xbrl.filing.j;
import net.gbicc.xbrl.filing.utils.PinyinUtils;
import net.gbicc.xbrl.filing.utils.StandardLabelGroup;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.lang.time.StopWatch;
import system.io.FastByteArrayOutputStream;
import system.io.IOHelper;
import system.lang.GenericMutable;
import system.lang.Int32;
import system.lang.MutableInteger;
import system.lang.MutableString;
import system.qizx.api.EvaluationException;
import system.qizx.api.Node;
import system.qizx.api.QName;
import system.qizx.api.util.time.Date;
import system.qizx.api.util.time.DateTime;
import system.qizx.api.util.time.DateTimeBase;
import system.qizx.api.util.time.DateTimeException;
import system.qizx.xdm.IQName;
import system.qizx.xdm.XdmNSAttribute;
import system.qizx.xdm.XdmNode;
import system.web.HttpUtility;
import system.xml.XmlChar;
import system.xml.schema.XmlSchema;
import system.xml.schema.XmlSchemaElement;
import system.xml.schema.XmlSchemaImport;
import system.xml.schema.XmlSchemaObject;
import system.xmlmind.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasProcessor
extends j {
    protected String cas_NamespaceURI;
    protected String cas_SchemaLocation;
    protected String cas_EntryPointLocation;
    protected String ogi_NamespaceURI;
    protected String ogi_EntryPointLocation;
    protected String bnk_NamespaceURI;
    protected String bnk_EntryPointLocation;
    protected String role130000URI;
    static final QName a = IQName.get((String)"http://www.xbrl.org/2003/iso4217", (String)"CNY");
    private static final char[] j = "?|><:*+\\;=.&!@#{}".toCharArray();
    private static final char[] k = "\uff1f?|><*\u201c\u201d\u037e=.&!@#{}".toCharArray();
    private static final char[] l = "_".toCharArray();
    private static final char[] m = " ()*+[]?\\/{}|@#%^=~`\u201c\u201d\u2018\u2019\u037e:,<>&$\u20a4\u20ac".toCharArray();
    private String n;
    private Date o;
    private Map<XbrlConcept, String> p = new HashMap<XbrlConcept, String>();
    private Map<XbrlConcept, String> q = new HashMap<XbrlConcept, String>();
    protected Collection<RelationshipSet> presentaionRS;
    protected Collection<RelationshipSet> calculationRS;
    private Collection<RelationshipSet> r;
    private Collection<RelationshipSet> s;
    private Collection<RelationshipSet> t;
    private boolean u;
    XbrlConcept b;
    XbrlConcept c;
    private QName v;
    private QName w;
    TaxonomySet d;
    XmlSchema e;
    private String x;
    private String y;
    private ProcessContext z;
    private Collection<RelationshipSet> A;
    static final Pattern f = Pattern.compile("http://([A-Za-z0-9|-]+.)+.[com|com.cn|cn|net|org|biz]+/cas/(?:[0-9]{1,4}(?<!^0?0?0?0))-(?:0?[1-9]|1[0-2])-(?:0?[1-9]|1[0-9]|2[0-8]|(?:(?<=-(?:0?[13578]|1[02])-)(?:29|3[01]))|(?:(?<=-(?:0?[469]|11)-)(?:29|30))|(?:(?<=(?:(?:[0-9]{0,2}(?!0?0)(?:[02468]?(?<![13579])[048]|[13579][26]))|(?:(?:[02468]?[048]|[13579][26])00))-0?2-)(?:29)))");
    private TaxonomySet[] B;
    Map<String, CasRedefineRoleType> g;
    public static final RoleTypeRule[] rules = new RoleTypeRule[]{new RoleTypeRule('1', "Statements"), new RoleTypeRule('2', "Notes"), new RoleTypeRule('3', "Policies"), new RoleTypeRule('4', "Details")};
    private Map<String, List<String>> C = null;
    private Map<j.b, Object> D = new HashMap<j.b, Object>();
    private Map<String, b> E = new HashMap<String, b>();
    private Map<String, XbrlConcept> F = new HashMap<String, XbrlConcept>();
    private Map<String, Object> G = new HashMap<String, Object>();
    private StandardLabelGroup H = new StandardLabelGroup("", "");
    private Map<StandardLabelGroup, StandardLabelGroup> I = new HashMap<StandardLabelGroup, StandardLabelGroup>();
    private Collection<RelationshipSet> J = null;
    private List<Label> K = new ArrayList<Label>();
    private a L = new a();
    private StringBuilder M = new StringBuilder();
    private Map<String, FastByteArrayOutputStream> N;
    private static final String[] O = new String[]{"[text block]", "-", "_", ",", "\uff0c", ".", "\u3002"};
    private static final String[] P = new String[]{"Explanatory", "", " ", " ", " ", " ", " "};
    private static final String[] Q = new String[]{"Explanatory", " ", " ", " ", " ", " ", " "};
    private final MutableString R = new MutableString();
    private MutableInt S = new MutableInt();
    private HashSet<QName> T;
    private HashSet<QName> U;
    private boolean V = true;
    public static final String[] Type_Names = new String[]{"\u8d27\u5e01", "\u6570\u503c", "\u767e\u5206\u6570", "\u6bcf\u80a1\u6536\u76ca\u578b"};
    public static final int Type_Text = -1;
    public static final int Type_Money = 0;
    public static final int Type_Dec = 2;
    public static final int Type_Percent = 4;
    public static final int Type_PerShare = 6;
    TaxonomySet h;
    Collection<RelationshipSet> i;
    private Map<String, XbrlConcept> W;
    private static final char[] X = "(\uff08\uff09)\uff0c,_.\u3002;\uff1b:\uff1a".toCharArray();
    private ProcessContext Y;

    public CasProcessor(DisclosureSystemType type) {
        super(type);
        this.catalog = "Casfiling".toUpperCase();
        this.initNamespace();
    }

    protected void initNamespace() {
        this.cas_NamespaceURI = "http://xbrl.mof.gov.cn/taxonomy/2010-09-30/cas";
        this.cas_SchemaLocation = "http://xbrl.mof.gov.cn/taxonomy/2010-09-30/cas_core_2010-09-30.xsd";
        this.cas_EntryPointLocation = "http://xbrl.mof.gov.cn/taxonomy/2010-09-30/cas_entry_point_2010-09-30.xsd";
        this.ogi_NamespaceURI = "http://xbrl.mof.gov.cn/taxonomy/2011-11-30/cas/ogi";
        this.ogi_EntryPointLocation = "http://xbrl.mof.gov.cn/taxonomy/2011-11-30/cas/ogi/cas_ogi_entry_point_2011-11-30.xsd";
        this.role130000URI = "http://xbrl.mof.gov.cn/role/cas/cas_30_2010-09-30_role-130000";
        this.bnk_NamespaceURI = "http://xbrl.mof.gov.cn/taxonomy/2012-11-30/cas/bnk";
        this.bnk_EntryPointLocation = "http://xbrl.mof.gov.cn/taxonomy/2012-11-30/cas/bnk/bnk_entry_point_2012-11-30.xsd";
    }

    private String g(String string) {
        if (string != null) {
            string = StringUtils.removeEndIgnoreCase((String)string, (String)"Abstract");
            string = StringUtils.removeEndIgnoreCase((String)string, (String)"Axis");
            string = StringUtils.removeEndIgnoreCase((String)string, (String)"LineItems");
            string = StringUtils.removeEndIgnoreCase((String)string, (String)"Member");
            string = StringUtils.removeEndIgnoreCase((String)string, (String)"Table");
            string = StringUtils.removeEndIgnoreCase((String)string, (String)"Explanatory");
            return string;
        }
        return "";
    }

    private TaxonomySet a(TaxonomySet taxonomySet) {
        String string;
        TaxonomySet taxonomySet2 = taxonomySet.getBaseTaxonomySet();
        if (taxonomySet2 == null) {
            XmlSchema[] xmlSchemaArray = taxonomySet.getSchemas();
            int n = xmlSchemaArray.length;
            int n2 = 0;
            while (n2 < n) {
                string = xmlSchemaArray[n2];
                String string2 = string.getTargetNamespace();
                if (string2 != null && string2.startsWith("http://xbrl.mof.gov.cn/taxonomy/") && string.getXmlSchemaSet() != this.dts) {
                    TaxonomySet taxonomySet3;
                    TaxonomySet taxonomySet4 = taxonomySet3 = string.getXmlSchemaSet() instanceof TaxonomySet ? (TaxonomySet)string.getXmlSchemaSet() : null;
                    if (taxonomySet3 != null && taxonomySet3.getEntryFile() != null && taxonomySet3.getEntryFile().startsWith("http://xbrl.mof.gov.cn/taxonomy/")) {
                        taxonomySet2 = taxonomySet3;
                        break;
                    }
                }
                ++n2;
            }
        }
        if (taxonomySet2 == null) {
            string = this.cas_EntryPointLocation;
            XbrlLoader xbrlLoader = XbrlLoader.create((TaxonomySet)taxonomySet);
            xbrlLoader.load(string);
            taxonomySet2 = xbrlLoader.getActiveDTS();
        }
        if (taxonomySet.getSchemas(this.ogi_NamespaceURI).length > 0) {
            string = this.ogi_EntryPointLocation;
            if (!string.equals(taxonomySet2.getEntryFile())) {
                XbrlLoader xbrlLoader = XbrlLoader.create((TaxonomySet)taxonomySet);
                xbrlLoader.load(string);
                taxonomySet2 = xbrlLoader.getActiveDTS();
            }
        } else if (taxonomySet.getSchemas(this.bnk_NamespaceURI).length > 0 && !(string = this.bnk_EntryPointLocation).equals(taxonomySet2.getEntryFile())) {
            XbrlLoader xbrlLoader = XbrlLoader.create((TaxonomySet)taxonomySet);
            xbrlLoader.load(string);
            taxonomySet2 = xbrlLoader.getActiveDTS();
        }
        return taxonomySet2;
    }

    XcType a(XbrlConcept xbrlConcept) {
        if (xbrlConcept == null) {
            return XcType.None;
        }
        if (xbrlConcept.isHypercube()) {
            return XcType.Table;
        }
        if (xbrlConcept.isDimension()) {
            return XcType.Axis;
        }
        String string = xbrlConcept.getName();
        QName qName = xbrlConcept.getSchemaTypeName();
        if (QNameConstants.nonnumDomainItemType.equals((Object)qName)) {
            return XcType.DomainItem;
        }
        if (QNameConstants.nonnumEscapedItemType.equals((Object)qName) || QNameConstants.nonnumTextBlockItemType.equals((Object)qName)) {
            return XcType.Explanatory;
        }
        if (string.endsWith("LineItems")) {
            return XcType.LineItems;
        }
        if (xbrlConcept.isItem()) {
            if (xbrlConcept.isAbstract()) {
                return XcType.AbstractItem;
            }
            if (xbrlConcept.isNumeric()) {
                return XcType.NumericItem;
            }
            return XcType.NonNumericItem;
        }
        return XcType.Concept;
    }

    String b(XbrlConcept xbrlConcept) {
        if (xbrlConcept == null) {
            return "";
        }
        String string = this.p.get(xbrlConcept);
        if (string != null) {
            return string;
        }
        if (this.A == null && this.dts != null) {
            this.A = this.dts.getLabelRelationships();
        }
        for (RelationshipSet relationshipSet : this.A) {
            for (Relationship relationship : relationshipSet.getChildren((Object)xbrlConcept)) {
                Label label;
                Object object;
                if (relationship.arc().getUse() != ArcUse.Optional || (object = relationship.toTarget()) == null || !(object instanceof Label) || !(label = (Label)object).getLang().startsWith("zh") || !label.getRole().equals("http://www.xbrl.org/2003/role/label")) continue;
                string = label.getInnerText().trim();
                this.p.put(xbrlConcept, string);
                return string;
            }
        }
        return "";
    }

    String c(XbrlConcept xbrlConcept) {
        if (xbrlConcept == null) {
            return "";
        }
        String string = this.q.get(xbrlConcept);
        if (string != null) {
            return string;
        }
        TaxonomySet taxonomySet = this.d;
        while (taxonomySet != null) {
            for (RelationshipSet relationshipSet : taxonomySet.getLabelRelationships()) {
                for (Relationship relationship : relationshipSet.getChildren((Object)xbrlConcept)) {
                    Label label;
                    Object object;
                    if (relationship.arc().getUse() != ArcUse.Optional || (object = relationship.toTarget()) == null || !(object instanceof Label) || !(label = (Label)object).getLang().startsWith("zh") || !label.getRole().equals("http://www.xbrl.org/2003/role/label")) continue;
                    string = label.getInnerText().trim();
                    this.q.put(xbrlConcept, string);
                    return string;
                }
            }
            taxonomySet = taxonomySet.getBaseTaxonomySet();
        }
        return "";
    }

    String a(XbrlConcept xbrlConcept, String string, String string2) {
        if (xbrlConcept == null) {
            return "";
        }
        if ("http://www.xbrl.org/2003/role/label" == string2 && string.startsWith("zh")) {
            return this.c(xbrlConcept);
        }
        TaxonomySet taxonomySet = this.d;
        while (taxonomySet != null) {
            for (RelationshipSet relationshipSet : taxonomySet.getLabelRelationships()) {
                for (Relationship relationship : relationshipSet.getChildren((Object)xbrlConcept)) {
                    Label label;
                    Object object;
                    if (relationship.arc().getUse() != ArcUse.Optional || (object = relationship.toTarget()) == null || !(object instanceof Label) || !(label = (Label)object).getLang().startsWith(string) || !label.getRole().equals(string2)) continue;
                    String string3 = label.getInnerText().trim();
                    return string3;
                }
            }
            taxonomySet = taxonomySet.getBaseTaxonomySet();
        }
        return "";
    }

    private void a() {
        if (this.dts == null || this.facts == null) {
            return;
        }
        XbrlSchema xbrlSchema = (XbrlSchema)this.e;
        if (xbrlSchema == null) {
            return;
        }
        Map map = xbrlSchema.getElements();
        if (map != null && !map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                XbrlMessage xbrlMessage;
                XbrlConcept xbrlConcept;
                XbrlConcept xbrlConcept2 = xbrlConcept = entry.getValue() instanceof XbrlConcept ? (XbrlConcept)entry.getValue() : null;
                if (this.a(xbrlConcept, this.presentaionRS) || (xbrlMessage = this.sendMessage("16.6.4", xbrlConcept.getName(), HttpUtility.getFileName((String)this.m(xbrlSchema.getBaseURI())))) == null) continue;
                xbrlMessage.setTag((Object)xbrlConcept);
            }
        }
    }

    private boolean a(XbrlConcept xbrlConcept, Collection<RelationshipSet> collection) {
        if (xbrlConcept != null && collection != null && !collection.isEmpty()) {
            for (RelationshipSet relationshipSet : collection) {
                if (!relationshipSet.contains((Object)xbrlConcept)) continue;
                return true;
            }
        }
        return false;
    }

    private void b() {
        if (this.dts == null || this.facts == null) {
            return;
        }
        XbrlSchema xbrlSchema = (XbrlSchema)this.e;
        if (xbrlSchema == null) {
            return;
        }
        for (c c2 : this.a(xbrlSchema).values()) {
            if (c2 == null || c2.c == null) continue;
            Linkbase linkbase = c2.c;
            Boolean bl = null;
            for (ExtendedLink extendedLink : linkbase.getExtendedLinks()) {
                if (!extendedLink.getNodeName().equals(QNameConstants.presentationLink) && !extendedLink.getNodeName().equals(QNameConstants.definitionLink) && !extendedLink.getNodeName().equals(QNameConstants.calculationLink) && !extendedLink.getNodeName().equals(QNameConstants.referenceLink) && !extendedLink.getNodeName().equals(QNameConstants.labelLink)) continue;
                if (this.a(extendedLink)) {
                    bl = true;
                    break;
                }
                if (bl != null) continue;
                bl = false;
            }
            if (bl == null || bl.booleanValue()) continue;
            this.sendMessage("507", this.m(c2.b.getHref()), this.m(xbrlSchema.getBaseURI()));
        }
    }

    private boolean a(ExtendedLink extendedLink) {
        for (Relationship relationship : extendedLink.getRelationships()) {
            XbrlConcept xbrlConcept = relationship.toConcept();
            if (xbrlConcept != null && this.T.contains(xbrlConcept.getQName())) {
                return true;
            }
            XbrlConcept xbrlConcept2 = relationship.fromConcept();
            if (xbrlConcept2 == null || !this.T.contains(xbrlConcept2.getQName())) continue;
            return true;
        }
        return false;
    }

    private Linkbase a(LinkbaseRef linkbaseRef) {
        XbrlDocument xbrlDocument;
        IXbrlDocument iXbrlDocument;
        URI uRI = linkbaseRef.getDiscoveredUri(null);
        if (uRI != null && (iXbrlDocument = this.dts.getDocument(uRI)) != null && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
            return (Linkbase)xbrlDocument.getDocumentElement();
        }
        return null;
    }

    private Map<String, c> a(XbrlSchema xbrlSchema) {
        HashMap<String, c> hashMap = new HashMap<String, c>();
        for (LinkbaseRef linkbaseRef : xbrlSchema.getLinkbaseRefs()) {
            Linkbase linkbase = this.a(linkbaseRef);
            if (linkbase == null || !linkbase.getOwnerDocument().isReadOnly()) continue;
            c c2 = new c();
            c2.a = linkbase.getOwnerDocument().getBaseURI();
            c2.c = linkbase;
            c2.b = linkbaseRef;
            hashMap.put(c2.a, c2);
        }
        return hashMap;
    }

    private void c() {
        if (this.b == null) {
            return;
        }
        for (RelationshipSet relationshipSet : this.presentaionRS) {
            String string = relationshipSet.getRoleURI();
            if (!this.h(string)) continue;
            HashSet hashSet = new HashSet();
            relationshipSet.getAllTargets(hashSet);
            for (Object e2 : hashSet) {
                if (!relationshipSet.containValidTarget(e2) || !(e2 instanceof XbrlConcept)) continue;
                XbrlConcept xbrlConcept = (XbrlConcept)e2;
                String string2 = this.d(xbrlConcept);
                if (xbrlConcept.isAbstract() || xbrlConcept.getName().contains("Separate") || xbrlConcept.getName().contains("Parent") || string2.contains("\u6bcd\u516c\u53f8") || this.a(xbrlConcept, string)) continue;
                this.sendMessage("12.1", this.a(string), String.valueOf(xbrlConcept.toString()) + " - " + this.a((XmlSchemaElement)xbrlConcept, "http://www.xbrl.org/2003/role/label"), string);
            }
        }
    }

    private boolean a(XbrlConcept xbrlConcept, String string) {
        for (Map.Entry entry : this.dts.getAllDRS().entrySet()) {
            XdtDRS xdtDRS;
            XdtCompiledHypercube[] xdtCompiledHypercubeArray;
            if (!CasProcessor.isPairURI((String)entry.getKey(), string) || (xdtCompiledHypercubeArray = (xdtDRS = (XdtDRS)entry.getValue()).tryGetHypercubes(xbrlConcept)) == null) continue;
            XdtCompiledHypercube[] xdtCompiledHypercubeArray2 = xdtCompiledHypercubeArray;
            int n = xdtCompiledHypercubeArray.length;
            int n2 = 0;
            while (n2 < n) {
                XdtCompiledHypercube xdtCompiledHypercube = xdtCompiledHypercubeArray2[n2];
                int n3 = xdtCompiledHypercube.tryDimension(this.w, this.v);
                if (n3 != 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean h(String string) {
        RoleType[] roleTypeArray = this.dts.getRoleTypes().get(string);
        if (roleTypeArray != null) {
            RoleType[] roleTypeArray2 = roleTypeArray;
            int n = roleTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                RoleType roleType = roleTypeArray2[n2];
                String string2 = roleType.getDefinitionText();
                if (string2 != null && (string2.contains("Separate") || string2.contains("Separated"))) {
                    return true;
                }
                if (this.u) {
                    for (RelationshipSet relationshipSet : this.t) {
                        for (Relationship relationship : relationshipSet.getChildren((Object)roleType)) {
                            GenericLabel genericLabel;
                            if (!(relationship.toTarget() instanceof GenericLabel) || (string2 = (genericLabel = (GenericLabel)relationship.toTarget()).getInnerText()) == null || !string2.contains("Separate") && !string2.contains("Separated")) continue;
                            return true;
                        }
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private void d() {
        for (RelationshipSet relationshipSet : this.presentaionRS) {
            for (Relationship relationship : relationshipSet.getRelationships()) {
                String string;
                XbrlConcept xbrlConcept = relationship.toConcept();
                if (!(relationship.arc() instanceof PresentationArc) || xbrlConcept == null) continue;
                PresentationArc presentationArc = (PresentationArc)relationship.arc();
                String string2 = presentationArc.getPreferredLabel();
                if (StringUtils.isEmpty((String)string2)) {
                    string2 = "http://www.xbrl.org/2003/role/label";
                }
                if ((string = this.a((XmlSchemaElement)xbrlConcept, string2)) != null && string.contains("\u671f\u521d") && !Label.isPeriodStartLabel((String)string2) && !string.endsWith("[member]") && !string.contains("\u671f\u521d\u81f3")) {
                    this.sendMessage("20.7.1", new Object[]{this.a(relationshipSet.getRoleURI()), xbrlConcept.getPrefixedName(), string, relationshipSet.getRoleURI(), this.m(presentationArc.getOwnerDocument().getBaseURI())});
                }
                if (QNameConstants.nonnumDomainItemType.equals((Object)xbrlConcept.getSchemaTypeName()) && string.endsWith("\u5c0f\u8ba1 [member]")) {
                    this.a(xbrlConcept, relationshipSet);
                }
                if (!xbrlConcept.isHypercube()) continue;
                this.a(relationshipSet, xbrlConcept);
            }
        }
    }

    private void a(RelationshipSet relationshipSet, XbrlConcept xbrlConcept) {
        for (Relationship relationship : relationshipSet.getParents((Object)xbrlConcept)) {
            boolean bl = false;
            for (Relationship relationship2 : relationshipSet.getChildren(relationship.fromTarget())) {
                XbrlConcept xbrlConcept2 = relationship2.toConcept();
                if (xbrlConcept2 == xbrlConcept || xbrlConcept2 == null || !xbrlConcept2.getName().endsWith("LineItems") && !xbrlConcept2.getName().endsWith("LineItem")) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.sendMessage("537", new Object[]{this.a(relationshipSet.getRoleURI()), xbrlConcept.getPrefixedName(), this.d(xbrlConcept)});
        }
    }

    private boolean a(XbrlConcept xbrlConcept, RelationshipSet relationshipSet) {
        boolean bl = false;
        for (RelationshipSet relationshipSet2 : this.e(relationshipSet.getRoleURI())) {
            if (!relationshipSet2.contains((Object)xbrlConcept)) continue;
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            for (Relationship relationship : relationshipSet2.getParents((Object)xbrlConcept)) {
                Object object = relationship.fromTarget();
                if (arrayList.contains(object)) continue;
                arrayList.add(object);
                for (Relationship relationship2 : relationshipSet2.getChildren(object, "http://xbrl.org/int/dim/arcrole/domain-member")) {
                    String string;
                    XbrlConcept xbrlConcept2;
                    if (relationship2.toTarget() == xbrlConcept || (xbrlConcept2 = relationship2.toConcept()) == null || !(string = this.d(xbrlConcept2)).contains("\u51cf")) continue;
                    bl = true;
                    this.sendMessage("532", new Object[]{xbrlConcept.getPrefixedName(), this.d(xbrlConcept), xbrlConcept2.getPrefixedName(), string, this.a(relationshipSet.getRoleURI())});
                }
            }
        }
        return bl;
    }

    String a(String string) {
        RoleType[] roleTypeArray = this.dts.getRoleTypes().get(string);
        if (roleTypeArray != null && roleTypeArray.length > 0) {
            RoleType roleType = roleTypeArray[0];
            return roleType.getDefinitionText();
        }
        return string;
    }

    String b(String string) {
        RoleType[] roleTypeArray = this.dts.getRoleTypes().get(string);
        if (roleTypeArray != null && roleTypeArray.length > 0) {
            RoleType roleType = roleTypeArray[0];
            return roleType.getDefinitionText();
        }
        return string;
    }

    String a(String string, TaxonomySet taxonomySet) {
        RoleType[] roleTypeArray = taxonomySet.getRoleTypes().get(string);
        if (roleTypeArray != null && roleTypeArray.length > 0) {
            RoleType roleType = roleTypeArray[0];
            return roleType.getDefinitionText();
        }
        return string;
    }

    String a(String string, TaxonomySet[] taxonomySetArray) {
        TaxonomySet[] taxonomySetArray2 = taxonomySetArray;
        int n = taxonomySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            TaxonomySet taxonomySet = taxonomySetArray2[n2];
            String string2 = this.a(string, taxonomySet);
            if (string2 != string) {
                return string2;
            }
            ++n2;
        }
        return string;
    }

    private String i(String string) {
        DateTime dateTime = null;
        String string2 = null;
        XbrlConcept xbrlConcept = this.dts.getConcept(string);
        if (xbrlConcept == null || string.startsWith("ifrs:")) {
            xbrlConcept = this.dts.getConcept(StringUtils.replace((String)string, (String)"ifrs:", (String)"ifrs-full:"));
        }
        if (xbrlConcept != null) {
            boolean bl = xbrlConcept.getPeriodType() == PeriodType.Duration;
            List list = (List)this.facts.get(xbrlConcept.getQName());
            if (list != null) {
                for (Fact fact : list) {
                    Context context = fact.getContext();
                    if (context == null || context.getDimensionContents().size() != 0) continue;
                    try {
                        DateTime dateTime2;
                        DateTime dateTime3 = dateTime2 = bl ? context.getPeriod().getEndDateElement().getDateTime() : context.getPeriod().getInstantElement().getDateTime();
                        if (dateTime == null) {
                            dateTime = dateTime2;
                            string2 = bl ? context.getPeriod().getEndDateElement().getInnerText().trim() : context.getPeriod().getInstantElement().getInnerText();
                            continue;
                        }
                        if (dateTime2.compareTo((DateTimeBase)dateTime) <= 0) continue;
                        dateTime = dateTime2;
                        string2 = bl ? context.getPeriod().getEndDateElement().getInnerText().trim() : context.getPeriod().getInstantElement().getInnerText();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        }
        return string2;
    }

    private void e() {
        int n;
        String string;
        if (this.o == null && this.instance != null && this.facts != null) {
            string = this.i("ifrs:NameOfReportingEntityOrOtherMeansOfIdentification");
            if (string == null && (string = this.i("cas:BusinessLicenseNumber")) == null) {
                string = this.i("ifrs:Assets");
            }
            if (string != null) {
                try {
                    this.o = Date.parseDate((String)string);
                }
                catch (DateTimeException dateTimeException) {
                    dateTimeException.printStackTrace();
                }
            }
        }
        if (this.o == null && this.e != null && (string = this.e.getTargetNamespace()) != null && (n = string.lastIndexOf(47)) != -1) {
            String string2 = string.substring(n + 1);
            try {
                this.o = Date.parseDate((String)string2);
            }
            catch (DateTimeException dateTimeException) {
                dateTimeException.printStackTrace();
            }
        }
    }

    @Override
    public void process(TaxonomySet dts) {
        String string;
        String string2;
        Object object;
        Object object2;
        XmlSchema[] xmlSchemaArray;
        if (dts == null) {
            return;
        }
        this.dts = dts;
        this.A = dts.getLabelRelationships();
        this.z = new ProcessContext(dts);
        this.V = this.z.getHandlerContext().getOptions().isValidateManual();
        this.presentaionRS = dts.getPresentationRelationships();
        this.r = dts.getDefinitionRelationships();
        this.calculationRS = dts.getCalculationRelationships();
        this.s = dts.getLabelRelationships();
        this.t = dts.getRelationshipSets((QName)QNameConstants.genericLink);
        this.u = this.t.size() > 0;
        this.d = this.a(dts);
        if (this.instance != null) {
            this.prepareInstance(this.instance);
        }
        XbrlSchema xbrlSchema = this.d(dts);
        this.e = xbrlSchema;
        this.e();
        this.y = xbrlSchema == null ? "" : xbrlSchema.getPrefixOfNamespace(xbrlSchema.getTargetNamespace());
        XmlSchema[] xmlSchemaArray2 = xmlSchemaArray = dts.getSchemas();
        int n = xmlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = xmlSchemaArray2[n2];
            object = this.m(object2.getSourceURI());
            String string3 = object2.getTargetNamespace();
            if (string3 != null && !StringUtils.isEmpty((String)string3) && !string3.startsWith("http://www.xbrl.org/") && !string3.startsWith("http://xbrl.org/") && string3.startsWith("http://xbrl.mof.gov.cn/taxonomy/")) {
                if (string3.equals(this.cas_NamespaceURI)) {
                    this.n = this.cas_NamespaceURI;
                    if (!this.cas_SchemaLocation.equals(object2.getSourceURI())) {
                        this.sendMessage("200", object);
                    }
                } else if (object2.getSourceURI() != null && !object2.getSourceURI().startsWith("http://xbrl.mof.gov.cn/taxonomy/")) {
                    this.sendMessage("200", object);
                }
                if ("cas".equals(string2 = object2.getPrefixOfNamespace(string3))) {
                    this.n = string3;
                }
                if (this.d == null && string3 != null && string3.startsWith("http://xbrl.mof.gov.cn/taxonomy/") && object2.getXmlSchemaSet() != this.dts) {
                    Object object3 = string = object2.getXmlSchemaSet() instanceof TaxonomySet ? (TaxonomySet)object2.getXmlSchemaSet() : null;
                    if (string != null && string.getEntryFile() != null && string.getEntryFile().startsWith("http://xbrl.mof.gov.cn/taxonomy/")) {
                        this.d = string;
                    }
                }
            }
            ++n2;
        }
        this.M();
        object2 = new StringBuilder();
        object = xmlSchemaArray;
        int n3 = xmlSchemaArray.length;
        n = 0;
        while (n < n3) {
            XmlSchema xmlSchema = object[n];
            boolean bl = xmlSchema == xbrlSchema;
            string2 = this.m(xmlSchema.getSourceURI());
            string = xmlSchema.getTargetNamespace();
            if (!(string == null || StringUtils.isEmpty((String)string) || string.startsWith("http://www.xbrl.org/") || string.startsWith("http://xbrl.org/"))) {
                for (XmlSchemaElement xmlSchemaElement : xmlSchema.getElements().values()) {
                    int n4;
                    Object object4;
                    if (!(xmlSchemaElement instanceof XbrlConcept)) continue;
                    XbrlConcept xbrlConcept = (XbrlConcept)xmlSchemaElement;
                    QName qName = xbrlConcept.getSchemaTypeName();
                    String string4 = xbrlConcept.getName();
                    this.a(dts, xbrlConcept);
                    if (xmlSchema != xbrlSchema) {
                        object4 = this.G.get(string4);
                        if (object4 == null) {
                            this.G.put(string4, xbrlConcept);
                        } else if (object4 instanceof XbrlConcept) {
                            this.G.put(string4, new Object[]{(XbrlConcept)object4, xbrlConcept});
                        } else {
                            this.G.put(string4, ArrayUtils.add((Object[])((Object[])object4), (Object)xbrlConcept));
                        }
                    } else {
                        this.F.put(string4, xbrlConcept);
                        if (!QNameConstants.nonnumDomainItemType.equals((Object)qName) && PinyinUtils.isPinyinCamelName(this.g(string4), (StringBuilder)object2)) {
                            this.sendMessage("204", string4, string2);
                        }
                        this.f(xbrlConcept);
                    }
                    if (string4.endsWith("Abstract")) {
                        if (!xbrlConcept.isAbstract()) {
                            this.sendMessage("202", string4, string2);
                        } else if (xbrlConcept.isMonetaryItem()) {
                            this.sendMessage("203", string4, string2);
                        }
                    } else if (string4.endsWith("LineItems")) {
                        this.e(xbrlConcept);
                        if (!xbrlConcept.isAbstract()) {
                            this.sendMessage("18.10.3", string4, string2);
                        }
                    }
                    if (QNameConstants.nonnumDomainItemType.equals((Object)qName)) {
                        if (!xbrlConcept.isAbstract() || !xbrlConcept.getName().endsWith("Member") || xbrlConcept.getPeriodType() != PeriodType.Duration) {
                            this.sendMessage("102", xmlSchemaElement.getName(), string2);
                        }
                    } else if (QNameConstants.nonnumTextBlockItemType.equals((Object)qName) || QNameConstants.nonnumEscapedItemType.equals((Object)qName)) {
                        if (bl) {
                            if (!xbrlConcept.getName().endsWith("Explanatory")) {
                                this.sendMessage("103", xmlSchemaElement.getName(), string2);
                            } else if (this.getVersion() == 2015 && !QNameConstants.nonnumTextBlockItemType.equals((Object)qName)) {
                                this.sendMessage("103.1.1", ((XbrlConcept)xmlSchemaElement).getPrefixedName(), this.b((XbrlConcept)xmlSchemaElement));
                            }
                        }
                    } else if (bl && xbrlConcept.getName().endsWith("Explanatory") && this.getVersion() == 2015) {
                        this.sendMessage("103.1.1", ((XbrlConcept)xmlSchemaElement).getPrefixedName(), this.b((XbrlConcept)xmlSchemaElement));
                    }
                    if (xbrlConcept.isDimension()) {
                        if (!xbrlConcept.getName().endsWith("Axis")) {
                            this.sendMessage("18.8.1", xmlSchemaElement.getName(), string2);
                        }
                        if (!xbrlConcept.isAbstract()) {
                            this.sendMessage("18.8.2", xmlSchemaElement.getName(), string2);
                        }
                    } else if (xbrlConcept.isHypercube()) {
                        if (!xbrlConcept.getName().endsWith("Table")) {
                            this.sendMessage("18.9.1", xmlSchemaElement.getName(), string2);
                        }
                        if (!xbrlConcept.isAbstract()) {
                            this.sendMessage("18.9.2", xmlSchemaElement.getName(), string2);
                        }
                    }
                    if (!xbrlConcept.isNillable()) {
                        this.sendMessage("18.3", xmlSchemaElement.getName(), string2);
                    }
                    if (!bl) continue;
                    if (xbrlConcept.isItem() && xbrlConcept.isAbstract() && !QNameConstants.nonnumDomainItemType.equals((Object)qName)) {
                        if (!QNameConstants.stringItemType.equals((Object)qName)) {
                            this.sendMessage("18.6.1", xbrlConcept.getPrefixedName(), xbrlConcept.getPrefixedName(qName));
                        }
                        if (xbrlConcept.getPeriodType() != PeriodType.Duration) {
                            this.sendMessage("18.6.2", xbrlConcept.getPrefixedName(), xbrlConcept.getPeriodType());
                        }
                    }
                    if (QNameConstants.stringItemType.equals((Object)qName) && xbrlConcept.isItem() && xbrlConcept.isAbstract() && xbrlConcept.getPeriodType() != PeriodType.Duration) {
                        this.sendMessage("104", xmlSchemaElement.getName(), string2);
                    }
                    if ((n4 = ((String)(object4 = xbrlConcept.getName())).indexOf("Begin")) == -1 || ((String)object4).indexOf("Balance") <= n4) continue;
                    this.sendMessage("511", xbrlConcept.getPrefixedName(), string2);
                }
            }
            ++n;
        }
        this.b = dts.getConcept("SeparateMember", StringUtils.isEmpty((String)this.n) ? this.cas_NamespaceURI : this.n);
        this.c = dts.getConcept("ConsolidatedAndIndividualFinancialStatementAxis", StringUtils.isEmpty((String)this.n) ? this.cas_NamespaceURI : this.n);
        this.v = this.b != null ? this.b.getQName() : null;
        this.w = this.c != null ? this.c.getQName() : null;
        this.b(dts);
        this.c(dts);
        this.A();
        this.B();
        this.l();
        this.k();
        this.y();
        this.d();
        this.c();
        this.w();
        this.q();
        this.u();
        this.s();
        this.z();
        this.r();
        this.t();
        this.o();
        this.m();
        this.n();
        this.checkRoleDefinition();
        if (this.getExtendMode().isRedefineMode()) {
            net.gbicc.xbrl.filing.d d2 = new net.gbicc.xbrl.filing.d(this, (XbrlSchema)this.e);
            d2.b = this.W;
            d2.a();
            d2.d();
            d2.b();
            d2.c();
            d2.a(this.presentaionRS);
            CasComponentModelCheck casComponentModelCheck = new CasComponentModelCheck(this, this.d);
            casComponentModelCheck.a(this.g);
        }
        this.j();
        this.i();
        this.g();
        this.h();
        this.f();
        this.checkAxisDefault();
    }

    protected void checkAxisDefault() {
    }

    private void f() {
        Collection collection = this.dts.getReferenceRelationships();
        for (RelationshipSet relationshipSet : collection) {
            for (Relationship relationship : relationshipSet.getRelationships()) {
                if (relationship.isReadOnly()) continue;
                this.sendMessage("24", relationship.getOwnerExtended().getOwnerDocument().getBaseURI());
            }
        }
    }

    @Override
    protected void clear() {
        if (this.N != null) {
            String string = SystemUtils.IS_OS_WINDOWS ? "C:\\xbrl\\report" : "/opt/xbrl/report";
            File file = new File(string);
            if (file.exists()) {
                for (Map.Entry<String, FastByteArrayOutputStream> entry : this.N.entrySet()) {
                    File file2 = new File(file, entry.getKey());
                    try {
                        IOHelper.saveAsFile((InputStream)entry.getValue().getInputStream(), (String)file2.getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        entry.getValue().close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            this.N.clear();
            this.N = null;
        }
    }

    private void g() {
        BigDecimal bigDecimal = null;
        HashMap hashMap = new HashMap();
        HashSet<XbrlConcept> hashSet = new HashSet<XbrlConcept>();
        HashSet<XbrlConcept> hashSet2 = null;
        for (RelationshipSet relationshipSet : this.presentaionRS) {
            String string = relationshipSet.getRoleURI();
            for (Object e2 : relationshipSet.getFromTargets()) {
                XbrlConcept xbrlConcept;
                bigDecimal = null;
                hashMap.clear();
                XbrlConcept xbrlConcept2 = xbrlConcept = e2 instanceof XbrlConcept ? (XbrlConcept)e2 : null;
                if (xbrlConcept != null && !hashSet.contains(xbrlConcept)) {
                    hashSet.add(xbrlConcept);
                    if (!xbrlConcept.hasLabel(this.z, "http://www.xbrl.org/2003/role/label")) {
                        this.sendMessage("41.1", new Object[]{this.a(string), xbrlConcept.getPrefixedName()});
                    }
                }
                List list = relationshipSet.getEffectiveChildren(e2);
                for (Relationship relationship : list) {
                    ArrayList<String> arrayList;
                    String string2 = relationship.arc().getAttributeValue((QName)QNameConstants.order);
                    BigDecimal bigDecimal2 = relationship.arc().getOrder();
                    if (StringUtils.isEmpty((String)string2)) {
                        this.sendMessage("21.3.1", new Object[]{this.a(string), relationship.fromTarget(), relationship.toTarget()});
                    }
                    if (bigDecimal != null && bigDecimal2.compareTo(bigDecimal) == 0) {
                        this.sendMessage("21.3.2", new Object[]{this.a(string), relationship.fromTarget(), relationship.toTarget(), string2});
                    }
                    bigDecimal = bigDecimal2;
                    XbrlConcept xbrlConcept3 = relationship.toConcept();
                    if (xbrlConcept3 != null) {
                        if (!hashSet.contains(xbrlConcept3)) {
                            hashSet.add(xbrlConcept3);
                            if (!xbrlConcept3.hasLabel(this.z, "http://www.xbrl.org/2003/role/label")) {
                                this.sendMessage("41.1", new Object[]{this.a(string), xbrlConcept3.getPrefixedName()});
                            }
                        }
                        if (StringUtils.endsWith((String)xbrlConcept3.getName(), (String)"Member") && (xbrlConcept == null || !StringUtils.endsWith((String)xbrlConcept.getName(), (String)"Member") && !StringUtils.endsWith((String)xbrlConcept.getName(), (String)"Axis"))) {
                            this.sendMessage("29.8.1", new Object[]{this.a(string), xbrlConcept3.getPrefixedName()});
                        }
                    }
                    if (!(relationship.arc() instanceof PresentationArc)) continue;
                    PresentationArc presentationArc = (PresentationArc)relationship.arc();
                    String string3 = presentationArc.getPreferredLabel();
                    if (StringUtils.isEmpty((String)string3)) {
                        string3 = "http://www.xbrl.org/2003/role/label";
                    }
                    if (xbrlConcept3 == null) continue;
                    if (!xbrlConcept3.hasLabel(this.z, string3)) {
                        this.sendMessage("21.4.1.1", new Object[]{this.a(string), relationship.fromTarget(), relationship.toTarget(), string3});
                    }
                    if ((arrayList = (ArrayList<String>)hashMap.get(xbrlConcept3)) == null) {
                        arrayList = new ArrayList<String>(2);
                        hashMap.put(xbrlConcept3, arrayList);
                        arrayList.add(string3);
                        continue;
                    }
                    if (arrayList.contains(string3)) {
                        this.sendMessage("21.4.3.1", new Object[]{this.a(string), relationship.fromTarget(), relationship.toTarget(), string3});
                        continue;
                    }
                    arrayList.add(string3);
                    if (!arrayList.contains("http://www.xbrl.org/2003/role/label")) continue;
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet<XbrlConcept>();
                    }
                    if (hashSet2.contains(xbrlConcept3)) continue;
                    hashSet2.add(xbrlConcept3);
                    this.sendMessage("21.4.3.2", new Object[]{this.a(string), relationship.fromTarget(), relationship.toTarget()});
                }
            }
        }
    }

    private void h() {
        HashSet<XbrlConcept> hashSet = new HashSet<XbrlConcept>();
        for (RelationshipSet relationshipSet : this.r) {
            Object object2;
            hashSet.clear();
            String string = relationshipSet.getRoleURI();
            for (Object object2 : relationshipSet.getFromTargets()) {
                XbrlConcept xbrlConcept;
                List list = relationshipSet.getEffectiveChildren(object2);
                if (list.size() > 0 && object2 instanceof XbrlConcept && (xbrlConcept = (XbrlConcept)object2).isHypercube()) {
                    hashSet.add(xbrlConcept);
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    XbrlConcept xbrlConcept2;
                    String string2;
                    xbrlConcept = (Relationship)iterator.next();
                    String string3 = xbrlConcept.arc().getAttributeValue((QName)QNameConstants.order);
                    if (StringUtils.isEmpty((String)string3)) {
                        this.sendMessage("23.1", new Object[]{this.a(string), xbrlConcept.fromTarget(), xbrlConcept.toTarget()});
                    }
                    if (!"http://xbrl.org/int/dim/arcrole/dimension-domain".equals(string2 = xbrlConcept.arcrole()) && !"http://xbrl.org/int/dim/arcrole/dimension-default".equals(string2) || (xbrlConcept2 = xbrlConcept.toConcept()) != null && QNameConstants.nonnumDomainItemType.equals((Object)xbrlConcept2.getSchemaTypeName())) continue;
                    this.sendMessage("23.2", xbrlConcept2 == null ? "Error" : xbrlConcept2.getPrefixedName(), this.b(xbrlConcept2), this.a(string));
                }
            }
            if (hashSet.size() <= 1) continue;
            object2 = new StringBuilder();
            for (XbrlConcept xbrlConcept : hashSet) {
                if (((StringBuilder)object2).length() != 0) {
                    ((StringBuilder)object2).append("; ");
                }
                ((StringBuilder)object2).append(xbrlConcept.getPrefixedName()).append(" - ").append(this.b(xbrlConcept));
            }
            this.sendMessage("23.3", this.a(string), ((StringBuilder)object2).toString());
        }
    }

    private void i() {
        Relationship relationship;
        Object object;
        Object object2;
        for (RelationshipSet relationshipSet : this.calculationRS) {
            object2 = relationshipSet.getRoleURI();
            for (Object object3 : relationshipSet.getFromTargets()) {
                object = relationshipSet.getEffectiveChildren(object3);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string;
                    relationship = (Relationship)iterator.next();
                    String string2 = relationship.arc().getAttributeValue((QName)QNameConstants.order);
                    if (StringUtils.isEmpty((String)string2)) {
                        this.sendMessage("22.1.1", new Object[]{this.a((String)object2), relationship.fromTarget(), relationship.toTarget()});
                    }
                    if (!StringUtils.isEmpty((String)(string = relationship.arc().getAttributeValue((QName)QNameConstants.weight)))) continue;
                    this.sendMessage("22.1.1", new Object[]{this.a((String)object2), relationship.fromTarget(), relationship.toTarget()});
                }
            }
        }
        for (RelationshipSet relationshipSet : this.calculationRS) {
            object2 = this.a(relationshipSet.getRoleURI());
            for (Object object3 : relationshipSet.getRelationships()) {
                object = object3.fromConcept();
                relationship = object3.toConcept();
                if (object == null || relationship == null || object.getPeriodType() == relationship.getPeriodType()) continue;
                this.sendMessage("22.2", new Object[]{object2, object.getPrefixedName(), relationship.getPrefixedName()});
            }
        }
        for (RelationshipSet relationshipSet : this.calculationRS) {
            Object object3;
            object2 = new HashSet();
            object3 = new Stack();
            for (Iterator iterator : relationshipSet.getRootNodes()) {
                if (iterator == null || ((HashSet)object2).contains(iterator)) continue;
                ((Vector)object3).clear();
                ((HashSet)object2).add(iterator);
                ((Stack)object3).push(iterator);
                try {
                    this.a(relationshipSet, iterator, (Stack<Object>)object3, (HashSet<Object>)object2);
                }
                finally {
                    ((Stack)object3).pop();
                }
            }
        }
    }

    private void a(RelationshipSet relationshipSet, Object object, Stack<Object> stack, HashSet<Object> hashSet) {
        for (Relationship relationship : relationshipSet.getChildren(object)) {
            Object object2 = relationship.toTarget();
            if (stack.contains(object2)) {
                if (!(object2 instanceof XbrlConcept)) break;
                XbrlConcept xbrlConcept = relationship.toConcept();
                this.sendMessage("22.3", this.a(relationshipSet.getRoleURI()), xbrlConcept.getPrefixedName());
                break;
            }
            stack.push(object2);
            try {
                hashSet.add(object2);
                this.a(relationshipSet, object2, stack, hashSet);
            }
            finally {
                stack.pop();
            }
        }
    }

    private void j() {
        if (this.dts == null) {
            return;
        }
        HashMap<XbrlDocument, HashSet<String>> hashMap = new HashMap<XbrlDocument, HashSet<String>>();
        for (RelationshipSet object : this.dts.getLabelRelationships()) {
            for (Object object2 : object.getToTargets()) {
                if (!(object2 instanceof Label)) continue;
                Label label = (Label)object2;
                String string = label.getLang();
                XbrlDocument xbrlDocument = label.getOwnerDocument();
                if (xbrlDocument == null) continue;
                HashSet<String> hashSet = (HashSet<String>)hashMap.get(xbrlDocument);
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                    hashMap.put(xbrlDocument, hashSet);
                }
                hashSet.add(string);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Object object2;
            if (((Set)entry.getValue()).size() <= 1) continue;
            object2 = IOHelper.getFileName((String)((IXbrlDocument)entry.getKey()).getBaseURI());
            object2 = HttpUtility.urlDecode(object2);
            this.sendMessage("52", object2);
        }
    }

    private void k() {
        if (this.e == null) {
            this.sendMessage("7.1");
        }
        if (this.e != null && this.e instanceof XbrlSchema) {
            XbrlSchema xbrlSchema = (XbrlSchema)this.e;
            if (this.e.getElements().size() > 0) {
                boolean bl = false;
                boolean bl2 = false;
                for (URI uRI : xbrlSchema.getDiscoveredFiles()) {
                    Linkbase linkbase;
                    Iterator iterator;
                    XbrlDocument xbrlDocument;
                    IXbrlDocument iXbrlDocument = this.dts.getDocument(uRI);
                    if (iXbrlDocument == null || !(iXbrlDocument instanceof XbrlDocument) || !((xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) || !(iterator = (linkbase = (Linkbase)xbrlDocument.getDocumentElement()).getExtendedLinks().iterator()).hasNext()) continue;
                    ExtendedLink extendedLink = (ExtendedLink)iterator.next();
                    if (extendedLink.getNodeName().equals(QNameConstants.presentationLink)) {
                        bl = true;
                        continue;
                    }
                    if (extendedLink.getNodeName().equals(QNameConstants.labelLink)) {
                        bl2 = true;
                        continue;
                    }
                    if (bl && bl2) break;
                }
                if (!bl && !bl2) {
                    this.sendMessage("7.4");
                } else if (!bl) {
                    this.sendMessage("7.2");
                } else if (!bl2) {
                    this.sendMessage("7.3");
                }
            }
        }
    }

    private void l() {
        if (this.e != null) {
            String string = this.e.getTargetNamespace();
            if (StringUtils.isEmpty((String)string)) {
                this.sendMessage("6.2");
            } else {
                boolean bl = f.matcher(string).matches();
                if (!bl) {
                    this.sendMessage("6.1", string);
                } else {
                    int n = string.lastIndexOf("/");
                    bl = false;
                    String string2 = null;
                    if (n != -1) {
                        string2 = string.substring(n + 1);
                        try {
                            Date.parseDate((String)string2);
                            bl = true;
                        }
                        catch (DateTimeException dateTimeException) {
                            // empty catch block
                        }
                    }
                    if (!bl) {
                        this.sendMessage("6.3", string2, string);
                    } else if (string2 != null) {
                        Object object;
                        this.e();
                        if (this.o != null && !string2.equals(object = this.o.toString())) {
                            this.sendMessage("6.4", string2, object);
                        }
                    }
                }
            }
            String string3 = this.e.getPrefixOfNamespace(string);
            if (!XmlChar.isNmToken((String)string3)) {
                this.sendMessage("6.5", string3);
            }
            XbrlSchema xbrlSchema = (XbrlSchema)this.e;
            if (this.extendMode == ExtendMode.Redefine) {
                for (String string2 : xbrlSchema.getLinkbaseRefs()) {
                    if (!string2.getHref().startsWith("http://xbrl.mof.gov.cn/taxonomy")) continue;
                    this.sendMessage("26.1.1", string2.getHref());
                }
            }
        }
    }

    private void e(XbrlConcept xbrlConcept) {
        if (this.presentaionRS == null) {
            this.presentaionRS = this.dts.getPresentationRelationships();
        }
        for (RelationshipSet relationshipSet : this.presentaionRS) {
            Collection collection = relationshipSet.getParents((Object)xbrlConcept);
            if (collection.size() == 0) continue;
            for (Relationship relationship : collection) {
                Object object = relationship.fromTarget();
                boolean bl = false;
                for (Relationship relationship2 : relationshipSet.getChildren(object)) {
                    XbrlConcept xbrlConcept2;
                    if (relationship2.toTarget() == xbrlConcept || (xbrlConcept2 = relationship2.toConcept()) == null || !xbrlConcept2.isHypercube()) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.sendMessage("220", new Object[]{this.a(relationshipSet.getRoleURI()), xbrlConcept.getPrefixedName(), this.d(xbrlConcept)});
            }
        }
    }

    private void b(TaxonomySet taxonomySet) {
        if (taxonomySet == null) {
            return;
        }
        Collection collection = taxonomySet.getDefinitionRelationships();
        GenericMutable genericMutable = new GenericMutable();
        for (QName qName : taxonomySet.hasDefaultDimensions()) {
            XbrlConcept xbrlConcept;
            XbrlConcept xbrlConcept2 = taxonomySet.getConcept(qName);
            if (xbrlConcept2 == null) continue;
            Object[] objectArray = taxonomySet.getDimensionDefault(qName);
            if (objectArray == null) {
                objectArray = QName.EmptyArray;
            }
            for (Object object : collection) {
                for (Relationship relationship : object.getChildren((Object)xbrlConcept2, "http://xbrl.org/int/dim/arcrole/dimension-domain")) {
                    xbrlConcept = relationship.toConcept();
                    if (xbrlConcept == null || ArrayUtils.contains((Object[])objectArray, (Object)xbrlConcept.getQName())) continue;
                    this.sendMessage("112", new Object[]{this.a(object.getRoleURI()), String.valueOf(xbrlConcept2.getPrefixedName()) + "- " + this.b(xbrlConcept2), String.valueOf(xbrlConcept.getPrefixedName()) + "- " + this.b(xbrlConcept)});
                }
            }
            if (objectArray == null || objectArray.length == 0) continue;
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object;
                object = objectArray2[n2];
                xbrlConcept = taxonomySet.getConcept((QName)object);
                if (xbrlConcept != null) {
                    genericMutable.value = null;
                    this.a(taxonomySet, xbrlConcept2, xbrlConcept, (GenericMutable<XbrlConcept>)genericMutable, collection);
                }
                ++n2;
            }
        }
    }

    private void a(TaxonomySet taxonomySet, XbrlConcept xbrlConcept, XbrlConcept xbrlConcept2, GenericMutable<XbrlConcept> genericMutable, Collection<RelationshipSet> collection) {
        boolean bl = false;
        for (RelationshipSet relationshipSet : collection) {
            if (!relationshipSet.contains((Object)xbrlConcept)) continue;
            bl = true;
            XdtDRS xdtDRS = (XdtDRS)taxonomySet.getAllDRS().get(relationshipSet.getRoleURI());
            if (xdtDRS == null || !xdtDRS.containsDimension(xbrlConcept.getQName())) continue;
            for (Relationship relationship : relationshipSet.getChildren((Object)xbrlConcept, "http://xbrl.org/int/dim/arcrole/dimension-domain")) {
                if (!relationship.isOptional() || relationship.toConcept() == null) continue;
                genericMutable.value = relationship.toConcept();
                if (genericMutable.value == xbrlConcept2) {
                    return;
                }
                if (!xdtDRS.isValidMember(xbrlConcept.getQName(), xbrlConcept2.getQName())) continue;
                return;
            }
        }
        if (bl && genericMutable.value != null) {
            this.sendMessage("111", new Object[]{String.valueOf(xbrlConcept.getPrefixedName()) + "- " + this.b(xbrlConcept), String.valueOf(xbrlConcept2.getPrefixedName()) + "- " + this.b(xbrlConcept2), String.valueOf(((XbrlConcept)genericMutable.value).getPrefixedName()) + "- " + this.b((XbrlConcept)genericMutable.value)});
        }
    }

    protected void checkRoleDefinition() {
        if (!this.extendMode.isRedefineMode()) {
            return;
        }
        for (RoleType roleType : this.dts.getRoleTypes()) {
            String string = roleType.getRoleURI();
            if (!string.endsWith("2")) continue;
            String string2 = String.valueOf(string.substring(0, string.length() - 1)) + "4";
            RoleType roleType2 = this.dts.getRoleTypes().getSingle(string2);
            if (roleType2 == null) continue;
            String string3 = roleType.getDefinitionText();
            String string4 = roleType2.getDefinitionText();
            int n = string3.indexOf("-");
            int n2 = string4.indexOf("-");
            if (n != -1) {
                string3 = string3.substring(n + 1).trim();
            }
            if (n2 != -1) {
                string4 = string4.substring(n2 + 1).trim();
            }
            if (string3.equals(string4)) continue;
            this.sendMessage("26.2.1", roleType.getDefinitionText(), roleType2.getDefinitionText());
        }
    }

    private void m() {
        if (this.dts == null) {
            return;
        }
        this.presentaionRS = this.dts.getPresentationRelationships();
        for (RelationshipSet relationshipSet : this.dts.getCalculationRelationships()) {
            String string = relationshipSet.getRoleURI();
            boolean bl = false;
            for (RelationshipSet relationshipSet2 : this.presentaionRS) {
                if (!CasProcessor.isPairURI(string, relationshipSet2.getRoleURI())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.sendMessage("538", this.a(string));
        }
    }

    private void n() {
        if (this.dts == null) {
            return;
        }
        for (RelationshipSet relationshipSet : this.dts.getDefinitionRelationships()) {
            String string = relationshipSet.getRoleURI();
            boolean bl = false;
            boolean bl2 = false;
            XbrlConcept xbrlConcept = null;
            for (Relationship relationship : relationshipSet.getRelationships()) {
                XbrlConcept xbrlConcept2 = relationship.fromConcept();
                if (xbrlConcept2 != null && xbrlConcept2.isHypercube()) {
                    bl = true;
                    break;
                }
                xbrlConcept2 = relationship.toConcept();
                if (xbrlConcept2 == null || !xbrlConcept2.isHypercube()) continue;
                bl = true;
                xbrlConcept = xbrlConcept2;
                bl2 = this.b(relationshipSet, xbrlConcept2);
                break;
            }
            if (!bl) {
                this.sendMessage("539", this.a(string));
                continue;
            }
            if (xbrlConcept == null || bl2) continue;
            this.sendMessage("540", new Object[]{this.a(string), xbrlConcept.getPrefixedName(), this.d(xbrlConcept)});
        }
    }

    private boolean b(RelationshipSet relationshipSet, XbrlConcept xbrlConcept) {
        for (Relationship relationship : relationshipSet.getChildren((Object)xbrlConcept)) {
            for (Relationship relationship2 : relationshipSet.getChildren(relationship.toTarget())) {
                if (relationshipSet.getChildren(relationship2.toTarget()).size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private void o() {
        if (this.dts == null) {
            return;
        }
        for (RelationshipSet relationshipSet : this.dts.getDefinitionRelationships()) {
            if (this.k(relationshipSet.getRoleURI()).size() != 0) continue;
            this.sendMessage("533", this.a(relationshipSet.getRoleURI()));
        }
    }

    private void p() {
    }

    private void f(XbrlConcept xbrlConcept) {
        BalanceType balanceType;
        String string;
        int n;
        boolean bl;
        if (xbrlConcept == null) {
            return;
        }
        QName qName = xbrlConcept.getSubstitutionGroup();
        if (!(QNameConstants.Item.equals((Object)qName) || QNameConstants.DimensionItem.equals((Object)qName) || QNameConstants.HypercubeItem.equals((Object)qName))) {
            this.sendMessage("18.7", xbrlConcept.getPrefixedName(), xbrlConcept.getPrefixedName(qName));
        }
        String string2 = this.d(xbrlConcept);
        String string3 = xbrlConcept.getName();
        boolean bl2 = bl = string3 != null && string3.length() > 0;
        if (bl) {
            n = string3.charAt(0);
            boolean bl3 = bl = n == Character.toUpperCase((char)n);
            if (n == 95) {
                this.sendMessage("18.1.3", xbrlConcept.getPrefixedName(), string2);
            }
        }
        if (!bl) {
            this.sendMessage("18.1.4", xbrlConcept.getPrefixedName(), string2);
        }
        if ((n = StringUtils.indexOfAny((String)string3, (char[])m)) != -1) {
            this.sendMessage("18.1.5", string3.substring(n, n + 1), xbrlConcept.getPrefixedName(), string2);
        }
        if (StringUtils.isEmpty((String)(string = xbrlConcept.getId())) || string.length() != this.y.length() + string3.length() + 1 || !string.equals(String.valueOf(this.y) + "_" + string3)) {
            this.sendMessage("18.2.2", xbrlConcept.getPrefixedName(), string);
        }
        if ((balanceType = xbrlConcept.getBalance()) == BalanceType.Credit || balanceType == BalanceType.Debit) {
            if (string2.endsWith("\u5229\u6da6")) {
                if (balanceType != BalanceType.Credit) {
                    this.sendMessage("527", new Object[]{xbrlConcept.getPrefixedName(), string2, "\u5229\u6da6", "\u8d37 - credit"});
                }
            } else if (string2.endsWith("\u8d1f\u503a")) {
                if (!string2.contains("\u8d44\u4ea7") && balanceType != BalanceType.Credit) {
                    this.sendMessage("527", new Object[]{xbrlConcept.getPrefixedName(), string2, "\u8d1f\u503a", "\u8d37 - credit"});
                }
            } else if (string2.endsWith("\u6536\u5165")) {
                if (balanceType != BalanceType.Credit) {
                    this.sendMessage("527", new Object[]{xbrlConcept.getPrefixedName(), string2, "\u6536\u5165", "\u8d37 - credit"});
                }
            } else if (string2.endsWith("\u6210\u672c") && !string2.endsWith("\u6295\u8d44\u6210\u672c") || string2.endsWith("\u8d39\u7528")) {
                if (balanceType != BalanceType.Debit) {
                    this.sendMessage("527", new Object[]{xbrlConcept.getPrefixedName(), string2, "\u6210\u672c\u3001\u8d39\u7528", "\u501f - debit"});
                }
            } else if (string2.endsWith("\u8d44\u4ea7")) {
                if (balanceType != BalanceType.Debit) {
                    this.sendMessage("527", new Object[]{xbrlConcept.getPrefixedName(), string2, "\u8d44\u4ea7", "\u501f - debit"});
                }
            } else if (string2.endsWith("\u6d41\u5165") || string2.endsWith("\u6536\u5230\u7684\u73b0\u91d1") || string2.endsWith("\u6536\u5230\u73b0\u91d1")) {
                if (balanceType != BalanceType.Debit) {
                    this.sendMessage("527", new Object[]{xbrlConcept.getPrefixedName(), string2, "\u73b0\u91d1\u6d41\u5165", "\u501f - debit"});
                }
            } else if ((string2.endsWith("\u6d41\u51fa") || string2.endsWith("\u6d41\u51fa\u7684\u73b0\u91d1") || string2.endsWith("\u6d41\u51fa\u73b0\u91d1") || string2.endsWith("\u652f\u4ed8\u7684\u73b0\u91d1") || string2.endsWith("\u652f\u4ed8\u73b0\u91d1")) && balanceType != BalanceType.Credit) {
                this.sendMessage("527", new Object[]{xbrlConcept.getPrefixedName(), string2, "\u73b0\u91d1\u6d41\u51fa", "\u8d37 - credit"});
            }
        }
        if (xbrlConcept.getPeriodType() == PeriodType.Instant) {
            if (string2.contains("\u672c\u671f") && !string2.contains("\u671f\u672b") && !string2.contains("\u671f\u521d")) {
                this.sendMessage("16.7.1", new Object[]{xbrlConcept.getPrefixedName(), string2});
            }
        } else if (xbrlConcept.getPeriodType() == PeriodType.Duration && string2.endsWith("\u4f59\u989d")) {
            this.sendMessage("16.7.2", new Object[]{xbrlConcept.getPrefixedName(), string2});
        }
        if (!QNameConstants.nonnumDomainItemType.equals((Object)xbrlConcept.getSchemaTypeName())) {
            if (string2.endsWith("\u516c\u53f8") && !string2.endsWith("\u5b50\u516c\u53f8") && !string2.endsWith("\u6bcd\u516c\u53f8") && !string2.endsWith("\u6240\u5c5e\u516c\u53f8")) {
                this.sendMessage("29.2.1", new Object[]{xbrlConcept.getPrefixedName(), string2});
            } else if (this.j(string2)) {
                this.sendMessage("29.2.2", xbrlConcept.getPrefixedName(), string2);
            }
        }
        if (xbrlConcept.isNumeric()) {
            if (string2.contains("\u6bd4\u4f8b") || string2.contains("\u767e\u5206\u6bd4")) {
                if (!QNameConstants.numPercentItemType.equals((Object)xbrlConcept.getSchemaTypeName())) {
                    this.sendMessage("29.7.1", xbrlConcept.getPrefixedName(), string2);
                }
            } else if (string2.contains("\u6bcf\u80a1") && !QNameConstants.numPerShareItemType.equals((Object)xbrlConcept.getSchemaTypeName())) {
                this.sendMessage("29.7.3", xbrlConcept.getPrefixedName(), string2);
            }
        }
    }

    private boolean j(String string) {
        int n = string.indexOf("\u5e74");
        return n != -1 && (n = string.indexOf("\u6708", n)) != -1;
    }

    private void q() {
        HashSet hashSet;
        XmlSchema[] xmlSchemaArray;
        Object object22;
        HashSet hashSet2 = new HashSet();
        for (Object object22 : this.dts.getPresentationRelationships()) {
            object22.getAllTargets(hashSet2);
        }
        object22 = this.dts.getNamespaceOfPrefix("ifrs");
        XmlSchema xmlSchema = null;
        if (object22 != null && (xmlSchemaArray = this.dts.getSchemas((String)object22)) != null && xmlSchemaArray.length > 0) {
            xmlSchema = xmlSchemaArray[0];
        }
        xmlSchemaArray = this.dts.getLabelRelationships();
        boolean bl = this.d != null && xmlSchema != null;
        HashSet hashSet3 = hashSet = bl ? new HashSet(this.d.getLabelRelationships()) : null;
        if (hashSet != null) {
            Object object3 = this.d.getBaseTaxonomySet();
            int n = 0;
            while (object3 != null && n++ < 10) {
                hashSet.addAll(object3.getLabelRelationships());
                object3 = object3.getBaseTaxonomySet();
            }
        }
        for (Object object3 : hashSet2) {
            XbrlConcept xbrlConcept;
            boolean bl2 = false;
            for (RelationshipSet relationshipSet : xmlSchemaArray) {
                if (!relationshipSet.contains(object3)) continue;
                bl2 = true;
                break;
            }
            if (!bl2 && object3 instanceof XbrlConcept) {
                this.sendMessage("513", ((XbrlConcept)object3).getPrefixedName());
            }
            if (!bl) continue;
            bl2 = false;
            for (RelationshipSet relationshipSet : hashSet) {
                if (!relationshipSet.contains(object3)) continue;
                bl2 = true;
                break;
            }
            if (bl2 || !(object3 instanceof XbrlConcept) || (xbrlConcept = (XbrlConcept)object3).getSchema() != xmlSchema) continue;
            this.sendMessage("16.2.1", this.d(xbrlConcept), xbrlConcept.getPrefixedName());
        }
    }

    @Override
    String d(XbrlConcept xbrlConcept) {
        if (xbrlConcept != null) {
            List list = xbrlConcept.getLabels(this.dts);
            String string = null;
            for (Label label : list) {
                if (!"http://www.xbrl.org/2003/role/label".equals(label.getRole())) continue;
                if (label.getLang().startsWith("zh")) {
                    return label.getInnerText();
                }
                string = label.getInnerText();
            }
            if (string == null && this.d != null) {
                list = xbrlConcept.getLabels(this.d);
                for (Label label : list) {
                    if (!"http://www.xbrl.org/2003/role/label".equals(label.getRole())) continue;
                    if (label.getLang().startsWith("zh")) {
                        return label.getInnerText();
                    }
                    string = label.getInnerText();
                }
            }
            return string == null ? "" : string;
        }
        return "";
    }

    private String a(XbrlConcept xbrlConcept, TaxonomySet taxonomySet) {
        if (xbrlConcept != null) {
            String string = null;
            TaxonomySet taxonomySet2 = taxonomySet;
            while (taxonomySet2 != null) {
                List list = xbrlConcept.getLabels(taxonomySet2);
                for (Label label : list) {
                    if (!"http://www.xbrl.org/2003/role/label".equals(label.getRole())) continue;
                    if (label.getLang().startsWith("zh")) {
                        return label.getInnerText();
                    }
                    string = label.getInnerText();
                }
                taxonomySet2 = taxonomySet2.getBaseTaxonomySet();
            }
            return string == null ? "" : string;
        }
        return "";
    }

    private boolean g(XbrlConcept xbrlConcept) {
        if (xbrlConcept != null) {
            for (RelationshipSet relationshipSet : this.A) {
                for (Relationship relationship : relationshipSet.getChildren((Object)xbrlConcept)) {
                    Label label;
                    String string;
                    Object object;
                    if (relationship.arc().getUse() != ArcUse.Optional || (object = relationship.toTarget()) == null || !(object instanceof Label) || !(string = (label = (Label)object).getRole()).equals("http://www.xbrl.org/2003/role/totalLabel") && !string.equals("http://www.xbrl.org/2009/role/negatedTotalLabel")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean h(XbrlConcept xbrlConcept) {
        List<TaxonomySet> list;
        if (this.d == null) {
            return true;
        }
        if (this.B == null) {
            list = new ArrayList();
            TaxonomySet taxonomySet = this.d;
            while (taxonomySet != null) {
                TaxonomySet taxonomySet2;
                if (taxonomySet.getLabelRelationships().size() > 0) {
                    list.add(taxonomySet);
                }
                if ((taxonomySet2 = taxonomySet.getBaseTaxonomySet()) == null || taxonomySet2 == taxonomySet) break;
                taxonomySet = taxonomySet2;
            }
            this.B = list.toArray(new TaxonomySet[list.size()]);
        }
        if (xbrlConcept != null) {
            if (this.B.length <= 1) {
                list = xbrlConcept.getLabels(this.d);
                return list != null && list.size() > 0;
            }
            TaxonomySet[] taxonomySetArray = this.B;
            int n = this.B.length;
            int n2 = 0;
            while (n2 < n) {
                list = taxonomySetArray[n2];
                List list2 = xbrlConcept.getLabels(list);
                if (list2 != null && list2.size() > 0) {
                    for (Label label : list2) {
                        if (!label.getLang().startsWith("zh")) continue;
                        return true;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private void r() {
        if (this.dts == null) {
            return;
        }
        if (!this.getExtendMode().isRedefineMode()) {
            return;
        }
        boolean bl = false;
        RoleTypeCollection roleTypeCollection = this.dts.getRoleTypes();
        for (RoleType roleType : roleTypeCollection) {
            String string;
            String string2 = roleType.getRoleURI();
            int n = string2.lastIndexOf("/");
            if (n + 7 != string2.length()) continue;
            char c2 = string2.charAt(string2.length() - 1);
            if (c2 == '4' || c2 == '3') {
                string = String.valueOf(string2.substring(0, string2.length() - 1)) + '2';
                if (roleTypeCollection.getSingle(string) == null) {
                    this.sendMessage("26.2.2", roleType.getDefinitionText(), string2);
                }
                bl = bl || c2 == '3';
                continue;
            }
            if (c2 != '2' || roleTypeCollection.getSingle(string = String.valueOf(string2.substring(0, string2.length() - 1)) + '4') != null || roleTypeCollection.getSingle(string = String.valueOf(string2.substring(0, string2.length() - 1)) + '3') != null) continue;
            this.sendMessage("26.2.3", roleType.getDefinitionText(), string2);
        }
        if (!bl) {
            this.sendMessage("26.2.4");
        }
    }

    void a(String[] stringArray) {
        Object object;
        List list;
        Map.Entry entry;
        GenericMutable genericMutable2;
        HashSet<String> hashSet = new HashSet<String>();
        Collection collection = this.dts.getAllDRS().values();
        Collection collection2 = this.d.getAllDRS().values();
        HashMap<String, ArrayList<Object>> hashMap = new HashMap<String, ArrayList<Object>>();
        HashMap hashMap2 = new HashMap();
        for (GenericMutable genericMutable2 : this.d.getPresentationRelationships()) {
            RoleType roleType = this.d.getRoleTypes().getSingle(genericMutable2.getRoleURI());
            if (roleType == null || !((d)((Object)(entry = new d(roleType)))).a()) continue;
            list = (List)hashMap.get(((d)((Object)entry)).b);
            if (list == null) {
                list = new ArrayList<Object>();
                hashMap.put(((d)((Object)entry)).b, (ArrayList<Object>)list);
            }
            list.add(entry);
            list = (List)hashMap2.get(((d)((Object)entry)).c);
            if (list == null) {
                list = new ArrayList(4);
                hashMap2.put(((d)((Object)entry)).c, list);
            }
            list.add(entry);
        }
        genericMutable2 = new GenericMutable();
        for (XdtDRS xdtDRS : collection) {
            list = xdtDRS.getDirectHasHyperCubes().entrySet().iterator();
            while (list.hasNext()) {
                entry = list.next();
                object = ((XdtComponent)entry.getKey()).getConcept();
                if (object == null) continue;
                XdtCompiledHypercube[] xdtCompiledHypercubeArray = (XdtCompiledHypercube[])entry.getValue();
                int n = xdtCompiledHypercubeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string;
                    XdtCompiledHypercube xdtCompiledHypercube = xdtCompiledHypercubeArray[n2];
                    XbrlConcept xbrlConcept = xdtCompiledHypercube.getConcept();
                    CasRedefineRoleType casRedefineRoleType = this.g.get(xdtDRS.getRole());
                    if (casRedefineRoleType != null && (string = casRedefineRoleType.getCode1()) != null && string.length() == 6 && string.charAt(0) != '6') {
                        XdtCompiledHypercube xdtCompiledHypercube2;
                        Object object2;
                        Object object32;
                        String string2 = "000000".equals(casRedefineRoleType.getCode2()) ? "" : casRedefineRoleType.getCode2();
                        String string3 = null;
                        genericMutable2.value = "";
                        String string4 = null;
                        boolean bl = false;
                        for (Object object32 : collection2) {
                            if (bl) break;
                            object2 = object32.tryGetHypercubes((XbrlConcept)object);
                            if (object2 == null) continue;
                            XdtCompiledHypercube[] xdtCompiledHypercubeArray2 = object2;
                            int n3 = ((XdtCompiledHypercube[])object2).length;
                            int n4 = 0;
                            while (n4 < n3) {
                                xdtCompiledHypercube2 = xdtCompiledHypercubeArray2[n4];
                                if (xdtCompiledHypercube2.getConcept() == xbrlConcept && (string3 = this.a(string4 = object32.getRole(), (GenericMutable<String>)genericMutable2)).length() != 0 && string3.length() == string.length() && string3.equals(string) && StringUtils.equals((String)string2, (String)((String)genericMutable2.value))) {
                                    bl = true;
                                }
                                ++n4;
                            }
                        }
                        if (!bl && xdtCompiledHypercube.getDimensions().length == 1 && xdtCompiledHypercube.getDimensions()[0].getConcept() == this.c && (object32 = (List)hashMap2.get(string)) != null) {
                            object2 = object32.iterator();
                            while (object2.hasNext()) {
                                d d2 = (d)object2.next();
                                xdtCompiledHypercube2 = this.d.getPresentationRelationships(d2.e);
                                if (xdtCompiledHypercube2 == null || !xdtCompiledHypercube2.containValidTarget(object) || !StringUtils.equals((String)string2, (String)d2.d)) continue;
                                bl = true;
                                break;
                            }
                        }
                        if (!bl && string3 != null) {
                            hashSet.add(xdtDRS.getRole());
                            this.sendMessage("516", new Object[]{String.valueOf(this.d((XbrlConcept)object)) + " - " + this.d(xbrlConcept), this.a(string4, this.d), xdtDRS.getRole(), this.a(xdtDRS.getRole()), this.d(string)});
                        }
                    }
                    ++n2;
                }
            }
        }
        for (XdtDRS xdtDRS : this.dts.getPresentationRelationships()) {
            if (hashSet.contains(xdtDRS.getRoleURI()) || (entry = this.dts.getRoleTypes().getSingle(xdtDRS.getRoleURI())) == null || !((d)((Object)(list = new d((RoleType)entry, true)))).a() || (object = (List)hashMap.get(((d)((Object)list)).b)) == null || object.size() == 0) continue;
            boolean bl = false;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                d d3 = (d)iterator.next();
                if (!d3.c.equals(((d)((Object)list)).c)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            d d4 = (d)object.get(0);
            this.sendMessage("516", new Object[]{((d)((Object)list)).b, d4.e, ((d)((Object)list)).c, ((d)((Object)list)).e, d4.c});
        }
    }

    private void s() {
        List<Object> list;
        Object object;
        Object object2;
        if (this.d == null) {
            return;
        }
        if (!this.getExtendMode().isRedefineMode()) {
            return;
        }
        this.O();
        this.P();
        String[] stringArray = CasProcessor.getIndustry(this.d);
        if (stringArray != null && stringArray.length > 0) {
            this.a(stringArray);
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Collection collection = this.dts.getAllDRS().values();
        Collection collection2 = this.d.getAllDRS().values();
        HashMap<String, ArrayList<Object>> hashMap = new HashMap<String, ArrayList<Object>>();
        HashMap hashMap2 = new HashMap();
        for (RelationshipSet relationshipSet : this.d.getPresentationRelationships()) {
            object2 = this.d.getRoleTypes().getSingle(relationshipSet.getRoleURI());
            if (object2 == null || !((d)(object = new d((RoleType)object2))).a()) continue;
            list = (ArrayList<Object>)hashMap.get(((d)object).b);
            if (list == null) {
                list = new ArrayList<Object>();
                hashMap.put(((d)object).b, (ArrayList<Object>)list);
            }
            list.add(object);
            list = (List)hashMap2.get(((d)object).c);
            if (list == null) {
                list = new ArrayList(4);
                hashMap2.put(((d)object).c, list);
            }
            list.add(object);
        }
        for (RelationshipSet relationshipSet : collection) {
            object = relationshipSet.getDirectHasHyperCubes().entrySet().iterator();
            while (object.hasNext()) {
                object2 = (Map.Entry)object.next();
                list = ((XdtComponent)object2.getKey()).getConcept();
                if (list == null) continue;
                XdtCompiledHypercube[] xdtCompiledHypercubeArray = (XdtCompiledHypercube[])object2.getValue();
                int n = xdtCompiledHypercubeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string;
                    XdtCompiledHypercube xdtCompiledHypercube = xdtCompiledHypercubeArray[n2];
                    XbrlConcept xbrlConcept = xdtCompiledHypercube.getConcept();
                    CasRedefineRoleType casRedefineRoleType = this.g.get(relationshipSet.getRole());
                    if (casRedefineRoleType != null && (string = casRedefineRoleType.getCode1()) != null && string.length() == 6 && string.charAt(0) != '6') {
                        XdtCompiledHypercube xdtCompiledHypercube2;
                        Object object3;
                        Object object422;
                        String string2 = null;
                        String string3 = null;
                        boolean bl = false;
                        for (Object object422 : collection2) {
                            if (bl) break;
                            object3 = object422.tryGetHypercubes(list);
                            if (object3 == null) continue;
                            XdtCompiledHypercube[] xdtCompiledHypercubeArray2 = object3;
                            int n3 = ((XdtCompiledHypercube[])object3).length;
                            int n4 = 0;
                            while (n4 < n3) {
                                xdtCompiledHypercube2 = xdtCompiledHypercubeArray2[n4];
                                if (xdtCompiledHypercube2.getConcept() == xbrlConcept && (string2 = this.a(string3 = object422.getRole(), (GenericMutable<String>)null)).length() != 0 && string2.length() == string.length() && string2.equals(string)) {
                                    bl = true;
                                }
                                ++n4;
                            }
                        }
                        if (!bl && xdtCompiledHypercube.getDimensions().length == 1 && xdtCompiledHypercube.getDimensions()[0].getConcept() == this.c && (object422 = (List)hashMap2.get(string)) != null) {
                            object3 = object422.iterator();
                            while (object3.hasNext()) {
                                d d2 = (d)object3.next();
                                xdtCompiledHypercube2 = this.d.getPresentationRelationships(d2.e);
                                if (xdtCompiledHypercube2 == null || !xdtCompiledHypercube2.containValidTarget(list)) continue;
                                bl = true;
                                break;
                            }
                        }
                        if (!bl && string2 != null) {
                            hashSet.add(relationshipSet.getRole());
                            this.sendMessage("516", new Object[]{String.valueOf(this.d((XbrlConcept)list)) + " - " + this.d(xbrlConcept), this.a(string3, this.d), relationshipSet.getRole(), this.a(relationshipSet.getRole()), this.d(string)});
                        }
                    }
                    ++n2;
                }
            }
        }
        for (RelationshipSet relationshipSet : this.dts.getPresentationRelationships()) {
            if (hashSet.contains(relationshipSet.getRoleURI()) || (object2 = this.dts.getRoleTypes().getSingle(relationshipSet.getRoleURI())) == null || !((d)(object = new d((RoleType)object2, true))).a() || (list = (List)hashMap.get(((d)object).b)) == null || list.size() == 0) continue;
            boolean bl = false;
            for (d d3 : list) {
                if (!d3.c.equals(((d)object).c)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            d d4 = (d)list.get(0);
            this.sendMessage("516", new Object[]{((d)object).b, d4.e, ((d)object).c, ((d)object).e, d4.c});
        }
    }

    private void t() {
        if (this.d == null) {
            this.d = this.a(this.dts);
        }
        if (this.getExtendMode().isRedefineMode()) {
            RoleType[] roleTypeArray;
            TaxonomySet taxonomySet;
            RoleType[] roleTypeArray2;
            RoleTypeCollection roleTypeCollection = this.dts.getRoleTypes();
            for (String string : roleTypeCollection.getRoleURIs()) {
                roleTypeArray2 = roleTypeCollection.get(string);
                if (roleTypeCollection.get(string).length > 1) {
                    this.sendMessage("26.3.1", string, this.a(string));
                }
                if (this.d == null || !string.startsWith("http://xbrl.mof.gov.cn")) continue;
                taxonomySet = this.d;
                while (taxonomySet != null) {
                    roleTypeArray = taxonomySet.getRoleTypes().get(string);
                    if (roleTypeArray.length != 0 && this.a(roleTypeArray2, roleTypeArray)) {
                        this.sendMessage("26.3.3", string, this.a(string));
                    }
                    taxonomySet = taxonomySet.getBaseTaxonomySet();
                }
            }
            for (String string : roleTypeCollection.getRoleTypeIds()) {
                roleTypeArray2 = roleTypeCollection.getRoleTypeById(string);
                if (roleTypeCollection.getRoleTypeById(string).length > 1) {
                    this.sendMessage("26.3.2", string);
                }
                if (this.d == null) continue;
                taxonomySet = this.d;
                while (taxonomySet != null) {
                    roleTypeArray = taxonomySet.getRoleTypes().getRoleTypeById(string);
                    if (roleTypeArray.length > 0 && this.a(roleTypeArray2, roleTypeArray)) {
                        this.sendMessage("26.3.4", string);
                    }
                    taxonomySet = taxonomySet.getBaseTaxonomySet();
                }
            }
        }
    }

    private boolean a(RoleType[] roleTypeArray, RoleType[] roleTypeArray2) {
        RoleType[] roleTypeArray3 = roleTypeArray;
        int n = roleTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RoleType roleType = roleTypeArray3[n2];
            RoleType[] roleTypeArray4 = roleTypeArray2;
            int n3 = roleTypeArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String string;
                RoleType roleType2 = roleTypeArray4[n4];
                if (roleType == roleType2 || (string = roleType.getOwnerDocument().getBaseURI()) != null && string.equals(roleType2.getOwnerDocument().getBaseURI())) break;
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private void u() {
        if (this.d == null) {
            return;
        }
        RoleVersion roleVersion = RoleVersion.V2013;
        if (this.o != null && this.o.getYear() <= 2011) {
            roleVersion = RoleVersion.V2012;
        }
        if (this.getClass() == Cas2015Processor.class) {
            roleVersion = RoleVersion.V2015;
        }
        g g2 = new g(this, this.d, roleVersion);
        g2.a(CasProcessor.getIndustry(this.dts));
        g2.c();
        g2.b();
        this.g = g2.a();
        this.checkRoleURICode1(g2, this.g);
    }

    protected void checkRoleURICode1(g checker, Map<String, CasRedefineRoleType> redefine) {
    }

    static boolean c(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        try {
            return string.length() == string.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return true;
        }
    }

    public static String[] getIndustry(TaxonomySet dts) {
        Object[] objectArray = null;
        XbrlConcept xbrlConcept = dts.getConcept("cas:BusinessLicenseNumber");
        if (xbrlConcept != null) {
            XbrlSchema xbrlSchema = xbrlConcept.getSchema();
            String string = xbrlSchema.getTargetNamespace();
            XmlSchema[] xmlSchemaArray = dts.getSchemas();
            int n = xmlSchemaArray.length;
            int n2 = 0;
            while (n2 < n) {
                XmlSchema xmlSchema = xmlSchemaArray[n2];
                if (xmlSchema instanceof XbrlSchema && xmlSchema.getExternals() != null && XbrlHelper.isReadOnly((XmlSchemaObject)((XbrlSchema)xmlSchema)) && xmlSchema.getElements().size() != 0) {
                    Object object2;
                    boolean bl = false;
                    String string2 = xmlSchema.getTargetNamespace();
                    if (string2.startsWith("http://xbrl.mof.gov.cn/taxonomy") && (string2.endsWith("/bnk") || string2.endsWith("/ogi"))) {
                        bl = true;
                    }
                    for (Object object2 : xmlSchema.getExternals()) {
                        if (!(object2 instanceof XmlSchemaImport)) continue;
                        XmlSchemaImport xmlSchemaImport = (XmlSchemaImport)object2;
                        XmlSchema xmlSchema2 = object2.getSchema();
                        if (xmlSchema2 != xbrlSchema && !string.equals(xmlSchemaImport.getNamespace())) continue;
                        bl = true;
                        break;
                    }
                    if (bl && !StringUtils.isEmpty((String)(object2 = xmlSchema.getPrefixOfNamespace(xmlSchema.getTargetNamespace())))) {
                        objectArray = objectArray == null ? new String[]{object2} : (String[])ArrayUtil.append((Object[])objectArray, (Object)object2);
                    }
                }
                ++n2;
            }
        }
        return objectArray == null ? new String[]{} : objectArray;
    }

    String d(String string) {
        if (this.d == null) {
            return string;
        }
        for (RoleType roleType : this.d.getRoleTypes()) {
            if (!roleType.getRoleURI().endsWith(string)) continue;
            return roleType.getDefinitionText();
        }
        return string;
    }

    String b(String string, TaxonomySet[] taxonomySetArray) {
        String string2 = "/" + string + "/";
        TaxonomySet[] taxonomySetArray2 = taxonomySetArray;
        int n = taxonomySetArray.length;
        int n2 = 0;
        while (n2 < n) {
            TaxonomySet taxonomySet = taxonomySetArray2[n2];
            for (RoleType roleType : taxonomySet.getRoleTypes()) {
                if (!roleType.getRoleURI().endsWith(string) && !roleType.getRoleURI().contains(string2)) continue;
                return roleType.getDefinitionText();
            }
            ++n2;
        }
        return string;
    }

    String a(String string, GenericMutable<String> genericMutable) {
        int n;
        if (genericMutable != null) {
            genericMutable.value = "";
        }
        if ((n = string.lastIndexOf(45)) != -1) {
            int n2;
            String string2 = string.substring(n + 1);
            if (string2.length() == 7 && (n2 = string2.charAt(6)) >= 97 && n2 <= 122) {
                string2 = string2.substring(0, 6);
            }
            if (string2.length() > 12 && (n2 = string2.indexOf("/")) != -1) {
                char c2;
                String string3 = string2.substring(n2 + 1);
                if (string3.length() == 7 && (c2 = string3.charAt(6)) >= 'a' && c2 <= 'z') {
                    string3 = string3.substring(0, 6);
                }
                if (genericMutable != null) {
                    genericMutable.value = string3;
                }
                string2 = string2.substring(0, n2);
            }
            return string2;
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private void a(XbrlInstance xbrlInstance) {
        void var3_4;
        if (xbrlInstance == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        XdmNode xdmNode2 = xbrlInstance.getFirstNS();
        while (var3_4 != null) {
            hashSet.add(var3_4.getInnerText());
            XdmNode xdmNode = var3_4.getNextSibling();
        }
        for (QName qName : this.U) {
            if (hashSet.contains(qName.getNamespaceURI())) continue;
            this.sendMessage("1.1", qName.getNamespaceURI());
        }
        for (QName qName : this.facts.keySet()) {
            if (hashSet.contains(qName.getNamespaceURI())) continue;
            this.sendMessage("1.1", qName.getNamespaceURI());
        }
    }

    private void v() {
        if (this.facts == null || this.facts.size() == 0) {
            return;
        }
        BigDecimal bigDecimal = new BigDecimal(10000);
        for (List list : this.facts.values()) {
            String string;
            Fact fact;
            XbrlConcept xbrlConcept;
            if (list == null || list.size() == 0 || (xbrlConcept = (fact = (Fact)list.get(0)).getConcept()) == null) continue;
            if (xbrlConcept.isSharesItem()) {
                for (Fact fact2 : list) {
                    string = fact2.getInnerText().trim();
                    if (StringUtils.isEmpty((String)string)) continue;
                    try {
                        BigDecimal bigDecimal2 = new BigDecimal(string);
                        if (bigDecimal2.abs().compareTo(bigDecimal) != -1 || bigDecimal2.compareTo(BigDecimal.ZERO) == 0) continue;
                        this.sendMessage("552", new Object[]{fact2.getPrefixedName(), this.b(xbrlConcept), fact2.getContextRef(), string});
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                continue;
            }
            if (!QNameConstants.numPercentItemType.equals((Object)xbrlConcept.getSchemaTypeName())) continue;
            for (Fact fact2 : list) {
                string = fact2.getDecimals();
                if (StringUtils.isEmpty((String)string) || "INF".equals(string)) continue;
                boolean bl = false;
                try {
                    BigDecimal bigDecimal3 = new BigDecimal(string);
                    if (bigDecimal3.compareTo(BigDecimal.ZERO) == -1) {
                        bl = true;
                    }
                }
                catch (Throwable throwable) {
                    bl = true;
                }
                if (!bl) continue;
                this.sendMessage("554.1", new Object[]{this.d(xbrlConcept), xbrlConcept.getPrefixedName(), fact2.getContextRef(), fact2.getInnerText(), string});
            }
        }
    }

    private void w() {
        this.presentaionRS = this.dts.getPresentationRelationships();
        ArrayList<XbrlConcept> arrayList = new ArrayList<XbrlConcept>();
        for (RelationshipSet relationshipSet : this.presentaionRS) {
            Object object2;
            arrayList.clear();
            for (Object object2 : relationshipSet.getFromTargets()) {
                if (!(object2 instanceof XbrlConcept) || !((XbrlConcept)object2).isHypercube()) continue;
                arrayList.add((XbrlConcept)object2);
            }
            if (arrayList.size() == 0) continue;
            Object object3 = object2 = relationshipSet.getRoleURI();
            if (((String)object2).length() - ((String)object2).lastIndexOf("/") == 8) {
                object3 = ((String)object2).substring(0, ((String)object2).length() - 1);
            }
            List<RelationshipSet> list = this.e((String)object3);
            int n = arrayList.size() - 1;
            while (n > -1) {
                XbrlConcept xbrlConcept = (XbrlConcept)arrayList.get(n);
                boolean bl = false;
                for (RelationshipSet relationshipSet2 : list) {
                    if (!relationshipSet2.contains((Object)xbrlConcept)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    arrayList.remove(n);
                }
                --n;
            }
            if (arrayList.size() == 0) continue;
            for (XbrlConcept xbrlConcept : arrayList) {
                this.sendMessage("512", object2, xbrlConcept);
            }
        }
    }

    List<RelationshipSet> e(String string) {
        ArrayList<RelationshipSet> arrayList = new ArrayList<RelationshipSet>();
        for (RelationshipSet relationshipSet : this.r) {
            if (!CasProcessor.isPairURI(string, relationshipSet.getRoleURI())) continue;
            arrayList.add(relationshipSet);
        }
        return arrayList;
    }

    static String f(String string) {
        int n = string.lastIndexOf(47);
        if (string.length() - n == 7) {
            return string;
        }
        if (string.length() - n == 8) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private void x() {
        if (this.C == null) {
            this.C = new HashMap<String, List<String>>();
            for (RoleType roleType : this.dts.getRoleTypes()) {
                String string = roleType.getRoleURI();
                String string2 = CasProcessor.f(string);
                List<String> list = this.C.get(string2);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.C.put(string2, list);
                }
                list.add(string);
                this.C.put(string, list);
            }
        }
    }

    private List<RelationshipSet> k(String string) {
        this.x();
        List<String> list = this.C.get(string);
        ArrayList<RelationshipSet> arrayList = new ArrayList<RelationshipSet>();
        if (list != null) {
            for (String string2 : list) {
                RelationshipSet relationshipSet = this.dts.getPresentationRelationships(string2);
                if (relationshipSet == null || !CasProcessor.isPairURI(string, relationshipSet.getRoleURI())) continue;
                arrayList.add(relationshipSet);
            }
        }
        return arrayList;
    }

    public static final boolean isPairURI(String thisURI, String roleURI) {
        if (Math.abs(thisURI.length() - roleURI.length()) <= 1) {
            return thisURI.equals(roleURI) || thisURI.startsWith(roleURI) || roleURI.startsWith(thisURI);
        }
        return false;
    }

    private void y() {
        for (RelationshipSet relationshipSet : this.dts.getPresentationRelationships()) {
            XbrlConcept xbrlConcept;
            for (Object e2 : relationshipSet.getFromTargets()) {
                if (!(e2 instanceof XbrlConcept)) continue;
                xbrlConcept = (XbrlConcept)e2;
                if (!xbrlConcept.isAbstract()) {
                    for (Relationship relationship : relationshipSet.getChildren((Object)xbrlConcept)) {
                        XbrlConcept xbrlConcept2 = relationship.toConcept();
                        if (xbrlConcept2 == null || !xbrlConcept2.isAbstract() || relationshipSet.hasChildren((Object)xbrlConcept2)) continue;
                        this.sendMessage("508", new Object[]{xbrlConcept, xbrlConcept2, relationshipSet.getRoleURI(), this.m(relationship.arc().getOwnerDocument().getBaseURI())});
                    }
                    continue;
                }
                if (!xbrlConcept.isXdtItem() || relationshipSet.hasParent((Object)xbrlConcept) || relationshipSet.getEffectiveChildren((Object)xbrlConcept).size() == 0) continue;
                this.sendMessage("525", xbrlConcept.getPrefixedName(), this.a(relationshipSet.getRoleURI()), relationshipSet.getRoleURI());
            }
            for (Object e2 : relationshipSet.getToTargets()) {
                if (!(e2 instanceof XbrlConcept) || !(xbrlConcept = (XbrlConcept)e2).isXdtItem() || relationshipSet.hasChildren((Object)xbrlConcept)) continue;
                this.sendMessage("525", xbrlConcept.getPrefixedName(), this.a(relationshipSet.getRoleURI()), relationshipSet.getRoleURI());
            }
        }
    }

    private void a(XbrlConcept xbrlConcept, List<Fact> list) {
        List<Fact> list2;
        Object object;
        Object object2;
        if (list == null || list.size() < 2) {
            return;
        }
        this.D.clear();
        boolean bl = false;
        for (Fact object3 : list) {
            object2 = j.b.a(object3, this.getUniqueContext(object3.getContext()));
            object = this.D.get(object2);
            if (object != null) {
                if (object instanceof Fact) {
                    list2 = new ArrayList<Fact>();
                    list2.add((Fact)object);
                    list2.add(object3);
                    this.D.put((j.b)object2, list2);
                } else if (object instanceof List) {
                    list2 = (List)object;
                    list2.add(object3);
                }
                bl = true;
                continue;
            }
            this.D.put((j.b)object2, object3);
        }
        if (bl) {
            for (Object object3 : this.D.values()) {
                if (!(object3 instanceof List) || (object2 = (List)object3).size() <= 1) continue;
                object = new StringBuilder();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    String string;
                    list2 = (Fact)iterator.next();
                    if (((StringBuilder)object).length() != 0) {
                        ((StringBuilder)object).append(", ");
                    }
                    if ((string = list2.getInnerText()).length() < 50) {
                        ((StringBuilder)object).append(string);
                        continue;
                    }
                    ((StringBuilder)object).append(string.substring(0, 50)).append("...");
                }
                list2 = (Fact)object2.get(0);
                this.sendMessage("28.7.1", new Object[]{String.valueOf(list2.getPrefixedName()) + " - " + this.d(xbrlConcept), list2.getContextRef(), ((StringBuilder)object).toString()});
            }
        }
    }

    private void b(XbrlConcept xbrlConcept, List<Fact> list) {
        Object object;
        if (list == null || list.size() < 2) {
            return;
        }
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        block0: for (Fact object2 : list) {
            int list2 = 0;
            while (list2 < arrayList.size()) {
                ArrayList<Fact> arrayList2;
                object = arrayList.get(list2);
                if (object instanceof Fact) {
                    if (((Fact)object).isDuplicate(object2)) {
                        arrayList2 = new ArrayList<Fact>(2);
                        arrayList2.add((Fact)object);
                        arrayList2.add(object2);
                        arrayList.set(list2, arrayList2);
                        bl = true;
                        continue block0;
                    }
                } else if (object instanceof List && ((Fact)(arrayList2 = (ArrayList<Fact>)object).get(0)).isDuplicate(object2)) {
                    arrayList2.add(object2);
                    bl = true;
                    continue block0;
                }
                ++list2;
            }
            arrayList.add(object2);
        }
        if (bl) {
            for (Object object2 : arrayList) {
                List list2;
                if (!(object2 instanceof List) || (list2 = (List)object2).size() <= 1) continue;
                object = (Fact)list2.get(0);
                this.sendMessage("28.7.2", new Object[]{String.valueOf(object.getPrefixedName()) + " - " + this.d(xbrlConcept), this.a((Fact)object)});
            }
        }
    }

    private String a(Fact fact) {
        for (Fact fact2 : fact.getFacts()) {
            String string;
            if (fact2.isItem()) {
                return String.valueOf(fact2.getPrefixedName()) + " - " + this.d(fact2.getConcept()) + fact2.getInnerText();
            }
            if (!fact2.isTuple() || (string = this.a(fact2)) == null) continue;
            return string;
        }
        return null;
    }

    protected void checkDuplicateFacts() {
        try {
            if (this.dts == null || this.facts == null) {
                return;
            }
            for (Map.Entry entry : this.facts.entrySet()) {
                XbrlConcept xbrlConcept = this.dts.getConcept((QName)entry.getKey());
                if (xbrlConcept == null) continue;
                if (xbrlConcept.isItem()) {
                    this.a(xbrlConcept, (List)entry.getValue());
                    continue;
                }
                if (!xbrlConcept.isTuple()) continue;
                this.b(xbrlConcept, (List)entry.getValue());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void z() {
        for (Map.Entry<String, XbrlConcept> entry : this.F.entrySet()) {
            Object object;
            Object object2 = this.G.get(entry.getKey());
            if (object2 == null) continue;
            if (object2 instanceof XbrlConcept) {
                object = (XbrlConcept)object2;
                if (object == null || !this.h((XbrlConcept)object)) continue;
                this.sendMessage("18.2.1", new Object[]{entry.getValue(), this.m(((XbrlConcept)entry.getValue()).getSchema().getSourceURI()), object});
                continue;
            }
            Object[] objectArray = (Object[])object2;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = objectArray[n2];
                Object object3 = object;
                if (object3 != null && this.h((XbrlConcept)object3)) {
                    this.sendMessage("18.2.1", new Object[]{entry.getValue(), this.m(((XbrlConcept)entry.getValue()).getSchema().getSourceURI()), object3});
                }
                ++n2;
            }
        }
        if (this.V) {
            Map.Entry<String, XbrlConcept> entry;
            entry = new net.gbicc.xbrl.filing.a(this);
            ((net.gbicc.xbrl.filing.a)((Object)entry)).a = this.G;
            ((net.gbicc.xbrl.filing.a)((Object)entry)).b = this.F;
            ((net.gbicc.xbrl.filing.a)((Object)entry)).c = this.g;
            ((net.gbicc.xbrl.filing.a)((Object)entry)).e = this.d;
            if (this.presentaionRS == null) {
                this.presentaionRS = this.dts.getPresentationRelationships();
            }
            ((net.gbicc.xbrl.filing.a)((Object)entry)).d = this.presentaionRS;
            ((net.gbicc.xbrl.filing.a)((Object)entry)).a();
        }
        this.G.clear();
        this.F.clear();
    }

    private void A() {
        for (StandardLabelGroup standardLabelGroup : this.I.values()) {
            if (standardLabelGroup.size() <= 1) continue;
            String string = this.l(standardLabelGroup.getLang());
            String string2 = standardLabelGroup.getLabel();
            String string3 = standardLabelGroup.getConceptNames();
            this.sendMessage("20.4.1", string3, string, string2);
        }
    }

    private String l(String string) {
        if (string.startsWith("zh")) {
            return "\u4e2d\u6587";
        }
        if (string.startsWith("en")) {
            return "\u82f1\u6587";
        }
        return string;
    }

    private String a(XmlSchemaElement xmlSchemaElement, String string) {
        for (RelationshipSet relationshipSet : this.s) {
            for (Relationship relationship : relationshipSet.getChildren((Object)xmlSchemaElement)) {
                Label label;
                Object object;
                if (relationship.arc().getUse() != ArcUse.Optional || (object = relationship.toTarget()) == null || !(object instanceof Label) || !(label = (Label)object).getRole().equals(string) || !label.getLang().startsWith("zh")) continue;
                return label.getInnerText();
            }
        }
        return "";
    }

    private void a(String string, String string2) {
        if (string == null) {
            string = "";
        }
        FastByteArrayOutputStream fastByteArrayOutputStream = null;
        if (this.N == null) {
            this.N = new HashMap<String, FastByteArrayOutputStream>();
        }
        if ((fastByteArrayOutputStream = this.N.get(string)) == null) {
            fastByteArrayOutputStream = new FastByteArrayOutputStream();
            this.N.put(string, fastByteArrayOutputStream);
            if (string.endsWith("_ChgNameOrLabel.csv")) {
                this.a(string, "\u539f\u5143\u7d20\u540d,\u65b0\u5143\u7d20\u540d,\u82f1\u6587\u6807\u51c6\u6807\u7b7e\r\n");
            }
        }
        if (fastByteArrayOutputStream != null) {
            try {
                if (string2 != null) {
                    fastByteArrayOutputStream.write(string2.getBytes("GBK"));
                    if (!string2.endsWith("\n")) {
                        fastByteArrayOutputStream.write("\r\n".getBytes());
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static String getL3CName(String enStandardLabel, StringBuilder targetName) {
        return CasProcessor.getL3CName(enStandardLabel, targetName, null);
    }

    public static String getL3CName(String enStandardLabel, StringBuilder targetName, MutableInt singleCount) {
        targetName.setLength(0);
        String string = StringUtils.replaceEach((String)enStandardLabel, (String[])O, (String[])P);
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            char c2 = string.charAt(n3);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9') {
                ++n;
                if (bl) {
                    targetName.append(Character.toUpperCase(c2));
                    bl = false;
                } else {
                    targetName.append(c2);
                }
            } else if (c2 != '-' && c2 != '\u00ad' && c2 != '\'' && c2 != '\u2019') {
                if (n == 1) {
                    ++n2;
                }
                n = 0;
                bl = true;
            }
            ++n3;
        }
        if (singleCount != null) {
            singleCount.setValue(n2);
        }
        String string2 = targetName.toString();
        return string2;
    }

    public static String getL3CNameOld(String enStandardLabel, StringBuilder targetName) {
        targetName.setLength(0);
        String string = StringUtils.replaceEach((String)enStandardLabel, (String[])O, (String[])Q);
        boolean bl = true;
        int n = 0;
        while (n < string.length()) {
            char c2 = string.charAt(n);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9') {
                if (bl) {
                    targetName.append(Character.toUpperCase(c2));
                    bl = false;
                } else {
                    targetName.append(c2);
                }
            } else if (c2 != '-' && c2 != '\u00ad' && c2 != '\'' && c2 != '\u2019') {
                bl = true;
            }
            ++n;
        }
        String string2 = targetName.toString();
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private void a(TaxonomySet taxonomySet, XbrlConcept xbrlConcept) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        this.E.clear();
        if (this.J == null) {
            this.J = taxonomySet.getLabelRelationships();
        }
        this.K.clear();
        boolean bl2 = xbrlConcept.getSchema() == this.e;
        boolean bl3 = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        Object object7 = this.J.iterator();
        while (object7.hasNext()) {
            RelationshipSet object62 = object7.next();
            for (Object object4 : object62.getChildren((Object)xbrlConcept)) {
                if (object4.arc().getUse() != ArcUse.Optional || (object3 = object4.toTarget()) == null || !(object3 instanceof Label)) continue;
                object2 = (Label)object3;
                this.K.add((Label)object2);
                object = object2.getLang();
                bl = "http://www.xbrl.org/2003/role/label".equals(object2.getRole());
                bl3 |= bl;
                if (bl2 && bl && string == null && ((String)object).startsWith("en")) {
                    string = object2.getInnerText();
                    continue;
                }
                if (!bl && string3 == null && "http://www.xbrl.org/2003/role/documentation".equals(object2.getRole()) && ((String)object).startsWith("zh")) {
                    string3 = object2.getInnerText();
                    continue;
                }
                if (!bl || !((String)object).startsWith("zh")) continue;
                string2 = object2.getInnerText();
            }
        }
        if (bl2) {
            if (!(string3 == null || !xbrlConcept.isMonetaryItem() || xbrlConcept.getBalance() != null && xbrlConcept.getBalance() != BalanceType.None || string3.contains("\u6b63") || string3.contains("\u8d1f"))) {
                this.sendMessage("20.5.2.1", xbrlConcept.getPrefixedName(), string2);
            }
            if (!QNameConstants.nonnumDomainItemType.equals((Object)xbrlConcept.getSchemaTypeName())) {
                object7 = this.K.iterator();
                while (object7.hasNext()) {
                    Object object4;
                    Label label = (Label)object7.next();
                    if (!label.getLang().startsWith("en") || !PinyinUtils.isLabelContainPinyin((String)(object4 = label.getInnerText()), this.R)) continue;
                    this.sendMessage("205", String.valueOf(string2) + " " + xbrlConcept.getPrefixedName(), object4, this.R.value);
                }
            }
        }
        if (bl2 && string != null) {
            String string4 = CasProcessor.getL3CName(string, this.M, this.S);
            if (string4.compareTo(xbrlConcept.getName()) != 0 && ((String)(object7 = CasProcessor.getL3CNameOld(string, this.M))).compareTo(xbrlConcept.getName()) != 0) {
                boolean bl4 = this.W != null && this.W.containsKey(xbrlConcept.getName());
                this.sendMessage(bl4 ? "18.1.1.2" : "18.1.1.1", xbrlConcept.getPrefixedName(), string, string4);
                if (!bl4) {
                    this.a(String.valueOf(this.y) + "_ChgNameOrLabel.csv", String.valueOf(xbrlConcept.getName()) + "," + string4 + ",\"" + StringUtils.replace((String)string, (String)"\"", (String)"\"\"") + "\"\r\n");
                }
            }
            if (this.S.intValue() > 1) {
                boolean bl5;
                object7 = StringUtils.replaceEach(string, (String[])O, (String[])P);
                String[] stringArray = StringUtils.split((String)object7, (char)' ');
                boolean bl6 = false;
                int n = 0;
                while (n < stringArray.length - 1) {
                    if (stringArray[n].length() == 1 && stringArray[n + 1].length() == 1) {
                        bl5 = true;
                        break;
                    }
                    ++n;
                }
                if (bl5) {
                    this.sendMessage("18.1.1.3", this.d(xbrlConcept), xbrlConcept.getPrefixedName(), string);
                }
            }
        }
        if (!bl3 && this.K.size() != 0) {
            void var8_17;
            Object var8_16 = null;
            object7 = null;
            for (Label label : this.K) {
                if (label.getLang().startsWith("zh")) {
                    object7 = label.getInnerText();
                    break;
                }
                String string5 = label.getInnerText();
            }
            this.sendMessage("110", xbrlConcept.getPrefixedName(), object7 != null ? object7 : var8_17);
        } else if (bl3 && this.K.size() > 0) {
            for (Label label : this.K) {
                if (!"http://www.xbrl.org/2003/role/label".equals(label.getRole()) || !label.getLang().startsWith("zh")) continue;
                String string6 = label.getInnerText();
                if (string6.contains("\u671f\u521d") || string6.contains("\u671f\u672b") || string6.contains("\u5408\u8ba1") && !string6.contains("\u7ec4\u5408") || string6.contains("\u5c0f\u8ba1")) {
                    String string7;
                    if (xbrlConcept.isAbstract() || (string7 = this.c(xbrlConcept)) != null && string6.contains("\u671f\u521d") || string6.contains("\u671f\u672b") || string6.contains("\u5408\u8ba1") && !string6.contains("\u7ec4\u5408") || string6.contains("\u5c0f\u8ba1")) continue;
                    this.sendMessage("213", xbrlConcept.getPrefixedName(), string6);
                    continue;
                }
                if (string6.length() >= 5 || xbrlConcept.getSchema() != this.e) continue;
                if (string6.length() <= 3) {
                    if (string6.contains("\u5370\u82b1\u7a0e") || string6.contains("\u7a0e\u7387")) continue;
                    this.sendMessage("215", xbrlConcept.getPrefixedName(), string6);
                    continue;
                }
                if (!string6.contains("\u672c\u5e74") && !string6.contains("\u5176\u4e2d")) continue;
                this.sendMessage("215", xbrlConcept.getPrefixedName(), string6);
            }
        }
        if (this.K.size() > 0) {
            XcType xcType = this.a(xbrlConcept);
            if (!xcType.hasSuffix()) {
                XcType xcType2 = XcType.None;
            }
            boolean bl6 = true;
            String string8 = null;
            block8: for (Label label : this.K) {
                String[] stringArray;
                char c2;
                void var8_24;
                XcType xcType3;
                if (!this.a(label)) continue;
                string8 = label.getInnerText();
                object2 = label.getRole();
                object = label.getLang();
                if (object == null) {
                    object = "";
                }
                if ((xcType3 = XcType.getSuffixType(string8)) != var8_24) {
                    bl6 = false;
                    break;
                }
                if (!label.getLang().startsWith("en")) continue;
                if (string8.length() > 0 && (c2 = string8.charAt(0)) != Character.toUpperCase(c2)) {
                    this.sendMessage("219", new Object[]{xbrlConcept.getPrefixedName(), this.d(xbrlConcept), string8});
                }
                if (string8.length() == 0) {
                    this.sendMessage("20.2.1", xbrlConcept.getPrefixedName());
                    continue;
                }
                if (!bl2 && string8.equals(this.a(xbrlConcept, (String)object, (String)object2))) continue;
                String string9 = string8.toLowerCase();
                String[] stringArray2 = stringArray = StringUtils.split((String)string9, (String)" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string10 = stringArray2[n2];
                    if ("the".equals(string10) || "a".equals(string10) || "an".equals(string10)) {
                        this.sendMessage("20.2.2", new Object[]{xbrlConcept.getPrefixedName(), string8, string10});
                        continue block8;
                    }
                    ++n2;
                }
            }
            if (!bl6) {
                this.sendMessage("217", new Object[]{string8, xbrlConcept.getPrefixedName(), this.a(xbrlConcept, xbrlConcept.getSchemaTypeName()), this.a(xbrlConcept, xbrlConcept.getSubstitutionGroup()), xbrlConcept.isAbstract()});
            }
        }
        this.L.a();
        for (Label label : this.K) {
            void var11_50;
            this.L.a(label);
            String string11 = label.getRole();
            String string12 = label.getLang();
            if (string12 == null) {
                String string13 = "";
            }
            object3 = label.getInnerText();
            boolean bl7 = this.a(label);
            if (bl7) {
                if (((String)object3).length() > 0 && (((String)object3).charAt(0) == ' ' || ((String)object3).charAt(((String)object3).length() - 1) == ' ' || StringUtils.contains((String)object3, (String)"  "))) {
                    this.sendMessage("20.10.1", xbrlConcept.getPrefixedName(), object3);
                }
                int n = -1;
                if (var11_50.startsWith("en") && (n = StringUtils.indexOfAny((String)object3, (char[])l)) != -1 && (bl2 || !((String)object3).equals(this.a(xbrlConcept, (String)var11_50, string11)))) {
                    this.sendMessage("20.1.2", xbrlConcept.getPrefixedName(), object3, Character.valueOf(((String)object3).charAt(n)));
                }
                if ((n = StringUtils.indexOfAny((String)object3, (char[])k)) != -1) {
                    if (bl2 || !((String)object3).equals(this.a(xbrlConcept, (String)var11_50, string11))) {
                        this.sendMessage("20.1.1", xbrlConcept.getPrefixedName(), object3, Character.valueOf(((String)object3).charAt(n)));
                    }
                } else if (var11_50.startsWith("en")) {
                    bl = true;
                    try {
                        byte[] byArray = ((String)object3).getBytes("UTF-8");
                        if (byArray.length > ((String)object3).length()) {
                            bl = false;
                        }
                    }
                    catch (Throwable throwable) {
                        bl = false;
                    }
                    if (!bl) {
                        char c3 = ' ';
                        char[] cArray = ((String)object3).toCharArray();
                        int n3 = cArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            char c4 = cArray[n4];
                            if (c4 > '\u0100') {
                                c3 = c4;
                                break;
                            }
                            ++n4;
                        }
                        this.sendMessage("20.1.1", xbrlConcept.getPrefixedName(), object3, Character.valueOf(c3));
                    }
                }
                if ("http://www.xbrl.org/2003/role/verboseLabel".equals(string11)) {
                    String string14 = label.getInnerText();
                    String string15 = null;
                    for (Label label2 : this.K) {
                        if (!"http://www.xbrl.org/2003/role/label".equals(label2.getRole()) || !var11_50.equals(label2.getLang())) continue;
                        string15 = label2.getInnerText();
                        break;
                    }
                    if (string15 != null) {
                        boolean bl8;
                        boolean bl9 = bl8 = string14.length() >= string15.length();
                        if (bl8 && var11_50.startsWith("zh")) {
                            int n5 = 0;
                            while (n5 < string15.length()) {
                                char c5 = string15.charAt(n5);
                                if (-1 == string14.indexOf(c5)) {
                                    bl8 = false;
                                    break;
                                }
                                ++n5;
                            }
                        } else if (bl8) {
                            String[] stringArray;
                            String string16 = string14.toUpperCase();
                            String[] stringArray3 = stringArray = StringUtils.split((String)string15, (String)" ");
                            int n6 = stringArray.length;
                            int n7 = 0;
                            while (n7 < n6) {
                                String string17 = stringArray3[n7];
                                if (!string16.contains(string17.toUpperCase())) {
                                    bl8 = false;
                                    break;
                                }
                                ++n7;
                            }
                        }
                        if (!bl8) {
                            this.sendMessage("514", new Object[]{xbrlConcept.getPrefixedName(), var11_50, string14, string15});
                        }
                    }
                }
            }
            if ((object = this.E.get(string11)) == null) {
                object = new b();
                ((b)object).a = string11;
                this.E.put(string11, (b)object);
            }
            if (var11_50.startsWith("zh")) {
                ((b)object).b = label.getInnerText();
            } else if (var11_50.startsWith("en")) {
                ((b)object).c = label.getInnerText().trim();
                this.a(((b)object).c, xbrlConcept, (String)var11_50);
            }
            if (!"http://www.xbrl.org/2003/role/label".equals(string11)) continue;
            String string18 = label.getInnerText();
            this.H.set((String)var11_50, string18);
            StandardLabelGroup standardLabelGroup = this.I.get(this.H);
            if (standardLabelGroup != null) {
                standardLabelGroup.addConcept(xbrlConcept);
                continue;
            }
            standardLabelGroup = new StandardLabelGroup((String)var11_50, string18);
            standardLabelGroup.addConcept(xbrlConcept);
            this.I.put(standardLabelGroup, standardLabelGroup);
        }
        for (b b2 : this.E.values()) {
            String string19;
            if (b2.a() || b2.b()) continue;
            String string20 = string19 = b2.c == null ? "\u82f1\u6587" : "\u4e2d\u6587";
            if ("http://www.xbrl.org/2003/role/documentation".equals(b2.a)) continue;
            this.sendMessage("20.9.1", xbrlConcept.getPrefixedName(), b2.a, string19);
        }
        if (this.L.b()) {
            if (this.L.e) {
                this.sendMessage("20.3.1", new Object[]{xbrlConcept, this.d(xbrlConcept), "\u4e2d\u6587"});
            }
            if (this.L.f) {
                this.sendMessage("20.3.1", new Object[]{xbrlConcept, this.d(xbrlConcept), "\u82f1\u6587"});
            }
            if (this.L.a || this.L.b) {
                this.sendMessage("548", new Object[]{xbrlConcept, this.d(xbrlConcept), "\u4e2d\u6587"});
            }
            if (this.L.c || this.L.d) {
                this.sendMessage("548", new Object[]{xbrlConcept, this.d(xbrlConcept), "\u82f1\u6587"});
            }
        }
    }

    private void B() {
        if (this.calculationRS == null) {
            this.calculationRS = this.dts.getCalculationRelationships();
        }
        for (RelationshipSet relationshipSet : this.calculationRS) {
            for (Object e2 : relationshipSet.getFromTargets()) {
                String string;
                XbrlConcept xbrlConcept;
                if (!relationshipSet.hasEffectiveChildren(e2)) continue;
                XbrlConcept xbrlConcept2 = xbrlConcept = e2 instanceof XbrlConcept ? (XbrlConcept)e2 : null;
                if (xbrlConcept == null || (string = this.b(xbrlConcept)) == null || !string.contains("\u5408\u8ba1") && !string.contains("\u5c0f\u8ba1")) continue;
                boolean bl = this.g(xbrlConcept);
                if (!bl) {
                    this.sendMessage("20.6.1.1", xbrlConcept.getPrefixedName(), this.b(xbrlConcept));
                    continue;
                }
                List<RelationshipSet> list = this.k(relationshipSet.getRoleURI());
                if (list.size() == 0) continue;
                for (RelationshipSet relationshipSet2 : list) {
                    this.c(relationshipSet2, xbrlConcept);
                }
            }
        }
    }

    private void c(RelationshipSet relationshipSet, XbrlConcept xbrlConcept) {
        boolean bl = false;
        block0: for (Object e2 : relationshipSet.getParentTargets((Object)xbrlConcept)) {
            for (Relationship relationship : relationshipSet.getChildren(e2)) {
                String string;
                PresentationArc presentationArc;
                if (relationship.toTarget() != xbrlConcept || !relationship.isOptional()) continue;
                PresentationArc presentationArc2 = presentationArc = relationship.arc() instanceof PresentationArc ? (PresentationArc)relationship.arc() : null;
                if (presentationArc == null || StringUtils.isEmpty((String)(string = presentationArc.getPreferredLabel())) || !"http://www.xbrl.org/2003/role/totalLabel".equals(string) && !"http://www.xbrl.org/2009/role/negatedTotalLabel".equals(string)) continue;
                bl = true;
                continue block0;
            }
        }
        if (!bl) {
            this.sendMessage("20.6.2.1", xbrlConcept.getPrefixedName(), this.b(xbrlConcept), this.a(relationshipSet.getRoleURI()));
        }
    }

    private boolean a(Label label) {
        XbrlDocument xbrlDocument;
        return !this.extendMode.isReuseMode() || !(xbrlDocument = label.getOwnerDocument()).isReadOnly() || xbrlDocument.getBaseURI().startsWith("http://zip.local/");
    }

    private String a(XbrlConcept xbrlConcept, QName qName) {
        if (xbrlConcept == null || qName == null || qName.isEmpty()) {
            return "";
        }
        String string = xbrlConcept.getPrefixOfNamespace(qName.getNamespaceURI());
        return StringUtils.isEmpty((String)string) ? qName.getLocalPart() : String.valueOf(string) + ":" + qName.getLocalPart();
    }

    private void a(String string, XbrlConcept xbrlConcept, String string2) {
    }

    private void c(TaxonomySet taxonomySet) {
        for (Map.Entry entry : taxonomySet.getAllDRS().entrySet()) {
            XdtDRS xdtDRS = (XdtDRS)entry.getValue();
            if (!xdtDRS.hasHypercube()) continue;
            for (Map.Entry entry2 : xdtDRS.getDirectHasHyperCubes().entrySet()) {
                XdtCompiledHypercube[] xdtCompiledHypercubeArray = (XdtCompiledHypercube[])entry2.getValue();
                int n = xdtCompiledHypercubeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    XdtCompiledHypercube xdtCompiledHypercube = xdtCompiledHypercubeArray[n2];
                    if (xdtCompiledHypercube.getContextElement() != ContextElementType.Scenario) {
                        this.sendMessage("29.4.1", new Object[]{((XdtComponent)entry2.getKey()).getConcept(), xdtCompiledHypercube.getHypercube().getConcept(), entry.getKey(), xdtCompiledHypercube.getSourceURI()});
                    }
                    if (!xdtCompiledHypercube.isClosed()) {
                        this.sendMessage("521", new Object[]{this.a((String)entry.getKey()), this.d(xdtCompiledHypercube.getHypercube().getConcept())});
                    }
                    this.a(xdtCompiledHypercube, xdtDRS);
                    XdtDimension[] xdtDimensionArray = xdtCompiledHypercube.getDimensions();
                    int n3 = xdtDimensionArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String string2;
                        XdtDimension xdtDimension = xdtDimensionArray[n4];
                        if (xdtDimension.getChildSize() > 1) {
                            this.sendMessage("109", new Object[]{xdtCompiledHypercube.getConcept(), xdtDimension.getConcept(), entry.getKey(), this.m(xdtCompiledHypercube.getSourceURI()), ((XdtComponent)entry2.getKey()).getConcept()});
                        }
                        for (String string2 : xdtDimension.getMembers()) {
                            if (QNameConstants.nonnumDomainItemType.equals((Object)string2.getSchemaTypeName())) continue;
                            this.sendMessage("218", new Object[]{this.a(xdtDRS.getRole()), this.d(xdtCompiledHypercube.getConcept()), this.d(xdtDimension.getConcept()), String.valueOf(string2.getPrefixedName()) + " - " + this.d((XbrlConcept)string2)});
                        }
                        string2 = (String)entry.getKey();
                        for (XdtComponent xdtComponent : xdtDimension.getDomainMembers()) {
                            this.a(xdtComponent, string2, 0);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
    }

    private void a(XdtCompiledHypercube xdtCompiledHypercube, XdtDRS xdtDRS) {
        XbrlConcept xbrlConcept = xdtCompiledHypercube.getConcept();
        RelationshipSet relationshipSet = this.dts.getDefinitionRelationships(xdtDRS.getRole());
        if (relationshipSet == null) {
            return;
        }
        for (Object e2 : relationshipSet.getParentTargets((Object)xbrlConcept)) {
            for (Relationship relationship : relationshipSet.getChildren(e2)) {
                XbrlConcept xbrlConcept2;
                if (!relationship.isOptional() || !"http://xbrl.org/int/dim/arcrole/domain-member".equals(relationship.arcrole()) || (xbrlConcept2 = relationship.toConcept()) == null) continue;
                boolean bl = xbrlConcept2.getName().endsWith("LineItems");
                boolean bl2 = xbrlConcept2.isAbstract();
                if (bl && bl2) continue;
                if (bl2 && !bl) {
                    this.sendMessage("18.10.1", xbrlConcept2.getName(), this.b(xbrlConcept2), this.a(relationshipSet.getRoleURI()));
                }
                if (bl && !bl2) {
                    this.sendMessage("18.10.2", xbrlConcept2.getName(), this.b(xbrlConcept2));
                }
                if (!relationshipSet.hasChildren((Object)xbrlConcept2)) continue;
                this.sendMessage("18.10.3", xbrlConcept2.getName(), this.b(xbrlConcept2), this.a(relationshipSet.getRoleURI()));
            }
        }
    }

    private void a(XdtComponent xdtComponent, String string, int n) {
        String string22;
        if (n > 20) {
            return;
        }
        XbrlConcept xbrlConcept = xdtComponent.getConcept();
        if (xbrlConcept != null) {
            if (!xbrlConcept.getName().endsWith("Member")) {
                this.sendMessage("18.11.1", xbrlConcept.getName(), this.b(xbrlConcept), this.a(string));
            }
            if (!xbrlConcept.isAbstract()) {
                this.sendMessage("18.11.2", xbrlConcept.getName(), this.b(xbrlConcept), this.a(string));
            }
            if (!QNameConstants.nonnumDomainItemType.equals((Object)xbrlConcept.getSchemaTypeName())) {
                this.sendMessage("18.11.3", xbrlConcept.getName(), this.b(xbrlConcept), this.a(string));
            }
        }
        if (n > 0 && (string22 = this.b(xbrlConcept)) != null && string22.contains("\u5408\u8ba1")) {
            this.sendMessage("18.5", xbrlConcept.getPrefixedName(), string22, this.a(string));
        }
        for (String string22 : xdtComponent.getDomainMembers()) {
            this.a((XdtComponent)string22, string, n + 1);
        }
    }

    private XbrlSchema d(TaxonomySet taxonomySet) {
        XmlSchema xmlSchema;
        XbrlSchema xbrlSchema = null;
        if (!StringUtils.isEmpty((String)this.getExtendNamespaceURI()) && (xmlSchema = taxonomySet.getSchemas(this.getExtendNamespaceURI())) != null && ((XmlSchema[])xmlSchema).length == 1) {
            xbrlSchema = (XbrlSchema)xmlSchema[0];
            return xbrlSchema;
        }
        XmlSchema[] xmlSchemaArray = taxonomySet.getSchemas();
        int n = xmlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            String[] stringArray;
            xmlSchema = xmlSchemaArray[n2];
            String string2 = xmlSchema.getTargetNamespace();
            if (!StringUtils.isEmpty((String)string2) && string2.startsWith("http://") && !string2.startsWith("http://www.xbrl.org") && !string2.startsWith("http://xbrl.org") && !string2.startsWith("http://xbrl.mof.gov.cn/taxonomy/") && (stringArray = StringUtils.split((String)(string = string2.substring(7)), (char)'/')) != null && stringArray.length == 3 && "cas".equals(stringArray[1])) {
                try {
                    Date.parseDate((String)stringArray[2]);
                    if (xmlSchema instanceof XbrlSchema) {
                        xbrlSchema = (XbrlSchema)xmlSchema;
                        return xbrlSchema;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return null;
    }

    private List<QName> C() {
        Object object;
        ArrayList<QName> arrayList = null;
        TaxonomySet taxonomySet = this.d;
        String string = this.role130000URI;
        while (taxonomySet != null) {
            object = taxonomySet.getPresentationRelationships(string);
            if (object != null) {
                HashSet hashSet = new HashSet();
                object.getAllConcepts(hashSet);
                for (XbrlConcept xbrlConcept : hashSet) {
                    if (xbrlConcept.isAbstract()) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    if (arrayList.contains(xbrlConcept.getQName())) continue;
                    arrayList.add(xbrlConcept.getQName());
                }
                break;
            }
            taxonomySet = taxonomySet.getBaseTaxonomySet();
        }
        if (arrayList == null) {
            arrayList = new ArrayList<QName>();
            String[] stringArray = new String[]{"cas:DisclosureOfBasicInformationOfCompanyExplanatory", "ifrs:NameOfReportingEntityOrOtherMeansOfIdentification", "cas:ApprovingProvince", "cas:ApprovalDate", "cas:ApprovalNo", "cas:Sponsor", "cas:BusinessLicenseNumber", "cas:Industries", "cas:RemarkOfCompanyBasicInformation", "ifrs:StatementOfIFRSCompliance", "cas:StatementOfComplianceWithAccountingStandardForBusinessEnterprises"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = stringArray[n2];
                XbrlConcept xbrlConcept = this.dts.getConcept((String)object);
                if (xbrlConcept != null) {
                    arrayList.add(xbrlConcept.getQName());
                }
                ++n2;
            }
        }
        return arrayList;
    }

    @Override
    protected void processInstance(XbrlInstance instance) {
        Context context;
        XbrlConcept xbrlConcept4;
        XbrlConcept xbrlConcept22;
        Object object322;
        Object object;
        Object object622;
        if (instance == null) {
            return;
        }
        this.prepareInstance(instance);
        this.dts = instance.getOwnerDTS();
        if (this.dts == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object622 : instance.getContexts()) {
            String object52 = object622.getIdentifierValue();
            if (!StringUtils.isEmpty((String)object52)) {
                hashSet.add(object52);
            }
            if ("http://www.saic.gov.cn/".equals(object = object622.getIdentifierScheme())) continue;
            this.sendMessage("29.1.1", object622.getId(), object);
        }
        if (hashSet.size() > 1) {
            object622 = new StringBuilder();
            for (Object object322 : hashSet) {
                if (((StringBuilder)object622).length() != 0) {
                    ((StringBuilder)object622).append(", ");
                }
                ((StringBuilder)object622).append((String)object322);
            }
            this.sendMessage("519", hashSet.size(), ((StringBuilder)object622).toString());
            ((StringBuilder)object622).setLength(0);
            hashSet.clear();
        }
        hashSet = null;
        object622 = this.dts.getPresentationRelationships();
        object322 = this.dts.getAllDRS();
        this.U = new HashSet();
        for (Context context2 : instance.getContexts()) {
            this.U.addAll(context2.getDimensionContents().keySet());
            Iterator<Object> iterator = context2.getDimensionContents().values().iterator();
            while (iterator.hasNext()) {
                xbrlConcept4 = xbrlConcept22 = (XbrlConcept)iterator.next();
                int n = ((MemberElement[])xbrlConcept4).length;
                int n2 = 0;
                while (n2 < n) {
                    Object object2;
                    XbrlConcept xbrlConcept3 = xbrlConcept4[n2];
                    if (xbrlConcept3 instanceof ExplicitMember && (object2 = ((ExplicitMember)xbrlConcept3).getDimensionContent()) != null && !object2.isEmpty()) {
                        this.U.add((QName)object2);
                    }
                    ++n2;
                }
            }
        }
        this.T = new HashSet();
        this.T.addAll(this.facts.keySet());
        this.T.addAll(this.U);
        for (QName qName : this.T) {
            xbrlConcept22 = this.dts.getConcept(qName);
            if (xbrlConcept22 == null) {
                this.sendMessage("520", qName.toString());
                continue;
            }
            boolean bl = false;
            Object object33 = object622.iterator();
            while (object33.hasNext()) {
                RelationshipSet relationshipSet = (RelationshipSet)object33.next();
                if (!relationshipSet.contains((Object)xbrlConcept22)) continue;
                bl = true;
                break;
            }
            List list = (List)this.facts.get(qName);
            if (!bl) {
                if (list != null && list.size() > 0) {
                    for (Object object33 : list) {
                        xbrlConcept4 = this.sendMessage("21.1.1", xbrlConcept22, this.b(xbrlConcept22));
                        if (xbrlConcept4 == null) continue;
                        xbrlConcept4.setTag(object33);
                    }
                } else {
                    this.sendMessage("21.1.1", xbrlConcept22, this.b(xbrlConcept22));
                }
            }
            if (list == null) continue;
            object33 = this.d(xbrlConcept22);
            boolean bl2 = xbrlConcept22.isMonetaryItem() && ((String)object33).endsWith("\u539f\u5e01\u91d1\u989d");
            for (XbrlConcept xbrlConcept4 : list) {
                Unit unit;
                if (!xbrlConcept4.isItem() || (context = xbrlConcept4.getContext()) == null) continue;
                if (context.getDimensionContents().size() > 0) {
                    XdtDRS xdtDRS2;
                    boolean bl3 = false;
                    for (XdtDRS xdtDRS2 : object322.values()) {
                        if (!xdtDRS2.hasHypercubes(xbrlConcept22)) continue;
                        bl3 = true;
                        break;
                    }
                    if (!bl3 && (xdtDRS2 = this.sendMessage("501", xbrlConcept22, xbrlConcept4.getContextRef(), xbrlConcept4.toString())) != null) {
                        xdtDRS2.setTag((Object)xbrlConcept4);
                    }
                }
                if (!bl2 || (unit = xbrlConcept4.getUnit()) != null && !this.a(unit, a)) continue;
                this.sendMessage("531", object33, xbrlConcept4.getInnerText());
            }
        }
        XbrlSchema xbrlSchema = this.d(this.dts);
        if (xbrlSchema != null) {
            object = new HashSet();
            for (XbrlConcept xbrlConcept22 : instance.getContexts()) {
                for (Map.Entry entry : xbrlConcept22.getDimensionContents().entrySet()) {
                    ((HashSet)object).add((QName)entry.getKey());
                    context = (Context)entry.getValue();
                    int n = ((MemberElement[])context).length;
                    int n3 = 0;
                    while (n3 < n) {
                        Context context3 = context[n3];
                        if (context3.isExplicitMember()) {
                            try {
                                ((HashSet)object).add(context3.getQName());
                            }
                            catch (EvaluationException evaluationException) {
                                evaluationException.printStackTrace();
                            }
                        }
                        ++n3;
                    }
                }
            }
            for (XbrlConcept xbrlConcept22 : xbrlSchema.getElements().values()) {
                if (!(xbrlConcept22 instanceof XbrlConcept)) continue;
                XbrlConcept xbrlConcept5 = xbrlConcept22;
                QName qName = xbrlConcept5.getQName();
                if (xbrlConcept5.isDimension()) {
                    XbrlMessage xbrlMessage;
                    if (((HashSet)object).contains(qName) || this.dts.getDefaultDimensionMember(qName) != null || (xbrlMessage = this.sendMessage("16.6.2", xbrlConcept5, this.m(xbrlSchema.getSourceURI()))) == null) continue;
                    xbrlMessage.setTag((Object)xbrlConcept5);
                    continue;
                }
                if (xbrlConcept5.isAbstract() || !xbrlConcept5.isItem() && !xbrlConcept5.isTuple() || this.facts.containsKey(qName) || ((HashSet)object).contains(qName)) continue;
                if (!this.i(xbrlConcept5)) {
                    XbrlMessage xbrlMessage = this.sendMessage("16.6.2", xbrlConcept5, this.m(xbrlSchema.getSourceURI()));
                    if (xbrlMessage == null) continue;
                    xbrlMessage.setTag((Object)xbrlConcept5);
                    continue;
                }
                this.sendMessage("16.6.1", new Object[]{xbrlConcept5, this.d(xbrlConcept5), this.m(xbrlSchema.getSourceURI())});
            }
        }
        this.G();
        this.H();
        this.c(instance);
        this.b(instance);
        this.a(instance);
        this.e(instance);
        this.d(instance);
        this.a();
        this.b();
        this.checkDuplicateFacts();
        this.J();
        this.p();
        this.L();
        this.K();
        this.I();
        this.F();
        this.E();
        this.v();
        this.D();
        this.N();
    }

    private void D() {
        if (this.getExtendMode().isRedefineMode() && this.instance != null) {
            try {
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                if (this.facts == null) {
                    this.facts = this.instance.getAllFacts(true);
                }
                net.gbicc.xbrl.filing.c c2 = new net.gbicc.xbrl.filing.c(this, this.instance, this.facts);
                boolean bl = this.getOptions().getBoolean("level24CrossCheck");
                c2.a(bl, this.o);
                stopWatch.split();
                System.out.println("checkLevelData: " + stopWatch.toSplitString() + " mode:" + (bl ? "full" : "fast"));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void E() {
        if (this.instance == null) {
            return;
        }
        List list = this.getHandlerContext().getCalcDetails();
        if (list != null && list.size() > 0) {
            e e2 = new e(this, list);
            e2.a();
        }
    }

    private void F() {
        if (this.instance == null) {
            return;
        }
        XdmNode xdmNode = this.instance.getFirstNS();
        while (xdmNode != null) {
            XmlSchema[] xmlSchemaArray;
            XdmNSAttribute xdmNSAttribute;
            String string;
            String string2 = xdmNode.getInnerText();
            if (xdmNode instanceof XdmNSAttribute && !"xmlns".equals(string = (xdmNSAttribute = (XdmNSAttribute)xdmNode).getLocalName()) && (xmlSchemaArray = this.dts.getSchemas(string2)) != null && xmlSchemaArray.length > 0) {
                XmlSchema[] xmlSchemaArray2 = xmlSchemaArray;
                int n = xmlSchemaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    XmlSchema xmlSchema = xmlSchemaArray2[n2];
                    String string3 = xmlSchema.getPrefixOfNamespace(string2);
                    if (!StringUtils.isEmpty((String)string3) && !string3.equals(string)) {
                        this.sendMessage("40", string3, string);
                    }
                    ++n2;
                }
            }
            xdmNode = xdmNode.getNextSibling();
        }
    }

    private void G() {
        net.gbicc.xbrl.filing.b b2 = new net.gbicc.xbrl.filing.b(this, this.instance, (XbrlSchema)this.e);
        if (this.o == null) {
            this.e();
        }
        b2.a(this.o.toString(), this.facts, this._equalContexts.values());
    }

    private void H() {
        List<QName> list = this.C();
        if (list != null) {
            for (QName qName : list) {
                XbrlConcept xbrlConcept;
                List list2 = (List)this.facts.get(qName);
                if (list2 != null && list2.size() != 0 || (xbrlConcept = this.dts.getConcept(qName)) == null) continue;
                String string = this.b(xbrlConcept);
                if (StringUtils.isEmpty((String)string)) {
                    string = this.a(xbrlConcept, this.d);
                }
                this.sendMessage("28.1.1", xbrlConcept.getPrefixedName(), string);
            }
        }
    }

    private void I() {
        if (this.instance != null) {
            this.e();
            f f2 = new f(this.instance, this, this._equalContexts.values(), this.facts);
            f2.a(this.o);
        }
    }

    private void J() {
        if (this._equalContexts != null) {
            HashSet<List> hashSet = null;
            for (List list : this._equalContexts.values()) {
                if (list.size() <= 1) continue;
                if (hashSet == null) {
                    hashSet = new HashSet<List>();
                }
                if (hashSet.contains(list)) continue;
                hashSet.add(list);
                StringBuilder stringBuilder = new StringBuilder();
                int n = 0;
                while (n < list.size() && n < 5) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(((Context)list.get(n)).getId());
                    ++n;
                }
                this.sendMessage("29.3.2", list.size() - 1, stringBuilder.toString());
            }
        }
    }

    private void b(XbrlInstance xbrlInstance) {
        if (xbrlInstance == null) {
            return;
        }
        String string = xbrlInstance.getOwnerDocument().getXmlEncoding();
        if (!"UTF-8".equalsIgnoreCase(string)) {
            this.sendMessage("5.2");
        }
        TaxonomySet taxonomySet = xbrlInstance.getOwnerDTS();
        IXbrlDocument[] iXbrlDocumentArray = taxonomySet.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray[n2];
            String string2 = iXbrlDocument.getBaseURI();
            if (!(iXbrlDocument.isReadOnly() && !string2.startsWith("http://zip.local/") || "UTF-8".equalsIgnoreCase(iXbrlDocument.getXmlEncoding()))) {
                this.sendMessage("5.1", StringUtils.removeStart((String)string2, (String)"http://zip.local/"));
            }
            ++n2;
        }
    }

    private void c(XbrlInstance xbrlInstance) {
        if (xbrlInstance != null && !"xbrl".equals(xbrlInstance.getLocalName())) {
            this.sendMessage("4.1", xbrlInstance.getLocalName());
        }
    }

    private void d(XbrlInstance xbrlInstance) {
        if (xbrlInstance == null) {
            return;
        }
        HashSet hashSet = new HashSet(xbrlInstance.getUnits());
        block0: for (List list : this.facts.values()) {
            for (Fact fact : list) {
                Unit unit = fact.getUnit();
                if (unit == null) continue;
                hashSet.remove(unit);
                if (hashSet.isEmpty()) break block0;
            }
        }
        if (hashSet.size() > 0) {
            for (List list : hashSet) {
                this.sendMessage("29.5.1", list.getId());
            }
        }
    }

    private void e(XbrlInstance xbrlInstance) {
        if (xbrlInstance == null) {
            return;
        }
        HashSet hashSet = new HashSet(xbrlInstance.getContexts());
        block0: for (List list : this.facts.values()) {
            for (Fact fact : list) {
                Context context = fact.getContext();
                if (context == null) continue;
                hashSet.remove(context);
                if (hashSet.isEmpty()) break block0;
            }
        }
        if (hashSet.size() > 0) {
            for (List list : hashSet) {
                this.sendMessage("29.3.1", list.getId());
            }
        }
    }

    private void K() {
        if (this.facts == null || this.facts.size() == 0) {
            return;
        }
        HashSet hashSet = new HashSet();
        MutableInteger mutableInteger = new MutableInteger();
        for (RelationshipSet relationshipSet : this.dts.getPresentationRelationships()) {
            hashSet.clear();
            relationshipSet.getAllTargets(hashSet);
            boolean bl = false;
            boolean bl2 = false;
            Fact fact = null;
            Fact fact2 = null;
            block1: for (Object e2 : hashSet) {
                List list;
                XbrlConcept xbrlConcept;
                if (!(e2 instanceof XbrlConcept) || !(xbrlConcept = (XbrlConcept)e2).isMonetaryItem() || (list = (List)this.facts.get(xbrlConcept.getQName())) == null || list.size() == 0) continue;
                for (Fact fact3 : list) {
                    String string = fact3.getDecimals();
                    if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !Int32.tryParse((String)string, (MutableInteger)mutableInteger) || mutableInteger.intValue() < 0 || mutableInteger.intValue() == 2 || "0".equals(fact3.getInnerText())) continue;
                    bl = true;
                    fact = fact3;
                    if (mutableInteger.intValue() != 0) {
                        bl2 = true;
                        fact2 = fact3;
                    }
                    if (bl2 && bl) break block1;
                }
            }
            if (bl2) {
                this.sendMessage("544", new Object[]{this.a(relationshipSet.getRoleURI()), fact2 == null ? "" : String.valueOf(this.d(fact2.getConcept())) + " " + fact2, relationshipSet.getRoleURI()});
                continue;
            }
            if (!bl) continue;
            this.sendMessage("542", new Object[]{this.a(relationshipSet.getRoleURI()), fact == null ? "" : String.valueOf(this.d(fact.getConcept())) + " " + fact, relationshipSet.getRoleURI()});
        }
    }

    private void L() {
        if (this.facts == null || this.facts.size() == 0) {
            return;
        }
        HashSet hashSet = new HashSet();
        MutableInteger mutableInteger = new MutableInteger();
        for (RelationshipSet relationshipSet : this.dts.getPresentationRelationships()) {
            hashSet.clear();
            relationshipSet.getAllTargets(hashSet);
            Fact[] factArray = new Fact[4];
            int[] nArray = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
            boolean bl = false;
            for (Object e2 : hashSet) {
                List list;
                int n;
                XbrlConcept xbrlConcept;
                if (!(e2 instanceof XbrlConcept) || (xbrlConcept = (XbrlConcept)e2).isAbstract() || xbrlConcept.isNonNumeric() || (n = CasProcessor.getConceptDataType(xbrlConcept)) == -1 || (list = (List)this.facts.get(xbrlConcept.getQName())) == null || list.size() == 0) continue;
                int n2 = Integer.MAX_VALUE;
                int n3 = Integer.MAX_VALUE;
                bl = true;
                Fact fact = null;
                for (Fact fact2 : list) {
                    String string = fact2.getDecimals();
                    if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !Int32.tryParse((String)string, (MutableInteger)mutableInteger)) continue;
                    if (n2 == Integer.MAX_VALUE || n2 > mutableInteger.intValue()) {
                        n2 = mutableInteger.intValue();
                        fact = fact2;
                    }
                    if (n3 != Integer.MAX_VALUE && n3 >= mutableInteger.intValue()) continue;
                    n3 = mutableInteger.intValue();
                }
                if (n2 != Integer.MAX_VALUE && (nArray[n] == Integer.MAX_VALUE || nArray[n] > n2)) {
                    nArray[n] = n2;
                    factArray[n / 2] = fact;
                }
                if (n3 == Integer.MAX_VALUE || nArray[n + 1] != Integer.MAX_VALUE && nArray[n + 1] >= n3) continue;
                nArray[n + 1] = n3;
            }
            if (!bl) continue;
            int n = 0;
            while (n < 4) {
                if (nArray[n * 2] != nArray[n * 2 + 1]) {
                    Fact fact = factArray[n];
                    this.sendMessage("541", new Object[]{this.a(relationshipSet.getRoleURI()), Type_Names[n], nArray[n * 2], nArray[n * 2 + 1], relationshipSet.getRoleURI(), fact != null ? this.d(fact.getConcept()) : "", fact});
                }
                ++n;
            }
        }
    }

    public static int getConceptDataType(XbrlConcept c2) {
        if (c2 == null || !c2.isNumeric()) {
            return -1;
        }
        if (c2.isMonetaryItem()) {
            return 0;
        }
        QName qName = c2.getSchemaTypeName();
        if (qName != null) {
            if (QNameConstants.numPercentItemType.equals((Object)qName)) {
                return 4;
            }
            if (QNameConstants.numPerShareItemType.equals((Object)qName)) {
                return 6;
            }
        }
        return 2;
    }

    private boolean a(Unit unit, QName qName) {
        if (unit == null || qName == null) {
            return false;
        }
        if (unit.getDenominatorMeasures().length > 0) {
            return false;
        }
        QName[] qNameArray = unit.getNumeratorMeasures();
        return qNameArray.length == 1 && qName.equals(qNameArray[0]);
    }

    private boolean i(XbrlConcept xbrlConcept) {
        if (this.presentaionRS == null) {
            this.presentaionRS = this.dts.getPresentationRelationships();
        }
        for (RelationshipSet relationshipSet : this.presentaionRS) {
            if (!relationshipSet.hasChildren((Object)xbrlConcept)) continue;
            return true;
        }
        return false;
    }

    private String m(String string) {
        if (string != null) {
            if (string.contains("%")) {
                string = HttpUtility.urlDecode((String)string);
            }
            if (string.startsWith("http://zip.local/")) {
                return string.substring("http://zip.local/".length());
            }
        }
        return string;
    }

    public String getExtendNamespaceURI() {
        if (StringUtils.isEmpty((String)this.x) && this.instance != null) {
            XdmNode xdmNode = this.instance.getFirstChild();
            while (xdmNode != null) {
                IXbrlDocument iXbrlDocument;
                SchemaRef schemaRef;
                URI uRI;
                if (xdmNode instanceof SchemaRef && (uRI = (schemaRef = (SchemaRef)xdmNode).getDiscoveredUri((Node)this.instance)) != null && (iXbrlDocument = this.dts.getDocument(uRI)) != null && iXbrlDocument instanceof XbrlSchema) {
                    XbrlSchema xbrlSchema = (XbrlSchema)iXbrlDocument;
                    this.x = xbrlSchema.getTargetNamespace();
                    return this.x;
                }
                xdmNode = xdmNode.getNextSibling();
            }
        }
        return this.x;
    }

    public void setExtendNamespaceURI(String _extendNamespaceURI) {
        this.x = _extendNamespaceURI;
    }

    private String a(XmlSchemaElement xmlSchemaElement) {
        for (RelationshipSet relationshipSet : this.i) {
            for (Relationship relationship : relationshipSet.getChildren((Object)xmlSchemaElement)) {
                Label label;
                Object object;
                if (relationship.arc().getUse() != ArcUse.Optional || (object = relationship.toTarget()) == null || !(object instanceof Label) || !(label = (Label)object).getLang().startsWith("zh") || !label.getRole().equals("http://www.xbrl.org/2003/role/label")) continue;
                return label.getInnerText().trim();
            }
        }
        return null;
    }

    private void M() {
        Object object;
        String string2;
        if (this.e == null) {
            this.e = this.d(this.dts);
        }
        if (this.e == null) {
            return;
        }
        if (this.dts.getPreviousTaxonomySet() == null) {
            this.sendMessage("553");
            return;
        }
        this.h = this.dts.getPreviousTaxonomySet();
        this.i = this.h.getLabelRelationships();
        XbrlSchema xbrlSchema = this.d(this.h);
        if (xbrlSchema == null) {
            return;
        }
        this.W = new HashMap<String, XbrlConcept>();
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (String string2 : xbrlSchema.getElements().values()) {
            this.W.put(string2.getName(), (XbrlConcept)string2);
            String string3 = this.a((XmlSchemaElement)string2);
            if (string3 == null) continue;
            hashMap.put(string3, string2);
            object = this.n(string3);
            if (object == string3) continue;
            hashMap.put(string3, string2);
        }
        string2 = xbrlSchema.getTargetNamespace();
        for (XmlSchemaElement xmlSchemaElement : this.e.getElements().values()) {
            String string4;
            String string5;
            object = IQName.create((String)xmlSchemaElement.getName(), (String)string2);
            XmlSchemaElement xmlSchemaElement2 = (XmlSchemaElement)xbrlSchema.getElements().get(object);
            if (xmlSchemaElement2 != null || (string5 = this.a(xmlSchemaElement, "http://www.xbrl.org/2003/role/label")) == null) continue;
            xmlSchemaElement2 = (XmlSchemaElement)hashMap.get(string5);
            if (xmlSchemaElement2 == null && (string4 = this.n(string5)) != string5) {
                xmlSchemaElement2 = (XmlSchemaElement)hashMap.get(string4);
            }
            if (xmlSchemaElement2 == null || xmlSchemaElement2.getName().equals(xmlSchemaElement.getName())) continue;
            this.sendMessage("18.1.2", string5, xmlSchemaElement2.getName(), xmlSchemaElement.getName());
        }
    }

    private String n(String string) {
        boolean bl = false;
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c2 = string.charAt(n2);
            if (ArrayUtils.indexOf((char[])X, (char)c2, (int)0) == -1) {
                stringBuffer.append(c2);
            }
            ++n2;
        }
        if (bl) {
            return stringBuffer.toString();
        }
        return string;
    }

    private void N() {
        if (this.instance == null) {
            return;
        }
        if (this.facts == null) {
            this.facts = this.instance.getAllFacts(true);
        }
        for (Map.Entry entry : this.facts.entrySet()) {
            XbrlConcept xbrlConcept = this.dts.getConcept((QName)entry.getKey());
            if (xbrlConcept == null || !xbrlConcept.isNumeric()) continue;
            boolean bl = xbrlConcept.isMonetaryItem();
            QName qName = xbrlConcept.getSchemaTypeName();
            block3: for (Fact fact : (List)entry.getValue()) {
                String string;
                String string2 = fact.getUnitRef();
                if (bl) {
                    if (!this.isValidMonetaryUnit(string2)) {
                        this.sendMessage("556.1", fact.toString(), string2, this.d(xbrlConcept));
                    }
                } else if (QNameConstants.numPercentItemType.equals((Object)qName)) {
                    if (!this.isValidPureUnit(string2)) {
                        this.sendMessage("556.2", fact.toString(), string2, this.d(xbrlConcept));
                    }
                } else if (QNameConstants.numPerShareItemType.equals((Object)qName) && !this.isValidPerShareUnit(string2)) {
                    this.sendMessage("556.3", fact.toString(), string2, this.d(xbrlConcept));
                }
                if (StringUtils.isEmpty((String)(string = fact.getDecimals())) || "INF".equals(string)) continue;
                try {
                    int n;
                    int n2 = Integer.parseInt(string);
                    String string3 = fact.getInnerText().trim();
                    int n3 = string3.indexOf(46);
                    if (n3 == -1) {
                        n3 = string3.length();
                    }
                    if ((n = n3 + n2) >= string3.length() - 1) continue;
                    int n4 = n;
                    while (n4 < string3.length()) {
                        char c2;
                        if (n4 >= 0 && (c2 = string3.charAt(n4)) != '0' && c2 != '.' && Character.isDigit(c2)) {
                            this.sendMessage("557.1", new Object[]{this.d(xbrlConcept), fact.getPrefixedName(), fact.getContextRef(), string3, string});
                            continue block3;
                        }
                        ++n4;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void O() {
        try {
            if (this.instance == null) {
                return;
            }
            try {
                this.Y = new ProcessContext(this.dts);
                if (this.facts == null) {
                    this.facts = this.instance.getFacts(true);
                }
                ArrayList<QName> arrayList = new ArrayList<QName>();
                ArrayList<QName> arrayList2 = new ArrayList<QName>();
                for (XdtDRS xdtDRS : this.dts.getAllDRS().values()) {
                    arrayList.clear();
                    Collection collection = xdtDRS.getAllPrimaryItems();
                    for (XdtCompiledHypercube[] xdtCompiledHypercubeArray : collection) {
                        arrayList.add(xdtCompiledHypercubeArray.getQName());
                    }
                    Iterator<Object> iterator = xdtDRS.getDirectHasHyperCubes().values().iterator();
                    while (iterator.hasNext()) {
                        XdtCompiledHypercube[] xdtCompiledHypercubeArray;
                        XdtCompiledHypercube[] xdtCompiledHypercubeArray2 = xdtCompiledHypercubeArray = (XdtCompiledHypercube[])iterator.next();
                        int n = xdtCompiledHypercubeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            XdtCompiledHypercube xdtCompiledHypercube = xdtCompiledHypercubeArray2[n2];
                            XdtDimension[] xdtDimensionArray = xdtCompiledHypercube.getDimensions();
                            int n3 = xdtDimensionArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                XdtDimension xdtDimension = xdtDimensionArray[n4];
                                arrayList2.clear();
                                arrayList2.addAll(xdtDimension.getEffectiveMembers());
                                if (arrayList2.size() != 0) {
                                    XbrlConcept xbrlConcept;
                                    XdtCompiledMember xdtCompiledMember;
                                    QName qName;
                                    int n5 = arrayList2.size() - 1;
                                    while (n5 > -1) {
                                        qName = (QName)arrayList2.get(n5);
                                        xdtCompiledMember = xdtDimension.getCompiledMember(this.dts.getConcept(qName));
                                        if (xdtCompiledMember != null && xdtCompiledMember.getChildren().size() > 0) {
                                            arrayList2.remove(n5);
                                        }
                                        --n5;
                                    }
                                    QName qName2 = xdtDimension.getConcept().getQName();
                                    qName = this.dts.getDefaultDimensionMember(qName2);
                                    if (qName != null) {
                                        arrayList2.remove(qName);
                                    }
                                    this.a(xdtDRS, arrayList, qName2, arrayList2);
                                    if (arrayList2.size() > 0 && (xbrlConcept = this.dts.getConcept((QName)(xdtCompiledMember = (QName)arrayList2.get(0)))) != null) {
                                        int n6;
                                        Object object2;
                                        String string;
                                        int n7;
                                        String string2 = xdtDRS.getRole();
                                        if (!StringUtils.isEmpty((String)string2) && (n7 = string2.lastIndexOf("/")) != -1 && (string = string2.substring(n7 + 1)).length() == 7) {
                                            string2 = string2.substring(0, string2.length());
                                        }
                                        List<RelationshipSet> list = this.k(string2);
                                        string = "";
                                        for (Object object2 : list) {
                                            if (!object2.contains((Object)xdtDimension.getConcept()) || !object2.contains((Object)xbrlConcept)) continue;
                                            string = object2.getRoleURI();
                                            break;
                                        }
                                        string2 = xdtDRS.getRole();
                                        if (!StringUtils.isEmpty((String)xdtDRS.getRole()) && (n6 = string2.lastIndexOf("/")) != -1) {
                                            string2 = string2.substring(n6 + 1);
                                        }
                                        object2 = String.valueOf(this.d(xdtDimension.getConcept())) + "->" + this.d(xbrlConcept);
                                        this.sendMessage("563.2", string2, string, object2);
                                    }
                                }
                                ++n4;
                            }
                            ++n2;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        finally {
            this.Y = null;
        }
    }

    private List<QName> a(XdtDRS xdtDRS, List<QName> list, QName qName, List<QName> list2) {
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            List list3;
            QName qName2 = list.get(n);
            if (qName2 != null && (list3 = (List)this.facts.get(qName2)) != null) {
                int n3 = 0;
                while (n3 < list3.size()) {
                    MemberElement[] memberElementArray;
                    Fact fact = (Fact)list3.get(n3);
                    Context context = fact.getContext();
                    if (context != null && xdtDRS.isDimensionalValid(fact, this.Y, null) && (memberElementArray = (MemberElement[])context.getDimensionContents().get(qName)) != null && memberElementArray.length != 0) {
                        int n4 = 0;
                        while (n4 < memberElementArray.length) {
                            ExplicitMember explicitMember;
                            QName qName3;
                            MemberElement memberElement = memberElementArray[n4];
                            if (memberElement instanceof ExplicitMember && (qName3 = (explicitMember = (ExplicitMember)memberElement).getDimensionContent()) != null) {
                                list2.remove(qName3);
                                if (list2.size() == 0) {
                                    return list2;
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n3;
                }
            }
            ++n;
        }
        return list2;
    }

    private void P() {
        try {
            for (RoleType roleType : this.dts.getRoleTypes()) {
                for (UsedOn usedOn : roleType.getUsedOns()) {
                    try {
                        QName qName = usedOn.getQName();
                        RelationshipSet relationshipSet = null;
                        boolean bl = true;
                        if (QNameConstants.presentationLink.equals((Object)qName)) {
                            relationshipSet = this.dts.getPresentationRelationships(roleType.getRoleURI());
                        } else if (QNameConstants.calculationLink.equals((Object)qName)) {
                            relationshipSet = this.dts.getRelationshipSet((QName)QNameConstants.calculationLink, roleType.getRoleURI());
                        } else if (QNameConstants.definitionLink.equals((Object)qName)) {
                            relationshipSet = this.dts.getDefinitionRelationships(roleType.getRoleURI());
                        } else if (QNameConstants.labelLink.equals((Object)qName)) {
                            relationshipSet = this.dts.getRelationshipSet((QName)QNameConstants.labelLink, roleType.getRoleURI());
                        } else if (QNameConstants.referenceLink.equals((Object)qName)) {
                            relationshipSet = this.dts.getRelationshipSet((QName)QNameConstants.referenceLink, roleType.getRoleURI());
                        } else {
                            bl = false;
                        }
                        if (!bl || relationshipSet != null) continue;
                        this.sendMessage("563.1", roleType.getRoleURI(), usedOn.getInnerText());
                    }
                    catch (Throwable throwable) {
                        this.sendMessage("563.3", roleType.getRoleURI(), usedOn.getInnerText());
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected int getVersion() {
        return 2013;
    }

    class a {
        boolean a;
        boolean b;
        boolean c;
        boolean d;
        boolean e;
        boolean f;
        Set<String> g = new HashSet<String>();
        Set<String> h = new HashSet<String>();
        Set<String> i = new HashSet<String>();
        Set<String> j = new HashSet<String>();
        Set<String> k = new HashSet<String>();
        Set<String> l = new HashSet<String>();

        a() {
        }

        void a() {
            this.a = false;
            this.b = false;
            this.c = false;
            this.d = false;
            this.e = false;
            this.f = false;
            this.g.clear();
            this.h.clear();
            this.i.clear();
            this.j.clear();
            this.k.clear();
            this.l.clear();
        }

        boolean b() {
            return this.a || this.b || this.c || this.d || this.e || this.f;
        }

        void a(Label label) {
            String string = label.getLang();
            String string2 = label.getRole();
            boolean bl = !Label.isNegatedLabel((String)string2);
            String string3 = label.getInnerText();
            if (string.startsWith("zh")) {
                if (this.k.contains(string2)) {
                    this.e = true;
                } else {
                    this.k.add(string2);
                }
                if (bl) {
                    if (this.g.contains(string3)) {
                        this.a = true;
                    } else {
                        this.g.add(string3);
                    }
                } else if (this.h.contains(string3)) {
                    this.b = true;
                } else {
                    this.h.add(string3);
                }
            } else if (string.startsWith("en")) {
                if (this.l.contains(string2)) {
                    this.f = true;
                } else {
                    this.l.add(string2);
                }
                if (bl) {
                    if (this.i.contains(string3)) {
                        this.c = true;
                    } else {
                        this.i.add(string3);
                    }
                } else if (this.j.contains(string3)) {
                    this.d = true;
                } else {
                    this.j.add(string3);
                }
            }
        }
    }

    static class b {
        String a;
        String b;
        String c;

        b() {
        }

        public boolean a() {
            return this.b == null && this.c == null;
        }

        public boolean b() {
            return this.b != null && this.c != null;
        }
    }

    static class c {
        private String a;
        private LinkbaseRef b;
        private Linkbase c;

        c() {
        }
    }

    class d {
        RoleType a;
        String b;
        String c;
        String d = "";
        String e;

        public boolean a() {
            return this.b != null && this.c != null;
        }

        d(RoleType roleType) {
            this.a = roleType;
            this.e = roleType.getRoleURI();
            this.b = roleType.getDefinitionText();
            int n = this.b.indexOf(93);
            if (n != -1) {
                this.b = this.b.substring(n + 1).trim();
            }
            if ((n = roleType.getRoleURI().lastIndexOf(45)) != -1) {
                this.c = roleType.getRoleURI().substring(n + 1);
                n = this.c.indexOf(47);
                if (n != -1) {
                    this.d = this.c.substring(n + 1);
                    this.c = this.c.substring(0, n);
                }
            }
        }

        d(RoleType roleType, boolean bl) {
            CasRedefineRoleType casRedefineRoleType;
            this.a = roleType;
            this.e = roleType.getRoleURI();
            this.b = roleType.getDefinitionText();
            int n = this.b.indexOf(93);
            if (n != -1) {
                this.b = this.b.substring(n + 1).trim();
            }
            if ((casRedefineRoleType = CasProcessor.this.g.get(this.e)) != null) {
                this.c = casRedefineRoleType.getCode1();
            } else {
                n = this.e.lastIndexOf(47);
                if (n != -1) {
                    this.d = this.e.substring(n + 1);
                    int n2 = this.e.lastIndexOf(47, n - 1);
                    if (n2 != -1) {
                        this.c = this.e.substring(n2 + 1, n);
                    }
                }
            }
        }
    }

    public static class RoleTypeRule {
        public String markText;
        public String markText2;
        private char a;

        public char getMarkChar() {
            return this.a;
        }

        RoleTypeRule(char markChar, String markText) {
            this.a = markChar;
            this.markText = markText;
            this.markText2 = String.valueOf(markText) + " - ";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum XcType {
        None,
        Concept,
        NonNumericItem,
        NumericItem,
        AbstractItem("Abstract", " [abstract]"),
        Table("Table", " [table]"),
        Axis("Axis", " [axis]"),
        LineItems("LineItems", " [line items]"),
        DomainItem("Member", " [member]"),
        Explanatory("Explanatory", " [text block]");

        private final String labelSuffix;
        private final String nameSuffix;
        private final boolean hasSuffix;

        private XcType() {
            this.nameSuffix = null;
            this.labelSuffix = null;
            this.hasSuffix = false;
        }

        public static XcType getSuffixType(String label) {
            int n;
            if (StringUtils.isEmpty((String)label)) {
                return None;
            }
            if (label.charAt(label.length() - 1) == ']' && (n = label.lastIndexOf(91)) != -1) {
                String string = label.substring(n + 1, label.length() - 1);
                if ("member".equals(string)) {
                    return DomainItem;
                }
                if ("axis".equals(string)) {
                    return Axis;
                }
                if ("table".equals(string)) {
                    return Table;
                }
                if ("line items".equals(string)) {
                    return LineItems;
                }
                if ("abstract".equals(string)) {
                    return AbstractItem;
                }
                if ("text block".equals(string)) {
                    return Explanatory;
                }
            }
            return None;
        }

        public String getLabelSuffix() {
            return this.labelSuffix;
        }

        public String getNameSuffix() {
            return this.nameSuffix;
        }

        public boolean hasSuffix() {
            return this.hasSuffix;
        }

        private XcType(String nameSuffix, String labelSuffix) {
            this.nameSuffix = nameSuffix;
            this.labelSuffix = labelSuffix;
            this.hasSuffix = this.labelSuffix != null;
        }
    }
}

