/*
 * Decompiled with CFR 0.152.
 */
package net.gbicc.xbrl.filing;

import net.gbicc.xbrl.filing.Cas2015Processor;
import net.gbicc.xbrl.filing.CasProcessor;
import net.gbicc.xbrl.filing.IFilingProcessor;
import net.gbicc.xbrl.filing.SasacProcessor;
import net.gbicc.xbrl.filing.i;
import net.gbicc.xbrl.filing.j;
import net.gbicc.xbrl.filing.k;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DisclosureSystemType {
    NONE("", true),
    CAS("\u8d22\u653f\u90e8", true),
    CAS2015("\u8d22\u653f\u90e82015", true),
    CSRC("\u4e2d\u56fd\u8bc1\u76d1\u4f1a", true),
    IFRS("IFRS", true),
    US_SEC_EFM("\u7f8e\u56fd\u8bc1\u76d1\u4f1a", false),
    CBRC("\u94f6\u76d1\u4f1a", false),
    SASAC("\u56fd\u8d44\u59d4", false);

    private String _value;
    private boolean _intValue;

    private DisclosureSystemType(String value, boolean intValue) {
        this._value = value;
        this._intValue = intValue;
    }

    public String getCaption() {
        return this._value;
    }

    public boolean isImplemented() {
        return this._intValue;
    }

    public static final DisclosureSystemType tryParse(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return NONE;
        }
        try {
            DisclosureSystemType disclosureSystemType = DisclosureSystemType.valueOf(name);
            return disclosureSystemType;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            try {
                DisclosureSystemType[] disclosureSystemTypeArray = (DisclosureSystemType[])DisclosureSystemType.class.getEnumConstants();
                if (disclosureSystemTypeArray != null) {
                    name = name.toUpperCase();
                    DisclosureSystemType[] disclosureSystemTypeArray2 = disclosureSystemTypeArray;
                    int n = disclosureSystemTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DisclosureSystemType disclosureSystemType = disclosureSystemTypeArray2[n2];
                        if (disclosureSystemType.name().toUpperCase().equals(name)) {
                            return disclosureSystemType;
                        }
                        ++n2;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                illegalArgumentException2.printStackTrace();
            }
        }
        return NONE;
    }

    public IFilingProcessor createProcessor() {
        if (this == CAS) {
            return new CasProcessor(this);
        }
        if (this == US_SEC_EFM) {
            return new i(this);
        }
        if (this == IFRS) {
            return new k(this);
        }
        if (this == CBRC) {
            return new CasProcessor(this);
        }
        if (this == SASAC) {
            return new SasacProcessor(this);
        }
        if (this == CAS2015) {
            return new Cas2015Processor(this);
        }
        return new j(this);
    }
}

