/*
 * Decompiled with CFR 0.152.
 */
package net.gbicc.xbrl.filing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.gbicc.xbrl.core.ArcUse;
import net.gbicc.xbrl.core.Context;
import net.gbicc.xbrl.core.Fact;
import net.gbicc.xbrl.core.IXbrlDocument;
import net.gbicc.xbrl.core.Label;
import net.gbicc.xbrl.core.PeriodType;
import net.gbicc.xbrl.core.ProcessContext;
import net.gbicc.xbrl.core.QNameConstants;
import net.gbicc.xbrl.core.Relationship;
import net.gbicc.xbrl.core.RelationshipSet;
import net.gbicc.xbrl.core.RoleType;
import net.gbicc.xbrl.core.SchemaRef;
import net.gbicc.xbrl.core.TaxonomySet;
import net.gbicc.xbrl.core.Unit;
import net.gbicc.xbrl.core.XbrlConcept;
import net.gbicc.xbrl.core.XbrlHelper;
import net.gbicc.xbrl.core.XbrlInstance;
import net.gbicc.xbrl.core.XbrlLoader;
import net.gbicc.xbrl.core.XbrlSchema;
import net.gbicc.xbrl.core.dimension.ExplicitMember;
import net.gbicc.xbrl.core.dimension.MemberElement;
import net.gbicc.xbrl.core.dimension.XdtDRS;
import net.gbicc.xbrl.filing.DisclosureSystemType;
import net.gbicc.xbrl.filing.j;
import net.gbicc.xbrl.filing.l;
import net.gbicc.xbrl.filing.m;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.mutable.MutableInt;
import system.io.FastByteArrayOutputStream;
import system.io.IOHelper;
import system.lang.Int32;
import system.lang.MutableInteger;
import system.qizx.api.EvaluationException;
import system.qizx.api.Node;
import system.qizx.api.QName;
import system.qizx.api.util.time.Date;
import system.qizx.api.util.time.DateTime;
import system.qizx.api.util.time.DateTimeBase;
import system.qizx.api.util.time.DateTimeException;
import system.qizx.xdm.IQName;
import system.qizx.xdm.XdmNSAttribute;
import system.qizx.xdm.XdmNode;
import system.web.HttpUtility;
import system.xml.schema.XmlSchema;
import system.xml.schema.XmlSchemaImport;
import system.xml.schema.XmlSchemaObject;
import system.xmlmind.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SasacProcessor
extends j {
    static final QName a = IQName.get((String)"http://www.xbrl.org/2003/iso4217", (String)"CNY");
    private static final char[] d = "?|><:*+\\;=.&!@#{}".toCharArray();
    private Date e;
    private Map<XbrlConcept, String> f = new HashMap<XbrlConcept, String>();
    private Map<XbrlConcept, String> g = new HashMap<XbrlConcept, String>();
    private Collection<RelationshipSet> h;
    private TaxonomySet i;
    XmlSchema b;
    private String j;
    private ProcessContext k;
    private Collection<RelationshipSet> l;
    static final Pattern c = Pattern.compile("http://([A-Za-z0-9|-]+.)+.[com|com.cn|cn|net|org|biz]+/cas/(?:[0-9]{1,4}(?<!^0?0?0?0))-(?:0?[1-9]|1[0-2])-(?:0?[1-9]|1[0-9]|2[0-8]|(?:(?<=-(?:0?[13578]|1[02])-)(?:29|3[01]))|(?:(?<=-(?:0?[469]|11)-)(?:29|30))|(?:(?<=(?:(?:[0-9]{0,2}(?!0?0)(?:[02468]?(?<![13579])[048]|[13579][26]))|(?:(?:[02468]?[048]|[13579][26])00))-0?2-)(?:29)))");
    public static final RoleTypeRule[] rules = new RoleTypeRule[]{new RoleTypeRule('1', "Statements"), new RoleTypeRule('2', "Notes"), new RoleTypeRule('3', "Policies"), new RoleTypeRule('4', "Details")};
    private Map<j.b, Object> m = new HashMap<j.b, Object>();
    private StringBuilder n = new StringBuilder();
    private Map<String, FastByteArrayOutputStream> o;
    private static final String[] p = new String[]{"[text block]", "-", "_", ",", "\uff0c", ".", "\u3002"};
    private static final String[] q = new String[]{"Explanatory", "", " ", " ", " ", " ", " "};
    private static final String[] r = new String[]{"Explanatory", " ", " ", " ", " ", " ", " "};
    private HashSet<QName> s;
    private HashSet<QName> t;
    public static final String[] Type_Names = new String[]{"\u8d27\u5e01", "\u6570\u503c", "\u767e\u5206\u6570", "\u6bcf\u80a1\u6536\u76ca\u578b"};
    public static final int Type_Text = -1;
    public static final int Type_Money = 0;
    public static final int Type_Dec = 2;
    public static final int Type_Percent = 4;
    public static final int Type_PerShare = 6;

    public SasacProcessor(DisclosureSystemType type) {
        super(type);
        this.catalog = "Sasacfiling";
    }

    private TaxonomySet a(TaxonomySet taxonomySet) {
        String string;
        TaxonomySet taxonomySet2 = taxonomySet.getBaseTaxonomySet();
        if (taxonomySet2 == null) {
            XmlSchema[] xmlSchemaArray = taxonomySet.getSchemas();
            int n = xmlSchemaArray.length;
            int n2 = 0;
            while (n2 < n) {
                string = xmlSchemaArray[n2];
                String string2 = string.getTargetNamespace();
                if (string2 != null && string2.startsWith("http://xbrl.mof.gov.cn/taxonomy/") && string.getXmlSchemaSet() != this.dts) {
                    TaxonomySet taxonomySet3;
                    TaxonomySet taxonomySet4 = taxonomySet3 = string.getXmlSchemaSet() instanceof TaxonomySet ? (TaxonomySet)string.getXmlSchemaSet() : null;
                    if (taxonomySet3 != null && taxonomySet3.getEntryFile() != null && taxonomySet3.getEntryFile().startsWith("http://xbrl.mof.gov.cn/taxonomy/")) {
                        taxonomySet2 = taxonomySet3;
                        break;
                    }
                }
                ++n2;
            }
        }
        if (taxonomySet2 == null) {
            string = "http://xbrl.mof.gov.cn/taxonomy/2010-09-30/cas_entry_point_2010-09-30.xsd";
            XbrlLoader xbrlLoader = XbrlLoader.create((TaxonomySet)taxonomySet);
            xbrlLoader.load(string);
            taxonomySet2 = xbrlLoader.getActiveDTS();
        }
        if (taxonomySet.getSchemas("http://xbrl.mof.gov.cn/taxonomy/2011-11-30/cas/ogi").length > 0) {
            string = "http://xbrl.mof.gov.cn/taxonomy/2011-11-30/cas/ogi/cas_ogi_entry_point_2011-11-30.xsd";
            if (!string.equals(taxonomySet2.getEntryFile())) {
                XbrlLoader xbrlLoader = XbrlLoader.create((TaxonomySet)taxonomySet);
                xbrlLoader.load(string);
                taxonomySet2 = xbrlLoader.getActiveDTS();
            }
        } else if (taxonomySet.getSchemas("http://xbrl.mof.gov.cn/taxonomy/2012-11-30/cas/bnk").length > 0 && !(string = "http://xbrl.mof.gov.cn/taxonomy/2012-11-30/cas/bnk/bnk_entry_point_2012-11-30.xsd").equals(taxonomySet2.getEntryFile())) {
            XbrlLoader xbrlLoader = XbrlLoader.create((TaxonomySet)taxonomySet);
            xbrlLoader.load(string);
            taxonomySet2 = xbrlLoader.getActiveDTS();
        }
        return taxonomySet2;
    }

    String a(XbrlConcept xbrlConcept) {
        if (xbrlConcept == null) {
            return "";
        }
        String string = this.f.get(xbrlConcept);
        if (string != null) {
            return string;
        }
        if (this.l == null && this.dts != null) {
            this.l = this.dts.getLabelRelationships();
        }
        for (RelationshipSet relationshipSet : this.l) {
            for (Relationship relationship : relationshipSet.getChildren((Object)xbrlConcept)) {
                Label label;
                Object object;
                if (relationship.arc().getUse() != ArcUse.Optional || (object = relationship.toTarget()) == null || !(object instanceof Label) || !(label = (Label)object).getLang().startsWith("zh") || !label.getRole().equals("http://www.xbrl.org/2003/role/label")) continue;
                string = label.getInnerText().trim();
                this.f.put(xbrlConcept, string);
                return string;
            }
        }
        return "";
    }

    String a(String string) {
        RoleType[] roleTypeArray = this.dts.getRoleTypes().get(string);
        if (roleTypeArray != null && roleTypeArray.length > 0) {
            RoleType roleType = roleTypeArray[0];
            return roleType.getDefinitionText();
        }
        return string;
    }

    private String b(String string) {
        DateTime dateTime = null;
        String string2 = null;
        XbrlConcept xbrlConcept = this.dts.getConcept(string);
        if (xbrlConcept != null) {
            boolean bl = xbrlConcept.getPeriodType() == PeriodType.Duration;
            List list = (List)this.facts.get(xbrlConcept.getQName());
            if (list != null) {
                for (Fact fact : list) {
                    Context context = fact.getContext();
                    if (context == null || context.getDimensionContents().size() != 0) continue;
                    try {
                        DateTime dateTime2;
                        DateTime dateTime3 = dateTime2 = bl ? context.getPeriod().getEndDateElement().getDateTime() : context.getPeriod().getInstantElement().getDateTime();
                        if (dateTime == null) {
                            dateTime = dateTime2;
                            string2 = bl ? context.getPeriod().getEndDateElement().getInnerText().trim() : context.getPeriod().getInstantElement().getInnerText();
                            continue;
                        }
                        if (dateTime2.compareTo((DateTimeBase)dateTime) <= 0) continue;
                        dateTime = dateTime2;
                        string2 = bl ? context.getPeriod().getEndDateElement().getInnerText().trim() : context.getPeriod().getInstantElement().getInnerText();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        }
        return string2;
    }

    private void a() {
        int n;
        String string;
        if (this.e == null && this.instance != null && this.facts != null) {
            string = this.b("ifrs:NameOfReportingEntityOrOtherMeansOfIdentification");
            if (string == null && (string = this.b("cas:BusinessLicenseNumber")) == null) {
                string = this.b("ifrs:Assets");
            }
            if (string != null) {
                try {
                    this.e = Date.parseDate((String)string);
                }
                catch (DateTimeException dateTimeException) {
                    dateTimeException.printStackTrace();
                }
            }
        }
        if (this.e == null && this.b != null && (string = this.b.getTargetNamespace()) != null && (n = string.lastIndexOf(47)) != -1) {
            String string2 = string.substring(n + 1);
            try {
                this.e = Date.parseDate((String)string2);
            }
            catch (DateTimeException dateTimeException) {
                dateTimeException.printStackTrace();
            }
        }
    }

    @Override
    public void process(TaxonomySet dts) {
        if (dts == null) {
            return;
        }
        this.dts = dts;
        this.l = dts.getLabelRelationships();
        this.k = new ProcessContext(dts);
        this.k.getHandlerContext().getOptions().isValidateManual();
        this.i = this.a(dts);
        if (this.instance != null) {
            this.prepareInstance(this.instance);
        }
    }

    @Override
    protected void clear() {
        if (this.o != null) {
            String string = SystemUtils.IS_OS_WINDOWS ? "C:\\xbrl\\report" : "/opt/xbrl/report";
            File file = new File(string);
            if (file.exists()) {
                for (Map.Entry<String, FastByteArrayOutputStream> entry : this.o.entrySet()) {
                    File file2 = new File(file, entry.getKey());
                    try {
                        IOHelper.saveAsFile((InputStream)entry.getValue().getInputStream(), (String)file2.getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        entry.getValue().close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            this.o.clear();
            this.o = null;
        }
    }

    private void b() {
    }

    private String a(XbrlConcept xbrlConcept, TaxonomySet taxonomySet) {
        if (xbrlConcept != null) {
            String string = null;
            TaxonomySet taxonomySet2 = taxonomySet;
            while (taxonomySet2 != null) {
                List list = xbrlConcept.getLabels(taxonomySet2);
                for (Label label : list) {
                    if (!"http://www.xbrl.org/2003/role/label".equals(label.getRole())) continue;
                    if (label.getLang().startsWith("zh")) {
                        return label.getInnerText();
                    }
                    string = label.getInnerText();
                }
                taxonomySet2 = taxonomySet2.getBaseTaxonomySet();
            }
            return string == null ? "" : string;
        }
        return "";
    }

    public static String[] getIndustry(TaxonomySet dts) {
        Object[] objectArray = null;
        XbrlConcept xbrlConcept = dts.getConcept("cas:BusinessLicenseNumber");
        if (xbrlConcept != null) {
            XbrlSchema xbrlSchema = xbrlConcept.getSchema();
            String string = xbrlSchema.getTargetNamespace();
            XmlSchema[] xmlSchemaArray = dts.getSchemas();
            int n = xmlSchemaArray.length;
            int n2 = 0;
            while (n2 < n) {
                XmlSchema xmlSchema = xmlSchemaArray[n2];
                if (xmlSchema instanceof XbrlSchema && xmlSchema.getExternals() != null && XbrlHelper.isReadOnly((XmlSchemaObject)((XbrlSchema)xmlSchema)) && xmlSchema.getElements().size() != 0) {
                    Object object2;
                    boolean bl = false;
                    for (Object object2 : xmlSchema.getExternals()) {
                        if (!(object2 instanceof XmlSchemaImport)) continue;
                        XmlSchemaImport xmlSchemaImport = (XmlSchemaImport)object2;
                        XmlSchema xmlSchema2 = object2.getSchema();
                        if (xmlSchema2 != xbrlSchema && !string.equals(xmlSchemaImport.getNamespace())) continue;
                        bl = true;
                        break;
                    }
                    if (bl && !StringUtils.isEmpty((String)(object2 = xmlSchema.getPrefixOfNamespace(xmlSchema.getTargetNamespace())))) {
                        objectArray = objectArray == null ? new String[]{object2} : (String[])ArrayUtil.append((Object[])objectArray, (Object)object2);
                    }
                }
                ++n2;
            }
        }
        return objectArray == null ? new String[]{} : objectArray;
    }

    /*
     * WARNING - void declaration
     */
    private void a(XbrlInstance xbrlInstance) {
        void var3_4;
        if (xbrlInstance == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        XdmNode xdmNode2 = xbrlInstance.getFirstNS();
        while (var3_4 != null) {
            hashSet.add(var3_4.getInnerText());
            XdmNode xdmNode = var3_4.getNextSibling();
        }
        for (QName qName : this.t) {
            if (hashSet.contains(qName.getNamespaceURI())) continue;
            this.sendMessage("1.1", qName.getNamespaceURI());
        }
        for (QName qName : this.facts.keySet()) {
            if (hashSet.contains(qName.getNamespaceURI())) continue;
            this.sendMessage("1.1", qName.getNamespaceURI());
        }
    }

    private void c() {
        if (this.facts == null || this.facts.size() == 0) {
            return;
        }
        BigDecimal bigDecimal = new BigDecimal(10000);
        for (List list : this.facts.values()) {
            String string;
            Fact fact;
            XbrlConcept xbrlConcept;
            if (list == null || list.size() == 0 || (xbrlConcept = (fact = (Fact)list.get(0)).getConcept()) == null) continue;
            if (xbrlConcept.isSharesItem()) {
                for (Fact fact2 : list) {
                    string = fact2.getInnerText().trim();
                    if (StringUtils.isEmpty((String)string)) continue;
                    try {
                        BigDecimal bigDecimal2 = new BigDecimal(string);
                        if (bigDecimal2.abs().compareTo(bigDecimal) != -1 || bigDecimal2.compareTo(BigDecimal.ZERO) == 0) continue;
                        this.sendMessage("552", new Object[]{fact2.getPrefixedName(), this.a(xbrlConcept), fact2.getContextRef(), string});
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                continue;
            }
            if (!QNameConstants.numPercentItemType.equals((Object)xbrlConcept.getSchemaTypeName())) continue;
            for (Fact fact2 : list) {
                string = fact2.getDecimals();
                if (StringUtils.isEmpty((String)string) || "INF".equals(string)) continue;
                boolean bl = false;
                try {
                    BigDecimal bigDecimal3 = new BigDecimal(string);
                    if (bigDecimal3.compareTo(BigDecimal.ZERO) == -1) {
                        bl = true;
                    }
                }
                catch (Throwable throwable) {
                    bl = true;
                }
                if (!bl) continue;
                this.sendMessage("554.1", new Object[]{this.d(xbrlConcept), xbrlConcept.getPrefixedName(), fact2.getContextRef(), fact2.getInnerText(), string});
            }
        }
    }

    public static final boolean isPairURI(String thisURI, String roleURI) {
        if (Math.abs(thisURI.length() - roleURI.length()) <= 1) {
            return thisURI.equals(roleURI) || thisURI.startsWith(roleURI) || roleURI.startsWith(thisURI);
        }
        return false;
    }

    private void a(XbrlConcept xbrlConcept, List<Fact> list) {
        List<Fact> list2;
        Object object;
        Object object2;
        if (list == null || list.size() < 2) {
            return;
        }
        this.m.clear();
        boolean bl = false;
        for (Fact object3 : list) {
            object2 = j.b.a(object3, this.getUniqueContext(object3.getContext()));
            object = this.m.get(object2);
            if (object != null) {
                if (object instanceof Fact) {
                    list2 = new ArrayList<Fact>();
                    list2.add((Fact)object);
                    list2.add(object3);
                    this.m.put((j.b)object2, list2);
                } else if (object instanceof List) {
                    list2 = (List)object;
                    list2.add(object3);
                }
                bl = true;
                continue;
            }
            this.m.put((j.b)object2, object3);
        }
        if (bl) {
            for (Object object3 : this.m.values()) {
                if (!(object3 instanceof List) || (object2 = (List)object3).size() <= 1) continue;
                object = new StringBuilder();
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    String string;
                    list2 = (Fact)iterator.next();
                    if (((StringBuilder)object).length() != 0) {
                        ((StringBuilder)object).append(", ");
                    }
                    if ((string = list2.getInnerText()).length() < 50) {
                        ((StringBuilder)object).append(string);
                        continue;
                    }
                    ((StringBuilder)object).append(string.substring(0, 50)).append("...");
                }
                list2 = (Fact)object2.get(0);
                this.sendMessage("28.7.1", new Object[]{String.valueOf(list2.getPrefixedName()) + " - " + this.d(xbrlConcept), list2.getContextRef(), ((StringBuilder)object).toString()});
            }
        }
    }

    private void b(XbrlConcept xbrlConcept, List<Fact> list) {
        Object object;
        if (list == null || list.size() < 2) {
            return;
        }
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        block0: for (Fact object2 : list) {
            int list2 = 0;
            while (list2 < arrayList.size()) {
                ArrayList<Fact> arrayList2;
                object = arrayList.get(list2);
                if (object instanceof Fact) {
                    if (((Fact)object).isDuplicate(object2)) {
                        arrayList2 = new ArrayList<Fact>(2);
                        arrayList2.add((Fact)object);
                        arrayList2.add(object2);
                        arrayList.set(list2, arrayList2);
                        bl = true;
                        continue block0;
                    }
                } else if (object instanceof List && ((Fact)(arrayList2 = (ArrayList<Fact>)object).get(0)).isDuplicate(object2)) {
                    arrayList2.add(object2);
                    bl = true;
                    continue block0;
                }
                ++list2;
            }
            arrayList.add(object2);
        }
        if (bl) {
            for (Object object2 : arrayList) {
                List list2;
                if (!(object2 instanceof List) || (list2 = (List)object2).size() <= 1) continue;
                object = (Fact)list2.get(0);
                this.sendMessage("28.7.2", new Object[]{String.valueOf(object.getPrefixedName()) + " - " + this.d(xbrlConcept), this.a((Fact)object)});
            }
        }
    }

    private String a(Fact fact) {
        for (Fact fact2 : fact.getFacts()) {
            String string;
            if (fact2.isItem()) {
                return String.valueOf(fact2.getPrefixedName()) + " - " + this.d(fact2.getConcept()) + fact2.getInnerText();
            }
            if (!fact2.isTuple() || (string = this.a(fact2)) == null) continue;
            return string;
        }
        return null;
    }

    protected void checkDuplicateFacts() {
        try {
            if (this.dts == null || this.facts == null) {
                return;
            }
            for (Map.Entry entry : this.facts.entrySet()) {
                XbrlConcept xbrlConcept = this.dts.getConcept((QName)entry.getKey());
                if (xbrlConcept == null) continue;
                if (xbrlConcept.getName().equals("CashReceivedFromBorrowings")) {
                    boolean bl = false;
                }
                if (xbrlConcept.isItem()) {
                    this.a(xbrlConcept, (List)entry.getValue());
                    continue;
                }
                if (!xbrlConcept.isTuple()) continue;
                this.b(xbrlConcept, (List)entry.getValue());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static String getL3CName(String enStandardLabel, StringBuilder targetName) {
        return SasacProcessor.getL3CName(enStandardLabel, targetName, null);
    }

    public static String getL3CName(String enStandardLabel, StringBuilder targetName, MutableInt singleCount) {
        targetName.setLength(0);
        String string = StringUtils.replaceEach((String)enStandardLabel, (String[])p, (String[])q);
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            char c2 = string.charAt(n3);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9') {
                ++n;
                if (bl) {
                    targetName.append(Character.toUpperCase(c2));
                    bl = false;
                } else {
                    targetName.append(c2);
                }
            } else if (c2 != '-' && c2 != '\u00ad' && c2 != '\'' && c2 != '\u2019') {
                if (n == 1) {
                    ++n2;
                }
                n = 0;
                bl = true;
            }
            ++n3;
        }
        if (singleCount != null) {
            singleCount.setValue(n2);
        }
        String string2 = targetName.toString();
        return string2;
    }

    public static String getL3CNameOld(String enStandardLabel, StringBuilder targetName) {
        targetName.setLength(0);
        String string = StringUtils.replaceEach((String)enStandardLabel, (String[])p, (String[])r);
        boolean bl = true;
        int n = 0;
        while (n < string.length()) {
            char c2 = string.charAt(n);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9') {
                if (bl) {
                    targetName.append(Character.toUpperCase(c2));
                    bl = false;
                } else {
                    targetName.append(c2);
                }
            } else if (c2 != '-' && c2 != '\u00ad' && c2 != '\'' && c2 != '\u2019') {
                bl = true;
            }
            ++n;
        }
        String string2 = targetName.toString();
        return string2;
    }

    private XbrlSchema b(TaxonomySet taxonomySet) {
        XmlSchema xmlSchema;
        XbrlSchema xbrlSchema = null;
        if (!StringUtils.isEmpty((String)this.getExtendNamespaceURI()) && (xmlSchema = taxonomySet.getSchemas(this.getExtendNamespaceURI())) != null && ((XmlSchema[])xmlSchema).length == 1) {
            xbrlSchema = (XbrlSchema)xmlSchema[0];
            return xbrlSchema;
        }
        XmlSchema[] xmlSchemaArray = taxonomySet.getSchemas();
        int n = xmlSchemaArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            String[] stringArray;
            xmlSchema = xmlSchemaArray[n2];
            String string2 = xmlSchema.getTargetNamespace();
            if (!StringUtils.isEmpty((String)string2) && string2.startsWith("http://") && !string2.startsWith("http://www.xbrl.org") && !string2.startsWith("http://xbrl.org") && !string2.startsWith("http://xbrl.mof.gov.cn/taxonomy/") && (stringArray = StringUtils.split((String)(string = string2.substring(7)), (char)'/')) != null && stringArray.length == 3 && "cas".equals(stringArray[1])) {
                try {
                    Date.parseDate((String)stringArray[2]);
                    if (xmlSchema instanceof XbrlSchema) {
                        xbrlSchema = (XbrlSchema)xmlSchema;
                        return xbrlSchema;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return null;
    }

    private List<QName> d() {
        Object object;
        ArrayList<QName> arrayList = null;
        TaxonomySet taxonomySet = this.i;
        String string = "http://xbrl.mof.gov.cn/role/cas/cas_30_2010-09-30_role-130000";
        while (taxonomySet != null) {
            object = taxonomySet.getPresentationRelationships("http://xbrl.mof.gov.cn/role/cas/cas_30_2010-09-30_role-130000");
            if (object != null) {
                HashSet hashSet = new HashSet();
                object.getAllConcepts(hashSet);
                for (XbrlConcept xbrlConcept : hashSet) {
                    if (xbrlConcept.isAbstract()) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    if (arrayList.contains(xbrlConcept.getQName())) continue;
                    arrayList.add(xbrlConcept.getQName());
                }
                break;
            }
            taxonomySet = taxonomySet.getBaseTaxonomySet();
        }
        if (arrayList == null) {
            arrayList = new ArrayList<QName>();
            String[] stringArray = new String[]{"cas:DisclosureOfBasicInformationOfCompanyExplanatory", "ifrs:NameOfReportingEntityOrOtherMeansOfIdentification", "cas:ApprovingProvince", "cas:ApprovalDate", "cas:ApprovalNo", "cas:Sponsor", "cas:BusinessLicenseNumber", "cas:Industries", "cas:RemarkOfCompanyBasicInformation", "ifrs:StatementOfIFRSCompliance", "cas:StatementOfComplianceWithAccountingStandardForBusinessEnterprises"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = stringArray[n2];
                XbrlConcept xbrlConcept = this.dts.getConcept((String)object);
                if (xbrlConcept != null) {
                    arrayList.add(xbrlConcept.getQName());
                }
                ++n2;
            }
        }
        return arrayList;
    }

    @Override
    protected void processInstance(XbrlInstance instance) {
        Context context;
        int n;
        XbrlConcept xbrlConcept4;
        Object object322;
        Object object;
        Object object622;
        if (instance == null) {
            return;
        }
        this.prepareInstance(instance);
        this.dts = instance.getOwnerDTS();
        if (this.dts == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object622 : instance.getContexts()) {
            String object52 = object622.getIdentifierValue();
            if (!StringUtils.isEmpty((String)object52)) {
                hashSet.add(object52);
            }
            if ("http://www.aqsiq.gov.cn/".equals(object = object622.getIdentifierScheme())) continue;
            this.sendMessage("29.1.1", object622.getId(), object);
        }
        if (hashSet.size() > 1) {
            object622 = new StringBuilder();
            for (Object object322 : hashSet) {
                if (((StringBuilder)object622).length() != 0) {
                    ((StringBuilder)object622).append(", ");
                }
                ((StringBuilder)object622).append((String)object322);
            }
            this.sendMessage("519", hashSet.size(), ((StringBuilder)object622).toString());
            ((StringBuilder)object622).setLength(0);
            hashSet.clear();
        }
        hashSet = null;
        object622 = this.dts.getPresentationRelationships();
        object322 = this.dts.getAllDRS();
        this.t = new HashSet();
        for (Context context2 : instance.getContexts()) {
            this.t.addAll(context2.getDimensionContents().keySet());
            Iterator<Object> iterator = context2.getDimensionContents().values().iterator();
            while (iterator.hasNext()) {
                XbrlConcept xbrlConcept2 = xbrlConcept4 = (XbrlConcept)iterator.next();
                n = ((MemberElement[])xbrlConcept2).length;
                int n2 = 0;
                while (n2 < n) {
                    Object object2;
                    XbrlConcept xbrlConcept3 = xbrlConcept2[n2];
                    if (xbrlConcept3 instanceof ExplicitMember && (object2 = ((ExplicitMember)xbrlConcept3).getDimensionContent()) != null && !object2.isEmpty()) {
                        this.t.add((QName)object2);
                    }
                    ++n2;
                }
            }
        }
        this.s = new HashSet();
        this.s.addAll(this.facts.keySet());
        this.s.addAll(this.t);
        for (QName qName : this.s) {
            List list;
            xbrlConcept4 = this.dts.getConcept(qName);
            if (xbrlConcept4 == null) {
                this.sendMessage("520", qName.toString());
                continue;
            }
            boolean bl = false;
            Object object3 = object622.iterator();
            while (object3.hasNext()) {
                RelationshipSet relationshipSet = (RelationshipSet)object3.next();
                if (!relationshipSet.contains((Object)xbrlConcept4)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.sendMessage("21.1.1", xbrlConcept4, this.a(xbrlConcept4));
            }
            if ((list = (List)this.facts.get(qName)) == null) continue;
            object3 = this.d(xbrlConcept4);
            n = xbrlConcept4.isMonetaryItem() && ((String)object3).endsWith("\u539f\u5e01\u91d1\u989d") ? 1 : 0;
            for (XbrlConcept xbrlConcept2 : list) {
                Unit unit;
                if (!xbrlConcept2.isItem() || (context = xbrlConcept2.getContext()) == null) continue;
                if (context.getDimensionContents().size() > 0) {
                    XdtDRS xdtDRS2;
                    boolean bl2 = false;
                    for (XdtDRS xdtDRS2 : object322.values()) {
                        if (!xdtDRS2.hasHypercubes(xbrlConcept4)) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2 && (xdtDRS2 = this.sendMessage("501", xbrlConcept4, xbrlConcept2.getContextRef(), xbrlConcept2.toString())) != null) {
                        xdtDRS2.setTag((Object)xbrlConcept2);
                    }
                }
                if (n == 0 || (unit = xbrlConcept2.getUnit()) != null && !this.a(unit, a)) continue;
                this.sendMessage("531", object3, xbrlConcept2.getInnerText());
            }
        }
        XbrlSchema xbrlSchema = this.b(this.dts);
        if (xbrlSchema != null) {
            object = new HashSet();
            for (XbrlConcept xbrlConcept4 : instance.getContexts()) {
                for (Map.Entry entry : xbrlConcept4.getDimensionContents().entrySet()) {
                    ((HashSet)object).add((QName)entry.getKey());
                    context = (Context)entry.getValue();
                    int n3 = ((MemberElement[])context).length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Context context3 = context[n4];
                        if (context3.isExplicitMember()) {
                            try {
                                ((HashSet)object).add(context3.getQName());
                            }
                            catch (EvaluationException evaluationException) {
                                evaluationException.printStackTrace();
                            }
                        }
                        ++n4;
                    }
                }
            }
            for (XbrlConcept xbrlConcept4 : xbrlSchema.getElements().values()) {
                if (!(xbrlConcept4 instanceof XbrlConcept)) continue;
                XbrlConcept xbrlConcept5 = xbrlConcept4;
                QName qName = xbrlConcept5.getQName();
                if (xbrlConcept5.isDimension()) {
                    if (((HashSet)object).contains(qName) || this.dts.getDefaultDimensionMember(qName) != null) continue;
                    this.sendMessage("16.6.2", xbrlConcept5, this.d(xbrlSchema.getSourceURI()));
                    continue;
                }
                if (xbrlConcept5.isAbstract() || !xbrlConcept5.isItem() && !xbrlConcept5.isTuple() || this.facts.containsKey(qName) || ((HashSet)object).contains(qName)) continue;
                if (!this.b(xbrlConcept5)) {
                    this.sendMessage("16.6.2", xbrlConcept5, this.d(xbrlSchema.getSourceURI()));
                    continue;
                }
                this.sendMessage("16.6.1", new Object[]{xbrlConcept5, this.d(xbrlConcept5), this.d(xbrlSchema.getSourceURI())});
            }
        }
        this.c(this.getFunid());
        this.f();
        this.c(instance);
        this.b(instance);
        this.a(instance);
        this.e(instance);
        this.d(instance);
        this.checkDuplicateFacts();
        this.h();
        this.b();
        this.j();
        this.i();
        this.g();
        this.e();
        this.c();
        this.k();
        this.checkDateItems();
    }

    private void e() {
        if (this.instance == null) {
            return;
        }
        XdmNode xdmNode = this.instance.getFirstNS();
        while (xdmNode != null) {
            XmlSchema[] xmlSchemaArray;
            XdmNSAttribute xdmNSAttribute;
            String string;
            String string2 = xdmNode.getInnerText();
            if (xdmNode instanceof XdmNSAttribute && !"xmlns".equals(string = (xdmNSAttribute = (XdmNSAttribute)xdmNode).getLocalName()) && (xmlSchemaArray = this.dts.getSchemas(string2)) != null && xmlSchemaArray.length > 0) {
                XmlSchema[] xmlSchemaArray2 = xmlSchemaArray;
                int n = xmlSchemaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    XmlSchema xmlSchema = xmlSchemaArray2[n2];
                    String string3 = xmlSchema.getPrefixOfNamespace(string2);
                    if (!StringUtils.isEmpty((String)string3) && !string3.equals(string)) {
                        this.sendMessage("40", string3, string);
                    }
                    ++n2;
                }
            }
            xdmNode = xdmNode.getNextSibling();
        }
    }

    private void c(String string) {
        l l2 = new l(this, this.instance, (XbrlSchema)this.b);
        if (this.e == null) {
            this.a();
        }
        l2.a(this.e.toString(), this.facts, this._equalContexts.values(), string);
    }

    private void f() {
        List<QName> list = this.d();
        if (list != null) {
            for (QName qName : list) {
                XbrlConcept xbrlConcept;
                List list2 = (List)this.facts.get(qName);
                if (list2 != null && list2.size() != 0 || (xbrlConcept = this.dts.getConcept(qName)) == null) continue;
                String string = this.a(xbrlConcept);
                if (StringUtils.isEmpty((String)string)) {
                    string = this.a(xbrlConcept, this.i);
                }
                this.sendMessage("28.1.1", xbrlConcept.getPrefixedName(), string);
            }
        }
    }

    private void g() {
        if (this.instance != null) {
            this.a();
            m m2 = new m(this.instance, this, this._equalContexts.values(), this.facts);
            m2.a(this.e);
        }
    }

    private void h() {
        if (this._equalContexts != null) {
            HashSet<List> hashSet = null;
            for (List list : this._equalContexts.values()) {
                if (list.size() <= 1) continue;
                if (hashSet == null) {
                    hashSet = new HashSet<List>();
                }
                if (hashSet.contains(list)) continue;
                hashSet.add(list);
                StringBuilder stringBuilder = new StringBuilder();
                int n = 0;
                while (n < list.size() && n < 5) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(((Context)list.get(n)).getId());
                    ++n;
                }
                this.sendMessage("29.3.2", list.size() - 1, stringBuilder.toString());
            }
        }
    }

    private void b(XbrlInstance xbrlInstance) {
        if (xbrlInstance == null) {
            return;
        }
        String string = xbrlInstance.getOwnerDocument().getXmlEncoding();
        if (!"UTF-8".equalsIgnoreCase(string)) {
            this.sendMessage("5.2");
        }
        TaxonomySet taxonomySet = xbrlInstance.getOwnerDTS();
        IXbrlDocument[] iXbrlDocumentArray = taxonomySet.getDocuments();
        int n = iXbrlDocumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IXbrlDocument iXbrlDocument = iXbrlDocumentArray[n2];
            String string2 = iXbrlDocument.getBaseURI();
            if (!(iXbrlDocument.isReadOnly() && !string2.startsWith("http://zip.local/") || "UTF-8".equalsIgnoreCase(iXbrlDocument.getXmlEncoding()))) {
                this.sendMessage("5.1", StringUtils.removeStart((String)string2, (String)"http://zip.local/"));
            }
            ++n2;
        }
    }

    private void c(XbrlInstance xbrlInstance) {
        if (xbrlInstance != null && !"xbrl".equals(xbrlInstance.getLocalName())) {
            this.sendMessage("4.1", xbrlInstance.getLocalName());
        }
    }

    private void d(XbrlInstance xbrlInstance) {
        if (xbrlInstance == null) {
            return;
        }
        HashSet hashSet = new HashSet(xbrlInstance.getUnits());
        block0: for (List list : this.facts.values()) {
            for (Fact fact : list) {
                Unit unit = fact.getUnit();
                if (unit == null) continue;
                hashSet.remove(unit);
                if (hashSet.isEmpty()) break block0;
            }
        }
        if (hashSet.size() > 0) {
            for (List list : hashSet) {
                this.sendMessage("29.5.1", list.getId());
            }
        }
    }

    private void e(XbrlInstance xbrlInstance) {
        Fact fact;
        if (xbrlInstance == null) {
            return;
        }
        HashSet hashSet = new HashSet(xbrlInstance.getContexts());
        for (Object object : hashSet) {
            if (!object.getId().startsWith("c_dur") || (fact = object.getId().split("_")) == null || ((String[])fact).length != 4 || !fact[2].equals(fact[3])) continue;
            this.sendMessage("559", object.getId());
        }
        block1: for (Object object : this.facts.values()) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                fact = (Fact)iterator.next();
                Context context = fact.getContext();
                if (context == null) continue;
                hashSet.remove(context);
                if (hashSet.isEmpty()) break block1;
            }
        }
        if (hashSet.size() > 0) {
            for (Object object : hashSet) {
                this.sendMessage("29.3.1", object.getId());
            }
        }
    }

    private void i() {
        if (this.facts == null || this.facts.size() == 0) {
            return;
        }
        HashSet hashSet = new HashSet();
        MutableInteger mutableInteger = new MutableInteger();
        for (RelationshipSet relationshipSet : this.dts.getPresentationRelationships()) {
            hashSet.clear();
            relationshipSet.getAllTargets(hashSet);
            boolean bl = false;
            boolean bl2 = false;
            Fact fact = null;
            Fact fact2 = null;
            block1: for (Object e2 : hashSet) {
                List list;
                XbrlConcept xbrlConcept;
                if (!(e2 instanceof XbrlConcept) || !(xbrlConcept = (XbrlConcept)e2).isMonetaryItem() || (list = (List)this.facts.get(xbrlConcept.getQName())) == null || list.size() == 0) continue;
                for (Fact fact3 : list) {
                    String string = fact3.getDecimals();
                    if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !Int32.tryParse((String)string, (MutableInteger)mutableInteger) || mutableInteger.intValue() < 0 || mutableInteger.intValue() == 2 || "0".equals(fact3.getInnerText())) continue;
                    bl = true;
                    fact = fact3;
                    if (mutableInteger.intValue() != 0) {
                        bl2 = true;
                        fact2 = fact3;
                    }
                    if (bl2 && bl) break block1;
                }
            }
            if (bl2) {
                this.sendMessage("544", new Object[]{this.a(relationshipSet.getRoleURI()), fact2 == null ? "" : String.valueOf(this.d(fact2.getConcept())) + " " + fact2, relationshipSet.getRoleURI()});
                continue;
            }
            if (!bl) continue;
            this.sendMessage("542", new Object[]{this.a(relationshipSet.getRoleURI()), fact == null ? "" : String.valueOf(this.d(fact.getConcept())) + " " + fact, relationshipSet.getRoleURI()});
        }
    }

    private void j() {
        if (this.facts == null || this.facts.size() == 0) {
            return;
        }
        HashSet hashSet = new HashSet();
        MutableInteger mutableInteger = new MutableInteger();
        for (RelationshipSet relationshipSet : this.dts.getPresentationRelationships()) {
            hashSet.clear();
            relationshipSet.getAllTargets(hashSet);
            Fact[] factArray = new Fact[4];
            int[] nArray = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
            boolean bl = false;
            for (Object e2 : hashSet) {
                List list;
                int n;
                XbrlConcept xbrlConcept;
                if (!(e2 instanceof XbrlConcept) || (xbrlConcept = (XbrlConcept)e2).isAbstract() || xbrlConcept.isNonNumeric() || (n = SasacProcessor.getConceptDataType(xbrlConcept)) == -1 || (list = (List)this.facts.get(xbrlConcept.getQName())) == null || list.size() == 0) continue;
                int n2 = Integer.MAX_VALUE;
                int n3 = Integer.MAX_VALUE;
                bl = true;
                Fact fact = null;
                for (Fact fact2 : list) {
                    String string = fact2.getDecimals();
                    if (StringUtils.isEmpty((String)string) || "INF".equals(string) || !Int32.tryParse((String)string, (MutableInteger)mutableInteger)) continue;
                    if (n2 == Integer.MAX_VALUE || n2 > mutableInteger.intValue()) {
                        n2 = mutableInteger.intValue();
                        fact = fact2;
                    }
                    if (n3 != Integer.MAX_VALUE && n3 >= mutableInteger.intValue()) continue;
                    n3 = mutableInteger.intValue();
                }
                if (n2 != Integer.MAX_VALUE && (nArray[n] == Integer.MAX_VALUE || nArray[n] > n2)) {
                    nArray[n] = n2;
                    factArray[n / 2] = fact;
                }
                if (n3 == Integer.MAX_VALUE || nArray[n + 1] != Integer.MAX_VALUE && nArray[n + 1] >= n3) continue;
                nArray[n + 1] = n3;
            }
            if (!bl) continue;
            int n = 0;
            while (n < 4) {
                if (nArray[n * 2] != nArray[n * 2 + 1]) {
                    Fact fact = factArray[n];
                    this.sendMessage("541", new Object[]{this.a(relationshipSet.getRoleURI()), Type_Names[n], nArray[n * 2], nArray[n * 2 + 1], relationshipSet.getRoleURI(), fact != null ? this.d(fact.getConcept()) : "", fact});
                }
                ++n;
            }
        }
    }

    public static int getConceptDataType(XbrlConcept c2) {
        if (c2 == null || !c2.isNumeric()) {
            return -1;
        }
        if (c2.isMonetaryItem()) {
            return 0;
        }
        QName qName = c2.getSchemaTypeName();
        if (qName != null) {
            if (QNameConstants.numPercentItemType.equals((Object)qName)) {
                return 4;
            }
            if (QNameConstants.numPerShareItemType.equals((Object)qName)) {
                return 6;
            }
        }
        return 2;
    }

    private boolean a(Unit unit, QName qName) {
        if (unit == null || qName == null) {
            return false;
        }
        if (unit.getDenominatorMeasures().length > 0) {
            return false;
        }
        QName[] qNameArray = unit.getNumeratorMeasures();
        return qNameArray.length == 1 && qName.equals(qNameArray[0]);
    }

    private boolean b(XbrlConcept xbrlConcept) {
        if (this.h == null) {
            this.h = this.dts.getPresentationRelationships();
        }
        for (RelationshipSet relationshipSet : this.h) {
            if (!relationshipSet.hasChildren((Object)xbrlConcept)) continue;
            return true;
        }
        return false;
    }

    private String d(String string) {
        if (string != null) {
            if (string.contains("%")) {
                string = HttpUtility.urlDecode((String)string);
            }
            if (string.startsWith("http://zip.local/")) {
                return string.substring("http://zip.local/".length());
            }
        }
        return string;
    }

    public String getExtendNamespaceURI() {
        if (StringUtils.isEmpty((String)this.j) && this.instance != null) {
            XdmNode xdmNode = this.instance.getFirstChild();
            while (xdmNode != null) {
                IXbrlDocument iXbrlDocument;
                SchemaRef schemaRef;
                URI uRI;
                if (xdmNode instanceof SchemaRef && (uRI = (schemaRef = (SchemaRef)xdmNode).getDiscoveredUri((Node)this.instance)) != null && (iXbrlDocument = this.dts.getDocument(uRI)) != null && iXbrlDocument instanceof XbrlSchema) {
                    XbrlSchema xbrlSchema = (XbrlSchema)iXbrlDocument;
                    this.j = xbrlSchema.getTargetNamespace();
                    return this.j;
                }
                xdmNode = xdmNode.getNextSibling();
            }
        }
        return this.j;
    }

    public void setExtendNamespaceURI(String _extendNamespaceURI) {
        this.j = _extendNamespaceURI;
    }

    private void k() {
        if (this.instance == null) {
            return;
        }
        if (this.facts == null) {
            this.facts = this.instance.getAllFacts(true);
        }
        for (Map.Entry entry : this.facts.entrySet()) {
            XbrlConcept xbrlConcept = this.dts.getConcept((QName)entry.getKey());
            if (xbrlConcept == null || !xbrlConcept.isNumeric()) continue;
            boolean bl = xbrlConcept.isMonetaryItem();
            QName qName = xbrlConcept.getSchemaTypeName();
            block3: for (Fact fact : (List)entry.getValue()) {
                String string;
                String string2 = fact.getUnitRef();
                if (bl) {
                    if (!this.isValidMonetaryUnit(string2)) {
                        this.sendMessage("556.1", fact.toString(), string2, this.d(xbrlConcept));
                    }
                } else if (QNameConstants.numPercentItemType.equals((Object)qName)) {
                    if (!this.isValidPureUnit(string2)) {
                        this.sendMessage("556.2", fact.toString(), string2, this.d(xbrlConcept));
                    }
                } else if (QNameConstants.numPerShareItemType.equals((Object)qName) && !this.isValidPerShareUnit(string2)) {
                    this.sendMessage("556.3", fact.toString(), string2, this.d(xbrlConcept));
                }
                if (StringUtils.isEmpty((String)(string = fact.getDecimals())) || "INF".equals(string)) continue;
                try {
                    int n;
                    int n2 = Integer.parseInt(string);
                    String string3 = fact.getInnerText().trim();
                    int n3 = string3.indexOf(46);
                    if (n3 == -1) {
                        n3 = string3.length();
                    }
                    if ((n = n3 + n2) >= string3.length() - 1) continue;
                    int n4 = n;
                    while (n4 < string3.length()) {
                        char c2;
                        if (n4 >= 0 && (c2 = string3.charAt(n4)) != '0' && c2 != '.' && Character.isDigit(c2)) {
                            this.sendMessage("557.1", new Object[]{this.d(xbrlConcept), fact.getPrefixedName(), fact.getContextRef(), string3, string});
                            continue block3;
                        }
                        ++n4;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public static class RoleTypeRule {
        public String markText;
        public String markText2;
        private char a;

        public char getMarkChar() {
            return this.a;
        }

        RoleTypeRule(char markChar, String markText) {
            this.a = markChar;
            this.markText = markText;
            this.markText2 = String.valueOf(markText) + " - ";
        }
    }
}

