/*
 * Decompiled with CFR 0.152.
 */
package net.gbicc.xbrl.filing;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.gbicc.xbrl.core.ConceptType;
import net.gbicc.xbrl.core.Context;
import net.gbicc.xbrl.core.Fact;
import net.gbicc.xbrl.core.HandlerContext;
import net.gbicc.xbrl.core.IXbrlDocument;
import net.gbicc.xbrl.core.Label;
import net.gbicc.xbrl.core.Linkbase;
import net.gbicc.xbrl.core.LogWatch;
import net.gbicc.xbrl.core.QNameConstants;
import net.gbicc.xbrl.core.TaxonomySet;
import net.gbicc.xbrl.core.Unit;
import net.gbicc.xbrl.core.XbrlConcept;
import net.gbicc.xbrl.core.XbrlContentType;
import net.gbicc.xbrl.core.XbrlDocument;
import net.gbicc.xbrl.core.XbrlInstance;
import net.gbicc.xbrl.core.XbrlMessage;
import net.gbicc.xbrl.core.messages.MessageManager;
import net.gbicc.xbrl.filing.DisclosureSystemType;
import net.gbicc.xbrl.filing.ExtendMode;
import net.gbicc.xbrl.filing.FilingProcessOptions;
import net.gbicc.xbrl.filing.IFilingProcessor;
import org.apache.commons.lang.StringUtils;
import system.qizx.api.QName;
import system.qizx.xdm.XdmElement;
import system.qizx.xdm.XdmNode;

class j
implements IFilingProcessor {
    private DisclosureSystemType a;
    private HandlerContext b;
    protected String catalog = "Filing".toUpperCase();
    protected Map<String, Unit> _units;
    protected Map<String, Context> _contexts;
    protected TaxonomySet dts;
    protected Map<a, List<Context>> _equalContexts;
    private Map<Context, a> c;
    protected Map<QName, List<Fact>> facts;
    protected XbrlInstance instance;
    protected FilingProcessOptions options;
    private String d;
    private HashSet<Unit> e;
    private HashSet<Unit> f;
    private HashSet<String> g;
    protected ExtendMode extendMode = ExtendMode.None;

    public void setOptions(FilingProcessOptions options) {
        this.options = options;
    }

    public FilingProcessOptions getOptions() {
        if (this.options == null) {
            this.options = new FilingProcessOptions();
        }
        return this.options;
    }

    protected void prepareInstance(XbrlInstance instance) {
        Object object;
        if (instance == null) {
            return;
        }
        if (this.instance == instance && this.facts != null && this._equalContexts != null) {
            return;
        }
        this.instance = instance;
        this.dts = instance.getOwnerDTS();
        this.facts = instance.getAllFacts(true);
        List list = instance.getContexts();
        this._equalContexts = new HashMap<a, List<Context>>(list.size());
        this.c = new HashMap<Context, a>();
        List<Context> list2 = null;
        for (Context context : list) {
            object = new a(context);
            this.c.put(context, (a)object);
            list2 = this._equalContexts.get(object);
            if (list2 == null) {
                list2 = new ArrayList<Context>(2);
                list2.add(context);
                this._equalContexts.put((a)object, list2);
                continue;
            }
            list2.add(context);
        }
        this._units = new HashMap<String, Unit>();
        for (Context context : instance.getUnits()) {
            object = context.getId();
            Unit unit = this._units.get(object);
            if (unit != null) continue;
            this._units.put((String)object, (Unit)context);
        }
    }

    protected Context getUniqueContext(Context c2) {
        if (c2 == null) {
            return null;
        }
        a a2 = this.c.get(c2);
        if (a2 == null) {
            return c2;
        }
        List<Context> list = this._equalContexts.get(a2);
        if (list != null) {
            return list.get(0);
        }
        return c2;
    }

    public byte[] getUtf8(String text) {
        try {
            return StringUtils.isEmpty((String)text) ? new byte[]{} : text.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return new byte[0];
        }
    }

    public void sendMessage(String messageId) {
        XbrlMessage xbrlMessage = MessageManager.getMessageGroup((String)this.catalog, null).getMessage(messageId);
        if (xbrlMessage != null) {
            this.b.sendMessage(xbrlMessage);
        } else {
            LogWatch.error((Object)(String.valueOf(messageId) + " not found message."));
        }
    }

    public void sendMessage(String messageId, Object arg) {
        XbrlMessage xbrlMessage = MessageManager.getMessageGroup((String)this.catalog, null).getMessage(messageId);
        if (xbrlMessage != null) {
            xbrlMessage = xbrlMessage.CloneMessage(arg);
            this.b.sendMessage(xbrlMessage);
        } else {
            LogWatch.error((Object)(String.valueOf(messageId) + " not found message."));
        }
    }

    public XbrlMessage sendMessage(String messageId, Object arg1, Object arg2) {
        XbrlMessage xbrlMessage = MessageManager.getMessageGroup((String)this.catalog, null).getMessage(messageId);
        if (xbrlMessage != null) {
            xbrlMessage = xbrlMessage.CloneMessage(arg1, arg2);
            this.b.sendMessage(xbrlMessage);
            return xbrlMessage;
        }
        LogWatch.error((Object)(String.valueOf(messageId) + " not found message."));
        return null;
    }

    public XbrlMessage sendMessage(String messageId, Object arg1, Object arg2, Object arg3) {
        XbrlMessage xbrlMessage = MessageManager.getMessageGroup((String)this.catalog, null).getMessage(messageId);
        if (xbrlMessage != null) {
            xbrlMessage = xbrlMessage.CloneMessage(arg1, arg2, arg3);
            this.b.sendMessage(xbrlMessage);
            return xbrlMessage;
        }
        LogWatch.error((Object)(String.valueOf(messageId) + " not found message."));
        return null;
    }

    public XbrlMessage sendMessage(String messageId, Object[] args) {
        XbrlMessage xbrlMessage = MessageManager.getMessageGroup((String)this.catalog, null).getMessage(messageId);
        if (xbrlMessage != null) {
            xbrlMessage = xbrlMessage.CloneMessage(args);
            this.b.sendMessage(xbrlMessage);
            return xbrlMessage;
        }
        LogWatch.error((Object)(String.valueOf(messageId) + " not found message."));
        return null;
    }

    public DisclosureSystemType getDiscosureSystem() {
        return this.a;
    }

    public void setHandlerContext(HandlerContext handlerContext) {
        this.b = handlerContext;
    }

    public HandlerContext getHandlerContext() {
        return this.b;
    }

    public j(DisclosureSystemType disclosureSystemType) {
        this.a = disclosureSystemType;
    }

    public void process(TaxonomySet dts) {
        this.dts = dts;
    }

    protected void processInstance(XbrlInstance instance) {
    }

    public final void process(XbrlInstance instance, boolean checkDTS) {
        try {
            try {
                if (this.getHandlerContext() == null && instance != null) {
                    this.b = instance.getOwnerDTS().getHandlerContext();
                }
                this.instance = instance;
                if (checkDTS) {
                    this.process(instance.getOwnerDTS());
                }
                this.processInstance(instance);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.clear();
            }
        }
        finally {
            this.clear();
        }
    }

    protected void clear() {
        this.facts = null;
        this._equalContexts = null;
    }

    protected boolean isValidPureUnit(String unitId) {
        Unit unit = this._units.get(unitId);
        if (unit == null) {
            return false;
        }
        if (this.e == null) {
            this.e = new HashSet();
        }
        if (this.e.contains(unit)) {
            return true;
        }
        QName[] qNameArray = unit.getDenominatorMeasures();
        if (qNameArray != null && qNameArray.length > 0) {
            return false;
        }
        QName[] qNameArray2 = unit.getNumeratorMeasures();
        if (qNameArray2 != null && qNameArray2.length == 1 && QNameConstants.pure.equals((Object)qNameArray2[0])) {
            this.e.add(unit);
            return true;
        }
        return false;
    }

    protected boolean isValidPerShareUnit(String unitId) {
        QName[] qNameArray;
        Unit unit = this._units.get(unitId);
        if (unit == null) {
            return false;
        }
        if (this.f == null) {
            this.f = new HashSet();
        }
        if (this.f.contains(unit)) {
            return true;
        }
        QName[] qNameArray2 = unit.getDenominatorMeasures();
        if (qNameArray2 != null && qNameArray2.length == 1 && QNameConstants.shares.equals((Object)qNameArray2[0]) && (qNameArray = unit.getNumeratorMeasures()) != null && qNameArray.length == 1 && "http://www.xbrl.org/2003/iso4217".equals(qNameArray[0].getNamespaceURI())) {
            this.f.add(unit);
            return true;
        }
        return false;
    }

    protected boolean isValidMonetaryUnit(String unitId) {
        if (StringUtils.isEmpty((String)unitId)) {
            return false;
        }
        if (this.g == null) {
            this.g = new HashSet();
        }
        if (this.g.contains(unitId)) {
            return true;
        }
        Unit unit = this._units.get(unitId);
        if (unit == null) {
            return false;
        }
        QName[] qNameArray = unit.getDenominatorMeasures();
        if (qNameArray != null && qNameArray.length > 0) {
            return false;
        }
        QName[] qNameArray2 = unit.getNumeratorMeasures();
        if (qNameArray2 != null && qNameArray2.length == 1 && "http://www.xbrl.org/2003/iso4217".equals(qNameArray2[0].getNamespaceURI())) {
            this.g.add(unitId);
            return true;
        }
        return false;
    }

    public ExtendMode getExtendMode() {
        if (this.extendMode == null) {
            this.extendMode = ExtendMode.None;
        }
        if (this.extendMode == ExtendMode.None && this.dts != null) {
            this.extendMode = ExtendMode.Redefine;
            IXbrlDocument[] iXbrlDocumentArray = this.dts.getDocuments();
            int n = iXbrlDocumentArray.length;
            int n2 = 0;
            block0: while (n2 < n) {
                XbrlDocument xbrlDocument;
                IXbrlDocument iXbrlDocument = iXbrlDocumentArray[n2];
                if (iXbrlDocument != null && iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && !iXbrlDocument.getContentType().contains(XbrlContentType.FileNotFound) && iXbrlDocument.isReadOnly() && iXbrlDocument.getBaseURI() != null && !iXbrlDocument.getBaseURI().startsWith("http://zip.local/") && iXbrlDocument instanceof XbrlDocument && (xbrlDocument = (XbrlDocument)iXbrlDocument).getDocumentElement() instanceof Linkbase) {
                    Linkbase linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                    XdmNode xdmNode = linkbase.getFirstChild();
                    while (xdmNode != null) {
                        if (xdmNode.getNodeNature() == 2 && (QNameConstants.presentationLink.equals((Object)xdmNode.getNodeName()) || QNameConstants.definitionLink.equals((Object)xdmNode.getNodeName()) || QNameConstants.calculationLink.equals((Object)xdmNode.getNodeName()))) {
                            this.extendMode = ExtendMode.Reuse;
                            break block0;
                        }
                        xdmNode = xdmNode.getNextSibling();
                    }
                }
                ++n2;
            }
        }
        return this.extendMode;
    }

    public ExtendMode checkExtendMode(XbrlInstance instance) {
        ExtendMode extendMode = ExtendMode.None;
        if (instance != null) {
            IXbrlDocument[] iXbrlDocumentArray = instance.getOwnerDTS().getDocuments();
            int n = iXbrlDocumentArray.length;
            int n2 = 0;
            while (n2 < n) {
                IXbrlDocument iXbrlDocument = iXbrlDocumentArray[n2];
                if (iXbrlDocument.getContentType().contains(XbrlContentType.Linkbase) && iXbrlDocument.isReadOnly() && !iXbrlDocument.getBaseURI().startsWith("http://zip.local/")) {
                    extendMode = ExtendMode.Reuse;
                    break;
                }
                ++n2;
            }
            if (extendMode == ExtendMode.None) {
                extendMode = ExtendMode.Redefine;
            }
        }
        return extendMode;
    }

    public void setExtendMode(ExtendMode extendMode) {
        this.extendMode = extendMode;
        if (this.extendMode == null) {
            this.extendMode = ExtendMode.None;
        }
    }

    public void checkDateItems() {
        if (this.instance == null) {
            return;
        }
        if (this.facts == null) {
            this.facts = this.instance.getAllFacts(true);
        }
        for (Map.Entry<QName, List<Fact>> entry : this.facts.entrySet()) {
            boolean bl;
            XbrlConcept xbrlConcept = this.dts.getConcept(entry.getKey());
            if (xbrlConcept == null || !(bl = xbrlConcept.isTypeOf(ConceptType.DateItem))) continue;
            for (Fact fact : entry.getValue()) {
                if (this.a(fact.getInnerText())) continue;
                this.sendMessage("560", xbrlConcept.getName(), fact.getInnerText());
            }
        }
    }

    String d(XbrlConcept xbrlConcept) {
        if (xbrlConcept != null) {
            List list = xbrlConcept.getLabels(this.dts);
            String string = null;
            for (Label label : list) {
                if (!"http://www.xbrl.org/2003/role/label".equals(label.getRole())) continue;
                if (label.getLang().startsWith("zh")) {
                    return label.getInnerText();
                }
                string = label.getInnerText();
            }
            return string == null ? "" : string;
        }
        return "";
    }

    private boolean a(String string) {
        String string2 = "[0-9]{4}-[0-9]{2}-[0-9]{2}";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        boolean bl = matcher.matches();
        return bl;
    }

    public void setFundid(String id) {
        this.d = id;
    }

    public String getFunid() {
        return this.d;
    }

    private static class a {
        private int a;
        private Context b;

        public a(Context context) {
            this.b = context;
            this.a = context.computeHashCode();
        }

        public int hashCode() {
            return this.a;
        }

        public boolean equals(Object o) {
            a a2;
            a a3 = a2 = o instanceof a ? (a)o : null;
            if (a2 == null) {
                return false;
            }
            if (a2.b == this.b) {
                return true;
            }
            return this.b.XdtEqual(a2.b);
        }
    }

    static class b {
        XbrlConcept a;
        XdmElement b;
        Unit c;
        Context d;
        private int e;

        b() {
        }

        public static b a(Fact fact, Context context) {
            b b2 = new b();
            b2.a = fact.getConcept();
            b2.b = fact.getParent();
            b2.c = fact.getUnit();
            b2.d = context;
            return b2;
        }

        public boolean equals(Object o) {
            if (o instanceof b) {
                b b2 = (b)o;
                if (o.hashCode() == b2.hashCode()) {
                    return this.d == b2.d && this.c == b2.c && this.a == b2.a && this.b == b2.b;
                }
            }
            return false;
        }

        public int hashCode() {
            if (this.e == 0) {
                this.e = (this.d != null ? this.d.hashCode() : 0) + (this.c == null ? 0 : this.c.hashCode()) * 10 + this.b.hashCode() * 1000 + this.a.hashCode() * 10000;
            }
            return this.e;
        }
    }
}

