/*
 * Decompiled with CFR 0.152.
 */
package net.gbicc.xbrl.filing.utils;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;

public class CosineSimilarAlgorithm {
    public static boolean isSimilarRemovePrefix(String text1, String text2, double similar) {
        int n = Math.min(text1.length(), text2.length());
        int n2 = -1;
        n2 = 0;
        while (n2 < n) {
            if (text1.charAt(n2) != text2.charAt(n2)) break;
            ++n2;
        }
        if (n2 != 0) {
            return CosineSimilarAlgorithm.getSimilarity(text1.substring(n2), text2.substring(n2)) >= similar;
        }
        return true;
    }

    public static double getSimilarity(String doc1, String doc2) {
        if (doc1 != null && doc1.trim().length() > 0 && doc2 != null && doc2.trim().length() > 0) {
            int[] nArray;
            short s;
            char c2;
            HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
            int n = 0;
            while (n < doc1.length()) {
                c2 = doc1.charAt(n);
                if (CosineSimilarAlgorithm.isHanZi(c2) && (s = CosineSimilarAlgorithm.getGB2312Id(c2)) != -1) {
                    nArray = (int[])hashMap.get(s);
                    if (nArray != null && nArray.length == 2) {
                        nArray[0] = nArray[0] + 1;
                    } else {
                        nArray = new int[]{1, 0};
                        hashMap.put(Integer.valueOf(s), nArray);
                    }
                }
                ++n;
            }
            n = 0;
            while (n < doc2.length()) {
                c2 = doc2.charAt(n);
                if (CosineSimilarAlgorithm.isHanZi(c2) && (s = CosineSimilarAlgorithm.getGB2312Id(c2)) != -1) {
                    nArray = (int[])hashMap.get(s);
                    if (nArray != null && nArray.length == 2) {
                        nArray[1] = nArray[1] + 1;
                    } else {
                        nArray = new int[]{0, 1};
                        hashMap.put(Integer.valueOf(s), nArray);
                    }
                }
                ++n;
            }
            Iterator iterator = hashMap.keySet().iterator();
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            while (iterator.hasNext()) {
                int[] nArray2 = (int[])hashMap.get(iterator.next());
                d4 += (double)(nArray2[0] * nArray2[1]);
                d2 += (double)(nArray2[0] * nArray2[0]);
                d3 += (double)(nArray2[1] * nArray2[1]);
            }
            double d5 = d2 * d3;
            return d5 != 0.0 ? d4 / Math.sqrt(d2 * d3) : 0.0;
        }
        return 0.0;
    }

    public static double getSimilarity(char[] doc1, String doc2) {
        if (doc1 != null && doc1.length > 0 && doc2 != null && doc2.trim().length() > 0) {
            short s;
            HashMap<Integer, int[]> hashMap = new HashMap<Integer, int[]>();
            char c2 = '\u0000';
            char c3 = doc1.length;
            while (c2 < c3) {
                short s2;
                s = doc1[c2];
                if (CosineSimilarAlgorithm.isHanZi((char)s) && (s2 = CosineSimilarAlgorithm.getGB2312Id((char)s)) != -1) {
                    int[] nArray = (int[])hashMap.get(s2);
                    if (nArray != null && nArray.length == 2) {
                        nArray[0] = nArray[0] + 1;
                    } else {
                        nArray = new int[]{1, 0};
                        hashMap.put(Integer.valueOf(s2), nArray);
                    }
                }
                ++c2;
            }
            c2 = '\u0000';
            while (c2 < doc2.length()) {
                c3 = doc2.charAt(c2);
                if (CosineSimilarAlgorithm.isHanZi(c3) && (s = CosineSimilarAlgorithm.getGB2312Id(c3)) != -1) {
                    int[] nArray = (int[])hashMap.get(s);
                    if (nArray != null && nArray.length == 2) {
                        nArray[1] = nArray[1] + 1;
                    } else {
                        nArray = new int[]{0, 1};
                        hashMap.put(Integer.valueOf(s), nArray);
                    }
                }
                ++c2;
            }
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            for (int[] nArray : hashMap.values()) {
                d4 += (double)(nArray[0] * nArray[1]);
                d2 += (double)(nArray[0] * nArray[0]);
                d3 += (double)(nArray[1] * nArray[1]);
            }
            double d5 = d2 * d3;
            return d5 != 0.0 ? d4 / Math.sqrt(d2 * d3) : 0.0;
        }
        return 0.0;
    }

    public static final boolean isHanZi(char ch) {
        return ch >= '\u4e00' && ch <= '\u9fa5';
    }

    public static short getGB2312Id(char ch) {
        byte[] byArray;
        block3: {
            try {
                byArray = Character.toString(ch).getBytes("GB2312");
                if (byArray.length == 2) break block3;
                return -1;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                return -1;
            }
        }
        int n = (byArray[0] & 0xFF) - 161;
        int n2 = (byArray[1] & 0xFF) - 161;
        return (short)(n * 94 + n2);
    }
}

