/*
 * Decompiled with CFR 0.152.
 */
package net.gbicc.xbrl.rule;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import net.gbicc.xbrl.core.Linkbase;
import net.gbicc.xbrl.core.TaxonomySet;
import net.gbicc.xbrl.core.XbrlConcept;
import net.gbicc.xbrl.core.XbrlDocument;
import net.gbicc.xbrl.core.XbrlInstance;
import net.gbicc.xbrl.core.messages.MessageManager;
import net.gbicc.xbrl.rule.RulePackage;
import org.apache.commons.lang.StringUtils;
import system.xml.schema.XmlSchemaSet;

public abstract class FormulaBuilder {
    protected TaxonomySet dts;
    protected XbrlInstance instance;
    protected Linkbase _linkbase;
    public static final String autoFormulaURI = "http://filling.roma.org/gen/formula.xml";
    protected static final boolean MoveAnalasysInferChangeItem = true;
    private Map<String, List<XbrlConcept>> a;
    private Map<String, List<XbrlConcept>> b;
    private boolean c = true;

    public boolean isAutoInfer() {
        return this.c;
    }

    public void setAutoInfer(boolean autoInfer) {
        this.c = autoInfer;
    }

    protected boolean isAxisAggregationProcessed(String roleURI, XbrlConcept axis) {
        List<XbrlConcept> list;
        if (roleURI == null || axis == null) {
            return true;
        }
        if (this.b != null && (list = this.b.get(roleURI)) != null) {
            return list.contains(axis);
        }
        return false;
    }

    protected void addAxisAggregationProcessed(String roleURI, XbrlConcept balance) {
        List<XbrlConcept> list;
        if (this.b == null) {
            this.b = new HashMap<String, List<XbrlConcept>>();
        }
        if ((list = this.b.get(roleURI)) == null) {
            list = new ArrayList<XbrlConcept>();
            this.b.put(roleURI, list);
        }
        if (!list.contains(balance)) {
            list.add(balance);
        }
    }

    protected boolean isMovementProcessed(String roleURI, XbrlConcept balance) {
        List<XbrlConcept> list;
        if (roleURI == null || balance == null) {
            return true;
        }
        if (this.a != null && (list = this.a.get(roleURI)) != null) {
            return list.contains(balance);
        }
        return false;
    }

    protected void addMovementProcessed(String roleURI, XbrlConcept balance) {
        List<XbrlConcept> list;
        if (this.a == null) {
            this.a = new HashMap<String, List<XbrlConcept>>();
        }
        if ((list = this.a.get(roleURI)) == null) {
            list = new ArrayList<XbrlConcept>();
            this.a.put(roleURI, list);
        }
        if (!list.contains(balance)) {
            list.add(balance);
        }
    }

    public void build(RulePackage rulePackage) {
        if (this.dts == null || this.instance == null) {
            return;
        }
    }

    protected static InputStream getStream(String resourceURI) {
        InputStream inputStream = MessageManager.class.getClassLoader().getResourceAsStream(resourceURI);
        try {
            if (inputStream == null) {
                URL uRL = MessageManager.class.getResource(resourceURI);
                URLConnection uRLConnection = uRL.openConnection();
                inputStream = uRLConnection.getInputStream();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return inputStream;
    }

    protected Linkbase createFormulaLinkbase() {
        if (this._linkbase == null) {
            XbrlDocument xbrlDocument = new XbrlDocument(autoFormulaURI, this.dts.getNameTable());
            InputStream inputStream = FormulaBuilder.getStream("/net/gbicc/xbrl/core/resources/SampleFormula.xml");
            try {
                xbrlDocument.load(inputStream);
                xbrlDocument.setSchemas((XmlSchemaSet)this.dts);
                this._linkbase = (Linkbase)xbrlDocument.getDocumentElement();
                String string = this.dts.getNamespaceOfPrefix("cas");
                if (!StringUtils.isEmpty((String)string)) {
                    this._linkbase.setAttribute("xmlns:cas", string);
                }
                if (!StringUtils.isEmpty((String)(string = this.dts.getNamespaceOfPrefix("ifrs")))) {
                    this._linkbase.setAttribute("xmlns:ifrs", string);
                }
                if (!StringUtils.isEmpty((String)(string = this.dts.getNamespaceOfPrefix("ifrs-full")))) {
                    this._linkbase.setAttribute("xmlns:ifrs-full", string);
                }
            }
            catch (XMLStreamException xMLStreamException) {
                xMLStreamException.printStackTrace();
            }
        }
        return this._linkbase;
    }
}

