/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.maven_replacer_plugin;

import com.google.code.maven_replacer_plugin.Replacement;
import com.google.code.maven_replacer_plugin.Replacer;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class TokenReplacer
implements Replacer {
    public String replace(String content, Replacement replacement, boolean regex, int regexFlags) {
        if (regex) {
            return this.replaceRegex(content, replacement.getToken(), replacement.getValue(), regexFlags);
        }
        return this.replaceNonRegex(content, replacement.getToken(), replacement.getValue());
    }

    private String replaceRegex(String content, String token, String value, int flags) {
        Pattern compiledPattern = flags == -1 ? Pattern.compile(token) : Pattern.compile(token, flags);
        return compiledPattern.matcher(content).replaceAll(StringUtils.defaultString((String)value));
    }

    private String replaceNonRegex(String content, String token, String value) {
        String valueToReplaceWith = StringUtils.defaultString((String)value);
        if (StringUtils.isEmpty((String)content)) {
            return content;
        }
        StringBuffer buffer = new StringBuffer();
        int start = 0;
        int end = 0;
        while ((end = content.indexOf(token, start)) >= 0) {
            buffer.append(content.substring(start, end));
            buffer.append(valueToReplaceWith);
            start = end + token.length();
        }
        return buffer.append(content.substring(start)).toString();
    }
}

