/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.mapper.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.annotation.builder.Builder;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.mapper.BaseMapper;
import org.beetl.sql.mapper.MapperInvoke;
import org.beetl.sql.mapper.annotation.AutoMapper;
import org.beetl.sql.mapper.builder.BaseMethodParser;
import org.beetl.sql.mapper.builder.MapperConfigBuilder;
import org.beetl.sql.mapper.builder.MapperMethodParser;

public class BaseMapperConfigBuilder
implements MapperConfigBuilder {
    protected final Map<MapperInvokeKey, MapperInvoke> amiMethodMap = new ConcurrentHashMap<MapperInvokeKey, MapperInvoke>();

    public BaseMapperConfigBuilder() {
        this.init();
    }

    @Override
    public MapperInvoke getAmi(Class entity, Class mapperClass, Method method) {
        MapperInvokeKey key = new MapperInvokeKey(method);
        return this.searchAmi(entity, mapperClass, key);
    }

    @Override
    public MapperInvoke getInheritAmi(Class entity, Class mapperClass, Method method) {
        MapperInvokeKey key = new MapperInvokeKey(mapperClass, method);
        return this.searchAmi(entity, mapperClass, key);
    }

    protected MapperInvoke searchAmi(Class entity, Class mapperClass, MapperInvokeKey key) {
        MapperInvoke mapperInvoke = this.amiMethodMap.get(key);
        if (mapperInvoke != null) {
            return mapperInvoke;
        }
        BaseMethodParser baseMethodParser = null;
        Builder builder = (Builder)BaseMapperConfigBuilder.getClassDeclaredAnnotation(mapperClass, Builder.class);
        if (builder != null) {
            Class cls = builder.value();
            baseMethodParser = (BaseMethodParser)BeanKit.newInstance((Class)cls);
        } else {
            baseMethodParser = new MapperMethodParser();
        }
        baseMethodParser.init(entity, mapperClass, key.m);
        mapperInvoke = baseMethodParser.parse();
        mapperInvoke = this.wrap(mapperInvoke, key.m);
        this.amiMethodMap.putIfAbsent(key, mapperInvoke);
        return mapperInvoke;
    }

    protected void init() {
        this.addMapperClass(BaseMapper.class);
    }

    @Override
    public void addMapperClass(Class c) {
        this.scanBaseMapper(c);
    }

    protected void scanBaseMapper(Class c) {
        Method[] methods;
        HashMap<MapperInvokeKey, MapperInvoke> map = new HashMap<MapperInvokeKey, MapperInvoke>();
        for (Method method : methods = c.getMethods()) {
            AutoMapper autoMapper = method.getAnnotation(AutoMapper.class);
            if (autoMapper == null) continue;
            Class<? extends MapperInvoke> mapperClass = autoMapper.value();
            MapperInvoke ins = (MapperInvoke)BeanKit.newSingleInstance(mapperClass);
            map.put(new MapperInvokeKey(method), this.wrap(ins, method));
        }
        if (map.isEmpty()) {
            return;
        }
        this.amiMethodMap.putAll(map);
    }

    protected MapperInvoke wrap(MapperInvoke old, Method method) {
        return old;
    }

    public static Annotation getClassDeclaredAnnotation(Class cls, Class expectAnnotation) {
        for (Annotation annotation : cls.getAnnotations()) {
            Object target = annotation.annotationType().getAnnotation(expectAnnotation);
            if (target == null) continue;
            return target;
        }
        Class<?>[] allParent = cls.getInterfaces();
        if (allParent == null || allParent.length == 0) {
            return null;
        }
        for (Class<?> parent : allParent) {
            Annotation target = BaseMapperConfigBuilder.getClassDeclaredAnnotation(parent, expectAnnotation);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    public static class MapperInvokeKey {
        public Class c;
        public Method m;

        public MapperInvokeKey(Class c, Method m) {
            this.c = c;
            this.m = m;
        }

        public MapperInvokeKey(Method m) {
            this.m = m;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapperInvokeKey that = (MapperInvokeKey)o;
            return Objects.equals(this.c, that.c) && this.m.equals(that.m);
        }

        public int hashCode() {
            return Objects.hash(this.c, this.m);
        }
    }
}

