/*
 * Decompiled with CFR 0.152.
 */
package com.pngencoder;

import com.pngencoder.PngEncoderLogic;
import com.pngencoder.PngEncoderPhysicalPixelDimensions;
import com.pngencoder.PngEncoderSrgbRenderingIntent;
import com.pngencoder.PngEncoderVerificationUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PngEncoder {
    public static int DEFAULT_COMPRESSION_LEVEL = 9;
    private final BufferedImage bufferedImage;
    private final int compressionLevel;
    private final boolean multiThreadedCompressionEnabled;
    private final PngEncoderSrgbRenderingIntent srgbRenderingIntent;
    private final PngEncoderPhysicalPixelDimensions physicalPixelDimensions;
    private final boolean usePredictorEncoding;
    private final boolean tryIndexedEncoding;

    private PngEncoder(BufferedImage bufferedImage, int compressionLevel, boolean multiThreadedCompressionEnabled, PngEncoderSrgbRenderingIntent srgbRenderingIntent, PngEncoderPhysicalPixelDimensions physicalPixelDimensions, boolean usePredictorEncoding, boolean tryIndexedEncoding) {
        this.bufferedImage = bufferedImage;
        this.compressionLevel = PngEncoderVerificationUtil.verifyCompressionLevel(compressionLevel);
        this.multiThreadedCompressionEnabled = multiThreadedCompressionEnabled;
        this.srgbRenderingIntent = srgbRenderingIntent;
        this.physicalPixelDimensions = physicalPixelDimensions;
        this.usePredictorEncoding = usePredictorEncoding;
        this.tryIndexedEncoding = tryIndexedEncoding;
    }

    public PngEncoder() {
        this(null, DEFAULT_COMPRESSION_LEVEL, true, null, null, false, false);
    }

    public PngEncoder withBufferedImage(BufferedImage bufferedImage) {
        return new PngEncoder(bufferedImage, this.compressionLevel, this.multiThreadedCompressionEnabled, this.srgbRenderingIntent, this.physicalPixelDimensions, this.usePredictorEncoding, this.tryIndexedEncoding);
    }

    public PngEncoder withCompressionLevel(int compressionLevel) {
        return new PngEncoder(this.bufferedImage, compressionLevel, this.multiThreadedCompressionEnabled, this.srgbRenderingIntent, this.physicalPixelDimensions, this.usePredictorEncoding, this.tryIndexedEncoding);
    }

    public PngEncoder withTryIndexedEncoding(boolean tryIndexedEncoding) {
        return new PngEncoder(this.bufferedImage, this.compressionLevel, this.multiThreadedCompressionEnabled, this.srgbRenderingIntent, this.physicalPixelDimensions, this.usePredictorEncoding, tryIndexedEncoding);
    }

    public PngEncoder withMultiThreadedCompressionEnabled(boolean multiThreadedCompressionEnabled) {
        return new PngEncoder(this.bufferedImage, this.compressionLevel, multiThreadedCompressionEnabled, this.srgbRenderingIntent, this.physicalPixelDimensions, this.usePredictorEncoding, this.tryIndexedEncoding);
    }

    public PngEncoder withSrgbRenderingIntent(PngEncoderSrgbRenderingIntent srgbRenderingIntent) {
        return new PngEncoder(this.bufferedImage, this.compressionLevel, this.multiThreadedCompressionEnabled, srgbRenderingIntent, this.physicalPixelDimensions, this.usePredictorEncoding, this.tryIndexedEncoding);
    }

    public PngEncoder withPhysicalPixelDimensions(PngEncoderPhysicalPixelDimensions physicalPixelDimensions) {
        return new PngEncoder(this.bufferedImage, this.compressionLevel, this.multiThreadedCompressionEnabled, this.srgbRenderingIntent, physicalPixelDimensions, this.usePredictorEncoding, this.tryIndexedEncoding);
    }

    public PngEncoder withPredictorEncoding(boolean usePredictorEncoding) {
        return new PngEncoder(this.bufferedImage, this.compressionLevel, this.multiThreadedCompressionEnabled, this.srgbRenderingIntent, this.physicalPixelDimensions, usePredictorEncoding, this.tryIndexedEncoding);
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public boolean isPredictorEncodingEnabled() {
        return this.usePredictorEncoding;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public boolean isMultiThreadedCompressionEnabled() {
        return this.multiThreadedCompressionEnabled;
    }

    public PngEncoderSrgbRenderingIntent getSrgbRenderingIntent() {
        return this.srgbRenderingIntent;
    }

    public int toStream(OutputStream outputStream) {
        try {
            return PngEncoderLogic.encode(this.bufferedImage, outputStream, this.compressionLevel, this.multiThreadedCompressionEnabled, this.srgbRenderingIntent, this.physicalPixelDimensions, this.isPredictorEncodingEnabled(), this.tryIndexedEncoding);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int toFile(Path filePath) {
        try (OutputStream outputStream = Files.newOutputStream(filePath, new OpenOption[0]);){
            int n = this.toStream(outputStream);
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int toFile(File file) {
        return this.toFile(file.toPath());
    }

    public int toFile(String fileName) {
        return this.toFile(Paths.get(fileName, new String[0]));
    }

    public byte[] toBytes() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(65536);
        this.toStream(outputStream);
        return outputStream.toByteArray();
    }
}

