/*
 * Decompiled with CFR 0.152.
 */
package com.pngencoder;

import com.pngencoder.PngEncoderDeflaterBuffer;
import java.util.LinkedList;
import java.util.Queue;

class PngEncoderDeflaterBufferPool {
    private final int bufferMaxLength;
    protected final Queue<PngEncoderDeflaterBuffer> buffers;

    PngEncoderDeflaterBufferPool(int bufferMaxLength) {
        this.bufferMaxLength = bufferMaxLength;
        this.buffers = new LinkedList<PngEncoderDeflaterBuffer>();
    }

    public int getBufferMaxLength() {
        return this.bufferMaxLength;
    }

    PngEncoderDeflaterBuffer borrow() {
        PngEncoderDeflaterBuffer buffer = this.buffers.poll();
        if (buffer == null) {
            buffer = new PngEncoderDeflaterBuffer(this, this.bufferMaxLength);
        }
        return buffer;
    }

    void giveBack(PngEncoderDeflaterBuffer buffer) {
        buffer.length = 0;
        this.buffers.offer(buffer);
    }

    int size() {
        return this.buffers.size();
    }
}

