/*
 * Decompiled with CFR 0.152.
 */
package com.pngencoder;

import com.pngencoder.PngEncoderDeflaterBuffer;
import com.pngencoder.PngEncoderDeflaterBufferPool;
import com.pngencoder.PngEncoderDeflaterExecutorService;
import com.pngencoder.PngEncoderDeflaterSegmentResult;
import com.pngencoder.PngEncoderDeflaterSegmentTask;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;

class PngEncoderDeflaterOutputStream
extends FilterOutputStream {
    static final int COUNT_MAX_QUEUED_TASKS = PngEncoderDeflaterExecutorService.NUM_THREADS_IS_AVAILABLE_PROCESSORS * 3;
    static final int COUNT_MAX_TOTAL_SEGMENTS = COUNT_MAX_QUEUED_TASKS * 3;
    static final int SEGMENT_MAX_LENGTH_DICTIONARY = 32768;
    static final int SEGMENT_MAX_LENGTH_ORIGINAL_MIN = 131072;
    private final PngEncoderDeflaterBufferPool pool;
    private final byte[] singleByte;
    private final int compressionLevel;
    private final int segmentMaxLengthOriginal;
    private final ConcurrentLinkedQueue<CompletableFuture<PngEncoderDeflaterSegmentResult>> resultQueue;
    private PngEncoderDeflaterBuffer originalSegment;
    private long adler32;
    private boolean finished;
    private boolean closed;

    public static int getSegmentMaxLengthOriginal(int totalOriginalBytesLength) {
        return Math.max(totalOriginalBytesLength / COUNT_MAX_TOTAL_SEGMENTS, 131072);
    }

    public static int getSegmentMaxLengthDeflated(int segmentMaxLengthOriginal) {
        return segmentMaxLengthOriginal + (segmentMaxLengthOriginal >> 3);
    }

    PngEncoderDeflaterOutputStream(OutputStream out, int compressionLevel, int segmentMaxLengthOriginal, PngEncoderDeflaterBufferPool pool) throws IOException {
        super(Objects.requireNonNull(out, "out"));
        this.pool = Objects.requireNonNull(pool, "pool");
        this.singleByte = new byte[1];
        this.compressionLevel = compressionLevel;
        this.segmentMaxLengthOriginal = segmentMaxLengthOriginal;
        this.resultQueue = new ConcurrentLinkedQueue();
        this.originalSegment = pool.borrow();
        this.adler32 = 1L;
        this.finished = false;
        this.closed = false;
        if (pool.getBufferMaxLength() != PngEncoderDeflaterOutputStream.getSegmentMaxLengthDeflated(segmentMaxLengthOriginal)) {
            throw new IllegalArgumentException("Mismatch between segmentMaxLengthOriginal and pool.");
        }
        PngEncoderDeflaterOutputStream.writeDeflateHeader(out, compressionLevel);
    }

    PngEncoderDeflaterOutputStream(OutputStream out, int compressionLevel, int segmentMaxLengthOriginal) throws IOException {
        this(out, compressionLevel, segmentMaxLengthOriginal, new PngEncoderDeflaterBufferPool(PngEncoderDeflaterOutputStream.getSegmentMaxLengthDeflated(segmentMaxLengthOriginal)));
    }

    @Override
    public void write(int b) throws IOException {
        this.singleByte[0] = (byte)(b & 0xFF);
        this.write(this.singleByte, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.finished) {
            throw new IOException("write beyond end of stream");
        }
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        while (len > 0) {
            int freeBufCount = this.segmentMaxLengthOriginal - this.originalSegment.length;
            if (freeBufCount == 0) {
                this.joinUntilMaximumQueueSize(COUNT_MAX_QUEUED_TASKS - 1);
                this.submitTask(false);
                continue;
            }
            int toCopyCount = Math.min(len, freeBufCount);
            System.arraycopy(b, off, this.originalSegment.bytes, this.originalSegment.length, toCopyCount);
            this.originalSegment.length += toCopyCount;
            off += toCopyCount;
            len -= toCopyCount;
        }
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        this.finished = true;
        try {
            this.submitTask(true);
            this.joinUntilMaximumQueueSize(0);
            this.out.write(ByteBuffer.allocate(4).putInt((int)this.adler32).array());
            this.out.flush();
        }
        finally {
            this.originalSegment.giveBack();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.finish();
        super.close();
    }

    void submitTask(boolean lastSegment) {
        PngEncoderDeflaterBuffer deflatedSegment = this.pool.borrow();
        PngEncoderDeflaterSegmentTask task = new PngEncoderDeflaterSegmentTask(this.originalSegment, deflatedSegment, this.compressionLevel, lastSegment);
        this.submitTask(task);
        this.originalSegment = this.pool.borrow();
    }

    void submitTask(PngEncoderDeflaterSegmentTask task) {
        CompletableFuture<PngEncoderDeflaterSegmentResult> future = CompletableFuture.supplyAsync(task, PngEncoderDeflaterExecutorService.getInstance());
        this.resultQueue.offer(future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void joinOne() throws IOException {
        CompletableFuture<PngEncoderDeflaterSegmentResult> resultFuture = this.resultQueue.poll();
        if (resultFuture != null) {
            PngEncoderDeflaterSegmentResult result;
            try {
                result = resultFuture.join();
            }
            catch (RuntimeException e) {
                throw new IOException("An async segment task failed.", e);
            }
            try {
                this.adler32 = result.getUpdatedAdler32(this.adler32);
                result.getDeflatedSegment().write(this.out);
            }
            finally {
                result.getOriginalSegment().giveBack();
                result.getDeflatedSegment().giveBack();
            }
        }
    }

    void joinUntilMaximumQueueSize(int maximumResultQueueSize) throws IOException {
        while (this.resultQueue.size() > maximumResultQueueSize) {
            this.joinOne();
        }
    }

    static void writeDeflateHeader(OutputStream outputStream, int compressionLevel) throws IOException {
        outputStream.write(120);
        byte flg = PngEncoderDeflaterOutputStream.getFlg(compressionLevel);
        outputStream.write(flg);
    }

    static byte getFlg(int compressionLevel) {
        if (compressionLevel == -1 || compressionLevel == 6) {
            return -100;
        }
        if (compressionLevel >= 0 && compressionLevel <= 1) {
            return 1;
        }
        if (compressionLevel >= 2 && compressionLevel <= 5) {
            return 94;
        }
        if (compressionLevel >= 7 && compressionLevel <= 9) {
            return -38;
        }
        throw new IllegalArgumentException("Invalid compressionLevel: " + compressionLevel);
    }
}

