/*
 * Decompiled with CFR 0.152.
 */
package com.pngencoder;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;

class PngEncoderIdatChunksOutputStream
extends FilterOutputStream {
    static final byte[] IDAT_BYTES = "IDAT".getBytes(StandardCharsets.US_ASCII);
    static final int DEFAULT_BUFFER_LENGTH = 32768;
    private final CRC32 crc = new CRC32();
    private final byte[] buf;
    private int count;

    PngEncoderIdatChunksOutputStream(OutputStream out, int bufferLength) {
        super(out);
        this.buf = new byte[bufferLength];
        this.count = 0;
    }

    PngEncoderIdatChunksOutputStream(OutputStream out) {
        this(out, 32768);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.flushBuffer();
            this.writeIdatChunk(b, off, len);
            return;
        }
        if (len > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        super.flush();
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.writeIdatChunk(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    private void writeIdatChunk(byte[] b, int off, int len) throws IOException {
        this.writeInt(len);
        this.out.write(IDAT_BYTES);
        this.out.write(b, off, len);
        this.crc.reset();
        this.crc.update(IDAT_BYTES, 0, IDAT_BYTES.length);
        this.crc.update(b, off, len);
        this.writeInt((int)this.crc.getValue());
    }

    private void writeInt(int i) throws IOException {
        this.out.write((byte)(i >> 24) & 0xFF);
        this.out.write((byte)(i >> 16) & 0xFF);
        this.out.write((byte)(i >> 8) & 0xFF);
        this.out.write((byte)i & 0xFF);
    }
}

