/*
 * Decompiled with CFR 0.152.
 */
package com.pngencoder;

import com.pngencoder.PngEncoderCountingOutputStream;
import com.pngencoder.PngEncoderDeflaterOutputStream;
import com.pngencoder.PngEncoderIdatChunksOutputStream;
import com.pngencoder.PngEncoderIndexed;
import com.pngencoder.PngEncoderPhysicalPixelDimensions;
import com.pngencoder.PngEncoderPredictor;
import com.pngencoder.PngEncoderScanlineUtil;
import com.pngencoder.PngEncoderSrgbRenderingIntent;
import com.pngencoder.PngEncoderVerificationUtil;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

class PngEncoderLogic {
    static final byte[] FILE_BEGINNING = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    static final byte[] FILE_ENDING = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    static final byte IHDR_COLOR_TYPE_GREY = 0;
    static final byte IHDR_COLOR_TYPE_RGB = 2;
    static final byte IHDR_COLOR_TYPE_INDEXED = 3;
    static final byte IHDR_COLOR_TYPE_GREY_ALPHA = 4;
    static final byte IHDR_COLOR_TYPE_RGBA = 6;
    static final byte IHDR_COMPRESSION_METHOD = 0;
    static final byte IHDR_FILTER_METHOD = 0;
    static final byte IHDR_INTERLACE_METHOD = 0;
    public static final byte[] GAMA_SRGB_VALUE = ByteBuffer.allocate(4).putInt(45455).array();
    public static final byte[] CHRM_SRGB_VALUE = ByteBuffer.allocate(32).putInt(31270).putInt(32900).putInt(64000).putInt(33000).putInt(30000).putInt(60000).putInt(15000).putInt(6000).array();

    private PngEncoderLogic() {
    }

    private static void encodeWithCompressorStream(boolean multiThreadedCompressionEnabled, int compressionLevel, BufferedImage bufferedImage, PngEncoderScanlineUtil.EncodingMetaInfo metaInfo, OutputStream outputStream, IDoWithDeflaterStream action) throws IOException {
        int segmentMaxLengthOriginal;
        int estimatedBytes = metaInfo.rowByteSize * bufferedImage.getHeight();
        if (estimatedBytes <= (segmentMaxLengthOriginal = PngEncoderDeflaterOutputStream.getSegmentMaxLengthOriginal(estimatedBytes)) || !multiThreadedCompressionEnabled) {
            Deflater deflater = new Deflater(compressionLevel);
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(outputStream, deflater);
            action.encodeImageData(false, deflaterOutputStream);
            deflaterOutputStream.finish();
            deflaterOutputStream.flush();
            deflater.end();
        } else {
            PngEncoderDeflaterOutputStream deflaterOutputStream = new PngEncoderDeflaterOutputStream(outputStream, compressionLevel, segmentMaxLengthOriginal);
            action.encodeImageData(true, deflaterOutputStream);
            deflaterOutputStream.finish();
        }
    }

    static int encode(BufferedImage bufferedImage, OutputStream outputStream, int compressionLevel, boolean multiThreadedCompressionEnabled, PngEncoderSrgbRenderingIntent srgbRenderingIntent, PngEncoderPhysicalPixelDimensions physicalPixelDimensions, boolean usePredictor, boolean tryIndexedEncoding) throws IOException {
        Objects.requireNonNull(bufferedImage, "bufferedImage");
        Objects.requireNonNull(outputStream, "outputStream");
        PngEncoderScanlineUtil.EncodingMetaInfo metaInfo = PngEncoderScanlineUtil.getEncodingMetaInfo(bufferedImage);
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        PngEncoderCountingOutputStream countingOutputStream = new PngEncoderCountingOutputStream(outputStream);
        countingOutputStream.write(FILE_BEGINNING);
        PngEncoderIndexed.IndexedEncoderResult indexedEncoderResult = null;
        if (bufferedImage.getType() == 13) {
            indexedEncoderResult = PngEncoderIndexed.encodeImageFromIndexed(bufferedImage, metaInfo);
        } else if (tryIndexedEncoding) {
            indexedEncoderResult = PngEncoderIndexed.encodeImage(bufferedImage, metaInfo);
        }
        byte[] ihdr = PngEncoderLogic.getIhdrHeader(width, height, metaInfo);
        byte[] ihdrChunk = PngEncoderLogic.asChunk("IHDR", ihdr);
        countingOutputStream.write(ihdrChunk);
        if (srgbRenderingIntent != null && metaInfo.colorProfile == null) {
            outputStream.write(PngEncoderLogic.asChunk("sRGB", new byte[]{srgbRenderingIntent.getValue()}));
            outputStream.write(PngEncoderLogic.asChunk("gAMA", GAMA_SRGB_VALUE));
            outputStream.write(PngEncoderLogic.asChunk("cHRM", CHRM_SRGB_VALUE));
        }
        if (physicalPixelDimensions != null) {
            outputStream.write(PngEncoderLogic.asChunk("pHYs", PngEncoderLogic.getPhysicalPixelDimensions(physicalPixelDimensions)));
        }
        if (metaInfo.colorProfile != null) {
            byte[] iCCP = PngEncoderLogic.getICCP(metaInfo.colorProfile);
            outputStream.write(PngEncoderLogic.asChunk("iCCP", iCCP));
        }
        PngEncoderIdatChunksOutputStream idatChunksOutputStream = new PngEncoderIdatChunksOutputStream(countingOutputStream);
        if (indexedEncoderResult != null) {
            outputStream.write(PngEncoderLogic.asChunk("PLTE", indexedEncoderResult.colorTable));
            if (indexedEncoderResult.transparencyTable != null) {
                outputStream.write(PngEncoderLogic.asChunk("tRNS", indexedEncoderResult.transparencyTable));
            }
            byte[] rawIDAT = indexedEncoderResult.rawIDAT;
            PngEncoderLogic.encodeWithCompressorStream(multiThreadedCompressionEnabled, compressionLevel, bufferedImage, metaInfo, idatChunksOutputStream, (isMultithreaded, out) -> out.write(rawIDAT));
        } else if (usePredictor) {
            PngEncoderLogic.encodeWithCompressorStream(multiThreadedCompressionEnabled, compressionLevel, bufferedImage, metaInfo, idatChunksOutputStream, (isMultithreaded, out) -> {
                if (isMultithreaded) {
                    PngEncoderPredictor.encodeImageMultiThreaded(bufferedImage, metaInfo, out);
                } else {
                    PngEncoderPredictor.encodeImageSingleThreaded(bufferedImage, metaInfo, out);
                }
            });
        } else {
            PngEncoderLogic.encodeWithCompressorStream(multiThreadedCompressionEnabled, compressionLevel, bufferedImage, metaInfo, idatChunksOutputStream, (isMultithreaded, out) -> PngEncoderScanlineUtil.stream(bufferedImage, 0, bufferedImage.getHeight(), new PngEncoderScanlineUtil.AbstractPNGLineConsumer(){

                @Override
                void consume(byte[] currRow, byte[] prevRow) throws IOException {
                    out.write(currRow);
                }
            }));
        }
        countingOutputStream.write(FILE_ENDING);
        countingOutputStream.flush();
        return countingOutputStream.getCount();
    }

    private static byte[] getICCP(ICC_Profile colorProfile) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String name = PngEncoderLogic.getProfileName(colorProfile);
        byte[] nameBytes = name.getBytes(StandardCharsets.ISO_8859_1);
        int nameByteWriteLen = Math.min(nameBytes.length, 79);
        out.write(nameBytes, 0, nameByteWriteLen);
        out.write(0);
        out.write(0);
        try (DeflaterOutputStream compressStream = new DeflaterOutputStream(out);){
            compressStream.write(colorProfile.getData());
        }
        return out.toByteArray();
    }

    private static String getProfileName(ICC_Profile profile) {
        int startIdx;
        int c;
        int endIdx;
        byte[] data = profile.getData(1684370275);
        if (data == null) {
            return "<noname>";
        }
        for (endIdx = startIdx = 12; endIdx < data.length && (c = data[endIdx]) != 0; ++endIdx) {
        }
        if (endIdx != startIdx) {
            return new String(data, startIdx, endIdx - startIdx, StandardCharsets.US_ASCII);
        }
        startIdx = 29;
        endIdx = 29;
        while (endIdx + 1 < data.length && (c = (data[endIdx] & 0xFF) + (data[endIdx] & 0xFF)) != 0) {
            endIdx += 2;
        }
        if (endIdx != startIdx) {
            return new String(data, startIdx, endIdx - startIdx, StandardCharsets.UTF_16LE);
        }
        return "<unnamed>";
    }

    static byte[] getIhdrHeader(int width, int height, PngEncoderScanlineUtil.EncodingMetaInfo metaInfo) {
        ByteBuffer buffer = ByteBuffer.allocate(13);
        buffer.putInt(width);
        buffer.putInt(height);
        buffer.put((byte)metaInfo.bitsPerChannel);
        switch (metaInfo.colorSpaceType) {
            case Rgb: {
                buffer.put(metaInfo.hasAlpha ? (byte)6 : 2);
                break;
            }
            case Gray: {
                buffer.put(metaInfo.hasAlpha ? (byte)4 : 0);
                break;
            }
            case Indexed: {
                buffer.put((byte)3);
            }
        }
        buffer.put((byte)0);
        buffer.put((byte)0);
        buffer.put((byte)0);
        return buffer.array();
    }

    static byte[] getPhysicalPixelDimensions(PngEncoderPhysicalPixelDimensions physicalPixelDimensions) {
        ByteBuffer buffer = ByteBuffer.allocate(9);
        buffer.putInt(physicalPixelDimensions.getPixelsPerUnitX());
        buffer.putInt(physicalPixelDimensions.getPixelsPerUnitY());
        buffer.put(physicalPixelDimensions.getUnit().getValue());
        return buffer.array();
    }

    static byte[] asChunk(String type, byte[] data) {
        PngEncoderVerificationUtil.verifyChunkType(type);
        ByteBuffer byteBuffer = ByteBuffer.allocate(data.length + 12);
        byteBuffer.putInt(data.length);
        ByteBuffer byteBufferForCrc = byteBuffer.slice().asReadOnlyBuffer();
        byteBufferForCrc.limit(4 + data.length);
        byteBuffer.put(type.getBytes(StandardCharsets.US_ASCII));
        byteBuffer.put(data);
        byteBuffer.putInt(PngEncoderLogic.getCrc32(byteBufferForCrc));
        return byteBuffer.array();
    }

    static int getCrc32(ByteBuffer byteBuffer) {
        CRC32 crc = new CRC32();
        crc.update(byteBuffer);
        return (int)crc.getValue();
    }

    @FunctionalInterface
    private static interface IDoWithDeflaterStream {
        public void encodeImageData(boolean var1, OutputStream var2) throws IOException;
    }
}

