/*
 * Decompiled with CFR 0.152.
 */
package com.pngencoder;

public class PngEncoderPhysicalPixelDimensions {
    private static final float INCHES_PER_METER = 39.37008f;
    private final int pixelsPerUnitX;
    private final int pixelsPerUnitY;
    private final Unit unit;

    private PngEncoderPhysicalPixelDimensions(int pixelsPerUnitX, int pixelsPerUnitY, Unit unit) {
        this.pixelsPerUnitX = pixelsPerUnitX;
        this.pixelsPerUnitY = pixelsPerUnitY;
        this.unit = unit;
    }

    public static PngEncoderPhysicalPixelDimensions pixelsPerMeter(int pixelsPerMeterX, int pixelsPerMeterY) {
        return new PngEncoderPhysicalPixelDimensions(pixelsPerMeterX, pixelsPerMeterY, Unit.METER);
    }

    public static PngEncoderPhysicalPixelDimensions pixelsPerMeter(int pixelsPerMeter) {
        return PngEncoderPhysicalPixelDimensions.pixelsPerMeter(pixelsPerMeter, pixelsPerMeter);
    }

    public static PngEncoderPhysicalPixelDimensions dotsPerInch(int dotsPerInchX, int dotsPerInchY) {
        int pixelsPerMeterX = Math.round((float)dotsPerInchX * 39.37008f);
        int pixelsPerMeterY = Math.round((float)dotsPerInchY * 39.37008f);
        return new PngEncoderPhysicalPixelDimensions(pixelsPerMeterX, pixelsPerMeterY, Unit.METER);
    }

    public static PngEncoderPhysicalPixelDimensions dotsPerInch(int dotsPerInch) {
        return PngEncoderPhysicalPixelDimensions.dotsPerInch(dotsPerInch, dotsPerInch);
    }

    public static PngEncoderPhysicalPixelDimensions aspectRatio(int pixelsPerUnitX, int pixelsPerUnitY) {
        return new PngEncoderPhysicalPixelDimensions(pixelsPerUnitX, pixelsPerUnitY, Unit.UNKNOWN);
    }

    public int getPixelsPerUnitX() {
        return this.pixelsPerUnitX;
    }

    public int getPixelsPerUnitY() {
        return this.pixelsPerUnitY;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public static enum Unit {
        UNKNOWN(0),
        METER(1);

        private final byte value;

        private Unit(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

