/*
 * Decompiled with CFR 0.152.
 */
package com.pngencoder;

import com.pngencoder.PngEncoderBufferedImageType;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;

class PngEncoderScanlineUtil {
    private PngEncoderScanlineUtil() {
    }

    static EncodingMetaInfo getEncodingMetaInfo(BufferedImage bufferedImage) {
        EncodingMetaInfo info = new EncodingMetaInfo();
        int width = bufferedImage.getWidth();
        PngEncoderBufferedImageType type = PngEncoderBufferedImageType.valueOf(bufferedImage);
        ColorSpace colorSpace = bufferedImage.getColorModel().getColorSpace();
        if (!colorSpace.isCS_sRGB() && colorSpace instanceof ICC_ColorSpace) {
            info.colorProfile = ((ICC_ColorSpace)colorSpace).getProfile();
        }
        info.colorSpaceType = !colorSpace.isCS_sRGB() && colorSpace instanceof ICC_ColorSpace && colorSpace.getType() == 6 ? EncodingMetaInfo.ColorSpaceType.Gray : EncodingMetaInfo.ColorSpaceType.Rgb;
        switch (type) {
            case TYPE_INT_ARGB: 
            case TYPE_INT_ARGB_PRE: 
            case TYPE_4BYTE_ABGR: 
            case TYPE_4BYTE_ABGR_PRE: {
                info.channels = 4;
                info.bytesPerPixel = 4;
                info.hasAlpha = true;
                break;
            }
            case TYPE_INT_BGR: 
            case TYPE_3BYTE_BGR: 
            case TYPE_USHORT_565_RGB: 
            case TYPE_USHORT_555_RGB: 
            case TYPE_INT_RGB: {
                info.channels = 3;
                info.bytesPerPixel = 3;
                break;
            }
            case TYPE_BYTE_GRAY: {
                info.channels = 1;
                info.bytesPerPixel = 1;
                break;
            }
            case TYPE_USHORT_GRAY: {
                info.channels = 1;
                info.bytesPerPixel = 2;
                info.bitsPerChannel = 16;
                break;
            }
            default: {
                boolean bl = info.hasAlpha = bufferedImage.getTransparency() != 1;
                if (!info.hasAlpha) {
                    info.channels = 3;
                    info.bytesPerPixel = 3;
                } else {
                    info.channels = 4;
                    info.bytesPerPixel = 4;
                }
                boolean needToFallBackTosRGB = !colorSpace.isCS_sRGB() && colorSpace instanceof ICC_ColorSpace && colorSpace.getType() != 5 && colorSpace.getType() != 6;
                boolean canICCBeHandled = false;
                if (!needToFallBackTosRGB && bufferedImage.getRaster().getDataBuffer().getDataType() == 1) {
                    info.channels = bufferedImage.getRaster().getSampleModel().getNumBands();
                    info.bytesPerPixel = info.channels * 2;
                    info.bitsPerChannel = 16;
                    canICCBeHandled = true;
                }
                if (!needToFallBackTosRGB && bufferedImage.getRaster().getDataBuffer().getDataType() == 3 && bufferedImage.getSampleModel().getSampleSize(0) == 8) {
                    canICCBeHandled = true;
                }
                if (canICCBeHandled) break;
                info.colorProfile = null;
            }
        }
        info.rowByteSize = 1 + info.bytesPerPixel * width;
        return info;
    }

    static byte[] get(BufferedImage bufferedImage) throws IOException {
        int height = bufferedImage.getHeight();
        EncodingMetaInfo encodingMetaInfo = PngEncoderScanlineUtil.getEncodingMetaInfo(bufferedImage);
        ByteBufferPNGLineConsumer consumer = new ByteBufferPNGLineConsumer(encodingMetaInfo.rowByteSize * height);
        PngEncoderScanlineUtil.stream(bufferedImage, 0, height, consumer);
        return consumer.bytes;
    }

    static void stream(BufferedImage bufferedImage, int yStart, int heightToStream, AbstractPNGLineConsumer consumer) throws IOException {
        int width = bufferedImage.getWidth();
        int imageHeight = bufferedImage.getHeight();
        assert (heightToStream <= imageHeight - yStart);
        PngEncoderBufferedImageType type = PngEncoderBufferedImageType.valueOf(bufferedImage);
        WritableRaster raster = bufferedImage.getRaster();
        switch (type) {
            case TYPE_INT_RGB: {
                PngEncoderScanlineUtil.getIntRgb(raster, yStart, width, heightToStream, consumer);
                break;
            }
            case TYPE_INT_ARGB: {
                PngEncoderScanlineUtil.getIntArgb(raster, yStart, width, heightToStream, false, consumer);
                break;
            }
            case TYPE_INT_ARGB_PRE: {
                PngEncoderScanlineUtil.getIntArgb(raster, yStart, width, heightToStream, true, consumer);
                break;
            }
            case TYPE_INT_BGR: {
                PngEncoderScanlineUtil.getIntBgr(raster, yStart, width, heightToStream, consumer);
                break;
            }
            case TYPE_3BYTE_BGR: {
                PngEncoderScanlineUtil.get3ByteBgr(raster, yStart, width, heightToStream, consumer);
                break;
            }
            case TYPE_4BYTE_ABGR: {
                PngEncoderScanlineUtil.get4ByteAbgr(raster, yStart, width, heightToStream, false, consumer);
                break;
            }
            case TYPE_4BYTE_ABGR_PRE: {
                PngEncoderScanlineUtil.get4ByteAbgr(raster, yStart, width, heightToStream, true, consumer);
                break;
            }
            case TYPE_BYTE_GRAY: {
                PngEncoderScanlineUtil.getByteGray(bufferedImage, yStart, width, heightToStream, consumer);
                break;
            }
            case TYPE_USHORT_GRAY: {
                PngEncoderScanlineUtil.getUshortGray(bufferedImage, yStart, width, heightToStream, consumer);
                break;
            }
            case TYPE_BYTE_INDEXED: {
                PngEncoderScanlineUtil.getFallback(bufferedImage, yStart, width, heightToStream, consumer);
                break;
            }
            default: {
                if (raster.getDataBuffer() instanceof DataBufferUShort && PngEncoderScanlineUtil.getUshortGenericDataBufferUShort(bufferedImage, yStart, width, heightToStream, consumer) || raster.getDataBuffer().getDataType() == 1 && PngEncoderScanlineUtil.getUshortGeneric(bufferedImage, yStart, width, heightToStream, consumer) || raster.getDataBuffer().getDataType() == 0 && PngEncoderScanlineUtil.getByteGeneric(bufferedImage, yStart, width, heightToStream, consumer) || raster.getDataBuffer().getDataType() == 3 && PngEncoderScanlineUtil.getIntGeneric(bufferedImage, yStart, width, heightToStream, consumer)) break;
                PngEncoderScanlineUtil.getFallback(bufferedImage, yStart, width, heightToStream, consumer);
            }
        }
    }

    private static void getFallback(BufferedImage bufferedImage, int yStart, int width, int heightToStream, AbstractPNGLineConsumer consumer) throws IOException {
        int[] elements = bufferedImage.getRGB(0, yStart, width, heightToStream, null, 0, width);
        if (bufferedImage.getTransparency() == 1) {
            PngEncoderScanlineUtil.getIntRgb(elements, yStart, width, heightToStream, consumer);
        } else {
            PngEncoderScanlineUtil.getIntArgb(elements, yStart, width, heightToStream, consumer);
        }
    }

    static void getIntRgb(int[] elements, int yStart, int width, int height, AbstractPNGLineConsumer consumer) throws IOException {
        int channels = 3;
        int rowByteSize = 1 + 3 * width;
        byte[] currLine = new byte[rowByteSize];
        byte[] prevLine = new byte[rowByteSize];
        for (int y = yStart; y < yStart + height; ++y) {
            int yOffset = y * width;
            int rowByteOffset = 1;
            for (int x = 0; x < width; ++x) {
                int element = elements[yOffset + x];
                currLine[rowByteOffset++] = (byte)(element >> 16);
                currLine[rowByteOffset++] = (byte)(element >> 8);
                currLine[rowByteOffset++] = (byte)element;
            }
            consumer.consume(currLine, prevLine);
            byte[] b = currLine;
            currLine = prevLine;
            prevLine = b;
        }
    }

    static void getIntArgb(int[] elements, int yStart, int width, int height, AbstractPNGLineConsumer consumer) throws IOException {
        int channels = 4;
        int rowByteSize = 1 + 4 * width;
        byte[] currLine = new byte[rowByteSize];
        byte[] prevLine = new byte[rowByteSize];
        for (int y = yStart; y < yStart + height; ++y) {
            int yOffset = y * width;
            int rowByteOffset = 1;
            for (int x = 0; x < width; ++x) {
                int element = elements[yOffset + x];
                currLine[rowByteOffset++] = (byte)(element >> 16);
                currLine[rowByteOffset++] = (byte)(element >> 8);
                currLine[rowByteOffset++] = (byte)element;
                currLine[rowByteOffset++] = (byte)(element >> 24);
            }
            consumer.consume(currLine, prevLine);
            byte[] b = currLine;
            currLine = prevLine;
            prevLine = b;
        }
    }

    static void getIntRgb(WritableRaster imageRaster, int yStart, int width, int heightToStream, AbstractPNGLineConsumer consumer) throws IOException {
        int channels = 3;
        int rowByteSize = 1 + 3 * width;
        byte[] currLine = new byte[rowByteSize];
        byte[] prevLine = new byte[rowByteSize];
        if (imageRaster.getSampleModel() instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel sampleModel = (SinglePixelPackedSampleModel)imageRaster.getSampleModel();
            int scanlineStride = sampleModel.getScanlineStride();
            assert (sampleModel.getNumBands() == 3);
            assert (sampleModel.getBitOffsets()[0] == 16);
            assert (sampleModel.getBitOffsets()[1] == 8);
            assert (sampleModel.getBitOffsets()[2] == 0);
            int[] rawInts = ((DataBufferInt)imageRaster.getDataBuffer()).getData();
            int linePtr = scanlineStride * (yStart - imageRaster.getSampleModelTranslateY()) - imageRaster.getSampleModelTranslateX();
            for (int y = 0; y < heightToStream; ++y) {
                int pixelPtr = linePtr;
                int pixelEndPtr = linePtr + width;
                int rowByteOffset = 1;
                while (pixelPtr < pixelEndPtr) {
                    int element = rawInts[pixelPtr++];
                    currLine[rowByteOffset++] = (byte)(element >> 16);
                    currLine[rowByteOffset++] = (byte)(element >> 8);
                    currLine[rowByteOffset++] = (byte)element;
                }
                linePtr += scanlineStride;
                consumer.consume(currLine, prevLine);
                byte[] b = currLine;
                currLine = prevLine;
                prevLine = b;
            }
        } else {
            throw new IllegalStateException("TYPE_INT_RGB must have a SinglePixelPackedSampleModel");
        }
    }

    static void getIntArgb(WritableRaster imageRaster, int yStart, int width, int heightToStream, boolean preMultipliedAlpha, AbstractPNGLineConsumer consumer) throws IOException {
        int channels = 4;
        int rowByteSize = 1 + 4 * width;
        byte[] currLine = new byte[rowByteSize];
        byte[] prevLine = new byte[rowByteSize];
        if (imageRaster.getSampleModel() instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel sampleModel = (SinglePixelPackedSampleModel)imageRaster.getSampleModel();
            int scanlineStride = sampleModel.getScanlineStride();
            assert (sampleModel.getNumBands() == 4);
            assert (sampleModel.getBitOffsets()[0] == 16);
            assert (sampleModel.getBitOffsets()[1] == 8);
            assert (sampleModel.getBitOffsets()[2] == 0);
            assert (sampleModel.getBitOffsets()[3] == 24);
            int[] rawInts = ((DataBufferInt)imageRaster.getDataBuffer()).getData();
            int linePtr = scanlineStride * (yStart - imageRaster.getSampleModelTranslateY()) - imageRaster.getSampleModelTranslateX();
            for (int y = 0; y < heightToStream; ++y) {
                int pixelPtr = linePtr;
                int rowByteOffset = 1;
                for (int x = 0; x < width; ++x) {
                    int element = rawInts[pixelPtr++];
                    byte r = (byte)(element >> 16);
                    byte g = (byte)(element >> 8);
                    byte b = (byte)element;
                    byte a = (byte)(element >> 24);
                    if (preMultipliedAlpha && a != 0 && a != -1) {
                        double normalizedInverseAlpha = 1.0 / ((double)(a & 0xFF) / 255.0);
                        r = (byte)((double)(r & 0xFF) * normalizedInverseAlpha + 0.5);
                        g = (byte)((double)(g & 0xFF) * normalizedInverseAlpha + 0.5);
                        b = (byte)((double)(b & 0xFF) * normalizedInverseAlpha + 0.5);
                    }
                    currLine[rowByteOffset++] = r;
                    currLine[rowByteOffset++] = g;
                    currLine[rowByteOffset++] = b;
                    currLine[rowByteOffset++] = a;
                }
                linePtr += scanlineStride;
                consumer.consume(currLine, prevLine);
                byte[] b = currLine;
                currLine = prevLine;
                prevLine = b;
            }
        } else {
            throw new IllegalStateException("TYPE_INT_RGB must have a SinglePixelPackedSampleModel");
        }
    }

    static void getIntBgr(WritableRaster imageRaster, int yStart, int width, int heightToStream, AbstractPNGLineConsumer consumer) throws IOException {
        int channels = 3;
        int rowByteSize = 1 + 3 * width;
        byte[] currLine = new byte[rowByteSize];
        byte[] prevLine = new byte[rowByteSize];
        if (imageRaster.getSampleModel() instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel sampleModel = (SinglePixelPackedSampleModel)imageRaster.getSampleModel();
            int scanlineStride = sampleModel.getScanlineStride();
            assert (sampleModel.getNumBands() == 3);
            assert (sampleModel.getBitOffsets()[0] == 0);
            assert (sampleModel.getBitOffsets()[1] == 8);
            assert (sampleModel.getBitOffsets()[2] == 16);
            int[] rawInts = ((DataBufferInt)imageRaster.getDataBuffer()).getData();
            int linePtr = scanlineStride * (yStart - imageRaster.getSampleModelTranslateY()) - imageRaster.getSampleModelTranslateX();
            for (int y = 0; y < heightToStream; ++y) {
                int pixelPtr = linePtr;
                int rowByteOffset = 1;
                for (int x = 0; x < width; ++x) {
                    int element = rawInts[pixelPtr++];
                    currLine[rowByteOffset++] = (byte)element;
                    currLine[rowByteOffset++] = (byte)(element >> 8);
                    currLine[rowByteOffset++] = (byte)(element >> 16);
                }
                linePtr += scanlineStride;
                consumer.consume(currLine, prevLine);
                byte[] b = currLine;
                currLine = prevLine;
                prevLine = b;
            }
        } else {
            throw new IllegalStateException("TYPE_INT_BGR must have a SinglePixelPackedSampleModel");
        }
    }

    static void get3ByteBgr(WritableRaster imageRaster, int yStart, int width, int heightToStream, AbstractPNGLineConsumer consumer) throws IOException {
        int channels = 3;
        int rowByteSize = 1 + 3 * width;
        byte[] currLine = new byte[rowByteSize];
        byte[] prevLine = new byte[rowByteSize];
        DataBufferByte dataBufferByte = (DataBufferByte)imageRaster.getDataBuffer();
        if (imageRaster.getSampleModel() instanceof PixelInterleavedSampleModel) {
            PixelInterleavedSampleModel sampleModel = (PixelInterleavedSampleModel)imageRaster.getSampleModel();
            byte[] rawBytes = dataBufferByte.getData();
            int scanlineStride = sampleModel.getScanlineStride();
            int pixelStride = sampleModel.getPixelStride();
            assert (pixelStride == 3);
            int linePtr = scanlineStride * (yStart - imageRaster.getSampleModelTranslateY()) - imageRaster.getSampleModelTranslateX() * pixelStride;
            for (int y = 0; y < heightToStream; ++y) {
                int pixelPtr = linePtr;
                int writePtr = 1;
                for (int x = 0; x < width; ++x) {
                    byte b = rawBytes[pixelPtr++];
                    byte g = rawBytes[pixelPtr++];
                    byte r = rawBytes[pixelPtr++];
                    currLine[writePtr++] = r;
                    currLine[writePtr++] = g;
                    currLine[writePtr++] = b;
                }
                linePtr += scanlineStride;
                consumer.consume(currLine, prevLine);
                byte[] b = currLine;
                currLine = prevLine;
                prevLine = b;
            }
        } else {
            throw new IllegalStateException("3ByteBgr must have a PixelInterleavedSampleModel");
        }
    }

    static void get4ByteAbgr(WritableRaster imageRaster, int yStart, int width, int heightToStream, boolean preMultipliedAlpha, AbstractPNGLineConsumer consumer) throws IOException {
        int channels = 4;
        int rowByteSize = 1 + 4 * width;
        byte[] currLine = new byte[rowByteSize];
        byte[] prevLine = new byte[rowByteSize];
        DataBufferByte dataBufferByte = (DataBufferByte)imageRaster.getDataBuffer();
        if (imageRaster.getSampleModel() instanceof PixelInterleavedSampleModel) {
            PixelInterleavedSampleModel sampleModel = (PixelInterleavedSampleModel)imageRaster.getSampleModel();
            byte[] rawBytes = dataBufferByte.getData();
            int scanlineStride = sampleModel.getScanlineStride();
            int pixelStride = sampleModel.getPixelStride();
            assert (pixelStride == 4);
            int linePtr = scanlineStride * (yStart - imageRaster.getSampleModelTranslateY()) - imageRaster.getSampleModelTranslateX() * pixelStride;
            for (int y = 0; y < heightToStream; ++y) {
                int pixelPtr = linePtr;
                int writePtr = 1;
                for (int x = 0; x < width; ++x) {
                    byte a = rawBytes[pixelPtr++];
                    byte b = rawBytes[pixelPtr++];
                    byte g = rawBytes[pixelPtr++];
                    byte r = rawBytes[pixelPtr++];
                    if (preMultipliedAlpha && a != 0 && a != -1) {
                        double normalizedInverseAlpha = 1.0 / ((double)(a & 0xFF) / 255.0);
                        r = (byte)((double)(r & 0xFF) * normalizedInverseAlpha + 0.5);
                        g = (byte)((double)(g & 0xFF) * normalizedInverseAlpha + 0.5);
                        b = (byte)((double)(b & 0xFF) * normalizedInverseAlpha + 0.5);
                    }
                    currLine[writePtr++] = r;
                    currLine[writePtr++] = g;
                    currLine[writePtr++] = b;
                    currLine[writePtr++] = a;
                }
                linePtr += scanlineStride;
                consumer.consume(currLine, prevLine);
                byte[] b = currLine;
                currLine = prevLine;
                prevLine = b;
            }
        } else {
            throw new IllegalStateException("4ByteAbgr must have a PixelInterleavedSampleModel");
        }
    }

    static void getByteGray(BufferedImage image, int yStart, int width, int heightToStream, AbstractPNGLineConsumer consumer) throws IOException {
        WritableRaster imageRaster = image.getRaster();
        boolean channels = true;
        int rowByteSize = 1 + 1 * width;
        byte[] currLine = new byte[rowByteSize];
        byte[] prevLine = new byte[rowByteSize];
        DataBufferByte dataBufferByte = (DataBufferByte)imageRaster.getDataBuffer();
        if (imageRaster.getSampleModel() instanceof PixelInterleavedSampleModel) {
            PixelInterleavedSampleModel sampleModel = (PixelInterleavedSampleModel)imageRaster.getSampleModel();
            byte[] rawBytes = dataBufferByte.getData();
            int scanlineStride = sampleModel.getScanlineStride();
            int pixelStride = sampleModel.getPixelStride();
            assert (pixelStride == 1);
            int linePtr = scanlineStride * (yStart - imageRaster.getSampleModelTranslateY()) - imageRaster.getSampleModelTranslateX() * pixelStride;
            for (int y = 0; y < heightToStream; ++y) {
                int pixelPtr = linePtr;
                System.arraycopy(rawBytes, pixelPtr, currLine, 1, width);
                linePtr += scanlineStride;
                consumer.consume(currLine, prevLine);
                byte[] b = currLine;
                currLine = prevLine;
                prevLine = b;
            }
        } else {
            throw new IllegalStateException("TYPE_BYTE_GRAY must have a PixelInterleavedSampleModel");
        }
    }

    static void getUshortGray(BufferedImage image, int yStart, int width, int heightToStream, AbstractPNGLineConsumer consumer) throws IOException {
        WritableRaster imageRaster = image.getRaster();
        boolean channels = true;
        int rowByteSize = 1 + 1 * width * 2;
        byte[] currLine = new byte[rowByteSize];
        byte[] prevLine = new byte[rowByteSize];
        DataBufferUShort dataBufferUShort = (DataBufferUShort)imageRaster.getDataBuffer();
        if (imageRaster.getSampleModel() instanceof PixelInterleavedSampleModel) {
            PixelInterleavedSampleModel sampleModel = (PixelInterleavedSampleModel)imageRaster.getSampleModel();
            short[] rawShorts = dataBufferUShort.getData();
            int scanlineStride = sampleModel.getScanlineStride();
            int pixelStride = sampleModel.getPixelStride();
            assert (pixelStride == 1);
            int linePtr = scanlineStride * (yStart - imageRaster.getSampleModelTranslateY()) - imageRaster.getSampleModelTranslateX() * pixelStride;
            for (int y = 0; y < heightToStream; ++y) {
                int pixelPtr = linePtr;
                int writePtr = 1;
                for (int x = 0; x < width; ++x) {
                    short grayColorValue = rawShorts[pixelPtr++];
                    byte high = (byte)(grayColorValue >> 8);
                    byte low = (byte)(grayColorValue & 0xFF);
                    currLine[writePtr++] = high;
                    currLine[writePtr++] = low;
                }
                linePtr += scanlineStride;
                consumer.consume(currLine, prevLine);
                byte[] b = currLine;
                currLine = prevLine;
                prevLine = b;
            }
        } else {
            throw new IllegalStateException("TYPE_USHORT_GRAY must have a PixelInterleavedSampleModel");
        }
    }

    static boolean getUshortGenericDataBufferUShort(BufferedImage image, int yStart, int width, int heightToStream, AbstractPNGLineConsumer consumer) throws IOException {
        WritableRaster imageRaster = image.getRaster();
        DataBufferUShort dataBufferUShort = (DataBufferUShort)imageRaster.getDataBuffer();
        int channels = imageRaster.getSampleModel().getNumBands();
        int rowByteSize = 1 + channels * width * 2;
        byte[] currLine = new byte[rowByteSize];
        byte[] prevLine = new byte[rowByteSize];
        if (imageRaster.getSampleModel() instanceof PixelInterleavedSampleModel) {
            PixelInterleavedSampleModel sampleModel = (PixelInterleavedSampleModel)imageRaster.getSampleModel();
            short[] rawShorts = dataBufferUShort.getData();
            int scanlineStride = sampleModel.getScanlineStride();
            int pixelStride = sampleModel.getPixelStride();
            assert (pixelStride == channels);
            int linePtr = scanlineStride * (yStart - imageRaster.getSampleModelTranslateY()) - imageRaster.getSampleModelTranslateX() * pixelStride;
            for (int y = 0; y < heightToStream; ++y) {
                int pixelPtr = linePtr;
                int writePtr = 1;
                for (int x = 0; x < width; ++x) {
                    for (int inPixelPtr = 0; inPixelPtr < channels; ++inPixelPtr) {
                        short colorValue = rawShorts[pixelPtr++];
                        byte high = (byte)(colorValue >> 8);
                        byte low = (byte)(colorValue & 0xFF);
                        currLine[writePtr++] = high;
                        currLine[writePtr++] = low;
                    }
                }
                linePtr += scanlineStride;
                consumer.consume(currLine, prevLine);
                byte[] b = currLine;
                currLine = prevLine;
                prevLine = b;
            }
            return true;
        }
        return false;
    }

    static boolean getUshortGeneric(BufferedImage image, int yStart, int width, int heightToStream, AbstractPNGLineConsumer consumer) throws IOException {
        WritableRaster imageRaster = image.getRaster();
        int channels = imageRaster.getSampleModel().getNumBands();
        int rowByteSize = 1 + channels * width * 2;
        byte[] currLine = new byte[rowByteSize];
        byte[] prevLine = new byte[rowByteSize];
        if (imageRaster.getSampleModel() instanceof PixelInterleavedSampleModel) {
            PixelInterleavedSampleModel sampleModel = (PixelInterleavedSampleModel)imageRaster.getSampleModel();
            DataBuffer dataBuffer = imageRaster.getDataBuffer();
            int numBanks = dataBuffer.getNumBanks();
            int scanlineStride = sampleModel.getScanlineStride();
            int pixelStride = sampleModel.getPixelStride();
            assert (pixelStride == channels);
            assert (numBanks == 1);
            int linePtr = scanlineStride * (yStart - imageRaster.getSampleModelTranslateY()) - imageRaster.getSampleModelTranslateX() * pixelStride;
            for (int y = 0; y < heightToStream; ++y) {
                int pixelPtr = linePtr;
                int writePtr = 1;
                for (int x = 0; x < width; ++x) {
                    for (int bankNum = 0; bankNum < channels; ++bankNum) {
                        short colorValue = (short)(dataBuffer.getElem(pixelPtr++) & 0xFFFF);
                        byte high = (byte)(colorValue >> 8);
                        byte low = (byte)(colorValue & 0xFF);
                        currLine[writePtr++] = high;
                        currLine[writePtr++] = low;
                    }
                }
                linePtr += scanlineStride;
                consumer.consume(currLine, prevLine);
                byte[] b = currLine;
                currLine = prevLine;
                prevLine = b;
            }
            return true;
        }
        return false;
    }

    static boolean getByteGeneric(BufferedImage image, int yStart, int width, int heightToStream, AbstractPNGLineConsumer consumer) throws IOException {
        WritableRaster imageRaster = image.getRaster();
        int channels = imageRaster.getSampleModel().getNumBands();
        int rowByteSize = 1 + channels * width;
        byte[] currLine = new byte[rowByteSize];
        byte[] prevLine = new byte[rowByteSize];
        if (imageRaster.getSampleModel() instanceof PixelInterleavedSampleModel) {
            PixelInterleavedSampleModel sampleModel = (PixelInterleavedSampleModel)imageRaster.getSampleModel();
            DataBuffer dataBuffer = imageRaster.getDataBuffer();
            int numBanks = dataBuffer.getNumBanks();
            int scanlineStride = sampleModel.getScanlineStride();
            int pixelStride = sampleModel.getPixelStride();
            assert (pixelStride == channels);
            assert (numBanks == 1);
            int linePtr = scanlineStride * (yStart - imageRaster.getSampleModelTranslateY()) - imageRaster.getSampleModelTranslateX() * pixelStride;
            for (int y = 0; y < heightToStream; ++y) {
                int pixelPtr = linePtr;
                int writePtr = 1;
                for (int x = 0; x < width; ++x) {
                    for (int bankNum = 0; bankNum < channels; ++bankNum) {
                        byte colorValue = (byte)(dataBuffer.getElem(pixelPtr++) & 0xFF);
                        currLine[writePtr++] = colorValue;
                    }
                }
                linePtr += scanlineStride;
                consumer.consume(currLine, prevLine);
                byte[] b = currLine;
                currLine = prevLine;
                prevLine = b;
            }
            return true;
        }
        return false;
    }

    static boolean getIntGeneric(BufferedImage image, int yStart, int width, int heightToStream, AbstractPNGLineConsumer consumer) throws IOException {
        WritableRaster imageRaster = image.getRaster();
        int channels = imageRaster.getSampleModel().getNumBands();
        int rowByteSize = 1 + channels * width;
        byte[] currLine = new byte[rowByteSize];
        byte[] prevLine = new byte[rowByteSize];
        if (imageRaster.getSampleModel() instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel sampleModel = (SinglePixelPackedSampleModel)imageRaster.getSampleModel();
            DataBuffer dataBuffer = imageRaster.getDataBuffer();
            int numBanks = dataBuffer.getNumBanks();
            int scanlineStride = sampleModel.getScanlineStride();
            int[] bitOffsets = sampleModel.getBitOffsets();
            int[] bitMasks = sampleModel.getBitMasks();
            assert (numBanks == 1);
            int linePtr = scanlineStride * (yStart - imageRaster.getSampleModelTranslateY()) - imageRaster.getSampleModelTranslateX();
            for (int y = 0; y < heightToStream; ++y) {
                int pixelPtr = linePtr;
                int writePtr = 1;
                for (int x = 0; x < width; ++x) {
                    int colorValue = dataBuffer.getElem(pixelPtr++);
                    for (int i = 0; i < bitOffsets.length; ++i) {
                        int v = (colorValue & bitMasks[i]) >> bitOffsets[i];
                        currLine[writePtr++] = (byte)(v & 0xFF);
                    }
                }
                linePtr += scanlineStride;
                consumer.consume(currLine, prevLine);
                byte[] b = currLine;
                currLine = prevLine;
                prevLine = b;
            }
            return true;
        }
        return false;
    }

    static class EncodingMetaInfo {
        int channels;
        int bytesPerPixel;
        int bitsPerChannel = 8;
        int rowByteSize;
        boolean hasAlpha;
        ICC_Profile colorProfile;
        ColorSpaceType colorSpaceType;

        EncodingMetaInfo() {
        }

        static enum ColorSpaceType {
            Rgb,
            Gray,
            Indexed;

        }
    }

    static class ByteBufferPNGLineConsumer
    extends AbstractPNGLineConsumer {
        byte[] bytes;
        int currentOffset;

        ByteBufferPNGLineConsumer(int byteCount) {
            this.bytes = new byte[byteCount];
        }

        @Override
        void consume(byte[] currRow, byte[] prevRow) {
            System.arraycopy(currRow, 0, this.bytes, this.currentOffset, currRow.length);
            this.currentOffset += currRow.length;
        }
    }

    static abstract class AbstractPNGLineConsumer {
        AbstractPNGLineConsumer() {
        }

        abstract void consume(byte[] var1, byte[] var2) throws IOException;
    }
}

