/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker;

import com.google.common.base.Strings;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;

abstract class AbstractDockerMojo
extends AbstractMojo {
    @Component(role=MavenSession.class)
    protected MavenSession session;
    @Component(role=MojoExecution.class)
    protected MojoExecution execution;
    @Parameter(property="dockerHost")
    private String dockerHost;

    AbstractDockerMojo() {
    }

    public void execute() throws MojoExecutionException {
        try (DefaultDockerClient client = null;){
            DefaultDockerClient.Builder builder = DefaultDockerClient.fromEnv().readTimeoutMillis(0L);
            String dockerHost = this.rawDockerHost();
            if (!Strings.isNullOrEmpty((String)dockerHost)) {
                builder.uri(dockerHost);
            }
            client = builder.build();
            this.execute((DockerClient)client);
        }
    }

    protected abstract void execute(DockerClient var1) throws Exception;

    protected String rawDockerHost() {
        return this.dockerHost;
    }
}

