/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jasperreports.compilers.DirectExpressionValueFilter;
import net.sf.jasperreports.compilers.GroovyClassFilterTransformer;
import net.sf.jasperreports.compilers.GroovyDirectExpressionValueFilter;
import net.sf.jasperreports.compilers.GroovySandboxEvaluator;
import net.sf.jasperreports.compilers.JRGroovyGenerator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRDefaultCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.tools.GroovyClass;

public class JRGroovyCompiler
extends JRAbstractJavaCompiler {
    protected static final String SOURCE_ENCODING = "UTF-8";
    public static final String EXCEPTION_MESSAGE_KEY_COMPILING_EXPRESSIONS_CLASS_FILE = "compilers.compiling.expressions.class.file";
    public static final String EXCEPTION_MESSAGE_KEY_TOO_FEW_CLASSES_GENERATED = "compilers.groovy.too.few.classes.generated";
    public static final String EXCEPTION_MESSAGE_KEY_TOO_MANY_CLASSES_GENERATED = "compilers.groovy.too.many.classes.generated";
    public static final String EXCEPTION_MESSAGE_KEY_REPORT_NOT_COMPILED_FOR_CLASS_FILTERING = "compilers.groovy.report.not.compiled.for.class.filtering";

    public JRGroovyCompiler(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext, false);
    }

    @Override
    protected DirectExpressionValueFilter directValueFilter() {
        return GroovyDirectExpressionValueFilter.instance();
    }

    @Override
    protected String compileUnits(JRCompilationUnit[] units, String classpath, File tempDirFile) throws JRException {
        CompilerConfiguration config = new CompilerConfiguration();
        config.setSourceEncoding(SOURCE_ENCODING);
        if (this.reportClassFilter.isFilteringEnabled()) {
            config.addCompilationCustomizers(new CompilationCustomizer[]{new GroovyClassFilterTransformer()});
        }
        CompilationUnit unit = new CompilationUnit(config);
        for (int i = 0; i < units.length; ++i) {
            try {
                byte[] sourceBytes = units[i].getSourceCode().getBytes(SOURCE_ENCODING);
                unit.addSource("calculator_" + units[i].getName(), (InputStream)new ByteArrayInputStream(sourceBytes));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new JRRuntimeException(e);
            }
        }
        try {
            unit.compile(7);
        }
        catch (CompilationFailedException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_COMPILING_EXPRESSIONS_CLASS_FILE, new Object[]{e.toString()}, e);
        }
        List generatedClasses = unit.getClasses();
        if (generatedClasses.size() < units.length) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_TOO_FEW_CLASSES_GENERATED, (Object[])null);
        }
        if (generatedClasses.size() > units.length) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_TOO_MANY_CLASSES_GENERATED, (Object[])null);
        }
        Map<String, byte[]> classBytes = generatedClasses.stream().collect(Collectors.toMap(GroovyClass::getName, GroovyClass::getBytes));
        for (int i = 0; i < units.length; ++i) {
            units[i].setCompileData((Serializable)classBytes.get(units[i].getName()));
        }
        return null;
    }

    @Override
    protected void checkLanguage(String language) throws JRException {
        if (!"groovy".equals(language) && !"java".equals(language)) {
            throw new JRException("compilers.language.not.supported", language, "groovy", "java");
        }
    }

    @Override
    protected JRCompilationSourceCode generateSourceCode(JRSourceCompileTask sourceTask) throws JRException {
        return new JRDefaultCompilationSourceCode(JRGroovyGenerator.generateClass(sourceTask, this.reportClassFilter), null);
    }

    @Override
    protected String getSourceFileName(String unitName) {
        return unitName + ".groovy";
    }

    @Override
    protected Class<?> loadClass(String className, byte[] compileData) {
        return JRClassLoader.loadClassFromBytes(className, compileData);
    }

    @Override
    protected JREvaluator loadEvaluator(Serializable compileData, String className) throws JRException {
        JREvaluator evaluator = super.loadEvaluator(compileData, className);
        if (this.reportClassFilter.isFilteringEnabled()) {
            if (!(evaluator instanceof GroovySandboxEvaluator)) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_REPORT_NOT_COMPILED_FOR_CLASS_FILTERING);
            }
            ((GroovySandboxEvaluator)evaluator).setReportClassFilter(this.reportClassFilter);
        }
        return evaluator;
    }
}

