/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.engine.type.SortOrderEnum;

public class JRSortableDataSource
implements JRRewindableDataSource {
    public static final String EXCEPTION_MESSAGE_KEY_SORT_FIELD_NOT_FOUND = "data.sortable.sort.field.not.found";
    private List<Object[]> records = new ArrayList<Object[]>();
    private Iterator<Object[]> iterator;
    private Object[] currentRecord;
    private Map<String, Integer> fieldIndexMap = new HashMap<String, Integer>();
    protected Collator collator;

    public JRSortableDataSource(JRDataSource ds, JRField[] fields, JRSortField[] sortFields, Locale locale) throws JRException {
        if (fields == null) {
            fields = new JRField[]{};
        }
        if (sortFields == null) {
            sortFields = new JRSortField[]{};
        }
        JRSortableDataSource.verifySortFields(fields, sortFields);
        this.collator = Collator.getInstance(locale);
        for (int i = 0; i < fields.length; ++i) {
            this.fieldIndexMap.put(fields[i].getName(), i);
        }
        int[] sortIndexes = new int[sortFields.length];
        int[] sortOrders = new int[sortFields.length];
        boolean[] collatorFlags = new boolean[sortFields.length];
        block1: for (int i = 0; i < sortFields.length; ++i) {
            JRSortField sortField = sortFields[i];
            sortIndexes[i] = this.fieldIndexMap.get(sortField.getName());
            sortOrders[i] = SortOrderEnum.ASCENDING == sortField.getOrderValue() ? 1 : -1;
            collatorFlags[i] = false;
            for (int j = 0; j < fields.length; ++j) {
                JRField field = fields[j];
                if (!sortField.getName().equals(field.getName())) continue;
                collatorFlags[i] = String.class.getName().equals(field.getValueClassName());
                continue block1;
            }
        }
        if (ds != null) {
            while (ds.next()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRFillInterruptedException();
                }
                Object[] record = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    record[i] = ds.getFieldValue(fields[i]);
                }
                this.records.add(record);
            }
        }
        Collections.sort(this.records, new DataSourceComparator(sortIndexes, sortOrders, collatorFlags));
        this.iterator = this.records.iterator();
    }

    @Override
    public boolean next() {
        boolean hasNext = false;
        if (this.iterator != null && (hasNext = this.iterator.hasNext())) {
            this.currentRecord = this.iterator.next();
        }
        return hasNext;
    }

    @Override
    public Object getFieldValue(JRField jrField) {
        Integer fieldIndex = this.fieldIndexMap.get(jrField.getName());
        if (fieldIndex == null) {
            throw new JRRuntimeException("data.array.list.field.not.found", jrField.getName());
        }
        return this.currentRecord[fieldIndex];
    }

    @Override
    public void moveFirst() {
        this.iterator = this.records.iterator();
    }

    public static void verifySortFields(JRField[] fields, JRSortField[] sortFields) {
        if (fields != null && sortFields != null) {
            for (int i = 0; i < sortFields.length; ++i) {
                String sortFieldName = sortFields[i].getName();
                boolean isFound = false;
                for (int j = 0; !isFound && j < fields.length; ++j) {
                    isFound = sortFieldName.equals(fields[j].getName());
                }
                if (isFound) continue;
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_SORT_FIELD_NOT_FOUND, sortFieldName);
            }
        }
    }

    class DataSourceComparator
    implements Comparator<Object[]> {
        int[] sortIndexes = null;
        int[] sortOrders = null;
        boolean[] collatorFlags = null;

        public DataSourceComparator(int[] sortIndexes, int[] sortOrders, boolean[] collatorFlags) {
            this.sortIndexes = sortIndexes;
            this.sortOrders = sortOrders;
            this.collatorFlags = collatorFlags;
        }

        @Override
        public int compare(Object[] record1, Object[] record2) {
            int ret = 0;
            for (int i = 0; i < this.sortIndexes.length; ++i) {
                int sortIndex = this.sortIndexes[i];
                Comparable field1 = (Comparable)record1[sortIndex];
                Comparable field2 = (Comparable)record2[sortIndex];
                ret = field1 == null ? (field2 == null ? 0 : -1) : (field2 == null ? 1 : (this.collatorFlags[i] ? JRSortableDataSource.this.collator.compare(field1, field2) : field1.compareTo(field2)));
                if ((ret *= this.sortOrders[i]) == 0) continue;
                return ret;
            }
            return ret;
        }
    }
}

