/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRRuntimeException;

public final class JRStringUtil {
    protected static final String JAVA_IDENTIFIER_PREFIX = "j";
    protected static final Pattern PATTERN_CSS_INVALID_CHARACTER = Pattern.compile("[^a-zA-Z0-9_-]+");
    protected static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final String EXCEPTION_MESSAGE_KEY_NUMBER_OUTSIDE_BOUNDS = "util.markup.processor.number.outside.bounds";
    protected static final String[] THOUSAND_DIGITS = new String[]{"", "M", "MM", "MMM"};
    protected static final String[] HUNDRED_DIGITS = new String[]{"", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM"};
    protected static final String[] TEN_DIGITS = new String[]{"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};
    protected static final String[] UNIT_DIGITS = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};

    public static String replaceCRwithLF(String text) {
        if (text != null) {
            int length = text.length();
            char[] chars = text.toCharArray();
            int r = 0;
            boolean dirty = false;
            for (int i = 0; i < length; ++i) {
                char ch = chars[i];
                if (ch == '\r') {
                    dirty = true;
                    if (i + 1 < length && chars[i + 1] == '\n') {
                        ++r;
                        continue;
                    }
                    chars[i - r] = 10;
                    continue;
                }
                chars[i - r] = ch;
            }
            return dirty ? new String(chars, 0, length - r) : text;
        }
        return null;
    }

    public static String xmlEncode(String text) {
        return JRStringUtil.xmlEncode(text, null);
    }

    public static String xmlEncode(String text, String invalidCharReplacement) {
        if (text == null || text.length() == 0) {
            return text;
        }
        int length = text.length();
        StringBuilder ret = new StringBuilder(length * 12 / 10);
        int last = 0;
        block7: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (Character.isISOControl(c) && c != '\t' && c != '\r' && c != '\n') {
                last = JRStringUtil.appendText(text, ret, i, last);
                if (invalidCharReplacement == null) {
                    ret.append(c);
                    continue;
                }
                if (invalidCharReplacement.length() == 0) continue;
                ret.append(invalidCharReplacement);
                continue;
            }
            switch (c) {
                case '&': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&amp;");
                    continue block7;
                }
                case '>': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&gt;");
                    continue block7;
                }
                case '<': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&lt;");
                    continue block7;
                }
                case '\"': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&apos;");
                    continue block7;
                }
            }
        }
        JRStringUtil.appendText(text, ret, length, last);
        return ret.toString();
    }

    public static String encodeXmlAttribute(String text) {
        return JRStringUtil.encodeXmlAttribute(text, false);
    }

    public static String encodeXmlAttribute(String text, boolean exceptApos) {
        if (text == null || text.length() == 0) {
            return text;
        }
        int length = text.length();
        StringBuilder ret = new StringBuilder(length * 12 / 10);
        int last = 0;
        block10: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&amp;");
                    continue block10;
                }
                case '>': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&gt;");
                    continue block10;
                }
                case '<': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&lt;");
                    continue block10;
                }
                case '\"': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    if (exceptApos) continue block10;
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&apos;");
                    continue block10;
                }
                case '\t': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&#x9;");
                    continue block10;
                }
                case '\r': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&#xD;");
                    continue block10;
                }
                case '\n': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&#xA;");
                    continue block10;
                }
            }
        }
        if (last == 0) {
            return text;
        }
        JRStringUtil.appendText(text, ret, length, last);
        return ret.toString();
    }

    private static int appendText(String text, StringBuilder ret, int current, int old) {
        if (old < current) {
            ret.append(text.substring(old, current));
        }
        return current + 1;
    }

    public static String htmlEncode(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        int length = text.length();
        StringBuilder ret = new StringBuilder(length * 12 / 10);
        boolean isEncodeSpace = true;
        int last = 0;
        block8: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case ' ': {
                    if (isEncodeSpace) {
                        if (last < i) {
                            ret.append(text.substring(last, i));
                        }
                        last = i + 1;
                        ret.append("&nbsp;");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    isEncodeSpace = true;
                    continue block8;
                }
                case '&': {
                    if (last < i) {
                        ret.append(text.substring(last, i));
                    }
                    last = i + 1;
                    ret.append("&amp;");
                    isEncodeSpace = false;
                    continue block8;
                }
                case '>': {
                    if (last < i) {
                        ret.append(text.substring(last, i));
                    }
                    last = i + 1;
                    ret.append("&gt;");
                    isEncodeSpace = false;
                    continue block8;
                }
                case '<': {
                    if (last < i) {
                        ret.append(text.substring(last, i));
                    }
                    last = i + 1;
                    ret.append("&lt;");
                    isEncodeSpace = false;
                    continue block8;
                }
                case '\"': {
                    if (last < i) {
                        ret.append(text.substring(last, i));
                    }
                    last = i + 1;
                    ret.append("&quot;");
                    isEncodeSpace = false;
                    continue block8;
                }
                case '\n': {
                    if (last < i) {
                        ret.append(text.substring(last, i));
                    }
                    last = i + 1;
                    ret.append("<br/>");
                    isEncodeSpace = false;
                    continue block8;
                }
                default: {
                    isEncodeSpace = false;
                }
            }
        }
        if (last < length) {
            ret.append(text.substring(last));
        }
        return ret.toString();
    }

    public static String getJavaIdentifier(String name) {
        if (JRStringUtil.isValidJavaIdentifier(name)) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name.length() + 5);
        char[] literalChars = new char[name.length()];
        name.getChars(0, literalChars.length, literalChars, 0);
        for (int i = 0; i < literalChars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                sb.append(JAVA_IDENTIFIER_PREFIX);
                sb.append((int)literalChars[i]);
                continue;
            }
            if (i != 0 && !Character.isJavaIdentifierPart(literalChars[i])) {
                sb.append((int)literalChars[i]);
                continue;
            }
            sb.append(literalChars[i]);
        }
        return sb.toString();
    }

    private static boolean isValidJavaIdentifier(String literal) {
        boolean result = true;
        char[] literalChars = new char[literal.length()];
        literal.getChars(0, literalChars.length, literalChars, 0);
        for (int i = 0; i < literalChars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                result = false;
                break;
            }
            if (i == 0 || Character.isJavaIdentifierPart(literalChars[i])) continue;
            result = false;
            break;
        }
        return result;
    }

    public static String escapeJavaStringLiteral(String text) {
        if (text == null) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer tkzer = new StringTokenizer(text, "\\\"\n\r\t", true);
        while (tkzer.hasMoreTokens()) {
            String token = tkzer.nextToken();
            if ("\\".equals(token)) {
                sb.append("\\\\");
                continue;
            }
            if ("\"".equals(token)) {
                sb.append("\\\"");
                continue;
            }
            if ("\n".equals(token)) {
                sb.append("\\n");
                continue;
            }
            if ("\r".equals(token)) {
                sb.append("\\r");
                continue;
            }
            if ("\t".equals(token)) {
                sb.append("\\t");
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static String escapeJavaScript(String input) {
        if (input == null) {
            return input;
        }
        StringBuilder filtered = new StringBuilder(input.length());
        char prevChar = '\u0000';
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\"') {
                filtered.append("\\\"");
            } else if (c == '\'') {
                filtered.append("\\'");
            } else if (c == '\\') {
                filtered.append("\\\\");
            } else if (c == '/') {
                filtered.append("\\/");
            } else if (c == '\t') {
                filtered.append("\\t");
            } else if (c == '\n') {
                if (prevChar != '\r') {
                    filtered.append("\\n");
                }
            } else if (c == '\r') {
                filtered.append("\\n");
            } else if (c == '\f') {
                filtered.append("\\f");
            } else {
                filtered.append(c);
            }
            prevChar = c;
        }
        return filtered.toString();
    }

    public static String escapeString4JavaScript(String input) {
        if (input == null) {
            return input;
        }
        StringBuilder filtered = new StringBuilder(input.length());
        char prevChar = '\u0000';
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\"') {
                filtered.append("\\\"");
            } else if (c == '\\') {
                filtered.append("\\\\");
            } else if (c == '/') {
                filtered.append("\\/");
            } else if (c == '\t') {
                filtered.append("\\t");
            } else if (c == '\n') {
                if (prevChar != '\r') {
                    filtered.append("\\n");
                }
            } else if (c == '\r') {
                filtered.append("\\n");
            } else if (c == '\f') {
                filtered.append("\\f");
            } else {
                filtered.append(c);
            }
            prevChar = c;
        }
        return filtered.toString();
    }

    public static List<Integer> getTabIndexes(String text) {
        int index;
        ArrayList<Integer> tabIndexes = null;
        if (text != null && (index = text.indexOf(9)) >= 0) {
            tabIndexes = new ArrayList<Integer>();
            do {
                tabIndexes.add(index);
            } while ((index = text.indexOf(9, index + 1)) >= 0);
        }
        return tabIndexes;
    }

    public static List<String> split(String[] srcArray, String delimiterRegExp) {
        ArrayList<String> tokens = null;
        if (srcArray != null) {
            tokens = new ArrayList<String>();
            for (int i = 0; i < srcArray.length; ++i) {
                if (srcArray[i] == null) {
                    tokens.add(null);
                    continue;
                }
                String[] currentTokensArray = srcArray[i].split(delimiterRegExp);
                for (int j = 0; j < currentTokensArray.length; ++j) {
                    tokens.add(currentTokensArray[j].trim());
                }
            }
        }
        return tokens;
    }

    public static String getString(Object value) {
        return value == null ? null : value.toString();
    }

    public static String escapeJSONString(String text) {
        if (text == null) {
            return null;
        }
        char[] escapedChars = JsonStringEncoder.getInstance().quoteAsString(text);
        if (text.contentEquals(CharBuffer.wrap(escapedChars))) {
            return text;
        }
        return String.valueOf(escapedChars);
    }

    public static String getCSSClass(String name) {
        String cssClass;
        if (name == null || name.isEmpty()) {
            return name;
        }
        Matcher matcher = PATTERN_CSS_INVALID_CHARACTER.matcher(name);
        StringBuffer sb = null;
        while (matcher.find()) {
            if (sb == null) {
                sb = new StringBuffer(name.length() + 4);
            }
            String text = matcher.group();
            String replacement = JRStringUtil.cssClassReplacement(text);
            matcher.appendReplacement(sb, replacement);
        }
        if (sb == null) {
            cssClass = name;
        } else {
            matcher.appendTail(sb);
            cssClass = sb.toString();
        }
        if (!Character.isLetter(cssClass.charAt(0))) {
            cssClass = 'c' + cssClass;
        }
        return cssClass;
    }

    protected static String cssClassReplacement(String text) {
        try {
            byte[] bytes = text.getBytes("UTF-8");
            char[] chars = new char[bytes.length * 2 + 1];
            chars[0] = 45;
            for (int i = 0; i < bytes.length; ++i) {
                int code = bytes[i] & 0xFF;
                chars[2 * i + 1] = HEX_DIGITS[code >>> 4];
                chars[2 * i + 2] = HEX_DIGITS[code & 0xF];
            }
            return new String(chars);
        }
        catch (UnsupportedEncodingException e) {
            throw new JRRuntimeException(e);
        }
    }

    public static String getLetterNumeral(int number, boolean isUpperCase) {
        String romanNumeral = "";
        int tmpNumber = number;
        while (tmpNumber > 0) {
            int modulo = (tmpNumber - 1) % 26;
            romanNumeral = (char)(modulo + 65) + romanNumeral;
            tmpNumber = (tmpNumber - modulo) / 26;
        }
        return isUpperCase ? romanNumeral : romanNumeral.toLowerCase();
    }

    public static String getRomanNumeral(int number, boolean isUpperCase) {
        if (number < 1 || number > 3999) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NUMBER_OUTSIDE_BOUNDS, number);
        }
        String strNumber = ("0000" + String.valueOf(number)).substring(String.valueOf(number).length());
        String result = THOUSAND_DIGITS[strNumber.charAt(0) - 48] + HUNDRED_DIGITS[strNumber.charAt(1) - 48] + TEN_DIGITS[strNumber.charAt(2) - 48] + UNIT_DIGITS[strNumber.charAt(3) - 48];
        return isUpperCase ? result : result.toLowerCase();
    }

    private JRStringUtil() {
    }
}

