/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.support;

import com.zaxxer.hikari.HikariDataSource;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.model.support.jpa.DatabaseProperties;
import org.apereo.cas.configuration.model.support.jpa.JpaConfigDataHolder;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.configuration.support.DataSourceProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.DataSourceLookupFailureException;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;

public final class JpaBeans {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaBeans.class);

    public static DataSource newDataSource(AbstractJpaProperties jpaProperties) {
        String dataSourceName = jpaProperties.getDataSourceName();
        boolean proxyDataSource = jpaProperties.isDataSourceProxy();
        if (StringUtils.isNotBlank((CharSequence)dataSourceName)) {
            try {
                JndiDataSourceLookup dsLookup = new JndiDataSourceLookup();
                dsLookup.setResourceRef(false);
                DataSource containerDataSource = dsLookup.getDataSource(dataSourceName);
                if (!proxyDataSource) {
                    return containerDataSource;
                }
                return new DataSourceProxy(containerDataSource);
            }
            catch (DataSourceLookupFailureException e) {
                LOGGER.warn("Lookup of datasource [{}] failed due to {} falling back to configuration via JPA properties.", (Object)dataSourceName, (Object)e.getMessage());
            }
        }
        HikariDataSource bean = new HikariDataSource();
        if (StringUtils.isNotBlank((CharSequence)jpaProperties.getDriverClass())) {
            bean.setDriverClassName(jpaProperties.getDriverClass());
        }
        bean.setJdbcUrl(jpaProperties.getUrl());
        bean.setUsername(jpaProperties.getUser());
        bean.setPassword(jpaProperties.getPassword());
        bean.setLoginTimeout((int)Beans.newDuration(jpaProperties.getPool().getMaxWait()).getSeconds());
        bean.setMaximumPoolSize(jpaProperties.getPool().getMaxSize());
        bean.setMinimumIdle(jpaProperties.getPool().getMinSize());
        bean.setIdleTimeout((long)((int)Beans.newDuration(jpaProperties.getIdleTimeout()).toMillis()));
        bean.setLeakDetectionThreshold((long)jpaProperties.getLeakThreshold());
        bean.setInitializationFailTimeout(jpaProperties.getFailFastTimeout());
        bean.setIsolateInternalQueries(jpaProperties.isIsolateInternalQueries());
        bean.setConnectionTestQuery(jpaProperties.getHealthQuery());
        bean.setAllowPoolSuspension(jpaProperties.getPool().isSuspension());
        bean.setAutoCommit(jpaProperties.isAutocommit());
        bean.setValidationTimeout(jpaProperties.getPool().getTimeoutMillis());
        return bean;
    }

    public static HibernateJpaVendorAdapter newHibernateJpaVendorAdapter(DatabaseProperties databaseProperties) {
        HibernateJpaVendorAdapter bean = new HibernateJpaVendorAdapter();
        bean.setGenerateDdl(databaseProperties.isGenDdl());
        bean.setShowSql(databaseProperties.isShowSql());
        return bean;
    }

    public static LocalContainerEntityManagerFactoryBean newHibernateEntityManagerFactoryBean(JpaConfigDataHolder config, AbstractJpaProperties jpaProperties) {
        LocalContainerEntityManagerFactoryBean bean = new LocalContainerEntityManagerFactoryBean();
        bean.setJpaVendorAdapter(config.getJpaVendorAdapter());
        if (StringUtils.isNotBlank((CharSequence)config.getPersistenceUnitName())) {
            bean.setPersistenceUnitName(config.getPersistenceUnitName());
        }
        bean.setPackagesToScan(config.getPackagesToScan().toArray(new String[0]));
        if (config.getDataSource() != null) {
            bean.setDataSource(config.getDataSource());
        }
        Properties properties = new Properties();
        properties.put("hibernate.dialect", jpaProperties.getDialect());
        properties.put("hibernate.hbm2ddl.auto", jpaProperties.getDdlAuto());
        properties.put("hibernate.jdbc.batch_size", (Object)jpaProperties.getBatchSize());
        if (StringUtils.isNotBlank((CharSequence)jpaProperties.getDefaultCatalog())) {
            properties.put("hibernate.default_catalog", jpaProperties.getDefaultCatalog());
        }
        if (StringUtils.isNotBlank((CharSequence)jpaProperties.getDefaultSchema())) {
            properties.put("hibernate.default_schema", jpaProperties.getDefaultSchema());
        }
        properties.put("hibernate.enable_lazy_load_no_trans", Boolean.TRUE);
        properties.put("hibernate.format_sql", Boolean.TRUE);
        properties.putAll(jpaProperties.getProperties());
        bean.setJpaProperties(properties);
        return bean;
    }

    @Generated
    private JpaBeans() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

