/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.Direction;
import com.terracottatech.frs.io.FileBuffer;
import com.terracottatech.frs.io.nio.HeaderException;
import com.terracottatech.frs.io.nio.IntegrityReadbackStrategy;
import com.terracottatech.frs.io.nio.NIOSegment;
import com.terracottatech.frs.io.nio.NIOStreamImpl;
import com.terracottatech.frs.io.nio.SegmentHeaders;
import com.terracottatech.frs.io.nio.WritingSegmentJumpList;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;

class WritingSegment
extends NIOSegment
implements Iterable<Chunk>,
Closeable {
    private FileBuffer buffer;
    private static final short IMPL_NUMBER = 2;
    private long maxMarker;
    private WritingSegmentJumpList writeJumpList;
    private long totalWrite;
    private boolean existingFile = false;

    WritingSegment(NIOStreamImpl p, File file) {
        super(p, file);
        if (file.exists()) {
            this.existingFile = true;
        }
    }

    long getMaximumMarker() {
        return this.maxMarker;
    }

    long getTotalWritten() {
        return this.totalWrite;
    }

    @Override
    void insertFileHeader(long lowestMarker, long marker) throws IOException {
        super.insertFileHeader(lowestMarker, marker);
        this.buffer.clear();
        this.buffer.put(SegmentHeaders.LOG_FILE.getBytes());
        this.buffer.putShort((short)2);
        this.buffer.putInt(super.getSegmentId());
        this.buffer.putLong(super.getStreamId().getMostSignificantBits());
        this.buffer.putLong(super.getStreamId().getLeastSignificantBits());
        this.buffer.putLong(super.getMinimumMarker());
        this.buffer.putLong(super.getBaseMarker());
        this.buffer.write(1);
    }

    synchronized WritingSegment open() throws IOException, HeaderException {
        while (this.buffer == null) {
            this.buffer = this.getStream() != null ? this.getStream().createFileBuffer(this.createFileChannel(), 524288) : new FileBuffer(this.createFileChannel(), ByteBuffer.allocate(524288));
        }
        if (this.existingFile) {
            try {
                this.buffer.partition(42);
                this.buffer.read(1);
                this.readFileHeader(this.buffer);
            }
            catch (HeaderException header) {
                throw new IOException(header);
            }
            catch (EOFException eof) {
                throw new HeaderException("truncated header", this);
            }
        } else {
            this.writeJumpList = new WritingSegmentJumpList();
        }
        return this;
    }

    private FileChannel createFileChannel() throws IOException {
        if (this.existingFile) {
            return new RandomAccessFile(this.getFile(), "rw").getChannel();
        }
        return new FileOutputStream(this.getFile()).getChannel();
    }

    void setJumpList(WritingSegmentJumpList jumps) {
        this.writeJumpList = jumps;
    }

    private long piggybackBufferOptimization(ByteBuffer used) throws IOException {
        long amt = used.remaining();
        int estart = used.limit();
        int position = used.position() - 12;
        used.position(position);
        used.limit(estart + 16 + 4);
        used.putInt(position, SegmentHeaders.CHUNK_START.getIntValue());
        used.putLong(position + 4, amt);
        used.putLong(estart, amt);
        used.putLong(estart + 8, this.getMaximumMarker());
        used.putInt(estart + 16, SegmentHeaders.FILE_CHUNK.getIntValue());
        amt = this.buffer.writeFully(used);
        this.writeJumpList.add(this.buffer.offset());
        return amt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long append(Chunk c, long maxMarker) throws IOException {
        int writeCount = 0;
        this.buffer.clear();
        if (this.maxMarker == maxMarker) {
            throw new IllegalArgumentException("writing the same marker to the log");
        }
        this.maxMarker = maxMarker;
        ByteBuffer[] raw = c.getBuffers();
        if (raw.length == 1 && !raw[0].isReadOnly() && raw[0].isDirect() && raw[0].position() > 12 && raw[0].capacity() - raw[0].limit() > 20) {
            return this.piggybackBufferOptimization(raw[0]);
        }
        this.buffer.clear();
        this.buffer.partition(12);
        long amt = c.remaining();
        this.buffer.put(SegmentHeaders.CHUNK_START.getBytes());
        this.buffer.putLong(amt);
        this.buffer.insert(raw, 1, false);
        this.buffer.putLong(amt);
        this.buffer.putLong(maxMarker);
        this.buffer.put(SegmentHeaders.FILE_CHUNK.getBytes());
        writeCount = raw.length + 2;
        try {
            long l = this.buffer.write(writeCount);
            return l;
        }
        finally {
            this.writeJumpList.add(this.buffer.offset());
        }
    }

    synchronized void prepareForClose() throws IOException {
        if (this.buffer != null && this.buffer.isOpen()) {
            this.buffer.clear();
            this.buffer.put(SegmentHeaders.CLOSE_FILE.getBytes());
            this.writeJumpList(this.buffer);
            this.buffer.write(1);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.totalWrite = 0L;
        if (this.buffer != null && this.buffer.isOpen()) {
            this.totalWrite = this.buffer.getTotal();
            long delta = System.nanoTime();
            this.buffer.sync(true);
            delta = System.nanoTime() - delta;
            this.getStream().recordFsyncLatency(delta);
            this.buffer.close();
        }
        this.buffer = null;
    }

    public boolean isClosed() {
        return this.buffer == null;
    }

    @Override
    public long size() {
        try {
            return this.buffer.size();
        }
        catch (IOException ioe) {
            return -1L;
        }
    }

    @Override
    public Iterator<Chunk> iterator() {
        final IntegrityReadbackStrategy reader = new IntegrityReadbackStrategy(this.buffer);
        try {
            this.buffer.clear();
            this.buffer.position(42L);
        }
        catch (IOException ioe) {
            return null;
        }
        return new Iterator<Chunk>(){

            @Override
            public boolean hasNext() {
                try {
                    return reader.hasMore(Direction.FORWARD);
                }
                catch (IOException ioe) {
                    return false;
                }
            }

            @Override
            public Chunk next() {
                try {
                    return reader.iterate(Direction.FORWARD);
                }
                catch (IOException ioe) {
                    return null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    private void writeJumpList(FileBuffer target) throws IOException {
        target.clear();
        target.put(SegmentHeaders.CLOSE_FILE.getBytes());
        long offset = 0L;
        for (long jump : this.writeJumpList) {
            if (target.remaining() < 10L) {
                target.write(1);
                target.clear();
            }
            target.putInt((int)(jump - offset));
            offset = jump;
        }
        if (this.writeJumpList.size() < Integer.MAX_VALUE) {
            target.putInt(this.writeJumpList.size());
        } else {
            target.putInt(-1);
        }
        target.put(SegmentHeaders.JUMP_LIST.getBytes());
    }

    public long position() throws IOException {
        return this.buffer == null ? 0L : this.buffer.position();
    }

    public long fsync(boolean meta) throws IOException {
        if (this.buffer == null) {
            throw new IOException("segment is closed");
        }
        long pos = this.buffer.offset();
        long delta = System.nanoTime();
        this.buffer.sync(meta);
        delta = System.nanoTime() - delta;
        this.getStream().recordFsyncLatency(delta);
        return pos;
    }

    protected void limit(long pos) throws IOException {
        if (this.buffer == null) {
            throw new IOException("segment is closed");
        }
        this.buffer.position(pos);
        this.buffer.put(SegmentHeaders.CLOSE_FILE.getBytes());
        this.writeJumpList(this.buffer);
        this.buffer.write(1);
        long delta = System.nanoTime();
        this.buffer.sync(true);
        delta = System.nanoTime() - delta;
        this.getStream().recordFsyncLatency(delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean last() throws IOException {
        if (this.buffer == null) {
            throw new IOException("segment is closed");
        }
        this.buffer.clear();
        this.buffer.position(42L);
        IntegrityReadbackStrategy find = new IntegrityReadbackStrategy(this.buffer);
        int count = 0;
        try {
            while (find.hasMore(Direction.FORWARD)) {
                try {
                    find.iterate(Direction.FORWARD);
                    ++count;
                }
                catch (IOException ioe) {
                    // empty catch block
                    break;
                }
            }
        }
        finally {
            this.buffer.clear();
            this.maxMarker = find.getMaximumMarker();
            this.buffer.position(find.getLastValidPosition());
            this.setJumpList(find.getJumpList());
        }
        if (count == 0) {
            return false;
        }
        if (!find.wasClosed() && this.verifyChunkMark(this.position())) {
            this.limit(this.position());
        }
        return true;
    }

    private boolean verifyChunkMark(long pos) throws IOException {
        this.buffer.clear();
        this.buffer.position(pos - 4L);
        this.buffer.partition(4);
        this.buffer.read(1);
        byte[] code = new byte[4];
        this.buffer.get(code);
        return SegmentHeaders.FILE_CHUNK.validate(code);
    }
}

