/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.CacheException;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.CachePersistenceException;
import org.ehcache.PersistentCacheManager;
import org.ehcache.Status;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.core.InternalCache;
import org.ehcache.core.events.CacheManagerListener;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.store.InternalCacheManager;
import org.ehcache.impl.config.copy.DefaultCopierConfiguration;
import org.ehcache.impl.copy.IdentityCopier;
import org.ehcache.jsr107.CacheResources;
import org.ehcache.jsr107.CloseUtil;
import org.ehcache.jsr107.ConfigurationMerger;
import org.ehcache.jsr107.Eh107Cache;
import org.ehcache.jsr107.Eh107CompleteConfiguration;
import org.ehcache.jsr107.Eh107Configuration;
import org.ehcache.jsr107.Eh107MXBean;
import org.ehcache.jsr107.Eh107ReverseConfiguration;
import org.ehcache.jsr107.EhcacheCachingProvider;
import org.ehcache.jsr107.EhcacheExpiryWrapper;
import org.ehcache.jsr107.Jsr107Service;
import org.ehcache.jsr107.Unwrap;
import org.ehcache.jsr107.internal.Jsr107CacheLoaderWriter;
import org.ehcache.jsr107.internal.WrappedCacheLoaderWriter;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.service.ServiceConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Eh107CacheManager
implements javax.cache.CacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(Eh107CacheManager.class);
    private static final MBeanServer MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
    private final Object cachesLock = new Object();
    private final ConcurrentMap<String, Eh107Cache<?, ?>> caches = new ConcurrentHashMap();
    private final CacheManager ehCacheManager;
    private final EhcacheCachingProvider cachingProvider;
    private final ClassLoader classLoader;
    private final URI uri;
    private final Properties props;
    private final ConfigurationMerger configurationMerger;
    private final StatisticsService statisticsService;

    Eh107CacheManager(EhcacheCachingProvider cachingProvider, CacheManager ehCacheManager, Jsr107Service jsr107Service, Properties props, ClassLoader classLoader, URI uri, ConfigurationMerger configurationMerger) {
        this.cachingProvider = cachingProvider;
        this.ehCacheManager = ehCacheManager;
        this.props = props;
        this.classLoader = classLoader;
        this.uri = uri;
        this.configurationMerger = configurationMerger;
        this.statisticsService = jsr107Service.getStatistics();
        ((InternalCacheManager)ehCacheManager).registerListener(new CacheManagerListener(){

            @Override
            public void cacheAdded(String alias, Cache<?, ?> cache) {
                Eh107CacheManager.this.loadCache(alias, cache);
            }

            @Override
            public void cacheRemoved(String alias, Cache<?, ?> cache) {
                Eh107Cache jcache = (Eh107Cache)Eh107CacheManager.this.caches.get(alias);
                if (jcache != null) {
                    Eh107CacheManager.this.close(jcache);
                }
            }

            @Override
            public void stateTransition(Status from, Status to) {
            }
        });
        this.loadAllCaches();
    }

    private void loadAllCaches() {
        for (Map.Entry<String, CacheConfiguration<?, ?>> entry : this.ehCacheManager.getRuntimeConfiguration().getCacheConfigurations().entrySet()) {
            CacheConfiguration<?, ?> config = entry.getValue();
            InternalCache cache = (InternalCache)this.ehCacheManager.getCache(entry.getKey(), config.getKeyType(), config.getValueType());
            this.loadCache(entry.getKey(), cache);
        }
        for (Eh107Cache wrappedCache : this.caches.values()) {
            wrappedCache.isClosed();
        }
    }

    private <K, V> javax.cache.Cache<K, V> loadCache(String alias, Cache<K, V> cache) {
        return this.caches.computeIfAbsent(alias, name -> {
            Eh107Cache wrappedCache = this.wrapEhcacheCache((String)name, (InternalCache)cache);
            Eh107Configuration configuration = wrappedCache.getConfiguration(Eh107Configuration.class);
            if (configuration.isManagementEnabled()) {
                this.enableManagement(wrappedCache, true);
            }
            if (configuration.isStatisticsEnabled()) {
                this.enableStatistics(wrappedCache, true);
            }
            return wrappedCache;
        });
    }

    private <K, V> javax.cache.Cache<K, V> reloadCache(String alias, Eh107Cache<K, V> jcache) {
        return this.caches.computeIfPresent(alias, (name, existing) -> {
            Eh107Configuration oldConfiguration = existing.getConfiguration(Eh107Configuration.class);
            Eh107Configuration newConfiguration = jcache.getConfiguration(Eh107Configuration.class);
            if (oldConfiguration.isManagementEnabled() != newConfiguration.isManagementEnabled()) {
                this.enableManagement(jcache, newConfiguration.isManagementEnabled());
            }
            if (oldConfiguration.isStatisticsEnabled() != newConfiguration.isStatisticsEnabled()) {
                this.enableStatistics(jcache, newConfiguration.isStatisticsEnabled());
            }
            return jcache;
        });
    }

    private <K, V> Eh107Cache<K, V> wrapEhcacheCache(String alias, InternalCache<K, V> cache) {
        CacheLoaderWriter<K, V> cacheLoaderWriter = cache.getCacheLoaderWriter();
        boolean storeByValueOnHeap = false;
        for (ServiceConfiguration<?, ?> serviceConfiguration : cache.getRuntimeConfiguration().getServiceConfigurations()) {
            if (!(serviceConfiguration instanceof DefaultCopierConfiguration)) continue;
            DefaultCopierConfiguration copierConfig = (DefaultCopierConfiguration)serviceConfiguration;
            if (copierConfig.getClazz().isAssignableFrom(IdentityCopier.class)) break;
            storeByValueOnHeap = true;
            break;
        }
        Eh107ReverseConfiguration<K, V> config = new Eh107ReverseConfiguration<K, V>(cache, cacheLoaderWriter != null, cacheLoaderWriter != null, storeByValueOnHeap);
        this.configurationMerger.setUpManagementAndStats(cache, config);
        EhcacheExpiryWrapper expiry = new EhcacheExpiryWrapper(cache.getRuntimeConfiguration().getExpiryPolicy());
        CacheResources<K, V> resources = new CacheResources<K, V>(alias, this.wrapCacheLoaderWriter(cacheLoaderWriter), expiry);
        return new Eh107Cache<K, V>(alias, config, resources, cache, this.statisticsService, this);
    }

    private <K, V> Jsr107CacheLoaderWriter<K, V> wrapCacheLoaderWriter(CacheLoaderWriter<K, V> cacheLoaderWriter) {
        return new WrappedCacheLoaderWriter<K, V>(cacheLoaderWriter);
    }

    public CachingProvider getCachingProvider() {
        return this.cachingProvider;
    }

    public URI getURI() {
        return this.uri;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Properties getProperties() {
        return new Properties(this.props);
    }

    public <K, V, C extends Configuration<K, V>> javax.cache.Cache<K, V> createCache(String cacheName, C config) throws IllegalArgumentException {
        this.checkClosed();
        if (cacheName == null || config == null) {
            throw new NullPointerException();
        }
        Object object = this.cachesLock;
        synchronized (object) {
            InternalCache ehCache;
            if (config instanceof Eh107Configuration.Eh107ConfigurationWrapper) {
                Eh107Configuration.Eh107ConfigurationWrapper configurationWrapper = (Eh107Configuration.Eh107ConfigurationWrapper)config;
                CacheConfiguration unwrap = configurationWrapper.getCacheConfiguration();
                try {
                    this.ehCacheManager.createCache(cacheName, unwrap);
                }
                catch (IllegalArgumentException e) {
                    throw new CacheException("A Cache named [" + cacheName + "] already exists");
                }
                return this.safeCacheRetrieval(cacheName);
            }
            ConfigurationMerger.ConfigHolder configHolder = this.configurationMerger.mergeConfigurations(cacheName, config);
            try {
                ehCache = (InternalCache)this.ehCacheManager.createCache(cacheName, configHolder.cacheConfiguration);
            }
            catch (IllegalArgumentException e) {
                throw configHolder.cacheResources.closeResourcesAfter(new CacheException("A Cache named [" + cacheName + "] already exists"));
            }
            catch (Throwable t) {
                throw configHolder.cacheResources.closeResourcesAfter(new CacheException(t));
            }
            Eh107Cache cache = null;
            CacheResources cacheResources = configHolder.cacheResources;
            try {
                if (configHolder.useEhcacheLoaderWriter) {
                    cacheResources = new CacheResources(cacheName, this.wrapCacheLoaderWriter(ehCache.getCacheLoaderWriter()), cacheResources.getExpiryPolicy(), cacheResources.getListenerResources());
                }
                cache = new Eh107Cache(cacheName, new Eh107CompleteConfiguration(configHolder.jsr107Configuration, ehCache.getRuntimeConfiguration()), cacheResources, ehCache, this.statisticsService, this);
                return this.reloadCache(cacheName, cache);
            }
            catch (Throwable t) {
                if (cache != null) {
                    throw cache.closeInternalAfter(new CacheException(t));
                }
                throw cacheResources.closeResourcesAfter(new CacheException(t));
            }
        }
    }

    private void checkClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException(this.toString() + " is closed");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.uri + "]";
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        this.checkClosed();
        if (cacheName == null || keyType == null || valueType == null) {
            throw new NullPointerException();
        }
        Eh107Cache<K, V> cache = this.safeCacheRetrieval(cacheName);
        if (cache == null) {
            return null;
        }
        Class actualKeyType = cache.getConfiguration(Configuration.class).getKeyType();
        Class actualValueType = cache.getConfiguration(Configuration.class).getValueType();
        if (keyType != actualKeyType) {
            throw new ClassCastException("Cache has key type " + actualKeyType.getName() + ", but getCache() called with key type " + keyType.getName());
        }
        if (valueType != actualValueType) {
            throw new ClassCastException("Cache has value type " + actualValueType.getName() + ", but getCache() called with value type " + valueType.getName());
        }
        return cache;
    }

    public <K, V> javax.cache.Cache<K, V> getCache(String cacheName) {
        this.checkClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        return this.safeCacheRetrieval(cacheName);
    }

    private <K, V> Eh107Cache<K, V> safeCacheRetrieval(String cacheName) {
        Eh107Cache eh107Cache = (Eh107Cache)this.caches.get(cacheName);
        if (eh107Cache != null && eh107Cache.isClosed()) {
            return null;
        }
        return eh107Cache;
    }

    public Iterable<String> getCacheNames() {
        this.checkClosed();
        return Collections.unmodifiableSet(new HashSet<String>(this.ehCacheManager.getRuntimeConfiguration().getCacheConfigurations().keySet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyCache(String cacheName) {
        if (cacheName == null) {
            throw new NullPointerException();
        }
        Object object = this.cachesLock;
        synchronized (object) {
            this.checkClosed();
            Eh107Cache cache = (Eh107Cache)this.caches.remove(cacheName);
            if (cache == null) {
                return;
            }
            try {
                CloseUtil.chain(() -> this.enableManagement(cache, false), () -> this.enableStatistics(cache, false), () -> cache.closeInternal(), () -> this.ehCacheManager.removeCache(cache.getName()), () -> {
                    if (this.ehCacheManager instanceof PersistentCacheManager) {
                        try {
                            ((PersistentCacheManager)this.ehCacheManager).destroyCache(cache.getName());
                        }
                        catch (CachePersistenceException t) {
                            throw new IOException(t);
                        }
                    }
                });
            }
            catch (Throwable t) {
                throw new CacheException(t);
            }
        }
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.checkClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        Eh107Cache cache = this.safeCacheRetrieval(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("No such Cache named " + cacheName);
        }
        this.enableManagement(cache, enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableManagement(Eh107Cache<?, ?> cache, boolean enabled) {
        Object object = this.cachesLock;
        synchronized (object) {
            this.checkClosed();
            if (enabled) {
                this.registerObject(cache.getManagementMBean());
            } else {
                this.unregisterObject(cache.getManagementMBean());
            }
            cache.setManagementEnabled(enabled);
        }
    }

    private void unregisterObject(Eh107MXBean bean) {
        try {
            MBEAN_SERVER.unregisterMBean(bean.getObjectName());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private void registerObject(Eh107MXBean bean) {
        try {
            LOG.info("Registering Ehcache MBean {}", (Object)bean.getObjectName());
            MBEAN_SERVER.registerMBean(bean, bean.getObjectName());
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.checkClosed();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        Eh107Cache cache = this.safeCacheRetrieval(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("No such Cache named " + cacheName);
        }
        this.enableStatistics(cache, enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableStatistics(Eh107Cache<?, ?> cache, boolean enabled) {
        Object object = this.cachesLock;
        synchronized (object) {
            this.checkClosed();
            if (enabled) {
                this.registerObject(cache.getStatisticsMBean());
            } else {
                this.unregisterObject(cache.getStatisticsMBean());
            }
            cache.setStatisticsEnabled(enabled);
        }
    }

    public boolean isClosed() {
        return this.ehCacheManager.getStatus() == Status.UNINITIALIZED;
    }

    public <T> T unwrap(Class<T> clazz) {
        return Unwrap.unwrap(clazz, this, this.ehCacheManager);
    }

    public void close() {
        this.cachingProvider.close(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeInternal() {
        Object object = this.cachesLock;
        synchronized (object) {
            try {
                Object[] objectArray = new Object[3];
                objectArray[0] = this.caches.values();
                objectArray[1] = this.caches::clear;
                objectArray[2] = this.ehCacheManager;
                CloseUtil.closeAll(objectArray);
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    void close(Eh107Cache<?, ?> cache) {
        if (this.caches.remove(cache.getName(), cache)) {
            try {
                CloseUtil.chain(() -> this.unregisterObject(cache.getManagementMBean()), () -> this.unregisterObject(cache.getStatisticsMBean()), () -> cache.closeInternal(), () -> this.ehCacheManager.removeCache(cache.getName()));
            }
            catch (Throwable t) {
                throw new CacheException(t);
            }
        }
    }
}

