/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.copy;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ehcache.impl.internal.store.copy.CopyingIterator;
import org.ehcache.impl.internal.store.copy.CopyingSpliterator;

class ImmutableCopyingCollection<T>
extends AbstractCollection<T> {
    private final Collection<T> delegate;
    private final UnaryOperator<T> copier;

    public ImmutableCopyingCollection(Collection<T> delegate, UnaryOperator<T> copier) {
        this.delegate = delegate;
        this.copier = copier;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new CopyingIterator(this.delegate.iterator(), this.copier);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.delegate.forEach(t -> action.accept((T)this.copier.apply(t)));
    }

    @Override
    public Object[] toArray() {
        return this.delegate.stream().map(this.copier).toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.delegate.stream().map(this.copier).collect(Collectors.toList()).toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public Spliterator<T> spliterator() {
        return new CopyingSpliterator(this.delegate.spliterator(), this.copier);
    }

    @Override
    public Stream<T> stream() {
        return this.delegate.stream().map(this.copier);
    }

    @Override
    public Stream<T> parallelStream() {
        return this.delegate.parallelStream().map(this.copier);
    }
}

