/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.NestedExceptionUtils;
import org.springframework.data.redis.connection.ReactiveSubscription;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.session.IndexResolver;
import org.springframework.session.MapSession;
import org.springframework.session.ReactiveFindByIndexNameSessionRepository;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.SaveMode;
import org.springframework.session.Session;
import org.springframework.session.SessionIdGenerator;
import org.springframework.session.UuidSessionIdGenerator;
import org.springframework.session.data.redis.ReactiveRedisSessionIndexer;
import org.springframework.session.data.redis.RedisSessionMapper;
import org.springframework.session.data.redis.SortedSetReactiveRedisSessionExpirationStore;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDeletedEvent;
import org.springframework.session.events.SessionExpiredEvent;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ReactiveRedisIndexedSessionRepository
implements ReactiveSessionRepository<RedisSession>,
ReactiveFindByIndexNameSessionRepository<RedisSession>,
DisposableBean,
InitializingBean {
    private static final Log logger = LogFactory.getLog(ReactiveRedisIndexedSessionRepository.class);
    public static final String DEFAULT_NAMESPACE = "spring:session";
    public static final int DEFAULT_DATABASE = 0;
    private final ReactiveRedisOperations<String, Object> sessionRedisOperations;
    private final ReactiveRedisTemplate<String, String> keyEventsOperations;
    private SessionIdGenerator sessionIdGenerator = UuidSessionIdGenerator.getInstance();
    private BiFunction<String, Map<String, Object>, Mono<MapSession>> redisSessionMapper = new RedisSessionMapperAdapter();
    private Duration defaultMaxInactiveInterval = Duration.ofSeconds(1800L);
    private SaveMode saveMode = SaveMode.ON_SET_ATTRIBUTE;
    private ApplicationEventPublisher eventPublisher = event -> {};
    private String sessionCreatedChannelPrefix;
    private String sessionDeletedChannel;
    private String sessionExpiredChannel;
    private String expiredKeyPrefix;
    private final List<Disposable> subscriptions = new ArrayList<Disposable>();
    private String namespace = "spring:session:";
    private int database = 0;
    private ReactiveRedisSessionIndexer indexer;
    private SortedSetReactiveRedisSessionExpirationStore expirationStore;
    private Duration cleanupInterval = Duration.ofSeconds(60L);
    private Clock clock = Clock.systemUTC();

    public ReactiveRedisIndexedSessionRepository(ReactiveRedisOperations<String, Object> sessionRedisOperations, ReactiveRedisTemplate<String, String> keyEventsOperations) {
        Assert.notNull(sessionRedisOperations, (String)"sessionRedisOperations cannot be null");
        Assert.notNull(keyEventsOperations, (String)"keyEventsOperations cannot be null");
        this.sessionRedisOperations = sessionRedisOperations;
        this.keyEventsOperations = keyEventsOperations;
        this.indexer = new ReactiveRedisSessionIndexer(sessionRedisOperations, this.namespace);
        this.expirationStore = new SortedSetReactiveRedisSessionExpirationStore(sessionRedisOperations, this.namespace);
        this.configureSessionChannels();
    }

    public void afterPropertiesSet() throws Exception {
        this.subscribeToRedisEvents();
        this.setupCleanupTask();
    }

    private void setupCleanupTask() {
        if (!this.cleanupInterval.isZero()) {
            Disposable cleanupExpiredSessionsTask = Flux.interval((Duration)this.cleanupInterval, (Duration)this.cleanupInterval).onBackpressureDrop(count -> logger.debug((Object)"Skipping clean-up expired sessions because the previous one is still running.")).concatMap(count -> this.cleanUpExpiredSessions()).subscribe();
            this.subscriptions.add(cleanupExpiredSessionsTask);
        }
    }

    private Flux<Void> cleanUpExpiredSessions() {
        return this.expirationStore.retrieveExpiredSessions(this.clock.instant()).flatMap(this::touch);
    }

    private Mono<Void> touch(String sessionId) {
        return this.sessionRedisOperations.hasKey((Object)this.getExpiredKey(sessionId)).then();
    }

    public void destroy() {
        for (Disposable subscription : this.subscriptions) {
            subscription.dispose();
        }
        this.subscriptions.clear();
    }

    public Mono<Map<String, RedisSession>> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        return this.indexer.getSessionIds(indexName, indexValue).flatMap(this::findById).collectMap(RedisSession::getId);
    }

    public Mono<RedisSession> createSession() {
        return Mono.fromSupplier(() -> this.sessionIdGenerator.generate()).subscribeOn(Schedulers.boundedElastic()).publishOn(Schedulers.parallel()).map(MapSession::new).doOnNext(session -> session.setMaxInactiveInterval(this.defaultMaxInactiveInterval)).map(session -> new RedisSession((MapSession)session, true));
    }

    public Mono<Void> save(RedisSession session) {
        return session.save().then(Mono.defer(() -> this.indexer.update(session))).then(Mono.defer(() -> this.expirationStore.add(session.getId(), session.getLastAccessedTime().plus(session.getMaxInactiveInterval()))));
    }

    public Mono<RedisSession> findById(String id) {
        return this.getSession(id, false);
    }

    private Mono<RedisSession> getSession(String sessionId, boolean allowExpired) {
        String sessionKey = this.getSessionKey(sessionId);
        return this.sessionRedisOperations.opsForHash().entries((Object)sessionKey).collectMap(entry -> entry.getKey().toString(), Map.Entry::getValue).filter(map -> !map.isEmpty()).flatMap(map -> this.redisSessionMapper.apply(sessionId, (Map<String, Object>)map)).filter(session -> allowExpired || !session.isExpired()).map(session -> new RedisSession((MapSession)session, false));
    }

    public Mono<Void> deleteById(String id) {
        return this.deleteAndReturn(id).then();
    }

    private Mono<RedisSession> deleteAndReturn(String id) {
        return this.getSession(id, true).flatMap(session -> this.sessionRedisOperations.delete((Object[])new String[]{this.getExpiredKey(session.getId())}).thenReturn(session)).flatMap(session -> this.sessionRedisOperations.delete((Object[])new String[]{this.getSessionKey(session.getId())}).thenReturn(session)).flatMap(session -> this.indexer.delete(session.getId()).thenReturn(session)).flatMap(session -> this.expirationStore.remove(session.getId()).thenReturn(session));
    }

    private void subscribeToRedisEvents() {
        Disposable sessionCreatedSubscription = this.sessionRedisOperations.listenToPattern(new String[]{this.getSessionCreatedChannelPrefix() + "*"}).flatMap(this::onSessionCreatedChannelMessage).subscribe();
        Disposable sessionDestroyedSubscription = this.keyEventsOperations.listenToChannel(new String[]{this.getSessionDeletedChannel(), this.getSessionExpiredChannel()}).flatMap(this::onKeyDestroyedMessage).subscribe();
        this.subscriptions.addAll(Arrays.asList(sessionCreatedSubscription, sessionDestroyedSubscription));
    }

    private Mono<Void> onSessionCreatedChannelMessage(ReactiveSubscription.Message<String, Object> message) {
        return Mono.just((Object)((String)message.getChannel())).filter(channel -> channel.startsWith(this.getSessionCreatedChannelPrefix())).map(channel -> {
            int sessionIdBeginIndex = channel.lastIndexOf(":") + 1;
            return channel.substring(sessionIdBeginIndex);
        }).flatMap(sessionId -> {
            Map entries = (Map)message.getMessage();
            return this.redisSessionMapper.apply((String)sessionId, entries);
        }).map(loaded -> {
            RedisSession session = new RedisSession((MapSession)loaded, false);
            return new SessionCreatedEvent((Object)this, (Session)session);
        }).doOnNext(this::publishEvent).then();
    }

    private Mono<Void> onKeyDestroyedMessage(ReactiveSubscription.Message<String, String> message) {
        return Mono.just((Object)((String)message.getMessage())).filter(key -> key.startsWith(this.getExpiredKeyPrefix())).map(key -> {
            int sessionIdBeginIndex = key.lastIndexOf(":") + 1;
            return key.substring(sessionIdBeginIndex);
        }).flatMap(this::deleteAndReturn).map(session -> {
            if (((String)message.getChannel()).equals(this.sessionDeletedChannel)) {
                return new SessionDeletedEvent((Object)this, (Session)session);
            }
            return new SessionExpiredEvent((Object)this, (Session)session);
        }).doOnNext(this::publishEvent).then();
    }

    private void publishEvent(Object event) {
        this.eventPublisher.publishEvent(event);
    }

    public void setDatabase(int database) {
        this.database = database;
        this.configureSessionChannels();
    }

    public void setRedisKeyNamespace(String namespace) {
        Assert.hasText((String)namespace, (String)"namespace cannot be null or empty");
        this.namespace = namespace.endsWith(":") ? namespace : namespace.trim() + ":";
        this.indexer.setNamespace(this.namespace);
        this.expirationStore.setNamespace(this.namespace);
        this.configureSessionChannels();
    }

    public void setCleanupInterval(Duration cleanupInterval) {
        Assert.notNull((Object)cleanupInterval, (String)"cleanupInterval cannot be null");
        this.cleanupInterval = cleanupInterval;
    }

    public void disableCleanupTask() {
        this.setCleanupInterval(Duration.ZERO);
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }

    public void setDefaultMaxInactiveInterval(Duration defaultMaxInactiveInterval) {
        Assert.notNull((Object)defaultMaxInactiveInterval, (String)"defaultMaxInactiveInterval must not be null");
        this.defaultMaxInactiveInterval = defaultMaxInactiveInterval;
    }

    public void setSessionIdGenerator(SessionIdGenerator sessionIdGenerator) {
        Assert.notNull((Object)sessionIdGenerator, (String)"sessionIdGenerator cannot be null");
        this.sessionIdGenerator = sessionIdGenerator;
    }

    public void setRedisSessionMapper(BiFunction<String, Map<String, Object>, Mono<MapSession>> redisSessionMapper) {
        Assert.notNull(redisSessionMapper, (String)"redisSessionMapper cannot be null");
        this.redisSessionMapper = redisSessionMapper;
    }

    public void setSaveMode(SaveMode saveMode) {
        Assert.notNull((Object)saveMode, (String)"saveMode cannot be null");
        this.saveMode = saveMode;
    }

    public ReactiveRedisOperations<String, Object> getSessionRedisOperations() {
        return this.sessionRedisOperations;
    }

    public void setEventPublisher(ApplicationEventPublisher eventPublisher) {
        Assert.notNull((Object)eventPublisher, (String)"eventPublisher cannot be null");
        this.eventPublisher = eventPublisher;
    }

    public void setIndexResolver(IndexResolver<Session> indexResolver) {
        Assert.notNull(indexResolver, (String)"indexResolver cannot be null");
        this.indexer.setIndexResolver(indexResolver);
    }

    private static String getAttributeNameWithPrefix(String attributeName) {
        return "sessionAttr:" + attributeName;
    }

    private String getSessionKey(String sessionId) {
        return this.namespace + "sessions:" + sessionId;
    }

    private String getExpiredKey(String sessionId) {
        return this.getExpiredKeyPrefix() + sessionId;
    }

    private String getExpiredKeyPrefix() {
        return this.expiredKeyPrefix;
    }

    private void configureSessionChannels() {
        this.sessionCreatedChannelPrefix = this.namespace + "event:" + this.database + ":created:";
        this.sessionDeletedChannel = "__keyevent@" + this.database + "__:del";
        this.sessionExpiredChannel = "__keyevent@" + this.database + "__:expired";
        this.expiredKeyPrefix = this.namespace + "sessions:expires:";
    }

    public String getSessionCreatedChannel(String sessionId) {
        return this.getSessionCreatedChannelPrefix() + sessionId;
    }

    public String getSessionCreatedChannelPrefix() {
        return this.sessionCreatedChannelPrefix;
    }

    public String getSessionDeletedChannel() {
        return this.sessionDeletedChannel;
    }

    public String getSessionExpiredChannel() {
        return this.sessionExpiredChannel;
    }

    private static final class RedisSessionMapperAdapter
    implements BiFunction<String, Map<String, Object>, Mono<MapSession>> {
        private final RedisSessionMapper mapper = new RedisSessionMapper();

        private RedisSessionMapperAdapter() {
        }

        @Override
        public Mono<MapSession> apply(String sessionId, Map<String, Object> map) {
            return Mono.fromSupplier(() -> this.mapper.apply(sessionId, map));
        }
    }

    public final class RedisSession
    implements Session {
        private final MapSession cached;
        private Map<String, Object> delta = new HashMap<String, Object>();
        private boolean isNew;
        private String originalSessionId;
        private Map<String, String> indexes = new HashMap<String, String>();

        public RedisSession(MapSession cached, boolean isNew) {
            this.cached = cached;
            this.isNew = isNew;
            this.originalSessionId = cached.getId();
            if (this.isNew) {
                this.delta.put("creationTime", cached.getCreationTime().toEpochMilli());
                this.delta.put("maxInactiveInterval", (int)cached.getMaxInactiveInterval().getSeconds());
                this.delta.put("lastAccessedTime", cached.getLastAccessedTime().toEpochMilli());
            }
            if (this.isNew || ReactiveRedisIndexedSessionRepository.this.saveMode == SaveMode.ALWAYS) {
                this.getAttributeNames().forEach(attributeName -> this.delta.put(ReactiveRedisIndexedSessionRepository.getAttributeNameWithPrefix(attributeName), cached.getAttribute(attributeName)));
            }
        }

        public String getId() {
            return this.cached.getId();
        }

        public String changeSessionId() {
            String newSessionId = ReactiveRedisIndexedSessionRepository.this.sessionIdGenerator.generate();
            this.cached.setId(newSessionId);
            return newSessionId;
        }

        public <T> T getAttribute(String attributeName) {
            Object attributeValue = this.cached.getAttribute(attributeName);
            if (attributeValue != null && ReactiveRedisIndexedSessionRepository.this.saveMode.equals((Object)SaveMode.ON_GET_ATTRIBUTE)) {
                this.delta.put(ReactiveRedisIndexedSessionRepository.getAttributeNameWithPrefix(attributeName), attributeValue);
            }
            return (T)attributeValue;
        }

        public Set<String> getAttributeNames() {
            return this.cached.getAttributeNames();
        }

        public void setAttribute(String attributeName, Object attributeValue) {
            this.cached.setAttribute(attributeName, attributeValue);
            this.delta.put(ReactiveRedisIndexedSessionRepository.getAttributeNameWithPrefix(attributeName), attributeValue);
        }

        public void removeAttribute(String attributeName) {
            this.cached.removeAttribute(attributeName);
            this.delta.put(ReactiveRedisIndexedSessionRepository.getAttributeNameWithPrefix(attributeName), null);
        }

        public Instant getCreationTime() {
            return this.cached.getCreationTime();
        }

        public void setLastAccessedTime(Instant lastAccessedTime) {
            this.cached.setLastAccessedTime(lastAccessedTime);
            this.delta.put("lastAccessedTime", this.getLastAccessedTime().toEpochMilli());
        }

        public Instant getLastAccessedTime() {
            return this.cached.getLastAccessedTime();
        }

        public void setMaxInactiveInterval(Duration interval) {
            this.cached.setMaxInactiveInterval(interval);
            this.delta.put("maxInactiveInterval", (int)this.getMaxInactiveInterval().getSeconds());
        }

        public Duration getMaxInactiveInterval() {
            return this.cached.getMaxInactiveInterval();
        }

        public boolean isExpired() {
            return this.cached.isExpired();
        }

        public Map<String, String> getIndexes() {
            return Collections.unmodifiableMap(this.indexes);
        }

        private boolean hasChangedSessionId() {
            return !this.getId().equals(this.originalSessionId);
        }

        private Mono<Void> save() {
            return Mono.defer(() -> this.saveChangeSessionId().then(this.saveDelta()).doOnSuccess(unused -> {
                this.isNew = false;
            }));
        }

        private Mono<Void> saveDelta() {
            Mono setTtl;
            if (this.delta.isEmpty()) {
                return Mono.empty();
            }
            String sessionKey = ReactiveRedisIndexedSessionRepository.this.getSessionKey(this.getId());
            Mono update = ReactiveRedisIndexedSessionRepository.this.sessionRedisOperations.opsForHash().putAll((Object)sessionKey, new HashMap<String, Object>(this.delta));
            String expiredKey = ReactiveRedisIndexedSessionRepository.this.getExpiredKey(this.getId());
            Mono updateExpireKey = ReactiveRedisIndexedSessionRepository.this.sessionRedisOperations.opsForValue().append((Object)expiredKey, "").hasElement();
            if (this.getMaxInactiveInterval().getSeconds() >= 0L) {
                Duration fiveMinutesFromActualExpiration = this.getMaxInactiveInterval().plus(Duration.ofMinutes(5L));
                setTtl = ReactiveRedisIndexedSessionRepository.this.sessionRedisOperations.expire((Object)sessionKey, fiveMinutesFromActualExpiration);
                updateExpireKey = updateExpireKey.flatMap(length -> ReactiveRedisIndexedSessionRepository.this.sessionRedisOperations.expire((Object)expiredKey, this.getMaxInactiveInterval()));
            } else {
                setTtl = ReactiveRedisIndexedSessionRepository.this.sessionRedisOperations.persist((Object)sessionKey);
                updateExpireKey = ReactiveRedisIndexedSessionRepository.this.sessionRedisOperations.delete((Object[])new String[]{expiredKey}).hasElement();
            }
            Mono publishCreated = Mono.empty();
            if (this.isNew) {
                String sessionCreatedChannelKey = ReactiveRedisIndexedSessionRepository.this.getSessionCreatedChannel(this.getId());
                publishCreated = ReactiveRedisIndexedSessionRepository.this.sessionRedisOperations.convertAndSend(sessionCreatedChannelKey, this.delta).then();
            }
            return update.flatMap(updated -> setTtl).then(updateExpireKey).then(publishCreated).then(Mono.fromRunnable(() -> {
                this.delta = new HashMap<String, Object>(this.delta.size());
            })).then();
        }

        private Mono<Void> saveChangeSessionId() {
            if (!this.hasChangedSessionId()) {
                return Mono.empty();
            }
            String sessionId = this.getId();
            Mono replaceSessionId = Mono.fromRunnable(() -> {
                this.originalSessionId = sessionId;
            }).then();
            if (this.isNew) {
                return Mono.from((Publisher)replaceSessionId);
            }
            String originalSessionKey = ReactiveRedisIndexedSessionRepository.this.getSessionKey(this.originalSessionId);
            String sessionKey = ReactiveRedisIndexedSessionRepository.this.getSessionKey(sessionId);
            String originalExpiredKey = ReactiveRedisIndexedSessionRepository.this.getExpiredKey(this.originalSessionId);
            String expiredKey = ReactiveRedisIndexedSessionRepository.this.getExpiredKey(sessionId);
            return this.renameKey(originalSessionKey, sessionKey).then(Mono.defer(() -> this.renameKey(originalExpiredKey, expiredKey))).then(Mono.defer(this::replaceSessionIdOnIndexes)).then(Mono.defer(() -> replaceSessionId));
        }

        private Mono<Void> replaceSessionIdOnIndexes() {
            return ReactiveRedisIndexedSessionRepository.this.indexer.delete(this.originalSessionId).then(ReactiveRedisIndexedSessionRepository.this.indexer.update(this));
        }

        private Mono<Void> renameKey(String oldKey, String newKey) {
            return ReactiveRedisIndexedSessionRepository.this.sessionRedisOperations.rename((Object)oldKey, (Object)newKey).onErrorResume(ex -> {
                String message = NestedExceptionUtils.getMostSpecificCause((Throwable)ex).getMessage();
                return StringUtils.startsWithIgnoreCase((String)message, (String)"ERR no such key");
            }, ex -> Mono.empty()).then();
        }
    }
}

