/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easyocr;

import cn.easyproject.easyocr.ImageType;
import cn.easyproject.easyocr.Type;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class ImageClean {
    private Map<String, Method> cleanMethodsCache = new HashMap<String, Method>();
    private Map<String, Object> cleanMethodsInstanceCache = new HashMap<String, Object>();
    private Map<String, Object> instanceCache = new HashMap<String, Object>();
    protected BufferedImage image;
    private int iw;
    private int ih;
    private int[] pixels;
    private Type imageType = ImageType.CAPTCHA_NORMAL;
    private double imageWidthRatio = 1.0;
    private double imageHeightRatio = 1.0;
    private int degrees = 0;
    private static int i = 0;
    private static int recursionMax = 100;

    private static boolean checkPixelRange(int r, int c, int w, int h) {
        return r >= 0 && r <= h - 1 && c >= 0 && c <= w - 1;
    }

    private static void searchAdjacentRecursion(int[][] pixelsArray, int r, int c, int w, int h) {
        if (++i > recursionMax) {
            i = 0;
            return;
        }
        boolean recursionUp = false;
        boolean recursionDown = false;
        boolean recursionLeft = false;
        boolean recursionRight = false;
        boolean recursionRightUp = false;
        boolean recursionRightDown = false;
        boolean recursionLeftUp = false;
        boolean recursionLeftDown = false;
        int rUp = r - 1;
        int cUp = c;
        int rDown = r + 1;
        int cDown = c;
        int rLeft = r;
        int cLeft = c - 1;
        int rRight = r;
        int cRight = c + 1;
        int rRightUp = r - 1;
        int cRightUp = c + 1;
        int rRightDown = r + 1;
        int cRightDown = c + 1;
        int rLeftUp = r - 1;
        int cLeftUp = c - 1;
        int rLeftDown = r + 1;
        int cLeftDown = c - 1;
        if (ImageClean.checkPixelRange(rUp, cUp, w, h) && pixelsArray[rUp][cUp] != -1) {
            pixelsArray[rUp][cUp] = -1;
            recursionUp = true;
        }
        if (ImageClean.checkPixelRange(rDown, cDown, w, h) && pixelsArray[rDown][cDown] != -1) {
            pixelsArray[rDown][cDown] = -1;
            recursionDown = true;
        }
        if (ImageClean.checkPixelRange(rLeft, cLeft, w, h) && pixelsArray[rLeft][cLeft] != -1) {
            pixelsArray[rLeft][cLeft] = -1;
            recursionLeft = true;
        }
        if (ImageClean.checkPixelRange(rRight, cRight, w, h) && pixelsArray[rRight][cRight] != -1) {
            pixelsArray[rRight][cRight] = -1;
            recursionRight = true;
        }
        if (ImageClean.checkPixelRange(rRightUp, cRightUp, w, h) && pixelsArray[rRightUp][cRightUp] != -1) {
            pixelsArray[rRightUp][cRightUp] = -1;
            recursionRightUp = true;
        }
        if (ImageClean.checkPixelRange(rRightDown, cRightDown, w, h) && pixelsArray[rRightDown][cRightDown] != -1) {
            pixelsArray[rRightDown][cRightDown] = -1;
            recursionRightDown = true;
        }
        if (ImageClean.checkPixelRange(rLeftUp, cLeftUp, w, h) && pixelsArray[rLeftUp][cLeftUp] != -1) {
            pixelsArray[rLeftUp][cLeftUp] = -1;
            recursionLeftUp = true;
        }
        if (ImageClean.checkPixelRange(rLeftDown, cLeftDown, w, h) && pixelsArray[rLeftDown][cLeftDown] != -1) {
            pixelsArray[rLeftDown][cLeftDown] = -1;
            recursionLeftDown = true;
        }
        if (recursionUp) {
            ImageClean.searchAdjacentRecursion(pixelsArray, rUp, cUp, w, h);
        }
        if (recursionDown) {
            ImageClean.searchAdjacentRecursion(pixelsArray, rDown, cDown, w, h);
        }
        if (recursionLeft) {
            ImageClean.searchAdjacentRecursion(pixelsArray, rLeft, cLeft, w, h);
        }
        if (recursionRight) {
            ImageClean.searchAdjacentRecursion(pixelsArray, rRight, cRight, w, h);
        }
        if (recursionRightUp) {
            ImageClean.searchAdjacentRecursion(pixelsArray, rRightUp, cRightUp, w, h);
        }
        if (recursionRightDown) {
            ImageClean.searchAdjacentRecursion(pixelsArray, rRightDown, cRightDown, w, h);
        }
        if (recursionLeftUp) {
            ImageClean.searchAdjacentRecursion(pixelsArray, rLeftUp, cLeftUp, w, h);
        }
        if (recursionLeftDown) {
            ImageClean.searchAdjacentRecursion(pixelsArray, rLeftDown, cLeftDown, w, h);
        }
    }

    public ImageClean() {
    }

    public ImageClean(double imageWidthRatio, double imageHeightRatio) {
        this.imageWidthRatio = imageWidthRatio;
        this.imageHeightRatio = imageHeightRatio;
    }

    public ImageClean(double imageWidthRatio, double imageHeightRatio, int degrees) {
        this.imageWidthRatio = imageWidthRatio;
        this.imageHeightRatio = imageHeightRatio;
        this.degrees = degrees;
    }

    public ImageClean(Type imageType) {
        this.imageType = imageType;
    }

    public ImageClean(Type imageType, double imageWidthRatio, double imageHeightRatio) {
        this.imageType = imageType;
        this.imageWidthRatio = imageWidthRatio;
        this.imageHeightRatio = imageHeightRatio;
    }

    public ImageClean(Type imageType, double imageWidthRatio, double imageHeightRatio, int degrees) {
        this.imageType = imageType;
        this.imageWidthRatio = imageWidthRatio;
        this.imageHeightRatio = imageHeightRatio;
        this.degrees = degrees;
    }

    public ImageClean(Type imageType, int degrees) {
        this.imageType = imageType;
        this.degrees = degrees;
    }

    public ImageClean(int degrees) {
        this.degrees = degrees;
    }

    protected BufferedImage changeBrighten() {
        BufferedImage bufferedImage = new BufferedImage(this.iw, this.ih, 1);
        bufferedImage.getGraphics().drawImage(this.image, 0, 0, null);
        RescaleOp rop = new RescaleOp(1.0f, 0.0f, null);
        this.image = rop.filter(bufferedImage, null);
        return this.image;
    }

    protected BufferedImage changeRotate(int degrees) {
        if (degrees % 360 == 0) {
            return this.image;
        }
        int w = 0;
        int h = 0;
        int x = 0;
        int y = 0;
        if ((degrees %= 360) < 0) {
            degrees = 360 + degrees;
        }
        double ang = Math.toRadians(degrees);
        if (degrees == 180 || degrees == 0 || degrees == 360) {
            w = this.iw;
            h = this.ih;
        } else if (degrees == 90 || degrees == 270) {
            w = this.ih;
            h = this.iw;
        } else {
            w = (int)((double)(this.ih / 2) * Math.cos(ang)) + this.iw;
            h = (int)((double)(this.iw / 2) * Math.sin(ang)) + this.ih;
        }
        x = w / 2 - this.iw / 2;
        y = h / 2 - this.ih / 2;
        BufferedImage rotatedImage = new BufferedImage(w, h, this.image.getType());
        Graphics2D gs = rotatedImage.createGraphics();
        gs.setBackground(Color.WHITE);
        gs.fillRect(0, 0, w, h);
        AffineTransform at = new AffineTransform();
        at.rotate(ang, w / 2, h / 2);
        at.translate(x, y);
        AffineTransformOp op = new AffineTransformOp(at, 3);
        op.filter(this.image, rotatedImage);
        this.iw = w;
        this.ih = h;
        this.image = rotatedImage;
        return this.image;
    }

    protected BufferedImage changeSacled(double imageWidthRatio, double imageHeightRatio) {
        BufferedImage imageChangeSize = null;
        if (imageWidthRatio != 1.0 || imageHeightRatio != 1.0) {
            int w = this.iw;
            int h = this.ih;
            if (imageWidthRatio != 1.0) {
                w = (int)((double)this.iw * imageWidthRatio);
            }
            if (imageHeightRatio != 1.0) {
                h = (int)((double)this.ih * imageHeightRatio);
            }
            int type = this.image.getTransparency() == 1 ? 1 : 2;
            imageChangeSize = new BufferedImage(w, h, type);
            Graphics2D g = imageChangeSize.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.drawImage(this.image, 0, 0, w, h, null);
            g.dispose();
            this.image = imageChangeSize;
        }
        return imageChangeSize;
    }

    protected BufferedImage changeToBinarization() {
        int grey = 100;
        return this.changeToBinarization(grey);
    }

    protected BufferedImage changeToBinarization(int grey) {
        PixelGrabber pg = new PixelGrabber(this.image.getSource(), 0, 0, this.iw, this.ih, this.pixels, 0, this.iw);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ColorModel cm = ColorModel.getRGBdefault();
        for (int i = 0; i < this.iw * this.ih; ++i) {
            int alpha = cm.getAlpha(this.pixels[i]);
            int red = cm.getRed(this.pixels[i]) > grey ? 255 : 0;
            int green = cm.getGreen(this.pixels[i]) > grey ? 255 : 0;
            int blue = cm.getBlue(this.pixels[i]) > grey ? 255 : 0;
            this.pixels[i] = alpha << 24 | red << 16 | green << 8 | blue;
        }
        Image tempImg = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.iw, this.ih, this.pixels, 0, this.iw));
        this.image = new BufferedImage(tempImg.getWidth(null), tempImg.getHeight(null), 4);
        this.image.createGraphics().drawImage(tempImg, 0, 0, null);
        return this.image;
    }

    protected BufferedImage changeToBlackWhiteImage() {
        int avgGrayValue = this.getAvgValue(this.iw, this.ih);
        int whitePoint = this.getWhitePoint();
        int blackPoint = this.getBlackPoint();
        for (int i = 0; i < this.ih; ++i) {
            for (int j = 0; j < this.iw; ++j) {
                Color point = new Color(this.image.getRGB(j, i));
                this.image.setRGB(j, i, point.getRed() < avgGrayValue ? blackPoint : whitePoint);
            }
        }
        return this.image;
    }

    protected BufferedImage changeToGrayByAvgColor() {
        for (int i = 0; i < this.ih; ++i) {
            for (int j = 0; j < this.iw; ++j) {
                Color point = new Color(this.image.getRGB(j, i));
                int gray = (point.getRed() + point.getGreen() + point.getBlue()) / 3;
                try {
                    this.image.setRGB(j, i, new Color(gray, gray, gray).getRGB());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.image;
    }

    protected BufferedImage changeToGrey() {
        ColorConvertOp ccp = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        this.image = ccp.filter(this.image, null);
        return this.image;
    }

    protected BufferedImage changeToMedian() {
        PixelGrabber pg = new PixelGrabber(this.image.getSource(), 0, 0, this.iw, this.ih, this.pixels, 0, this.iw);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ColorModel cm = ColorModel.getRGBdefault();
        for (int i = 1; i < this.ih - 1; ++i) {
            for (int j = 1; j < this.iw - 1; ++j) {
                int alpha = cm.getAlpha(this.pixels[i * this.iw + j]);
                int red4 = cm.getRed(this.pixels[i * this.iw + j - 1]);
                int red5 = cm.getRed(this.pixels[i * this.iw + j]);
                int red6 = cm.getRed(this.pixels[i * this.iw + j + 1]);
                int red = red4 >= red5 ? (red5 >= red6 ? red5 : (red4 >= red6 ? red6 : red4)) : (red4 > red6 ? red4 : (red5 > red6 ? red6 : red5));
                int green4 = cm.getGreen(this.pixels[i * this.iw + j - 1]);
                int green5 = cm.getGreen(this.pixels[i * this.iw + j]);
                int green6 = cm.getGreen(this.pixels[i * this.iw + j + 1]);
                int green = green4 >= green5 ? (green5 >= green6 ? green5 : (green4 >= green6 ? green6 : green4)) : (green4 > green6 ? green4 : (green5 > green6 ? green6 : green5));
                int blue4 = cm.getBlue(this.pixels[i * this.iw + j - 1]);
                int blue5 = cm.getBlue(this.pixels[i * this.iw + j]);
                int blue6 = cm.getBlue(this.pixels[i * this.iw + j + 1]);
                int blue = blue4 >= blue5 ? (blue5 >= blue6 ? blue5 : (blue4 >= blue6 ? blue6 : blue4)) : (blue4 > blue6 ? blue4 : (blue5 > blue6 ? blue6 : blue5));
                this.pixels[i * this.iw + j] = alpha << 24 | red << 16 | green << 8 | blue;
            }
        }
        Image tempImg = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.iw, this.ih, this.pixels, 0, this.iw));
        this.image = new BufferedImage(tempImg.getWidth(null), tempImg.getHeight(null), 4);
        this.image.createGraphics().drawImage(tempImg, 0, 0, null);
        return this.image;
    }

    public boolean cleanImage(File from, File to) {
        try {
            FileInputStream fis = new FileInputStream(from);
            return this.cleanImage((InputStream)fis, to);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean cleanImage(File from, File to, double imageWidthRatio, double imageHeightRatio) {
        try {
            FileInputStream fis = new FileInputStream(from);
            return this.cleanImage((InputStream)fis, to, imageWidthRatio, imageHeightRatio);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean cleanImage(File from, File to, double imageWidthRatio, double imageHeightRatio, int degrees) {
        try {
            FileInputStream fis = new FileInputStream(from);
            return this.cleanImage((InputStream)fis, to, imageWidthRatio, imageHeightRatio, degrees);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean cleanImage(File from, File to, int degrees) {
        try {
            FileInputStream fis = new FileInputStream(from);
            return this.cleanImage((InputStream)fis, to, degrees);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean cleanImage(File from, String to) {
        try {
            FileInputStream fis = new FileInputStream(from);
            File out = new File(to);
            return this.cleanImage((InputStream)fis, out);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean cleanImage(File from, String to, double imageWidthRatio, double imageHeightRatio) {
        try {
            FileInputStream fis = new FileInputStream(from);
            File out = new File(to);
            return this.cleanImage((InputStream)fis, out, imageWidthRatio, imageHeightRatio);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean cleanImage(File from, String to, double imageWidthRatio, double imageHeightRatio, int degrees) {
        try {
            FileInputStream fis = new FileInputStream(from);
            File out = new File(to);
            return this.cleanImage((InputStream)fis, out, imageWidthRatio, imageHeightRatio, degrees);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean cleanImage(File from, String to, int degrees) {
        try {
            FileInputStream fis = new FileInputStream(from);
            File out = new File(to);
            return this.cleanImage((InputStream)fis, out, degrees);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean cleanImage(InputStream from, File to) {
        return this.cleanImage(from, to, this.imageWidthRatio, this.imageHeightRatio, this.degrees);
    }

    public boolean cleanImage(InputStream from, File to, double imageWidthRatio, double imageHeightRatio) {
        return this.cleanImage(from, to, imageWidthRatio, imageHeightRatio, this.degrees);
    }

    public boolean cleanImage(InputStream from, File to, double imageWidthRatio, double imageHeightRatio, int degrees) {
        try {
            this.image = ImageIO.read(from);
            this.iw = this.image.getWidth();
            this.ih = this.image.getHeight();
            this.changeRotate(360);
            this.pixels = new int[this.iw * this.ih];
            if (this.imageType != ImageType.NONE) {
                String[] cleanMethods = this.imageType.getClass().getMethod("getCleanMethods", new Class[0]).invoke((Object)this.imageType, new Object[0]).toString().trim().split("#|,");
                Class<?> imageCleanClass = this.getClass();
                for (String cleanMethodName : cleanMethods) {
                    try {
                        cleanMethodName = cleanMethodName.trim();
                        if (cleanMethodName.endsWith("()")) {
                            cleanMethodName = cleanMethodName.replace("()", "");
                        }
                        if (cleanMethodName.equals("")) continue;
                        Method m = this.cleanMethodsCache.get(cleanMethodName);
                        if (m != null) {
                            if (m.getDeclaringClass().getName().equals("cn.easyproject.easyocr.ImageClean")) {
                                m.invoke(this.cleanMethodsInstanceCache.get(cleanMethodName), new Object[0]);
                                continue;
                            }
                            m.invoke(this.cleanMethodsInstanceCache.get(cleanMethodName), this.image, this);
                            continue;
                        }
                        Object o = this;
                        if (cleanMethodName.indexOf(".") != -1) {
                            String className = cleanMethodName.substring(0, cleanMethodName.lastIndexOf("."));
                            String methodName = cleanMethodName.substring(cleanMethodName.lastIndexOf(".") + 1);
                            Class<?> c = Class.forName(className);
                            m = className.equals("cn.easyproject.easyocr.ImageClean") ? c.getDeclaredMethod(methodName, new Class[0]) : c.getDeclaredMethod(methodName, BufferedImage.class, ImageClean.class);
                            if (this.instanceCache.get(className) != null) {
                                o = this.instanceCache.get(className);
                            } else {
                                o = c.newInstance();
                                this.instanceCache.put(className, o);
                            }
                        } else {
                            m = imageCleanClass.getDeclaredMethod(cleanMethodName, new Class[0]);
                        }
                        m.setAccessible(true);
                        if (m.getDeclaringClass().getName().equals("cn.easyproject.easyocr.ImageClean")) {
                            m.invoke(o, new Object[0]);
                        } else {
                            m.invoke(o, this.image, this);
                        }
                        this.cleanMethodsCache.put(cleanMethodName, m);
                        this.cleanMethodsInstanceCache.put(cleanMethodName, o);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.changeSacled(imageWidthRatio, imageHeightRatio);
            ImageIO.write((RenderedImage)this.image, "png", to);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        return false;
    }

    public boolean cleanImage(InputStream from, File to, int degrees) {
        return this.cleanImage(from, to, this.imageWidthRatio, this.imageHeightRatio, degrees);
    }

    public boolean cleanImage(InputStream from, String to) {
        return this.cleanImage(from, new File(to));
    }

    public boolean cleanImage(InputStream from, String to, double imageWidthRatio, double imageHeightRatio) {
        return this.cleanImage(from, new File(to), imageWidthRatio, imageHeightRatio);
    }

    public boolean cleanImage(InputStream from, String to, double imageWidthRatio, double imageHeightRatio, int degrees) {
        return this.cleanImage(from, new File(to), imageWidthRatio, imageHeightRatio, degrees);
    }

    public boolean cleanImage(InputStream from, String to, int degrees) {
        return this.cleanImage(from, new File(to), degrees);
    }

    public boolean cleanImage(String from, File to) {
        try {
            InputStream is = null;
            if (from.startsWith("http://") || from.startsWith("ftp://")) {
                URL url = new URL(from);
                is = url.openStream();
            } else {
                is = new FileInputStream(from);
            }
            return this.cleanImage(is, to);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean cleanImage(String from, File to, double imageWidthRatio, double imageHeightRatio) {
        try {
            InputStream is = null;
            if (from.startsWith("http://") || from.startsWith("ftp://")) {
                URL url = new URL(from);
                is = url.openStream();
            } else {
                is = new FileInputStream(from);
            }
            return this.cleanImage(is, to, imageWidthRatio, imageHeightRatio);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean cleanImage(String from, File to, double imageWidthRatio, double imageHeightRatio, int degrees) {
        try {
            InputStream is = null;
            if (from.startsWith("http://") || from.startsWith("ftp://")) {
                URL url = new URL(from);
                is = url.openStream();
            } else {
                is = new FileInputStream(from);
            }
            return this.cleanImage(is, to, imageWidthRatio, imageHeightRatio, degrees);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean cleanImage(String from, File to, int degrees) {
        try {
            InputStream is = null;
            if (from.startsWith("http://") || from.startsWith("ftp://")) {
                URL url = new URL(from);
                is = url.openStream();
            } else {
                is = new FileInputStream(from);
            }
            return this.cleanImage(is, to, degrees);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean cleanImage(String from, String to) {
        try {
            InputStream is = null;
            if (from.startsWith("http://") || from.startsWith("ftp://")) {
                URL url = new URL(from);
                is = url.openStream();
            } else {
                is = new FileInputStream(from);
            }
            File out = new File(to);
            return this.cleanImage(is, out);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean cleanImage(String from, String to, double imageWidthRatio, double imageHeightRatio) {
        try {
            InputStream is = null;
            if (from.startsWith("http://") || from.startsWith("ftp://")) {
                URL url = new URL(from);
                is = url.openStream();
            } else {
                is = new FileInputStream(from);
            }
            File out = new File(to);
            return this.cleanImage(is, out, imageWidthRatio, imageHeightRatio);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean cleanImage(String from, String to, double imageWidthRatio, double imageHeightRatio, int degrees) {
        try {
            InputStream is = null;
            if (from.startsWith("http://") || from.startsWith("ftp://")) {
                URL url = new URL(from);
                is = url.openStream();
            } else {
                is = new FileInputStream(from);
            }
            File out = new File(to);
            return this.cleanImage(is, out, imageWidthRatio, imageHeightRatio, degrees);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean cleanImage(String from, String to, int degrees) {
        try {
            InputStream is = null;
            if (from.startsWith("http://") || from.startsWith("ftp://")) {
                URL url = new URL(from);
                is = url.openStream();
            } else {
                is = new FileInputStream(from);
            }
            File out = new File(to);
            return this.cleanImage(is, out, degrees);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected BufferedImage jugementBlackOrWhite() {
        int j;
        int miny;
        int i;
        int[][] pixelsArray = new int[this.ih][this.iw];
        int minx = this.image.getMinX();
        for (i = miny = this.image.getMinY(); i < this.ih; ++i) {
            for (j = minx; j < this.iw; ++j) {
                pixelsArray[i][j] = this.image.getRGB(j, i);
            }
        }
        for (int r = 0; r < this.ih; ++r) {
            for (int c = 0; c < this.iw; ++c) {
                if (pixelsArray[r][c] == -1 || pixelsArray[r][c] == -16777216) continue;
                pixelsArray[r][c] = this.checkBlackOrWhite(pixelsArray, r, c, this.iw, this.ih) ? -1 : -16777216;
            }
        }
        for (i = miny; i < this.ih; ++i) {
            for (j = minx; j < this.iw; ++j) {
                this.image.setRGB(j, i, pixelsArray[i][j]);
            }
        }
        return this.image;
    }

    protected boolean checkBlackOrWhite(int[][] pixelsArray, int r, int c, int w, int h) {
        int cRight;
        int rRight;
        int cLeft;
        int rLeft;
        int cDown;
        int rDown;
        boolean flag = true;
        int white = 0;
        int black = 0;
        int rUp = r - 1;
        int cUp = c;
        if (ImageClean.checkPixelRange(rUp, cUp, w, h)) {
            if (pixelsArray[rUp][cUp] == -1) {
                ++white;
            } else if (pixelsArray[rUp][cUp] == -16777216) {
                ++black;
            }
        }
        if (ImageClean.checkPixelRange(rDown = r + 1, cDown = c, w, h)) {
            if (pixelsArray[rDown][cDown] == -1) {
                ++white;
            } else if (pixelsArray[rDown][cDown] == -16777216) {
                ++black;
            }
        }
        if (ImageClean.checkPixelRange(rLeft = r, cLeft = c - 1, w, h)) {
            if (pixelsArray[rLeft][cLeft] == -1) {
                ++white;
            } else if (pixelsArray[rLeft][cLeft] == -16777216) {
                ++black;
            }
        }
        if (ImageClean.checkPixelRange(rRight = r, cRight = c + 1, w, h)) {
            if (pixelsArray[rRight][cRight] == -1) {
                ++white;
            } else if (pixelsArray[rRight][cRight] == -16777216) {
                ++black;
            }
        }
        int rRightUp = r - 1;
        int cRightUp = c + 1;
        int rRightDown = r + 1;
        int cRightDown = c + 1;
        int rLeftUp = r - 1;
        int cLeftUp = c - 1;
        int rLeftDown = r + 1;
        int cLeftDown = c - 1;
        if (ImageClean.checkPixelRange(rRightUp, cRightUp, w, h)) {
            if (pixelsArray[rRightUp][cRightUp] == -1) {
                ++white;
            } else if (pixelsArray[rRightUp][cRightUp] == -16777216) {
                ++black;
            }
        }
        if (ImageClean.checkPixelRange(rRightDown, cRightDown, w, h)) {
            if (pixelsArray[rRightDown][cRightDown] == -1) {
                ++white;
            } else if (pixelsArray[rRightDown][cRightDown] == -16777216) {
                ++black;
            }
        }
        if (ImageClean.checkPixelRange(rLeftUp, cLeftUp, w, h)) {
            if (pixelsArray[rLeftUp][cLeftUp] == -1) {
                ++white;
            } else if (pixelsArray[rLeftUp][cLeftUp] == -16777216) {
                ++black;
            }
        }
        if (ImageClean.checkPixelRange(rLeftDown, cLeftDown, w, h)) {
            if (pixelsArray[rLeftDown][cLeftDown] == -1) {
                ++white;
            } else if (pixelsArray[rLeftDown][cLeftDown] == -16777216) {
                ++black;
            }
        }
        if (white > black) {
            flag = true;
        }
        return flag;
    }

    protected BufferedImage cleanCrossOrphan() {
        int roundCount = 1;
        return this.cleanOrphan(roundCount, true);
    }

    protected BufferedImage cleanOrphan() {
        int roundCount = 1;
        return this.cleanOrphan(roundCount, false);
    }

    protected BufferedImage cleanOrphan(int roundCount, boolean cross) {
        int j;
        int miny;
        int i;
        int[][] pixelsArray = new int[this.ih][this.iw];
        int minx = this.image.getMinX();
        for (i = miny = this.image.getMinY(); i < this.ih; ++i) {
            for (j = minx; j < this.iw; ++j) {
                pixelsArray[i][j] = this.image.getRGB(j, i);
            }
        }
        for (int r = 0; r < this.ih; ++r) {
            for (int c = 0; c < this.iw; ++c) {
                if (pixelsArray[r][c] == -1 || this.checkAround(pixelsArray, r, c, this.iw, this.ih, cross) > roundCount) continue;
                pixelsArray[r][c] = -1;
            }
        }
        for (i = miny; i < this.ih; ++i) {
            for (j = minx; j < this.iw; ++j) {
                this.image.setRGB(j, i, pixelsArray[i][j]);
            }
        }
        return this.image;
    }

    protected int checkAround(int[][] pixelsArray, int r, int c, int w, int h, boolean cross) {
        int cRight;
        int rRight;
        int cLeft;
        int rLeft;
        int cDown;
        int rDown;
        int res = 0;
        int rUp = r - 1;
        int cUp = c;
        if (ImageClean.checkPixelRange(rUp, cUp, w, h) && pixelsArray[rUp][cUp] != -1) {
            ++res;
        }
        if (ImageClean.checkPixelRange(rDown = r + 1, cDown = c, w, h) && pixelsArray[rDown][cDown] != -1) {
            ++res;
        }
        if (ImageClean.checkPixelRange(rLeft = r, cLeft = c - 1, w, h) && pixelsArray[rLeft][cLeft] != -1) {
            ++res;
        }
        if (ImageClean.checkPixelRange(rRight = r, cRight = c + 1, w, h) && pixelsArray[rRight][cRight] != -1) {
            ++res;
        }
        if (!cross) {
            int rRightUp = r - 1;
            int cRightUp = c + 1;
            int rRightDown = r + 1;
            int cRightDown = c + 1;
            int rLeftUp = r - 1;
            int cLeftUp = c - 1;
            int rLeftDown = r + 1;
            int cLeftDown = c - 1;
            if (ImageClean.checkPixelRange(rRightUp, cRightUp, w, h) && pixelsArray[rRightUp][cRightUp] != -1) {
                ++res;
            }
            if (ImageClean.checkPixelRange(rRightDown, cRightDown, w, h) && pixelsArray[rRightDown][cRightDown] != -1) {
                ++res;
            }
            if (ImageClean.checkPixelRange(rLeftUp, cLeftUp, w, h) && pixelsArray[rLeftUp][cLeftUp] != -1) {
                ++res;
            }
            if (ImageClean.checkPixelRange(rLeftDown, cLeftDown, w, h) && pixelsArray[rLeftDown][cLeftDown] != -1) {
                ++res;
            }
        }
        return res;
    }

    protected BufferedImage cleanPadding() {
        int j;
        int miny;
        int i;
        int[][] pixelsArray = new int[this.ih][this.iw];
        int minx = this.image.getMinX();
        for (i = miny = this.image.getMinY(); i < this.ih; ++i) {
            for (j = minx; j < this.iw; ++j) {
                pixelsArray[i][j] = this.image.getRGB(j, i);
            }
        }
        block2: for (int r = 0; r < this.ih; ++r) {
            for (int c = 0; c < this.iw; ++c) {
                if (pixelsArray[r][c] == -1) continue;
                pixelsArray[r][c] = -1;
                ImageClean.searchAdjacentRecursion(pixelsArray, r, c, this.iw, this.ih);
                break block2;
            }
        }
        for (i = miny; i < this.ih; ++i) {
            for (j = minx; j < this.iw; ++j) {
                this.image.setRGB(j, i, pixelsArray[i][j]);
            }
        }
        return this.image;
    }

    protected BufferedImage convertImageToGrayscale() {
        BufferedImage tmp = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 10);
        Graphics2D g2 = tmp.createGraphics();
        g2.drawImage((Image)this.image, 0, 0, null);
        g2.dispose();
        this.image = tmp;
        return this.image;
    }

    protected int getAvgValue(int width, int height) {
        int total = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                Color point = new Color(this.image.getRGB(j, i));
                total += (point.getRed() + point.getGreen() + point.getBlue()) / 3;
            }
        }
        return total / (width * height);
    }

    protected int getBlackPoint() {
        return new Color(0, 0, 0).getRGB() & 0xFFFFFFFF;
    }

    protected BufferedImage getBlur() {
        float[] data = new float[]{0.1111f, 0.1111f, 0.1111f, 0.1111f, 0.1111f, 0.1111f, 0.1111f, 0.1111f, 0.1111f};
        ConvolveOp cop = new ConvolveOp(new Kernel(3, 3, data));
        this.image = cop.filter(this.image, null);
        return this.image;
    }

    public int getDegrees() {
        return this.degrees;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public double getImageHeightRatio() {
        return this.imageHeightRatio;
    }

    public Type getImageType() {
        return this.imageType;
    }

    public double getImageWidthRatio() {
        return this.imageWidthRatio;
    }

    protected BufferedImage getSharpen() {
        float[] data = new float[]{0.0f, -0.75f, 0.0f, -0.75f, 4.0f, -0.75f, 0.0f, -0.75f, 0.0f};
        ConvolveOp cop = new ConvolveOp(new Kernel(3, 3, data));
        this.image = cop.filter(this.image, null);
        return this.image;
    }

    protected int getWhitePoint() {
        return new Color(255, 255, 255).getRGB() & 0xFFFFFFFF;
    }

    protected void reverseGray() {
        for (int y = 0; y < this.ih; ++y) {
            for (int x = 0; x < this.iw; ++x) {
                int rgb = this.image.getRGB(x, y);
                Color color = new Color(rgb);
                Color newColor = new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
                this.image.setRGB(x, y, newColor.getRGB());
            }
        }
    }

    public void setDegrees(int degrees) {
        this.degrees = degrees;
    }

    public void setImageHeightRatio(double imageHeightRatio) {
        this.imageHeightRatio = imageHeightRatio;
    }

    public void setImageRatio(double imageWidthRatio, double imageHeightRatio) {
        this.imageWidthRatio = imageWidthRatio;
        this.imageHeightRatio = imageHeightRatio;
    }

    public void setImageType(Type imageType) {
        this.imageType = imageType;
    }

    public void setImageWidthRatio(double imageWidthRatio) {
        this.imageWidthRatio = imageWidthRatio;
    }
}

