/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf;

import com.baidu.bjf.remoting.protobuf.Codec;
import com.baidu.bjf.remoting.protobuf.FieldType;
import com.baidu.bjf.remoting.protobuf.IDLProxyObject;
import com.baidu.bjf.remoting.protobuf.ProtobufProxy;
import com.baidu.bjf.remoting.protobuf.annotation.Protobuf;
import com.baidu.bjf.remoting.protobuf.utils.CodePrinter;
import com.baidu.bjf.remoting.protobuf.utils.JDKCompilerHelper;
import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import com.squareup.protoparser.EnumType;
import com.squareup.protoparser.MessageType;
import com.squareup.protoparser.Option;
import com.squareup.protoparser.ProtoFile;
import com.squareup.protoparser.ProtoSchemaParser;
import com.squareup.protoparser.Type;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProtobufIDLProxy {
    private static final char PACKAGE_SPLIT_CHAR = '.';
    private static final String PACKAGE_SPLIT = ".";
    private static final String UTF_8 = "utf-8";
    private static final String JAVA_OUTER_CLASSNAME_OPTION = "java_outer_classname";
    private static final String JAVA_PACKAGE_OPTION = "java_package";
    private static final String CODE_END = ";\n";
    public static final String DEFAULT_FILE_NAME = "jprotobuf_autogenerate";
    private static final Map<String, FieldType> typeMapping = new HashMap<String, FieldType>();
    private static final Map<String, String> fieldTypeMapping;
    private static final String DEFAULT_SUFFIX_CLASSNAME = "JProtoBufProtoClass";

    public static IDLProxyObject createSingle(String data) {
        return ProtobufIDLProxy.createSingle(data, false);
    }

    public static IDLProxyObject createSingle(String data, boolean debug) {
        return ProtobufIDLProxy.createSingle(data, debug, null);
    }

    public static IDLProxyObject createSingle(String data, boolean debug, File path) {
        ProtoFile protoFile = ProtoSchemaParser.parse((String)DEFAULT_FILE_NAME, (String)data);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        try {
            Map<String, IDLProxyObject> map = ProtobufIDLProxy.doCreate(protoFile, false, debug, path, false, null, cds);
            return map.entrySet().iterator().next().getValue();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static IDLProxyObject createSingle(InputStream is) throws IOException {
        return ProtobufIDLProxy.createSingle(is, false);
    }

    public static IDLProxyObject createSingle(InputStream is, boolean debug) throws IOException {
        return ProtobufIDLProxy.createSingle(is, debug, null);
    }

    public static IDLProxyObject createSingle(InputStream is, boolean debug, File path) throws IOException {
        ProtoFile protoFile = ProtoSchemaParser.parseUtf8((String)DEFAULT_FILE_NAME, (InputStream)is);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        Map<String, IDLProxyObject> map = ProtobufIDLProxy.doCreate(protoFile, false, debug, path, false, null, cds);
        return map.entrySet().iterator().next().getValue();
    }

    public static IDLProxyObject createSingle(Reader reader) throws IOException {
        return ProtobufIDLProxy.createSingle(reader, false);
    }

    public static IDLProxyObject createSingle(Reader reader, boolean debug) throws IOException {
        return ProtobufIDLProxy.createSingle(reader, debug, null);
    }

    public static IDLProxyObject createSingle(Reader reader, boolean debug, File path) throws IOException {
        ProtoFile protoFile = ProtoSchemaParser.parse((String)DEFAULT_FILE_NAME, (Reader)reader);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        Map<String, IDLProxyObject> map = ProtobufIDLProxy.doCreate(protoFile, false, debug, path, false, null, cds);
        return map.entrySet().iterator().next().getValue();
    }

    public static Map<String, IDLProxyObject> create(String data) {
        return ProtobufIDLProxy.create(data, false);
    }

    public static Map<String, IDLProxyObject> create(String data, boolean debug) {
        return ProtobufIDLProxy.create(data, debug, null);
    }

    public static Map<String, IDLProxyObject> create(String data, boolean debug, File path) {
        ProtoFile protoFile = ProtoSchemaParser.parse((String)DEFAULT_FILE_NAME, (String)data);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        try {
            return ProtobufIDLProxy.doCreate(protoFile, true, debug, path, false, null, cds);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Map<String, IDLProxyObject> create(InputStream is) throws IOException {
        return ProtobufIDLProxy.create(is, false);
    }

    public static Map<String, IDLProxyObject> create(InputStream is, boolean debug) throws IOException {
        return ProtobufIDLProxy.create(is, debug, null);
    }

    public static Map<String, IDLProxyObject> create(InputStream is, boolean debug, File path) throws IOException {
        ProtoFile protoFile = ProtoSchemaParser.parseUtf8((String)DEFAULT_FILE_NAME, (InputStream)is);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        return ProtobufIDLProxy.doCreate(protoFile, true, debug, path, false, null, cds);
    }

    public static Map<String, IDLProxyObject> create(Reader reader) throws IOException {
        return ProtobufIDLProxy.create(reader, false);
    }

    public static Map<String, IDLProxyObject> create(Reader reader, boolean debug) throws IOException {
        return ProtobufIDLProxy.create(reader, debug, null);
    }

    public static Map<String, IDLProxyObject> create(Reader reader, boolean debug, File path) throws IOException {
        ProtoFile protoFile = ProtoSchemaParser.parse((String)DEFAULT_FILE_NAME, (Reader)reader);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        return ProtobufIDLProxy.doCreate(protoFile, true, debug, path, false, null, cds);
    }

    public static Map<String, IDLProxyObject> create(File file) throws IOException {
        return ProtobufIDLProxy.create(file, false);
    }

    public static Map<String, IDLProxyObject> create(File file, boolean debug) throws IOException {
        return ProtobufIDLProxy.create(file, debug, null);
    }

    public static Map<String, IDLProxyObject> create(File file, boolean debug, File path) throws IOException {
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        return ProtobufIDLProxy.create(file, debug, path, cds, new HashSet<String>());
    }

    public static Map<String, IDLProxyObject> create(File file, boolean debug, File path, List<CodeDependent> cds, Set<String> compiledClass) throws IOException {
        return ProtobufIDLProxy.doCreatePro(file, true, debug, path, false, null, cds, compiledClass);
    }

    public static void generateSource(String data, File sourceOutputPath) {
        ProtoFile protoFile = ProtoSchemaParser.parse((String)DEFAULT_FILE_NAME, (String)data);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        try {
            ProtobufIDLProxy.doCreate(protoFile, true, false, null, true, sourceOutputPath, cds);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void generateSource(InputStream is, File sourceOutputPath) throws IOException {
        ProtoFile protoFile = ProtoSchemaParser.parseUtf8((String)DEFAULT_FILE_NAME, (InputStream)is);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        ProtobufIDLProxy.doCreate(protoFile, true, false, null, true, sourceOutputPath, cds);
    }

    public static void generateSource(Reader reader, File sourceOutputPath) throws IOException {
        ProtoFile protoFile = ProtoSchemaParser.parse((String)DEFAULT_FILE_NAME, (Reader)reader);
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        ProtobufIDLProxy.doCreate(protoFile, true, false, null, true, sourceOutputPath, cds);
    }

    public static void generateSource(File file, File sourceOutputPath) throws IOException {
        ArrayList<CodeDependent> cds = new ArrayList<CodeDependent>();
        ProtobufIDLProxy.generateSource(file, sourceOutputPath, cds, new HashSet<String>());
    }

    public static void generateSource(File file, File sourceOutputPath, List<CodeDependent> cds, Set<String> compiledClass) throws IOException {
        ProtobufIDLProxy.doCreatePro(file, true, false, null, true, sourceOutputPath, cds, compiledClass);
    }

    private static Map<String, IDLProxyObject> doCreatePro(List<ProtoFile> protoFiles, boolean multi, boolean debug, File path, boolean generateSouceOnly, File sourceOutputDir, List<CodeDependent> cds, Set<String> compiledClass) throws IOException {
        int count = 0;
        HashMap<String, EnumType> enumTypes = new HashMap<String, EnumType>();
        HashMap<String, String> packageMapping = new HashMap<String, String>();
        HashSet<String> packages = new HashSet<String>();
        for (ProtoFile protoFile : protoFiles) {
            List types = protoFile.getTypes();
            if (types == null || types.isEmpty()) continue;
            String packageName = protoFile.getPackageName();
            List options = protoFile.getOptions();
            if (options != null) {
                for (Option option : options) {
                    if (!option.getName().equals(JAVA_PACKAGE_OPTION)) continue;
                    packageName = option.getValue().toString();
                }
            }
            packages.add(packageName);
            for (Type type : types) {
                packageMapping.put(type.getName(), packageName);
                packageMapping.put(type.getFullyQualifiedName(), packageName);
                if (type instanceof MessageType) {
                    ++count;
                    continue;
                }
                enumTypes.put(type.getName(), (EnumType)type);
                enumTypes.put(type.getFullyQualifiedName(), (EnumType)type);
            }
        }
        if (!multi && count != 1) {
            throw new RuntimeException("Only one message defined allowed in '.proto' IDL");
        }
        List<Class<?>> clsList = ProtobufIDLProxy.createEnumClasses(enumTypes, packageMapping, generateSouceOnly, sourceOutputDir, compiledClass);
        for (ProtoFile protoFile : protoFiles) {
            List<Class<?>> messageClasses = ProtobufIDLProxy.createMessageClass(protoFile, multi, debug, generateSouceOnly, sourceOutputDir, cds, compiledClass, new HashSet<String>(enumTypes.keySet()), packages);
            clsList.addAll(messageClasses);
        }
        HashMap<String, IDLProxyObject> ret = new HashMap<String, IDLProxyObject>();
        for (Class<?> cls : clsList) {
            Object newInstance;
            try {
                if (Enum.class.isAssignableFrom(cls)) continue;
                newInstance = cls.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            Codec<?> codec = ProtobufProxy.create(cls, debug, path);
            IDLProxyObject idlProxyObject = new IDLProxyObject(codec, newInstance, cls);
            String name = cls.getSimpleName();
            if (name.endsWith(DEFAULT_SUFFIX_CLASSNAME)) {
                name = name.substring(0, name.length() - DEFAULT_SUFFIX_CLASSNAME.length());
            }
            ret.put(name, idlProxyObject);
        }
        return ret;
    }

    private static Map<String, IDLProxyObject> doCreatePro(File file, boolean multi, boolean debug, File path, boolean generateSouceOnly, File sourceOutputDir, List<CodeDependent> cds, Set<String> compiledClass) throws IOException {
        ProtobufIDLProxy.checkDirectory(generateSouceOnly, sourceOutputDir);
        List<ProtoFile> protoFiles = ProtobufIDLProxy.findRelateProtoFiles(file, new HashSet<String>());
        return ProtobufIDLProxy.doCreatePro(protoFiles, multi, debug, path, generateSouceOnly, sourceOutputDir, cds, compiledClass);
    }

    private static List<Class<?>> createMessageClass(ProtoFile protoFile, boolean multi, boolean debug, boolean generateSouceOnly, File sourceOutputDir, List<CodeDependent> cds, Set<String> compiledClass, Set<String> enumNames, Set<String> packages) {
        CodeDependent codeDependent;
        List types = protoFile.getTypes();
        if (types == null || types.isEmpty()) {
            throw new RuntimeException("No message defined in '.proto' IDL");
        }
        int count = 0;
        for (Type next : types) {
            if (next instanceof EnumType) continue;
            ++count;
        }
        if (!multi && count != 1) {
            throw new RuntimeException("Only one message defined allowed in '.proto' IDL");
        }
        ArrayList ret = new ArrayList(types.size());
        ArrayList<MessageType> messageTypes = new ArrayList<MessageType>();
        for (Type type : types) {
            Class checkClass = ProtobufIDLProxy.checkClass(protoFile, type);
            if (checkClass != null) {
                ret.add(checkClass);
                continue;
            }
            if (!(type instanceof MessageType)) continue;
            messageTypes.add((MessageType)type);
        }
        for (MessageType mt : messageTypes) {
            CodeDependent cd = ProtobufIDLProxy.createCodeByType(protoFile, mt, enumNames, true, new ArrayList<Type>(), cds, packages);
            if (cd.isDepndency()) {
                cds.add(cd);
                continue;
            }
            cds.add(0, cd);
        }
        ArrayList<CodeDependent> copiedCds = new ArrayList<CodeDependent>(cds);
        while ((codeDependent = ProtobufIDLProxy.hasDependency(copiedCds, compiledClass)) != null) {
            if (debug) {
                CodePrinter.printCode(codeDependent.code, "generate jprotobuf code");
            }
            if (!generateSouceOnly) {
                Class<?> newClass = JDKCompilerHelper.getJdkCompiler().compile(codeDependent.getClassName(), codeDependent.code, ProtobufIDLProxy.class.getClassLoader(), null, -1L);
                ret.add(newClass);
                continue;
            }
            ProtobufIDLProxy.writeSourceCode(codeDependent, sourceOutputDir);
        }
        return ret;
    }

    private static List<Class<?>> createEnumClasses(Map<String, EnumType> enumTypes, Map<String, String> packageMapping, boolean generateSouceOnly, File sourceOutputDir, Set<String> compiledClass) {
        ArrayList ret = new ArrayList();
        HashSet<String> enumNames = new HashSet<String>();
        Collection<EnumType> enums = enumTypes.values();
        for (EnumType enumType : enums) {
            String name = enumType.getName();
            if (enumNames.contains(name)) continue;
            enumNames.add(name);
            String packageName = packageMapping.get(name);
            Class cls = ProtobufIDLProxy.checkClass(packageName, (Type)enumType);
            if (cls != null) {
                ret.add(cls);
                continue;
            }
            CodeDependent codeDependent = ProtobufIDLProxy.createCodeByType(enumType, true, packageName);
            compiledClass.add(codeDependent.name);
            compiledClass.add(packageName + '.' + codeDependent.name);
            if (!generateSouceOnly) {
                Class<?> newClass = JDKCompilerHelper.getJdkCompiler().compile(codeDependent.getClassName(), codeDependent.code, ProtobufIDLProxy.class.getClassLoader(), null, -1L);
                ret.add(newClass);
                continue;
            }
            ProtobufIDLProxy.writeSourceCode(codeDependent, sourceOutputDir);
        }
        return ret;
    }

    protected static void checkDirectory(boolean generateSouceOnly, File sourceOutputDir) {
        if (generateSouceOnly) {
            if (sourceOutputDir == null) {
                throw new RuntimeException("param 'sourceOutputDir' is null.");
            }
            if (!sourceOutputDir.isDirectory()) {
                throw new RuntimeException("param 'sourceOutputDir' should be a exist file directory.");
            }
        }
    }

    private static List<ProtoFile> findRelateProtoFiles(File file, Set<String> dependencyNames) throws IOException {
        LinkedList<ProtoFile> protoFiles = new LinkedList<ProtoFile>();
        ProtoFile protoFile = ProtoSchemaParser.parse((File)file);
        protoFiles.addFirst(protoFile);
        String parent = file.getParent();
        List dependencies = protoFile.getDependencies();
        if (dependencies != null && !dependencies.isEmpty()) {
            for (String fn : dependencies) {
                if (dependencyNames.contains(fn)) continue;
                File dependencyFile = new File(parent, fn);
                protoFiles.addAll(ProtobufIDLProxy.findRelateProtoFiles(dependencyFile, dependencyNames));
            }
        }
        return protoFiles;
    }

    private static Map<String, IDLProxyObject> doCreate(ProtoFile protoFile, boolean multi, boolean debug, File path, boolean generateSouceOnly, File sourceOutputDir, List<CodeDependent> cds) throws IOException {
        return ProtobufIDLProxy.doCreatePro(Arrays.asList(protoFile), multi, debug, path, generateSouceOnly, sourceOutputDir, cds, new HashSet<String>());
    }

    private static Set<String> getPackages(List<CodeDependent> cds) {
        HashSet<String> ret = new HashSet<String>();
        if (cds == null) {
            return ret;
        }
        for (CodeDependent cd : cds) {
            ret.add(cd.pkg);
        }
        return ret;
    }

    private static void writeSourceCode(CodeDependent cd, File sourceOutputDir) {
        if (cd.pkg == null) {
            cd.pkg = "";
        }
        String dir = sourceOutputDir + File.separator + cd.pkg.replace('.', File.separatorChar);
        File f = new File(dir);
        f.mkdirs();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(f, cd.name + ".java"));
            fos.write(cd.code.getBytes(UTF_8));
            fos.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        }
    }

    private static CodeDependent hasDependency(List<CodeDependent> cds, Set<String> compiledClass) {
        if (cds.isEmpty()) {
            return null;
        }
        Iterator<CodeDependent> iterator = cds.iterator();
        while (iterator.hasNext()) {
            CodeDependent next = iterator.next();
            compiledClass.addAll(next.subClasses);
            if (!next.isDepndency()) {
                compiledClass.add(next.name);
                compiledClass.add(next.pkg + '.' + next.name);
                iterator.remove();
                return next;
            }
            Set dependencies = next.dependencies;
            if (!compiledClass.containsAll(dependencies)) continue;
            compiledClass.add(next.name);
            compiledClass.add(next.pkg + '.' + next.name);
            iterator.remove();
            return next;
        }
        HashSet<String> guessLoadedClass = new HashSet<String>(compiledClass);
        if (!cds.isEmpty()) {
            for (CodeDependent codeDependent : cds) {
                guessLoadedClass.add(codeDependent.name);
            }
            for (CodeDependent next : cds) {
                if (!next.isDepndency() || guessLoadedClass.containsAll(next.dependencies)) continue;
                for (String dependClass : next.dependencies) {
                    if (guessLoadedClass.contains(dependClass)) continue;
                    throw new RuntimeException("Message '" + StringUtils.removeEnd(next.name, DEFAULT_SUFFIX_CLASSNAME) + "' depend on message '" + dependClass.replace(DEFAULT_SUFFIX_CLASSNAME, "") + "' is missed");
                }
            }
        }
        return null;
    }

    private static CodeDependent createCodeByType(EnumType type, boolean topLevelClass, String packageName) {
        CodeDependent cd = new CodeDependent();
        String defaultClsName = type.getName();
        String simpleName = ProtobufIDLProxy.getProxyClassName(defaultClsName);
        StringBuilder code = new StringBuilder();
        if (topLevelClass) {
            if (!StringUtils.isEmpty(packageName)) {
                code.append("package ").append(packageName).append(CODE_END);
                code.append("\n");
            }
            code.append("import com.baidu.bjf.remoting.protobuf.EnumReadable;\n");
        }
        if (topLevelClass) {
            code.append("public enum ");
        } else {
            code.append("public static enum ");
        }
        code.append(simpleName).append(" implements EnumReadable {\n");
        Iterator iter = type.getValues().iterator();
        while (iter.hasNext()) {
            EnumType.Value value = (EnumType.Value)iter.next();
            String name = value.getName();
            int tag = value.getTag();
            code.append(name).append("(").append(tag).append(")");
            if (iter.hasNext()) {
                code.append(",");
                continue;
            }
            code.append(CODE_END);
        }
        code.append("private final int value;\n");
        code.append(simpleName).append("(int value) { this.value = value;  }\n");
        code.append("public int value() { return value; }\n");
        code.append("}\n");
        cd.name = simpleName;
        cd.pkg = packageName;
        cd.code = code.toString();
        return cd;
    }

    private static CodeDependent createCodeByType(ProtoFile protoFile, MessageType type, Set<String> enumNames, boolean topLevelClass, List<Type> parentNestedTypes, List<CodeDependent> cds, Set<String> packages) {
        CodeDependent cd = new CodeDependent();
        String packageName = protoFile.getPackageName();
        String defaultClsName = type.getName();
        List options = protoFile.getOptions();
        if (options != null) {
            for (Option option : options) {
                if (!option.getName().equals(JAVA_PACKAGE_OPTION)) continue;
                packageName = option.getValue().toString();
            }
        }
        String simpleName = ProtobufIDLProxy.getProxyClassName(defaultClsName);
        StringBuilder code = new StringBuilder();
        if (topLevelClass) {
            if (!StringUtils.isEmpty(packageName)) {
                code.append("package ").append(packageName).append(CODE_END);
                code.append("\n");
            }
            code.append("import com.baidu.bjf.remoting.protobuf.FieldType;\n");
            code.append("import com.baidu.bjf.remoting.protobuf.EnumReadable;\n");
            code.append("import com.baidu.bjf.remoting.protobuf.annotation.Protobuf;\n");
        }
        String clsName = topLevelClass ? "public class " : "public static class ";
        code.append(clsName).append(simpleName).append(" {\n");
        List fields = type.getFields();
        List<Type> nestedTypes = ProtobufIDLProxy.fetchAllNestedTypes(type, true);
        ArrayList<Type> checkNestedTypes = new ArrayList<Type>(nestedTypes);
        for (Type t : nestedTypes) {
            if (t instanceof EnumType) {
                enumNames.add(t.getName());
                enumNames.add(t.getFullyQualifiedName());
                if (StringUtils.isEmpty(packageName)) continue;
                enumNames.add(StringUtils.removeStart(t.getFullyQualifiedName(), packageName + PACKAGE_SPLIT));
                continue;
            }
            checkNestedTypes.add(t);
        }
        checkNestedTypes.addAll(parentNestedTypes);
        String suffix = "";
        for (MessageType.Field field : fields) {
            ProtobufIDLProxy.generateProtobufDefinedForField(code, field, enumNames);
            FieldType fType = typeMapping.get(field.getType());
            String javaType = "";
            if (fType == null) {
                String jType = field.getType();
                javaType = ProtobufIDLProxy.getProxyClassName(jType, packages);
                if (!ProtobufIDLProxy.isNestedTypeDependency(field.getType(), checkNestedTypes)) {
                    cd.addDependency(javaType);
                }
            } else {
                javaType = fType.getJavaType();
                suffix = fType.getSuffix();
            }
            if (MessageType.Label.REPEATED == field.getLabel()) {
                javaType = List.class.getName() + "<" + javaType + ">";
            }
            code.append("public ").append(javaType);
            code.append(" ").append(field.getName());
            Option defaultOption = Option.findByName((List)field.getOptions(), (String)"default");
            if (defaultOption != null) {
                code.append("=");
                Object defaultValue = defaultOption.getValue();
                if (defaultValue instanceof EnumType.Value) {
                    EnumType.Value enumValue = (EnumType.Value)defaultValue;
                    code.append(javaType).append('.').append(enumValue.getName());
                } else if (defaultValue instanceof String) {
                    code.append("\"").append(defaultValue).append("\"");
                } else {
                    code.append(String.valueOf(defaultValue) + suffix);
                }
            }
            code.append(CODE_END);
        }
        if (nestedTypes != null) {
            for (Type t : nestedTypes) {
                CodeDependent nestedCd;
                String fqname = t.getFullyQualifiedName();
                if (!StringUtils.isEmpty(packageName)) {
                    fqname = StringUtils.removeStart(t.getFullyQualifiedName(), packageName + '.');
                }
                String subClsName = ProtobufIDLProxy.getProxyClassName(fqname);
                if (t instanceof EnumType) {
                    nestedCd = ProtobufIDLProxy.createCodeByType((EnumType)t, false, packageName);
                    enumNames.add(t.getName());
                } else {
                    nestedCd = ProtobufIDLProxy.createCodeByType(protoFile, (MessageType)t, enumNames, false, checkNestedTypes, cds, ProtobufIDLProxy.getPackages(cds));
                }
                nestedCd.addSubClass(subClsName);
                nestedCd.addSubClass(packageName + '.' + subClsName);
                code.append(nestedCd.code);
                cd.dependencies.addAll(nestedCd.dependencies);
                cd.subClasses.addAll(nestedCd.subClasses);
            }
        }
        code.append("}\n");
        cd.name = simpleName;
        cd.pkg = packageName;
        cd.code = code.toString();
        cd.dependencies.remove(cd.name);
        if (!parentNestedTypes.isEmpty()) {
            for (Type t : checkNestedTypes) {
                Iterator iterator = cd.dependencies.iterator();
                while (iterator.hasNext()) {
                    String dependName = ((String)iterator.next()).replaceAll(DEFAULT_SUFFIX_CLASSNAME, "");
                    if (!t.getFullyQualifiedName().endsWith(dependName)) continue;
                    iterator.remove();
                }
            }
        }
        return cd;
    }

    private static List<Type> fetchAllNestedTypes(MessageType type, boolean all) {
        ArrayList<Type> ret = new ArrayList<Type>();
        List nestedTypes = type.getNestedTypes();
        ret.addAll(nestedTypes);
        if (all) {
            for (Type t : nestedTypes) {
                if (!(t instanceof MessageType)) continue;
                List<Type> subNestedTypes = ProtobufIDLProxy.fetchAllNestedTypes((MessageType)t, true);
                ret.addAll(subNestedTypes);
            }
        }
        return ret;
    }

    private static boolean isNestedTypeDependency(String type, List<Type> nestedTypes) {
        if (nestedTypes == null) {
            return false;
        }
        for (Type t : nestedTypes) {
            if (!type.equals(t.getName())) continue;
            return true;
        }
        return false;
    }

    private static void generateProtobufDefinedForField(StringBuilder code, MessageType.Field field, Set<String> enumNames) {
        code.append("@").append(Protobuf.class.getSimpleName()).append("(");
        String fieldType = fieldTypeMapping.get(field.getType());
        if (fieldType == null) {
            fieldType = enumNames.contains(field.getType()) ? "FieldType.ENUM" : "FieldType.OBJECT";
        }
        code.append("fieldType=").append(fieldType);
        code.append(", order=").append(field.getTag());
        if (MessageType.Label.OPTIONAL == field.getLabel()) {
            code.append(", required=false");
        } else if (MessageType.Label.REQUIRED == field.getLabel()) {
            code.append(", required=true");
        }
        code.append(")\n");
    }

    private static Class checkClass(String packageName, Type type) {
        String simpleName = ProtobufIDLProxy.getProxyClassName(type.getName());
        String className = packageName + '.' + simpleName;
        Class<?> c = null;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            c = null;
        }
        return c;
    }

    private static Class checkClass(ProtoFile protoFile, Type type) {
        String packageName = protoFile.getPackageName();
        String defaultClsName = type.getName();
        List options = protoFile.getOptions();
        if (options != null) {
            for (Option option : options) {
                if (option.getName().equals(JAVA_PACKAGE_OPTION)) {
                    packageName = option.getValue().toString();
                    continue;
                }
                if (!option.getName().equals(JAVA_OUTER_CLASSNAME_OPTION)) continue;
                defaultClsName = option.getValue().toString();
            }
        }
        String simpleName = ProtobufIDLProxy.getProxyClassName(defaultClsName);
        String className = packageName + '.' + simpleName;
        Class<?> c = null;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            c = null;
        }
        return c;
    }

    private static String getProxyClassName(String name) {
        Set<String> emptyPkgs = Collections.emptySet();
        return ProtobufIDLProxy.getProxyClassName(name, emptyPkgs);
    }

    private static String getProxyClassName(String name, Set<String> pkgs) {
        String ret = "";
        if (name.indexOf(46) != -1) {
            String[] split = name.split("\\.");
            boolean classFound = false;
            for (String string : split) {
                if (pkgs.contains(string) && !classFound) {
                    ret = ret + string + '.';
                    continue;
                }
                classFound = true;
                ret = ret + ProtobufIDLProxy.getProxyClassName(string) + '.';
            }
            ret = StringUtils.removeEnd(ret, PACKAGE_SPLIT);
        } else {
            ret = name + DEFAULT_SUFFIX_CLASSNAME;
        }
        return ret;
    }

    static {
        typeMapping.put("double", FieldType.DOUBLE);
        typeMapping.put("float", FieldType.FLOAT);
        typeMapping.put("int64", FieldType.INT64);
        typeMapping.put("uint64", FieldType.UINT64);
        typeMapping.put("int32", FieldType.INT32);
        typeMapping.put("fixed64", FieldType.FIXED64);
        typeMapping.put("fixed32", FieldType.FIXED32);
        typeMapping.put("bool", FieldType.BOOL);
        typeMapping.put("string", FieldType.STRING);
        typeMapping.put("bytes", FieldType.BYTES);
        typeMapping.put("uint32", FieldType.UINT32);
        typeMapping.put("sfixed32", FieldType.SFIXED32);
        typeMapping.put("sfixed64", FieldType.SFIXED64);
        typeMapping.put("sint64", FieldType.SINT64);
        typeMapping.put("sint32", FieldType.SINT32);
        fieldTypeMapping = new HashMap<String, String>();
        fieldTypeMapping.put("double", "FieldType.DOUBLE");
        fieldTypeMapping.put("float", "FieldType.FLOAT");
        fieldTypeMapping.put("int64", "FieldType.INT64");
        fieldTypeMapping.put("uint64", "FieldType.UINT64");
        fieldTypeMapping.put("int32", "FieldType.INT32");
        fieldTypeMapping.put("fixed64", "FieldType.FIXED64");
        fieldTypeMapping.put("fixed32", "FieldType.FIXED32");
        fieldTypeMapping.put("bool", "FieldType.BOOL");
        fieldTypeMapping.put("string", "FieldType.STRING");
        fieldTypeMapping.put("bytes", "FieldType.BYTES");
        fieldTypeMapping.put("uint32", "FieldType.UINT32");
        fieldTypeMapping.put("sfixed32", "FieldType.SFIXED32");
        fieldTypeMapping.put("sfixed64", "FieldType.SFIXED64");
        fieldTypeMapping.put("sint64", "FieldType.SINT64");
        fieldTypeMapping.put("sint32", "FieldType.SINT32");
        fieldTypeMapping.put("enum", "FieldType.ENUM");
    }

    private static class CodeDependent {
        private String name;
        private String pkg;
        private Set<String> dependencies = new HashSet<String>();
        private String code;
        private Set<String> subClasses = new HashSet<String>();

        private CodeDependent() {
        }

        private boolean isDepndency() {
            return !this.dependencies.isEmpty();
        }

        private void addSubClass(String name) {
            this.subClasses.add(name);
        }

        private void addDependency(String name) {
            System.out.println(name);
            this.dependencies.add(name);
        }

        public String getClassName() {
            if (StringUtils.isEmpty(this.pkg)) {
                return this.name;
            }
            return this.pkg + '.' + this.name;
        }
    }
}

