/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.utils;

import com.baidu.bjf.remoting.protobuf.utils.StringUtils;
import java.io.File;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ClassHelper {
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String PACKAGE_SEPARATOR = ".";
    public static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[L";
    private static final Map<String, Class<?>> PRIMIIIVE_TYPE_NAME_MAP = new HashMap(16);
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_TYPE_MAP = new HashMap(8);

    public static String getInternalName(String clsName) {
        if (clsName == null) {
            return null;
        }
        return clsName.replace('$', '.');
    }

    public static long getLastModifyTime(Class<?> cls) {
        if (cls == null) {
            return -1L;
        }
        String clsName = cls.getName().replace('.', '/') + ".class";
        ClassLoader classLoader = cls.getClassLoader();
        if (classLoader == null) {
            return -1L;
        }
        URL resource = classLoader.getResource(clsName);
        if (resource != null) {
            return new File(resource.getFile()).lastModified();
        }
        return -1L;
    }

    public static Class<?> forNameWithThreadContextClassLoader(String name) throws ClassNotFoundException {
        return ClassHelper.forName(name, Thread.currentThread().getContextClassLoader());
    }

    public static Class<?> forNameWithCallerClassLoader(String name, Class<?> caller) throws ClassNotFoundException {
        return ClassHelper.forName(name, caller.getClassLoader());
    }

    public static ClassLoader getCallerClassLoader(Class<?> caller) {
        return caller.getClassLoader();
    }

    public static ClassLoader getClassLoader(Class<?> cls) {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = cls.getClassLoader();
        }
        return cl;
    }

    public static ClassLoader getClassLoader() {
        return ClassHelper.getClassLoader(ClassHelper.class);
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        return ClassHelper.forName(name, ClassHelper.getClassLoader());
    }

    public static Class<?> forName(String name, ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        Class<?> clazz = ClassHelper.resolvePrimitiveClassName(name);
        if (clazz != null) {
            return clazz;
        }
        if (name.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
            Class<?> elementClass = ClassHelper.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        int internalArrayMarker = name.indexOf(INTERNAL_ARRAY_PREFIX);
        if (internalArrayMarker != -1 && name.endsWith(";")) {
            String elementClassName = null;
            if (internalArrayMarker == 0) {
                elementClassName = name.substring(INTERNAL_ARRAY_PREFIX.length(), name.length() - 1);
            } else if (name.startsWith("[")) {
                elementClassName = name.substring(1);
            }
            Class<?> elementClass = ClassHelper.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        ClassLoader classLoaderToUse = classLoader;
        if (classLoaderToUse == null) {
            classLoaderToUse = ClassHelper.getClassLoader();
        }
        return classLoaderToUse.loadClass(name);
    }

    public static Class<?> resolvePrimitiveClassName(String name) {
        Class<?> result = null;
        if (name != null && name.length() <= 8) {
            result = PRIMIIIVE_TYPE_NAME_MAP.get(name);
        }
        return result;
    }

    public static String toShortString(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getSimpleName() + "@" + System.identityHashCode(obj);
    }

    public static String getClassName(Class<?> cls) {
        if (cls.isMemberClass()) {
            String name = cls.getName();
            name = StringUtils.substringAfterLast(name, PACKAGE_SEPARATOR);
            return name;
        }
        return cls.getSimpleName();
    }

    public static String getPackage(Class<?> cls) {
        Package pkg = cls.getPackage();
        if (pkg == null) {
            String fullName = cls.getName();
            int index = fullName.lastIndexOf(46);
            if (index != -1) {
                return fullName.substring(0, index);
            }
            return "";
        }
        return pkg.getName();
    }

    public static boolean hasDefaultConstructor(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        try {
            cls.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e2) {
            return false;
        }
        catch (SecurityException e2) {
            throw new IllegalArgumentException(e2.getMessage(), e2);
        }
        return true;
    }

    public static String getFullClassName(Class<?> cls) {
        return ClassHelper.getPackage(cls) + PACKAGE_SEPARATOR + ClassHelper.getClassName(cls);
    }

    static {
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Byte.class, Byte.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Character.class, Character.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Double.class, Double.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Float.class, Float.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Integer.class, Integer.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Long.class, Long.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Short.class, Short.TYPE);
        HashSet<Class> primitiveTypeNames = new HashSet<Class>(16);
        primitiveTypeNames.addAll(PRIMITIVE_WRAPPER_TYPE_MAP.values());
        primitiveTypeNames.addAll(Arrays.asList(boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class));
        for (Class primitiveClass : primitiveTypeNames) {
            PRIMIIIVE_TYPE_NAME_MAP.put(primitiveClass.getName(), primitiveClass);
        }
    }
}

