/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.utils;

import com.baidu.bjf.remoting.protobuf.utils.ClassHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FieldUtils {
    private static final Map<String, String> PRIMITIVE_TYPE_MAPPING = new HashMap<String, String>();
    private static final Logger LOGGER;

    public static String getUnboxedFieldname(String name, String primitiveType) {
        if (PRIMITIVE_TYPE_MAPPING.containsKey(primitiveType)) {
            return PRIMITIVE_TYPE_MAPPING.get(primitiveType) + ".valueOf(" + name + ")";
        }
        return name;
    }

    public static String getInBoxedFieldname(String name, String primitiveType) {
        if (PRIMITIVE_TYPE_MAPPING.containsValue(primitiveType)) {
            return primitiveType + ".valueOf(" + name + ")";
        }
        return name;
    }

    public static String toObjectType(String primitiveType) {
        if (PRIMITIVE_TYPE_MAPPING.containsKey(primitiveType)) {
            return PRIMITIVE_TYPE_MAPPING.get(primitiveType);
        }
        return ClassHelper.getInternalName(primitiveType);
    }

    public static Object getField(Object t, String name) {
        Field field = FieldUtils.findField(t.getClass(), name);
        if (field == null) {
            return null;
        }
        field.setAccessible(true);
        try {
            return field.get(t);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, e.getMessage(), e);
            return null;
        }
    }

    public static void setField(Object t, String name, Object value) {
        Field field = FieldUtils.findField(t.getClass(), name);
        if (field == null) {
            return;
        }
        field.setAccessible(true);
        try {
            field.set(t, value);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, e.getMessage(), e);
        }
    }

    public static void setField(Object t, String name, int value) {
        FieldUtils.setField(t, name, (Object)value);
    }

    public static void setField(Object t, String name, short value) {
        FieldUtils.setField(t, name, (Object)value);
    }

    public static void setField(Object t, String name, double value) {
        FieldUtils.setField(t, name, (Object)value);
    }

    public static void setField(Object t, String name, float value) {
        FieldUtils.setField(t, name, Float.valueOf(value));
    }

    public static void setField(Object t, String name, byte value) {
        FieldUtils.setField(t, name, (Object)value);
    }

    public static void setField(Object t, String name, char value) {
        FieldUtils.setField(t, name, Character.valueOf(value));
    }

    public static void setField(Object t, String name, long value) {
        FieldUtils.setField(t, name, (Object)value);
    }

    public static void setField(Object t, String name, boolean value) {
        FieldUtils.setField(t, name, (Object)value);
    }

    public static void addList(List list, Object value) {
        if (list != null) {
            list.add(value);
        }
    }

    public static void addList(List list, int value) {
        FieldUtils.addList(list, (Object)value);
    }

    public static void addList(List list, short value) {
        FieldUtils.addList(list, (Object)value);
    }

    public static void addList(List list, double value) {
        FieldUtils.addList(list, (Object)value);
    }

    public static void addList(List list, float value) {
        FieldUtils.addList(list, Float.valueOf(value));
    }

    public static void addList(List list, byte value) {
        FieldUtils.addList(list, (Object)value);
    }

    public static void addList(List list, char value) {
        FieldUtils.addList(list, Character.valueOf(value));
    }

    public static void addList(List list, long value) {
        FieldUtils.addList(list, (Object)value);
    }

    public static void addList(List list, boolean value) {
        FieldUtils.addList(list, (Object)value);
    }

    public static Field findField(Class clazz, String name) {
        return FieldUtils.findField(clazz, name, null);
    }

    public static Field findField(Class clazz, String name, Class type) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (name == null && type == null) {
            throw new IllegalArgumentException("Either name or type of the field must be specified");
        }
        for (Class searchType = clazz; !Object.class.equals((Object)searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields = searchType.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    public static List<Field> findMatchedFields(Class targetClass, Class ann) {
        ArrayList<Field> ret = new ArrayList<Field>();
        if (targetClass == null) {
            return ret;
        }
        do {
            Field[] fields = targetClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Object protobuf = fields[i].getAnnotation(ann);
                if (protobuf == null) continue;
                ret.add(fields[i]);
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return ret;
    }

    static {
        PRIMITIVE_TYPE_MAPPING.put(Integer.TYPE.getSimpleName(), Integer.class.getSimpleName());
        PRIMITIVE_TYPE_MAPPING.put(Long.TYPE.getSimpleName(), Long.class.getSimpleName());
        PRIMITIVE_TYPE_MAPPING.put(Short.TYPE.getSimpleName(), Short.class.getSimpleName());
        PRIMITIVE_TYPE_MAPPING.put(Boolean.TYPE.getSimpleName(), Boolean.class.getSimpleName());
        PRIMITIVE_TYPE_MAPPING.put(Double.TYPE.getSimpleName(), Double.class.getSimpleName());
        PRIMITIVE_TYPE_MAPPING.put(Float.TYPE.getSimpleName(), Float.class.getSimpleName());
        PRIMITIVE_TYPE_MAPPING.put(Character.TYPE.getSimpleName(), Character.class.getSimpleName());
        PRIMITIVE_TYPE_MAPPING.put(Byte.TYPE.getSimpleName(), Byte.class.getSimpleName());
        LOGGER = Logger.getLogger(FieldUtils.class.getName());
    }
}

