/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bjf.remoting.protobuf.utils.compiler;

import com.baidu.bjf.remoting.protobuf.utils.ClassHelper;
import com.baidu.bjf.remoting.protobuf.utils.compiler.Compiler;
import java.io.OutputStream;

public abstract class CacheableJdkCompiler
implements Compiler {
    protected Compiler compiler;

    public CacheableJdkCompiler(Compiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public Class<?> compile(String className, String code, ClassLoader classLoader, OutputStream os, long timestamp) {
        Class<?> cls = null;
        try {
            cls = ClassHelper.forName(className, classLoader);
        }
        catch (ClassNotFoundException e) {
        }
        catch (LinkageError e) {
            // empty catch block
        }
        if (cls != null) {
            return cls;
        }
        byte[] bytes = this.cached(className, timestamp);
        if (bytes != null) {
            LoadableClassLoader loadableClassLoader = new LoadableClassLoader(classLoader);
            loadableClassLoader.defineNewClass(className, bytes, 0, bytes.length);
            try {
                return loadableClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        cls = this.compiler.compile(className, code, classLoader, os, timestamp);
        this.cache(className, this.compiler.loadBytes(className), timestamp);
        return cls;
    }

    protected abstract byte[] cached(String var1, long var2);

    protected abstract void cache(String var1, byte[] var2, long var3);

    protected static class LoadableClassLoader
    extends ClassLoader {
        protected LoadableClassLoader(ClassLoader parent) {
            super(parent);
        }

        public void defineNewClass(String name, byte[] b, int off, int len) {
            this.defineClass(name, b, off, len);
        }
    }
}

