/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.util.ArrayList;
import java.util.Set;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.util.MultiValueMap;

public class ExtraDataEntryNameMap {
    private final MultiValueMap<String, String> nameMap = new MultiValueMap();

    public void clear() {
        this.nameMap.clear();
    }

    public void clearExtraClasses() {
        for (String dataEntryKey : this.nameMap.keySet()) {
            for (String dataEntryValue : new ArrayList(this.nameMap.get((Object)dataEntryKey))) {
                if (!dataEntryValue.endsWith(".class")) continue;
                this.nameMap.remove((Object)dataEntryKey, (Object)dataEntryValue);
            }
        }
    }

    public void addExtraDataEntry(String extraDataEntryName) {
        this.nameMap.put(null, (Object)extraDataEntryName);
    }

    public void addExtraClass(String extraDataEntryName) {
        this.addExtraDataEntry(this.getClassDataEntryName(extraDataEntryName));
    }

    public void addExtraDataEntry(String keyDataEntryName, String extraDataEntryName) {
        this.nameMap.put((Object)keyDataEntryName, (Object)extraDataEntryName);
    }

    public void addExtraDataEntryToClass(String keyClassName, String extraDataEntryName) {
        this.addExtraDataEntry(this.getClassDataEntryName(keyClassName), extraDataEntryName);
    }

    public void addExtraClassToClass(Clazz keyClass, Clazz extraClass) {
        this.addExtraDataEntry(this.getClassDataEntryName(keyClass), this.getClassDataEntryName(extraClass));
    }

    public void addExtraClassToClass(Clazz keyClass, Class extraClass) {
        this.addExtraDataEntry(this.getClassDataEntryName(keyClass), this.getClassDataEntryName(extraClass));
    }

    public void addExtraClassToClass(Clazz keyClass, String extraClassName) {
        this.addExtraDataEntry(this.getClassDataEntryName(keyClass), this.getClassDataEntryName(extraClassName));
    }

    public void addExtraClassToClass(String keyClassName, Class extraClass) {
        this.addExtraDataEntry(this.getClassDataEntryName(keyClassName), this.getClassDataEntryName(extraClass));
    }

    public void addExtraClassToClass(String keyClassName, String extraClassName) {
        this.addExtraDataEntry(this.getClassDataEntryName(keyClassName), this.getClassDataEntryName(extraClassName));
    }

    public Set<String> getKeyDataEntryNames() {
        return this.nameMap.keySet();
    }

    public Set<String> getAllExtraDataEntryNames() {
        return this.nameMap.getValues();
    }

    public Set<String> getDefaultExtraDataEntryNames() {
        return this.nameMap.get(null);
    }

    public Set<String> getExtraDataEntryNames(String keyDataEntryName) {
        return this.nameMap.get((Object)keyDataEntryName);
    }

    private String getClassDataEntryName(Clazz clazz) {
        return clazz.getName() + ".class";
    }

    private String getClassDataEntryName(Class clazz) {
        return ClassUtil.internalClassName((String)clazz.getName()) + ".class";
    }

    public String getClassDataEntryName(String className) {
        return className + ".class";
    }
}

