/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.util.Objects;
import org.beetl.sql.clazz.kit.BeetlSQLException;

public class SqlId {
    protected String namespace;
    protected String id;
    protected Type type = Type.general;
    protected ManagedType managedType = ManagedType.resource;
    transient int hashCode = 0;
    transient String sqlId;

    protected SqlId() {
    }

    protected SqlId(String namespace, String id) {
        this.namespace = namespace;
        this.id = id;
        this.id = this.inferType(id);
    }

    protected SqlId(String sqlId) {
        this.sqlId = sqlId;
        String[] array = this.parseId(sqlId);
        this.namespace = array[0];
        String temp = array[1];
        this.id = this.inferType(temp);
    }

    public static SqlId of(String namespace, String id) {
        return new SqlId(namespace, id);
    }

    public static SqlId of(String sqlId) {
        return new SqlId(sqlId);
    }

    protected String inferType(String temp) {
        if (temp.endsWith("$page")) {
            this.type = Type.page;
            return temp.substring(0, temp.length() - 5);
        }
        if (temp.endsWith("$count")) {
            this.type = Type.count;
            return temp.substring(0, temp.length() - 6);
        }
        if (temp.endsWith("$range")) {
            this.type = Type.range;
            return temp.substring(0, temp.length() - 6);
        }
        if (temp.endsWith("$view")) {
            this.type = Type.view;
            return temp.substring(0, temp.length() - 5);
        }
        this.type = Type.general;
        return temp;
    }

    public SqlId toPage() {
        SqlId pageSqlId = this.clone();
        pageSqlId.type = Type.page;
        return pageSqlId;
    }

    public SqlId toCount() {
        SqlId pageSqlId = this.clone();
        pageSqlId.type = Type.count;
        return pageSqlId;
    }

    public SqlId toRange() {
        SqlId rangeSqlId = this.clone();
        rangeSqlId.type = Type.range;
        return rangeSqlId;
    }

    public SqlId toView(Class viewType) {
        SqlId viewSqlId = this.clone();
        viewSqlId.type = Type.view;
        viewSqlId.namespace = viewSqlId.namespace + "#" + viewType.getSimpleName();
        return viewSqlId;
    }

    public boolean isPage() {
        return this.type == Type.page;
    }

    public boolean isSql() {
        return this.managedType == ManagedType.sql || this.managedType == ManagedType.template;
    }

    protected SqlId clone() {
        SqlId clone = new SqlId();
        clone.namespace = this.namespace;
        clone.id = this.id;
        clone.type = this.type;
        clone.managedType = this.managedType;
        return clone;
    }

    public SqlId sibling(String id) {
        SqlId newSqlId = new SqlId(this.namespace, id);
        return newSqlId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getId() {
        return this.id;
    }

    protected String[] parseId(String id) {
        int index = id.lastIndexOf(46);
        if (index == -1) {
            throw new BeetlSQLException(99, "sqlId \u683c\u5f0f\u662fnamespace.sql");
        }
        return new String[]{id.substring(0, index), id.substring(index + 1)};
    }

    public String toString() {
        if (this.type == Type.general) {
            return this.namespace + "." + this.id;
        }
        return this.namespace + "." + this.id + "$" + (Object)((Object)this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlId sqlId = (SqlId)o;
        return this.namespace.equals(sqlId.namespace) && this.id.equals(sqlId.id) && this.type == sqlId.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.namespace, this.id, this.type});
    }

    static enum ManagedType {
        resource,
        auto,
        template,
        sql;

    }

    static enum Type {
        general,
        page,
        range,
        count,
        view;

    }
}

