/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.concat;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import org.beetl.sql.annotation.entity.View;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.core.concat.ConcatBuilder;
import org.beetl.sql.core.concat.ConcatContext;
import org.beetl.sql.core.concat.SelectColNode;
import org.beetl.sql.core.concat.WhereNode;

public class Select
extends WhereNode {
    String mainTable;
    SelectColNode colNode;
    boolean isAll = false;

    public Select(ConcatContext ctx) {
        super(ctx);
    }

    public Select col(String name) {
        this.checkCol();
        this.colNode.col(name);
        return this;
    }

    public Select cols(String ... names) {
        this.checkCol();
        for (String name : names) {
            this.colNode.col(name);
        }
        return this;
    }

    public Select all() {
        this.checkCol();
        this.colNode.all();
        return this;
    }

    public Select all(Class pojoClass, Class viewType) {
        this.checkCol();
        try {
            PropertyDescriptor[] propertyDescriptors = BeanKit.propertyDescriptors((Class)pojoClass);
            HashSet cols = new HashSet();
            for (PropertyDescriptor ps : propertyDescriptors) {
                View view = (View)BeanKit.getAnnotation((Class)pojoClass, (String)ps.getName(), View.class);
                if (view == null || !BeanKit.containViewType((Class[])view.value(), (Class)viewType)) continue;
                this.colNode.col(this.ctx.nc.getColName(pojoClass, ps.getName()));
            }
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public Select from(Class target) {
        this.mainTable = this.ctx.nc.getTableName(target);
        this.mainTable = this.ctx.keyWordHandler.getTable(this.mainTable);
        return this;
    }

    public Select from(String table) {
        this.mainTable = this.ctx.keyWordHandler.getTable(table);
        return this;
    }

    public Select count() {
        this.checkCol();
        this.colNode.count();
        return this;
    }

    protected void checkCol() {
        if (this.colNode == null) {
            this.colNode = new SelectColNode();
        }
    }

    @Override
    public void toSql(ConcatBuilder sb) {
        sb.append("select");
        if (this.isAll) {
            sb.append("*");
        } else {
            this.colNode.toSql(sb);
        }
        sb.append("from").append(this.mainTable);
        super.toSql(sb);
    }

    public String toSql() {
        ConcatBuilder sb = this.ctx.concatBuilder;
        this.toSql(sb);
        return sb.toString();
    }
}

