/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.engine;

import java.io.Reader;
import org.beetl.core.Resource;
import org.beetl.core.ResourceLoader;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.engine.NoneBlockStringReader;
import org.beetl.sql.core.engine.StringSqlTemplateLoader;
import org.beetl.sql.core.loader.SQLFileVersion;
import org.beetl.sql.core.loader.SQLLoader;

public class SqlTemplateResource
extends Resource<SqlId> {
    SQLFileVersion sqlFileVersion = null;

    public SqlTemplateResource(SqlId id, ResourceLoader loader) {
        super((Object)id, loader);
    }

    public Reader openReader() {
        SQLSource newResource = this.getSQLLoader().loadSQL((SqlId)this.id);
        this.sqlFileVersion = newResource.getVersion();
        return new NoneBlockStringReader(newResource.getTemplate());
    }

    public boolean isModified() {
        if (this.sqlFileVersion == null) {
            return true;
        }
        SQLSource newResource = this.getSQLLoader().querySQL((SqlId)this.id);
        boolean isModified = newResource.getVersion().isModified(this.sqlFileVersion);
        return isModified;
    }

    public int getLine() {
        SQLSource newResource = this.getSQLLoader().querySQL((SqlId)this.id);
        return newResource.line;
    }

    protected SQLLoader getSQLLoader() {
        StringSqlTemplateLoader l = (StringSqlTemplateLoader)this.resourceLoader;
        SQLLoader sqlLoader = l.getSqlLLoader();
        return sqlLoader;
    }
}

