/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapping;

import java.lang.annotation.Annotation;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.function.Consumer;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.BeetlSQLException;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.mapping.BeanProcessor;
import org.beetl.sql.core.mapping.RowMapper;

public class StreamData<T> {
    ResultSet rs;
    ExecuteContext ctx;
    Class<T> clazz;
    BeanProcessor beanProcessor = null;
    protected boolean done = false;
    protected Type mappingType = null;
    RowMapper rowMapper;
    Annotation config;

    public StreamData(ResultSet rs, ExecuteContext ctx, Class<T> clazz) {
        this.rs = rs;
        this.ctx = ctx;
        this.clazz = clazz;
        this.config4stream(rs);
        this.mappingType = Map.class.isAssignableFrom(clazz) ? Type.MAP : (BeanKit.isBaseDataType(clazz) ? Type.BASE : Type.POJO);
    }

    public void setRowMapper(RowMapper rowMapper, Annotation config) {
        this.rowMapper = rowMapper;
        this.config = config;
    }

    public void foreach(Consumer<T> consumer) {
        if (this.done) {
            throw new IllegalStateException("\u904d\u5386\u5df2\u7ecf\u7ed3\u675f");
        }
        Object t = null;
        this.done = true;
        while (true) {
            T t2 = this.next();
            t = t2;
            if (t2 == null) break;
            consumer.accept(t);
        }
    }

    protected void config4stream(ResultSet rs) {
        this.ctx.sqlManager.getDbStyle().streamConfig(rs);
    }

    public T next() {
        try {
            SQLManager sqlManager = this.ctx.sqlManager;
            if (!sqlManager.getDs().isTransaction()) {
                throw new UnsupportedOperationException("Stream\u67e5\u8be2\u53ea\u5141\u8bb8\u5728\u4e8b\u7269\u73af\u5883\u91cc\u6267\u884c");
            }
            if (this.beanProcessor == null) {
                this.beanProcessor = this.ctx.sqlManager.getDefaultBeanProcessors();
            }
            if (this.rs.next()) {
                Map<String, Object> t = null;
                t = this.mappingType == Type.POJO ? (Map<String, Object>)this.beanProcessor.toBean(this.ctx, this.rs, this.clazz) : (this.mappingType == Type.BASE ? this.beanProcessor.toBaseType(this.ctx, this.clazz, this.rs) : this.beanProcessor.toMap(this.ctx, this.clazz, this.rs));
                return (T)t;
            }
            return null;
        }
        catch (SQLException exe) {
            throw new BeetlSQLException(99, exe.getMessage(), (Throwable)exe);
        }
    }

    static enum Type {
        POJO,
        BASE,
        MAP;

    }
}

