/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapping.type;

import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.beetl.sql.clazz.kit.HexUtil;
import org.beetl.sql.clazz.kit.LobKit;
import org.beetl.sql.core.mapping.type.JavaSqlTypeHandler;
import org.beetl.sql.core.mapping.type.ReadTypeParameter;
import org.beetl.sql.core.mapping.type.WriteTypeParameter;

public class StringTypeHandler
extends JavaSqlTypeHandler {
    @Override
    public Object getValue(ReadTypeParameter typePara) throws SQLException {
        ResultSet rs = typePara.rs;
        int index = typePara.index;
        if (typePara.dbName.equals("oracle")) {
            int type = typePara.meta.getColumnType(index);
            switch (type) {
                case 2005: {
                    Clob clob = rs.getClob(index);
                    if (clob == null) {
                        return null;
                    }
                    Reader r = clob.getCharacterStream();
                    return LobKit.getString((Reader)r);
                }
                case 2011: {
                    NClob nclob = rs.getNClob(index);
                    if (nclob == null) {
                        return null;
                    }
                    Reader r = nclob.getCharacterStream();
                    return LobKit.getString((Reader)r);
                }
            }
            return rs.getString(index);
        }
        if (typePara.dbName.equals("dameng")) {
            int type = typePara.meta.getColumnType(index);
            switch (type) {
                case 2004: {
                    String s = rs.getString(index);
                    if (s != null) {
                        try {
                            return new String(HexUtil.decodeHex((String)s), "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                            break;
                        }
                    }
                    return s;
                }
            }
            return rs.getString(index);
        }
        return rs.getString(index);
    }

    @Override
    public void setParameter(WriteTypeParameter writeTypeParameter, Object obj) throws SQLException {
        writeTypeParameter.getPs().setString(writeTypeParameter.getIndex(), (String)obj);
    }

    @Override
    public int jdbcType() {
        return 12;
    }
}

