/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.resolver.resource;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.util.StreamUtil;
import com.itextpdf.styledxmlparser.exceptions.ReadingByteLimitException;
import com.itextpdf.styledxmlparser.resolver.resource.IResourceRetriever;
import com.itextpdf.styledxmlparser.resolver.resource.LimitedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceRetriever
implements IResourceRetriever {
    private static final Logger logger = LoggerFactory.getLogger(DefaultResourceRetriever.class);
    private long resourceSizeByteLimit = Long.MAX_VALUE;

    public long getResourceSizeByteLimit() {
        return this.resourceSizeByteLimit;
    }

    public IResourceRetriever setResourceSizeByteLimit(long resourceSizeByteLimit) {
        this.resourceSizeByteLimit = resourceSizeByteLimit;
        return this;
    }

    @Override
    public InputStream getInputStreamByUrl(URL url) throws IOException {
        if (!this.urlFilter(url)) {
            logger.warn(MessageFormatUtil.format((String)"Resource with given URL ({0}) was filtered out.", (Object[])new Object[]{url}));
            return null;
        }
        return new LimitedInputStream(url.openStream(), this.resourceSizeByteLimit);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getByteArrayByUrl(URL url) throws IOException {
        try (InputStream stream = this.getInputStreamByUrl(url);){
            if (stream == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray = StreamUtil.inputStreamToArray((InputStream)stream);
            return byArray;
        }
        catch (ReadingByteLimitException ex) {
            logger.warn(MessageFormatUtil.format((String)"Unable to retrieve resource with given URL ({0}) and resource size byte limit ({1}).", (Object[])new Object[]{url, this.resourceSizeByteLimit}));
            return null;
        }
    }

    protected boolean urlFilter(URL url) {
        return true;
    }
}

